/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.model.IEntityModel;
import cerent.cms.model.IModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.SvlanCircuit;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Observable;
import java.util.Observer;

public class SvlanCircuitDataSource
extends AbstractRowDataSource
implements Observer {
    private static final SDebug db = new SDebug("SvlanCircuitDataSource");
    private HashSet<SvlanCircuit> circuits = new HashSet();
    private NetCircuitManager ncm = NetCircuitManager.instance();
    private IModel uiModel = null;
    private HashMap<SvlanCircuit, Integer> circuitsMap = new HashMap();
    private int networkViewLayer;
    private boolean isVisible = false;
    private boolean isDisposed = false;

    public SvlanCircuitDataSource(IModel iModel) {
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        this.uiModel = iModel;
        String string = "";
        string = iModel == null ? "Network" : (iModel instanceof INodeModel ? ((INodeModel)iModel).getName() : iModel.getNodeModel().getName() + "_" + iModel.toString());
        this.ncm.addObserver(this);
    }

    public synchronized void dispose() {
        if (db.on()) {
            db.println("dispose()");
        }
        this.isDisposed = true;
        this.ncm.deleteObserver(this);
        this.uiModel = null;
    }

    protected HashSet<SvlanCircuit> getCircuitsWithinScope() {
        HashSet<SvlanCircuit> hashSet = new HashSet<SvlanCircuit>();
        if (this.networkViewLayer != 2) {
            if (this.uiModel instanceof INodeModel) {
                hashSet = this.ncm.getSvlanCircuits((INodeModel)this.uiModel);
            } else if (this.uiModel instanceof IModuleModel) {
                IModuleModel iModuleModel = (IModuleModel)this.uiModel;
                hashSet = this.ncm.getSvlanCircuits(iModuleModel.getConnectionsList());
            } else if (this.uiModel instanceof IEntityModel) {
                IEntityModel iEntityModel = (IEntityModel)this.uiModel;
                hashSet = this.ncm.getSvlanCircuits(iEntityModel.getNodeModel(), iEntityModel.getShelfId());
            } else {
                hashSet = this.ncm.getSvlanCircuits();
            }
        }
        return hashSet;
    }

    public void setNetworkViewLayerFilter(int n) {
        if (db.on()) {
            db.println("setNetworkViewLayerFilter");
        }
        this.networkViewLayer = n;
        this.updateAllCircuits();
    }

    public synchronized void setCircuitScope(IModel iModel) {
        if (db.on()) {
            db.println("setCircuitScope");
        }
        if (iModel instanceof NetworkModel) {
            iModel = null;
        }
        if (this.uiModel != iModel) {
            this.uiModel = iModel;
        }
        this.updateAllCircuits();
    }

    public synchronized void updateAllCircuits() {
        this.circuits = this.getCircuitsWithinScope();
        if (db.on()) {
            db.println("updateAllCircuits: circuit in scope " + this.circuits.size());
        }
        for (SvlanCircuit object : this.circuitsMap.keySet()) {
            object.deleteObserver(this);
        }
        this.circuitsMap.clear();
        int n = 0;
        for (SvlanCircuit svlanCircuit : this.circuits) {
            this.circuitsMap.put(svlanCircuit, new Integer(n));
            svlanCircuit.addObserver(this);
            ++n;
        }
        this.fireDataSourceChanged();
    }

    public Object getObjectAtRow(int n) {
        try {
            return new ArrayList<SvlanCircuit>(this.circuits).get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return null;
        }
    }

    public int getRowCount() {
        return this.circuits.size();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof INetCircuit) {
            INetCircuit iNetCircuit = (INetCircuit)((Object)observable);
            if (db.on()) {
                db.println("update ckt=" + iNetCircuit.getCircuitName());
            }
            if (iNetCircuit.isCircuitRefValid()) {
                this.updateChangedCircuits(iNetCircuit);
            }
        } else {
            if (db.on()) {
                db.println("update: change from NCM added or deleted circuit");
            }
            this.updateAllCircuits();
        }
    }

    private void updateChangedCircuits(INetCircuit iNetCircuit) {
        if (db.on()) {
            db.println("updateChangedCircuits started");
        }
        Integer n = null;
        n = this.circuitsMap.get(iNetCircuit);
        if (n != null) {
            this.fireBulkRowUpdated(n, iNetCircuit, iNetCircuit);
        }
        this.fireBulkUpdateView();
        if (db.on()) {
            db.println("updateChangedCircuits done");
        }
    }
}

