/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.circuits;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.util.SDebug;
import cerent.util.gui.row.AbstractRowDataSource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public class VcatMemberCktDataSource
extends AbstractRowDataSource
implements Observer,
Runnable {
    List memCktList = Collections.synchronizedList(new ArrayList());
    NetVcatCircuit vcatCircuit;
    private static final SDebug db = new SDebug("VcatMemberCktDataSource");
    private Thread timerThread = null;
    private Object timerLock = new Object();
    private boolean isVisible = false;
    private boolean isDisposed = false;
    private static final int UPDATE_FREQUENCY = 3000;
    boolean checkDsStructureChange;
    private HashSet changedCircuits = new HashSet();

    public VcatMemberCktDataSource(INetCircuit iNetCircuit) {
        if (!(iNetCircuit instanceof NetVcatCircuit)) {
            if (db.on()) {
                db.println("VcatMemberCktDatSource(): parentckt not an instance of NetVcatCircuit");
            }
            return;
        }
        this.vcatCircuit = (NetVcatCircuit)iNetCircuit;
        this.checkDsStructureChange = true;
        this.timerThread = new Thread((Runnable)this, "VcatMemberDataSourceTimerThread");
        this.timerThread.start();
        this.vcatCircuit.addObserver(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.isDisposed) {
            try {
                Object object = this.timerLock;
                synchronized (object) {
                    block13: {
                        if (this.isVisible) {
                            this.updateCircuits();
                            try {
                                this.timerLock.wait(3000L);
                            }
                            catch (InterruptedException interruptedException) {
                                if (db.on()) {
                                    db.println("InterruptedException: timerLock thread interrupted");
                                }
                                break block13;
                            }
                        }
                        try {
                            this.timerLock.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            if (!db.on()) break block13;
                            db.println("InterruptedException: timerLock thread interrupted");
                        }
                    }
                }
            }
            catch (Exception exception) {
                if (!db.on()) continue;
                db.println("exception in " + this.timerThread.getName());
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (db.on()) {
            db.println("disposing timer thread " + this.timerThread.getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setVisible(boolean bl) {
        if (db.on()) {
            db.println("Setting isVisible=" + bl);
        }
        Object object = this.timerLock;
        synchronized (object) {
            if (bl) {
                this.isVisible = true;
                this.timerLock.notify();
            } else {
                this.isVisible = false;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        if (db.on()) {
            db.println("in dispose()");
        }
        this.isDisposed = true;
        Iterator iterator = this.timerLock;
        synchronized (iterator) {
            this.timerLock.notify();
        }
        if (this.vcatCircuit != null) {
            this.vcatCircuit.deleteObserver(this);
        }
        if (this.memCktList != null) {
            iterator = this.memCktList.iterator();
            while (iterator.hasNext()) {
                ((INetCircuit)iterator.next()).deleteObserver(this);
            }
        }
    }

    public void setEnabled(boolean bl) {
        if (VcatMemberCktDataSource.db.on) {
            db.println("Enabled=" + bl);
            db.println("timerThread=" + this.timerThread);
            if (this.timerThread != null) {
                db.println("timerThread.isAlive() = " + this.timerThread.isAlive());
            }
        }
        if (bl) {
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
    }

    private synchronized void updateCircuits() {
        if (this.checkDsStructureChange) {
            this.updateAllCircuits();
            this.checkDsStructureChange = false;
        }
        if (!this.changedCircuits.isEmpty()) {
            this.updateChangedCircuits();
        }
    }

    private void updateAllCircuits() {
        boolean bl = false;
        List<INetCircuit> list = Collections.synchronizedList(new ArrayList(this.vcatCircuit.getAllMemberCircuits()));
        for (INetCircuit iNetCircuit : this.memCktList) {
            if (list.contains(iNetCircuit)) continue;
            if (db.on()) {
                db.fine("UpdateAllCircuits: delete obs of " + iNetCircuit.getCircuitName());
            }
            iNetCircuit.deleteObserver(this);
            bl = true;
        }
        for (INetCircuit iNetCircuit : list) {
            if (this.memCktList.contains(iNetCircuit)) continue;
            if (db.on()) {
                db.fine("UpdateAllCircuits: add obs of " + iNetCircuit.getCircuitName());
            }
            iNetCircuit.addObserver(this);
            bl = true;
        }
        if (bl) {
            if (db.on()) {
                db.fine("UpdateAllCircuits: data source has changed, update struct");
            }
            this.memCktList = list;
            this.fireDataSourceChanged();
            this.changedCircuits.clear();
        }
    }

    private void updateChangedCircuits() {
        for (INetCircuit iNetCircuit : this.changedCircuits) {
            if (db.on()) {
                db.fine("updateChangedCircuits; trying to update " + iNetCircuit.getCircuitName());
            }
            int n = -1;
            if (this.memCktList.contains(iNetCircuit)) {
                n = this.memCktList.indexOf(iNetCircuit);
                if (db.on()) {
                    db.fine("\tFound! on row " + n);
                }
            }
            if (n == -1) continue;
            this.fireBulkRowUpdated(n, iNetCircuit, iNetCircuit);
        }
        this.changedCircuits.clear();
        this.fireBulkUpdateView();
    }

    public Collection getAllObjects() {
        return this.memCktList;
    }

    public Object getObjectAtRow(int n) {
        if (n < this.memCktList.size() && n >= 0) {
            return this.memCktList.get(n);
        }
        return null;
    }

    public int getRowCount() {
        return this.memCktList.size();
    }

    @Override
    public void update(Observable observable, Object object) {
        if (db.on()) {
            db.finer("Update from " + observable + " with arg " + object);
        }
        if (observable instanceof NetCcatCircuit) {
            INetCircuit iNetCircuit = (INetCircuit)((Object)observable);
            int n = -1;
            if (db.on()) {
                db.println("update NetCcat ckt=" + iNetCircuit.getCircuitName());
            }
            if (iNetCircuit.isCircuitRefValid()) {
                if (db.on()) {
                    db.fine("\tReference is valid; just update the row");
                }
                this.changedCircuits.add(iNetCircuit);
            } else {
                if (db.on()) {
                    db.fine("\tReference is not valid; need to update struct");
                }
                this.checkDsStructureChange = true;
            }
        } else if (observable instanceof NetVcatCircuit) {
            NetVcatCircuit netVcatCircuit = (NetVcatCircuit)((Object)observable);
            if (db.on()) {
                db.println("update NetVCat=" + netVcatCircuit.getCircuitName());
            }
            if (netVcatCircuit.isCircuitRefValid()) {
                if (db.on()) {
                    db.fine("Vcat update trigger to refresh circuit.");
                }
                this.checkDsStructureChange = true;
            }
        }
    }
}

