/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ftg;

import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IFTGDelegator;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IIpConfig;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStsRollModel;
import cerent.cms.model.ftg.DelegatingModel;
import cerent.cms.model.ftg.EntityModelAdapterFactory;
import cerent.cms.model.ftg.OldNodeModelDelegateAdapter;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

public class FTGUtils {
    private static SDebug db = new SDebug("FTGUtils");

    private FTGUtils() {
    }

    public static IModel guestPaneFtgAdaptIfNeeded(IModel iModel) {
        INodeModel iNodeModel;
        Object object = iModel;
        if (iModel != null && !Feature.provides((INodeModel)(iNodeModel = iModel.getNodeModel()), (Feature)Feature.FTG) && !(iModel instanceof DelegatingModel)) {
            if (iModel instanceof INodeModel) {
                object = new OldNodeModelDelegateAdapter((INodeModel)iModel);
            } else if (iModel instanceof IEntityModel) {
                object = EntityModelAdapterFactory.createAdapter((IEntityModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
            } else if (db.on()) {
                db.println("Unexpected model type: " + iModel.getClass().getName());
            }
        }
        return object;
    }

    public static boolean validateWrapping(Object object) {
        if (object == null) {
            return true;
        }
        if (object instanceof IModel) {
            return FTGUtils._validateWrapping((IModel)object);
        }
        if (object instanceof ICircuitModel) {
            return FTGUtils._validateWrapping((ICircuitModel)object);
        }
        Class<?> clazz = object.getClass();
        boolean bl = true;
        if (clazz.isArray()) {
            bl = FTGUtils._validateArrayWrapping(object);
        } else if (object instanceof Collection) {
            Iterator iterator = ((Collection)object).iterator();
            bl = FTGUtils._validateWrapping(iterator, clazz.getName() + " collection");
        } else if (object instanceof Iterator) {
            Iterator iterator = (Iterator)object;
            bl = FTGUtils._validateWrapping(iterator, "iterator");
        } else if (object instanceof Map && (bl = FTGUtils._validateWrapping(((Map)object).keySet().iterator(), clazz.getName() + " keys"))) {
            bl = FTGUtils._validateWrapping(((Map)object).values().iterator(), clazz.getName() + " values");
        }
        return bl;
    }

    protected static boolean _validateWrapping(ICircuitModel iCircuitModel) {
        Class<?> clazz = iCircuitModel.getClass();
        ICircuitId iCircuitId = iCircuitModel.getId();
        INodeModel iNodeModel = iCircuitModel.getNodeModel();
        if (iNodeModel == null) {
            return true;
        }
        String string = FTGUtils.getIpAddr(iNodeModel);
        boolean bl = Feature.delegateProvides((INodeModel)iNodeModel, (Feature)Feature.FTG);
        boolean bl2 = bl ^ iCircuitModel instanceof IFTGDelegator;
        if (!bl2) {
            if (!bl) {
                if (FTGUtils.shouldOldModelBeWrapped(iCircuitModel)) {
                    FTGUtils.genException("(" + string + ")model class: " + clazz.getName() + " with id: " + iCircuitId + " should be wrapped but isn't");
                }
            } else {
                FTGUtils.genException("(" + string + ")model class: " + clazz.getName() + " with id: " + iCircuitId + " should NOT be wrapped but is");
            }
        }
        return bl2;
    }

    protected static boolean _validateWrapping(IModel iModel) {
        Class<?> clazz = iModel.getClass();
        int n = iModel.getIndex();
        INodeModel iNodeModel = iModel.getNodeModel();
        if (iNodeModel == null) {
            return true;
        }
        String string = FTGUtils.getIpAddr(iNodeModel);
        boolean bl = Feature.delegateProvides((INodeModel)iNodeModel, (Feature)Feature.FTG);
        boolean bl2 = bl ^ iModel instanceof IFTGDelegator;
        if (!bl2) {
            if (!bl) {
                if (FTGUtils.shouldOldModelBeWrapped(iModel)) {
                    FTGUtils.genException("(" + string + ")model class: " + clazz.getName() + " with index: " + n + " should be wrapped but isn't");
                }
            } else {
                FTGUtils.genException("(" + string + ")model class: " + clazz.getName() + " with index: " + n + " should NOT be wrapped but is");
            }
        }
        return bl2;
    }

    protected static void genException(String string) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException(string);
        if (db.on()) {
            db.println(string);
            SDebug.printStackTrace((Throwable)illegalArgumentException);
        }
        throw illegalArgumentException;
    }

    protected static String getIpAddr(INodeModel iNodeModel) {
        IIpConfig iIpConfig = iNodeModel.getIpConfig();
        String string = InetUtil.makeDottedString(iIpConfig.getIpAddress());
        return string;
    }

    protected static boolean shouldOldModelBeWrapped(Object object) {
        if (object == null) {
            return false;
        }
        boolean bl = object instanceof ICircuitModel || object instanceof INodeModel || object instanceof IConnectionModel || object instanceof IConnectionModels || object instanceof ICircuitFactoryModel || object instanceof IEntityModel || object instanceof IInterfaceModel || object instanceof IStsRollModel || object instanceof IElementModel;
        return bl;
    }

    protected static boolean _validateArrayWrapping(Object object) {
        int n;
        int n2 = Array.getLength(object);
        boolean bl = true;
        try {
            for (n = 0; bl && n < n2; ++n) {
                Object object2 = Array.get(object, n);
                bl = FTGUtils.validateWrapping(object2);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string = "array count: " + n + "; " + illegalArgumentException.getMessage();
            throw new IllegalArgumentException(string);
        }
        return bl;
    }

    protected static boolean _validateWrapping(Iterator iterator, String string) {
        boolean bl = true;
        int n = 0;
        try {
            while (iterator.hasNext() && bl) {
                bl = FTGUtils.validateWrapping(iterator.next());
                ++n;
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string2 = string + "; iterator count: " + n + "; " + illegalArgumentException.getMessage();
            throw new IllegalArgumentException(string2);
        }
        return bl;
    }
}

