/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.model.ftg;

import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IElementModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IStsRollModel;
import cerent.cms.model.ftg.ConnectionModelAdapterFactory;
import cerent.cms.model.ftg.DelegatingModel;
import cerent.cms.model.ftg.ElementModelAdapterFactory;
import cerent.cms.model.ftg.EntityModelAdapterFactory;
import cerent.cms.model.ftg.InterfaceModelAdapterFactory;
import cerent.cms.model.ftg.OldCircuitFactoryModelDelegateAdapter;
import cerent.cms.model.ftg.OldCircuitModelAdapter;
import cerent.cms.model.ftg.OldConnectionModelsDelegateAdapter;
import cerent.cms.model.ftg.OldElementModelsDelegateAdapter;
import cerent.cms.model.ftg.OldNodeModelDelegateAdapter;
import cerent.cms.model.ftg.OldStsRollModelAdapter;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;

public class FtgModelObserver
implements IObserver {
    private IObserver delegate;
    private static SDebug db = new SDebug("FtgModelObserver");

    public FtgModelObserver(IObserver iObserver) {
        this.delegate = iObserver;
    }

    public IObserver getDelegate() {
        return this.delegate;
    }

    private static IObservable CreateOldAdapter(IObservable iObservable) {
        IModel iModel = iObservable instanceof IModel ? (IModel)iObservable : null;
        INodeModel iNodeModel = iModel != null ? iModel.getNodeModel() : null;
        DelegatingModel delegatingModel = null;
        if (iObservable instanceof ICircuitModel) {
            delegatingModel = new OldCircuitModelAdapter((ICircuitModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof INodeModel) {
            delegatingModel = new OldNodeModelDelegateAdapter(iNodeModel);
        } else if (iModel instanceof IConnectionModel) {
            delegatingModel = ConnectionModelAdapterFactory.createAdapter((IConnectionModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof IConnectionModels) {
            delegatingModel = new OldConnectionModelsDelegateAdapter((IConnectionModels)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iObservable instanceof ICircuitFactoryModel) {
            delegatingModel = new OldCircuitFactoryModelDelegateAdapter((ICircuitFactoryModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof IEntityModel) {
            delegatingModel = EntityModelAdapterFactory.createAdapter((IEntityModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof IInterfaceModel) {
            delegatingModel = InterfaceModelAdapterFactory.createAdapter((IInterfaceModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof IStsRollModel) {
            delegatingModel = new OldStsRollModelAdapter((IStsRollModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof IElementModel) {
            delegatingModel = ElementModelAdapterFactory.createAdapter((IElementModel)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else if (iModel instanceof IElementModels) {
            delegatingModel = new OldElementModelsDelegateAdapter((IElementModels)iModel, new OldNodeModelDelegateAdapter(iNodeModel));
        } else {
            db.println("(" + iNodeModel.getHostName() + ") you MAY need to add FTG old model adaption support for type: " + iModel.getClass().getName());
        }
        return delegatingModel;
    }

    protected boolean doesOldAdapterNeedCreating(INodeModel iNodeModel) {
        return iNodeModel != null && !Feature.provides((INodeModel)iNodeModel, (Feature)Feature.FTG);
    }

    public void update(IObservable iObservable, Object object) {
        INodeModel iNodeModel;
        Object object2 = iObservable instanceof IModel ? ((IModel)iObservable).getNodeModel() : (iNodeModel = iObservable instanceof ICircuitModel ? ((ICircuitModel)iObservable).getNodeModel() : null);
        if (this.doesOldAdapterNeedCreating(iNodeModel)) {
            iObservable = FtgModelObserver.CreateOldAdapter(iObservable);
        }
        this.delegate.update(iObservable, object);
    }
}

