/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.IConnectionType;
import cerent.cms.ncp.BridgeConnection;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.InternalCircuitSpan;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.SelectorConnection;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public abstract class Connection {
    private static final SDebug db = new SDebug("Connection");
    protected ArrayList inPuts = new ArrayList();
    protected ArrayList outPuts = new ArrayList();
    private String name = null;
    private boolean loopFlag = false;

    public Connection(String string) {
        this.name = string;
    }

    public boolean checkEndPoint(Object object) {
        if (object instanceof NetCircuitSpan || object instanceof NetCircuitEnd) {
            return true;
        }
        if (this.dbgOn()) {
            db.println("connection end point is neither NetCircuitSpan nor NetCircuitEnd");
        }
        return false;
    }

    public boolean addInput(Object object) {
        return false;
    }

    public boolean addOutput(Object object) {
        if (!this.checkEndPoint(object)) {
            return false;
        }
        this.outPuts.add(object);
        return true;
    }

    public boolean removeInput(Object object) {
        if (this.inPuts.isEmpty()) {
            if (this.dbgOn()) {
                db.println("WARNING! inPut list empty");
            }
            return false;
        }
        if (!this.checkEndPoint(object)) {
            return false;
        }
        if (this.inPuts.contains(object)) {
            int n = this.inPuts.indexOf(object);
            this.inPuts.remove(n);
            return true;
        }
        if (this.dbgOn()) {
            db.println("WARNING! object not in input list");
        }
        return false;
    }

    public Connection getSelectorHead() {
        return null;
    }

    protected boolean isInput(Object object) {
        return this.inPuts.contains(object);
    }

    protected boolean hasOutputTo(Connection connection) {
        Connection connection2 = null;
        for (Object e : this.outPuts) {
            if (!(e instanceof NetCircuitSpan) || (connection2 = ((NetCircuitSpan)e).getPeerConnection(this)) == null || !connection2.equals(connection)) continue;
            return true;
        }
        return false;
    }

    protected boolean isExternalInput(Object object) {
        Iterator iterator = this.inPuts.iterator();
        while (iterator.hasNext()) {
            Object object2 = this.getExternalInput(iterator.next());
            if (object2 == null || !object2.equals(object)) continue;
            return true;
        }
        return false;
    }

    public boolean removeOutput(Object object) {
        if (this.outPuts.isEmpty()) {
            if (this.dbgOn()) {
                db.println("WARNING! outPut list empty");
            }
            return false;
        }
        if (!this.checkEndPoint(object)) {
            return false;
        }
        if (this.outPuts.contains(object)) {
            int n = this.outPuts.indexOf(object);
            this.outPuts.remove(n);
            return true;
        }
        if (this.dbgOn()) {
            db.println("WARNING! object not in output list");
        }
        return false;
    }

    protected boolean isOutput(Object object) {
        return this.outPuts.contains(object);
    }

    protected boolean isInputCircuitEnd() {
        Iterator iterator = this.inPuts.iterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof NetCircuitEnd)) continue;
            return true;
        }
        return this.inPuts.size() > 0;
    }

    public List getOutputs() {
        return new ArrayList(this.outPuts);
    }

    public List getInputs() {
        return new ArrayList(this.inPuts);
    }

    public List getExternalInputs() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        Iterator iterator = this.inPuts.iterator();
        while (iterator.hasNext()) {
            Object object = this.getExternalInput(iterator.next());
            if (object == null) continue;
            arrayList.add(object);
        }
        return arrayList;
    }

    public List getOutSpans() {
        LinkedList linkedList = new LinkedList();
        for (Object e : this.outPuts) {
            if (!(e instanceof NetCircuitSpan)) continue;
            linkedList.add(e);
        }
        return linkedList;
    }

    public List getInSpans() {
        LinkedList linkedList = new LinkedList();
        for (Object e : this.inPuts) {
            if (!(e instanceof NetCircuitSpan)) continue;
            linkedList.add(e);
        }
        return linkedList;
    }

    public List getExternalInSpans() {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        for (Object e : this.inPuts) {
            NetCircuitSpan netCircuitSpan;
            if (!(e instanceof NetCircuitSpan) || (netCircuitSpan = this.getExternalInSpan((NetCircuitSpan)e)) == null) continue;
            linkedList.add(netCircuitSpan);
        }
        return linkedList;
    }

    public boolean isSelector() {
        return false;
    }

    protected boolean isFedByDriHandoffs() {
        return false;
    }

    public boolean isBridge() {
        return false;
    }

    public boolean isOneway() {
        return false;
    }

    protected boolean isValidBlsrDriSelector() {
        return false;
    }

    protected boolean isValidOpenEndedOnewayBlsrDriSecondaryDrop() {
        return false;
    }

    protected boolean isOpenEndedOnewayBlsrDriSecondaryDrop() {
        return false;
    }

    protected boolean isOpenEndedOnewayBlsrDriPrimaryDrop() {
        return false;
    }

    protected boolean isUpsrHead3Profile() {
        return false;
    }

    protected boolean isBlsrDriSelector() {
        return false;
    }

    protected NetCircuitSpan getExternalInSpan(NetCircuitSpan netCircuitSpan) {
        NetCircuitSpan netCircuitSpan2 = null;
        if (!this.inPuts.contains(netCircuitSpan)) {
            return null;
        }
        if (netCircuitSpan != null && netCircuitSpan.isInternalSpan()) {
            Connection connection = netCircuitSpan.getPeerConnection(this);
            if (connection != null) {
                List list = connection.getInSpans();
                netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
            }
        } else {
            netCircuitSpan2 = netCircuitSpan;
        }
        return netCircuitSpan2;
    }

    protected Object getExternalInput(Object object) {
        Object object2 = null;
        if (object != null && object instanceof InternalCircuitSpan) {
            InternalCircuitSpan internalCircuitSpan = (InternalCircuitSpan)object;
            Connection connection = internalCircuitSpan.getPeerConnection(this);
            if (connection != null) {
                object2 = connection.inPuts.size() == 0 ? null : connection.inPuts.get(0);
            }
        } else {
            object2 = object;
        }
        return object2;
    }

    protected boolean isFedBy(Connection connection) {
        NetCircuitSpan netCircuitSpan = this.inPuts.size() == 1 && this.inPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)this.inPuts.get(0) : null;
        return this.isFedBy(connection, this, netCircuitSpan);
    }

    protected boolean isFedBy(Connection connection, Connection connection2, NetCircuitSpan netCircuitSpan) {
        if (this.equals(connection)) {
            if (this.dbgOn()) {
                db.println("isFedBy: terminating true. The " + connection2.getName() + " on node " + connection2.getNodeName() + " is fed by the " + this.getName() + " on node " + this.getNodeName());
            }
            return true;
        }
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("isFedBy: terminating on a null inSpan on the " + this.getName() + " connection on " + this.getNodeName() + " Search was for the " + connection.getName() + " connection on node " + connection.getNodeName() + " feeding the " + connection2.getName() + " on node " + connection2.getNodeName());
            }
            return false;
        }
        Connection connection3 = netCircuitSpan.getPeerConnection(this);
        if (connection3 == null) {
            if (this.dbgOn()) {
                db.println("isFedBy: terminating on a null peer on the " + this.getName() + " connection on " + this.getNodeName() + " Search was for the " + connection.getName() + " connection on node " + connection.getNodeName() + " feeding the " + connection2.getName() + " on node " + connection2.getNodeName());
            }
            return false;
        }
        if (connection3 instanceof SelectorConnection) {
            if (this.dbgOn()) {
                db.println("isFedBy: terminating on the " + connection3.getName() + " connection on " + connection3.getNodeName() + " Search was for the " + connection.getName() + " connection on node " + connection.getNodeName() + " feeding the " + connection2.getName() + " on node " + connection2.getNodeName());
            }
            return true;
        }
        NetCircuitSpan netCircuitSpan2 = this.inPuts.size() == 1 && this.inPuts.get(0) instanceof NetCircuitSpan ? (NetCircuitSpan)this.inPuts.get(0) : null;
        boolean bl = this.loopFound() ? false : connection3.isFedBy(connection, connection2, netCircuitSpan);
        this.loopFlag = false;
        return bl;
    }

    protected List collectSelectorHeadCandidates(ArrayList arrayList, NetCircuitSpan netCircuitSpan) {
        List list;
        Connection connection = netCircuitSpan.getPeerConnection(this);
        if (connection == null) {
            if (this.dbgOn()) {
                db.println("collectSelectorHeadCandidates: terminating on a null peer connection.");
            }
            return arrayList;
        }
        if (connection instanceof SelectorConnection && !connection.isBlsrDriSecondary()) {
            if (this.dbgOn()) {
                db.println("collectSelectorHeadCandidates: terminating on a selector connection on " + connection.getNodeName());
            }
            arrayList.add(connection);
            return arrayList;
        }
        if (connection instanceof BridgeConnection && !connection.isUpsrBlsrIdriPrimaryInternalBridge()) {
            if (this.dbgOn()) {
                db.println("collectSelectorHeadCandidates: found a bridge on " + connection.getNodeName());
            }
            arrayList.add(connection);
        }
        if ((list = connection.getInSpans()).size() == 0) {
            if (this.dbgOn()) {
                db.println("collectSelectorHeadCandidates: terminating on a null inSpan on " + connection.getNodeName());
            }
            return arrayList;
        }
        if (!this.loopFound()) {
            connection.collectSelectorHeadCandidates(arrayList, (NetCircuitSpan)list.get(0));
        }
        this.loopFlag = false;
        return arrayList;
    }

    protected abstract boolean hasValidUpsrDriHandoffInterconnect(Connection var1);

    protected boolean markSelectorInputSpans(SelectorConnection selectorConnection, NetCircuitSpan netCircuitSpan) {
        Connection connection;
        Connection connection2 = connection = selectorConnection == null ? null : selectorConnection.getSelectorHead();
        if (this.equals(connection)) {
            if (this.dbgOn()) {
                db.println("markSelectorInputSpans: terminating at head on node " + this.getNodeName());
            }
            return this.isInputLineProtected(netCircuitSpan);
        }
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("markSelectorInputSpans: terminating on a null inSpan on node " + this.getNodeName());
            }
            if (this.isInputCircuitEnd()) {
                if (this.getUpsrDriSelector() != null) {
                    selectorConnection.addHandoff(this);
                }
                return Connection.isSelectorOpenEnded(connection);
            }
            return false;
        }
        Connection connection3 = netCircuitSpan.getPeerConnection(this);
        if (connection3 == null) {
            if (this.dbgOn()) {
                db.println("markSelectorInputSpans: terminating on a null peer connection on node " + this.getNodeName());
            }
            return false;
        }
        if (connection3 instanceof SelectorConnection) {
            if (this.dbgOn()) {
                db.println("markSelectorInputSpans: terminating on a selector on node " + connection3.getNodeName());
                db.println("markSelectorInputSpans: true upsr input path member. span " + netCircuitSpan.prettyString());
            }
            if (connection3.hasInternalCircuitSpanInput()) {
                selectorConnection.addHandoff(connection3);
            }
            netCircuitSpan.setUpsrLink(true);
            return true;
        }
        List list = connection3.getInSpans();
        NetCircuitSpan netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        boolean bl = this.loopFound() ? false : connection3.markSelectorInputSpans(selectorConnection, netCircuitSpan2);
        this.loopFlag = false;
        netCircuitSpan.setUpsrLink(true);
        if (this.dbgOn()) {
            db.println("markSelectorInputSpans: true upsr input path member. span " + netCircuitSpan.prettyString());
        }
        return bl;
    }

    protected boolean isUpsrBlsrIdriPrimaryInternalBridge() {
        return false;
    }

    protected static boolean isLineProtected(NetCircuitSpan netCircuitSpan) {
        return netCircuitSpan == null ? false : netCircuitSpan.isLineProtected();
    }

    protected static boolean isSelectorOpenEnded(Connection connection) {
        return connection == null;
    }

    protected boolean isInputLineProtected(NetCircuitSpan netCircuitSpan) {
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("isInputLineProtected: terminating on a null inSpan on node " + this.getNodeName());
            }
            return this.isInputCircuitEnd();
        }
        if (this.dbgOn()) {
            db.println("isInputLineProtected: walking input path on node " + this.getNodeName() + " span " + netCircuitSpan.prettyString());
        }
        if (!(this instanceof SelectorConnection || Connection.isLineProtected(netCircuitSpan) || this.isBlsrDriPcaSecondary(netCircuitSpan))) {
            if (this.dbgOn()) {
                db.println("isInputLineProtected: terminating on a " + this.getName() + " without input line protection on node " + this.getNodeName());
            }
            return false;
        }
        Connection connection = netCircuitSpan.getPeerConnection(this);
        if (connection == null) {
            if (this.dbgOn()) {
                db.println("isInputLineProtected: terminating on a null peer connection on node " + this.getNodeName());
            }
            return false;
        }
        if (connection instanceof SelectorConnection) {
            if (this.dbgOn()) {
                db.println("isInputLineProtected: terminating on a selector on node " + connection.getNodeName());
            }
            return true;
        }
        List list = connection.getInSpans();
        NetCircuitSpan netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        boolean bl = this.loopFound() ? false : connection.isInputLineProtected(netCircuitSpan2);
        this.loopFlag = false;
        return bl;
    }

    protected SelectorConnection getUpsrDriSelector() {
        return null;
    }

    protected boolean hasInternalCircuitSpanInput() {
        for (Object e : this.inPuts) {
            if (!(e instanceof InternalCircuitSpan)) continue;
            return true;
        }
        return false;
    }

    private boolean isBlsrDriPcaSecondary(NetCircuitSpan netCircuitSpan) {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitSpan.getNetLinkSpan() != null && netCircuitSpan.getNetLinkSpan().isSecondaryCircuit() && netCircuitNode != null && netCircuitSpan.getLink().isPca(netCircuitNode.getNetElement());
    }

    protected boolean hasInputPathDrop(SelectorConnection selectorConnection, NetCircuitSpan netCircuitSpan, Object object) {
        Connection connection;
        Connection connection2;
        Connection connection3 = connection2 = selectorConnection == null ? null : selectorConnection.getSelectorHead();
        if (this.equals(connection2)) {
            if (this.dbgOn()) {
                db.println("hasInputPathDrop: terminating at head on node " + this.getNodeName());
            }
            return false;
        }
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("hasInputPathDrop: terminating on a null inSpan on node " + this.getNodeName());
            }
            return false;
        }
        if (this.dbgOn() && !netCircuitSpan.isInternalSpan()) {
            db.println("hasInputPathDrop: examining connType " + EnumStrings.getString(IConnectionType.class, (int)this.getNode().connType) + " on node " + this.getNodeName());
        }
        if ((connection = netCircuitSpan.getPeerConnection(this)) == null) {
            if (this.dbgOn()) {
                db.println("hasInputPathDrop: terminating on a null peer connection on node " + this.getNodeName());
            }
            return this.hasNodeFedDrop(object);
        }
        if (!netCircuitSpan.isInternalSpan() && this.hasNodeFedDrop(object)) {
            return true;
        }
        if (connection instanceof SelectorConnection) {
            if (this.dbgOn()) {
                db.println("hasInputPathDrop: terminating on a selector on node " + connection.getNodeName());
            }
            return false;
        }
        List list = connection.getInSpans();
        NetCircuitSpan netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        boolean bl = this.loopFound() ? true : connection.hasInputPathDrop(selectorConnection, netCircuitSpan2, object);
        this.loopFlag = false;
        return bl;
    }

    protected boolean hasNodeFedDrop(Object object) {
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null) {
            db.println("hasNodeFedDrop: Error - node for connection not found");
            return true;
        }
        if (netCircuitNode.feedsNoDrops(object)) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("hasNodeFedDrop: a drop is fed by node " + netCircuitNode.getName());
        }
        return true;
    }

    private boolean loopFound() {
        if (this.loopFlag) {
            db.println("loopFound: ERROR - loop detected at " + this.getNodeName());
            return true;
        }
        this.loopFlag = true;
        return false;
    }

    protected boolean selectorPathHasInterconnectToDriPeer(SelectorConnection selectorConnection, NetCircuitSpan netCircuitSpan, Connection connection) {
        Connection connection2;
        if (this.hasOutputTo(connection)) {
            if (this.dbgOn()) {
                db.println("selectorPathHasInterconnectToDriPeer: terminating on finding the " + connection.getName() + " connection on node " + this.getNodeName());
            }
            return true;
        }
        Connection connection3 = connection2 = selectorConnection == null ? null : selectorConnection.getSelectorHead();
        if (this.equals(connection2)) {
            if (this.dbgOn()) {
                db.println("selectorPathHasInterconnectToDriPeer: terminating at head on node " + this.getNodeName());
            }
            return false;
        }
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("selectorPathHasInterconnectToDriPeer: terminating on a null inSpan on node " + this.getNodeName());
            }
            return false;
        }
        Connection connection4 = netCircuitSpan.getPeerConnection(this);
        if (connection4 == null) {
            if (this.dbgOn()) {
                db.println("selectorPathHasInterconnectToDriPeer: terminating on a null peer connection on node " + this.getNodeName());
            }
            return false;
        }
        if (connection4 instanceof SelectorConnection) {
            if (this.dbgOn()) {
                db.println("selectorPathHasInterconnectToDriPeer: terminating on a selector on node " + connection4.getNodeName());
            }
            return false;
        }
        List list = connection4.getInSpans();
        NetCircuitSpan netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        boolean bl = this.loopFound() ? true : connection4.selectorPathHasInterconnectToDriPeer(selectorConnection, netCircuitSpan2, connection);
        this.loopFlag = false;
        return bl;
    }

    protected int validDriHandoffPairCount(SelectorConnection selectorConnection, Connection connection, NetCircuitSpan netCircuitSpan, StringBuffer stringBuffer, StringBuffer stringBuffer2, ArrayList arrayList, ArrayList arrayList2, int n) {
        NetCircuitSpan netCircuitSpan2;
        Connection connection2;
        NetCircuitNode netCircuitNode = this.getNode();
        if (this.equals(connection)) {
            if (netCircuitSpan != null && netCircuitNode != null && netCircuitSpan.getLink() != null && netCircuitSpan.getLink().inBLSR()) {
                stringBuffer.replace(0, stringBuffer.length(), netCircuitSpan.getLink().blsrRingName(netCircuitNode.getNetElement()));
            }
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: terminating at " + this.getName() + " connection head on node " + this.getNodeName() + " secondaryPath " + stringBuffer2 + (stringBuffer.length() > 0 ? " with input BLSR " + stringBuffer : ""));
            }
            return n;
        }
        if (!this.isValidBlsrDriHandoffPair(netCircuitSpan, arrayList)) {
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: terminating on an invalid BLSR DRI handoff on node " + this.getNodeName());
            }
            return -1;
        }
        if (netCircuitSpan == null) {
            boolean bl = this.isInputCircuitEnd();
            if (bl && !arrayList2.contains(this)) {
                arrayList2.add(this);
            }
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: terminating on a null inSpan on node " + this.getNodeName() + " isOpenEnded " + bl + " secondaryPath " + stringBuffer2);
            }
            return arrayList2.size() == 2 ? ++n : n;
        }
        if (!this.isValidBlsrDriSpan(stringBuffer, netCircuitSpan)) {
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: BLSR DRI handoff interconnect " + this.getNodeName() + " not protected by ring " + stringBuffer + " on span " + netCircuitSpan.prettyString());
            }
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        if ((connection2 = netCircuitSpan.getPeerConnection(this)) == null) {
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: terminating on a null peer connection on node " + this.getNodeName());
            }
            return n;
        }
        if (connection2.isBlsrDriHandoff() && stringBuffer.length() > 0 && !netCircuitSpan.isInternalSpan()) {
            if (this.isValidBlsrDriHandoffPair(arrayList)) {
                if (this.dbgOn()) {
                    db.println("validDriHandoffPairCount: valid BLSR " + stringBuffer + " DRI feed coming from the handoff on node " + connection2.getNodeName());
                }
                ++n;
            }
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        if (connection2 instanceof SelectorConnection) {
            this.markSecondarySpan(stringBuffer2, netCircuitSpan, selectorConnection);
            if (!arrayList2.contains(connection2)) {
                arrayList2.add(connection2);
            }
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: terminating on a selector on node " + connection2.getNodeName() + " secondaryPath " + stringBuffer2);
            }
            return arrayList2.size() == 2 ? ++n : n;
        }
        List list = connection2.getInSpans();
        NetCircuitSpan netCircuitSpan3 = netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        if (this.loopFound()) {
            return -1;
        }
        n = connection2.validDriHandoffPairCount(selectorConnection, connection, netCircuitSpan2, stringBuffer, stringBuffer2, arrayList, arrayList2, n);
        this.loopFlag = false;
        this.markSecondarySpan(stringBuffer2, netCircuitSpan, selectorConnection);
        if (!this.isValidBlsrDriSpan(stringBuffer, netCircuitSpan)) {
            if (this.dbgOn()) {
                db.println("validDriHandoffPairCount: BLSR DRI handoff interconnect " + this.getNodeName() + " not protected by ring " + stringBuffer + " on span " + netCircuitSpan.prettyString());
            }
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        if (this.isBlsrDriHandoff() && stringBuffer.length() > 0 && !netCircuitSpan.isInternalSpan()) {
            if (this.isValidBlsrDriHandoffPair(arrayList)) {
                if (this.dbgOn()) {
                    db.println("validDriHandoffPairCount: valid BLSR " + stringBuffer + " DRI feed going to the handoff on node " + this.getNodeName());
                }
                ++n;
            } else {
                n = -1;
            }
            stringBuffer.replace(0, stringBuffer.length(), "");
        }
        return n;
    }

    boolean isValidBlsrDriSpan(StringBuffer stringBuffer, NetCircuitSpan netCircuitSpan) {
        if (netCircuitSpan.isInternalSpan() || stringBuffer.length() == 0) {
            return true;
        }
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitSpan.getLink().inBLSR() && netCircuitNode != null && netCircuitSpan.getLink().blsrRingName(netCircuitNode.getNetElement()).equals(stringBuffer.toString())) {
            netCircuitSpan.setBlsrDriInterConnect(true);
            return true;
        }
        return false;
    }

    private boolean isValidBlsrDriHandoffPair(NetCircuitSpan netCircuitSpan, ArrayList arrayList) {
        String string = "";
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null) {
            string = "unable to determine node owner";
        } else if (this.isBlsrDriType() && !this.hasBlsrProtection() && !this.isUpsrBlsrIdriPrimaryInternalBridge()) {
            string = "lacks a BLSR protected span.  Every connection on a primary, secondary and intermdiate type node must have at least one BLSR protected span except for the bridge with an unprotected input on a BLSR IDRI primary";
        } else if (!NetCircuitNodeUtil.isBlsrDriPrimary(netCircuitNode.getDriNodeType()) && !NetCircuitNodeUtil.isBlsrDriSecondary(netCircuitNode.getDriNodeType()) && this.hasBlsrProtection() && netCircuitNode.hasSelector()) {
            string = "has a BLSR service selector but is not configured as a primary or secondary handoff";
        }
        if ((arrayList.size() & 1) == 1 && string.length() == 0 && !this.isBlsrDriType()) {
            string = "must be a primary, secondary or intermediate IDriNodeType";
        }
        if (string.length() == 0 && netCircuitSpan != null && !netCircuitSpan.isInternalSpan() && netCircuitSpan.getLink().inBLSR()) {
            Connection connection;
            Connection connection2;
            if ((arrayList.size() & 1) == 0 && this.isBlsrDriHandoff()) {
                if (arrayList.size() >= 4) {
                    string = "has input path with more than 4 handoffs";
                } else {
                    arrayList.add(this);
                }
            }
            if ((arrayList.size() & 1) == 1 && string.length() == 0 && (connection2 = netCircuitSpan.getPeerConnection(this)) != null && ((connection = (Connection)arrayList.get(arrayList.size() - 1)).isBlsrDriPrimary() && connection2.isBlsrDriSecondary() || connection.isBlsrDriSecondary() && connection2.isBlsrDriPrimary())) {
                arrayList.add(connection2);
            }
        }
        if (string.length() > 0) {
            if (this.dbgOn()) {
                db.println("isValidBlsrDriHandoffPair: error - " + this.getName() + " connection on node " + this.getNodeName() + " " + string);
            }
            return false;
        }
        return true;
    }

    protected boolean hasBlsrProtection() {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.getExternalInSpans());
        arrayList.addAll(this.getOutSpans());
        for (NetCircuitSpan netCircuitSpan : arrayList) {
            if (netCircuitSpan.isInternalSpan() || !netCircuitSpan.getLink().inBLSR()) continue;
            return true;
        }
        return false;
    }

    private boolean isValidBlsrDriHandoffPair(List list) {
        String string = "";
        String string2 = "";
        switch (list.size()) {
            case 0: {
                string = "no handoff pairs";
                break;
            }
            case 2: {
                string = "single handoff pair";
                break;
            }
            case 4: {
                NetCircuitNode netCircuitNode = ((Connection)list.get(1)).getNode();
                NetCircuitNode netCircuitNode2 = ((Connection)list.get(2)).getNode();
                NetCircuitNode netCircuitNode3 = ((Connection)list.get(3)).getNode();
                string = netCircuitNode != null && (netCircuitNode.equals(netCircuitNode2) || netCircuitNode.equals(netCircuitNode3)) ? "integrated handoff configuration" : "traditional handoff configuration";
                break;
            }
            default: {
                string2 = "invalid handoff count of " + list.size();
            }
        }
        if (this.dbgOn()) {
            db.println("isValidBlsrDriHandoffPair: " + string2 + string + " discovered");
        }
        return string.length() > 0;
    }

    protected void markSpansDri() {
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null || !netCircuitNode.getDri() && !this.isFedByDriHandoffs() && !this.isBlsrEdge()) {
            return;
        }
        for (Object e : this.inPuts) {
            NetCircuitSpan netCircuitSpan;
            if (!(e instanceof NetCircuitSpan) || (netCircuitSpan = this.getExternalInSpan((NetCircuitSpan)e)) == null || netCircuitSpan.getDri()) continue;
            if (this.dbgOn()) {
                db.println("markSpansDri: starting on " + this.getName() + " connection on node " + this.getNodeName() + " inSpan " + netCircuitSpan.prettyString());
            }
            this.markSpansDri((SelectorConnection)(this.isSelector() ? this : null), netCircuitSpan, netCircuitNode.getDri());
        }
    }

    private boolean markSpansDri(SelectorConnection selectorConnection, NetCircuitSpan netCircuitSpan, boolean bl) {
        NetCircuitSpan netCircuitSpan2;
        if (selectorConnection != null && this.equals(selectorConnection.getSelectorHead())) {
            bl |= this.isDriNode();
            if (this.dbgOn()) {
                db.println("markSpansDri: terminating at head with isDriPath " + bl + " on node " + this.getNodeName());
            }
            return bl;
        }
        if (netCircuitSpan == null) {
            bl |= this.isDriNode();
            if (this.dbgOn()) {
                db.println("markSpansDri: terminating on a null inSpan with  isDriPath " + bl + " on node " + this.getNodeName());
            }
            return bl;
        }
        Connection connection = netCircuitSpan.getPeerConnection(this);
        if (connection == null) {
            if (this.dbgOn()) {
                db.println("markSpansDri: terminating on a null peer connection  with isDriPath false on node " + this.getNodeName());
            }
            return false;
        }
        if (connection.isDriNode()) {
            if (this.dbgOn()) {
                db.println("markSpansDri: terminating with isDriPath true  on DRI node " + connection.getNodeName());
            }
            if (this.markSpanDri(netCircuitSpan, true) && this.dbgOn()) {
                db.println("markSpansDri: true DRI input path member on span " + netCircuitSpan.prettyString());
            }
            return true;
        }
        if (connection.isSelector() || connection.isBlsrEdge()) {
            if (this.dbgOn()) {
                db.println("markSpansDri: terminating with isDriPath " + bl + " on " + (connection.isSelector() ? "a selector on" : "blsr edge") + " node " + connection.getNodeName());
            }
            if (this.markSpanDri(netCircuitSpan, bl) && this.dbgOn()) {
                db.println("markSpansDri: true DRI input path member on span " + netCircuitSpan.prettyString());
            }
            return bl;
        }
        List list = connection.getInSpans();
        NetCircuitSpan netCircuitSpan3 = netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        if (this.loopFound()) {
            return false;
        }
        bl = connection.markSpansDri(selectorConnection, netCircuitSpan2, bl);
        this.loopFlag = false;
        if (this.markSpanDri(netCircuitSpan, bl) && this.dbgOn()) {
            db.println("markSpansDri: true DRI input path member on span " + netCircuitSpan.prettyString());
        }
        return bl;
    }

    private boolean isDriNode() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode != null && netCircuitNode.getDri();
    }

    private boolean markSpanDri(NetCircuitSpan netCircuitSpan, boolean bl) {
        if (bl && (netCircuitSpan.getUpsrLink() || netCircuitSpan.getLink().inBLSR() || netCircuitSpan.getLink().isPca() && netCircuitSpan.getNetLinkSpan().isSecondaryCircuit())) {
            netCircuitSpan.setDri(true);
            return true;
        }
        return false;
    }

    protected boolean isBlsrEdge() {
        String string = "";
        String string2 = "";
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null || netCircuitNode.hasSelector() || this.inPuts.size() == 0) {
            return false;
        }
        INetElement iNetElement = netCircuitNode.getNetElement();
        if (this.inPuts.get(0) instanceof NetCircuitSpan) {
            string = ((NetCircuitSpan)this.inPuts.get(0)).getLink().blsrRingName(iNetElement);
        }
        for (Object e : this.outPuts) {
            if (!(e instanceof NetCircuitSpan)) continue;
            INetLink iNetLink = ((NetCircuitSpan)e).getLink();
            if (iNetLink.blsrRingName(iNetElement).equals(string) && !string.equals("")) {
                return false;
            }
            if (iNetLink.blsrRingName(iNetElement).equals("")) continue;
            string2 = iNetLink.blsrRingName(iNetElement);
        }
        return !string.equals(string2);
    }

    boolean isBlsrDriPrimary() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode != null && NetCircuitNodeUtil.isBlsrDriPrimary(netCircuitNode.getDriNodeType());
    }

    boolean isBlsrDriSecondary() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode != null && NetCircuitNodeUtil.isBlsrDriSecondary(netCircuitNode.getDriNodeType());
    }

    protected boolean isBlsrDriHandoff() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode != null && NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNode.getDriNodeType());
    }

    protected boolean isBlsrDriType() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode != null && NetCircuitNodeUtil.isBlsrDriType(netCircuitNode.getDriNodeType());
    }

    private void markSecondarySpan(StringBuffer stringBuffer, NetCircuitSpan netCircuitSpan, SelectorConnection selectorConnection) {
        boolean bl;
        boolean bl2;
        String string;
        NetCircuitNode netCircuitNode = this.getNode();
        if (netCircuitNode == null || netCircuitNode.circuit.getState() == 0) {
            return;
        }
        Connection connection = selectorConnection == null ? null : selectorConnection.getSelectorHead();
        String string2 = string = stringBuffer.toString();
        Connection connection2 = netCircuitSpan.getPeerConnection(this);
        List list = connection2.getInSpans();
        NetCircuitSpan netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        boolean bl3 = netCircuitSpan != null && netCircuitSpan2 != null && netCircuitSpan.getLink() != null && netCircuitSpan2.getLink() != null && netCircuitSpan.getLink().inBLSR() && netCircuitSpan2.getLink().inBLSR();
        boolean bl4 = bl2 = connection2 != null && connection2.equals(connection);
        if (string2.equals("unprotected") && bl2 && bl3) {
            string2 = "true";
        } else if (string2.toString().equals("protected")) {
            string2 = connection2 != null && connection2.hasPcaOutput() ? "false" : "true";
        }
        boolean bl5 = bl = netCircuitNode != null && netCircuitSpan.getLink() != null && netCircuitSpan.getLink().isPca(netCircuitNode.getNetElement());
        if (bl) {
            string2 = "true";
        }
        if (!string.equals(string2)) {
            stringBuffer.replace(0, stringBuffer.length(), string2);
            if (this.dbgOn()) {
                db.println("markSecondarySpan: secondaryPathState changed from " + string + " to " + stringBuffer);
            }
        }
        if (string2.toString().equals("true") && netCircuitSpan.getNetLinkSpan() != null && !netCircuitSpan.getNetLinkSpan().isSecondaryCircuit()) {
            if (this.dbgOn()) {
                db.println("markSecondarySpan: set true on span " + netCircuitSpan.getNetLinkSpan().prettyString());
            }
            netCircuitSpan.getNetLinkSpan().setSecondaryCircuit(true);
        }
    }

    protected boolean hasPcaOutput() {
        Iterator iterator = this.getOutSpans().iterator();
        NetCircuitNode netCircuitNode = this.getNode();
        while (netCircuitNode != null && iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (netCircuitSpan.getLink() == null || !netCircuitSpan.getLink().isPca(netCircuitNode.getNetElement())) continue;
            return true;
        }
        return false;
    }

    protected boolean isBlsrDriPath(SelectorConnection selectorConnection, NetCircuitSpan netCircuitSpan) {
        Connection connection;
        if (this.qualifiesPathAsBlsrDri(selectorConnection, netCircuitSpan)) {
            return true;
        }
        Connection connection2 = connection = selectorConnection == null ? null : selectorConnection.getSelectorHead();
        if (this.equals(connection)) {
            if (this.dbgOn()) {
                db.println("isBlsrDriPath: terminating at head on node " + this.getNodeName());
            }
            return false;
        }
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("isBlsrDriPath: terminating on a null inSpan on node " + this.getNodeName());
            }
            return false;
        }
        Connection connection3 = netCircuitSpan.getPeerConnection(this);
        if (connection3 == null) {
            if (this.dbgOn()) {
                db.println("isBlsrDriPath: terminating on a null peer connection on node " + this.getNodeName());
            }
            return false;
        }
        if (connection3 instanceof SelectorConnection) {
            if (this.dbgOn()) {
                db.println("isBlsrDriPath: terminating on a selector on node " + connection3.getNodeName());
            }
            return false;
        }
        List list = connection3.getInSpans();
        NetCircuitSpan netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        boolean bl = this.loopFound() ? false : connection3.isBlsrDriPath(selectorConnection, netCircuitSpan2);
        this.loopFlag = false;
        return bl;
    }

    private boolean qualifiesPathAsBlsrDri(SelectorConnection selectorConnection, NetCircuitSpan netCircuitSpan) {
        NetCircuitSpan netCircuitSpan2 = this.getExternalInSpan(netCircuitSpan);
        boolean bl = netCircuitSpan2 != null && netCircuitSpan2.getLink() != null && netCircuitSpan2.getLink().inBLSR();
        return bl && this.isBlsrDriHandoff() && !this.isUpsrHead3Profile();
    }

    protected int markBlsrDriHandoffs(SelectorConnection selectorConnection, Connection connection, NetCircuitSpan netCircuitSpan) {
        return this.markBlsrDriHandoffs(selectorConnection, connection, netCircuitSpan, 0);
    }

    private int markBlsrDriHandoffs(SelectorConnection selectorConnection, Connection connection, NetCircuitSpan netCircuitSpan, int n) {
        NetCircuitSpan netCircuitSpan2;
        n += this.markBlsrDriHandoff();
        if (this.equals(connection)) {
            if (this.dbgOn()) {
                db.println("markBlsrDriHandoffs: terminating at head on node " + this.getNodeName());
            }
            return n;
        }
        if (netCircuitSpan == null) {
            if (this.dbgOn()) {
                db.println("markBlsrDriHandoffs: terminating on a null inSpan on node " + this.getNodeName());
            }
            return n;
        }
        Connection connection2 = netCircuitSpan.getPeerConnection(this);
        if (connection2 == null) {
            if (this.dbgOn()) {
                db.println("markBlsrDriHandoffs: terminating on a null peer connection on node " + this.getNodeName());
            }
            return n;
        }
        if (connection2 instanceof SelectorConnection) {
            n += connection2.markBlsrDriHandoff();
            if (this.dbgOn()) {
                db.println("markBlsrDriHandoffs: terminating on a selector on node " + connection2.getNodeName());
            }
            return n;
        }
        List list = connection2.getInSpans();
        NetCircuitSpan netCircuitSpan3 = netCircuitSpan2 = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
        if (!this.loopFound()) {
            n = connection2.markBlsrDriHandoffs(selectorConnection, connection, netCircuitSpan2, n);
        }
        this.loopFlag = false;
        return n;
    }

    protected int markBlsrDriHandoff() {
        NetCircuitNode netCircuitNode;
        if (this.isBlsrDriHandoff() && (netCircuitNode = this.getNode()) != null && !netCircuitNode.getDri()) {
            netCircuitNode.setDri(true);
            return 1;
        }
        return 0;
    }

    protected NetCircuitNode getNode() {
        NetCircuitNode netCircuitNode = this.getNode(this.inPuts.iterator());
        if (netCircuitNode == null) {
            netCircuitNode = this.getNode(this.outPuts.iterator());
        }
        return netCircuitNode;
    }

    private NetCircuitNode getNode(Iterator iterator) {
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan;
            Object e = iterator.next();
            if (!(e instanceof NetCircuitSpan)) continue;
            NetCircuitSpan netCircuitSpan2 = netCircuitSpan = this.inPuts.contains(e) ? this.getExternalInSpan((NetCircuitSpan)e) : (NetCircuitSpan)e;
            if (netCircuitSpan == null) {
                return null;
            }
            INetCircuit iNetCircuit = netCircuitSpan.getCircuit();
            if (iNetCircuit == null) continue;
            NetCircuitNode netCircuitNode = (NetCircuitNode)netCircuitSpan.getSrcNCN();
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)netCircuitSpan.getDstNCN();
            if (netCircuitNode != null && netCircuitNode.connections.contains(this)) {
                return netCircuitNode;
            }
            if (netCircuitNode2 == null || !netCircuitNode2.connections.contains(this)) continue;
            return netCircuitNode2;
        }
        return null;
    }

    protected String getNodeName() {
        NetCircuitNode netCircuitNode = this.getNode();
        return netCircuitNode == null ? "?" : netCircuitNode.getName();
    }

    protected boolean dbgOn() {
        return (db.on() || NetCircuitManager.pkgDbgOn()) && !NetCircuitManager.pkgDbgSuppressed();
    }

    protected String getName() {
        return this.name;
    }

    protected void prettyString() {
        this.prettyString(db);
    }

    protected void prettyString(SDebug sDebug) {
        if (!sDebug.on() && !NetCircuitManager.pkgDbgOn()) {
            return;
        }
        sDebug.println("      name: " + this.getName());
        for (Object e : this.inPuts) {
            if (e instanceof InternalCircuitSpan) {
                sDebug.println("     input: " + ((NetCircuitSpan)e).prettyString());
                continue;
            }
            if (e instanceof NetCircuitSpan) {
                sDebug.println("     input: " + ((NetCircuitSpan)e).prettyString());
                continue;
            }
            if (!(e instanceof NetCircuitEnd)) continue;
            sDebug.println("     input: " + ((NetCircuitEnd)e).prettyString());
        }
        for (Object e : this.outPuts) {
            if (e instanceof InternalCircuitSpan) {
                sDebug.println("    output: " + ((NetCircuitSpan)e).prettyString());
                continue;
            }
            if (e instanceof NetCircuitSpan) {
                sDebug.println("    output: " + ((NetCircuitSpan)e).availSpan.prettyString());
                continue;
            }
            if (!(e instanceof NetCircuitEnd)) continue;
            sDebug.println("    output: " + ((NetCircuitEnd)e).prettyString());
        }
    }
}

