/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.Feature;
import cerent.cms.model.HoPathDefModel;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IVlanModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.util.IHoLoNum;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.SDebug;

public class HoCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("HoCircuitEnd");

    protected HoCircuitEnd() {
    }

    public HoCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd) {
        super(iNodeModel, iCircuitEnd);
    }

    public HoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        super(iNodeModel, iEntityModel, iHoNum, iLoNum, bl);
    }

    public HoCircuitEnd(INodeModel iNodeModel, IEntityModel iEntityModel, IHoLoNum iHoLoNum, boolean bl) {
        this(iNodeModel, iEntityModel, iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), bl);
    }

    public HoCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
        this.setLoNum(null);
    }

    public HoCircuitEnd(INetElement iNetElement, Object object, int n) {
        IHoPathDefModel iHoPathDefModel;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        IHoNum iHoNum = null;
        int n2 = 0;
        int n3 = 0;
        if (object instanceof IHoPathDefModel) {
            iHoPathDefModel = (IHoPathDefModel)object;
            iHoNum = HoPathDefModel.physicalHo(iHoPathDefModel);
            n2 = 4;
            n3 = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.VCAT) ? (int)iHoPathDefModel.getPathIdentifier() : 0;
        } else if (this.dbgOn()) {
            this.debug("Warning! NetCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n, iHoNum, null, false, n3));
        try {
            iHoPathDefModel = iNodeModel.getEntityTable().getEntityModelByIndex(n);
            if (iHoPathDefModel != null && HoCircuitEnd.autoAssignCheck((IEntityModel)iHoPathDefModel)) {
                this.setHoNum(null);
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            iHoPathDefModel = null;
        }
        this.setStage(n2);
    }

    public static boolean autoAssignCheck(IEntityModel iEntityModel) {
        IModuleModel iModuleModel;
        boolean bl = false;
        int n = iEntityModel.getPayloadType();
        if (n == 6 || n == 8 || n == 14 || n == 13 || n == 17 || n == 18 || n == 20) {
            bl = true;
        } else if (n == 19 && Feature.provides((INodeModel)iEntityModel.getNodeModel(), (Feature)Feature.HOLO_ETHER_PROVISION_MODE) && (iModuleModel = iEntityModel.getModuleModel()) != null && iModuleModel.isAutoProvisionMode()) {
            bl = true;
        }
        return bl;
    }

    @Override
    public Object getPathDef(short s) throws ObjNotFound {
        IPoolModel iPoolModel = this.getHoPool();
        if (iPoolModel == null) {
            throw new ObjNotFound("unable to get hoPool");
        }
        HoPathDefModel hoPathDefModel = new HoPathDefModel(iPoolModel, s, this.getRelativeHoNum(iPoolModel), (short)this.getPathIdentifier());
        return hoPathDefModel;
    }

    protected void createEtherBridge(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) throws CTCUserException, AbstractCmsIOException {
    }

    protected void destroyEtherBridge(ICircuitId iCircuitId) throws SanityCheckFailed {
    }

    protected void changeVlanSet(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) {
    }

    protected boolean changeVlanSetCheck(ICircuitId iCircuitId, IVlanModel[] iVlanModelArray) {
        return false;
    }

    @Override
    protected boolean onXm() {
        if (Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.DS3XM12)) {
            try {
                if (this.getEntityModel().onPortlessPort()) {
                    return true;
                }
            }
            catch (ObjNotFound objNotFound) {
                // empty catch block
            }
        }
        return false;
    }

    @Override
    protected boolean usePairPortlessPorts(NetCircuitEnd netCircuitEnd) {
        if (this.getNodeId() != netCircuitEnd.getNodeId()) {
            return false;
        }
        if (!Feature.provides((INodeModel)this.getNodeModel(), (Feature)Feature.DS3XM12)) {
            return false;
        }
        try {
            if (this.dbgOn()) {
                this.debug("usePairPortlessPorts(" + netCircuitEnd.prettyString() + ")");
            }
            if (this.getEntityModel().onPairPortlessPorts(netCircuitEnd.getEntityModel())) {
                if (this.dbgOn()) {
                    this.debug("usePairPortlessPorts() => true");
                }
                return true;
            }
        }
        catch (ObjNotFound objNotFound) {
            // empty catch block
        }
        return false;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }
}

