/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.ConnectionTypeError;
import cerent.cms.model.DeleteInstead;
import cerent.cms.model.Feature;
import cerent.cms.model.IBridgePortInfo;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IDriNodeType;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoRollModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.EtherP2PCircuitEnd;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.HoCircuitNodeOperator;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSplicer;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.YCircuitNodeController;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class HoCircuitNode
extends NetCircuitNode {
    private static final SDebug db = new SDebug("HoCircuitNode");
    private IHoConnectionModel hoConn;
    private List bridgeInfo;
    YCircuitNodeController yController;
    public boolean hasYCircuits;
    private Object bridgeInfoLockObject;
    private boolean ingressOnXm;
    protected HoCircuitNodeOperator operator;

    public HoCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit) {
        super(iNetElement, hoCcatCircuit);
        this.connName = hoCcatCircuit.getCircuitName();
        this.cktId = new CircuitId(0, 0);
        this.serviceState = -2;
        this.bridgeInfoLockObject = new Object();
        this.bridgeInfo = null;
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.operator = new HoCircuitNodeOperator(this);
        this.ingressOnXm = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HoCircuitNode(INetElement iNetElement, HoCcatCircuit hoCcatCircuit, Object object) throws AbstractCmsObjectNotExistException {
        super(iNetElement, hoCcatCircuit, object);
        this.connName = this.getConnNameFromNE();
        this.driNodeType = this.getDriNodeTypeFromModelLayer();
        if (this.driNodeType == 1 || this.driNodeType == 2) {
            this.setDri(true);
        }
        if (this.dbgOn()) {
            db.println(" driNodeType " + EnumStrings.getString(IDriNodeType.class, (int)this.driNodeType));
        }
        hoCcatCircuit.setChanged();
        this.bridgeInfoLockObject = new Object();
        this.bridgeInfo = null;
        this.pathWidth = hoCcatCircuit.getCircuitSizeObj().size2widthOfHoCircuit();
        this.operator = new HoCircuitNodeOperator(this);
        this.ingressOnXm = false;
        Object object2 = this.entitiesLockObject;
        synchronized (object2) {
            this.updateUpsrEntities(true);
        }
    }

    @Override
    protected void sanityCheckConnModel() {
        this.getConnTypeFromConnModel();
    }

    @Override
    protected int getConnTypeFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getIntendedType();
        }
        return 22;
    }

    @Override
    protected void setConnTypeInConnModel(int n) throws ConnectionTypeError, ConnectionInTopologyUpgrade, ConnectionInLoopback, ConnectionInTestAccess, ConnectionInRoll {
        if (this.hoConn != null) {
            if (this.dbgOn()) {
                db.println("changing intended type for HO connection");
            }
            this.hoConn.changeIntendedType(n);
        }
    }

    @Override
    protected void addOutputToConnModel(NetCircuitEnd netCircuitEnd) throws CTCUserException {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)((HoCircuitEnd)netCircuitEnd).getPathDef(this.pathWidth);
            this.hoConn.addOutput(iHoPathDefModel);
        }
    }

    @Override
    protected void addOutputToConnModel(NetCircuitSpan netCircuitSpan) throws CTCUserException {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
            this.hoConn.addOutput(iHoPathDefModel);
        }
    }

    @Override
    protected void addSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        super.addSpliceListener(spliceListenerEntry);
        int n = this.getADMoBTrunkPort(spliceListenerEntry.spliceLinkIndex.entityIndex);
        if (n != 0) {
            if (this.dbgOn()) {
                this.debug("addSpliceListener for ADMTrunkPort (" + Integer.toHexString(n) + ") at " + this.getName());
            }
            SpliceListener spliceListener = new SpliceListener(null, null, this.getTrunkPortChannel(n), this, true);
            SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, n, eSpanDirection.ORIGINATING);
            SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
            this.addAditListener(spliceListenerEntry2);
            spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, n, eSpanDirection.TERMINATING);
            spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
            this.addAditListener(spliceListenerEntry2);
        }
    }

    @Override
    protected void removeSpliceListener(SpliceListenerEntry spliceListenerEntry) {
        super.removeSpliceListener(spliceListenerEntry);
        int n = this.getADMoBTrunkPort(spliceListenerEntry.spliceLinkIndex.entityIndex);
        if (n != 0) {
            NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.instance();
            if (this.dbgOn()) {
                this.debug("removeSpliceListener for ADMTrunkPort (" + Integer.toHexString(n) + ") at " + this.getName());
            }
            if (spliceListenerEntry.spliceListener.loAdit) {
                return;
            }
            SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, n, eSpanDirection.ORIGINATING);
            SpliceListener spliceListener = new SpliceListener(null, null, this.getTrunkPortChannel(n), this, true);
            SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex, spliceListener);
            boolean bl = this.spliceListeners.remove(spliceListenerEntry2);
            if (bl) {
                netCircuitSplicer.cancelCallback(spliceListenerEntry2);
                if (this.dbgOn()) {
                    this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
                }
            }
            if (bl = this.spliceListeners.remove(spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex = new SpliceLinkIndex(spliceListenerEntry.spliceLinkIndex.ne, n, eSpanDirection.TERMINATING), spliceListener))) {
                netCircuitSplicer.cancelCallback(spliceListenerEntry2);
                if (this.dbgOn()) {
                    this.debug("Removed loAditSpliceListener(" + spliceListenerEntry2.prettyString() + ") at " + this.getName());
                }
            }
        }
    }

    public boolean isADMoBCard(IEntityModel iEntityModel) {
        IModuleModel iModuleModel;
        boolean bl = false;
        INodeModel iNodeModel = this.getNodeModel();
        if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM) && (iModuleModel = iEntityModel.getModuleModel()) instanceof IDwdmModuleModel) {
            IDwdmModuleModel iDwdmModuleModel = (IDwdmModuleModel)iModuleModel;
            bl = iDwdmModuleModel.isADMCard();
        }
        if (this.dbgOn()) {
            this.debug("isADMoBCard() == " + bl);
        }
        return bl;
    }

    public int getADMoBTrunkPort(int n) {
        int n2;
        block4: {
            n2 = 0;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM)) {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                try {
                    IDwdmModuleModel iDwdmModuleModel;
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    IModuleModel iModuleModel = iEntityModel.getModuleModel();
                    if (iModuleModel instanceof IDwdmModuleModel && (iDwdmModuleModel = (IDwdmModuleModel)iModuleModel).isADMCard() && iEntityModel instanceof ITdmPortModel) {
                        ITdmPortModel iTdmPortModel = (ITdmPortModel)iEntityModel;
                        n2 = iTdmPortModel.getADMobTrunkPort();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block4;
                    db.println("getADMoBTrunkPort: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return n2;
    }

    private int getTrunkPortChannel(int n) {
        int n2;
        block4: {
            n2 = 0;
            INodeModel iNodeModel = this.getNodeModel();
            if (iNodeModel.provides(Feature.STS_OVER_MSTP_ADM)) {
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                try {
                    IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                    if (iEntityModel instanceof IDwdmPortModel) {
                        IDwdmPortModel iDwdmPortModel = (IDwdmPortModel)iEntityModel;
                        n2 = iDwdmPortModel.getOptChannel();
                    }
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (!db.on()) break block4;
                    db.println("getTrunkPortChannel: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                }
            }
        }
        return n2;
    }

    @Override
    protected void removeOutputFromConnModel(NetCircuitEnd netCircuitEnd) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, CTCUserException {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)((HoCircuitEnd)netCircuitEnd).getPathDef(this.pathWidth);
            this.hoConn.removeOutput(iHoPathDefModel);
        }
    }

    @Override
    protected void removeOutputFromConnModel(NetCircuitSpan netCircuitSpan) throws InvalidPath, DeleteInstead, ConnectionTypeError, ObjNotFound, PathInUse, NoMoreLoCapableHo, CTCUserException {
        if (this.hoConn != null) {
            IHoPathDefModel iHoPathDefModel = (IHoPathDefModel)netCircuitSpan.getPathDef(this.getNetElement(), this.pathWidth);
            this.hoConn.removeOutput(iHoPathDefModel);
        }
    }

    @Override
    protected Object[] getPathsFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            Object[] objectArray = iHoConnectionModel.getPaths();
            IRollModel iRollModel = this.getRoll();
            if (iRollModel == null) {
                if (this.dbgOn()) {
                    db.println("the connection is NOT involved in the roll");
                }
                return objectArray;
            }
            if (this.dbgOn()) {
                db.println("the connection is involved in the roll");
            }
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray.length; ++i) {
                objectArray2[i] = this.isCompletedRollToPath(objectArray[i], iRollModel) ? this.getRollFromPath(iRollModel) : objectArray[i];
            }
            return objectArray2;
        }
        if (this.dbgOn()) {
            db.println("getPathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    @Override
    protected Object[] getActivePathsFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getActivePaths();
        }
        if (this.dbgOn()) {
            db.println("getActivePathsFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return new LinkedList().toArray();
    }

    @Override
    protected int getProtectionOpFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return -1;
    }

    @Override
    protected int getReverseProtectionOpFromConnModel() {
        IHoConnectionModel iHoConnectionModel = this.hoConn;
        if (iHoConnectionModel != null) {
            return iHoConnectionModel.getReverseProtectionOp();
        }
        if (this.dbgOn()) {
            db.println("getProtectionOpFromConnModel @ Node " + this.getName() + " with connection object deleted");
        }
        return -1;
    }

    protected boolean hasP2pEtherCktEnd() {
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)iterator.next();
                if (!hoCircuitEnd.isEtherP2PCircuitEnd()) continue;
                return true;
            }
            iterator = this.drops.iterator();
        }
        return false;
    }

    protected List getP2pEtherCktEnd() {
        LinkedList<HoCircuitEnd> linkedList = new LinkedList<HoCircuitEnd>();
        Iterator iterator = this.sources.iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                HoCircuitEnd hoCircuitEnd = (HoCircuitEnd)iterator.next();
                if (!hoCircuitEnd.isEtherP2PCircuitEnd()) continue;
                linkedList.add(hoCircuitEnd);
            }
            iterator = this.drops.iterator();
        }
        return linkedList;
    }

    @Override
    public boolean eligibleForEtherHoDropAdd() {
        return this.getConnectionType() == 8 && this.biSpans.size() + this.drops.size() < 2;
    }

    @Override
    public int totalSpans() {
        return this.inSpans.size() + this.outSpans.size() + this.biSpans.size();
    }

    @Override
    protected void activate() throws CircuitProvError {
        super.activate();
        this.numberOfPaths += this.onXm() ? 1 : 0;
    }

    @Override
    protected int findUpgradedConnType() {
        if (this.dbgOn()) {
            db.println("finding upgraded connection type for Node " + this.getName());
        }
        if (this.circuit.isBidirectional()) {
            if (this.biSpans.size() > 2) {
                return 22;
            }
            if (this.nodeDrop != null) {
                return 8;
            }
            return this.getConnectionType();
        }
        int n = this.countRoutedOutputs();
        if (this.getConnectionType() == 1 && n > 0) {
            return 6;
        }
        return this.getConnectionType();
    }

    @Override
    protected int findConnType() {
        int n = this.countNumInputs();
        int n2 = this.countNumOutputs();
        int n3 = n + n2;
        if (this.nodeDrop != null && this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
            if (n3 > 2) {
                return 22;
            }
            if (n3 == 0 && this.circuit.getCktNodeListSize() != 1) {
                return 22;
            }
            return 8;
        }
        return super.findConnType();
    }

    protected NetCircuitSpan findNextBiSpanOnRoute(NetCircuitSpan netCircuitSpan) {
        IEntityModel[] iEntityModelArray = null;
        if (this.hoConn != null) {
            iEntityModelArray = this.hoConn.getPathEntities();
        }
        return this.findNextBiSpanOnRoute(iEntityModelArray, netCircuitSpan);
    }

    @Override
    public void setConnectionCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the connection circuit Id at " + this.getName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        ICircuitId iCircuitId2 = this.cktId;
        if (this.hoConn != null) {
            boolean bl = false;
            boolean bl2 = false;
            if (this.isEtherStitched()) {
                try {
                    ((EtherNodeDropCircuitEnd)this.nodeDrop).destroyEtherBridge(iCircuitId2);
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    bl = true;
                }
                if (!bl) {
                    this.hoConn.setCircuitId(iCircuitId);
                    this.cktId = iCircuitId;
                    try {
                        ((EtherNodeDropCircuitEnd)this.nodeDrop).createEtherBridge(iCircuitId, this.circuit.getVlans());
                    }
                    catch (CTCUserException cTCUserException) {
                        bl2 = true;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        bl2 = true;
                    }
                }
            } else if (this.hasP2pEtherCktEnd()) {
                for (EtherP2PCircuitEnd etherP2PCircuitEnd : this.getP2pEtherCktEnd()) {
                    try {
                        etherP2PCircuitEnd.destroyEtherBridge(iCircuitId2);
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        bl = true;
                    }
                    if (bl) continue;
                    this.hoConn.setCircuitId(iCircuitId);
                    this.cktId = iCircuitId;
                    try {
                        etherP2PCircuitEnd.createEtherBridge(iCircuitId, this.circuit.getVlans());
                    }
                    catch (CTCUserException cTCUserException) {
                        bl2 = true;
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        bl2 = true;
                    }
                }
            } else {
                this.hoConn.setCircuitId(iCircuitId);
                this.cktId = iCircuitId;
            }
            if (bl) {
                if (this.dbgOn()) {
                    db.println("Unable to destroy ether bridge");
                }
            } else if (bl2 && this.dbgOn()) {
                db.println("Able to destroy ether bridge, but unable to create new one with new circuit id");
            }
            if (!NetCircuit.isNullCircuitId(iCircuitId)) {
                this.deregisterNullCircuitConnection(this.getNetElement(), this.hoConn);
            }
        }
    }

    @Override
    public ICircuitId getConnectionCircuitId() {
        ICircuitId iCircuitId = null;
        try {
            if (this.hoConn != null) {
                iCircuitId = this.hoConn.getCircuitId();
            }
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            // empty catch block
        }
        if (this.dbgOn() && iCircuitId == null) {
            db.println("getConnectionCircuitId: node " + this.getName() + " with connection object deleted");
        }
        return iCircuitId;
    }

    @Override
    protected int getUpsrReversionMode() {
        if (this.hoConn != null) {
            return this.hoConn.getUpsrReversion().getReversionMode();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean isAnyChangeInEtherStpState() {
        IBridgePortInfo[] iBridgePortInfoArray;
        boolean bl = false;
        if (!this.hasConnection()) {
            return bl;
        }
        if (this.hoConn == null) {
            return bl;
        }
        try {
            iBridgePortInfoArray = this.hoConn.getBridgePortInfoList();
        }
        catch (NoSuchInterface noSuchInterface) {
            db.println("Exception caught in isAnyChangeInEtherStpState");
            SDebug.printStackTrace((Throwable)noSuchInterface);
            return bl;
        }
        if (iBridgePortInfoArray == null) {
            if (this.dbgOn()) {
                db.println("isAnyChangeInEtherStpState: null portInfo at " + this.getName());
            }
            return bl;
        }
        Object object = this.bridgeInfoLockObject;
        synchronized (object) {
            if (this.bridgeInfo == null) {
                this.bridgeInfo = new LinkedList();
            }
            if (iBridgePortInfoArray.length != this.bridgeInfo.size()) {
                bl = true;
            }
            if (!bl) {
                IBridgePortInfo[] iBridgePortInfoArray2 = this.bridgeInfo.toArray(new IBridgePortInfo[0]);
                for (int i = 0; i < iBridgePortInfoArray.length; ++i) {
                    if (iBridgePortInfoArray[i].getPortState() == iBridgePortInfoArray2[i].getPortState()) continue;
                    bl = true;
                    break;
                }
            }
            if (bl) {
                this.bridgeInfo.clear();
                this.bridgeInfo.addAll(Arrays.asList(iBridgePortInfoArray));
            }
        }
        return bl;
    }

    @Override
    public IConnectionModel getConn() {
        return this.hoConn;
    }

    @Override
    protected void setConn(IConnectionModel iConnectionModel) {
        this.hoConn = (IHoConnectionModel)iConnectionModel;
    }

    @Override
    public boolean isUpsr() {
        return this.upsrOps != null;
    }

    protected boolean isEtherStitched() {
        return this.getConnectionType() == 8;
    }

    @Override
    protected boolean isForwardingSpan(NetCircuitSpan netCircuitSpan, NetCircuitNode netCircuitNode) {
        return this.isForwardingSpan(netCircuitSpan, (HoCircuitNode)netCircuitNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isForwardingSpan(NetCircuitSpan netCircuitSpan, HoCircuitNode hoCircuitNode) {
        IEntityModel[] iEntityModelArray;
        ICircuitId iCircuitId;
        if (hoCircuitNode == this) {
            if (this.dbgOn()) {
                db.println("isFwdSpan: Checking node " + this.getName() + " has already been visited");
            }
            return true;
        }
        if (hoCircuitNode == null) {
            hoCircuitNode = this;
        }
        if ((iCircuitId = this.circuit.getCircuitId()) == null) {
            return true;
        }
        if (this.hoConn == null) {
            if (this.dbgOn()) {
                db.println("isForwardingSpan: hoConn is null!");
            }
            return true;
        }
        NetCircuitNode netCircuitNode = null;
        IBridgePortInfo iBridgePortInfo = null;
        IBridgePortInfo iBridgePortInfo2 = null;
        Object object = this.bridgeInfoLockObject;
        synchronized (object) {
            if (this.bridgeInfo == null) {
                this.bridgeInfo = new LinkedList();
                this.isAnyChangeInEtherStpState();
            }
            if ((iEntityModelArray = this.bridgeInfo.iterator()).hasNext()) {
                iBridgePortInfo = (IBridgePortInfo)iEntityModelArray.next();
            }
            if (iEntityModelArray.hasNext()) {
                iBridgePortInfo2 = (IBridgePortInfo)iEntityModelArray.next();
            }
        }
        if (iBridgePortInfo2 != null || iBridgePortInfo != null) {
            int n = netCircuitSpan.getEntityIndex(this.getNetElement());
            iEntityModelArray = this.hoConn.getPathEntities();
            Iterator<IEntityModel> iterator = Arrays.asList(iEntityModelArray).iterator();
            int n2 = 0;
            boolean bl = false;
            while (iterator.hasNext()) {
                IEntityModel iEntityModel = iterator.next();
                if (iEntityModel.getEntityIndex() == n) {
                    bl = true;
                    break;
                }
                ++n2;
            }
            IBridgePortInfo iBridgePortInfo3 = null;
            if (!bl) {
                if (this.dbgOn()) {
                    db.println("isForwardingSpan: No nodeIndex match!!");
                }
                return true;
            }
            if (n2 == 0) {
                iBridgePortInfo3 = iBridgePortInfo;
            } else if (n2 == 1) {
                iBridgePortInfo3 = iBridgePortInfo2;
            } else {
                if (this.dbgOn()) {
                    db.println("isForwardingSpan: invalid nodeIndex match!! " + n2);
                }
                return true;
            }
            if (iBridgePortInfo3 == null && this.circuit.isEthernet() && !this.circuit.getCircuitTypeObj().isEthernetCircuitType()) {
                iBridgePortInfo3 = iBridgePortInfo != null ? iBridgePortInfo : iBridgePortInfo2;
            }
            if (iBridgePortInfo3 != null) {
                return iBridgePortInfo3.getPortState() == 5;
            }
            if (this.dbgOn()) {
                db.println("isFwdSpan: Index match " + n2 + ", but portInfo is null! ");
            }
            return true;
        }
        NetCircuitSpan netCircuitSpan2 = this.findNextBiSpanOnRoute(netCircuitSpan);
        if (netCircuitSpan2 == null) {
            return true;
        }
        netCircuitNode = this.spanGetPeer(netCircuitSpan2);
        if (netCircuitNode == null) {
            if (this.dbgOn()) {
                db.println("isForwardingSpan: no peernode for " + netCircuitSpan2.prettyString());
            }
            return true;
        }
        return netCircuitNode.isForwardingSpan(netCircuitSpan2, hoCircuitNode);
    }

    @Override
    public boolean getCktNodeStpEnabled() {
        if (!Network.instance().getNetElem(this.hoConn.getNodeModel().getNodeId()).getNodeModel().provides(Feature.BACKEND_STP)) {
            if (this.dbgOn()) {
                db.println("disabling TDM port STP not supported");
            }
            return true;
        }
        return this.hoConn != null && this.hoConn.getStpEnabled();
    }

    @Override
    public boolean hasXcLoopback() {
        boolean bl;
        block5: {
            bl = false;
            if (this.hoConn != null && this.getNodeModel().provides(Feature.HASXCLPBK_IFACE)) {
                try {
                    bl = this.hoConn.hasXcLoopback();
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    if (db.on()) {
                        db.println("Caught exception in hasXcLoopback!");
                        SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                    }
                }
                catch (InvalidPath invalidPath) {
                    if (!db.on()) break block5;
                    db.println("Caught exception in hasXcLoopback!");
                    SDebug.printStackTrace((Throwable)invalidPath);
                }
            }
        }
        return bl;
    }

    @Override
    protected Object getRollFromPath(IRollModel iRollModel) {
        IHoRollModel iHoRollModel = (IHoRollModel)iRollModel;
        if (iHoRollModel != null) {
            return iHoRollModel.getRollFromPath();
        }
        return null;
    }

    @Override
    protected Object getRollToPath(IRollModel iRollModel) {
        IHoRollModel iHoRollModel = (IHoRollModel)iRollModel;
        if (iHoRollModel != null) {
            return iHoRollModel.getRollToPath();
        }
        return null;
    }

    @Override
    protected boolean isCompletedRollToPath(Object object, IRollModel iRollModel) {
        IHoRollModel iHoRollModel = (IHoRollModel)iRollModel;
        if (iHoRollModel == null) {
            return false;
        }
        try {
            if (iHoRollModel.getRollFinish() == 3) {
                NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), this.getRollToPath((IRollModel)iHoRollModel));
                NetCircuitEnd netCircuitEnd2 = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), object);
                if (netCircuitEnd2.equals(netCircuitEnd)) {
                    this.rollHasCompleted = true;
                    return true;
                }
            }
        }
        catch (Exception exception) {
            return false;
        }
        return false;
    }

    @Override
    protected IRollModel getRoll() {
        IHoRollModel iHoRollModel = null;
        if (this.inRoll()) {
            try {
                iHoRollModel = this.getConn().getNodeModel().getConnectionModels().getHoRollModels(this.getConn().getIndex());
            }
            catch (NoSuchConnection noSuchConnection) {
                iHoRollModel = null;
            }
        }
        return iHoRollModel;
    }

    @Override
    protected boolean isIngressOnXm() {
        return this.ingressOnXm;
    }

    protected void setIngressOnXm(boolean bl) {
        this.ingressOnXm = bl;
    }

    @Override
    protected boolean onXm() {
        if (!this.circuit.getXmCircuitEnds().isEmpty() && ((NetCircuitEnd)this.circuit.getXmCircuitEnds().get(0)).getNodeId() == this.getNodeModel().getNodeId()) {
            return true;
        }
        Object[] objectArray = this.getPathsFromConnModel();
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(this.getNetElement(), objectArray[i]);
            if (!netCircuitEnd.onXm()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected NetCircuitNodeOperator getOperator() {
        return this.operator;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    public void setYController(YCircuitNodeController yCircuitNodeController) {
        this.yController = yCircuitNodeController;
        this.yController.addObserver(this);
        this.hasYCircuits = true;
    }

    public void deleteController() {
        if (this.dbgOn()) {
            db.println("Deleting YController...");
        }
        this.hasYCircuits = false;
        this.yController.destroy();
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IHoConnectionModel) {
            super.update(iObservable, object);
        } else if (iObservable instanceof YCircuitNodeController && ((Integer)object).equals(ModelUpdateType.DELETED)) {
            if (this.yState == 3) {
                this.yState = 1;
            }
            this.hasYCircuits = false;
        }
    }
}

