/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.fv.net.IFvLinkModel;
import cerent.cms.fv.net.IFvNetElement;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkPhysicalType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IServerTrailLinkId;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.ISrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptCompositeNetLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Topology;
import cerent.util.IHoNum;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Observer;

public class InternalNetLink
extends CmsObservable
implements INetLink {
    INetElement srcNe;
    INetElement dstNe;
    int srcEntityIndex;
    int dstEntityIndex;
    protected int srcShelf = 1;
    protected int srcSlot = 0;
    protected int[] srcPort = new int[0];
    protected IHoNum srcHo;
    protected int dstShelf = 1;
    protected int dstSlot = 0;
    protected int[] dstPort = new int[0];
    protected IHoNum dstHo;
    protected static SDebug db = new SDebug("InternalNetLink");
    ArrayList linksList;
    private long timestamp;

    InternalNetLink(INetElement iNetElement, INetElement iNetElement2, int n, int n2, IHoNum iHoNum, IHoNum iHoNum2) {
        this.srcNe = iNetElement;
        this.dstNe = iNetElement2;
        this.srcEntityIndex = n;
        this.dstEntityIndex = n2;
        this.linksList = new ArrayList();
        this.linksList.add(this);
        this.timestamp = System.currentTimeMillis();
        this.acquireSrcSlotAndPort();
    }

    protected void acquireSrcSlotAndPort() {
        boolean bl;
        block10: {
            INodeModel iNodeModel = this.getSrc().getNodeModel();
            bl = false;
            if (iNodeModel.isInited()) {
                try {
                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                    if (iEntityTableModel != null) {
                        IEntityModel iEntityModel = iEntityTableModel.getEntityModelByIndex(this.getSrcEntityIndex());
                        if (iEntityModel != null) {
                            if (iNodeModel.provides(Feature.MULTISHELF)) {
                                this.srcShelf = iEntityModel.getShelfId();
                            }
                            this.srcSlot = iEntityModel.getSlot();
                            this.srcPort = InternalNetLink.getPortNum(iEntityModel);
                            if (this.srcSlot != 0 && this.srcPort.length > 0 && iNodeModel.getConnectionNotifier() != null && db.on()) {
                                db.println("acquireSrcSlotAndPort: deleting SRC NM ConnNotifier observer.");
                            }
                        } else {
                            bl = true;
                        }
                        break block10;
                    }
                    bl = true;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    bl = true;
                    if (db.on()) {
                        db.println("acquireSrcSlotAndPort: entity index invalid");
                    }
                    break block10;
                }
            }
            bl = true;
        }
        if (bl) {
            // empty if block
        }
    }

    protected static int[] getPortNum(IEntityModel iEntityModel) {
        if (iEntityModel instanceof IPortModel) {
            if (iEntityModel.getNodeModel().provides(Feature.EXP_PORT_NUM)) {
                return ((IPortModel)iEntityModel).getPortNum();
            }
            return new int[]{iEntityModel.getPort()};
        }
        return new int[0];
    }

    @Override
    public INetElement getSrc() {
        return this.srcNe;
    }

    @Override
    public int getSrcEntityIndex() {
        return this.srcEntityIndex;
    }

    @Override
    public int[] getSrcPortNumber() {
        return this.srcPort;
    }

    @Override
    public int getSrcSlotNumber() {
        return this.srcSlot;
    }

    @Override
    public int getSrcShelfNumber() {
        return this.srcShelf;
    }

    @Override
    public IHoNum getSrcHo() {
        return this.srcHo;
    }

    @Override
    public INetElement getDst() {
        return this.dstNe;
    }

    @Override
    public int getDstEntityIndex() {
        return this.dstEntityIndex;
    }

    @Override
    public int[] getDstPortNumber() {
        return this.dstPort;
    }

    @Override
    public int getDstSlotNumber() {
        return this.dstSlot;
    }

    @Override
    public int getDstShelfNumber() {
        return this.dstShelf;
    }

    @Override
    public IHoNum getDstHo() {
        return this.dstHo;
    }

    @Override
    public ILinkModel getLinkModel() {
        return null;
    }

    @Override
    public int getLinkType() {
        return 10;
    }

    @Override
    public ArrayList getLinksList() {
        return this.linksList;
    }

    @Override
    public ArrayList getNodesList() {
        ArrayList arrayList = null;
        arrayList.add(this.srcNe);
        arrayList.add(this.dstNe);
        return arrayList;
    }

    @Override
    public int getPhysicalType() {
        return 1;
    }

    @Override
    public ILinkPhysicalType getPhysicalTypeObj() {
        return null;
    }

    @Override
    public int getProtectionType() {
        return 3;
    }

    @Override
    public void setProtectionType(int n) {
    }

    @Override
    public boolean isSdccLink() {
        return false;
    }

    @Override
    public int getProtectionGroup() {
        return 0;
    }

    @Override
    public void setPhysicalType(int n) {
    }

    @Override
    public int getSrcLinkId() {
        return 0;
    }

    @Override
    public int getDstLinkId() {
        return 0;
    }

    @Override
    public void setCost(int n) {
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public void addSrlg(ISrg iSrg) throws SanityCheckFailed {
    }

    @Override
    public void removeSrlg(ISrg iSrg) throws SanityCheckFailed {
    }

    @Override
    public void clearSrlg() throws SanityCheckFailed {
    }

    @Override
    public LinkedList getSrlgList() throws SanityCheckFailed {
        return null;
    }

    @Override
    public IPoolModel getSrcPool() {
        return null;
    }

    @Override
    public IPoolModel getDstPool() {
        return null;
    }

    @Override
    public int state() {
        return 1;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public boolean isFullyUnprotected() {
        return true;
    }

    @Override
    public boolean isFullyProtected() {
        return false;
    }

    @Override
    public boolean isFullyLineProtected() {
        return false;
    }

    @Override
    public String prettyString() {
        return this.srcNe.prettyString() + "(" + Integer.toHexString(this.srcEntityIndex) + (this.srcHo == null ? "" : ":" + this.srcHo) + ")" + "->" + this.dstNe.prettyString() + "(" + Integer.toHexString(this.dstEntityIndex) + (this.dstHo == null ? "" : ":" + this.dstHo) + "). " + "(" + "Internal Link" + ", " + "State=" + "Up).";
    }

    @Override
    public String prettyStringDetail() {
        return new String("Pretty string Internal Net Link - will add the description later !");
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public boolean isLOTunnel() {
        return false;
    }

    @Override
    public boolean isLAP() {
        return false;
    }

    @Override
    public boolean isOchTrailTunnel() {
        return false;
    }

    @Override
    public boolean isPhantom() {
        return false;
    }

    @Override
    public boolean isPca() {
        return false;
    }

    @Override
    public boolean isPca(INetElement iNetElement) {
        return false;
    }

    @Override
    public boolean inWorkingBLSR() {
        return false;
    }

    @Override
    public boolean isBlsrCapable() {
        return false;
    }

    @Override
    public boolean isLOCapable() {
        return false;
    }

    @Override
    public ILabelSet getSrcLabelSet(int n, int n2) {
        return null;
    }

    @Override
    public ILabelSet getDstLabelSet(int n, int n2) {
        return null;
    }

    @Override
    public INetLinkSpan[] getAllAvailSpans(int n, int n2) {
        return null;
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public List getAvailableHoNumbers(int n, int n2) {
        return null;
    }

    @Override
    public List getAvailableLoNumbers(IHoNum iHoNum, int n) {
        return null;
    }

    @Override
    public INetLinkSpan getAvailSpan(int n, int n2) {
        return null;
    }

    @Override
    public boolean availBW(RoutePrefs routePrefs) {
        return false;
    }

    @Override
    public boolean canSupportCircuitSize(int n, int n2) {
        return false;
    }

    @Override
    public boolean canSupportCircuitDirection(int n) {
        return false;
    }

    @Override
    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Topology getTopology() {
        return null;
    }

    @Override
    public int getTopoId() {
        return -1;
    }

    @Override
    public long getOspfAreaId() {
        return -1L;
    }

    @Override
    public void setSla(short s) {
    }

    @Override
    public Integer getSla() {
        return -1;
    }

    @Override
    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        return false;
    }

    @Override
    public boolean isRoutable() {
        return false;
    }

    @Override
    public int getEndProtectionSwitchState(boolean bl) {
        return -1;
    }

    @Override
    public short blsrRingId() {
        return -1;
    }

    @Override
    public boolean equals(Object object) {
        if (object instanceof InternalNetLink) {
            InternalNetLink internalNetLink = (InternalNetLink)object;
            if (!internalNetLink.getSrc().equals(this.srcNe)) {
                return false;
            }
            if (internalNetLink.getSrcEntityIndex() != this.getSrcEntityIndex()) {
                return false;
            }
            if (!internalNetLink.getDst().equals(this.dstNe)) {
                return false;
            }
            return internalNetLink.getDstEntityIndex() == this.getDstEntityIndex();
        }
        return false;
    }

    @Override
    public boolean physicalLinkEquals(INetLink iNetLink) {
        return false;
    }

    @Override
    public INetLink getReverseLink() {
        return null;
    }

    @Override
    public INetLink getCounterpartLink() {
        return null;
    }

    @Override
    public String originatingRingName() {
        return new String("Not applicable");
    }

    @Override
    public String terminatingRingName() {
        return new String("Not applicable");
    }

    @Override
    public boolean originatingInRing() {
        return false;
    }

    @Override
    public boolean terminatingInRing() {
        return false;
    }

    @Override
    public boolean shouldSrcDstLabelsMatch() {
        return false;
    }

    @Override
    public void containsSrg(Collection collection) throws xLinkNotUsable {
    }

    @Override
    public boolean inBLSR() {
        return false;
    }

    @Override
    public String blsrRingName() {
        return new String("Not applicable for internal net link");
    }

    @Override
    public String blsrRingName(INetElement iNetElement) {
        return new String("Not applicable for internal net link");
    }

    @Override
    public boolean isSrcExtendable() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public boolean isServerTrail() {
        return false;
    }

    @Override
    public IServerTrailLinkId getServerTrailId() {
        return null;
    }

    @Override
    public String getServerTrailIdString() {
        return new String("Not applicable for internal net link");
    }

    @Override
    public String getServerTrailCktSizeString() {
        return new String("Not applicable for internal net link");
    }

    @Override
    public int getProtectionRole() {
        return -1;
    }

    @Override
    public boolean isTemporarySptLink() {
        return false;
    }

    @Override
    public boolean needsSptCompositeLink(RoutePrefs routePrefs) {
        return false;
    }

    @Override
    public SptCompositeNetLink getSptCompositeLink(RoutePrefs routePrefs) {
        return null;
    }

    @Override
    public int getPhysicalSize() {
        return 0;
    }

    @Override
    public IHoNum get2fBlsrStartingPcaHo(boolean bl) {
        return null;
    }

    public void addObserver(Observer observer) {
    }

    public void addObserver(IObserver iObserver) {
    }

    public int countObservers() {
        return 0;
    }

    public void deleteObserver(Observer observer) {
    }

    public void deleteObserver(IObserver iObserver) {
    }

    public void deleteObservers() {
    }

    public boolean hasChanged() {
        return false;
    }

    public void setChanged() {
    }

    public void notifyObservers() {
    }

    public void notifyObservers(Object object) {
    }

    public IFvNetElement getDestination() {
        return this.dstNe;
    }

    public IFvNetElement getSource() {
        return this.srcNe;
    }

    public IFvLinkModel getTheLinkModel() {
        return null;
    }
}

