/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitMergeOperator;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class LoCcatCircuit
extends NetCcatCircuit {
    private static final SDebug db = new SDebug("LoCcatCircuit");
    private NetCcatCircuit myLap;
    private boolean lapLinkRemoved;
    public boolean isYCircuit;
    public Object loNum;

    protected LoCcatCircuit(CircuitCreatInfo circuitCreatInfo) {
        super(circuitCreatInfo);
        this.myLap = null;
        this.lapLinkRemoved = false;
    }

    protected LoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        super(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
        this.myLap = null;
        this.lapLinkRemoved = false;
    }

    protected LoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement, Object object) {
        super(circuitCreatInfo, iNetElement, object);
        this.lapLinkRemoved = false;
        this.clearChanged();
    }

    protected LoCcatCircuit(CircuitCreatInfo circuitCreatInfo, INodeModel iNodeModel, ICircuitModel iCircuitModel) throws AbstractCmsObjectNotExistException {
        this(circuitCreatInfo);
        this.lapLinkRemoved = false;
        this.initState(4);
        this.addDiscoveredCircuitInfo(iNodeModel, iCircuitModel);
        this.clearChanged();
    }

    @Override
    public void routeDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2;
        block6: {
            routePrefs2 = new RoutePrefs(routePrefs);
            INetCircuit iNetCircuit = this.useLAP();
            if (iNetCircuit == null) {
                iNetCircuit = this.ncMgr.getLAPHo(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum());
            }
            if (iNetCircuit != null && !routePrefs2.getRequiredLinks().contains(iNetCircuit.getLapLink()) && !routePrefs2.getRequiredLinks().contains(iNetCircuit.getReverseLapLink())) {
                LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
                if (this.useLAPOnSource() != null) {
                    linkedList.add(iNetCircuit.getLapLink());
                } else {
                    linkedList.add(iNetCircuit.getReverseLapLink());
                }
                try {
                    routePrefs2.setReqEntityList(linkedList);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!this.dbgOn()) break block6;
                    db.println("routeDrop: hit ObjDuplicate exception");
                }
            }
        }
        super.routeDrop(iNetCircuitEnd, routePrefs2);
    }

    protected void setLap() {
        this.myLap = null;
        this.useLAP();
    }

    @Override
    public INetCircuit useLAP() {
        if (this.myLap != null) {
            return this.myLap;
        }
        NetCcatCircuit netCcatCircuit = this.useLAPOnSource();
        if (netCcatCircuit == null) {
            netCcatCircuit = this.useLAPOnDrop();
        }
        if (netCcatCircuit != null && (this.getState() == 1 || this.getState() == 8 || this.getState() == 5)) {
            this.myLap = netCcatCircuit;
            this.myLap.addObserver(this);
        }
        return netCcatCircuit;
    }

    public NetCcatCircuit useLAPOnSource() {
        IEntityModel iEntityModel = null;
        for (NetCircuitEnd netCircuitEnd : this.getCktSources()) {
            INodeModel iNodeModel;
            block4: {
                iNodeModel = netCircuitEnd.getNodeModel();
                try {
                    iEntityModel = netCircuitEnd.getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    if (!this.dbgOn()) break block4;
                    db.println("useLAPOnSource hits exception: entity model does not exist");
                }
            }
            if (iNodeModel == null || iEntityModel == null) continue;
            NetCcatCircuit netCcatCircuit = this.ncMgr.getLAPLoGrooming(iNodeModel, iEntityModel, netCircuitEnd.getHoNum());
            if (netCcatCircuit != null) {
                return netCcatCircuit;
            }
            netCcatCircuit = (NetCcatCircuit)this.ncMgr.getLAPHo(iNodeModel, iEntityModel, netCircuitEnd.getHoNum());
            if (netCcatCircuit == null) continue;
            return netCcatCircuit;
        }
        return null;
    }

    public NetCcatCircuit useLAPOnDrop() {
        IEntityModel iEntityModel = null;
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel;
            NetCircuitEnd netCircuitEnd;
            block4: {
                netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
                iNodeModel = netCircuitEnd.getNodeModel();
                try {
                    iEntityModel = netCircuitEnd.getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    if (!this.dbgOn()) break block4;
                    db.println("useLAP hits exception: entity model does not exist");
                }
            }
            if (iNodeModel == null || iEntityModel == null) continue;
            NetCcatCircuit netCcatCircuit = this.ncMgr.getLAPLoGrooming(iNodeModel, iEntityModel, netCircuitEnd.getHoNum());
            if (netCcatCircuit != null) {
                return netCcatCircuit;
            }
            netCcatCircuit = (NetCcatCircuit)this.ncMgr.getLAPHo(iNodeModel, iEntityModel, netCircuitEnd.getHoNum());
            if (netCcatCircuit == null) continue;
            return netCcatCircuit;
        }
        return null;
    }

    @Override
    protected void disposeActiveSpan(NetCircuitSpan netCircuitSpan) {
        if (netCircuitSpan.getLink().isLAP()) {
            this.lapLinkRemoved = true;
        }
        super.disposeActiveSpan(netCircuitSpan);
    }

    @Override
    protected boolean tl1CircuitCompleteCheck() {
        if (this.lapLinkRemoved) {
            this.tl1RemoveLapNode();
            this.myLap = null;
            this.lapLinkRemoved = false;
        }
        return super.tl1CircuitCompleteCheck();
    }

    @Override
    protected void tl1RemoveLapNode() {
        if (this.dbgOn()) {
            db.println("tl1RemoveLapHoCktEnd : called");
        }
        if (this.getState() == 2) {
            if (this.dbgOn()) {
                db.println(this.getCircuitName() + " is in Deleting State");
            }
            return;
        }
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = new LinkedList();
        this.getNodeLevelSourcesAndDrops(linkedList, linkedList2);
        LinkedList linkedList3 = new LinkedList(linkedList);
        linkedList3.addAll(linkedList2);
        for (NetCircuitEnd netCircuitEnd : linkedList3) {
            if (!(netCircuitEnd instanceof LoCircuitEnd) || !((LoCircuitEnd)netCircuitEnd).isTl1LapCktEnd()) continue;
            NetCircuitNode netCircuitNode = this.getCircuitNodeFromCktEnd(netCircuitEnd);
            if (netCircuitNode == null) break;
            this.destroyLapNode(netCircuitNode);
            break;
        }
    }

    @Override
    protected void destroyLapNode(NetCircuitNode netCircuitNode) {
        NetCircuitMergeOperator netCircuitMergeOperator;
        if (this.dbgOn()) {
            db.println("Destroying LAPcktNode : " + netCircuitNode.getNetElement().getName() + "for ckt:" + this.getCircuitName());
        }
        netCircuitNode.destroy();
        this.removeCktNode(netCircuitNode);
        if (this.inCircuitMerge && (netCircuitMergeOperator = CircuitMergeManager.instance().getMergeOperator(this)) != null) {
            netCircuitMergeOperator.lapNodeDestroyed(netCircuitNode);
        }
    }

    @Override
    protected void lapNodeCreated(NetCircuitNode netCircuitNode) {
        NetCircuitMergeOperator netCircuitMergeOperator;
        if (this.inCircuitMerge && (netCircuitMergeOperator = CircuitMergeManager.instance().getMergeOperator(this)) != null) {
            netCircuitMergeOperator.lapNodeDiscovered(netCircuitNode);
        }
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof HoCcatCircuit) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                this.updateCircuit();
            }
        } else {
            super.update(iObservable, object);
        }
    }

    protected void updateCircuit() {
        this.setChanged();
        this.notifyChanged();
    }

    @Override
    public List getSources() {
        LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
        if (this.useLAP() == null) {
            return this.getCktSources();
        }
        Iterator iterator = this.getCktSources().iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel;
            LoCircuitEnd loCircuitEnd;
            IEntityModel iEntityModel;
            block6: {
                iEntityModel = null;
                loCircuitEnd = (LoCircuitEnd)iterator.next();
                iNodeModel = loCircuitEnd.getNodeModel();
                try {
                    iEntityModel = loCircuitEnd.getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    if (!this.dbgOn()) break block6;
                    db.println("useLAP hits exception: entity model does not exist");
                }
            }
            if (iNodeModel == null || iEntityModel == null) continue;
            NetCcatCircuit netCcatCircuit = this.ncMgr.getLAPLoGrooming(iNodeModel, iEntityModel, loCircuitEnd.getHoNum());
            if (netCcatCircuit != null) {
                for (NetCircuitEnd netCircuitEnd : this.getPseudoCktEnds(loCircuitEnd)) {
                    if (linkedList.contains(netCircuitEnd)) continue;
                    linkedList.add(netCircuitEnd);
                }
                continue;
            }
            linkedList.add(loCircuitEnd);
        }
        return linkedList;
    }

    @Override
    public List getDrops() {
        LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
        if (this.useLAP() == null) {
            return this.getCktDrops();
        }
        Iterator iterator = this.getCktDrops().iterator();
        while (iterator.hasNext()) {
            INodeModel iNodeModel;
            NetCircuitDropInfo netCircuitDropInfo;
            IEntityModel iEntityModel;
            block6: {
                iEntityModel = null;
                netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                iNodeModel = netCircuitDropInfo.getNodeModel();
                try {
                    iEntityModel = netCircuitDropInfo.getEntityModel();
                }
                catch (ObjNotFound objNotFound) {
                    if (!this.dbgOn()) break block6;
                    db.println("hits exception: entity model does not exist");
                }
            }
            if (iNodeModel == null || iEntityModel == null) continue;
            NetCcatCircuit netCcatCircuit = this.ncMgr.getLAPLoGrooming(iNodeModel, iEntityModel, netCircuitDropInfo.getHoNum());
            if (netCcatCircuit != null) {
                for (NetCircuitEnd netCircuitEnd : this.getPseudoCktEnds((LoCircuitEnd)netCircuitDropInfo.getNetCktEnd())) {
                    NetCircuitDropInfo netCircuitDropInfo2 = new NetCircuitDropInfo(netCircuitEnd, netCircuitDropInfo.getPathProt());
                    if (linkedList.contains(netCircuitDropInfo2)) continue;
                    linkedList.add(netCircuitDropInfo2);
                }
                continue;
            }
            linkedList.add(netCircuitDropInfo);
        }
        return linkedList;
    }

    protected List getPseudoCktEnds(LoCircuitEnd loCircuitEnd) {
        LinkedList<LoCircuitEnd> linkedList = new LinkedList<LoCircuitEnd>();
        INetCircuit iNetCircuit = null;
        if (this.myLap != null) {
            iNetCircuit = this.myLap;
        }
        if (iNetCircuit == null) {
            iNetCircuit = this.useLAP();
        }
        if (iNetCircuit != null) {
            for (NetCircuitEnd netCircuitEnd : iNetCircuit.getSources()) {
                CircuitEnd circuitEnd = new CircuitEnd(netCircuitEnd.getNodeId(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), loCircuitEnd.getLoNum(), loCircuitEnd.getDropProt(), loCircuitEnd.getPathIdentifier());
                linkedList.add(new LoCircuitEnd(this.net.getNodeModel(netCircuitEnd.getNodeId()), circuitEnd));
            }
        }
        return linkedList;
    }

    @Override
    public List getCircuitSpans() {
        INetLink iNetLink = null;
        NetLinkSpan netLinkSpan = null;
        NetCircuitSpan netCircuitSpan = null;
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        List list = super.getCircuitSpans();
        INetCircuit iNetCircuit = this.useLAP();
        if (iNetCircuit != null && this.getCircuitSpanFromNetLink(iNetCircuit.getLapLink()) == null && this.getCircuitSpanFromNetLink(iNetCircuit.getReverseLapLink()) == null && this.getState() == 1 && iNetCircuit.getState() == 1) {
            INetCircuitEnd iNetCircuitEnd = this.getPrimarySource();
            try {
                if (NetCircuitManager.instance().getLAPLoGrooming(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum()) != null) {
                    iNetLink = iNetCircuit.getLapLink();
                    netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), iNetCircuitEnd.getLoNum());
                } else {
                    iNetLink = iNetCircuit.getReverseLapLink();
                    netLinkSpan = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iNetLink.getSrcHo(), iNetLink.getDstHo(), this.getPrimaryDrop().getLoNum());
                }
            }
            catch (ObjNotFound objNotFound) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            if (netLinkSpan != null) {
                List list2 = iNetCircuit.getCircuitNodeFromNE(iNetLink.getSrc());
                if (list2 != null) {
                    if (list2.size() > 1) {
                        if (this.dbgOn()) {
                            db.println("Error !! MXPN in LAP");
                        }
                    } else {
                        netCircuitNode = (NetCircuitNode)list2.get(0);
                    }
                }
                if ((list2 = iNetCircuit.getCircuitNodeFromNE(iNetLink.getDst())) != null) {
                    if (list2.size() > 1) {
                        if (this.dbgOn()) {
                            db.println("Error !! MXPN in LAP");
                        }
                    } else {
                        netCircuitNode2 = (NetCircuitNode)list2.get(0);
                    }
                }
                netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this, netLinkSpan, netCircuitNode, netCircuitNode2);
            }
            if (netCircuitSpan != null) {
                netCircuitSpan.setSrcState(4);
                netCircuitSpan.setDstState(4);
                list.add(netCircuitSpan);
            }
        }
        return list;
    }

    @Override
    public int getCircuitSpanNum() {
        if (this.getState() == 1 && this.myLap != null) {
            if (this.useLAPOnSource() != null && this.myLap.getPrimarySource().getNodeId() == this.getPrimarySource().getNodeId()) {
                return super.getCircuitSpanNum();
            }
            if (this.useLAPOnDrop() != null) {
                boolean bl = false;
                Iterator iterator = this.getCktDrops().iterator();
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
                    if (this.myLap.getPrimarySource().getNodeId() != netCircuitEnd.getNodeId()) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    return super.getCircuitSpanNum();
                }
                return super.getCircuitSpanNum() + 1;
            }
            return super.getCircuitSpanNum() + 1;
        }
        return super.getCircuitSpanNum();
    }

    @Override
    public boolean usesNetElement(INetElement iNetElement) {
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)this.useLAP();
        if (netCcatCircuit != null) {
            return super.usesNetElement(iNetElement) || netCcatCircuit.usesNetElement(iNetElement);
        }
        return super.usesNetElement(iNetElement);
    }

    @Override
    public boolean doesCircuitUseNetLink(INetLink iNetLink) {
        if (super.doesCircuitUseNetLink(iNetLink)) {
            return true;
        }
        if (this.getState() != 1) {
            return false;
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)this.useLAP();
        if (netCcatCircuit != null) {
            return netCcatCircuit.doesCircuitUseNetLink(iNetLink);
        }
        return false;
    }

    @Override
    public List getLinkEndpoints(INetLink iNetLink) {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(super.getLinkEndpoints(iNetLink));
        if (iNetLink.isLOTunnel()) {
            Iterator iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (netCircuitEnd.getHoNum() == iNetLink.getLinkModel().srcHo() || netCircuitEnd.getHoNum() == iNetLink.getLinkModel().dstHo()) continue;
                iterator.remove();
            }
        }
        return linkedList;
    }

    @Override
    public ILoNum getLoOverHo() {
        if (this.useLAPOnSource() != null) {
            return ((NetCircuitEnd)this.getCktSources().get(0)).getLoNum();
        }
        if (this.useLAPOnDrop() != null) {
            return ((NetCircuitDropInfo)this.getCktDrops().get(0)).getLoNum();
        }
        return null;
    }

    @Override
    protected synchronized void finalDispose() {
        if (this.myLap != null) {
            this.myLap.deleteObserver(this);
        }
        super.finalDispose();
    }

    public boolean isSourceOnLAP(NetCircuitEnd netCircuitEnd) {
        Iterator iterator = this.getSources().iterator();
        if (!this.circuitInfoActive()) {
            return false;
        }
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iterator.next();
            if (this.dbgOn()) {
                db.println("isSource: circuit's source = " + netCircuitEnd2.prettyString());
            }
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSource(NetCircuitEnd netCircuitEnd) {
        Iterator iterator = this.getCktSources().iterator();
        if (!this.circuitInfoActive()) {
            return false;
        }
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iterator.next();
            if (netCircuitEnd2.equals(netCircuitEnd)) {
                return true;
            }
            if (netCircuitEnd == null || !(netCircuitEnd instanceof LoCircuitEnd) || !(netCircuitEnd2 instanceof LoCircuitEnd)) continue;
            LoCircuitEnd loCircuitEnd = (LoCircuitEnd)netCircuitEnd;
            LoCircuitEnd loCircuitEnd2 = (LoCircuitEnd)netCircuitEnd2;
            if (!loCircuitEnd.isPreVcatDaytonaCircuitEnd() || !loCircuitEnd2.isPreVcatDaytonaCircuitEnd() || !loCircuitEnd2.roughlyEquals(loCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    public boolean isDropOnLAP(NetCircuitEnd netCircuitEnd) {
        Iterator iterator = this.getDrops().iterator();
        while (iterator.hasNext()) {
            NetCircuitEnd netCircuitEnd2 = ((NetCircuitDropInfo)iterator.next()).getNetCktEnd();
            if (!netCircuitEnd2.equals(netCircuitEnd)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected NetCircuitDropInfo getDrop(NetCircuitEnd netCircuitEnd) {
        NetCircuitDropInfo netCircuitDropInfo = super.getDrop(netCircuitEnd);
        if (netCircuitDropInfo != null) {
            return netCircuitDropInfo;
        }
        for (NetCircuitDropInfo netCircuitDropInfo2 : this.getCktDrops()) {
            NetCircuitEnd netCircuitEnd2 = netCircuitDropInfo2.getNetCktEnd();
            if (netCircuitEnd == null || !(netCircuitEnd instanceof LoCircuitEnd) || !(netCircuitEnd2 instanceof LoCircuitEnd)) continue;
            LoCircuitEnd loCircuitEnd = (LoCircuitEnd)netCircuitEnd;
            LoCircuitEnd loCircuitEnd2 = (LoCircuitEnd)netCircuitEnd2;
            if (!loCircuitEnd.isPreVcatDaytonaCircuitEnd() || !loCircuitEnd2.isPreVcatDaytonaCircuitEnd() || !loCircuitEnd2.roughlyEquals(loCircuitEnd)) continue;
            return netCircuitDropInfo2;
        }
        return null;
    }

    @Override
    protected void restoreLapHoNode(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, NetLinkSpan netLinkSpan) {
        INetLink iNetLink = netLinkSpan.getLink();
        if (this.dbgOn()) {
            this.debug("restoreLapHoNode() for " + this.getCircuitName());
        }
        if (!iNetLink.isLAP()) {
            if (this.dbgOn()) {
                this.debug("restoreLapHoNode FAILURE: link is not LAP link");
            }
            return;
        }
        if (netCircuitNode != null && netCircuitNode2 != null) {
            if (this.dbgOn()) {
                this.debug("restoreLapHoNode FAILURE: src and dest are both non-null");
            }
            return;
        }
        if (netCircuitNode == null && netCircuitNode2 == null) {
            if (this.dbgOn()) {
                this.debug("restoreLapHoNode FAILURE: src and dest are both null");
            }
            return;
        }
        HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)((NetLink)iNetLink).getLotCircuit();
        if (netCircuitNode == null) {
            netCircuitNode = this.createLapHoCircuitNode(hoCcatCircuit, iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), netLinkSpan.getSrcHoNum(), netLinkSpan.getLoNum(), true);
        } else if (netCircuitNode2 == null) {
            netCircuitNode2 = this.createLapHoCircuitNode(hoCcatCircuit, iNetLink.getDst(), iNetLink.getDstEntityIndex(), netLinkSpan.getDstHoNum(), netLinkSpan.getLoNum(), false);
        }
    }

    protected NetCircuitNode createLapHoCircuitNode(HoCcatCircuit hoCcatCircuit, INetElement iNetElement, int n, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        LoCircuitNode loCircuitNode = (LoCircuitNode)NetCircuitNodeFactory.createCircuitNode(iNetElement, this);
        loCircuitNode.setState(2);
        if (this.getCircuitDir() == 0) {
            loCircuitNode.setConnectionType(0);
        } else {
            loCircuitNode.setConnectionType(1);
        }
        loCircuitNode.numberOfPaths = 2;
        LoCircuitEnd loCircuitEnd = null;
        if (!this.circuitInfoActive()) {
            loCircuitEnd = this.getTl1LAPCktEnd(hoCcatCircuit, iLoNum);
            loCircuitEnd.setStage(4);
        }
        if (this.circuitInfoActive()) {
            if (this.useLAPOnSource() != null) {
                loCircuitNode.insertSource((NetCircuitEnd)this.getSources().get(0));
            } else {
                loCircuitNode.insertDrop((NetCircuitEnd)this.getDropCktEnds().get(0));
            }
        } else if (bl) {
            loCircuitNode.insertSource(loCircuitEnd);
        } else {
            loCircuitNode.insertDrop(loCircuitEnd);
        }
        loCircuitNode.simulateConnection(iNetElement, n, iHoNum, iLoNum);
        this.insertCktNode(loCircuitNode);
        return loCircuitNode;
    }

    private LoCircuitEnd getTl1LAPCktEnd(HoCcatCircuit hoCcatCircuit, ILoNum iLoNum) {
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)hoCcatCircuit.getPrimarySource();
        LoCircuitEnd loCircuitEnd = new LoCircuitEnd(netCircuitEnd.getNodeId(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), iLoNum, false);
        loCircuitEnd.setTl1LapCktEnd();
        if (this.dbgOn()) {
            db.println("getTl1LapCktEnd : Returning loCktEnd " + loCircuitEnd.prettyString());
        }
        return loCircuitEnd;
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public boolean upsrBerThresholdsSettable() {
        boolean bl = false;
        Iterator iterator = this.getUpsrSelectors().iterator();
        while (!bl && iterator.hasNext()) {
            bl = ((IConnectionModel)iterator.next()).getNodeModel().provides(Feature.UPSR_VT_THRESH);
        }
        return bl;
    }

    public Object getILoNum() {
        return this.loNum;
    }

    @Override
    public boolean isYCircuit() {
        return this.isYCircuit;
    }

    public boolean isYActive() {
        if (!this.isYCircuit) {
            return false;
        }
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (netCircuitNode instanceof LoYCircuitNode) continue;
            return true;
        }
        return false;
    }

    public void updateYCircuit(boolean bl) {
        if (!this.isYCircuit) {
            return;
        }
        boolean bl2 = this.isYActive();
        for (NetCircuitNode netCircuitNode : this.getCircuitNodes()) {
            if (!(netCircuitNode instanceof LoYCircuitNode)) continue;
            ((LoYCircuitNode)netCircuitNode).setInUse(bl2, bl);
        }
    }
}

