/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CircuitId;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPoolModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.LoDefModel;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetLink;
import cerent.util.SDebug;

public class LoCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("LoCircuitSpan");
    private boolean srcFabricated;
    private boolean dstFabricated;

    public LoCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan, INetCircuitNode iNetCircuitNode, INetCircuitNode iNetCircuitNode2) {
        super(netCcatCircuit, netLinkSpan, iNetCircuitNode, iNetCircuitNode2);
        if (this.dbgOn()) {
            db.println("LoCircuitSpan object instantiated");
        }
        this.srcFabricated = false;
        this.dstFabricated = false;
    }

    @Override
    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        IPoolModel iPoolModel = this.getHoPool(iNetElement);
        CircuitId circuitId = new CircuitId(iNetElement.getNodeId(), 0);
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iPoolModel == null) {
            throw new ObjNotFound("unable to find pool model");
        }
        ILoAditModel iLoAditModel = this.getLoAdit(iNetElement, iPoolModel);
        if (iLoAditModel == null && (iLoAditModel = this.createLoAdit(iNetElement, circuitId, iPoolModel)) == null) {
            if (this.dbgOn()) {
                this.debug("CircuitEnd: unable to create LoAdit");
            }
            throw new ObjNotFound("unable to find pool model");
        }
        LoDefModel loDefModel = null;
        loDefModel = new LoDefModel(iNodeModel, iLoAditModel, this.availSpan.getLoNum(), s, 0, this.getEntityIndex(iNetElement));
        return loDefModel;
    }

    @Override
    public void dispose(boolean bl) {
        super.dispose(bl);
        if (this.getLink().isLAP()) {
            NetCcatCircuit netCcatCircuit = (NetCcatCircuit)this.getCircuit();
            if (netCcatCircuit.useLAP() == null) {
                if (this.dbgOn()) {
                    this.debug("LoCktSpan:useLAP is null ");
                }
                netCcatCircuit.tl1RemoveLapNode();
                return;
            }
            NetCircuitNode netCircuitNode = (NetCircuitNode)this.getSrcNCN();
            if (netCircuitNode != null && netCircuitNode.getConn() == null) {
                netCcatCircuit.destroyLapNode(netCircuitNode);
            }
            if ((netCircuitNode = (NetCircuitNode)this.getDstNCN()) != null && netCircuitNode.getConn() == null) {
                netCcatCircuit.destroyLapNode(netCircuitNode);
            }
        }
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public boolean isSrcFabricated() {
        return this.srcFabricated;
    }

    @Override
    public boolean isDstFabricated() {
        return this.dstFabricated;
    }

    protected void setSrcFabricated() {
        this.srcFabricated = true;
    }

    protected void setDstFabricated() {
        this.dstFabricated = true;
    }

    @Override
    public String prettyString() {
        String string = super.prettyString();
        if (this.srcFabricated || this.dstFabricated) {
            string = string + " src fabricated = " + this.srcFabricated + " dst fabricated = " + this.dstFabricated;
        }
        return string;
    }

    @Override
    public int getProtectionType() {
        if (this.isDriSpan()) {
            return 18;
        }
        if (this.isUpsr() && !this.srcFabricated && !this.dstFabricated) {
            return 13;
        }
        if (this.getLink().isLOTunnel() || this.getLink().isLAP()) {
            return ((NetLink)this.getLink()).getLotCircuit().getProtType();
        }
        return this.getLink().getProtectionType();
    }
}

