/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoConnModelSimulator;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.YCircuitNodeController;
import cerent.cms.topo.INetElement;
import cerent.util.IObservable;
import cerent.util.SDebug;

public class LoYCircuitNode
extends LoCircuitNode {
    private int selfId;
    private YCircuitNodeController yController;
    boolean allowDelete = false;
    boolean controllerDeleted = false;
    private static final SDebug db = new SDebug("LoYCircuitNode");

    public LoYCircuitNode(INetElement iNetElement, LoCcatCircuit loCcatCircuit, Object object) {
        super(iNetElement, loCcatCircuit, object);
    }

    @Override
    public void deactivate() throws DeletionError {
        if (this.allowDelete) {
            super.deactivate();
        }
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || super.dbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof ILoConnectionModel) {
            super.update(iObservable, object);
        } else if (iObservable instanceof YCircuitNodeController && ((Integer)object).equals(ModelUpdateType.DELETED)) {
            this.allowDelete = true;
            for (NetCircuitNode netCircuitNode : this.getCircuit().getCircuitNodes()) {
                if (netCircuitNode instanceof LoYCircuitNode) continue;
                ((NetCcatCircuit)netCircuitNode.getCircuit()).disposeLTN(netCircuitNode);
                NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
            }
            this.forceDelete(iObservable, object);
        }
    }

    public void forceDelete(IObservable iObservable, Object object) {
        if (this.getConn() != null) {
            ((LoConnModelSimulator)this.getConn())._update(iObservable, object);
        }
    }

    public void setController(int n, YCircuitNodeController yCircuitNodeController) {
        this.yController = yCircuitNodeController;
        this.selfId = n;
        ModelIndirectObservable.instance().addObserver((IObservable)this.yController, this);
    }

    public void setInUse(boolean bl, boolean bl2) {
        if (this.dbgOn()) {
            this.debug("Setting value " + (bl ? "True" : "False") + " for loNum :" + this.selfId);
        }
        this.yController.setInUse(this.selfId, bl, bl2);
    }
}

