/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.ISvlanPathDefModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.ObjDuplicate;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.ConnTypeUnsupported;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.ConnectionValidator;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitSpan;
import cerent.cms.ncp.INetCircuitState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitCreateWorker;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitNodeUtil;
import cerent.cms.ncp.NetCircuitOperator;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.OchncCircuitSpan;
import cerent.cms.ncp.RouteValidator;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuitNode;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.DriNodePair;
import cerent.cms.route.DriNodes;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.Wavelength;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.EnumStrings;
import cerent.util.ErrorMsg;
import cerent.util.HoLoComparator;
import cerent.util.SDebug;
import cerent.util.TDMTerminology;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class NetCcatCircuitOperator
extends NetCircuitOperator
implements IJobGroupListener {
    private NetCcatCircuit ccatCircuit;
    private boolean createDone;
    private Object threadWaitObject;
    private static final SDebug db = new SDebug("NetCcatCircuitOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected NetCcatCircuitOperator(NetCcatCircuit netCcatCircuit) {
        this.ccatCircuit = netCcatCircuit;
        this.createDone = false;
        this.threadWaitObject = new Object();
    }

    @Override
    protected NetCircuit getCircuit() {
        return this.ccatCircuit;
    }

    protected void removeInactiveNodesAndSpans() {
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("removeInactiveNodesAndSpans");
        }
        for (NetCircuitSpan netCircuitSpan : this.ccatCircuit.getCircuitSpans()) {
            if (netCircuitSpan.getSrcState() != 0) continue;
            if (netCircuitSpan.getDstState() == 0) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("removing INACTIVE span: " + netCircuitSpan.prettyString());
                }
                this.ccatCircuit.removeCktSpan(netCircuitSpan);
                this.ccatCircuit.setChanged();
                continue;
            }
            if (!NetCcatCircuitOperator.dbgOn()) continue;
            db.println("src of span inactive, but dst is not");
        }
        for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
            if (netCircuitNode == this.ccatCircuit.getSrcCircuitNode() || netCircuitNode == this.ccatCircuit.getSecSrcCircuitNode()) {
                boolean bl = this.ccatCircuit.getPrimarySource().getNodeId() == this.ccatCircuit.getPrimaryDrop().getNodeId() && this.ccatCircuit.getSources().size() == 1 && this.ccatCircuit.getDrops().size() == 1 && this.ccatCircuit.getCircuitTypeObj().isHoCircuitType();
                if (!bl || !netCircuitNode.hasDualConnections() || this.ccatCircuit.getXmCircuitEnds().size() != 0) continue;
                DualConnectionCircuitNode dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode;
                NetCircuitNode netCircuitNode2 = dualConnectionCircuitNode.getFstCircuitNode();
                NetCircuitNode netCircuitNode3 = dualConnectionCircuitNode.getSecCircuitNode();
                if (netCircuitNode3.getState() != 0 || netCircuitNode3.getDrops().size() != 0 || netCircuitNode3.getSources().size() != 0 || netCircuitNode3.isNodeDrop()) continue;
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Removing INACTIVE DCN node: " + netCircuitNode.getNetElement().getName());
                }
                this.ccatCircuit.removeCktNode(netCircuitNode);
                this.ccatCircuit.insertCktNode(netCircuitNode2);
                this.ccatCircuit.setSrcCircuitNode(netCircuitNode2);
                this.ccatCircuit.setChanged();
                continue;
            }
            if (netCircuitNode.getSources().size() != 0 || netCircuitNode.getState() != 0 || netCircuitNode.getDrops().size() != 0 || netCircuitNode.isNodeDrop()) continue;
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("Removing INACTIVE node: " + netCircuitNode.getNetElement().getName());
            }
            this.ccatCircuit.removeCktNode(netCircuitNode);
            this.ccatCircuit.setChanged();
        }
    }

    @Override
    protected void addDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, CircuitDropOutstanding, SanityCheckFailed, IncorrectCircuitState {
        if (!this.ccatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.ccatCircuit.getCircuitType(), iNetCircuitEnd);
        if (this.ccatCircuit.isMemberOfVcat() && !this.ccatCircuit.isOpenEndedVcatCircuit()) {
            netCircuitEnd.setPathIdentifier(this.ccatCircuit.getPrimarySource().getPathIdentifier());
        }
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("addDrop called. Drop = " + netCircuitEnd.prettyString());
        }
        if (!this.ccatCircuit.isMemberOfVcat()) {
            this.ccatCircuit.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        }
        int n = this.convertPathProt(this.ccatCircuit.getMemberPrefs() == null ? 9 : this.ccatCircuit.getMemberPrefs().getPathProtection());
        this.addDropCheck(netCircuitEnd, n);
        NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, n);
        if (this.ccatCircuit.getCktDrops().contains(netCircuitDropInfo)) {
            throw new SanityCheckFailed("An attempt was made to add a duplicate drop to the circuit.");
        }
        INetElement iNetElement = null;
        try {
            iNetElement = netCircuitEnd.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in addDrop");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("addDrop: unable to find NE");
            }
            throw new ObjNotFound("The network element cannot be found.");
        }
        ICircuitType iCircuitType = this.ccatCircuit.getCircuitTypeObj();
        List list = this.ccatCircuit.getCircuitNodeFromNE(iNetElement);
        NetCircuitNode netCircuitNode = null;
        if (iCircuitType.isSVLANType() && list != null && list.size() > 1) {
            for (NetCircuitNode netCircuitNode2 : list) {
                ISvlanPathDefModel iSvlanPathDefModel;
                List list2 = netCircuitNode2.getPathList();
                if (list2 == null || list2.size() <= 0 || !SvlanCircuitHelper.areEntitiesCoLocatedForL2Ckt(iNetElement, (iSvlanPathDefModel = (ISvlanPathDefModel)list2.get(0)).getPortEntityIdx(), iNetCircuitEnd.getEntityIndex(), false)) continue;
                netCircuitNode = netCircuitNode2;
                break;
            }
            if (netCircuitNode == null) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("WARNING!!! not found a cktNode for this drop point.");
                }
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        } else {
            netCircuitNode = this.ccatCircuit.getCircuitNodeWithDropFromNE(iNetElement);
            if (netCircuitNode == null && list != null) {
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        if (netCircuitNode == null) {
            if (iCircuitType.isEthernetCircuitType()) {
                throw new SanityCheckFailed("An Ethernet HO drop cannot be added on the node " + iNetElement.getName() + ".");
            }
            netCircuitNode = this.ccatCircuit.getXmCircuitEnds().isEmpty() || ((NetCircuitEnd)this.ccatCircuit.getXmCircuitEnds().get(0)).getNodeId() != iNetCircuitEnd.getNodeId() ? NetCircuitNodeFactory.createCircuitNode(iNetElement, this.ccatCircuit) : NetCircuitNodeFactory.createDualConnectionCircuitNode(iNetElement, iCircuitType, (HoCcatCircuit)this.ccatCircuit);
            this.ccatCircuit.insertCktNode(netCircuitNode);
        } else {
            if (this.ccatCircuit.isUpsr1wayTl1() && !this.sanityCheckRequestedDropProtection(netCircuitNode, n)) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("addDrop: ONEWAY connection on " + netCircuitNode.getName() + " does not support drop protection");
                }
                throw new SanityCheckFailed("A one way connection on the node " + netCircuitNode.getName() + " does not support drop protection.");
            }
            if (iCircuitType.isEthernetCircuitType() && !netCircuitNode.eligibleForEtherHoDropAdd()) {
                throw new SanityCheckFailed("An Ethernet HO drop cannot be added on the node " + iNetElement.getName() + ".");
            }
        }
        netCircuitNode.addDropInfo(netCircuitDropInfo);
        this.ccatCircuit.insertDrop(netCircuitDropInfo);
        if (this.ccatCircuit.getState() != 0) {
            this.ccatCircuit.setState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICircuitId createCircuitInfo(INodeModel iNodeModel, INodeModel iNodeModel2, ICircuitInfo iCircuitInfo) throws CircuitProvError {
        ICircuitId iCircuitId;
        int n = 0;
        if (iCircuitInfo.getSrcPoint().getNodeId() != 0) {
            ++n;
        }
        if (iCircuitInfo.getSecSrcPoint().getNodeId() != 0) {
            ++n;
        }
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("createCircuitInfo: " + n + " source(s), " + iCircuitInfo.getDropInfo().length + " drop(s)");
        }
        ICircuitFactoryModel iCircuitFactoryModel = iNodeModel.getCircuitFactoryModel();
        Object object = NetCircuitManager.instance().getMasterCktListLock();
        synchronized (object) {
            ICircuitModel iCircuitModel;
            NetCircuitManager.instance().removeCircuit(this.getCircuit());
            try {
                String string = OchTrailHelper.sanitizeCRSOchTrailCircuitName(iCircuitInfo.getCircuitName());
                iCircuitInfo.setCircuitName(string);
                iCircuitModel = iCircuitFactoryModel.createCircuit(iNodeModel2, iCircuitInfo);
                this.getCircuit().setCircuitModel(iCircuitModel);
            }
            catch (CTCUserException cTCUserException) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                }
                String string = "The circuit information could not be created.";
                if (cTCUserException instanceof InvalidCircuitName) {
                    string = string + "\nThe circuit name was invalid.";
                }
                throw new CircuitProvError(string);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                if (abstractCmsIOException instanceof CmsNodeUpgradingException) {
                    throw new CircuitProvError(ErrorMsg.getString((EID)CEMC.EID_NODE_UPGRADING_EXCEPTION_PARAM_1, (Object)"Circuit creation"));
                }
                throw new CircuitProvError("Unable to create circuit info due to IO exception");
            }
            this.getCircuit().setCircuitInfoActive();
            this.getCircuit().addCircuitInfoObserver();
            try {
                iCircuitId = iCircuitModel.getId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                this.getCircuit().disposeCircuitInfo(true);
                throw new CircuitProvError("The circuit information could not be found.");
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.getCircuit().disposeCircuitInfo(true);
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Unable to get circuit id: " + (Object)((Object)abstractCmsCommFailException));
                }
                throw new CircuitProvError("The circuit ID could not be retrieved.");
            }
            this.getCircuit().updateCircuitId(iCircuitId);
            NetCircuitManager.instance().insertCircuit(this.getCircuit(), false);
        }
        this.checkForDefaultName();
        return iCircuitId;
    }

    protected boolean sanityCheckRequestedDropProtection(NetCircuitNode netCircuitNode, int n) {
        if ((netCircuitNode.getConnectionType() == 0 || netCircuitNode.getConnectionType() == 4) && n == 0) {
            if (netCircuitNode.connections.size() == 1) {
                Connection connection = (Connection)netCircuitNode.connections.get(0);
                List list = connection.getInSpans();
                NetCircuitSpan netCircuitSpan = list.size() == 0 ? null : (NetCircuitSpan)list.get(0);
                return connection.isInputLineProtected(netCircuitSpan);
            }
            db.println("sanityCheckRequestedDropProtection: Error in connection list on node " + netCircuitNode.getName());
            return false;
        }
        return true;
    }

    @Override
    protected void routeDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2;
        block12: {
            routePrefs2 = new RoutePrefs(routePrefs);
            LinkedList<Object> linkedList = new LinkedList<Object>();
            ICircuitType iCircuitType = this.ccatCircuit.getCircuitTypeObj();
            if (iCircuitType.isHoCircuitType() || iCircuitType.isLAPCircuitType()) {
                List list = this.ccatCircuit.getXmCircuitEnds();
                if (list.size() != 0) {
                    INetElement iNetElement = ((NetCircuitEnd)list.get(0)).getNetElement();
                    if (!routePrefs2.getRequiredNodes().contains(iNetElement) && iNetElement != this.ccatCircuit.getPrimarySource().getNetElement() && iNetElement != iNetCircuitEnd.getNetElement()) {
                        linkedList.add(iNetElement);
                    }
                }
            } else if (iCircuitType.isLoCircuitType()) {
                INetCircuit iNetCircuit = ((LoCcatCircuit)this.ccatCircuit).useLAPOnSource();
                if (iNetCircuit == null) {
                    iNetCircuit = NetCircuitManager.instance().getLAPHo(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum());
                }
                if (iNetCircuit != null && !routePrefs2.getRequiredLinks().contains(iNetCircuit.getLapLink()) && !routePrefs2.getRequiredLinks().contains(iNetCircuit.getReverseLapLink())) {
                    if (((LoCcatCircuit)this.ccatCircuit).useLAPOnSource() != null) {
                        linkedList.add(iNetCircuit.getLapLink());
                    } else {
                        linkedList.add(iNetCircuit.getReverseLapLink());
                    }
                }
            }
            if (!linkedList.isEmpty()) {
                try {
                    routePrefs2.setReqEntityList(linkedList);
                }
                catch (ObjDuplicate objDuplicate) {
                    if (!NetCcatCircuitOperator.dbgOn()) break block12;
                    db.println("routeDrop: hit ObjDuplicate exception");
                }
            }
        }
        super.routeDrop(iNetCircuitEnd, routePrefs2);
    }

    @Override
    protected void routeCurrentDrop(INetElement iNetElement, RoutePrefs routePrefs, boolean bl) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        LinkedList linkedList = new LinkedList(this.ccatCircuit.getRequiredSpans());
        linkedList.addAll(routePrefs2.getRequiredSpans());
        this.sanityCheckCircuitInputs(routePrefs2.getPathProt());
        if (routePrefs2.getSrc() == null) {
            routePrefs2.setSrc(this.ccatCircuit.getSrcCircuitNode().getNetElement());
        }
        if (this.ccatCircuit.getSecondarySource() != null) {
            routePrefs2.setSecSrc(this.ccatCircuit.getSecondarySource().getNetElement());
        }
        routePrefs2.setDst(iNetElement);
        routePrefs2.setCircuitSize(this.ccatCircuit.getCircuitSize());
        routePrefs2.setRequiredSpans(linkedList);
        routePrefs2.setCircuitType(this.ccatCircuit.getCircuitType());
        routePrefs2.setPathOnly(false);
        routePrefs2.setDir(this.ccatCircuit.getCircuitDir());
        routePrefs2.setSla(this.ccatCircuit.getSla());
        if (routePrefs2.getSecDst() != null && routePrefs2.getSecDst() != routePrefs2.getDst() && !this.ccatCircuit.isBidirectional()) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("roueCurrentDrop: setPathProtection");
            }
            if (routePrefs2.getPathProt() != 5) {
                routePrefs2.setPathProt(0);
            }
        }
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs2, this.ccatCircuit);
        netCircuitPath.computeCircuitPath();
        this.ccatCircuit.setCircuitCosts(netCircuitPath.computePathCosts());
        if (bl) {
            LinkedList linkedList2 = netCircuitPath.getAvailSpans();
            for (INetLinkSpan iNetLinkSpan : linkedList2) {
                if (iNetLinkSpan.getLink().isLAP() && this.ccatCircuit.useLAP() != null) {
                    NetLinkSpan netLinkSpan = null;
                    INetCircuitSpan iNetCircuitSpan = NetCircuitManager.instance().getLAPSpan(this.ccatCircuit);
                    netLinkSpan = (NetLinkSpan)iNetCircuitSpan.getNetLinkSpan();
                    iNetLinkSpan.setLoNum(netLinkSpan.getLoNum());
                }
                this.ccatCircuit.addCircuitSpan(iNetLinkSpan, routePrefs2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void deleteDrop(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        NetCcatCircuit netCcatCircuit = this.ccatCircuit;
        synchronized (netCcatCircuit) {
            this.deleteDropCktEnd(iNetCircuitEnd);
        }
        if (this.ccatCircuit.getCktOperation() != 1) {
            this.ccatCircuit.notifyChanged(false);
        }
    }

    @Override
    protected void deleteDropCktEnd(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
        INetCircuit iNetCircuit;
        int n;
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("Deleting drop from circuit");
        }
        if ((n = this.ccatCircuit.getState()) != 0 && n != 1 && n != 5 && n != 3 && !this.ccatCircuit.getCircuitTypeObj().isSVLANType()) {
            throw new IncorrectCircuitState("A circuit drop can be deleted only when its status\nis CREATING, DISCOVERED, DISCOVERED_TL1,  or DROP_PENDING.");
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.ccatCircuit.getCircuitType(), iNetCircuitEnd);
        if (this.ccatCircuit.isMemberOfVcat() && !this.ccatCircuit.isOpenEndedVcatCircuit()) {
            netCircuitEnd.setPathIdentifier(this.ccatCircuit.getPrimarySource().getPathIdentifier());
            if (this.ccatCircuit.memberDropHoLo != null) {
                netCircuitEnd.setHoLoNum(this.ccatCircuit.memberDropHoLo);
            }
        }
        Iterator iterator = this.ccatCircuit.getCktDrops().iterator();
        NetCircuitDropInfo netCircuitDropInfo = null;
        while (iterator.hasNext() && !(netCircuitDropInfo = (NetCircuitDropInfo)iterator.next()).getNetCktEnd().equals(netCircuitEnd)) {
            netCircuitDropInfo = null;
        }
        if (netCircuitDropInfo == null && this.ccatCircuit.memberSecDropHoLo != null) {
            netCircuitEnd.setHoLoNum(this.ccatCircuit.memberSecDropHoLo);
            iterator = this.ccatCircuit.getCktDrops().iterator();
            while (iterator.hasNext() && !(netCircuitDropInfo = (NetCircuitDropInfo)iterator.next()).getNetCktEnd().equals(netCircuitEnd)) {
                netCircuitDropInfo = null;
            }
        } else if (netCircuitDropInfo == null) {
            if (this.ccatCircuit.isMemberOfVcat() && !this.ccatCircuit.isOpenEndedVcatCircuit()) {
                netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.ccatCircuit.getCircuitType(), iNetCircuitEnd);
                netCircuitEnd.setPathIdentifier(this.ccatCircuit.getPrimarySource().getPathIdentifier());
            }
            iterator = this.ccatCircuit.getCktDrops().iterator();
            while (iterator.hasNext() && !(netCircuitDropInfo = (NetCircuitDropInfo)iterator.next()).getNetCktEnd().equals(netCircuitEnd)) {
                netCircuitDropInfo = null;
            }
        }
        if (netCircuitDropInfo == null) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("deleteDrop: unable to find drop");
            }
            throw new ObjNotFound("The drop to be deleted cannot be found.");
        }
        if (n == 1 && this.ccatCircuit.getDropsSize() == 1 && !this.ccatCircuit.isStitchedEthernet()) {
            throw new CannotDeleteLastDrop("The last circuit drop cannot be deleted. \nPlease destroy the circuit instead.");
        }
        int n2 = netCircuitDropInfo.getNetCktEnd().getStage();
        if (n == 3 && n2 != 2) {
            throw new CircuitDropOutstanding("An existing drop cannot be deleted when another drop is pending.");
        }
        INetElement iNetElement = null;
        try {
            iNetElement = netCircuitDropInfo.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in deleteDrop");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            throw new ObjNotFound("The network element cannot be found.");
        }
        NetCircuitNode netCircuitNode = null;
        List list = this.ccatCircuit.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            netCircuitNode = list.size() > 1 ? this.ccatCircuit.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
        }
        if (netCircuitNode == null) {
            this.ccatCircuit.removeDrop(netCircuitDropInfo);
            return;
        }
        if (n2 == 2) {
            netCircuitNode.removeRoutedDrop(netCircuitDropInfo.getNetCktEnd());
            if (netCircuitNode.getDrops().size() == 0 && !netCircuitNode.isNodeDrop()) {
                this.ccatCircuit.removeRoutedSpans();
            }
        } else {
            netCircuitNode.deleteDrop(netCircuitDropInfo.getNetCktEnd());
            try {
                if (this.ccatCircuit.circuitInfoActive()) {
                    this.ccatCircuit.circuitModel().delDrop(netCircuitDropInfo.getNetCktEnd().getCircuitEnd());
                }
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw cannotDeleteLastDrop;
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception");
                }
                throw abstractCmsIOException;
            }
        }
        if (netCircuitNode.getDrops().size() == 0 && !netCircuitNode.isNodeDrop()) {
            this.removeInactiveNodesAndSpans();
        }
        this.ccatCircuit.removeDrop(netCircuitDropInfo);
        if (this.ccatCircuit.getDropsSize() > 0 && n == 3) {
            if (!this.ccatCircuit.circuitInfoActive()) {
                if (this.ccatCircuit.isTl1Ckt()) {
                    this.ccatCircuit.setState(5);
                } else {
                    this.ccatCircuit.setState(4);
                }
            } else {
                this.ccatCircuit.setState(1);
            }
        }
        if (this.ccatCircuit.getCircuitTypeObj().isLoCircuitType() && (iNetCircuit = this.ccatCircuit.useLAP()) != null && netCircuitNode != null && netCircuitNode.getNetElement() == iNetCircuit.getSrcCircuitNode().getNetElement()) {
            this.ccatCircuit.removeCktNode(netCircuitNode);
            ((LoCcatCircuit)this.ccatCircuit).setLap();
        }
    }

    protected void addNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws IncorrectCircuitState {
        List list;
        NetCircuitNode netCircuitNode = null;
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("Adding a Network Element to circuit. NE = " + iNetElement.getName());
        }
        if (!this.ccatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        int n = this.ccatCircuit.getState();
        if (n != 1 && n != 0) {
            throw new IncorrectCircuitState("When adding a network element, the circuit should be in the DISCOVERED or CREATING state.");
        }
        if (this.ccatCircuit.getCircuitTypeObj().isTunnelCircuitType() && n == 1) {
            throw new IncorrectCircuitState("A node cannot be added to a DISCOVERED tunnel.");
        }
        if (this.ccatCircuit.getCircuitTypeObj().isLAPCircuitType() && n == 1) {
            throw new IncorrectCircuitState("A node cannot be added to a DISCOVERED low order aggregation circuit.");
        }
        if (this.ccatCircuit.getCircuitTypeObj().isOchccCircuitType() && n == 1) {
            throw new IncorrectCircuitState("A node cannot be added to a DISCOVERED OCH trail circuit.");
        }
        if (this.ccatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() && n == 1) {
            throw new IncorrectCircuitState("A node cannot be added to a DISCOVERED OCH trail tunnel.");
        }
        if (routePrefs != null) {
            this.ccatCircuit.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        }
        if ((list = this.ccatCircuit.getCircuitNodeFromNE(iNetElement)) != null) {
            if (list.size() > 1) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Error !! MXPN in tunnel/LAP/Ethernet circuit");
                }
            } else {
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createNodeDrop(this.ccatCircuit.getCircuitType(), iNetElement);
        NetCircuitDropInfo netCircuitDropInfo = routePrefs == null ? new NetCircuitDropInfo(netCircuitEnd, 2) : (this.ccatCircuit.getCircuitTypeObj().isLAPCircuitType() ? new NetCircuitDropInfo(netCircuitEnd, this.convertPathProt(routePrefs.getPathProt())) : new NetCircuitDropInfo(netCircuitEnd, 2));
        if (netCircuitNode == null) {
            if (this.ccatCircuit.getCircuitTypeObj().isEthernetCircuitType() && n == 1) {
                throw new IncorrectCircuitState("A node cannot be added to a DISCOVERED Ethernet circuit.");
            }
            if (this.ccatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                boolean bl = ((OchncCircuit)this.ccatCircuit).setCktDstInternalSpliceEnds(iNetElement, routePrefs);
                if (bl) {
                    NetCircuitNode netCircuitNode2 = NetCircuitNodeFactory.createOchTrailTunnelCircuitNode(iNetElement, (OchncCircuit)this.ccatCircuit);
                    NetCircuitNode netCircuitNode3 = NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, (OchncCircuit)this.ccatCircuit);
                    this.ccatCircuit.insertCktNode(netCircuitNode2);
                    netCircuitNode2.addDropInfo(netCircuitDropInfo);
                    netCircuitNode = netCircuitNode3;
                    List list2 = ((OchncCircuit)this.ccatCircuit).getDstInternalSpliceLinkEnds();
                    InternalNetLink internalNetLink = new InternalNetLink(netCircuitNode2.getNetElement(), netCircuitNode3.getNetElement(), ((INetCircuitEnd)list2.get(0)).getEntityIndex(), ((INetCircuitEnd)list2.get(1)).getEntityIndex(), null, null);
                    NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                    NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, netLinkSpan, netCircuitNode2, netCircuitNode3);
                    if (NetCcatCircuitOperator.dbgOn()) {
                        db.println("Created the internal splicing span: OchTrailTunnelNode->OchncNode");
                    }
                    netCircuitSpan.setSrcState(4);
                    netCircuitSpan.setDstState(4);
                    this.ccatCircuit.insertCktSpan(netCircuitSpan);
                    netCircuitNode2.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                    netCircuitNode3.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                    InternalNetLink internalNetLink2 = new InternalNetLink(netCircuitNode3.getNetElement(), netCircuitNode2.getNetElement(), ((INetCircuitEnd)list2.get(2)).getEntityIndex(), ((INetCircuitEnd)list2.get(0)).getEntityIndex(), null, null);
                    netLinkSpan = new NetLinkSpan(internalNetLink2, null, null, null, null);
                    netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, netLinkSpan, netCircuitNode3, netCircuitNode2);
                    if (NetCcatCircuitOperator.dbgOn()) {
                        db.println("Created the internal splicing span: OchncNode->OchTrailTunnelNode");
                    }
                    netCircuitSpan.setSrcState(4);
                    netCircuitSpan.setDstState(4);
                    this.ccatCircuit.insertCktSpan(netCircuitSpan);
                    netCircuitNode3.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                    netCircuitNode2.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                } else {
                    netCircuitNode = NetCircuitNodeFactory.createCircuitNode(iNetElement, this.ccatCircuit);
                }
            } else {
                List list3 = this.ccatCircuit.getXmCircuitEnds();
                netCircuitNode = list3.size() == 0 || ((NetCircuitEnd)list3.get(0)).getNodeId() != iNetElement.getNodeId() ? NetCircuitNodeFactory.createCircuitNode(iNetElement, this.ccatCircuit) : NetCircuitNodeFactory.createDualConnectionCircuitNode(iNetElement, this.ccatCircuit.getCircuitTypeObj(), (HoCcatCircuit)this.ccatCircuit);
            }
            this.ccatCircuit.insertCktNode(netCircuitNode);
        } else if (this.ccatCircuit.getCircuitTypeObj().isEthernetCircuitType() && netCircuitNode.getConnectionType() == 8) {
            throw new IncorrectCircuitState("The node " + iNetElement.getName() + " already exists in the Ethernet circuit.");
        }
        netCircuitNode.addDropInfo(netCircuitDropInfo);
        this.ccatCircuit.insertDrop(netCircuitDropInfo);
        if (n != 0) {
            this.ccatCircuit.setState(3);
        }
    }

    protected void routeNetElement(INetElement iNetElement, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        ICircuitType iCircuitType;
        NetCircuitNode netCircuitNode = null;
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("routeNetElement called for circuit " + this.ccatCircuit.getCircuitName() + ". NE = " + iNetElement.getName());
        }
        if (!((iCircuitType = this.ccatCircuit.getCircuitTypeObj()).isTunnelCircuitType() || iCircuitType.isEthernetCircuitType() || iCircuitType.isLAPCircuitType() || iCircuitType.isOchccCircuitType() || iCircuitType.isOchTrailTunnelCircuitType())) {
            throw new SanityCheckFailed("A network element can only be added to Ethernet or tunnel circuit types.");
        }
        List list = this.ccatCircuit.getCircuitNodeFromNE(iNetElement);
        if (list != null) {
            if (list.size() > 1) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Error !! MXPN in tunnel/LAP/Ethernet circuit");
                }
            } else {
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        if (iCircuitType.isEthernetCircuitType() && this.ccatCircuit.getState() == 1 && netCircuitNode == null) {
            throw new SanityCheckFailed("Automatic routing is supported for only the first network element of an Ethernet circuit.");
        }
        this.addNetElement(iNetElement, routePrefs);
        if (netCircuitNode != null) {
            return;
        }
        try {
            this.routeCurrentDrop(iNetElement, routePrefs, true);
        }
        catch (NoRoute noRoute) {
            block13: {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("routeCurrentDrop failed. deleting the net element");
                }
                try {
                    this.deleteNetElement(iNetElement);
                }
                catch (DeletionError deletionError) {
                    if (!NetCcatCircuitOperator.dbgOn()) break block13;
                    db.println("unable to reverse as deleting routed drop encountered exception " + deletionError.getMessage());
                }
            }
            throw noRoute;
        }
    }

    protected void routeNetElement(INetElement iNetElement, INetElement iNetElement2, RoutePrefs routePrefs) throws SanityCheckFailed, IncorrectCircuitState, CTCUserException, AbstractCmsIOException {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        routePrefs2.setDst(iNetElement);
        if (iNetElement.getNodeId() != iNetElement2.getNodeId()) {
            routePrefs2.setSecDst(iNetElement2);
        }
        if (iNetElement.getNodeId() != iNetElement2.getNodeId()) {
            this.addNetElement(iNetElement2, routePrefs2);
        }
        try {
            this.routeNetElement(iNetElement, routePrefs2);
        }
        catch (NoRoute noRoute) {
            block6: {
                try {
                    this.deleteNetElement(iNetElement2);
                }
                catch (DeletionError deletionError) {
                    if (!NetCcatCircuitOperator.dbgOn()) break block6;
                    db.println("unable to reverse as deleting routed drop encountered exception " + deletionError.getMessage());
                }
            }
            throw noRoute;
        }
    }

    protected void deleteNetElement(INetElement iNetElement) throws ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, DeletionError, SanityCheckFailed {
        block17: {
            Object object;
            List list;
            NetCircuitNode netCircuitNode = null;
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("Deleting Net Element from circuit. Node = " + iNetElement.getName());
            }
            if ((list = this.ccatCircuit.getCircuitNodeFromNE(iNetElement)) != null) {
                if (list.size() > 1) {
                    if (this.ccatCircuit.getCircuitTypeObj().isOchncType() || this.ccatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                        object = list.iterator();
                        NetCircuitNode netCircuitNode2 = null;
                        while (object.hasNext()) {
                            netCircuitNode2 = (NetCircuitNode)object.next();
                            if (!netCircuitNode2.isOchncCircuitNode()) continue;
                            netCircuitNode = netCircuitNode2;
                            break;
                        }
                    } else if (NetCcatCircuitOperator.dbgOn()) {
                        db.println("Error !! MXPN in tunnel/LAP/Ethernet circuit");
                    }
                } else {
                    netCircuitNode = (NetCircuitNode)list.get(0);
                }
            }
            if (netCircuitNode == null) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Warning! unable to find circuit node");
                }
                throw new ObjNotFound("The network element cannot be found.");
            }
            if (netCircuitNode == this.ccatCircuit.getSrcCircuitNode()) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Cannot delete source circuit node");
                }
                throw new SanityCheckFailed("The source circuit node cannot be deleted.");
            }
            if (this.ccatCircuit.getCircuitTypeObj().isEthernetCircuitType() && netCircuitNode.getDrops().size() > 0) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Cannot delete Ethernet circuit node with HO drops.");
                }
                throw new SanityCheckFailed("Nodes with drops cannot be deleted. \nPlease delete all of a node's drops before deleting the node.");
            }
            object = NetCircuitEndFactory.createNodeDrop(this.ccatCircuit.getCircuitType(), iNetElement);
            try {
                this.deleteDropCktEnd((INetCircuitEnd)object);
            }
            catch (CircuitDropOutstanding circuitDropOutstanding) {
                if (!NetCcatCircuitOperator.dbgOn()) break block17;
                db.println("deleteNetElement- circuit drop outstanding " + circuitDropOutstanding);
            }
        }
    }

    protected void addCircuitSpan(INetLinkSpan iNetLinkSpan, RoutePrefs routePrefs) throws NoRoute {
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        INetLink iNetLink = iNetLinkSpan.getLink();
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("addCircuitSpan " + ((NetLinkSpan)iNetLinkSpan).prettyString() + " to circuit " + NetCcatCircuit.prettyString(this.ccatCircuit.getCircuitId()));
        }
        if (this.ccatCircuit.getCircuitSpanFromNetLink(iNetLink) != null) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("addCircuitSpan: span already in list; ignored");
            }
            return;
        }
        List list = this.ccatCircuit.getCircuitNodeFromNE(iNetLink.getSrc());
        if (list != null) {
            if (list.size() > 1) {
                if (this.ccatCircuit.getCircuitTypeObj().isOchncType() || this.ccatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() || this.ccatCircuit.getCircuitTypeObj().isSVLANType()) {
                    netCircuitNode = this.fillNcnForCircuit2(iNetLinkSpan, this.ccatCircuit, true);
                } else if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Error !! MXPN in NetCcatCircuit::addCircuitSpan");
                }
            } else {
                this.sanityCheckRegenNode(iNetLink, this.ccatCircuit, true);
                netCircuitNode = (NetCircuitNode)list.get(0);
            }
        }
        if ((list = this.ccatCircuit.getCircuitNodeFromNE(iNetLink.getDst())) != null) {
            if (list.size() > 1) {
                if (this.ccatCircuit.getCircuitTypeObj().isOchncType() || this.ccatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() || this.ccatCircuit.getCircuitTypeObj().isSVLANType()) {
                    netCircuitNode2 = this.fillNcnForCircuit2(iNetLinkSpan, this.ccatCircuit, false);
                } else if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Error !! MXPN in NetCcatCircuit::addCircuitSpan");
                }
            } else {
                this.sanityCheckRegenNode(iNetLink, this.ccatCircuit, false);
                netCircuitNode2 = (NetCircuitNode)list.get(0);
            }
        }
        if (netCircuitNode == null || !this.doesNodeMatchSpanRole(netCircuitNode, iNetLinkSpan)) {
            netCircuitNode = this.fillNcnForCircuit(iNetLink, this.ccatCircuit, true);
        }
        if (netCircuitNode2 == null || !this.doesNodeMatchSpanRole(netCircuitNode2, iNetLinkSpan)) {
            netCircuitNode2 = this.fillNcnForCircuit(iNetLink, this.ccatCircuit, false);
        }
        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, (NetLinkSpan)iNetLinkSpan, netCircuitNode, netCircuitNode2);
        netCircuitSpan.setSrcState(2);
        netCircuitSpan.setDstState(2);
        this.ccatCircuit.insertCktSpan(netCircuitSpan);
        if (!this.ccatCircuit.isBidirectional()) {
            if (iNetLinkSpan.getOmni()) {
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            } else {
                netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            }
        } else if (this.ccatCircuit.getCircuitTypeObj().isOchncType() || this.ccatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
        } else {
            netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
    }

    private boolean isSrcOrDstCircuitNode(OchncCircuitNode ochncCircuitNode) {
        INetCircuitNode iNetCircuitNode;
        if (this.ccatCircuit.getDropNE().equals(ochncCircuitNode.ne) || this.ccatCircuit.getSourceNE().equals(ochncCircuitNode.ne)) {
            return true;
        }
        for (NetCircuitSpan netCircuitSpan : ochncCircuitNode.getInSpans()) {
            if (!netCircuitSpan.getLink().isVirtual() || !(netCircuitSpan instanceof OchncCircuitSpan) || !((iNetCircuitNode = netCircuitSpan.getSrcNCN()) instanceof OchTrailTunnelNode)) continue;
            return true;
        }
        for (NetCircuitSpan netCircuitSpan : ochncCircuitNode.getOutSpans()) {
            if (!netCircuitSpan.getLink().isVirtual() || !(netCircuitSpan instanceof OchncCircuitSpan) || !((iNetCircuitNode = netCircuitSpan.getDstNCN()) instanceof OchTrailTunnelNode)) continue;
            return true;
        }
        return false;
    }

    private boolean doesNodeMatchSpanRole(NetCircuitNode netCircuitNode, INetLinkSpan iNetLinkSpan) {
        if (netCircuitNode instanceof OchncCircuitNode) {
            if (this.isSrcOrDstCircuitNode((OchncCircuitNode)netCircuitNode)) {
                return true;
            }
            Iterator iterator = netCircuitNode.getAllSpans().keySet().iterator();
            if (!iterator.hasNext()) {
                return false;
            }
            while (iterator.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (netCircuitSpan.getNetLinkSpan().getProtectionRole() != iNetLinkSpan.getProtectionRole()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    private NetCircuitNode fillNcnForCircuit2(INetLinkSpan iNetLinkSpan, NetCcatCircuit netCcatCircuit, boolean bl) throws NoRoute {
        NetCircuitNode netCircuitNode;
        block14: {
            IEntityModel iEntityModel;
            INetElement iNetElement;
            block17: {
                block19: {
                    NetCircuitNode netCircuitNode2;
                    block18: {
                        int n;
                        block16: {
                            block15: {
                                INetLink iNetLink = iNetLinkSpan.getLink();
                                netCircuitNode = null;
                                iNetElement = null;
                                n = 0;
                                if (bl) {
                                    iNetElement = iNetLink.getSrc();
                                    n = iNetLink.getSrcEntityIndex();
                                } else {
                                    iNetElement = iNetLink.getDst();
                                    n = iNetLink.getDstEntityIndex();
                                }
                                if (!netCcatCircuit.getCircuitTypeObj().isSVLANType()) break block15;
                                List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
                                for (SvlanCircuitNode svlanCircuitNode : list) {
                                    if (svlanCircuitNode.getInternalEntityIdx() != SvlanCircuitHelper.getGZOtherTrunkPort(iNetElement, n)) continue;
                                    netCircuitNode = svlanCircuitNode;
                                    if (!NetCcatCircuitOperator.dbgOn()) break;
                                    db.println("fillNcnForCircuit2(): returning cktnode with intEntity " + Integer.toHexString(svlanCircuitNode.getInternalEntityIdx()));
                                    break;
                                }
                                if (netCircuitNode != null || !NetCcatCircuitOperator.dbgOn()) break block14;
                                db.println("fillNcnForCircuit2(): Error !! SVLAN xc not found for " + Integer.toHexString(n));
                                break block14;
                            }
                            if (!iNetElement.equals(netCcatCircuit.getPrimarySource().getNetElement()) && !iNetElement.equals(netCcatCircuit.getPrimaryDrop().getNetElement())) break block16;
                            List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
                            for (NetCircuitNode netCircuitNode3 : list) {
                                if (!netCircuitNode3.isOchncCircuitNode()) continue;
                                netCircuitNode = netCircuitNode3;
                                break block14;
                            }
                            break block14;
                        }
                        iEntityModel = null;
                        int n2 = netCcatCircuit.getCircuitOptChannel();
                        iEntityModel = OchTrailHelper.getColocatedTrunkPort(iNetElement, n, n2);
                        if (iEntityModel == null) break block17;
                        netCircuitNode2 = ((OchncCircuit)netCcatCircuit).findOchTrailTunnelNode(iNetElement, iEntityModel, true);
                        if (netCircuitNode2 != null) break block18;
                        if (!NetCcatCircuitOperator.dbgOn()) break block14;
                        db.println("Error !! This looks like an error case..because we found that in an intermediate node of ochtrail thereare multiple NCNs and a colocated trunk port..but no ochtrailtunnelnode exist for " + iEntityModel.getEntityIndex());
                        break block14;
                    }
                    NetCircuitNode netCircuitNode4 = ((OchTrailTunnelNode)netCircuitNode2).findColocatedOchncCircuitNode();
                    if (netCircuitNode4 == null) break block19;
                    netCircuitNode = netCircuitNode4;
                    break block14;
                }
                if (!NetCcatCircuitOperator.dbgOn()) break block14;
                db.println("Error !! found co-located trail tunnel node w/o ochnccircuit node");
                break block14;
            }
            List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
            Iterator iterator = list.iterator();
            if (list.size() > 2) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("Error..NCP has modelled this as a regen node with four XC there are multiple NCNs..but no colocated trunk port !!!");
                }
                IEntityTableModel iEntityTableModel = iNetElement.getNodeModel().getEntityTable();
                IEntityModel iEntityModel2 = null;
                if (iEntityTableModel != null) {
                    while (iterator.hasNext()) {
                        NetCircuitNode netCircuitNode5 = (NetCircuitNode)iterator.next();
                        if (!netCircuitNode5.isOchTrailTunnelNode()) continue;
                        int n = ((OchTrailTunnelNode)netCircuitNode5).getEntityIndexFromSpans();
                        try {
                            iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                            if (!Feature.provides((INodeModel)iNetElement.getNodeModel(), (Feature)Feature.OTU2_XP)) break;
                            iEntityModel2 = ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel();
                            break;
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (!db.on()) continue;
                            db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                        }
                        catch (Exception exception) {
                            if (!db.on()) continue;
                            db.println("getTunnelEntityIndex: Exception " + exception);
                        }
                    }
                }
                if (iEntityModel != null && iEntityModel2 != null) {
                    throw new NoRoute("Trunk ports of regen card on " + iNetElement.getName() + ", " + CircuitMapUtil.getSpanLabel(iEntityModel, null, null) + " and " + "\n" + CircuitMapUtil.getSpanLabel(iEntityModel2, null, null) + ", are connected to wrong sides.");
                }
                throw new NoRoute("Trunk ports of regen card on " + iNetElement.getName() + " are connected to wrong sides.");
            }
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("Intermediate node of ochnc/trail with multiple NCNs.");
            }
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode6 = (NetCircuitNode)iterator.next();
                if (!netCircuitNode6.isOchncCircuitNode() || !this.doesNodeMatchSpanRole(netCircuitNode6, iNetLinkSpan)) continue;
                netCircuitNode = netCircuitNode6;
                break;
            }
        }
        return netCircuitNode;
    }

    private NetCircuitNode fillNcnForCircuit(INetLink iNetLink, NetCcatCircuit netCcatCircuit, boolean bl) throws NoRoute {
        NetCircuitNode netCircuitNode = null;
        INetElement iNetElement = null;
        int n = 0;
        if (bl) {
            iNetElement = iNetLink.getSrc();
            n = iNetLink.getSrcEntityIndex();
        } else {
            iNetElement = iNetLink.getDst();
            n = iNetLink.getDstEntityIndex();
        }
        if ((netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() || netCcatCircuit.getCircuitTypeObj().isOchncType()) && Feature.provides((INodeModel)iNetElement.getNodeModel(), (Feature)Feature.OTU2_XP) && netCcatCircuit.isBidirectional()) {
            IEntityModel iEntityModel = null;
            int n2 = netCcatCircuit.getCircuitOptChannel();
            iEntityModel = OchTrailHelper.getColocatedTrunkPort(iNetElement, n, n2);
            if (iEntityModel != null) {
                IEntityModel iEntityModel2;
                block17: {
                    iEntityModel2 = null;
                    try {
                        iEntityModel2 = ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel();
                    }
                    catch (Exception exception) {
                        if (!NetCcatCircuitOperator.dbgOn()) break block17;
                        db.println("Error !! retrieving regen peer model");
                    }
                }
                if (iEntityModel2 != null) {
                    INetCircuitEnd[] iNetCircuitEndArray = netCcatCircuit.fillInternalSpliceLinks(iNetElement, iEntityModel.getEntityIndex(), n2, true);
                    INetCircuitEnd[] iNetCircuitEndArray2 = netCcatCircuit.fillInternalSpliceLinks(iNetElement, iEntityModel2.getEntityIndex(), n2, true);
                    if (NetCcatCircuitOperator.dbgOn()) {
                        db.println("regen node found" + ((IPortModel)iEntityModel).getPortNum()[0] + "->" + ((IPortModel)iEntityModel2).getPortNum()[0]);
                    }
                    if (iNetCircuitEndArray != null && iNetCircuitEndArray2 != null) {
                        NetCircuitNode netCircuitNode2 = null;
                        NetCircuitNode netCircuitNode3 = null;
                        NetCircuitNode netCircuitNode4 = NetCircuitNodeFactory.createOchTrailTunnelCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
                        NetCircuitNode netCircuitNode5 = NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
                        netCcatCircuit.insertCktNode(netCircuitNode4);
                        netCcatCircuit.insertCktNode(netCircuitNode5);
                        InternalNetLink internalNetLink = new InternalNetLink(netCircuitNode4.getNetElement(), netCircuitNode5.getNetElement(), iNetCircuitEndArray[0].getEntityIndex(), iNetCircuitEndArray[1].getEntityIndex(), null, null);
                        NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                        NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode4, netCircuitNode5);
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Created the internal splicing span: OchTrailTunnelNode->OchncNode");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        netCircuitNode4.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                        netCircuitNode5.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                        netCcatCircuit.insertCktSpan(netCircuitSpan);
                        InternalNetLink internalNetLink2 = new InternalNetLink(netCircuitNode5.getNetElement(), netCircuitNode4.getNetElement(), iNetCircuitEndArray[2].getEntityIndex(), iNetCircuitEndArray[0].getEntityIndex(), null, null);
                        netLinkSpan = new NetLinkSpan(internalNetLink2, null, null, null, null);
                        netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode5, netCircuitNode4);
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Created the internal splicing span: OchncNode->OchTrailTunnelNode");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        netCircuitNode5.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                        netCircuitNode4.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                        netCcatCircuit.insertCktSpan(netCircuitSpan);
                        netCircuitNode = netCircuitNode5;
                        netCircuitNode2 = netCircuitNode4;
                        netCircuitNode4 = NetCircuitNodeFactory.createOchTrailTunnelCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
                        netCircuitNode5 = NetCircuitNodeFactory.createOchncCircuitNode(iNetElement, (OchncCircuit)netCcatCircuit);
                        netCcatCircuit.insertCktNode(netCircuitNode4);
                        netCcatCircuit.insertCktNode(netCircuitNode5);
                        internalNetLink = new InternalNetLink(netCircuitNode4.getNetElement(), netCircuitNode5.getNetElement(), iNetCircuitEndArray2[0].getEntityIndex(), iNetCircuitEndArray2[1].getEntityIndex(), null, null);
                        netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                        netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode4, netCircuitNode5);
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Created the internal splicing span: OchTrailTunnelNode->OchncNode");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        netCircuitNode4.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                        netCircuitNode5.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                        netCcatCircuit.insertCktSpan(netCircuitSpan);
                        internalNetLink2 = new InternalNetLink(netCircuitNode5.getNetElement(), netCircuitNode4.getNetElement(), iNetCircuitEndArray2[2].getEntityIndex(), iNetCircuitEndArray2[0].getEntityIndex(), null, null);
                        netLinkSpan = new NetLinkSpan(internalNetLink2, null, null, null, null);
                        netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode5, netCircuitNode4);
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Created the internal splicing span: OchncNode->OchTrailTunnelNode");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        netCircuitNode5.addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                        netCircuitNode4.addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                        netCcatCircuit.insertCktSpan(netCircuitSpan);
                        netCircuitNode3 = netCircuitNode4;
                        internalNetLink = new InternalNetLink(netCircuitNode2.getNetElement(), netCircuitNode3.getNetElement(), iEntityModel.getEntityIndex(), iEntityModel2.getEntityIndex(), null, null);
                        netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
                        netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode2, netCircuitNode3);
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Created the internal splicing span between regen trunk ports: OchTrailTunnelNode->OchTrailTunnelNode" + iEntityModel.getEntityIndex() + "->" + iEntityModel2.getEntityIndex());
                            db.println("port numbers" + ((IPortModel)iEntityModel).getPortNum()[0] + "->" + ((IPortModel)iEntityModel2).getPortNum()[0]);
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        netCircuitNode2.addActiveSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                        netCircuitNode3.addActiveSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                        netCcatCircuit.insertCktSpan(netCircuitSpan);
                    } else {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Error !! co located trunk port found. but not ableto fill internal splice link ends");
                        }
                        throw new NoRoute("Trunk ports of regen card on " + iNetElement.getName() + ", " + CircuitMapUtil.getSpanLabel(iEntityModel, null, null) + " and " + "\n" + CircuitMapUtil.getSpanLabel(iEntityModel2, null, null) + ", are not connected to OCH units using " + "the specified circuit" + "\n" + "wavelength " + Wavelength.getWavelengthStringFromWavelength(n2) + "." + "\n" + "This could be because only one set of patchcords has been created, or the two" + "\n" + "sets of patchcords are using two different wavelengths.");
                    }
                }
            }
        }
        if (netCircuitNode == null) {
            netCircuitNode = NetCircuitNodeFactory.newNodeForAddSpan(iNetElement, netCcatCircuit);
            netCcatCircuit.insertCktNode(netCircuitNode);
        }
        return netCircuitNode;
    }

    private void sanityCheckRegenNode(INetLink iNetLink, NetCcatCircuit netCcatCircuit, boolean bl) throws NoRoute {
        INetElement iNetElement = null;
        int n = 0;
        if (bl) {
            iNetElement = iNetLink.getSrc();
            n = iNetLink.getSrcEntityIndex();
        } else {
            iNetElement = iNetLink.getDst();
            n = iNetLink.getDstEntityIndex();
        }
        if ((netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType() || netCcatCircuit.getCircuitTypeObj().isOchncType()) && Feature.provides((INodeModel)iNetElement.getNodeModel(), (Feature)Feature.OTU2_XP) && netCcatCircuit.isBidirectional() && !iNetElement.equals(netCcatCircuit.getPrimarySource().getNetElement()) && !iNetElement.equals(netCcatCircuit.getPrimaryDrop().getNetElement())) {
            IEntityModel iEntityModel = null;
            int n2 = netCcatCircuit.getCircuitOptChannel();
            iEntityModel = OchTrailHelper.getColocatedTrunkPort(iNetElement, n, n2);
            if (iEntityModel != null) {
                IEntityModel iEntityModel2;
                block9: {
                    iEntityModel2 = null;
                    try {
                        iEntityModel2 = ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel();
                    }
                    catch (Exception exception) {
                        if (!NetCcatCircuitOperator.dbgOn()) break block9;
                        db.println("Error !! retrieving regen peer model");
                    }
                }
                if (iEntityModel2 != null) {
                    INetCircuitEnd[] iNetCircuitEndArray = netCcatCircuit.fillInternalSpliceLinks(iNetElement, iEntityModel.getEntityIndex(), n2, true);
                    INetCircuitEnd[] iNetCircuitEndArray2 = netCcatCircuit.fillInternalSpliceLinks(iNetElement, iEntityModel2.getEntityIndex(), n2, true);
                    if (iNetCircuitEndArray != null || iNetCircuitEndArray2 != null) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("regen node found" + ((IPortModel)iEntityModel).getPortNum()[0] + "->" + ((IPortModel)iEntityModel2).getPortNum()[0]);
                            db.println("But this should have been modelled as either four XC or routing should fail");
                        }
                        throw new NoRoute("Trunk ports of regen card on " + iNetElement.getName() + ", " + CircuitMapUtil.getSpanLabel(iEntityModel, null, null) + " and " + "\n" + CircuitMapUtil.getSpanLabel(iEntityModel2, null, null) + ", are not connected to OCH units using " + "the specified circuit" + "\n" + "wavelength " + Wavelength.getWavelengthStringFromWavelength(n2) + "." + "\n" + "This could be because only one set of patchcords has been created, or the two" + "\n" + "sets of patchcords are using two different wavelengths.");
                    }
                }
            }
        }
    }

    protected void removeRoutedCircuitSpan(INetLinkSpan iNetLinkSpan) {
        int n;
        int n2;
        NetCircuitSpan netCircuitSpan;
        INetLink iNetLink = iNetLinkSpan.getLink();
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("removeRoutedCircuitSpan " + iNetLinkSpan.getLink().prettyString() + " from circuit " + NetCcatCircuit.prettyString(this.ccatCircuit.getCircuitId()));
        }
        if ((netCircuitSpan = (NetCircuitSpan)this.ccatCircuit.getCircuitSpanFromNetLink(iNetLink)) == null) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("removeRoutedCircuitSpan: WARNING!! span not found");
            }
            return;
        }
        if (netCircuitSpan.getSrcState() != 2 && netCircuitSpan.getDstState() != 2) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("removeRoutedCircuitSpan: WARNING span not ROUTED; skipping...");
            }
            return;
        }
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("removeRoutedCircuitSpan: " + iNetLink.prettyString());
        }
        NetCircuitNode netCircuitNode = (NetCircuitNode)netCircuitSpan.getSrcNCN();
        NetCircuitNode netCircuitNode2 = (NetCircuitNode)netCircuitSpan.getDstNCN();
        this.ccatCircuit.removeCktSpan(netCircuitSpan);
        if (!this.ccatCircuit.isBidirectional()) {
            if (netCircuitSpan.isUpsr() || netCircuitSpan.getNetLinkSpan().getOmni()) {
                netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            }
            n2 = netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            n = netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
        } else {
            n2 = netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
            n = netCircuitNode2.removeRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
        }
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("removeRoutedCircuitSpan: After remove, srcPaths=" + n2 + " dstPaths=" + n);
        }
        if (n2 == 0) {
            this.ccatCircuit.removeCktNode(netCircuitNode);
        }
        if (n == 0) {
            this.ccatCircuit.removeCktNode(netCircuitNode2);
        }
    }

    protected void addCircuitSpan(NetLinkSpan netLinkSpan, NetCircuitNode netCircuitNode, eSpanDirection eSpanDirection2) {
        NetCircuitSpan netCircuitSpan = null;
        netCircuitSpan = (NetCircuitSpan)this.ccatCircuit.getCircuitSpanFromNetLink(netLinkSpan.getLink());
        if (netCircuitSpan == null) {
            netCircuitSpan = eSpanDirection2 == eSpanDirection.ORIGINATING ? NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, netLinkSpan, netCircuitNode, null) : (eSpanDirection2 == eSpanDirection.TERMINATING ? NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, netLinkSpan, null, netCircuitNode) : (netLinkSpan.getLink().getSrc().equals(netCircuitNode.getNetElement()) ? NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, netLinkSpan, netCircuitNode, null) : NetCircuitSpanFactory.createCircuitSpan(this.ccatCircuit, netLinkSpan, null, netCircuitNode)));
        }
        netCircuitSpan.setSrcState(2);
        netCircuitSpan.setDstState(2);
        this.ccatCircuit.insertCktSpan(netCircuitSpan);
        netCircuitNode.addRoutedSpan(netCircuitSpan, eSpanDirection2);
        if (netLinkSpan.getLink().getSrc().equals(netCircuitNode.getNetElement())) {
            if (netCircuitSpan.getSrcNCN() == null) {
                netCircuitSpan.setSrcNCN(netCircuitNode);
            }
        } else if (netCircuitSpan.getDstNCN() == null) {
            netCircuitSpan.setDstNCN(netCircuitNode);
        }
    }

    protected void deleteCircuitSpan(NetLinkSpan netLinkSpan, NetCircuitNode netCircuitNode, eSpanDirection eSpanDirection2) {
        NetCircuitSpan netCircuitSpan = (NetCircuitSpan)this.ccatCircuit.getCircuitSpanFromNetLink(netLinkSpan.getLink());
        if (netCircuitSpan == null) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("deleteCircuitSpan: WARNING - ckt span not found for link " + netLinkSpan.getLink().prettyString());
            }
            return;
        }
        this.ccatCircuit.removeCktSpan(netCircuitSpan);
        netCircuitNode.removeRoutedSpan(netCircuitSpan, eSpanDirection2);
    }

    protected void sanityCheck() throws SanityCheckFailed {
        boolean bl = false;
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("sanityCheck() called for " + this.ccatCircuit.getCircuitName());
        }
        if (!this.ccatCircuit.isCircuitRefValid()) {
            throw new SanityCheckFailed("The circuit was already destroyed.");
        }
        int n = this.ccatCircuit.getMemberPrefs() == null ? 9 : this.ccatCircuit.getMemberPrefs().getPathProtection();
        this.sanityCheckOpenEndUpsr(n);
        int n2 = 0;
        int n3 = 0;
        for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
            int n4 = netCircuitNode.sanityCheck();
            netCircuitNode.setupConnListOnCreation(n4);
            if (n4 == 10) {
                if (netCircuitNode.isConnPartofBlsrDri()) continue;
                ++n2;
                continue;
            }
            if (n4 != 11) continue;
            ++n3;
        }
        this.ccatCircuit.getMarker().markUpsr();
        this.ccatCircuit.getMarker().markDri();
        if (n2 % 2 != 0 || n3 % 2 != 0) {
            throw new SanityCheckFailed("An invalid number of DRI/IDRI nodes exists.\nDRI=" + n2 + "\nIDRI=" + n3 + "\n");
        }
        if (this.ccatCircuit.getDropsSize() == 1 && this.ccatCircuit.getSourcesSize() == 1 && !this.ccatCircuit.hasBlsrDri() && n2 % 4 != 0) {
            throw new SanityCheckFailed("An invalid number (" + n2 + ") of DRI nodes exist.\n" + "On single source, single destination circuits, DRI nodes should occur in multiples of four.");
        }
        for (NetCircuitDropInfo netCircuitDropInfo : this.ccatCircuit.getCktDrops()) {
            if (this.ccatCircuit.getCktOperation() != 5 && netCircuitDropInfo.getNetCktEnd().getStage() != 2 || netCircuitDropInfo.getPathProt() != 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("SanityCheck: passed for unprotected circuit " + this.ccatCircuit.getCircuitName());
            }
            return;
        }
        if (this.ccatCircuit.isUpsr1wayTl1()) {
            this.sanityCheckSelectorDropProtection();
        }
        for (NetCircuitSpan netCircuitSpan : this.ccatCircuit.getCircuitSpans()) {
            int n5 = netCircuitSpan.getProtectionType();
            if (NetProtectionType.isProtectedType(n5)) continue;
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("SanityCheck: Path protection not available to outstanding drops. Protection type " + EnumStrings.getString(INetProtectionType.class, (int)n5));
            }
            throw new SanityCheckFailed("The specified path is not protected. Check the span " + netCircuitSpan.getLink().prettyString() + ".");
        }
        for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
            if (!netCircuitNode.hasUnprotectedSelector()) continue;
            throw new SanityCheckFailed("The selector connection on the node " + netCircuitNode.getName() + " is unprotected.");
        }
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("SanityCheck: passed for " + this.ccatCircuit.getCircuitName());
        }
        this.ccatCircuit.getSpansToRollback().clear();
    }

    protected void sanityCheckSelectorDropProtection() throws SanityCheckFailed {
        for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
            if (netCircuitNode.getState() != 0 && netCircuitNode.getState() != 3 || netCircuitNode.getOperator().sanityCheckSelectorDropProtection()) continue;
            throw new SanityCheckFailed("The selector drop on the node " + netCircuitNode.getName() + " lacks two valid input paths.");
        }
    }

    protected void sanityCheckManualRouting() throws SanityCheckFailed {
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("calling sanityCheckManualRouting");
        }
        List list = this.ccatCircuit.getCircuitNodes();
        Map map = this.ccatCircuit.getCircuitNodesMap();
        try {
            if (!this.ccatCircuit.isCircuitRefValid()) {
                throw new SanityCheckFailed("The circuit was already destroyed.");
            }
            if (this.ccatCircuit.getRoutedCircuitSpans().size() == 0 && this.ccatCircuit.getCircuitNodes().size() != 1) {
                throw new SanityCheckFailed("The \"Included Spans\" list does not route to the drop.");
            }
            int n = this.ccatCircuit.getMemberPrefs() == null ? 9 : this.ccatCircuit.getMemberPrefs().getPathProtection();
            this.sanityCheckCircuitInputs(n);
            this.sanityCheckBlsrDriHandoffs();
            for (NetCircuitNode netCircuitNode : list) {
                int n2 = netCircuitNode.getOperator().sanityCheckGetConnType();
                netCircuitNode.setConnectionType(n2);
                netCircuitNode.setupConnListOnCreation(n2);
            }
            for (NetCircuitNode netCircuitNode : list) {
                netCircuitNode.findUpsrHeads();
            }
            this.sanityCheckBlsrDri(map);
            RouteValidator.instance().validateRoute(this.ccatCircuit);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.ccatCircuit.getState() != 3) {
                for (NetCircuitNode netCircuitNode : list) {
                    netCircuitNode.resetDriNodeType();
                    if (!NetCcatCircuitOperator.dbgOn()) continue;
                    db.println("resetting DRI node type of " + netCircuitNode);
                }
            }
            throw sanityCheckFailed;
        }
    }

    protected void sanityCheckBlsrDriHandoffs() throws SanityCheckFailed {
        MemberPrefs memberPrefs = this.ccatCircuit.getMemberPrefs();
        if (memberPrefs == null) {
            return;
        }
        if (memberPrefs.getDriNodePrefs().size() == 0) {
            return;
        }
        NetCircuitNode netCircuitNode = null;
        NetCircuitNode netCircuitNode2 = null;
        List list = memberPrefs.getDriNodePrefs();
        for (DriNodes driNodes : list) {
            List list2 = driNodes.getNodePairs();
            for (DriNodePair driNodePair : list2) {
                List list3 = this.ccatCircuit.getCircuitNodeFromNE(driNodePair.getPrimary());
                if (list3 != null) {
                    if (list3.size() > 1) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Error!! MXPN in BLSR-DRI case");
                        }
                    } else {
                        netCircuitNode = (NetCircuitNode)list3.get(0);
                    }
                } else {
                    netCircuitNode = null;
                }
                if ((list3 = this.ccatCircuit.getCircuitNodeFromNE(driNodePair.getSecondary())) != null) {
                    if (list3.size() > 1) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Error!! MXPN in BLSR-DRI case");
                        }
                    } else {
                        netCircuitNode2 = (NetCircuitNode)list3.get(0);
                    }
                } else {
                    netCircuitNode2 = null;
                }
                if (netCircuitNode == null) {
                    throw new SanityCheckFailed("The primary node is missing from the circuit path.");
                }
                if (netCircuitNode2 == null) {
                    throw new SanityCheckFailed("The secondary node is missing from the circuit path.");
                }
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("sanityCheckBlsrDriHandoffs: primary " + netCircuitNode.getName() + " secondary " + netCircuitNode2.getName());
                }
                ConnectionValidator.instance().sanityCheckBlsrDriPrimaryNode(netCircuitNode);
                this.ccatCircuit.getMarker().markBlsrDriInterConnectSpans(netCircuitNode, netCircuitNode2, driNodes.getDriType());
            }
        }
    }

    private void sanityCheckCircuitInputs(int n) throws SanityCheckFailed {
        block40: {
            INetCircuit iNetCircuit;
            Object object;
            Object object2;
            block41: {
                Object object3;
                Object object4;
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("SanityCheckCircuitInputs: Circuit state: " + EnumStrings.getString(INetCircuitState.class, (int)this.ccatCircuit.getState()));
                }
                if (this.ccatCircuit.getState() == 0) {
                    Object object5;
                    INetLink iNetLink;
                    int n2;
                    int n3 = this.ccatCircuit.getUniqueNumSrcDstNodes();
                    if (NetCcatCircuitOperator.dbgOn()) {
                        db.println("SanityCheckCircuitInputs:: Number of unique Nodes: " + n3);
                    }
                    if (n3 == 4) {
                        throw new SanityCheckFailed("A circuit cannot have four unique nodes as its endpoints.");
                    }
                    if (n3 == 3) {
                        object2 = this.ccatCircuit.getDrops();
                        if (object2.size() == 2 && ((NetCircuitDropInfo)object2.get(0)).getNodeId() != ((NetCircuitDropInfo)object2.get(1)).getNodeId() && !this.ccatCircuit.isBidirectional()) {
                            if (n == 0 && n == 5) {
                                throw new SanityCheckFailed("A unidirectional circuit with two drops on different nodes must be unprotected.");
                            }
                        } else if (n != 9 && n != 0 && n != 5) {
                            throw new SanityCheckFailed("If three unique nodes are used to create a circuit, that circuit must be protected.");
                        }
                    }
                    if (this.ccatCircuit.getSourcesSize() == 2) {
                        int n4 = this.ccatCircuit.getPrimarySource().getNodeId();
                        if (n4 != (n2 = this.ccatCircuit.getSecondarySource().getNodeId()) && this.ccatCircuit.useLAP() != null) {
                            throw new SanityCheckFailed("The use of a VC/VT aggregation circuit is not supported.");
                        }
                        if (n4 == n2 && n == 5 && n3 != 1) {
                            throw new SanityCheckFailed("DRI circuits cannot have two sources on same node.");
                        }
                    }
                    if (this.ccatCircuit.getDropsSize() == 2) {
                        int n5;
                        object2 = this.ccatCircuit.getCktDrops();
                        n2 = ((NetCircuitDropInfo)object2.get(0)).getNodeId();
                        if (n2 != (n5 = ((NetCircuitDropInfo)object2.get(1)).getNodeId()) && this.ccatCircuit.useLAP() != null) {
                            throw new SanityCheckFailed("The use of a VC/VT aggregation circuit is not supported.");
                        }
                        if (n2 == n5 && n == 5 && n3 != 1) {
                            throw new SanityCheckFailed("A DRI circuit cannot have two drops on the same node.");
                        }
                    }
                    if (this.ccatCircuit.isMonitorCircuit()) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("SanityCheckCircuitInputs: Monitor Circuit");
                        }
                        return;
                    }
                    object2 = this.ccatCircuit.getPrimarySource();
                    object4 = this.ccatCircuit.getPrimaryDrop();
                    object3 = null;
                    object = null;
                    if (object2 != null) {
                        object3 = Network.instance().findNetLinkFromSource(false, object2.getNetElement(), object2.getEntityIndex(), object2.getHoNum());
                    }
                    if (object4 != null) {
                        object = Network.instance().findNetLinkFromSource(false, object4.getNetElement(), object4.getEntityIndex(), object4.getHoNum());
                    }
                    LinkedList<Object> linkedList = new LinkedList<Object>();
                    if (object3 != null) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Found a netLink for Source End point: " + object3.prettyString());
                        }
                        if ((iNetLink = Network.instance().findReverseLink((INetLink)object3)) != null) {
                            if (NetCcatCircuitOperator.dbgOn()) {
                                db.println("Found reverse netLink for Source End point: " + iNetLink.prettyString());
                            }
                            if (object3.getProtectionType() == 4 || object3.getProtectionType() == 0) {
                                object5 = new NetLinkSpan((INetLink)object3, iNetLink, object2.getHoNum(), object2.getHoNum(), object2.getLoNum());
                                linkedList.add(object5);
                                if (NetCcatCircuitOperator.dbgOn()) {
                                    db.println("SanityCheckCircuitInputs: Adding: " + ((NetLinkSpan)object5).prettyString());
                                }
                            }
                        }
                    }
                    if (object != null) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("Found a netLink for Destination End point: " + object.prettyString());
                        }
                        if ((iNetLink = Network.instance().findReverseLink((INetLink)object)) != null) {
                            if (NetCcatCircuitOperator.dbgOn()) {
                                db.println("Found reverse netLink for Destination End point: " + iNetLink.prettyString());
                            }
                            if (object.getProtectionType() == 4 || object.getProtectionType() == 0) {
                                if (object3 != null && ((NetLink)object3).blsrRingName().equals(((NetLink)object).blsrRingName())) {
                                    object5 = NetCircuitNode.getTDMTerminology(object2.getNodeModel()).getRingTerms(1);
                                    if (!object2.getHoNum().equals(object4.getHoNum())) {
                                        throw new SanityCheckFailed("Both endpoints are on the same " + (String)object5 + " trunk ports. Their time slots must match.");
                                    }
                                    if (object2.getLoNum() != null && object4.getLoNum() != null && !object2.getLoNum().equals(object4.getLoNum())) {
                                        throw new SanityCheckFailed("Both endpoints are on the same " + (String)object5 + " trunk ports. Their time slots must match.");
                                    }
                                }
                                object5 = new NetLinkSpan((INetLink)object, iNetLink, object4.getHoNum(), object4.getHoNum(), object4.getLoNum());
                                linkedList.add(object5);
                                if (NetCcatCircuitOperator.dbgOn()) {
                                    db.println("SanityCheckCircuitInputs: Adding: " + ((NetLinkSpan)object5).prettyString());
                                }
                            }
                        }
                    }
                    if (linkedList.size() > 0) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("SanityCheckCircuitInputs:: Adding Spans: " + linkedList.size());
                        }
                        this.ccatCircuit.getMemberPrefs().addRequiredSpans(linkedList);
                    }
                }
                if (!this.ccatCircuit.getCircuitTypeObj().isLoCircuitType()) {
                    return;
                }
                iNetCircuit = this.ccatCircuit.useLAP();
                if (iNetCircuit == null) {
                    return;
                }
                if (iNetCircuit == null) break block40;
                object2 = iNetCircuit.getLapLink();
                if (((LoCcatCircuit)this.ccatCircuit).useLAPOnSource() == null) break block41;
                object4 = this.ccatCircuit.getPrimarySource();
                object3 = new NetLinkSpan((INetLink)object2, iNetCircuit.getReverseLapLink(), object2.getSrcHo(), object2.getDstHo(), object4.getLoNum());
                if (this.ccatCircuit.getRequiredSpans().contains(object3)) break block40;
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("sanityCheckCircuitInputs adding required span");
                }
                this.ccatCircuit.getMemberPrefs().addRequiredSpan((INetLinkSpan)object3);
                break block40;
            }
            for (Object object3 : this.ccatCircuit.getDrops()) {
                if (object2.getSrc() != ((NetCircuitDropInfo)object3).getNetElement() || object2.getSrcEntityIndex() != ((NetCircuitDropInfo)object3).getEntityIndex() || !HoLoComparator.instance().isEqual(object2.getSrcHo(), ((NetCircuitDropInfo)object3).getHoNum())) continue;
                object = new NetLinkSpan(iNetCircuit.getReverseLapLink(), (INetLink)object2, object2.getDstHo(), object2.getSrcHo(), ((NetCircuitDropInfo)object3).getLoNum());
                if (this.ccatCircuit.getRequiredSpans().contains(object)) break;
                this.ccatCircuit.getMemberPrefs().addRequiredSpan((INetLinkSpan)object);
                break;
            }
        }
    }

    protected void sanityCheckBlsrDri(Map map) throws SanityCheckFailed {
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        Iterator<Object> iterator = map.values().iterator();
        LinkedList linkedList = new LinkedList();
        while (iterator.hasNext()) {
            List list = (List)iterator.next();
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                linkedList.add(iterator2.next());
            }
        }
        for (NetCircuitNode netCircuitNode : linkedList) {
            if (netCircuitNode.getState() == 3 && NetCircuitNodeUtil.isBlsrDriHandoff(netCircuitNode.getDriNodeType())) {
                throw new SanityCheckFailed("The node " + netCircuitNode.getName() + " does not support the " + "modification of its " + "BLSR-DRI handoff connections.");
            }
            if (netCircuitNode.hasInvalidBlsrDriSelector() || netCircuitNode.hasInvalidOpenEndedOnewayBlsrDri()) {
                throw new SanityCheckFailed("The DRI handoff on the node " + netCircuitNode.getName() + " failed the protection validation.");
            }
            ConnectionValidator.instance().validateBlsrDriPcaSpans(netCircuitNode, arrayList);
            bl |= netCircuitNode.hasBlsrDriSelector();
        }
        if (!bl && this.ccatCircuit.hasBlsrDri() && this.ccatCircuit.getSourcesSize() == 1 && this.ccatCircuit.getDropsSize() == 1) {
            throw new SanityCheckFailed("The BLSR DRI handoff is missing BLSR input protection.");
        }
    }

    private void sanityCheckOpenEndUpsr(int n) throws SanityCheckFailed {
        if (this.ccatCircuit.getState() == 0) {
            ConnectionValidator connectionValidator = ConnectionValidator.instance();
            NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.ccatCircuit.getPrimarySource();
            NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)this.ccatCircuit.getSecondarySource();
            if (netCircuitEnd != null && netCircuitEnd2 != null) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("sanityCheckOpenEndUpsr: 2 sources");
                }
                if (this.ccatCircuit.srcPayloadType() != this.ccatCircuit.secSrcPayloadType()) {
                    throw new SanityCheckFailed("The payload types of the primary and secondary sources do not match.");
                }
                if (!connectionValidator.validateAdmOBSelectorConstraints(this.ccatCircuit, netCircuitEnd, netCircuitEnd2)) {
                    throw new SanityCheckFailed("The circuit source contains an invalid selector.");
                }
            }
            if (this.ccatCircuit.getDropsSize() == 2) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("sanityCheckOpenEndUpsr: 2 drops");
                }
                List list = this.ccatCircuit.getCktDrops();
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)list.get(0);
                NetCircuitDropInfo netCircuitDropInfo2 = (NetCircuitDropInfo)list.get(1);
                NetCircuitEnd netCircuitEnd3 = netCircuitDropInfo.getNetCktEnd();
                NetCircuitEnd netCircuitEnd4 = netCircuitDropInfo2.getNetCktEnd();
                if (this.ccatCircuit.getPayloadType(netCircuitEnd3) != this.ccatCircuit.getPayloadType(netCircuitEnd4)) {
                    throw new SanityCheckFailed("The payload types of the primary and secondary destinations do not match.");
                }
                if (!connectionValidator.validateAdmOBSelectorConstraints(this.ccatCircuit, netCircuitEnd3, netCircuitEnd4)) {
                    throw new SanityCheckFailed("The circuit destination contains an invalid selector.");
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected List addDropToCircuitInfo() throws CircuitProvError {
        List list = super.addDropToCircuitInfo();
        if (this.ccatCircuit.isMemberOfVcat()) {
            List list2;
            List list3 = list2 = this.ccatCircuit.getPrevDropList();
            synchronized (list3) {
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                    try {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("try to cleanup previously added circuit drop from member circuit (" + this.ccatCircuit.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.ccatCircuit.getCircuitId()) + ")");
                        }
                        this.ccatCircuit.circuitModel().delDrop(netCircuitDropInfo.getNetCktEnd().getCircuitEnd());
                        iterator.remove();
                    }
                    catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                        if (!NetCcatCircuitOperator.dbgOn()) continue;
                        db.println("Cannot del. last drop while deleting drop from prevDropList");
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        if (!NetCcatCircuitOperator.dbgOn()) continue;
                        db.println("Unexpected exception while deleting drop from prevDropList");
                    }
                }
                list2.addAll(list);
            }
        }
        return list;
    }

    @Override
    protected String deriveDefaultName() {
        String string;
        String string2 = this.ccatCircuit.getSrcNodeModel().getName();
        if (string2.length() > 16) {
            string2 = string2.substring(0, 15);
        }
        int n = this.ccatCircuit.getCircuitId().getUniquePart().getUniqueId();
        if (this.ccatCircuit.getCircuitTypeObj().isEthernetCircuitType()) {
            INetElement iNetElement = this.ccatCircuit.getSrcNetElement();
            TDMTerminology tDMTerminology = iNetElement.getNodeModel().getTDMTerminology();
            string = tDMTerminology.getEthernetTypeTerm() + "_Ether-" + string2 + "_" + n;
        } else {
            string = this.ccatCircuit.isMemberOfVcat() ? this.ccatCircuit.getVcatGroup().getCircuitName() + "_" + this.ccatCircuit.getMemberNumber() : (this.ccatCircuit.getCircuitTypeObj().isSVLANType() ? this.ccatCircuit.getCircuitTypeObj().getProtocolIndepCktTypeShortStr() + "_" + string2 : this.ccatCircuit.getCircuitTypeObj().getProtocolIndepCktTypeShortStr() + "_" + string2 + (n != 0 ? "_" + n : "_TL1"));
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean provision() throws NoRoute, ConnTypeUnsupported, SanityCheckFailed, CircuitProvError, AnnotatedException {
        INodeModel iNodeModel;
        boolean bl = false;
        List list = this.ccatCircuit.getCircuitNodes();
        int n = this.ccatCircuit.getState();
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("provision called for " + this.ccatCircuit.getCircuitName() + ". Id = " + NetCcatCircuit.prettyString(this.ccatCircuit.getCircuitId()));
        }
        if (!this.ccatCircuit.isCircuitRefValid()) {
            throw new CircuitProvError("The circuit was already destroyed.");
        }
        if (n != 0 && n != 3 && n != 11) {
            throw new CircuitProvError("The circuit state is invalid for provisioning.");
        }
        JobController jobController = NetCircuitManager.instance().getCreateJc();
        if (jobController == null) {
            throw new CircuitProvError("The job controller cannot be obtained.");
        }
        if (!jobController.isIdle()) {
            throw new CircuitProvError("The job controller is not idle.");
        }
        if (n == 0) {
            if (this.ccatCircuit.tl1Compatible()) {
                if (!this.ccatCircuit.tl1InfoActive()) {
                    this.createTl1Info();
                    bl = true;
                }
            } else if (!this.ccatCircuit.circuitInfoActive()) {
                if (this.ccatCircuit.getSrcNodeModel().getNeType() != null && this.ccatCircuit.getSrcNodeModel().getNeType().indexOf("crs") >= 0) {
                    this.createCircuitInfo(this.ccatCircuit.getSrcNodeModel(), this.ccatCircuit.getPrimaryDrop().getNodeModel(), this.ccatCircuit.getCircuitInfo());
                } else {
                    super.createCircuitInfo(this.ccatCircuit.getSrcNodeModel(), this.ccatCircuit.getCircuitInfo());
                }
                bl = true;
            }
        }
        if (this.ccatCircuit.isMemberOfVcat() && this.ccatCircuit.getAdminState() == 4) {
            Iterator iterator = list.iterator();
            boolean bl2 = this.ccatCircuit.isOpenEndedVcatCircuit();
            iNodeModel = null;
            if (bl2) {
                iNodeModel = ((NetVcatTermination)this.ccatCircuit.getVcatGroup().getAllVcatTerms().get(0)).getNodeModel();
            }
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (!bl2) {
                    if (netCircuitNode.getNodeModel() == this.ccatCircuit.getPrimarySource().getNodeModel() || netCircuitNode.getNodeModel() == this.ccatCircuit.getPrimaryDrop().getNodeModel()) continue;
                    netCircuitNode.setAdminState(2);
                    continue;
                }
                if (this.ccatCircuit.getPrimarySource().getNodeModel() == iNodeModel) {
                    if (netCircuitNode.getNodeModel() == iNodeModel) continue;
                    netCircuitNode.setAdminState(2);
                    continue;
                }
                if (netCircuitNode.getNodeModel() == this.ccatCircuit.getPrimaryDrop().getNodeModel()) continue;
                netCircuitNode.setAdminState(2);
            }
        }
        Object[] objectArray = list.toArray();
        iNodeModel = new IJobControl[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            iNodeModel[i] = new NetCircuitCreateWorker((NetCircuitNode)objectArray[i]);
        }
        JobGroup jobGroup = new JobGroup((IJobControl[])iNodeModel, (IJobGroupListener)this, null);
        this.createDone = false;
        jobController.submitJob(jobGroup);
        while (!this.createDone) {
            Object object = this.threadWaitObject;
            synchronized (object) {
                block39: {
                    try {
                        this.threadWaitObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        if (!NetCcatCircuitOperator.dbgOn()) break block39;
                        db.println("provision: InterruptedException");
                    }
                }
            }
        }
        JobStatus[] jobStatusArray = jobGroup.getJobStatusList();
        for (int i = 0; i < jobStatusArray.length; ++i) {
            block40: {
                if (jobStatusArray[i].value() != 2) continue;
                try {
                    if (!this.ccatCircuit.isMemberOfVcat()) {
                        this.tentative2Routed();
                    }
                }
                catch (DeletionError deletionError) {
                    if (NetCcatCircuitOperator.dbgOn()) {
                        db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                    }
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (!NetCcatCircuitOperator.dbgOn()) break block40;
                    db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                }
            }
            throw (AnnotatedException)((Object)jobStatusArray[i].getResult());
        }
        if (this.ccatCircuit.circuitInfoActive()) {
            try {
                this.addDropToCircuitInfo();
            }
            catch (CircuitProvError circuitProvError) {
                block41: {
                    try {
                        if (!this.ccatCircuit.isMemberOfVcat()) {
                            this.tentative2Routed();
                        }
                    }
                    catch (DeletionError deletionError) {
                        if (NetCcatCircuitOperator.dbgOn()) {
                            db.println("tentative2Routed encountered exception " + deletionError.getMessage());
                        }
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (!NetCcatCircuitOperator.dbgOn()) break block41;
                        db.println("tentative2Routed encountered exception " + incorrectCircuitState.getMessage());
                    }
                }
                throw circuitProvError;
            }
        }
        if (!this.ccatCircuit.isMemberOfVcat()) {
            this.tentative2Active();
        }
        return bl;
    }

    @Override
    protected void tentative2Routed() throws DeletionError, IncorrectCircuitState {
        if (this.ccatCircuit.getCktOperation() == 1 && this.ccatCircuit.circuitInfoActive()) {
            this.ccatCircuit.destroyCircuitInfo();
        }
        for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
            netCircuitNode.getOperator().tentative2Routed();
        }
    }

    @Override
    protected void tentative2Active() {
        for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
            netCircuitNode.tentative2Active();
        }
        if (this.ccatCircuit.getState() == 0) {
            if (this.ccatCircuit.tl1Compatible()) {
                this.ccatCircuit.setState(5);
                this.ccatCircuit.setTL1DropPathUnprot();
                this.ccatCircuit.setTl1Compatible(false);
                this.ccatCircuit.getMarker().markUpsr();
                this.ccatCircuit.getMarker().markDri();
            } else {
                this.ccatCircuit.setState(4);
                this.ccatCircuit.completeCheck();
            }
            this.ccatCircuit.setProtType();
        } else if (!this.ccatCircuit.circuitInfoActive()) {
            if (this.ccatCircuit.getCircuitTypeObj().isSVLANType()) {
                this.ccatCircuit.setState(6);
                this.ccatCircuit.tl1CircuitCompleteCheck();
            } else {
                this.ccatCircuit.setState(5);
                this.ccatCircuit.setTL1DropPathUnprot();
                this.ccatCircuit.getMarker().markUpsr();
                this.ccatCircuit.getMarker().markDri();
            }
        } else {
            this.ccatCircuit.setState(4);
            this.ccatCircuit.completeCheck();
        }
        this.ccatCircuit.setServiceState(this.ccatCircuit.deriveServiceState());
        this.ccatCircuit.setCktOperation(0);
    }

    protected void rename(String string) throws CircuitProvError {
        if (string.trim().equals("")) {
            throw new CircuitProvError("The circuit name cannot be blank.");
        }
        this.renameCircuit(string);
        this.renameConnections(string);
    }

    protected void renameConnections(String string) throws CircuitProvError {
        if (this.ccatCircuit.getCktNodeListSize() != 0) {
            for (NetCircuitNode netCircuitNode : this.ccatCircuit.getCircuitNodes()) {
                netCircuitNode.setConnName(string);
            }
        }
    }

    protected void destroyCircuit() throws IncorrectCircuitState, SanityCheckFailed, DeletionError {
        if (!this.ccatCircuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        if (this.ccatCircuit instanceof LoCcatCircuit && ((LoCcatCircuit)this.ccatCircuit).isYCircuit) {
            this.ccatCircuit.setState(6);
        }
        List list = this.ccatCircuit.getCircuitNodes();
        NetCircuitNode netCircuitNode = null;
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("destroy(" + this.ccatCircuit.getCircuitName() + ", " + NetCcatCircuit.prettyString(this.ccatCircuit.getCircuitId()) + ")");
        }
        Collections.shuffle(list);
        Iterator iterator = list.iterator();
        DeletionError deletionError = null;
        int n = 0;
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("Deactivating " + netCircuitNode.getName());
            }
            try {
                if (netCircuitNode instanceof LoYCircuitNode) {
                    ((LoYCircuitNode)netCircuitNode).deactivate();
                    continue;
                }
                netCircuitNode.deactivate();
            }
            catch (DeletionError deletionError2) {
                if (NetCcatCircuitOperator.dbgOn()) {
                    db.println("deletion error exception in destroy");
                }
                ++n;
                if (deletionError != null) continue;
                deletionError = deletionError2;
            }
        }
        if (deletionError != null) {
            if (NetCcatCircuitOperator.dbgOn()) {
                db.println("Total of " + n + " catches");
            }
            throw deletionError;
        }
        if (this.ccatCircuit.circuitInfoActive()) {
            this.ccatCircuit.destroyCircuitInfo();
        }
        if (this.ccatCircuit instanceof LoCcatCircuit && ((LoCcatCircuit)this.ccatCircuit).isYCircuit) {
            ((LoCcatCircuit)this.ccatCircuit).updateYCircuit(true);
        }
    }

    protected LinkedList sanityCheckSRGs() throws SanityCheckFailed {
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("calling sanityCheckSRGs");
        }
        if (!this.ccatCircuit.isCircuitRefValid()) {
            throw new SanityCheckFailed("The circuit was already destroyed.");
        }
        LinkedList linkedList = new LinkedList();
        linkedList = RouteValidator.instance().getSrgFailureList(this.ccatCircuit.getCircuitSpans());
        if (NetCcatCircuitOperator.dbgOn()) {
            db.println("sanityCheckSRGs got " + linkedList.size() + " violations");
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobGroupFinished(JobGroup jobGroup) {
        Object object = this.threadWaitObject;
        synchronized (object) {
            this.createDone = true;
            this.threadWaitObject.notifyAll();
        }
    }
}

