/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CircuitType;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchncConnectionModel;
import cerent.cms.model.ISvlanConnectionModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchncCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.SvlanCircuit;
import cerent.cms.ncp.YCircuitNodeController;
import cerent.cms.topo.INetElement;
import cerent.util.HoLoFactory;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class NetCircuitFactory {
    protected static final NetCircuitManager ncm = NetCircuitManager.instance();
    private static final SDebug db = new SDebug("NetCircuitFactory");
    private static final SDebug pkgDb = new SDebug("NcpPackage");

    private NetCircuitFactory() {
    }

    public static INetCircuit newCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd) {
        return NetCircuitFactory.newCircuit(circuitCreatInfo, iNetCircuitEnd, null);
    }

    public static INetCircuit newCircuit(CircuitCreatInfo circuitCreatInfo, INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2) {
        NetCircuit netCircuit = null;
        try {
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
            if (iCircuitType.isHoCircuitType() || iCircuitType.isLAPCircuitType()) {
                netCircuit = new HoCcatCircuit(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
            } else if (iCircuitType.isLoCircuitType()) {
                netCircuit = new LoCcatCircuit(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
            } else if (iCircuitType.isOchncType()) {
                netCircuit = new OchncCircuit(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
            } else if (iCircuitType.isOchccCircuitType()) {
                netCircuit = new OchccCircuit(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
            } else if (iCircuitType.isVcatCircuitType()) {
                netCircuit = iNetCircuitEnd2 != null ? new NetVcatCircuit(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2) : new NetVcatCircuit(circuitCreatInfo, iNetCircuitEnd);
            } else if (iCircuitType.isSVLANType()) {
                netCircuit = new SvlanCircuit(circuitCreatInfo, iNetCircuitEnd, iNetCircuitEnd2);
            }
        }
        catch (RuntimeException runtimeException) {
            if (NetCircuitFactory.dbgOn()) {
                SDebug.printStackTrace((Throwable)runtimeException);
                NetCircuitFactory.debug("Warning! unable to create circuit");
            }
            throw runtimeException;
        }
        if (netCircuit == null) {
            // empty if block
        }
        return netCircuit;
    }

    public static INetCircuit newCircuit(CircuitCreatInfo circuitCreatInfo, INetElement iNetElement) throws SanityCheckFailed {
        NetCcatCircuit netCcatCircuit = null;
        CircuitCreatInfo circuitCreatInfo2 = null;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        if (iCircuitType.isOchTrailTunnelCircuitType()) {
            try {
                netCcatCircuit = new OchncCircuit(circuitCreatInfo, iNetElement);
            }
            catch (RuntimeException runtimeException) {
                if (NetCircuitFactory.dbgOn()) {
                    NetCircuitFactory.debug("Warning! unable to create OchTrail Tunnel circuit");
                }
                throw runtimeException;
            }
        }
        if (iCircuitType.isOchccCircuitType()) {
            try {
                netCcatCircuit = new OchccCircuit(circuitCreatInfo, iNetElement);
            }
            catch (RuntimeException runtimeException) {
                if (NetCircuitFactory.dbgOn()) {
                    NetCircuitFactory.debug("Warning! unable to create OchTrail circuit (ITU-T Line Card)");
                }
                throw runtimeException;
            }
        }
        circuitCreatInfo2 = new CircuitCreatInfo(circuitCreatInfo.type(), circuitCreatInfo.size(), circuitCreatInfo.dir(), circuitCreatInfo.monitor(), circuitCreatInfo.name(), circuitCreatInfo.adminState(), circuitCreatInfo.tl1Compatible(), circuitCreatInfo.sla());
        circuitCreatInfo2.setTrafficDir(circuitCreatInfo.getTrafficDir());
        if (iCircuitType.isHoCircuitType()) {
            iCircuitType = CircuitType.ETHERNET_TYPE;
            circuitCreatInfo2.setType(iCircuitType.getEnum());
        }
        if (!iCircuitType.isEthernetCircuitType() && !iCircuitType.isTunnelCircuitType()) {
            throw new SanityCheckFailed("Constructor for Ethernet/LO Tunnelfor the wrong circuit type");
        }
        if (iCircuitType.isEthernetCircuitType()) {
            circuitCreatInfo2.setTL1Compatible(false);
        }
        if (circuitCreatInfo2.dir() != 1) {
            throw new SanityCheckFailed((iCircuitType.isEthernetCircuitType() ? "Ethernet " : "LO Tunnel ") + "circuits have to be bidirectional");
        }
        try {
            netCcatCircuit = new HoCcatCircuit(circuitCreatInfo2, iNetElement);
        }
        catch (RuntimeException runtimeException) {
            if (NetCircuitFactory.dbgOn()) {
                NetCircuitFactory.debug("Warning! unable to create circuit");
            }
            throw runtimeException;
        }
        return netCcatCircuit;
    }

    public static INetCircuit newCircuitFromCircuitInfo(INodeModel iNodeModel, ICircuitModel iCircuitModel) {
        NetCircuit netCircuit = null;
        if (NetCircuitFactory.dbgOn()) {
            NetCircuitFactory.debug("newCircuitFromCircuitInfo() at " + iNodeModel.getName());
        }
        CircuitCreatInfo circuitCreatInfo = iCircuitModel.getType() == 9 || iCircuitModel.getType() == 15 ? new CircuitCreatInfo(iCircuitModel.getType(), iCircuitModel.getSize(), iCircuitModel.getDirection(), iCircuitModel.getCktOptChannel()) : new CircuitCreatInfo(iCircuitModel.getType(), iCircuitModel.getSize(), iCircuitModel.getDirection());
        circuitCreatInfo.setAdminState(-1);
        try {
            ICircuitType iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type());
            if (iCircuitType.isHoCircuitType() || iCircuitType.isEthernetCircuitType() || iCircuitType.isTunnelCircuitType() || iCircuitType.isLAPCircuitType()) {
                netCircuit = new HoCcatCircuit(circuitCreatInfo, iNodeModel, iCircuitModel);
            } else if (iCircuitType.isLoCircuitType()) {
                netCircuit = new LoCcatCircuit(circuitCreatInfo, iNodeModel, iCircuitModel);
            } else if (iCircuitType.isOchncType() || iCircuitType.isOchTrailTunnelCircuitType()) {
                netCircuit = new OchncCircuit(circuitCreatInfo, iNodeModel, iCircuitModel);
            } else if (iCircuitType.isOchccCircuitType()) {
                netCircuit = new OchccCircuit(circuitCreatInfo, iNodeModel, iCircuitModel);
            } else if (iCircuitType.isVcatCircuitType()) {
                netCircuit = new NetVcatCircuit(circuitCreatInfo, iNodeModel, iCircuitModel);
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (NetCircuitFactory.dbgOn()) {
                NetCircuitFactory.debug("CircuitModel destroyed before we could process it");
            }
            throw abstractCmsObjectNotExistException;
        }
        ncm.insertCircuit(netCircuit, true);
        return netCircuit;
    }

    public static boolean fabricateYCircuits(NetCircuitNode netCircuitNode, ICircuitSize iCircuitSize, ICircuitType iCircuitType) {
        CircuitCreatInfo circuitCreatInfo = null;
        LoCcatCircuit loCcatCircuit = null;
        IConnectionModel iConnectionModel = netCircuitNode.getConn();
        INetElement iNetElement = netCircuitNode.getNetElement();
        int n = 0;
        Object[] objectArray = netCircuitNode.getPathsFromConnModel();
        Iterator<Object> iterator = Arrays.asList(objectArray).iterator();
        Object object = iterator.next();
        NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(iNetElement, object);
        List list = HoLoFactory.getAllLoNums(netCircuitEnd.getHoNum().getFramingType(), iCircuitSize.getEnum());
        YCircuitNodeController yCircuitNodeController = new YCircuitNodeController(list.size());
        iterator = list.iterator();
        if (NetCircuitFactory.dbgOn()) {
            NetCircuitFactory.debug("Fabricating " + list.size() + " Lo circuits of size" + iCircuitSize.getEnum());
        }
        while (iterator.hasNext()) {
            block5: {
                Object object2 = iterator.next();
                circuitCreatInfo = new CircuitCreatInfo(iCircuitType.getEnum(), iCircuitSize.getEnum(), 1, true, object2);
                try {
                    loCcatCircuit = new LoCcatCircuit(circuitCreatInfo, iNetElement, iConnectionModel);
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!NetCircuitFactory.dbgOn()) break block5;
                    NetCircuitFactory.debug("Connection model destroyed before processing Y fabrication");
                }
            }
            ncm.insertCircuit(loCcatCircuit, true);
            for (LoYCircuitNode loYCircuitNode : loCcatCircuit.getCircuitNodes()) {
                loYCircuitNode.setController(n, yCircuitNodeController);
            }
            ++n;
        }
        ((HoCircuitNode)netCircuitNode).setYController(yCircuitNodeController);
        return true;
    }

    public static NetCcatCircuit newCircuitFromConn(INetElement iNetElement, Object object) {
        IOchncConnectionModel iOchncConnectionModel;
        CircuitCreatInfo circuitCreatInfo = null;
        if (NetCircuitFactory.dbgOn()) {
            NetCircuitFactory.debug("newCircuitFromConn() at " + iNetElement.getName());
        }
        if (object instanceof IOchncConnectionModel) {
            iOchncConnectionModel = (IOchncConnectionModel)object;
            circuitCreatInfo = new CircuitCreatInfo(ncm.connCircuitType(object), ncm.connCircuitSize(object), ncm.connCircuitDir(object), iOchncConnectionModel.getOptChannel());
        } else if (object instanceof IOchTrailAditModel) {
            iOchncConnectionModel = (IOchTrailAditModel)object;
            circuitCreatInfo = new CircuitCreatInfo(ncm.connCircuitType(object), ncm.connCircuitSize(object), ncm.connCircuitDir(object), iOchncConnectionModel.getOptChannel());
        } else if (object instanceof IOchccConnectionModel) {
            iOchncConnectionModel = (IOchccConnectionModel)object;
            circuitCreatInfo = new CircuitCreatInfo(ncm.connCircuitType(object), 31, ncm.connCircuitDir(object), iOchncConnectionModel.getAdit().getOptChannel());
        } else if (object instanceof ISvlanConnectionModel) {
            iOchncConnectionModel = (ISvlanConnectionModel)object;
            circuitCreatInfo = new CircuitCreatInfo(ncm.connCircuitType(object), 29, ncm.connCircuitDir(object));
            circuitCreatInfo.setSVLAN(iOchncConnectionModel.getSvlan());
        } else {
            circuitCreatInfo = new CircuitCreatInfo(ncm.connCircuitType(object), ncm.connCircuitSize(object), ncm.connCircuitDir(object));
        }
        circuitCreatInfo.setAdminState(ncm.connCircuitAdminState(object));
        circuitCreatInfo.setName(ncm.connCircuitName(object));
        iOchncConnectionModel = CircuitType.getCircuitType((int)circuitCreatInfo.type());
        NetCcatCircuit netCcatCircuit = null;
        try {
            if (iOchncConnectionModel.isHoCircuitType() || iOchncConnectionModel.isEthernetCircuitType() || iOchncConnectionModel.isLAPCircuitType() || iOchncConnectionModel.isTunnelCircuitType()) {
                netCcatCircuit = new HoCcatCircuit(circuitCreatInfo, iNetElement, object);
            } else if (iOchncConnectionModel.isLoCircuitType()) {
                netCcatCircuit = new LoCcatCircuit(circuitCreatInfo, iNetElement, object);
            } else if (iOchncConnectionModel.isOchncType() || iOchncConnectionModel.isOchTrailTunnelCircuitType()) {
                netCcatCircuit = new OchncCircuit(circuitCreatInfo, iNetElement, object);
            } else if (iOchncConnectionModel.isOchccCircuitType()) {
                netCcatCircuit = new OchccCircuit(circuitCreatInfo, iNetElement, object);
            } else if (iOchncConnectionModel.isSVLANType()) {
                netCcatCircuit = new SvlanCircuit(circuitCreatInfo, iNetElement, object);
            }
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (NetCircuitFactory.dbgOn()) {
                NetCircuitFactory.debug("Connection model destroyed before we could process it");
            }
            throw abstractCmsObjectNotExistException;
        }
        ncm.insertCircuit(netCcatCircuit, true);
        return netCcatCircuit;
    }

    public static NetVcatCircuit newCircuitFromVcatTerm(INetElement iNetElement, Object object) {
        if (NetCircuitFactory.dbgOn()) {
            NetCircuitFactory.debug("newCircuitFromVcatTerm() at " + iNetElement.getName());
        }
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(ncm.vcatTermCircuitType(object), ncm.vcatTermCircuitSize(object), ncm.vcatTermCircuitDir(object));
        try {
            circuitCreatInfo.setAdminState(ncm.vcatTermCircuitAdminState(object));
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (NetCircuitFactory.dbgOn()) {
                NetCircuitFactory.debug("Vcat term model destroyed before we could process it");
            }
            throw abstractCmsObjectNotExistException;
        }
        circuitCreatInfo.setName(ncm.vcatTermCircuitName(object));
        NetVcatCircuit netVcatCircuit = null;
        try {
            netVcatCircuit = new NetVcatCircuit(circuitCreatInfo, iNetElement, object);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            if (NetCircuitFactory.dbgOn()) {
                NetCircuitFactory.debug("Vcat term model destroyed before we could process it");
            }
            throw abstractCmsObjectNotExistException;
        }
        if (!netVcatCircuit.isCircuitRefValid()) {
            netVcatCircuit = null;
        } else {
            ncm.insertCircuit(netVcatCircuit, true);
        }
        return netVcatCircuit;
    }

    protected static void notifyChanged() {
        if (NetCircuitFactory.dbgOn()) {
            NetCircuitFactory.debug("notifyChanged(ncMgr)");
        }
        ncm.setChanged();
        ncm.notifyObservers(ModelUpdateType.ADDED);
    }

    protected static boolean pkgDbgOn() {
        return pkgDb.on();
    }

    protected static boolean dbgOn() {
        return db.on() || NetCircuitFactory.pkgDbgOn();
    }

    protected static void debug(String string) {
        db.println(string);
    }
}

