/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.CircuitType;
import cerent.cms.model.CktInfo;
import cerent.cms.model.ErrorWritingToDb;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.IVlanInfo;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OnlyOneDropPerBidirCktAllowed;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitMergeError;
import cerent.cms.ncp.CircuitMergeFilter;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.Endpoints;
import cerent.cms.ncp.EtherNodeDropCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.NetVcatTermination;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetCircuitMergeOperator {
    private static final SDebug db = new SDebug("NetCircuitMergeOperator");
    private static CircuitMergeManager mergeManager = CircuitMergeManager.instance();
    private NetCcatCircuit myCircuit;
    private int operation;
    private ICircuitModel circuitModelBeforeMerge;
    private NetCircuitNode sourceNodeBeforeMerge;
    private String circuitNameBeforeMerge;
    private int circuitNodeNumBeforeMerge;
    private boolean pureTl1CktBeforeMerge;
    private List disjointParts = new ArrayList();
    private Map nodeDisjointPartMap = new HashMap();
    private boolean changed = false;
    private boolean existsRollbackXconnects = false;
    private NetVcatCircuit baseVcat = null;
    private NetVcatCircuit otherVcat = null;

    public NetCircuitMergeOperator(NetCcatCircuit netCcatCircuit, int n) {
        this.myCircuit = netCcatCircuit;
        this.operation = n;
    }

    public NetCircuitMergeOperator(NetVcatCircuit netVcatCircuit, NetVcatCircuit netVcatCircuit2) {
        this.baseVcat = netVcatCircuit;
        this.otherVcat = netVcatCircuit2;
    }

    public void validateForMerge() throws CircuitMergeError {
        NetCircuitMergeOperator.validateForMerge(this.myCircuit);
    }

    public static void validateForMerge(INetCircuit iNetCircuit) throws CircuitMergeError {
        String string = iNetCircuit.getCircuitName();
        if (iNetCircuit.getCircuitTypeObj().isSVLANType()) {
            throw new CircuitMergeError("The circuit \"" + string + "\" is a SVLAN circuit.");
        }
        if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
            throw new CircuitMergeError("The circuit \"" + string + "\" is a VCAT circuit.");
        }
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuit;
        if (netCcatCircuit.getCktNodeListSize() == 0) {
            throw new CircuitMergeError("The circuit \"" + string + "\" has no connection.");
        }
        switch (netCcatCircuit.getState()) {
            case 0: {
                throw new CircuitMergeError("The circuit \"" + string + "\" is being created.");
            }
            case 2: {
                throw new CircuitMergeError("The circuit \"" + string + "\" is being deleted.");
            }
            case 3: {
                throw new CircuitMergeError("The circuit \"" + string + "\" has a drop pending.");
            }
            case 8: {
                throw new CircuitMergeError("The circuit \"" + string + "\" has a roll pending.");
            }
        }
        if (NetCircuitMergeOperator.containsVlanCircuitEnds(netCcatCircuit) && netCcatCircuit.getVlans().length == 0) {
            throw new CircuitMergeError("The VLAN set of the circuit \"" + string + "\" is empty.");
        }
    }

    private static boolean containsVlanCircuitEnds(NetCcatCircuit netCcatCircuit) {
        for (Object e : netCcatCircuit.getDrops()) {
            NetCircuitEnd netCircuitEnd = ((NetCircuitDropInfo)e).getNetCktEnd();
            if (!netCircuitEnd.isEtherP2PCircuitEnd()) continue;
            return true;
        }
        return false;
    }

    public void prepareMerge() {
        this.myCircuit.setInCircuitMerge(true);
        this.circuitModelBeforeMerge = this.myCircuit.circuitModel();
        this.sourceNodeBeforeMerge = this.myCircuit.srcCircuitNode;
        this.circuitNameBeforeMerge = this.myCircuit.getCircuitName();
        this.circuitNodeNumBeforeMerge = this.myCircuit.getCircuitNodes().size();
        this.pureTl1CktBeforeMerge = this.myCircuit.hasNullCircuitId();
        for (NetCircuitNode netCircuitNode : this.myCircuit.getCircuitNodes()) {
            if (netCircuitNode.getConn() == null) continue;
            this.disjointParts.add(new DisjointPart(netCircuitNode));
            netCircuitNode.conformToConnection(mergeManager.getSplicer());
        }
    }

    private void handleHoGroomingNode(NetCircuitNode netCircuitNode) {
        if (this.dbgOn()) {
            db.println("handleHoGroomingNode");
        }
        for (NetCircuitSpan netCircuitSpan : netCircuitNode.getAllSpansList()) {
            NetCircuitNode netCircuitNode2 = (NetCircuitNode)(netCircuitNode.getNetElement() == netCircuitSpan.getLink().getSrc() ? netCircuitSpan.getDstNCN() : netCircuitSpan.getSrcNCN());
            if (netCircuitNode2 == null || !netCircuitNode2.getAllSpansList().contains(netCircuitSpan)) continue;
            if (this.dbgOn()) {
                db.println("Found peer node.");
            }
            this.getDisjointPartOnNode(netCircuitNode2).add(netCircuitNode);
            break;
        }
    }

    protected void lapNodeDestroyed(NetCircuitNode netCircuitNode) {
        DisjointPart disjointPart;
        if (this.dbgOn()) {
            db.println("lapNodeDestroyed");
        }
        if (netCircuitNode.getConn() == null && (disjointPart = this.getDisjointPartOnNode(netCircuitNode)) != null) {
            disjointPart.remove(netCircuitNode);
        }
    }

    protected void lapNodeDiscovered(NetCircuitNode netCircuitNode) {
        if (this.dbgOn()) {
            db.println("lapNodeDiscovered");
        }
        if (netCircuitNode.getConn() == null) {
            this.handleHoGroomingNode(netCircuitNode);
        }
    }

    public boolean canBeCompleted() {
        return this.getDisjointPartsNum() == 0 || this.getDisjointPartsNum() == 1 && this.isNodesStructureComplete(this.myCircuit);
    }

    public boolean finalizeMerge() {
        if (this.dbgOn()) {
            db.println("Start finalizeMerge");
            Iterator iterator = this.disjointParts.iterator();
            while (iterator.hasNext()) {
                ((DisjointPart)iterator.next()).prettyPrint(db);
            }
        }
        if (this.operation == 1 && this.myCircuit != mergeManager.getMasterCircuit()) {
            this.reloadWholeCircuit();
            return false;
        }
        boolean bl = true;
        DisjointPart disjointPart = this.getSourcePart();
        int n = 1;
        ArrayList arrayList = new ArrayList(this.disjointParts);
        for (DisjointPart disjointPart2 : arrayList) {
            if (disjointPart2 == disjointPart) continue;
            if (!this.handleDisjointPart(disjointPart2, n)) {
                bl = false;
                continue;
            }
            this.changed = true;
            ++n;
        }
        if (disjointPart != null) {
            if (!bl) {
                boolean bl2 = this.handleDisjointPart(disjointPart, n);
                if (bl2) {
                    this.changed = true;
                }
            } else {
                bl = this.handleSrcPart(disjointPart);
            }
        }
        if (!bl) {
            this.reloadWholeCircuit();
        }
        return bl;
    }

    public void cleanup() {
        if (this.myCircuit.getCktNodeListSize() == 0 && !this.existsRollbackXconnects) {
            this.deleteOldCircuitModel();
            this.myCircuit.finalDispose();
            this.myCircuit.notifyDeleted();
        }
    }

    private void deleteOldCircuitModel() {
        block5: {
            if (this.circuitModelBeforeMerge != null) {
                try {
                    this.circuitModelBeforeMerge.delete();
                }
                catch (ErrorWritingToDb errorWritingToDb) {
                    if (this.dbgOn()) {
                        SDebug.printStackTrace((Throwable)errorWritingToDb);
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (!this.dbgOn()) break block5;
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
            }
        }
    }

    private void removeCircuitFromManager(INetCircuit iNetCircuit) {
        NetCircuitManager.instance().removeCircuit(iNetCircuit);
    }

    private void destroyCircuit(INetCircuit iNetCircuit) {
        block6: {
            try {
                iNetCircuit.destroyCircuit();
            }
            catch (IncorrectCircuitState incorrectCircuitState) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)incorrectCircuitState);
                }
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)sanityCheckFailed);
                }
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) break block6;
                SDebug.printStackTrace((Throwable)deletionError);
            }
        }
    }

    private boolean handleSrcPart(DisjointPart disjointPart) {
        if (!this.isNodesStructureComplete(this.myCircuit)) {
            return false;
        }
        if (this.circuitModelBeforeMerge != null && this.doesCktModelMatchCktSrcAndDrop(this.circuitModelBeforeMerge)) {
            if (this.dbgOn()) {
                db.println("circuit model mathes circuit node info - restore the circuit model.");
            }
            try {
                this.permanentlyMoveConnections();
                if (this.needToUseOldCircuitName() && !this.myCircuit.getCircuitName().equals(this.circuitNameBeforeMerge)) {
                    this.myCircuit.renameCircuit(this.circuitNameBeforeMerge);
                    this.changed = true;
                }
                this.reloadCircuitInfo();
                return true;
            }
            catch (CircuitProvError circuitProvError) {
                SDebug.printStackTrace((Throwable)circuitProvError);
                return false;
            }
        }
        if (this.dbgOn()) {
            db.println("circuit model does not match circuit node info - create a new circuit model.");
        }
        String string = this.needToUseOldCircuitName() ? this.circuitNameBeforeMerge : null;
        boolean bl = this.completeCircuit(this.myCircuit, string);
        if (this.dbgOn()) {
            db.println("New model created? " + bl);
        }
        if (bl) {
            this.deleteOldCircuitModel();
            this.changed = true;
        }
        return bl;
    }

    private boolean handleDisjointPart(DisjointPart disjointPart, int n) {
        if (this.dbgOn()) {
            db.println("Start handleDisjointPart");
        }
        return this.changeDisjointPartToNewCtcCircuit(disjointPart, n);
    }

    private NetCcatCircuit buildPartialCircuit(DisjointPart disjointPart, String string) {
        ICircuitType iCircuitType;
        CircuitCreatInfo circuitCreatInfo = this.createNewCircuitCreatInfo(string);
        NetCcatCircuit netCcatCircuit = null;
        int n = this.getAdjustedCircuitType(disjointPart, circuitCreatInfo.type());
        if (n != circuitCreatInfo.type()) {
            circuitCreatInfo.setType(n);
        }
        if ((iCircuitType = CircuitType.getCircuitType((int)circuitCreatInfo.type())).isTunnelCircuitType() || iCircuitType.isEthernetCircuitType()) {
            List list = this.getSpecialNodes(disjointPart.getNodeSet(), this.myCircuit.getCircuitTypeObj());
            NetCircuitNode netCircuitNode = list.contains(this.sourceNodeBeforeMerge) ? this.sourceNodeBeforeMerge : (NetCircuitNode)list.get(0);
            try {
                netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, netCircuitNode.getNetElement());
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (this.dbgOn()) {
                    db.println(sanityCheckFailed.getMessage());
                }
            }
        } else {
            netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, (INetCircuitEnd)null);
        }
        return netCcatCircuit;
    }

    private int getAdjustedCircuitType(DisjointPart disjointPart, int n) {
        return this.getAdjustedCircuitType(disjointPart.getNodeSet(), n);
    }

    private int getAdjustedCircuitType(Collection collection, int n) {
        int n2 = n;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)n);
        boolean bl = iCircuitType.isTunnelCircuitType();
        boolean bl2 = iCircuitType.isLAPCircuitType();
        boolean bl3 = iCircuitType.isEthernetCircuitType();
        if (bl || bl2 || bl3) {
            NetCircuitNode netCircuitNode = (NetCircuitNode)collection.iterator().next();
            ITdmProtocolType iTdmProtocolType = netCircuitNode.getNodeModel().getTdmProtocolTypeObj();
            List list = this.getSpecialNodes(collection, iCircuitType);
            if (this.dbgOn()) {
                db.println("special node size = " + list.size());
            }
            switch (list.size()) {
                case 0: {
                    if (this.dbgOn()) {
                        db.println("set type to HO");
                    }
                    n2 = iTdmProtocolType.getHoCircuitType();
                    break;
                }
                case 1: {
                    if (!bl) break;
                    if (this.dbgOn()) {
                        db.println("set type to LAP");
                    }
                    n2 = iTdmProtocolType.getAggCircuitType();
                    break;
                }
                case 2: {
                    if (!bl2) break;
                    if (this.dbgOn()) {
                        db.println("set type to Tunnel");
                    }
                    n2 = iTdmProtocolType.getTunnelCircuitType();
                }
            }
        }
        return n2;
    }

    private boolean changeDisjointPartToNewCtcCircuit(DisjointPart disjointPart, int n) {
        String string = this.needToUseOldCircuitName() ? this.getNewCircuitName(n) : null;
        NetCcatCircuit netCcatCircuit = this.buildPartialCircuit(disjointPart, string);
        if (this.dbgOn()) {
            db.println("newCkt=" + netCcatCircuit);
        }
        if (netCcatCircuit == null) {
            return false;
        }
        this.moveDisjointPart(disjointPart, this.myCircuit, netCcatCircuit);
        if (this.isNodesStructureComplete(netCcatCircuit) && this.completeCircuit(netCcatCircuit, string)) {
            if (this.dbgOn()) {
                db.println("new circuit is created successfully");
            }
            mergeManager.addNewCreatedCircuit(netCcatCircuit);
            return true;
        }
        if (this.dbgOn()) {
            db.println("new circuit could not be created successfully");
        }
        this.moveDisjointPart(disjointPart, netCcatCircuit, this.myCircuit);
        this.destroyCircuit(netCcatCircuit);
        return false;
    }

    private List getSpecialNodes(Collection collection, ICircuitType iCircuitType) {
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        for (NetCircuitNode netCircuitNode : collection) {
            if ((!iCircuitType.isTunnelCircuitType() && !iCircuitType.isLAPCircuitType() || !(netCircuitNode instanceof LoTunnelNode)) && (!iCircuitType.isEthernetCircuitType() || netCircuitNode.getConnectionType() != 8)) continue;
            arrayList.add(netCircuitNode);
        }
        return arrayList;
    }

    private boolean completeCircuit(NetCcatCircuit netCcatCircuit, String string) {
        boolean bl;
        block13: {
            try {
                block14: {
                    netCcatCircuit.setInCircuitMerge(false);
                    netCcatCircuit.deleteCircuitInfoObserver();
                    this.removeCircuitFromManager(netCcatCircuit);
                    List list = netCcatCircuit.createNewCircuitModel(string);
                    if (list.isEmpty()) {
                        if (this.dbgOn()) {
                            db.println("New circuit model is successfully created.");
                        }
                        bl = true;
                        break block13;
                    }
                    if (this.dbgOn()) {
                        db.println("Some connection IDs could not be changed.");
                    }
                    this.removeCircuitFromManager(netCcatCircuit);
                    if (netCcatCircuit.circuitInfoActive()) {
                        try {
                            netCcatCircuit.destroyCircuitInfo();
                        }
                        catch (IncorrectCircuitState incorrectCircuitState) {
                            if (this.dbgOn()) {
                                SDebug.printStackTrace((Throwable)incorrectCircuitState);
                            }
                        }
                        catch (DeletionError deletionError) {
                            if (!this.dbgOn()) break block14;
                            SDebug.printStackTrace((Throwable)deletionError);
                        }
                    }
                }
                bl = false;
            }
            catch (CircuitProvError circuitProvError) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)circuitProvError);
                }
                bl = false;
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)sanityCheckFailed);
                }
                bl = false;
            }
        }
        NetCircuitManager.instance().insertCircuit(netCcatCircuit, true);
        return bl;
    }

    private CircuitCreatInfo createNewCircuitCreatInfo(String string) {
        ICircuitInfo iCircuitInfo = this.myCircuit.getCircuitInfo();
        return new CircuitCreatInfo(iCircuitInfo.getCircuitType(), iCircuitInfo.getCircuitSize(), iCircuitInfo.getDir(), iCircuitInfo.getMonitor(), string, this.myCircuit.getAdminState(), false, iCircuitInfo.getCktOptChannel());
    }

    private String getNewCircuitName(int n) {
        return this.circuitNameBeforeMerge + ":" + n;
    }

    private DisjointPart getSourcePart() {
        return this.getDisjointPartOnNode(this.sourceNodeBeforeMerge);
    }

    private boolean doesCktModelMatchCktSrcAndDrop(ICircuitModel iCircuitModel) {
        if (iCircuitModel == null) {
            return false;
        }
        if (this.dbgOn()) {
            db.println("doesCktModelMatchCktSrcAndDrop started: cktModel = " + iCircuitModel);
        }
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        this.myCircuit.fetchSourcesAndDropsFromCircuitModel(iCircuitModel, arrayList, arrayList2);
        if (this.dbgOn()) {
            this.myCircuit.prettyPrint(db);
        }
        HashSet hashSet = new HashSet(this.myCircuit.getSources());
        HashSet hashSet2 = new HashSet(this.myCircuit.getDropCktEnds());
        HashSet hashSet3 = new HashSet();
        hashSet3.addAll(arrayList);
        HashSet<NetCircuitEnd> hashSet4 = new HashSet<NetCircuitEnd>();
        Iterator iterator = arrayList2.iterator();
        while (iterator.hasNext()) {
            hashSet4.add(((NetCircuitDropInfo)iterator.next()).getNetCktEnd());
        }
        return this.doesSrcDropPairMatch(new Set[]{hashSet, hashSet2}, new Set[]{hashSet3, hashSet4}, this.myCircuit.isBidirectional());
    }

    private boolean doesSrcDropPairMatch(Set[] setArray, Set[] setArray2, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = ((Object)setArray[0]).equals(setArray2[0]) && ((Object)setArray[1]).equals(setArray2[1]);
        if (bl) {
            boolean bl4 = bl2 = bl2 || ((Object)setArray[0]).equals(setArray2[1]) && ((Object)setArray[1]).equals(setArray2[0]);
        }
        if (this.dbgOn()) {
            db.println("isMatch=" + bl2);
        }
        return bl2;
    }

    public DisjointPart getDisjointPartOnNode(NetCircuitNode netCircuitNode) {
        if (netCircuitNode == null) {
            return null;
        }
        DisjointPart disjointPart = (DisjointPart)this.nodeDisjointPartMap.get(netCircuitNode);
        if (disjointPart == null) {
            NetCircuitNode netCircuitNode2 = null;
            List list = this.myCircuit.getCircuitNodeFromNE(netCircuitNode.getNetElement());
            if (list != null) {
                if (list.size() > 1) {
                    for (NetCircuitNode netCircuitNode3 : list) {
                        DualConnectionCircuitNode dualConnectionCircuitNode;
                        if (!netCircuitNode3.hasDualConnections() || !(dualConnectionCircuitNode = (DualConnectionCircuitNode)netCircuitNode3).getFstCircuitNode().equals(netCircuitNode) && !dualConnectionCircuitNode.getSecCircuitNode().equals(netCircuitNode)) continue;
                        disjointPart = (DisjointPart)this.nodeDisjointPartMap.get(dualConnectionCircuitNode);
                        return disjointPart;
                    }
                } else {
                    netCircuitNode2 = (NetCircuitNode)list.get(0);
                    if (netCircuitNode2 != null && netCircuitNode2.hasDualConnections()) {
                        disjointPart = (DisjointPart)this.nodeDisjointPartMap.get(netCircuitNode2);
                    }
                }
            }
        }
        return disjointPart;
    }

    protected void unify(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        NetCircuitMergeOperator netCircuitMergeOperator;
        DisjointPart disjointPart;
        DisjointPart disjointPart2;
        NetCcatCircuit netCcatCircuit;
        boolean bl;
        if (this.dbgOn()) {
            db.println("unify starts - # disjoint parts = " + this.getDisjointPartsNum());
        }
        if (this.dbgOn()) {
            db.println("myNode:");
            netCircuitNode.prettyPrint(db);
            db.println("otherNode:");
            netCircuitNode2.prettyPrint(db);
        }
        boolean bl2 = bl = (netCcatCircuit = (NetCcatCircuit)netCircuitNode2.getCircuit()) == this.myCircuit;
        if (this.dbgOn()) {
            db.println("onSameCircuit = " + bl);
        }
        if ((disjointPart2 = this.getDisjointPartOnNode(netCircuitNode)) == (disjointPart = (netCircuitMergeOperator = bl ? this : mergeManager.getMergeOperator(netCcatCircuit)).getDisjointPartOnNode(netCircuitNode2))) {
            if (this.dbgOn()) {
                db.println("on same disjoing part");
            }
        } else {
            Object object;
            if (!bl && (object = this.findCommonNE(disjointPart)) != null) {
                NetCircuitNode netCircuitNode3 = null;
                List list = this.myCircuit.getCircuitNodeFromNE((INetElement)object);
                if (list != null) {
                    if (list.size() > 1) {
                        if (this.dbgOn()) {
                            db.println("Error !! Merging MXPN circuit not supported");
                        }
                    } else {
                        netCircuitNode3 = (NetCircuitNode)list.get(0);
                    }
                }
                NetCircuitNode netCircuitNode4 = null;
                list = netCcatCircuit.getCircuitNodeFromNE((INetElement)object);
                if (list != null) {
                    if (list.size() > 1) {
                        if (this.dbgOn()) {
                            db.println("Error !! Merging MXPN circuit not supported");
                        }
                    } else {
                        netCircuitNode4 = (NetCircuitNode)list.get(0);
                    }
                }
                if (netCircuitNode3 != null && netCircuitNode4 != null && !this.myCircuit.getCircuitTypeObj().isOchncType() && !this.myCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
                    this.handleDualNodes(netCircuitNode3, netCircuitNode4, disjointPart2, disjointPart, netCcatCircuit);
                }
            }
            netCircuitMergeOperator.removeDisjointPart(disjointPart);
            disjointPart2.unify(disjointPart);
            if (!bl) {
                for (NetCircuitNode netCircuitNode3 : disjointPart.getNodeSet()) {
                    this.moveConnection(netCircuitNode3, (NetCcatCircuit)netCircuitNode3.getCircuit(), this.myCircuit);
                }
            }
        }
        if (this.dbgOn()) {
            db.println("unify ends - # disjoint parts = " + this.getDisjointPartsNum());
            this.myCircuit.prettyPrint(db);
        }
    }

    private INetElement findCommonNE(DisjointPart disjointPart) {
        Iterator iterator = disjointPart.nodeSet.iterator();
        while (iterator.hasNext()) {
            INetElement iNetElement = ((INetCircuitNode)iterator.next()).getNetElement();
            Object var4_4 = null;
            List list = this.myCircuit.getCircuitNodeFromNE(iNetElement);
            if (list == null || list.size() < 1) continue;
            return iNetElement;
        }
        return null;
    }

    private void handleDualNodes(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2, DisjointPart disjointPart, DisjointPart disjointPart2, NetCcatCircuit netCcatCircuit) {
        if (this.myCircuit.sameNEUnifyAllowed(netCircuitNode, netCircuitNode2)) {
            NetCircuitNode netCircuitNode3 = NetCircuitNodeFactory.createDualConnectionCircuitNode(netCircuitNode, netCircuitNode2);
            this.moveConnection(netCircuitNode2, netCcatCircuit, this.myCircuit);
            this.myCircuit.insertCktNode(netCircuitNode3);
            disjointPart.add(netCircuitNode3);
            disjointPart.add(netCircuitNode2);
            disjointPart2.remove(netCircuitNode2);
            if (this.dbgOn()) {
                db.println("after handleDualNodes - # disjoint parts = " + this.getDisjointPartsNum());
                this.myCircuit.prettyPrint(db);
            }
        }
    }

    private void moveConnection(NetCircuitNode netCircuitNode, NetCcatCircuit netCcatCircuit, NetCcatCircuit netCcatCircuit2) {
        HashMap hashMap = netCircuitNode.getAllSpans();
        netCcatCircuit.removeCktNode(netCircuitNode);
        for (NetCircuitSpan netCircuitSpan : hashMap.keySet()) {
            netCcatCircuit.removeCktSpan(netCircuitSpan);
        }
        netCcatCircuit2.insertCktNode(netCircuitNode);
        for (NetCircuitSpan netCircuitSpan : hashMap.keySet()) {
            netCcatCircuit2.insertCktSpan(netCircuitSpan);
        }
        netCircuitNode.setCircuit(netCcatCircuit2);
    }

    private void moveDisjointPart(DisjointPart disjointPart, NetCcatCircuit netCcatCircuit, NetCcatCircuit netCcatCircuit2) {
        Object object2;
        for (Object object2 : disjointPart.getNodeSet()) {
            this.moveConnection((NetCircuitNode)object2, netCcatCircuit, netCcatCircuit2);
        }
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.getMergeOperator(netCcatCircuit);
        object2 = mergeManager.getMergeOperator(netCcatCircuit2);
        if (netCircuitMergeOperator != null) {
            super.removeDisjointPart(disjointPart);
        }
        if (object2 != null) {
            super.addDisjointPart(disjointPart);
        }
    }

    private void addDisjointPart(DisjointPart disjointPart) {
        if (!this.disjointParts.contains(disjointPart)) {
            this.disjointParts.add(disjointPart);
            for (NetCircuitNode netCircuitNode : disjointPart.getNodeSet()) {
                this.nodeDisjointPartMap.put(netCircuitNode, disjointPart);
            }
        }
    }

    private void removeDisjointPart(DisjointPart disjointPart) {
        if (this.disjointParts.contains(disjointPart)) {
            this.disjointParts.remove(disjointPart);
            for (NetCircuitNode netCircuitNode : disjointPart.getNodeSet()) {
                this.nodeDisjointPartMap.remove(netCircuitNode);
            }
        } else if (this.dbgOn()) {
            db.print("Can't find disjointPart: ");
            disjointPart.prettyPrint(db);
        }
    }

    private void permanentlyMoveConnections() throws CircuitProvError {
        Iterator iterator = this.disjointParts.iterator();
        while (iterator.hasNext()) {
            this.permanentlyMoveConnections((DisjointPart)iterator.next());
        }
    }

    private void permanentlyMoveConnections(DisjointPart disjointPart) throws CircuitProvError {
        ICircuitId iCircuitId = this.myCircuit.getCircuitId();
        for (NetCircuitNode netCircuitNode : disjointPart.getNodeSet()) {
            Object object;
            if (!netCircuitNode.getConnectionCircuitId().equals(iCircuitId)) {
                netCircuitNode.setConnectionCircuitId(iCircuitId);
                this.changed = true;
                object = mergeManager.findOperatorBeforeMerge(netCircuitNode);
                ((NetCircuitMergeOperator)object).changed = true;
            }
            if (!this.needToUseOldCircuitName() || (object = netCircuitNode.getConnNameFromNE()) == null || ((String)object).equals(this.circuitNameBeforeMerge)) continue;
            netCircuitNode.setConnName(this.circuitNameBeforeMerge);
            this.changed = true;
        }
    }

    public void reloadWholeCircuit() {
        this.myCircuit.setInCircuitMerge(false);
        this.reloadCircuitInfo();
        this.reloadAllConnections();
    }

    private void reloadAllConnections() {
        for (NetCircuitNode netCircuitNode : this.myCircuit.getCircuitNodes()) {
            NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.findOperatorBeforeMerge(netCircuitNode);
            if (netCircuitMergeOperator == this) {
                netCircuitNode.conformToConnection();
                continue;
            }
            this.markRollbackXconExisted(netCircuitNode);
            this.myCircuit.disposeConnection(netCircuitNode, false);
            NetCircuitWatchDog.instance().reloadConnections(netCircuitNode.getNetElement());
        }
        if (this.pureTl1CktBeforeMerge && this.myCircuit.getCktNodeListSize() == 0) {
            this.myCircuit.checkAndUpdateCircuit();
            if (!this.myCircuit.isCircuitRefValid()) {
                this.myCircuit.notifyObservers(ModelUpdateType.DELETED);
            }
        }
        if (this.myCircuit.isCircuitRefValid()) {
            this.myCircuit.setProtType();
        }
    }

    private void markRollbackXconExisted(NetCircuitNode netCircuitNode) {
        NetCircuitMergeOperator netCircuitMergeOperator = mergeManager.findOperatorBeforeMerge(netCircuitNode);
        if (netCircuitMergeOperator != null) {
            ICircuitId iCircuitId = netCircuitNode.getConnectionCircuitId();
            if (iCircuitId != null && !NetCircuit.isNullCircuitId(iCircuitId)) {
                if (this.dbgOn()) {
                    db.println("Circuit " + netCircuitMergeOperator.myCircuit.getCircuitName() + "exist rollback cross-connect.");
                }
                netCircuitMergeOperator.existsRollbackXconnects = true;
            }
        } else if (netCircuitNode instanceof DualConnectionCircuitNode) {
            NetCircuitNode[] netCircuitNodeArray = ((DualConnectionCircuitNode)netCircuitNode).getChildCktNodes();
            for (int i = 0; i < netCircuitNodeArray.length; ++i) {
                this.markRollbackXconExisted(netCircuitNodeArray[i]);
            }
        }
    }

    private void reloadCircuitInfo() {
        this.myCircuit.setInCircuitMerge(false);
        if (this.circuitModelBeforeMerge != null) {
            this.myCircuit.updateCircuitInfo(this.circuitModelBeforeMerge, false);
            this.myCircuit.notifyChanged();
        }
    }

    public boolean connectToCircuitSource(NetCircuitNode netCircuitNode) {
        DisjointPart disjointPart = this.getDisjointPartOnNode(netCircuitNode);
        if (disjointPart == null) {
            return false;
        }
        return disjointPart.getNodeSet().contains(this.sourceNodeBeforeMerge);
    }

    private boolean isNodesStructureComplete(NetCcatCircuit netCcatCircuit) {
        IEntityModel iEntityModel;
        int n = this.getAdjustedCircuitType(netCcatCircuit.getCircuitNodes(), netCcatCircuit.getCircuitType());
        if (n != netCcatCircuit.getCircuitType()) {
            if (netCcatCircuit == this.myCircuit && netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                netCcatCircuit.deleteLAPLink(CircuitType.getCircuitType((int)n));
            }
            netCcatCircuit.setCircuitType(n);
            if (netCcatCircuit == this.myCircuit && netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
                netCcatCircuit.insertLAPLink(CircuitType.getCircuitType((int)n));
            }
        }
        netCcatCircuit.setCircuitRoutingDirection();
        if (!netCcatCircuit.initSourcesAndDrops()) {
            if (this.isEtherPacketRingCircuit(netCcatCircuit)) {
                if (!this.reconfigureEtherPacketRingCircuit(netCcatCircuit)) {
                    return false;
                }
            } else {
                return false;
            }
        }
        if (!netCcatCircuit.isNodesStructureComplete()) {
            if (this.dbgOn()) {
                db.println("node structure is incomplete.");
            }
            return false;
        }
        if (netCcatCircuit.getCircuitTypeObj().isTunnelCircuitType() || netCcatCircuit.getCircuitTypeObj().isLAPCircuitType() || netCcatCircuit.getCircuitTypeObj().isEthernetCircuitType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            return true;
        }
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        try {
            iEntityModel = netCcatCircuit.getPrimarySource().getEntityModel();
        }
        catch (ObjNotFound objNotFound) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)objNotFound);
            }
            return false;
        }
        Iterator iterator = netCcatCircuit.getCktDrops().iterator();
        while (iterator.hasNext()) {
            ITdmProtocolType iTdmProtocolType;
            arrayList.clear();
            NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
            try {
                arrayList.add(netCircuitDropInfo.getEntityModel());
            }
            catch (ObjNotFound objNotFound) {
                if (this.dbgOn()) {
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
                return false;
            }
            boolean bl = false;
            if (iEntityModel != null) {
                boolean bl2 = bl = iEntityModel.getModuleModel().getEqType() == 233 || iEntityModel.getModuleModel().getEqType() == 234;
            }
            if ((iTdmProtocolType = Network.instance().findNetElem(iEntityModel.getNodeModel()).getTdmProtocolTypeObj()).isSdh() && netCcatCircuit.getCircuitSize() == 11 && bl) {
                ILoNum iLoNum = netCcatCircuit.getPrimarySource().getLoNum();
                short s = iLoNum.getVc3OrSts1();
                List list = iEntityModel.getParent().getDescendantsOfClassType(7);
                for (int i = 0; i < list.size(); ++i) {
                    if (((IEntityModel)list.get(i)).getPositionInParent() != s) continue;
                    iEntityModel = (IEntityModel)list.get(i);
                }
            }
            if (!Endpoints.instance().filterAvailDropEntities(iEntityModel, arrayList, netCcatCircuit.getCircuitTypeObj(), netCcatCircuit.getCircuitDir()).isEmpty()) continue;
            if (this.dbgOn()) {
                db.println("source and drop payload types do not match");
            }
            return false;
        }
        return true;
    }

    private boolean isEtherPacketRingCircuit(NetCcatCircuit netCcatCircuit) {
        if (this.dbgOn()) {
            db.println("checkEtherPacketRing");
        }
        if (netCcatCircuit.getSourcesSize() != 0 || netCcatCircuit.getDropsSize() < 2) {
            return false;
        }
        for (NetCircuitDropInfo netCircuitDropInfo : netCcatCircuit.getDrops()) {
            if (netCircuitDropInfo.getNetCktEnd() instanceof EtherNodeDropCircuitEnd) continue;
            return false;
        }
        if (this.dbgOn()) {
            db.println("Is a ether packet ring circuit.");
        }
        return true;
    }

    private boolean reconfigureEtherPacketRingCircuit(NetCcatCircuit netCcatCircuit) {
        Object object2;
        ArrayList<NetCircuitNode> arrayList = new ArrayList<NetCircuitNode>();
        for (Object object2 : netCcatCircuit.getCircuitNodes()) {
            if (!((NetCircuitNode)object2).isNodeDrop()) continue;
            arrayList.add((NetCircuitNode)object2);
        }
        if (arrayList.size() == 0) {
            db.severe("Wrong - could not find drops");
            return false;
        }
        NetCircuitNode netCircuitNode = arrayList.contains(this.sourceNodeBeforeMerge) ? this.sourceNodeBeforeMerge : (NetCircuitNode)arrayList.get(0);
        object2 = netCircuitNode.getNodeDrop();
        netCcatCircuit.insertSource((NetCircuitEnd)object2);
        netCcatCircuit.removeDrop(new NetCircuitDropInfo((NetCircuitEnd)object2, 2));
        netCcatCircuit.updateCircuitSourceInfo();
        netCcatCircuit.updateCircuitDropInfo();
        boolean bl = netCcatCircuit.setSrcCircuitNode();
        if (this.dbgOn()) {
            db.println("source size = " + netCcatCircuit.getSourcesSize());
            db.println("drop size = " + netCcatCircuit.getDropsSize());
            db.println("reconfigure packet ring result = " + bl);
        }
        return bl;
    }

    public int getDisjointPartsNum() {
        if (this.dbgOn()) {
            db.println("# of disjoint parts = " + this.disjointParts.size());
        }
        return this.disjointParts.size();
    }

    public boolean needToUseOldCircuitName() {
        return this.operation == 0 || this.operation == 1 || this.myCircuit.getCircuitTypeObj().isEthernetCircuitType();
    }

    public int getNodeNumInAllDisjointParts() {
        int n = 0;
        Iterator iterator = this.disjointParts.iterator();
        while (iterator.hasNext()) {
            n += ((DisjointPart)iterator.next()).getNodeSet().size();
        }
        return n;
    }

    private Set getNodesInAllDisjointParts() {
        HashSet hashSet = new HashSet();
        Iterator iterator = this.disjointParts.iterator();
        while (iterator.hasNext()) {
            hashSet.addAll(((DisjointPart)iterator.next()).getNodeSet());
        }
        return hashSet;
    }

    public int getCircuitNodeNumBeforeMerge() {
        return this.circuitNodeNumBeforeMerge;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean adjustVcatCircuit(NetVcatCircuit netVcatCircuit) {
        ICircuitId iCircuitId;
        Object object2;
        if (netVcatCircuit.getState() != 5) {
            return false;
        }
        for (Object object2 : netVcatCircuit.getAllMemberCircuits()) {
            if (((INetCircuit)object2).getState() == 1) continue;
            return false;
        }
        try {
            iCircuitId = netVcatCircuit.getOperator().createCircuitInfo(netVcatCircuit.getSrcNodeModel(), netVcatCircuit.getCircuitInfo());
        }
        catch (CircuitProvError circuitProvError) {
            NetVcatCircuit netVcatCircuit2 = netVcatCircuit;
            synchronized (netVcatCircuit2) {
                for (Object e : netVcatCircuit.getAllVcatTerms()) {
                    NetVcatTermination netVcatTermination = (NetVcatTermination)e;
                    netVcatCircuit.disposeVcatTerm(netVcatTermination, false);
                    NetCircuitWatchDog.instance().reloadVcatTerms(netVcatTermination.getNetElement());
                }
            }
            return false;
        }
        object2 = netVcatCircuit;
        synchronized (object2) {
            for (Object e : netVcatCircuit.getAllVcatTerms()) {
                ((NetVcatTermination)e).setVcatTermCircuitId(iCircuitId);
            }
        }
        netVcatCircuit.completeCheck();
        return true;
    }

    public boolean changed() {
        return this.changed;
    }

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeOpenVcats() {
        NetVcatCircuit netVcatCircuit;
        Object object;
        if (db.on()) {
            db.println("Adjusting the VCGs and CktModels now.");
        }
        INetCircuit iNetCircuit = (INetCircuit)this.baseVcat.getAllMemberCircuits().get(0);
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.baseVcat.getPrimarySource();
        boolean bl = false;
        NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)iNetCircuit.getPrimarySource();
        NetCircuitEnd netCircuitEnd3 = NetCircuitEndFactory.createCircuitEnd(iNetCircuit.getCircuitType(), netCircuitEnd2);
        netCircuitEnd3.setPathIdentifier(0);
        if (!netCircuitEnd3.equals(netCircuitEnd)) {
            bl = true;
        }
        ICircuitId iCircuitId = this.baseVcat.getCircuitId();
        if (bl) {
            if (db.on()) {
                db.println("Member circuits have swapped ends.");
            }
            object = this.otherVcat;
            synchronized (object) {
                netVcatCircuit = this.baseVcat;
                synchronized (netVcatCircuit) {
                    this.otherVcat.deleteCircuitInfoObserver();
                    this.baseVcat.deleteCircuitInfoObserver();
                    if (db.on()) {
                        db.println("Setting Master circuit's source and drops");
                    }
                    INodeModel iNodeModel = ((NetCircuitEnd)this.otherVcat.getPrimarySource()).getNodeModel();
                    this.baseVcat.setSrcNodeModel(iNodeModel);
                    int n = ((NetCircuitDropInfo)((NetCircuit)this.baseVcat.getAllMemberCircuits().get(0)).getDrops().get(0)).getPathProt();
                    NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd, n);
                    LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
                    linkedList.add(netCircuitDropInfo);
                    this.baseVcat.setDrops(linkedList);
                    this.baseVcat.setSources(this.otherVcat.getSources());
                    if (db.on()) {
                        db.println("Getting Destination VcatTerm from child circuit");
                    }
                    NetVcatTermination netVcatTermination = (NetVcatTermination)this.otherVcat.getAllVcatTerms().get(0);
                    ((NetVcatGroup)this.baseVcat.getForwardVcatGroup()).insertVcatTermination(netVcatTermination);
                    try {
                        netVcatTermination.setVcatName(this.getOrigName(this.baseVcat.getCircuitName()));
                    }
                    catch (CircuitProvError circuitProvError) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    netVcatTermination.setVcatCircuit(this.baseVcat);
                    netVcatTermination.setVcatTermCircuitId(iCircuitId);
                    if (db.on()) {
                        db.println("About to delete the old circuitModel of the Master");
                    }
                    try {
                        this.baseVcat.circuitModel().delete();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    catch (ErrorWritingToDb errorWritingToDb) {
                        SDebug.printStackTrace((Throwable)errorWritingToDb);
                    }
                    this.baseVcat.setCircuitModel(null);
                    CktInfo cktInfo = new CktInfo();
                    ICircuitInfo iCircuitInfo = this.baseVcat.getCircuitInfo();
                    cktInfo.setSrcPoint(NetCircuitMergeOperator.createNullCircuitEnd());
                    cktInfo.setSecSrcPoint(NetCircuitMergeOperator.createNullCircuitEnd());
                    cktInfo.setDropInfo(new ICircuitDropInfo[0]);
                    cktInfo.setVlans(new IVlanInfo[0]);
                    cktInfo.setMonitor(iCircuitInfo.getMonitor());
                    cktInfo.setCircuitSize(iCircuitInfo.getCircuitSize());
                    cktInfo.setCircuitType(iCircuitInfo.getCircuitType());
                    cktInfo.setDir(iCircuitInfo.getDir());
                    cktInfo.setSla(iCircuitInfo.getSla());
                    cktInfo.setCircuitName(iCircuitInfo.getCircuitName());
                    cktInfo.setSrcPoint(((NetCircuitEnd)this.baseVcat.getPrimarySource()).getCircuitEnd());
                    LinkedList<ICircuitDropInfo> linkedList2 = new LinkedList<ICircuitDropInfo>();
                    linkedList2.add(netCircuitDropInfo.getCircuitDropInfo());
                    ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[]{};
                    iCircuitDropInfoArray = linkedList2.toArray(iCircuitDropInfoArray);
                    cktInfo.setDropInfo(iCircuitDropInfoArray);
                    cktInfo.setVcatRoutingPref(iCircuitInfo.getVcatRoutingPref());
                    ICircuitId iCircuitId2 = null;
                    if (db.on()) {
                        db.println("About to create the new Circuit Model");
                    }
                    try {
                        iCircuitId2 = this.baseVcat.getOperator().createCircuitInfo(iNodeModel, cktInfo);
                    }
                    catch (CircuitProvError circuitProvError) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    if (db.on()) {
                        db.println("Setting the VcatTerm Id to the new id");
                    }
                    for (NetVcatTermination netVcatTermination2 : this.baseVcat.getAllVcatTerms()) {
                        netVcatTermination2.setVcatTermCircuitId(iCircuitId2);
                    }
                    if (db.on()) {
                        db.println("About to delete the Child Vcat Circuit");
                    }
                    this.otherVcat.setSrcNodeModel(null);
                    this.otherVcat.setDrops(null);
                    this.otherVcat.setSources(null);
                    ((NetVcatGroup)this.otherVcat.getForwardVcatGroup()).clearMemberCircuits();
                    ((NetVcatGroup)this.otherVcat.getForwardVcatGroup()).clearVcatTerms();
                    try {
                        this.otherVcat.circuitModel().delete();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    catch (ErrorWritingToDb errorWritingToDb) {
                        SDebug.printStackTrace((Throwable)errorWritingToDb);
                    }
                    this.otherVcat.setCircuitModel(null);
                }
            }
            this.otherVcat.finalDispose();
            this.otherVcat.notifyDeleted();
            this.baseVcat.ncMgr.notifyObservers();
            this.baseVcat.addCircuitInfoObserver();
        } else {
            if (db.on()) {
                db.println("Member circuits have not swapped ends.");
            }
            object = this.otherVcat;
            synchronized (object) {
                netVcatCircuit = this.baseVcat;
                synchronized (netVcatCircuit) {
                    NetCircuitEnd netCircuitEnd4 = (NetCircuitEnd)this.otherVcat.getPrimarySource();
                    int n = ((NetCircuitDropInfo)((NetCircuit)this.baseVcat.getAllMemberCircuits().get(0)).getDrops().get(0)).getPathProt();
                    NetCircuitDropInfo netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd4, n);
                    LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
                    linkedList.add(netCircuitDropInfo);
                    this.otherVcat.deleteCircuitInfoObserver();
                    this.baseVcat.deleteCircuitInfoObserver();
                    if (db.on()) {
                        db.println("Setting Master Circuit's Drop");
                    }
                    this.baseVcat.setDrops(linkedList);
                    try {
                        this.baseVcat.circuitModel().addDrop(netCircuitDropInfo.getCircuitDropInfo());
                    }
                    catch (OnlyOneDropPerBidirCktAllowed onlyOneDropPerBidirCktAllowed) {
                        SDebug.printStackTrace((Throwable)onlyOneDropPerBidirCktAllowed);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    NetVcatTermination netVcatTermination = (NetVcatTermination)this.otherVcat.getAllVcatTerms().get(0);
                    if (db.on()) {
                        db.println("Getting Destination VcatTerm from child circuit");
                    }
                    ((NetVcatGroup)this.baseVcat.getForwardVcatGroup()).insertVcatTermination(netVcatTermination);
                    try {
                        netVcatTermination.setVcatName(this.getOrigName(this.baseVcat.getCircuitName()));
                    }
                    catch (CircuitProvError circuitProvError) {
                        SDebug.printStackTrace((Throwable)circuitProvError);
                    }
                    netVcatTermination.setVcatCircuit(this.baseVcat);
                    netVcatTermination.setVcatTermCircuitId(iCircuitId);
                    if (db.on()) {
                        db.println("About to delete the Child Vcat Circuit");
                    }
                    this.otherVcat.setSrcNodeModel(null);
                    this.otherVcat.setDrops(null);
                    this.otherVcat.setSources(null);
                    ((NetVcatGroup)this.otherVcat.getForwardVcatGroup()).clearMemberCircuits();
                    ((NetVcatGroup)this.otherVcat.getForwardVcatGroup()).clearVcatTerms();
                    try {
                        this.otherVcat.circuitModel().delete();
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                    catch (ErrorWritingToDb errorWritingToDb) {
                        SDebug.printStackTrace((Throwable)errorWritingToDb);
                    }
                    this.otherVcat.setCircuitModel(null);
                }
            }
            this.otherVcat.finalDispose();
            this.otherVcat.notifyDeleted();
            this.baseVcat.ncMgr.notifyObservers();
            this.baseVcat.addCircuitInfoObserver();
        }
        if (db.on()) {
            db.println("Removing tags from circuit names");
        }
        object = this.getOrigName(this.baseVcat.getCircuitName());
        try {
            this.baseVcat.rename((String)object);
        }
        catch (CircuitProvError circuitProvError) {
            SDebug.printStackTrace((Throwable)circuitProvError);
        }
    }

    private String getOrigName(String string) {
        String string2 = string;
        int n = string.lastIndexOf("_Master");
        if (n != -1) {
            string2 = string.substring(0, n);
        }
        return string2;
    }

    protected static CircuitEnd createNullCircuitEnd() {
        return new CircuitEnd(0, 0, null, null, false, 0);
    }

    public static int getNoOfMemsInVcat(INetCircuit iNetCircuit) {
        return ((NetCcatCircuit)iNetCircuit).getVcatGroup().getNetVcatCircuit().getAllMemberCircuits().size();
    }

    public static NetVcatCircuit getNetVcatCircuit(INetCircuit iNetCircuit) {
        return ((NetCcatCircuit)iNetCircuit).getVcatGroup().getNetVcatCircuit();
    }

    public static boolean readytoAdjust(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        NetVcatCircuit netVcatCircuit = NetCircuitMergeOperator.getNetVcatCircuit(iNetCircuit);
        NetVcatCircuit netVcatCircuit2 = NetCircuitMergeOperator.getNetVcatCircuit(iNetCircuit2);
        INodeModel iNodeModel = netVcatCircuit.getSrcNodeModel();
        INodeModel iNodeModel2 = netVcatCircuit2.getSrcNodeModel();
        Iterator iterator = netVcatCircuit.getAllMemberCircuits().iterator();
        int n = netVcatCircuit.getAllMemberCircuits().size();
        int n2 = 0;
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit3 = (INetCircuit)iterator.next();
            INodeModel iNodeModel3 = iNetCircuit3.getPrimarySource().getNodeModel();
            INodeModel iNodeModel4 = ((INetCircuitEnd)iNetCircuit3.getDrops().get(0)).getNodeModel();
            if ((!iNodeModel3.equals(iNodeModel) || !iNodeModel4.equals(iNodeModel2)) && (!iNodeModel3.equals(iNodeModel2) || !iNodeModel4.equals(iNodeModel))) continue;
            ++n2;
        }
        return n - n2 == 1;
    }

    public static void validate(INetCircuit iNetCircuit) throws Exception {
        Object object;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList();
        NetVcatCircuit netVcatCircuit = NetCircuitMergeOperator.getNetVcatCircuit(iNetCircuit);
        if (netVcatCircuit == null) {
            throw new Exception("Master Circuit is null.Cannot merge.");
        }
        Iterator iterator = netVcatCircuit.getAllMemberCircuits().iterator();
        int n = netVcatCircuit.getAllMemberCircuits().size();
        CircuitMergeFilter circuitMergeFilter = null;
        List list = null;
        while (iterator.hasNext()) {
            object = (INetCircuit)iterator.next();
            if (object.equals(iNetCircuit)) continue;
            circuitMergeFilter = new CircuitMergeFilter((INetCircuit)object);
            list = circuitMergeFilter.findLinedupCircuits();
            if (list.size() > 0) {
                linkedList2.addAll(list);
            } else {
                linkedList.add(object);
            }
            list = null;
        }
        object = "";
        int n2 = linkedList.size();
        if (n2 > 0) {
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                if (((String)object).length() > 0) {
                    object = (String)object + ",";
                }
                object = (String)object + ((INetCircuit)iterator.next()).getCircuitName();
            }
        }
        if (linkedList2.size() != n - 1) {
            if (n2 > 1) {
                throw new Exception("Member Circuits " + (String)object + " are not properly aligned.Cannot Merge.");
            }
            throw new Exception("Member Circuit " + (String)object + " is not properly aligned.Cannot Merge.");
        }
    }

    protected class DisjointPart {
        private Set nodeSet = new HashSet();

        DisjointPart(NetCircuitNode netCircuitNode) {
            this.nodeSet.add(netCircuitNode);
            NetCircuitMergeOperator.this.nodeDisjointPartMap.put(netCircuitNode, this);
        }

        Set getNodeSet() {
            return this.nodeSet;
        }

        void unify(DisjointPart disjointPart) {
            Iterator iterator = disjointPart.nodeSet.iterator();
            while (iterator.hasNext()) {
                this.add((NetCircuitNode)iterator.next());
            }
        }

        void add(INetCircuitNode iNetCircuitNode) {
            this.nodeSet.add(iNetCircuitNode);
            NetCircuitMergeOperator.this.nodeDisjointPartMap.put(iNetCircuitNode, this);
        }

        void remove(INetCircuitNode iNetCircuitNode) {
            this.nodeSet.remove(iNetCircuitNode);
            NetCircuitMergeOperator.this.nodeDisjointPartMap.remove(iNetCircuitNode);
        }

        boolean containLoTunnelNode() {
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                if (!(iterator.next() instanceof LoTunnelNode)) continue;
                return true;
            }
            return false;
        }

        boolean containEtherStitchNode() {
            for (NetCircuitNode netCircuitNode : this.nodeSet) {
                if (netCircuitNode.getConnectionType() != 8) continue;
                return true;
            }
            return false;
        }

        boolean containUpsrNode() {
            for (NetCircuitNode netCircuitNode : this.nodeSet) {
                int n = netCircuitNode.getConnectionType();
                if (n == 0 || !netCircuitNode.isUpsrSelector() && !netCircuitNode.isUpsrBridge()) continue;
                return true;
            }
            return false;
        }

        boolean containDualConnectionNode() {
            for (NetCircuitNode netCircuitNode : this.nodeSet) {
                if (!netCircuitNode.hasDualConnections()) continue;
                return true;
            }
            return false;
        }

        protected void prettyPrint(SDebug sDebug) {
            if (!sDebug.on()) {
                return;
            }
            sDebug.println("This disjoint part has totally " + this.nodeSet.size() + " circuit nodes.");
            Iterator iterator = this.nodeSet.iterator();
            while (iterator.hasNext()) {
                ((NetCircuitNode)iterator.next()).prettyPrint(sDebug);
            }
        }
    }
}

