/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.IConnectionType;
import cerent.cms.ncp.Connection;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;

public class NetCircuitNodeUtil {
    private NetCircuitNode node;
    private static final SDebug db = new SDebug("NetCircuitNodeUtil");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public NetCircuitNodeUtil(NetCircuitNode netCircuitNode) {
        this.node = netCircuitNode;
    }

    public INetCircuit getCircuit() {
        return this.node.getCircuit();
    }

    protected int findConnType() {
        INetCircuit iNetCircuit = this.getCircuit();
        if (this.node.equals(iNetCircuit.getSrcCircuitNode()) && iNetCircuit.isDiag()) {
            return 18;
        }
        if (iNetCircuit.getCircuitDir() == 1) {
            return this.findBiDirectionalConnType();
        }
        return this.findUniDirectionalConnType();
    }

    protected int findBiDirectionalConnType() {
        int n = this.node.countNumInputs();
        int n2 = this.node.countNumOutputs();
        int n3 = this.node.countNumOmniSpans();
        int n4 = n + n2 + n3;
        if (this.node.isNodeDrop()) {
            if (this.getCircuit().getCircuitTypeObj().isEthernetCircuitType()) {
                if (n4 == 2 && n == 1 || n4 == 1 || n4 == 0 && ((NetCcatCircuit)this.getCircuit()).getCktNodeListSize() == 1) {
                    return 8;
                }
                return 22;
            }
            if (n4 == 1 || n4 == 0 && this.node.onXm()) {
                return 1;
            }
            return 22;
        }
        if (n4 == 2) {
            if (n == 1 && n2 == 1 && n3 == 0 || n3 == 2 && n == 0 && n2 == 0) {
                return 1;
            }
        } else if (n4 == 3) {
            if (n == 2 && n2 == 1 || n == 1 && n2 == 2) {
                return 2;
            }
            if (n == 1 && n2 == 1 && n3 == 1) {
                return 10;
            }
        } else if (n4 == 4) {
            if (n == 2 && n2 == 2 && n3 == 0) {
                if (this.areSpansBlsrProtected()) {
                    return 13;
                }
                if (this.getCircuit().getCircuitTypeObj().isOchncType()) {
                    return 12;
                }
                return 3;
            }
            if (n == 1 && n2 == 1 && n3 == 2) {
                return 11;
            }
            if ((n == 2 && n2 == 1 || n == 1 && n2 == 2) && n3 == 1 && this.upsrBlsrHandoffProtCheck()) {
                return 14;
            }
        } else if (n4 == 6) {
            return 20;
        }
        if (this.node.onXm()) {
            return DualConnectionCircuitNode.findBiDirectionalConnType(this.node);
        }
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("Warning! findBiDirectionalConnType: Unknown Conn. Type, node: " + this.node.getName() + " total=" + n4 + " in: " + n + " out: " + n2 + " omni: " + n3);
        }
        return 22;
    }

    protected int findUniDirectionalConnType() {
        int n = this.node.countNumInputs();
        int n2 = this.node.countNumOutputs();
        int n3 = this.node.countNumOmniSpans();
        int n4 = n + n2 + n3;
        if (n3 > 2) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("FindUniDirectionalConnType: too many omni spans: " + n3);
            }
            return 22;
        }
        if (this.node.getBiSpans().size() != 0) {
            if (n4 == 2 && n3 == 0) {
                return 1;
            }
            if (n4 == 2 && n3 == 2) {
                return 1;
            }
            if (n4 == 3 && n3 == 1) {
                return 6;
            }
        }
        if (this.getCircuit().isMonitorCircuit() && this.getCircuit().getSrcCircuitNode().equals(this.node)) {
            if (n == 1 && n2 == 1) {
                return 9;
            }
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("Unknown conn type at " + this.node.getName());
            }
            return 22;
        }
        if (n4 == 2 && n == 1 && n2 == 1) {
            return 0;
        }
        if (n4 == 3) {
            if (n == 2 && n2 == 1) {
                return 6;
            }
            if (n == 1 && n2 == 1 && n3 == 1) {
                return 6;
            }
            if (n == 1 && n2 == 2) {
                return 0;
            }
        }
        if (n4 == 4) {
            if (n == 2 && n2 == 2) {
                if (this.areSpansBlsrProtected()) {
                    return 15;
                }
                return 6;
            }
            if (n == 2 && n2 == 1 && n3 == 1) {
                if (this.upsrBlsrHandoffProtCheck()) {
                    return 16;
                }
            } else if (n == 1 && n2 == 2 && n3 == 1 && this.blsrUpsrHandoffProtCheck()) {
                return 0;
            }
        }
        if (this.node.onXm()) {
            return DualConnectionCircuitNode.findUniDirectionalConnType(this.node);
        }
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("Unknown conn type at " + this.node.getName());
        }
        return 22;
    }

    protected boolean areSpansBlsrProtected() {
        NetCircuitSpan netCircuitSpan;
        NetLinkSpan netLinkSpan;
        INetLink iNetLink;
        INetLink iNetLink2;
        Object object;
        String[] stringArray = new String[4];
        Network network = Network.instance();
        INetElement iNetElement = this.node.getNetElement();
        INetCircuit iNetCircuit = this.node.getCircuit();
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("areSpansBlsrProtected");
        }
        if (this.node.countNumInputs() != 2 || this.node.countNumOutputs() != 2 || this.node.countNumOmniSpans() != 0) {
            return false;
        }
        LinkedList linkedList = this.node.getTermSpans();
        LinkedList linkedList2 = this.node.getOrigSpans();
        List list = this.node.getSources();
        List list2 = this.node.getDrops();
        if (linkedList.size() != 2) {
            if (list.isEmpty()) {
                return false;
            }
            object = (NetCircuitEnd)list.get(0);
            iNetLink2 = network.findNetLinkFromSource(false, ((NetCircuitEnd)object).getNetElement(), ((NetCircuitEnd)object).getEntityIndex(), ((NetCircuitEnd)object).getHoNum());
            if (iNetLink2 == null) {
                return false;
            }
            iNetLink = iNetLink2.getReverseLink();
            if (iNetLink == null) {
                return false;
            }
            netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, ((NetCircuitEnd)object).getHoNum(), ((NetCircuitEnd)object).getHoNum(), ((NetCircuitEnd)object).getLoNum());
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(iNetCircuit, netLinkSpan, null, null);
            linkedList.addFirst(netCircuitSpan);
        }
        if (linkedList2.size() != 2) {
            if (list2.isEmpty()) {
                return false;
            }
            object = (NetCircuitEnd)list2.get(0);
            iNetLink2 = network.findNetLinkFromSource(false, ((NetCircuitEnd)object).getNetElement(), ((NetCircuitEnd)object).getEntityIndex(), ((NetCircuitEnd)object).getHoNum());
            if (iNetLink2 == null) {
                return false;
            }
            iNetLink = iNetLink2.getReverseLink();
            if (iNetLink == null) {
                return false;
            }
            netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, ((NetCircuitEnd)object).getHoNum(), ((NetCircuitEnd)object).getHoNum(), ((NetCircuitEnd)object).getLoNum());
            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(iNetCircuit, netLinkSpan, null, null);
            linkedList2.addLast(netCircuitSpan);
        }
        if (linkedList.size() != 2 || linkedList2.size() != 2) {
            return false;
        }
        for (NetCircuitSpan netCircuitSpan2 : linkedList) {
            if (netCircuitSpan2.getLink().inBLSR()) continue;
            return false;
        }
        if (((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName(iNetElement).equals(((NetCircuitSpan)linkedList.get(1)).getLink().blsrRingName(iNetElement))) {
            return false;
        }
        stringArray[0] = ((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName();
        stringArray[1] = ((NetCircuitSpan)linkedList.get(1)).getLink().blsrRingName();
        for (NetCircuitSpan netCircuitSpan3 : linkedList2) {
            if (netCircuitSpan3.getLink().inBLSR()) continue;
            return false;
        }
        if (((NetCircuitSpan)linkedList2.get(0)).getLink().blsrRingName().equals(((NetCircuitSpan)linkedList2.get(1)).getLink().blsrRingName())) {
            return false;
        }
        stringArray[2] = ((NetCircuitSpan)linkedList2.get(0)).getLink().blsrRingName();
        stringArray[3] = ((NetCircuitSpan)linkedList2.get(1)).getLink().blsrRingName();
        if (!(stringArray[0].equals(stringArray[2]) && stringArray[1].equals(stringArray[3]) || stringArray[0].equals(stringArray[3]) && stringArray[1].equals(stringArray[2]))) {
            return false;
        }
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("areSpansBlsrProtected: true");
        }
        return true;
    }

    private boolean upsrBlsrHandoffProtCheck() {
        String string;
        LinkedList linkedList;
        LinkedList linkedList2;
        boolean bl = false;
        if (this.node.countNumTermSpans() == 2 && this.node.countNumOrigSpans() == 1 && this.node.countNumOmniSpans() == 1) {
            linkedList2 = this.node.getTermSpans();
            linkedList = this.node.getOrigSpans();
        } else if (this.node.countNumTermSpans() == 1 && this.node.countNumOrigSpans() == 2 && this.node.countNumOmniSpans() == 1) {
            linkedList2 = this.node.getOrigSpans();
            linkedList = this.node.getTermSpans();
        } else {
            return false;
        }
        if (((NetCircuitSpan)linkedList2.get(0)).getLink().inBLSR() && !((NetCircuitSpan)linkedList2.get(1)).getLink().isProtected()) {
            string = ((NetCircuitSpan)linkedList2.get(0)).getLink().blsrRingName();
        } else if (!((NetCircuitSpan)linkedList2.get(0)).getLink().isProtected() && ((NetCircuitSpan)linkedList2.get(1)).getLink().inBLSR()) {
            string = ((NetCircuitSpan)linkedList2.get(1)).getLink().blsrRingName();
        } else {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: inSpans prot check failed");
            }
            return false;
        }
        LinkedList linkedList3 = this.node.getOmniSpans();
        if (((NetCircuitSpan)linkedList3.get(0)).getLink().isProtected()) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: omniSpans prot check failed");
            }
            return false;
        }
        if (!((NetCircuitSpan)linkedList.get(0)).getLink().inWorkingBLSR()) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: outSpans prot check failed");
            }
            return false;
        }
        if (!string.equals(((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName())) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("upsrBlsrHandoffProtCheck: inSpan-outSpan ring mismatch");
            }
            return false;
        }
        return true;
    }

    private boolean blsrUpsrHandoffProtCheck() {
        String string;
        boolean bl = false;
        INetElement iNetElement = this.node.getNetElement();
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("blsUpsrHandoffCheck");
        }
        if (this.node.countNumTermSpans() != 1 || this.node.countNumOrigSpans() != 2 || this.node.countNumOmniSpans() != 1) {
            return false;
        }
        LinkedList linkedList = this.node.getOrigSpans();
        if (((NetCircuitSpan)linkedList.get(0)).getLink().inBLSR() && !((NetCircuitSpan)linkedList.get(1)).getLink().isProtected()) {
            string = ((NetCircuitSpan)linkedList.get(0)).getLink().blsrRingName(iNetElement);
        } else if (!((NetCircuitSpan)linkedList.get(0)).getLink().isProtected() && ((NetCircuitSpan)linkedList.get(1)).getLink().inBLSR()) {
            string = ((NetCircuitSpan)linkedList.get(1)).getLink().blsrRingName(iNetElement);
        } else {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("blsUpsrHandoffCheck: outspan protection check failed");
            }
            return false;
        }
        LinkedList linkedList2 = this.node.getOmniSpans();
        if (((NetCircuitSpan)linkedList2.get(0)).getLink().isProtected()) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("blsUpsrHandoffCheck: omnispan protection check failed");
            }
            return false;
        }
        LinkedList linkedList3 = this.node.getTermSpans();
        if (!((NetCircuitSpan)linkedList3.get(0)).getLink().inWorkingBLSR()) {
            return false;
        }
        if (!string.equals(((NetCircuitSpan)linkedList3.get(0)).getLink().blsrRingName(iNetElement))) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("blsUpsrHandoffCheck: in out span ring mismatch");
            }
            return false;
        }
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("blsUpsrHandoffCheck: passed");
        }
        return true;
    }

    protected int findUpgradedConnType() {
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("finding upgraded connection type for Node " + this.node.getName());
        }
        int n = this.node.getConnectionType();
        int n2 = this.node.countRoutedOutputs();
        if (this.getCircuit().isBidirectional()) {
            if (this.node.getBiSpans().size() > 2) {
                return 22;
            }
            return n;
        }
        if (n == 1 && n2 > 0) {
            return 6;
        }
        return n;
    }

    protected int findDowngradedConnType() {
        if (this.getCircuit().isBidirectional()) {
            if (NetCircuitNodeUtil.dbgOn()) {
                db.println("Downgrade of bi-direc nodes not allowed");
            }
            return 22;
        }
        int n = this.node.countNumOutputs();
        int n2 = this.node.getConnectionType();
        if (n2 == 6 && n == 1) {
            return 1;
        }
        return n2;
    }

    protected int calculateConnectionType() {
        INetCircuit iNetCircuit = this.getCircuit();
        int n = this.node.countNumInputs();
        int n2 = this.node.countNumOutputs();
        int n3 = this.node.getBiSpans().size();
        int n4 = this.node.countNumOmniSpans();
        int n5 = iNetCircuit.isBidirectional() ? this.calculateBidirectionalConnType(n, n2, n3, n4, true, this.node.getName()) : this.calculateUnidirectionalConnType(n, n2, n3, n4, true, this.node.getName());
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("calculateConnectionType: old conn type => " + EnumStrings.getString(IConnectionType.class, (int)this.node.getConnectionType()) + ", new conn type => " + EnumStrings.getString(IConnectionType.class, (int)n5));
        }
        return n5;
    }

    private int calculateBidirectionalConnType(int n, int n2, int n3, int n4, boolean bl, String string) {
        int n5 = n + n2 + n4;
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("calculateBiConnType: inCount => " + n + ", outCount => " + n2 + ", biSpans => " + n3 + ", omniSpans => " + n4 + ", isUpsr => " + bl);
        }
        if (n5 == 2) {
            if (n == 1 && n2 == 1 && n4 == 0 || n4 == 2 && n == 0 && n2 == 0) {
                return 1;
            }
        } else if (n5 == 3) {
            if (n == 2 && n2 == 1 || n == 1 && n2 == 2) {
                return 2;
            }
            if (n == 1 && n2 == 1 && n4 == 1) {
                return 10;
            }
        } else if (n5 == 4) {
            if (n == 2 && n2 == 2 && n4 == 0) {
                return 3;
            }
            if (n == 1 && n2 == 1 && n4 == 2) {
                return 11;
            }
        }
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("calculateBidirectionalConnType: WARNING - unknown Conn. Type, node => " + string + ", total => " + n5 + ", in => " + n + ", out => " + n2 + ", omni => " + n4);
        }
        return 22;
    }

    private int calculateUnidirectionalConnType(int n, int n2, int n3, int n4, boolean bl, String string) {
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("calculateUniConnType: inCount => " + n + ", outCount => " + n2 + ", biSpans => " + n3 + ", omniSpans => " + n4 + ", isUpsr => " + bl);
        }
        if (n == 1 && n2 == 1) {
            if (bl) {
                return 1;
            }
            return 0;
        }
        if (n == 1 && n2 == 2) {
            return 0;
        }
        if (n == 2 && n2 == 1) {
            return 6;
        }
        if (n == 2 && n2 >= 2) {
            return 6;
        }
        if (n == 1 && n2 == 1 && n4 > 0 && n4 < 3) {
            return 6;
        }
        if (NetCircuitNodeUtil.dbgOn()) {
            db.println("calculateUnidirectionalConnType: WARNING - unknown Conn. Type, node => " + string + ", in => " + n + ", out => " + n2 + ", omni => " + n4);
        }
        return 22;
    }

    protected static boolean isBidirectionalConnType(int n) {
        return n == 1 || n == 2 || n == 3 || n == 8 || n == 10 || n == 11 || n == 13 || n == 14 || n == 12 || n == 18 || n == 20 || n == 21;
    }

    protected static boolean isUnidirectionalConnType(int n) {
        return n == 0 || n == 4 || n == 5 || n == 6 || n == 7 || n == 9 || n == 15 || n == 16;
    }

    protected static boolean hasTl1ConnType(int n) {
        return n == 0 || n == 1 || n == 2 || n == 3 || n == 9 || n == 10 || n == 11 || n == 12 || n == 18 || n == 13 || n == 14 || n == 15 || n == 16 || n == 20;
    }

    protected static boolean isUpsrSelectorConnType(int n) {
        return n == 2 || n == 3 || n == 7 || n == 5 || n == 6 || n == 10 || n == 11 || n == 14 || n == 13 || n == 15 || n == 16;
    }

    protected static boolean isUpsrBridgeConnType(int n, int n2) {
        return NetCircuitNodeUtil.isBridgedOneWay(n, n2) || n == 2 || n == 3 || n == 4 || n == 10 || n == 11 || n == 14 || n == 13 || n == 15 || n == 16;
    }

    protected static boolean isUpsrDriConn(int n) {
        return n == 10 || n == 11;
    }

    protected static boolean isBridgedOneWay(int n, int n2) {
        return (n == 0 || n == 4 || n == 9) && n2 > 1;
    }

    protected static boolean isBridgedOneWayDri(int n, int n2, int n3) {
        return n == 0 && n2 > 1 && n3 == 1;
    }

    protected boolean is1wayUpsrConnType(int n) {
        if (n == 4 || n == 0) {
            List list = this.node.getConnections();
            if (list.size() == 1) {
                NetCircuitSpan netCircuitSpan;
                Connection connection = (Connection)list.get(0);
                List list2 = connection.getInSpans();
                NetCircuitSpan netCircuitSpan2 = netCircuitSpan = list2.size() == 0 ? null : (NetCircuitSpan)list2.get(0);
                if (connection.isInputLineProtected(netCircuitSpan)) {
                    return false;
                }
                if (netCircuitSpan == null) {
                    db.println("is1wayUpsrConnType: Error in connection input on node " + this.node.getName());
                    return true;
                }
                return netCircuitSpan.getUpsrLink();
            }
            if (this.node.getCircuit().getState() == 1) {
                db.println("is1wayUpsrConnType: Error in connection list on node " + this.node.getName());
            }
            return true;
        }
        return n == 5 || n == 7;
    }

    protected static boolean isBlsrDriHandoff(int n) {
        return n == 1 || n == 2;
    }

    protected static boolean isBlsrDriIntermediate(int n) {
        return n == 3;
    }

    protected static boolean isBlsrDriPrimary(int n) {
        return n == 1;
    }

    protected static boolean isBlsrDriSecondary(int n) {
        return n == 2;
    }

    protected static boolean isBlsrDriType(int n) {
        return n == 1 || n == 2 || n == 3;
    }
}

