/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CannotDeleteLastDrop;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OnlyOneDropPerBidirCktAllowed;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.SDebug;
import java.util.LinkedList;
import java.util.List;

public abstract class NetCircuitOperator {
    private static final SDebug db = new SDebug("NetCircuitOperator");

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected abstract NetCircuit getCircuit();

    protected abstract void addDrop(INetCircuitEnd var1, RoutePrefs var2) throws AllocFailed, ObjNotFound, CircuitDropOutstanding, SanityCheckFailed, IncorrectCircuitState;

    protected abstract void routeCurrentDrop(INetElement var1, RoutePrefs var2, boolean var3) throws SanityCheckFailed, NoRoute, AllocFailed, AbstractCmsIOException;

    protected abstract void deleteDrop(INetCircuitEnd var1) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException;

    protected abstract void deleteDropCktEnd(INetCircuitEnd var1) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException;

    protected abstract String deriveDefaultName();

    protected abstract void tentative2Active();

    protected abstract void tentative2Routed() throws DeletionError, IncorrectCircuitState;

    protected void addDropCheck(NetCircuitEnd netCircuitEnd, int n) throws SanityCheckFailed, IncorrectCircuitState {
        int n2 = this.getCircuit().getState();
        if (n2 != 1 && n2 != 0 && n2 != 5 && !this.getCircuit().getCircuitTypeObj().isSVLANType()) {
            throw new IncorrectCircuitState("A drop can be added only for circuits in the DISCOVERED, DISCOVERED_TL1, or CREATING states.");
        }
        if (this.inconsistentDropPathProtection(n)) {
            if (this.dbgOn()) {
                db.println("addDrop: ERROR - new drop pathProt != existing drop pathProt");
            }
            throw new SanityCheckFailed("All circuit drops must have matching path protection.");
        }
        if (this.getCircuit().isBidirectional() && !this.getCircuit().getCircuitTypeObj().isSVLANType() && !this.getCircuit().getCircuitTypeObj().isOchncType()) {
            if (this.getCircuit().getCktSources().contains(netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("addDrop: drop same as source");
                }
                throw new SanityCheckFailed("The source and destination are identical.");
            }
            if (n2 == 1 && !this.getCircuit().getCircuitTypeObj().isEthernetCircuitType()) {
                throw new SanityCheckFailed("A drop cannot be added to a discovered bidirectional circuit.");
            }
        }
    }

    private boolean inconsistentDropPathProtection(int n) {
        int n2 = this.getCircuit().getState();
        return n2 == 1 && n != this.getCircuit().getDropPathProtection() || n2 == 5 && !this.getCircuit().isCircuitProtected() && n == 0;
    }

    protected void routeDrop(INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        INetElement iNetElement;
        NetCircuit netCircuit;
        if (this.dbgOn()) {
            db.println("routeDrop called for " + this.getCircuit().getCircuitName() + ". drop = " + ((NetCircuitEnd)iNetCircuitEnd).prettyString());
        }
        if (!(netCircuit = this.getCircuit()).isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        try {
            iNetElement = iNetCircuitEnd.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("i/o exception in routeDrop");
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            iNetElement = null;
        }
        if (iNetElement == null) {
            if (this.dbgOn()) {
                db.println("routeDrop: unable to find NE");
            }
            throw new ObjNotFound("The network element could not be found.");
        }
        if (netCircuit.doesCircuitUseNetElem(iNetElement) && netCircuit.getState() != 0) {
            this.addDrop(iNetCircuitEnd, routePrefs);
            return;
        }
        this.addDrop(iNetCircuitEnd, routePrefs);
        if (!netCircuit.doesCircuitUseNetElem(iNetElement)) {
            throw new ObjNotFound("The circuit node could not be found.");
        }
        try {
            this.routeCurrentDrop(iNetElement, routePrefs, true);
        }
        catch (NoRoute noRoute) {
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            this.deleteDrops(iNetCircuitEnd);
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            this.deleteDrops(iNetCircuitEnd);
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            this.deleteDrops(iNetCircuitEnd);
            throw abstractCmsIOException;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            this.deleteDrops(iNetCircuitEnd);
            throw sanityCheckFailed;
        }
    }

    protected void routeDrop(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        INetElement iNetElement;
        try {
            iNetElement = iNetCircuitEnd2.getNetElement();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            db.println("Unable to find net element for secondary drop");
            throw new ObjNotFound("The network element could not be found.");
        }
        routePrefs.setSecDst(iNetElement);
        try {
            this.routeDrop(iNetCircuitEnd, routePrefs);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            routePrefs.setSecDst(null);
            throw sanityCheckFailed;
        }
        catch (NoRoute noRoute) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            throw abstractCmsIOException;
        }
        this.addDrop(iNetCircuitEnd2, routePrefs);
    }

    protected void deleteDrops(INetCircuitEnd iNetCircuitEnd) throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        block4: {
            try {
                this.deleteDropCktEnd(iNetCircuitEnd);
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception.");
                }
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) break block4;
                db.println("unable to reverse for deleting routed drop encountered exception " + deletionError.getMessage());
            }
        }
    }

    protected int convertPathProt(int n) {
        if (n == 9) {
            return n;
        }
        this.getCircuit();
        int n2 = NetCircuit.isPathFullyProtected(n) ? 0 : 2;
        return n2;
    }

    protected List addDropToCircuitInfo() throws CircuitProvError {
        if (this.dbgOn()) {
            db.println("addDropToCircuitInfo: " + this.getCircuit().getDropsSize() + " drop(s)");
        }
        LinkedList<NetCircuitDropInfo> linkedList = new LinkedList<NetCircuitDropInfo>();
        for (NetCircuitDropInfo netCircuitDropInfo : this.getCircuit().getCktDrops()) {
            if (netCircuitDropInfo.getNetCktEnd().getStage() != 3) continue;
            try {
                this.getCircuit().circuitModel().addDrop(netCircuitDropInfo.getCircuitDropInfo());
                linkedList.add(netCircuitDropInfo);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Unable to modify circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                throw new CircuitProvError("The circuit information could not be modified.");
            }
            catch (OnlyOneDropPerBidirCktAllowed onlyOneDropPerBidirCktAllowed) {
                if (this.dbgOn()) {
                    db.println("Unable to modify circuit info: " + (Object)((Object)onlyOneDropPerBidirCktAllowed));
                }
                throw new CircuitProvError("More than one drop cannot be added to a bidirectional circuit.");
            }
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ICircuitId createCircuitInfo(INodeModel iNodeModel, ICircuitInfo iCircuitInfo) throws CircuitProvError {
        ICircuitId iCircuitId;
        int n = 0;
        if (iCircuitInfo.getSrcPoint() != null && iCircuitInfo.getSrcPoint().getNodeId() != 0) {
            ++n;
        }
        if (iCircuitInfo.getSecSrcPoint() != null && iCircuitInfo.getSecSrcPoint().getNodeId() != 0) {
            ++n;
        }
        if (this.dbgOn()) {
            db.println("createCircuitInfo: " + n + " source(s), " + iCircuitInfo.getDropInfo().length + " drop(s)");
        }
        ICircuitFactoryModel iCircuitFactoryModel = iNodeModel.getCircuitFactoryModel();
        Object object = NetCircuitManager.instance().getMasterCktListLock();
        synchronized (object) {
            ICircuitModel iCircuitModel;
            NetCircuitManager.instance().removeCircuit(this.getCircuit());
            try {
                iCircuitModel = iCircuitFactoryModel.createCircuit(iCircuitInfo);
                this.getCircuit().setCircuitModel(iCircuitModel);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                }
                String string = "The circuit information could not be created.";
                if (cTCUserException instanceof InvalidCircuitName) {
                    string = string + "\nThe circuit name was invalid.";
                }
                throw new CircuitProvError(string);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                if (abstractCmsIOException instanceof CmsNodeUpgradingException) {
                    throw new CircuitProvError(ErrorMsg.getString((EID)CEMC.EID_NODE_UPGRADING_EXCEPTION_PARAM_1, (Object)"Circuit creation"));
                }
                throw new CircuitProvError("Unable to create circuit info due to IO exception");
            }
            this.getCircuit().setCircuitInfoActive();
            this.getCircuit().addCircuitInfoObserver();
            try {
                iCircuitId = iCircuitModel.getId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                this.getCircuit().disposeCircuitInfo(true);
                throw new CircuitProvError("The circuit information could not be found.");
            }
            catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                this.getCircuit().disposeCircuitInfo(true);
                if (this.dbgOn()) {
                    db.println("Unable to get circuit id: " + (Object)((Object)abstractCmsCommFailException));
                }
                throw new CircuitProvError("The circuit ID could not be retrieved.");
            }
            this.getCircuit().updateCircuitId(iCircuitId);
            NetCircuitManager.instance().insertCircuit(this.getCircuit(), false);
        }
        this.checkForDefaultName();
        return iCircuitId;
    }

    protected void checkForDefaultName() throws CircuitProvError {
        String string = this.getCircuit().getCircuitInfo().getCircuitName();
        if (string.equals("")) {
            String string2 = this.deriveDefaultName();
            this.renameCircuit(string2);
        } else if (this.getCircuit().isMonitorCircuit()) {
            String string3;
            String string4 = "_" + this.getCircuit().getCircuitId().getUniquePart().getUniqueId();
            int n = 48;
            if (string.length() + string4.length() > n) {
                String string5 = "_MON";
                int n2 = string.lastIndexOf(string5);
                string3 = n2 >= 0 ? string.substring(0, n2) : string;
                string3 = string3.substring(0, n - string5.length() - string4.length());
                string3 = string3 + string5 + string4;
            } else {
                string3 = string + string4;
            }
            this.renameCircuit(string3);
        }
    }

    protected void createTl1Info() throws CircuitProvError {
        this.getCircuit().updateCircuitId(new CircuitId(0, 0));
        this.getCircuit().setTl1InfoActive();
        NetCircuitManager.instance().insertCircuit(this.getCircuit(), false);
        if (this.getCircuit() instanceof NetVcatCircuit) {
            ((NetVcatCircuit)this.getCircuit()).getCircuitInfo().setVcatRoutingPref(0);
        }
        this.checkForDefaultName();
    }

    protected void renameCircuit(String string) throws CircuitProvError {
        if (!this.getCircuit().isCircuitRefValid()) {
            throw new CircuitProvError("The circuit was already destroyed.");
        }
        ICircuitModel iCircuitModel = this.getCircuit().circuitModel();
        if (iCircuitModel != null) {
            try {
                iCircuitModel.setName(string);
            }
            catch (InvalidCircuitName invalidCircuitName) {
                if (this.dbgOn()) {
                    db.println("rename: Invalid Circuit Name");
                }
                throw new CircuitProvError("The new circuit name could not be provisioned.");
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                throw new CircuitProvError("The circuit could not be renamed.");
            }
        }
        this.getCircuit().setCircuitName(string);
        this.getCircuit().setChanged();
    }

    protected void addOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, CircuitDropOutstanding, ObjNotFound, SanityCheckFailed, IncorrectCircuitState {
    }

    protected void deleteOpenVcatDrops(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, CannotDeleteLastDrop, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
    }

    protected void deleteDropCktEnd(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, ObjNotFound, CannotDeleteLastDrop, IncorrectCircuitState, SanityCheckFailed, DeletionError, AbstractCmsIOException {
    }

    protected void routeDrop(INetCircuitEnd[] iNetCircuitEndArray, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        NetCircuit netCircuit;
        if (this.dbgOn()) {
            db.println("routeDrop called for " + this.getCircuit().getCircuitName() + ". open vcat ");
        }
        if (!(netCircuit = this.getCircuit()).isCircuitRefValid()) {
            throw new IncorrectCircuitState("The circuit was already destroyed.");
        }
        this.checkNEs(iNetCircuitEndArray);
        this.addOpenVcatDrops(iNetCircuitEndArray, routePrefs);
        try {
            this.routeCurrentDrop(null, routePrefs, true);
        }
        catch (NoRoute noRoute) {
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            this.deleteDrops(iNetCircuitEndArray);
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            this.deleteDrops(iNetCircuitEndArray);
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            this.deleteDrops(iNetCircuitEndArray);
            throw abstractCmsIOException;
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            this.deleteDrops(iNetCircuitEndArray);
            throw sanityCheckFailed;
        }
    }

    private void checkNEs(INetCircuitEnd[] iNetCircuitEndArray) throws ObjNotFound {
        INetElement iNetElement = null;
        for (int i = 0; i < iNetCircuitEndArray.length; ++i) {
            try {
                if (iNetCircuitEndArray[i] == null) continue;
                iNetElement = iNetCircuitEndArray[i].getNetElement();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                db.println("i/o exception in routeDrop");
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
                iNetElement = null;
            }
            if (iNetElement != null) continue;
            if (this.dbgOn()) {
                db.println("routeDrop: unable to find NE");
            }
            throw new ObjNotFound("The network element could not be found.");
        }
    }

    protected void deleteDrops(INetCircuitEnd[] iNetCircuitEndArray) throws CircuitDropOutstanding, ObjNotFound, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        block4: {
            try {
                this.deleteDropCktEnd(iNetCircuitEndArray);
            }
            catch (CannotDeleteLastDrop cannotDeleteLastDrop) {
                if (this.dbgOn()) {
                    db.println("Cannot del. last drop: unexpected exception.");
                }
            }
            catch (DeletionError deletionError) {
                if (!this.dbgOn()) break block4;
                db.println("unable to reverse for deleting routed drop encountered exception " + deletionError.getMessage());
            }
        }
    }

    public void routeDrop(INetCircuitEnd[] iNetCircuitEndArray, INetCircuitEnd[] iNetCircuitEndArray2, RoutePrefs routePrefs) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        if (this.dbgOn()) {
            db.println("routeDrop called for " + this.getCircuit().getCircuitName() + ". open vcat ");
        }
        this.checkNEs(iNetCircuitEndArray2);
        try {
            this.routeDrop(iNetCircuitEndArray, routePrefs);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + sanityCheckFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)sanityCheckFailed);
            routePrefs.setSecDst(null);
            throw sanityCheckFailed;
        }
        catch (NoRoute noRoute) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + noRoute.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)noRoute));
            throw noRoute;
        }
        catch (AllocFailed allocFailed) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + allocFailed.getMessage());
            }
            SDebug.printStackTrace((Throwable)((Object)allocFailed));
            throw allocFailed;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.dbgOn()) {
                db.println("unable to route to drop " + abstractCmsIOException.getMessage());
            }
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            throw abstractCmsIOException;
        }
        this.addOpenVcatDrops(iNetCircuitEndArray2, routePrefs);
    }
}

