/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.CircuitType;
import cerent.cms.model.FramingType;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.NetProtectionType;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.PathCost;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.AutoRouteRequestor;
import cerent.cms.route.CircuitPath;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.MemberGroupPrefs;
import cerent.cms.route.MemberPath;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.NoRoute;
import cerent.cms.route.NodeSrg;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.TsiConstraint;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.util.ILabel;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;

public class NetCircuitPath {
    private static final SDebug db = new SDebug("NetCircuitPath");
    protected CircuitPath cp;
    protected NetCircuit circuit;
    protected RoutePrefs prefs;
    private boolean isLoCircuit;

    public NetCircuitPath(RoutePrefs routePrefs, NetCircuit netCircuit) {
        this.prefs = routePrefs;
        this.circuit = netCircuit;
        ICircuitType iCircuitType = CircuitType.getCircuitType((int)routePrefs.getCircuitType());
        this.isLoCircuit = iCircuitType.isLoCircuitType();
        if (netCircuit != null && !iCircuitType.isOchccCircuitType() && !iCircuitType.isSVLANType()) {
            this.computePrefs();
        }
    }

    private void computePrefs() {
        if (this.circuit.isMonitorCircuit()) {
            return;
        }
        this.computeEndPointPrefs();
        this.computeLAPEndPointPrefs();
        this.computeCktExtPrefs();
    }

    private void computeEndPointPrefs() {
        Object object;
        Object object2;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Iterator iterator = this.circuit.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                object2 = (NetCircuitEnd)iterator.next();
                object = this.circuit.net.findNetLinkFromSource(false, ((NetCircuitEnd)object2).getNetElement(), ((NetCircuitEnd)object2).getEntityIndex(), ((NetCircuitEnd)object2).getHoNum());
                if (this.dbgOn()) {
                    this.debug("NetCircuitPath: Finding a link for endpoint: " + ((NetCircuitEnd)object2).prettyString());
                }
                if (object != null) {
                    if (this.dbgOn()) {
                        this.debug("NetCircuitPath: Found the link: " + object.prettyString());
                    }
                    if (object.isLAP()) {
                        if (!this.dbgOn()) continue;
                        this.debug("NetCircuitPath: This is a LAP link, ignore");
                        continue;
                    }
                } else {
                    if (!this.dbgOn()) continue;
                    this.debug("NetCircuitPath: Did not find");
                    continue;
                }
                linkedList.add(object);
            }
            iterator = this.circuit.getDropCktEnds().iterator();
        }
        object2 = this.prefs.getFwdDropPrefs();
        object = ((DropPrefs)object2).getFirstMemberGroupPrefs();
        MemberPrefs memberPrefs = ((MemberGroupPrefs)object).getMemberPrefs();
        memberPrefs.addExcludeLinks(linkedList);
    }

    private void computeLAPEndPointPrefs() {
        Object object;
        Object object2;
        Object object3;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        if (this.dbgOn()) {
            this.debug("NetCircuitPath: computeLAPEndPointPrefs");
        }
        Iterator iterator = this.circuit.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                object3 = (NetCircuitEnd)iterator.next();
                object2 = this.circuit.net.findNetLinkFromSource(false, ((NetCircuitEnd)object3).getNetElement(), ((NetCircuitEnd)object3).getEntityIndex(), ((NetCircuitEnd)object3).getHoNum());
                if (this.dbgOn()) {
                    this.debug("NetCircuitPath: Finding a link for endpoint: " + ((NetCircuitEnd)object3).prettyString());
                }
                if (object2 != null) {
                    if (this.dbgOn()) {
                        this.debug("NetCircuitPath: Found the link: " + object2.prettyString());
                    }
                } else {
                    if (!this.dbgOn()) continue;
                    this.debug("NetCircuitPath: Did not find");
                    continue;
                }
                if (!object2.isLAP()) continue;
                if (object2.getProtectionType() == 4 || object2.getProtectionType() == 0) {
                    object = new TsiConstraint(((NetCircuitEnd)object3).getNetElement(), i == 0 ? object2.originatingRingName() : object2.terminatingRingName(), (ILabel)(this.isLoCircuit ? ((NetCircuitEnd)object3).getHoLoNum() : ((NetCircuitEnd)object3).getHoNum()));
                    if (this.dbgOn()) {
                        this.debug("NetCircuitPath: adding TSI constraint for endpoint: " + ((NetCircuitEnd)object3).prettyString() + ". TSI Cons = " + ((TsiConstraint)object).prettyString() + " for LAP link");
                    }
                    treeSet.add(object);
                    continue;
                }
                object = new TsiConstraint(((NetCircuitEnd)object3).getNetElement(), "", (ILabel)(this.isLoCircuit ? ((NetCircuitEnd)object3).getHoLoNum() : ((NetCircuitEnd)object3).getHoNum()));
                if (this.dbgOn()) {
                    this.debug("NetCircuitPath: adding TSI constraint for endpoint: " + ((NetCircuitEnd)object3).prettyString() + ". TSI Cons = " + ((TsiConstraint)object).prettyString() + " for LAP link");
                }
                treeSet.add(object);
            }
            iterator = this.circuit.getDropCktEnds().iterator();
        }
        object3 = this.prefs.getFwdDropPrefs();
        object2 = ((DropPrefs)object3).getFirstMemberGroupPrefs();
        object = ((MemberGroupPrefs)object2).getMemberPrefs();
        ((MemberPrefs)object).addTsiConstraints(treeSet);
    }

    private void computeBLSREndPointPrefs() {
        Object object;
        Object object2;
        Object object3;
        LinkedList linkedList = new LinkedList();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        Iterator iterator = this.circuit.getCktSources().iterator();
        for (int i = 0; i < 2; ++i) {
            while (iterator.hasNext()) {
                object3 = (NetCircuitEnd)iterator.next();
                object2 = this.circuit.net.findNetLinkFromSource(false, ((NetCircuitEnd)object3).getNetElement(), ((NetCircuitEnd)object3).getEntityIndex(), ((NetCircuitEnd)object3).getHoNum());
                if (this.dbgOn()) {
                    this.debug("NetCircuitPath: Finding a link for endpoint: " + ((NetCircuitEnd)object3).prettyString());
                }
                if (object2 != null) {
                    if (this.dbgOn()) {
                        this.debug("NetCircuitPath: Found the link: " + object2.prettyString());
                    }
                } else {
                    if (!this.dbgOn()) continue;
                    this.debug("NetCircuitPath: Did not find");
                    continue;
                }
                if (object2.getProtectionType() != 4 && object2.getProtectionType() != 0) continue;
                object = new TsiConstraint(((NetCircuitEnd)object3).getNetElement(), i == 0 ? object2.originatingRingName() : object2.terminatingRingName(), (ILabel)(this.isLoCircuit ? ((NetCircuitEnd)object3).getHoLoNum() : ((NetCircuitEnd)object3).getHoNum()));
                if (this.dbgOn()) {
                    this.debug("NetCircuitPath: adding TSI constraint for endpoint: " + ((NetCircuitEnd)object3).prettyString() + ". TSI Cons = " + ((TsiConstraint)object).prettyString());
                }
                treeSet.add(object);
            }
            iterator = this.circuit.getDropCktEnds().iterator();
        }
        object3 = this.prefs.getFwdDropPrefs();
        object2 = ((DropPrefs)object3).getFirstMemberGroupPrefs();
        object = ((MemberGroupPrefs)object2).getMemberPrefs();
        ((MemberPrefs)object).addExcludeLinks(linkedList);
        ((MemberPrefs)object).addTsiConstraints(treeSet);
    }

    private void computeCktExtPrefs() {
        Object object;
        Object object2;
        Object object32;
        if (this.circuit.state != 3) {
            return;
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        for (Object object32 : this.circuit.getCircuitNodes()) {
            object2 = ((NetCircuitNode)object32).getNetElement();
            if (((NetCircuitNode)object32).getState() != 2 && ((NetCircuitNode)object32).getState() != 3) continue;
            object = new NodeSrg((INetElement)object2, 1);
            linkedList.add(object);
        }
        object32 = this.prefs.getFwdDropPrefs();
        object2 = ((DropPrefs)object32).getFirstMemberGroupPrefs();
        object = ((MemberGroupPrefs)object2).getMemberPrefs();
        ((MemberPrefs)object).addSrgs(linkedList);
    }

    protected CircuitPath computeCircuitPath() throws NoRoute, AllocFailed {
        if (this.dbgOn()) {
            this.debug("NetCircuitPath: Invoking the route requestor");
        }
        AutoRouteRequestor autoRouteRequestor = new AutoRouteRequestor(this.prefs);
        this.cp = autoRouteRequestor.getCircuitPath();
        if (this.circuit != null) {
            this.circuit.setTimeSlotViolations(this.cp.getTsViolations());
        }
        if (this.dbgOn()) {
            this.debug("NetCircuitPath: Obtained the following route:");
            this.debug("===========================================");
            this.debug(this.cp.prettyString());
            this.debug("===========================================");
        }
        INetLinkSpan iNetLinkSpan2 = null;
        for (INetLinkSpan iNetLinkSpan2 : this.cp.getBlsrDriSecPathLinks()) {
            iNetLinkSpan2.setSecondaryCircuit(true);
        }
        return this.cp;
    }

    protected LinkedList computePathCosts() {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        if (this.dbgOn()) {
            this.debug("NetCircuitPath: Computing Path Costs");
        }
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList linkedList2 = new LinkedList(this.cp.getDropPath().getMemberPaths());
        int n5 = 0;
        Iterator iterator = linkedList2.iterator();
        while (iterator.hasNext()) {
            Object object2;
            n = 0;
            n2 = 0;
            n3 = 0;
            n4 = 0;
            MemberPath memberPath = (MemberPath)iterator.next();
            ++n5;
            LinkedList linkedList3 = memberPath.getPathSegments();
            for (Object object2 : linkedList3) {
                for (Object object3 : ((PathSegment)object2).getPrimaryLinks()) {
                    n += object3.getCost();
                    ++n3;
                }
                if (((PathSegment)object2).isPathProtected()) {
                    Object object3;
                    object3 = ((PathSegment)object2).getAlternateLinks().iterator();
                    while (object3.hasNext()) {
                        INetLink iNetLink = (INetLink)object3.next();
                        n2 += iNetLink.getCost();
                        ++n4;
                    }
                    continue;
                }
                if (!((PathSegment)object2).isLineProtected()) continue;
                n2 += n;
                n4 += n3;
            }
            object2 = new PathCost();
            ((PathCost)object2).setMemberNumber(n5);
            ((PathCost)object2).setPrimaryCost(n);
            ((PathCost)object2).setPrimaryHops(n3);
            ((PathCost)object2).setAlternateCost(n2);
            ((PathCost)object2).setAlternateHops(n4);
            linkedList.add(object2);
            if (!this.dbgOn()) continue;
            this.debug("NetCircuitPath: Path Costs ");
            this.debug("===========================================");
            this.debug(((PathCost)object2).prettyString());
            this.debug("===========================================");
        }
        return linkedList;
    }

    public LinkedList getAvailSpans() {
        return this.cp.getAvailSpans();
    }

    public LinkedList getLoTunnels(int n, int n2, int n3, int n4, boolean bl, int n5) throws NoRoute {
        boolean bl2 = false;
        LinkedList linkedList = new LinkedList();
        LinkedList linkedList2 = this.cp.getAvailSpans();
        for (PathSegment pathSegment : this.cp.getPathSegments()) {
            try {
                bl2 = pathSegment.getAlternateLinks().size() != 0;
                this.createLoTunnelForPathSegment(n, n2, n3, n4, bl, pathSegment.getPrimaryLinks(), linkedList, linkedList2, bl2, n5);
                if (pathSegment.getAlternateLinks().size() == 0) continue;
                this.createLoTunnelForPathSegment(n, n2, n3, n4, bl, pathSegment.getAlternateLinks(), linkedList, linkedList2, bl2, n5);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    this.debug("Unable to create LO Tunnel");
                }
                for (LoTunnelInfo loTunnelInfo : linkedList) {
                    INetCircuit iNetCircuit = loTunnelInfo.tunnel();
                    try {
                        iNetCircuit.destroyCircuit();
                    }
                    catch (DeletionError deletionError) {
                        if (!this.dbgOn()) continue;
                        this.debug("Unable to cleanup LO Tunnel");
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (!this.dbgOn()) continue;
                        this.debug("Unable to cleanup LO Tunnel");
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!this.dbgOn()) continue;
                        this.debug("Unable to cleanup LO Tunnel");
                    }
                }
                throw new NoRoute("Unable to create the LO Tunnels");
            }
        }
        return linkedList;
    }

    private void createLoTunnelForPathSegment(int n, int n2, int n3, int n4, boolean bl, List list, LinkedList linkedList, LinkedList linkedList2, boolean bl2, int n5) throws CTCUserException {
        INetCircuit iNetCircuit;
        boolean bl3 = false;
        if (this.singleHopOrExistingLotHavingBw(n, n2, n4, list, bl2, n5)) {
            return;
        }
        INetElement iNetElement = ((INetLink)list.get(0)).getSrc();
        INetElement iNetElement2 = ((INetLink)list.get(list.size() - 1)).getDst();
        if (this.dbgOn()) {
            this.debug("Adding LO Tunnel from " + iNetElement.getName() + " to " + iNetElement2.getName() + " to list of tunnels. " + "SLA " + n4);
        }
        if (!PortGrouping.getInstance().isInCreation()) {
            if (!iNetElement.loXCon() || !iNetElement2.loXCon()) {
                if (this.dbgOn()) {
                    this.debug("LO Tunnel end points don't have Low order XC");
                }
                throw new NoRoute("Unable to find acceptable set of LO Tunnels");
            }
            bl3 = false;
            for (INetLink iNetLink : list) {
                if (iNetLink.getSrc().loXCon() && iNetLink.getDst().loXCon()) continue;
                bl3 = true;
                break;
            }
            if (!bl3 && this.dbgOn()) {
                this.debug("LO Tunnel not really required. All nodes have XCLO");
            }
        }
        IFramingType iFramingType = FramingType.getFramingType((int)n3);
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(iFramingType.getTunnelCircuitType(), iFramingType.getLoTunnelSize(), 1, (short)n4);
        circuitCreatInfo.setTL1Compatible(bl);
        try {
            iNetCircuit = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetElement);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                this.debug("Warning! Sanity check failure unexpected");
            }
            if (bl3) {
                throw new NoRoute("Unable to create a required LO Tunnel");
            }
            return;
        }
        LoTunnelInfo loTunnelInfo = new LoTunnelInfo(iNetCircuit, bl3);
        linkedList.add(loTunnelInfo);
        try {
            iNetCircuit.addNetElement(iNetElement2, new RoutePrefs());
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            if (this.dbgOn()) {
                this.debug("Warning! LO Tunnel destroyed during creation");
            }
            if (bl3) {
                throw new NoRoute("Unable to create a required LO Tunnel");
            }
            return;
        }
        for (INetLink iNetLink : list) {
            Iterator iterator = linkedList2.iterator();
            boolean bl4 = false;
            while (iterator.hasNext()) {
                INetLinkSpan iNetLinkSpan = (INetLinkSpan)iterator.next();
                if (!iNetLinkSpan.isRelevantLink(iNetLink)) continue;
                iNetCircuit.addCircuitSpan(iNetLinkSpan);
                iterator.remove();
                bl4 = true;
                break;
            }
            if (bl4) continue;
            throw new NoRoute("Unable to find free HO in span " + iNetLink.prettyString());
        }
    }

    protected boolean singleHopOrExistingLotHavingBw(int n, int n2, int n3, int n4) {
        boolean bl = false;
        for (PathSegment pathSegment : this.cp.getPathSegments()) {
            bl = pathSegment.getAlternateLinks().size() != 0;
            if (!this.singleHopOrExistingLotHavingBw(n, n2, n3, pathSegment.getPrimaryLinks(), bl, n4)) {
                return false;
            }
            if (pathSegment.getAlternateLinks().size() == 0 || this.singleHopOrExistingLotHavingBw(n, n2, n3, pathSegment.getAlternateLinks(), bl, n4)) continue;
            return false;
        }
        return true;
    }

    private boolean singleHopOrExistingLotHavingBw(int n, int n2, int n3, List list, boolean bl, int n4) {
        INetElement iNetElement = ((INetLink)list.get(0)).getSrc();
        INetElement iNetElement2 = ((INetLink)list.get(list.size() - 1)).getDst();
        if (this.dbgOn()) {
            this.debug("Searching for existing LO Tunnel from " + iNetElement.getName() + " to " + iNetElement2.getName() + " for " + n4 + " members");
        }
        if (PortGrouping.getInstance().isInCreation()) {
            return false;
        }
        if (list.size() < 2) {
            if (this.dbgOn()) {
                this.debug("Single hop tunnel - ignoring");
            }
            return true;
        }
        List list2 = NetCircuitManager.instance().findLoTunnels(iNetElement, iNetElement2, true);
        list2 = this.validateTunnels(list2);
        Iterator iterator = list2.iterator();
        if (this.dbgOn()) {
            this.debug(list2.size() + " existing Lo Tunnel(s) found from " + iNetElement.getName() + " to " + iNetElement2.getName());
        }
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            INetLink iNetLink = iNetCircuit.getLotLink();
            if (iNetLink == null) continue;
            boolean bl2 = true;
            if (n3 != 0 && iNetLink.getSla() != null && iNetLink.getSla().shortValue() != 0 && n3 != iNetLink.getSla().shortValue()) continue;
            int n5 = iNetLink.getAllAvailSpans(n, n2).length;
            if (n5 < n4) {
                if (this.dbgOn()) {
                    this.debug("LO Tunnel " + iNetCircuit.getCircuitName() + " does not have enough bandwidth");
                }
                bl2 = false;
            }
            if (!bl2) continue;
            if (this.dbgOn()) {
                this.debug("LO Tunnel " + iNetCircuit.getCircuitName() + " has available spans" + " and pathMatchRqd = " + bl);
            }
            if (!bl) {
                return true;
            }
            boolean bl3 = true;
            for (INetLink iNetLink2 : list) {
                INetLink iNetLink3 = Network.instance().findReverseLink(iNetLink2);
                if (iNetCircuit.doesCircuitUseNetLink(iNetLink2)) continue;
                if (iNetLink3 == null) {
                    bl3 = false;
                    break;
                }
                if (iNetCircuit.doesCircuitUseNetLink(iNetLink3)) continue;
                bl3 = false;
                break;
            }
            if (bl3) {
                return true;
            }
            if (!this.dbgOn()) continue;
            this.debug("duplicate upsr-tunnels do not have a matching path");
        }
        return false;
    }

    public INetCircuit getOchTrailTunnel(int n) throws NoRoute {
        INetCircuit iNetCircuit = null;
        for (PathSegment pathSegment : this.cp.getPathSegments()) {
            try {
                iNetCircuit = this.createOchTrailTunnelForPathSegment(pathSegment.getPrimaryLinks(), n);
            }
            catch (CTCUserException cTCUserException) {
                block11: {
                    if (this.dbgOn()) {
                        this.debug("Unable to create OchTrail Tunnel");
                    }
                    try {
                        if (iNetCircuit != null) {
                            iNetCircuit.destroyCircuit();
                        }
                    }
                    catch (DeletionError deletionError) {
                        if (this.dbgOn()) {
                            this.debug("Unable to cleanup OchTrail Tunnel");
                        }
                    }
                    catch (IncorrectCircuitState incorrectCircuitState) {
                        if (this.dbgOn()) {
                            this.debug("Unable to cleanup OchTrail Tunnel");
                        }
                    }
                    catch (SanityCheckFailed sanityCheckFailed) {
                        if (!this.dbgOn()) break block11;
                        this.debug("Unable to cleanup OchTrail Tunnel");
                    }
                }
                throw new NoRoute("Unable to create the OchTrail Tunnels");
            }
        }
        return iNetCircuit;
    }

    private INetCircuit createOchTrailTunnelForPathSegment(List list, int n) throws CTCUserException {
        INetCircuit iNetCircuit;
        INetElement iNetElement = ((INetLink)list.get(0)).getSrc();
        INetElement iNetElement2 = ((INetLink)list.get(list.size() - 1)).getDst();
        if (this.dbgOn()) {
            this.debug("Adding OchTrail Tunnel from " + iNetElement.getName() + " to " + iNetElement2.getName() + " to list of tunnels. ");
        }
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(15, CircuitSize.SIZE_OCHNC_ENS.getEnum(), 1, false, "", n, false, this.prefs.getcktOptChannel());
        circuitCreatInfo.setSrcTrkPort(this.prefs.getcktSrcEntityIndex());
        try {
            iNetCircuit = NetCircuitFactory.newCircuit(circuitCreatInfo, iNetElement);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            if (this.dbgOn()) {
                this.debug("Warning! Sanity check failure unexpected");
            }
            throw new NoRoute("Unable to create a required OchTrail Tunnel");
        }
        try {
            iNetCircuit.addNetElement(iNetElement2, this.prefs);
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            if (this.dbgOn()) {
                this.debug("Warning! OchTrail Tunnel destroyed during creation");
            }
            throw new NoRoute("Unable to create a required OchTrail Tunnel");
        }
        for (INetLink iNetLink : list) {
            for (INetLinkSpan iNetLinkSpan : this.getAvailSpans()) {
                iNetCircuit.addCircuitSpan(iNetLinkSpan);
            }
        }
        return iNetCircuit;
    }

    private boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    private void debug(String string) {
        db.println(string);
    }

    private List validateTunnels(List linkedList) {
        LinkedList<INetCircuit> linkedList2 = new LinkedList<INetCircuit>();
        for (INetCircuit iNetCircuit : linkedList) {
            INetLink iNetLink = iNetCircuit.getLotLink();
            if (!(iNetLink instanceof NetLink) || this.prefs.getPcaPref() && ((NetLink)iNetLink).inWorkingBLSR() || !this.prefs.getPcaPref() && NetProtectionType.isPcaType(iNetCircuit.getProtType())) continue;
            linkedList2.add(iNetCircuit);
        }
        linkedList = linkedList2;
        return linkedList;
    }
}

