/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitDropInfo;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CktInfo;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitFactoryModel;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.InvalidCircuitName;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.IHoLoNum;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.Set;

public abstract class NetCircuitRepairer {
    private static final SDebug db = new SDebug("NetCircuitRepairer");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected abstract void changeCircuitId(ICircuitId var1);

    protected abstract NetCircuit getCircuit();

    protected abstract Set getAffectedNodes(int var1, int var2);

    protected boolean isRepairable() {
        NetCircuit netCircuit = this.getCircuit();
        if (netCircuit.circuitModel() == null) {
            if (NetCircuitRepairer.dbgOn()) {
                db.println("Circuit Model does not exist. It cannot be repaired");
            }
            return false;
        }
        return !NetCircuit.isNullCircuitId(netCircuit.getCircuitId());
    }

    protected void setCktIdOnNCN(String string, int n, String string2) {
        NetCircuit netCircuit = this.getCircuit();
        int n2 = Network.instance().findNetElemByIp(string).getNodeId();
        CircuitId circuitId = new CircuitId(n2, n);
        int n3 = Network.instance().findNetElemByIp(string2).getNodeId();
        this.setCktId(circuitId, n3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void fixTunnelCircuit(String string, int n) {
        NetCircuit netCircuit = this.getCircuit();
        int n2 = Network.instance().findNetElemByIp(string).getNodeId();
        CircuitId circuitId = new CircuitId(n2, n);
        NetCircuit netCircuit2 = netCircuit;
        synchronized (netCircuit2) {
            if (NetCircuitRepairer.dbgOn()) {
                db.println("repairTunnelCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(circuitId) + ")");
            }
            this.changeCircuitId(circuitId);
        }
    }

    protected void setCktId(ICircuitId iCircuitId, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean fixCircuit() throws CircuitProvError {
        NetCircuit netCircuit = this.getCircuit();
        ICircuitId iCircuitId = netCircuit.getCircuitId();
        NetCircuit netCircuit2 = netCircuit;
        synchronized (netCircuit2) {
            ICircuitId iCircuitId2;
            ICircuitModel iCircuitModel;
            if (NetCircuitRepairer.dbgOn()) {
                db.println("repairTunnelCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + ")");
            }
            CktInfo cktInfo = new CktInfo();
            Iterator iterator = netCircuit.getCktSources().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator.next();
                if (n == 0) {
                    cktInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
                    ++n;
                    continue;
                }
                if (n != true) continue;
                cktInfo.setSecSrcPoint(netCircuitEnd.getCircuitEnd());
                break;
            }
            if (cktInfo.getSecSrcPoint() == null) {
                cktInfo.setSecSrcPoint(netCircuit.createNullCircuitEnd());
            }
            ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[netCircuit.getDropsSize()];
            iterator = netCircuit.getCktDrops().iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                NetCircuitDropInfo netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                iCircuitDropInfoArray[n2++] = netCircuitDropInfo.getCircuitDropInfo();
            }
            cktInfo.setDropInfo(iCircuitDropInfoArray);
            VlanSetManager.instance();
            cktInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(netCircuit.getVlans()));
            cktInfo.setMonitor(netCircuit.isMonitorCircuit());
            cktInfo.setCircuitSize(netCircuit.getCircuitSize());
            cktInfo.setCircuitType(netCircuit.getCircuitType());
            cktInfo.setDir(netCircuit.getCircuitDir());
            cktInfo.setCircuitName(netCircuit.getCircuitName());
            cktInfo.setSla(netCircuit.getSla());
            if (NetCircuitRepairer.dbgOn()) {
                db.println("repairTunnelCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + "): " + "Creating new circuit");
            }
            ICircuitFactoryModel iCircuitFactoryModel = netCircuit.getSrcNodeModel().getCircuitFactoryModel();
            try {
                iCircuitModel = iCircuitFactoryModel.createCircuit((ICircuitInfo)cktInfo);
            }
            catch (CTCUserException cTCUserException) {
                if (NetCircuitRepairer.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                }
                String string = "New circuit information could not be created.";
                if (cTCUserException instanceof InvalidCircuitName) {
                    string = string + "\nThe circuit name is invalid.";
                }
                throw new CircuitProvError(string);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCircuitRepairer.dbgOn()) {
                    db.println("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                }
                if (abstractCmsIOException instanceof CmsNodeUpgradingException) {
                    throw new CircuitProvError(ErrorMsg.getString((EID)CEMC.EID_NODE_UPGRADING_EXCEPTION_PARAM_1, (Object)"Circuit repair"));
                }
                throw new CircuitProvError("Unable to create new circuit info due to IO exception");
            }
            try {
                iCircuitId2 = iCircuitModel.getId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (NetCircuitRepairer.dbgOn()) {
                    db.println("New CircuitModel disappeared");
                }
                throw new CircuitProvError("The new circuit model does not exist.");
            }
            if (NetCircuitRepairer.dbgOn()) {
                db.println("repairTunnelCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + ")" + ": New Id = " + NetCircuit.prettyString(iCircuitId2) + "; Changing circuit ID on connections");
            }
            this.changeCircuitId(iCircuitId2);
            try {
                netCircuit.deleteCircuitModel();
            }
            catch (DeletionError deletionError) {
                throw new CircuitProvError("The circuit could only be partially repaired. " + deletionError.getMessage());
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean repairCircuit(int n, int n2) throws CircuitProvError {
        INetElement iNetElement = Network.instance().findNetElem(n2);
        INodeModel iNodeModel = iNetElement == null ? null : iNetElement.getNodeModel();
        NetCircuit netCircuit = this.getCircuit();
        ICircuitId iCircuitId = netCircuit.getCircuitId();
        NetCircuit netCircuit2 = netCircuit;
        synchronized (netCircuit2) {
            if (NetCircuitRepairer.dbgOn()) {
                db.println("repairCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + ")");
            }
            if (!this.isRepairable()) {
                return false;
            }
            if (iCircuitId.getNodeId() == n) {
                ICircuitId iCircuitId2;
                ICircuitModel iCircuitModel;
                for (NetCircuitEnd netCircuitEnd : netCircuit.getCktSources()) {
                    netCircuitEnd.setNode(n2);
                }
                for (NetCircuitDropInfo netCircuitDropInfo : netCircuit.getCktDrops()) {
                    if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
                    netCircuitDropInfo.getNetCktEnd().setNode(n2);
                }
                CktInfo cktInfo = new CktInfo();
                Iterator iterator = netCircuit.getCktSources().iterator();
                int n3 = 0;
                while (iterator.hasNext()) {
                    NetCircuitEnd netCircuitEnd;
                    netCircuitEnd = (NetCircuitEnd)iterator.next();
                    if (n3 == 0) {
                        cktInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
                        ++n3;
                        continue;
                    }
                    if (n3 != true) continue;
                    cktInfo.setSecSrcPoint(netCircuitEnd.getCircuitEnd());
                    break;
                }
                if (cktInfo.getSecSrcPoint() == null) {
                    cktInfo.setSecSrcPoint(netCircuit.createNullCircuitEnd());
                }
                ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[netCircuit.getDropsSize()];
                iterator = netCircuit.getCktDrops().iterator();
                int n4 = 0;
                while (iterator.hasNext()) {
                    NetCircuitDropInfo netCircuitDropInfo;
                    netCircuitDropInfo = (NetCircuitDropInfo)iterator.next();
                    iCircuitDropInfoArray[n4++] = netCircuitDropInfo.getCircuitDropInfo();
                }
                cktInfo.setDropInfo(iCircuitDropInfoArray);
                VlanSetManager.instance();
                cktInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(netCircuit.getVlans()));
                cktInfo.setMonitor(netCircuit.isMonitorCircuit());
                cktInfo.setCircuitSize(netCircuit.getCircuitSize());
                cktInfo.setCircuitType(netCircuit.getCircuitType());
                cktInfo.setDir(netCircuit.getCircuitDir());
                cktInfo.setCircuitName(netCircuit.getCircuitName());
                cktInfo.setSla(netCircuit.getSla());
                if (NetCircuitRepairer.dbgOn()) {
                    db.println("repairCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + "): " + "Creating new circuit");
                }
                ICircuitFactoryModel iCircuitFactoryModel = netCircuit.getSrcNodeModel().getCircuitFactoryModel();
                try {
                    iCircuitModel = iCircuitFactoryModel.createCircuit((ICircuitInfo)cktInfo);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitRepairer.dbgOn()) {
                        db.println("Unable to create circuit info: " + (Object)((Object)cTCUserException));
                    }
                    String string = "New circuit information could not be created.";
                    if (cTCUserException instanceof InvalidCircuitName) {
                        string = string + "\nThe circuit name is invalid.";
                    }
                    throw new CircuitProvError(string);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (NetCircuitRepairer.dbgOn()) {
                        db.println("Unable to create circuit info: " + (Object)((Object)abstractCmsIOException));
                    }
                    if (abstractCmsIOException instanceof CmsNodeUpgradingException) {
                        throw new CircuitProvError(ErrorMsg.getString((EID)CEMC.EID_NODE_UPGRADING_EXCEPTION_PARAM_1, (Object)"Circuit repair"));
                    }
                    throw new CircuitProvError("Unable to create new circuit info due to IO exception");
                }
                try {
                    iCircuitId2 = iCircuitModel.getId();
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (NetCircuitRepairer.dbgOn()) {
                        db.println("New CircuitModel disappeared");
                    }
                    throw new CircuitProvError("The new circuit model does not exist.");
                }
                if (NetCircuitRepairer.dbgOn()) {
                    db.println("repairCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + ")" + ": New Id = " + NetCircuit.prettyString(iCircuitId2) + "; Changing circuit ID on connections");
                }
                this.changeCircuitId(iCircuitId2);
                try {
                    netCircuit.deleteCircuitModel();
                }
                catch (DeletionError deletionError) {
                    throw new CircuitProvError("The circuit could only be partially repaired. " + deletionError.getMessage());
                }
                return true;
            }
            boolean bl = false;
            if (NetCircuitRepairer.dbgOn()) {
                db.println("repairCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + ")" + ": Checking drops to see if they have to old NodeId");
            }
            for (NetCircuitDropInfo netCircuitDropInfo : netCircuit.getCktDrops()) {
                if (netCircuitDropInfo.getNetCktEnd().getCircuitEnd().getNodeId() != n) continue;
                ICircuitEnd iCircuitEnd = netCircuitDropInfo.getNetCktEnd().getCircuitEnd();
                IHoLoNum iHoLoNum = iCircuitEnd.getHoLoNum();
                CircuitEnd circuitEnd = new CircuitEnd(n2, iCircuitEnd.getPortNum(), iHoLoNum.getHoNum(), iHoLoNum.getLoNum(), iCircuitEnd.getDropProt(), iCircuitEnd.getPathIdentifier());
                CircuitDropInfo circuitDropInfo = new CircuitDropInfo();
                circuitDropInfo.setDropPoint(circuitEnd);
                circuitDropInfo.setPathProt(netCircuitDropInfo.getPathProt());
                try {
                    if (NetCircuitRepairer.dbgOn()) {
                        db.println("repairCircuit(" + netCircuit.getCircuitName() + ", " + NetCircuit.prettyString(iCircuitId) + ")" + ": Modifying drop in circuitModel");
                    }
                    netCircuit.circuitModel().addDrop((ICircuitDropInfo)circuitDropInfo);
                    netCircuit.circuitModel().delDrop(iCircuitEnd);
                }
                catch (CTCUserException cTCUserException) {
                    if (NetCircuitRepairer.dbgOn()) {
                        db.println(" repairCircuit - unexpected exception " + (Object)((Object)cTCUserException));
                    }
                    throw new CircuitProvError("The drop could not be added to/deleted from the circuit.");
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (NetCircuitRepairer.dbgOn()) {
                        db.println("repairCircuit - " + (Object)((Object)abstractCmsIOException));
                    }
                    if (abstractCmsIOException instanceof CmsNodeUpgradingException) {
                        throw new CircuitProvError(ErrorMsg.getString((EID)CEMC.EID_NODE_UPGRADING_EXCEPTION_PARAM_1, (Object)"Circuit repair"));
                    }
                    throw new CircuitProvError("Unable to add/delete drop into circuit due to IO exception");
                }
                bl = true;
            }
            return bl;
        }
    }
}

