/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AllocFailed;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.IRollModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitDropOutstanding;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCcatCircuitOperator;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.RouteValidator;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetLinkComparator;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class NetCircuitRollOperator
implements IObserver {
    private NetCcatCircuit circuit;
    private int circuitState;
    private static final SDebug db = new SDebug("NetCircuitRollOperator");

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected NetCircuitRollOperator(NetCcatCircuit netCcatCircuit) {
        this.circuit = netCcatCircuit;
        this.circuitState = netCcatCircuit.getState();
        netCcatCircuit.addObserver(this);
    }

    protected List findRouteForBridgeRoll(RoutePrefs routePrefs, boolean bl) throws AllocFailed, ObjNotFound, NoRoute, CircuitDropOutstanding, IncorrectCircuitState, SanityCheckFailed, AbstractCmsIOException {
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("findRouteForBridgeRoll called for " + this.circuit.getCircuitName());
        }
        if (!this.circuit.isCircuitRefValid()) {
            throw new IncorrectCircuitState("Circuit already destroyed");
        }
        routePrefs.setCircuitSize(this.circuit.getCircuitSize());
        routePrefs.setCircuitType(this.circuit.getCircuitType());
        routePrefs.setPathOnly(false);
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        if (bl) {
            routePrefs2.setPathProt(3);
        } else if (routePrefs.getPathProt() == 0) {
            routePrefs2.setPathProt(7);
        }
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs2, this.circuit);
        netCircuitPath.computeCircuitPath();
        return netCircuitPath.getAvailSpans();
    }

    protected static boolean isOldRouteUPSR(List list) {
        boolean bl = false;
        for (NetCircuitSpan netCircuitSpan : list) {
            if (netCircuitSpan.getProtectionType() == 13 || netCircuitSpan.getProtectionType() == 18 && netCircuitSpan.getLink().getProtectionType() == 3) {
                bl = true;
                continue;
            }
            bl = false;
            break;
        }
        return bl;
    }

    private boolean canNodeBeRemoved(NetCircuitNode netCircuitNode, List list) {
        List list2 = netCircuitNode.getAllSpansList();
        Iterator iterator = list2.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            if (list.contains(netCircuitSpan)) continue;
            bl = false;
            break;
        }
        return bl;
    }

    protected void getNodeAndSpanListWithCktEnd(INetCircuitEnd iNetCircuitEnd, INetCircuitEnd iNetCircuitEnd2, List list, List list2) {
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("getNodeAndSpanListWithCktEnd with fromEnd: " + ((NetCircuitEnd)iNetCircuitEnd).prettyString() + " toEnd: " + (iNetCircuitEnd2 == null ? " " : ((NetCircuitEnd)iNetCircuitEnd2).prettyString()));
        }
        if (this.circuit.isSource((NetCircuitEnd)iNetCircuitEnd) || this.circuit.isDrop((NetCircuitEnd)iNetCircuitEnd)) {
            return;
        }
        INetLink iNetLink = null;
        INetLink iNetLink2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        Network network = Network.instance();
        iNetLink = network.findNetLinkFromSourceCktEnd(this.circuit.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd.getNetElement(), iNetCircuitEnd.getEntityIndex(), iNetCircuitEnd.getHoNum(), iNetCircuitEnd.getLoNum());
        if (iNetLink == null) {
            return;
        }
        bl = this.circuit.doesCircuitUseNetLink(iNetLink);
        if (!bl) {
            iNetLink = iNetLink.getReverseLink();
            bl = this.circuit.doesCircuitUseNetLink(iNetLink);
            bl3 = true;
        }
        if (iNetCircuitEnd2 == null) {
            if (bl) {
                this.circuit.getOrderedNodeAndSpanList(iNetLink, null, list, list2);
            }
            return;
        }
        iNetLink2 = network.findNetLinkFromDestinationCktEnd(this.circuit.getCircuitTypeObj().isLoCircuitType(), iNetCircuitEnd2.getNetElement(), iNetCircuitEnd2.getEntityIndex(), iNetCircuitEnd2.getHoNum(), iNetCircuitEnd2.getLoNum());
        if (iNetLink2 == null) {
            return;
        }
        bl2 = this.circuit.doesCircuitUseNetLink(iNetLink2);
        if (!bl2) {
            iNetLink2 = iNetLink2.getReverseLink();
            bl2 = this.circuit.doesCircuitUseNetLink(iNetLink2);
            bl4 = true;
        }
        if (bl && bl2) {
            if (bl3 && bl4) {
                this.circuit.getOrderedNodeAndSpanList(iNetLink2, iNetLink, list, list2);
            } else {
                this.circuit.getOrderedNodeAndSpanList(iNetLink, iNetLink2, list, list2);
            }
            if (list2.isEmpty()) {
                return;
            }
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)list2.get(0);
            NetCircuitSpan netCircuitSpan2 = (NetCircuitSpan)list2.get(list2.size() - 1);
            INetElement iNetElement = netCircuitSpan.getLink().getSrc();
            NetCircuitEnd netCircuitEnd = new NetCircuitEnd(iNetElement.getNodeId(), netCircuitSpan.getEntityIndex(iNetElement), netCircuitSpan.getHoNum(iNetElement), netCircuitSpan.getLoNum(), false);
            INetElement iNetElement2 = netCircuitSpan2.getLink().getDst();
            NetCircuitEnd netCircuitEnd2 = new NetCircuitEnd(iNetElement2.getNodeId(), netCircuitSpan2.getEntityIndex(iNetElement2), netCircuitSpan2.getHoNum(iNetElement2), netCircuitSpan2.getLoNum(), false);
            if (bl3 && bl4) {
                if (!netCircuitEnd.equals(iNetCircuitEnd2) || !netCircuitEnd2.equals(iNetCircuitEnd)) {
                    list.clear();
                    list2.clear();
                }
            } else if (!netCircuitEnd.equals(iNetCircuitEnd) || !netCircuitEnd2.equals(iNetCircuitEnd2)) {
                list.clear();
                list2.clear();
            }
        }
    }

    protected LinkedList sanityCheckBridgeRollSRGs(List list) throws SanityCheckFailed {
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("calling sanityCheckBridgeRollSRGs");
        }
        LinkedList linkedList = new LinkedList();
        if (!this.circuit.isCircuitRefValid()) {
            throw new SanityCheckFailed("Circuit already destroyed");
        }
        linkedList = RouteValidator.instance().getSrgFailureList(list);
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("sanityCheckSRGs got " + linkedList.size() + " violations");
        }
        return linkedList;
    }

    protected void sanityCheckBridgeRollRouting(List list, List list2, List list3, RoutePrefs routePrefs) throws SanityCheckFailed {
        Object object2;
        if (!NetCircuitRollOperator.routeEqual(this.circuit.getCircuitSpanMap(), list)) {
            if (NetCircuitRollOperator.dbgOn()) {
                db.println("calling sanityCheckBridgeRollRouting");
            }
            if (!this.circuit.isCircuitRefValid()) {
                throw new SanityCheckFailed("Circuit already destroyed");
            }
            this.circuit.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
            Map map = Collections.synchronizedMap(new TreeMap(new NetElemComparator()));
            for (CmsObservable cmsObservable : list3) {
                LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
                linkedList.add((NetCircuitNode)cmsObservable);
                map.put(((NetCircuitNode)cmsObservable).getNetElement(), linkedList);
            }
            this.circuit.sanityCheckBlsrDri(map);
            RouteValidator.instance().validateRoute(this.circuit, list2, list3, this.circuit.getMemberPrefs());
            if (this.circuit.isMemberOfVcat()) {
                this.circuit.getVcatGroup().sanityCheckVcatRoutingPref(this.circuit, list2);
            }
            if (this.circuit.getMemberPrefs().getPathProtection() == 0 && this.circuit.getProtType() == 0) {
                for (CmsObservable cmsObservable : list2) {
                    if (NetProtectionType.isProtectedType(((NetCircuitSpan)cmsObservable).getProtectionType())) continue;
                    throw new SanityCheckFailed("Path specified is not protected. Check span " + ((NetCircuitSpan)cmsObservable).getLink().prettyString());
                }
            }
            return;
        }
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("calling sanityCheckBridgeRollRouting on end-to-end circuit roll");
        }
        CircuitCreatInfo circuitCreatInfo = new CircuitCreatInfo(this.circuit.getCircuitType(), this.circuit.getCircuitSize(), this.circuit.getCircuitDir());
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)NetCircuitFactory.newCircuit(circuitCreatInfo, this.circuit.getPrimarySource());
        try {
            netCcatCircuit.addDrop(this.circuit.getPrimaryDrop(), routePrefs);
        }
        catch (Exception exception) {
            if (NetCircuitRollOperator.dbgOn()) {
                db.println("sanityCheckBridgeRollRouting: clone a new circuit hits exception when adding drop");
            }
            throw new SanityCheckFailed("clone a new circuit on adding drop failed");
        }
        for (Object object2 : list2) {
            netCcatCircuit.insertCktSpan((NetCircuitSpan)object2);
            ((NetCircuitSpan)object2).setCircuit(netCcatCircuit);
        }
        for (Object object2 : list3) {
            netCcatCircuit.insertCktNode((NetCircuitNode)object2, false);
            ((NetCircuitNode)object2).setCircuit(netCcatCircuit);
        }
        netCcatCircuit.setMemberPrefs(routePrefs.getFwdDropPrefs().getFirstMemberGroupPrefs().getMemberPrefs());
        ((NetCcatCircuitOperator)netCcatCircuit.getOperator()).sanityCheckBlsrDriHandoffs();
        for (Object object2 : list3) {
            int n = ((NetCircuitNode)object2).getOperator().sanityCheckGetConnType();
            ((NetCircuitNode)object2).setConnectionType(n);
            ((NetCircuitNode)object2).setupConnListOnCreation(n);
        }
        for (Object object2 : list3) {
            ((NetCircuitNode)object2).findUpsrHeads();
        }
        object2 = new TreeMap(new NetElemComparator());
        for (NetCircuitNode netCircuitNode : list3) {
            LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
            linkedList.add(netCircuitNode);
            object2.put(netCircuitNode.getNetElement(), linkedList);
        }
        netCcatCircuit.sanityCheckBlsrDri((Map)object2);
        RouteValidator.instance().validateRoute(netCcatCircuit, list2, list3, this.circuit.getMemberPrefs());
        if (this.circuit.isMemberOfVcat()) {
            this.circuit.getVcatGroup().sanityCheckVcatRoutingPref(netCcatCircuit, list2);
        }
        netCcatCircuit.sanityCheck();
    }

    private void consolidateOldAndNewNode(NetCircuitNode netCircuitNode, HashMap hashMap, NetCircuitNode netCircuitNode2) {
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("consolidateOldAndNewNode, oldNode = " + netCircuitNode.getName() + " newNode = " + netCircuitNode2.getName());
        }
        HashMap hashMap2 = netCircuitNode.getAllSpans();
        for (NetCircuitSpan netCircuitSpan : hashMap2.keySet()) {
            if (hashMap.containsKey(netCircuitSpan.getLink())) continue;
            if (netCircuitSpan.getOmni()) {
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                continue;
            }
            if (!this.circuit.isBidirectional() && !NetCircuitRollOperator.isDriSpan(netCircuitNode, netCircuitSpan) && (eSpanDirection)hashMap2.get(netCircuitSpan) == eSpanDirection.BIDIRECTIONAL) {
                if (netCircuitSpan.getLink().getDst() == netCircuitNode.getNetElement()) {
                    netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.TERMINATING);
                    continue;
                }
                netCircuitNode2.addRoutedSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
                continue;
            }
            netCircuitNode2.addRoutedSpan(netCircuitSpan, (eSpanDirection)hashMap2.get(netCircuitSpan));
        }
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("old node has num of inSpans " + netCircuitNode.getInSpans().size());
            db.println("new node has total num of inSpans " + netCircuitNode2.getInSpans().size());
            db.println("old node has num of outSpans " + netCircuitNode.getOutSpans().size());
            db.println("new node has total num of outSpans " + netCircuitNode2.getOutSpans().size());
            db.println("old node has num of biSpans " + netCircuitNode.getBiSpans().size());
            db.println("new node has total num of biSpans " + netCircuitNode2.getBiSpans().size());
        }
    }

    protected void getNewSpanAndNodeList(List list, List list2, List list3, List list4) {
        NetCircuitNode netCircuitNode;
        NetCircuitNode netCircuitNode22;
        Iterator<Object> iterator;
        Object object3;
        Object object2;
        if (NetCircuitRollOperator.dbgOn()) {
            int n;
            db.println("calling getNewSpanAndNodeList with newRoute and oldRoute");
            db.println("new route contains following spans : ");
            for (n = 0; n < list.size(); ++n) {
                object2 = (NetCircuitSpan)list.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)object2).prettyString());
            }
            db.println("old route contains following spans : ");
            for (n = 0; n < list2.size(); ++n) {
                object2 = (NetCircuitSpan)list2.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)object2).prettyString());
            }
        }
        HashMap<INetLink, NetCircuitSpan> hashMap = new HashMap<INetLink, NetCircuitSpan>();
        object2 = new HashMap();
        NetCircuitNode netCircuitNode3 = null;
        NetCircuitNode netCircuitNode4 = null;
        NetCircuitSpan netCircuitSpan2 = null;
        INetLink iNetLink = null;
        for (NetCircuitSpan netCircuitSpan2 : list) {
            iNetLink = netCircuitSpan2.getLink();
            netCircuitSpan2.setSrcState(2);
            netCircuitSpan2.setDstState(2);
            netCircuitNode3 = (NetCircuitNode)((HashMap)object2).get(iNetLink.getSrc());
            if (netCircuitNode3 == null) {
                netCircuitNode3 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getSrc(), this.circuit);
                ((HashMap)object2).put(iNetLink.getSrc(), netCircuitNode3);
            }
            if ((netCircuitNode4 = (NetCircuitNode)((HashMap)object2).get(iNetLink.getDst())) == null) {
                netCircuitNode4 = NetCircuitNodeFactory.newNodeForAddSpan(iNetLink.getDst(), this.circuit);
                ((HashMap)object2).put(iNetLink.getDst(), netCircuitNode4);
            }
            if (!this.circuit.isBidirectional()) {
                if (netCircuitSpan2.getOmni()) {
                    netCircuitNode3.addRoutedSpan(netCircuitSpan2, eSpanDirection.BIDIRECTIONAL);
                    netCircuitNode4.addRoutedSpan(netCircuitSpan2, eSpanDirection.BIDIRECTIONAL);
                } else {
                    netCircuitNode3.addRoutedSpan(netCircuitSpan2, eSpanDirection.ORIGINATING);
                    netCircuitNode4.addRoutedSpan(netCircuitSpan2, eSpanDirection.TERMINATING);
                }
            } else {
                netCircuitNode3.addRoutedSpan(netCircuitSpan2, eSpanDirection.BIDIRECTIONAL);
                netCircuitNode4.addRoutedSpan(netCircuitSpan2, eSpanDirection.BIDIRECTIONAL);
            }
            hashMap.put(iNetLink, netCircuitSpan2);
        }
        HashMap<INetLink, NetCircuitSpan> hashMap2 = new HashMap<INetLink, NetCircuitSpan>();
        HashMap<INetElement, INetCircuitNode> hashMap3 = new HashMap<INetElement, INetCircuitNode>();
        NetCircuitNode netCircuitNode5 = null;
        NetCircuitNode netCircuitNode6 = null;
        NetCircuitSpan netCircuitSpan32 = null;
        for (NetCircuitSpan netCircuitSpan32 : list2) {
            iNetLink = netCircuitSpan32.getLink();
            netCircuitNode5 = (NetCircuitNode)hashMap3.get(iNetLink.getSrc());
            if (netCircuitNode5 == null) {
                hashMap3.put(iNetLink.getSrc(), netCircuitSpan32.getSrcNCN());
            }
            if ((netCircuitNode6 = (NetCircuitNode)hashMap3.get(iNetLink.getDst())) == null) {
                hashMap3.put(iNetLink.getDst(), netCircuitSpan32.getDstNCN());
            }
            hashMap2.put(iNetLink, netCircuitSpan32);
        }
        List list5 = this.circuit.getCircuitSpans();
        Iterator<Object> iterator2 = list5.iterator();
        while (iterator2.hasNext()) {
            object3 = (NetCircuitSpan)iterator2.next();
            if (!list2.contains(object3)) continue;
            iterator2.remove();
        }
        for (Object object3 : list5) {
            if (NetCircuitRollOperator.dbgOn()) {
                db.println("remaining span " + ((NetCircuitSpan)object3).prettyString() + " is added to spanlist");
            }
            iterator = NetCircuitSpanFactory.createCircuitSpan(this.circuit, (NetLinkSpan)((NetCircuitSpan)object3).getNetLinkSpan(), ((NetCircuitSpan)object3).getSrcNCN(), ((NetCircuitSpan)object3).getDstNCN());
            netCircuitNode22 = (NetCircuitNode)((NetCircuitSpan)object3).getSrcNCN();
            netCircuitNode = (NetCircuitNode)((NetCircuitSpan)object3).getDstNCN();
            if (((NetCircuitSpan)object3).getLink().getProtectionType() == 3 && (netCircuitNode22.getDri() && NetCircuitRollOperator.isDriSpan(netCircuitNode22, (NetCircuitSpan)object3) || netCircuitNode.getDri() && NetCircuitRollOperator.isDriSpan(netCircuitNode, (NetCircuitSpan)object3))) {
                if (NetCircuitRollOperator.dbgOn()) {
                    db.println("set span " + ((NetCircuitSpan)object3).prettyString() + " as omni");
                }
                ((NetCircuitSpan)object3).getNetLinkSpan().setOmni(true);
            }
            ((NetCircuitSpan)((Object)iterator)).setUpsrLink(((NetCircuitSpan)object3).getUpsrLink());
            ((NetCircuitSpan)((Object)iterator)).setSrcState(2);
            ((NetCircuitSpan)((Object)iterator)).setDstState(2);
            list3.add(iterator);
        }
        for (Object object3 : hashMap.values()) {
            if (NetCircuitRollOperator.dbgOn()) {
                db.println("new span " + ((NetCircuitSpan)object3).prettyString() + " is added to spanlist");
            }
            list3.add(object3);
        }
        object3 = this.circuit.getCircuitNodes();
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            netCircuitNode22 = (NetCircuitNode)iterator.next();
            if (!this.canNodeBeRemoved(netCircuitNode22, list2)) continue;
            iterator.remove();
        }
        iterator = object3.iterator();
        while (iterator.hasNext()) {
            netCircuitNode22 = (NetCircuitNode)iterator.next();
            netCircuitNode = (NetCircuitNode)((HashMap)object2).get(netCircuitNode22.getNetElement());
            if (netCircuitNode != null) {
                this.consolidateOldAndNewNode(netCircuitNode22, hashMap2, netCircuitNode);
                continue;
            }
            if (NetCircuitRollOperator.dbgOn()) {
                db.println("orig node " + netCircuitNode22.getName() + " is added to nodelist");
            }
            list4.add(netCircuitNode22);
        }
        for (NetCircuitNode netCircuitNode22 : ((HashMap)object2).values()) {
            netCircuitNode = (NetCircuitNode)hashMap3.get(netCircuitNode22.getNetElement());
            if (netCircuitNode != null) {
                for (NetCircuitEnd netCircuitEnd : netCircuitNode.getSources()) {
                    netCircuitNode22.insertSource(netCircuitEnd);
                }
                for (NetCircuitEnd netCircuitEnd : netCircuitNode.getDrops()) {
                    netCircuitNode22.insertDrop(netCircuitEnd);
                }
            }
            if (NetCircuitRollOperator.dbgOn()) {
                db.println("new node " + netCircuitNode22.getName() + " is added to nodelist");
            }
            list4.add(netCircuitNode22);
        }
    }

    protected static boolean routeEqual(Map map, List list) {
        Iterator iterator = list.iterator();
        TreeMap<INetLink, NetCircuitSpan> treeMap = new TreeMap<INetLink, NetCircuitSpan>(new NetLinkComparator());
        while (iterator.hasNext()) {
            NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator.next();
            treeMap.put(netCircuitSpan.getLink(), netCircuitSpan);
        }
        return ((Object)treeMap).equals(map);
    }

    protected List getDriNodes(List list, List list2) {
        Object object2;
        LinkedList<INetElement> linkedList = new LinkedList<INetElement>();
        Iterator iterator = list.iterator();
        boolean bl = false;
        boolean bl2 = false;
        while (iterator.hasNext()) {
            object2 = (NetCircuitNode)iterator.next();
            if (!((NetCircuitNode)object2).getDri() || ((NetCircuitNode)object2).getDriNodeTypeFromModelLayer() != 1) continue;
            linkedList.add(((NetCircuitNode)object2).getNetElement());
        }
        if (linkedList.isEmpty()) {
            return linkedList;
        }
        if (linkedList.size() == 1) {
            for (Object object2 : list) {
                if (!((NetCircuitNode)object2).getDri() || ((NetCircuitNode)object2).getDriNodeTypeFromModelLayer() != 2) continue;
                linkedList.add(((NetCircuitNode)object2).getNetElement());
                break;
            }
        } else if (linkedList.size() == 2) {
            object2 = "";
            INetElement iNetElement = (INetElement)linkedList.get(0);
            for (CmsObservable cmsObservable : list2) {
                if (((NetCircuitSpan)cmsObservable).getLink().getDst() != iNetElement || !((NetCircuitSpan)cmsObservable).getLink().inBLSR()) continue;
                object2 = ((NetCircuitSpan)cmsObservable).getLink().blsrRingName();
                break;
            }
            for (CmsObservable cmsObservable : list) {
                if (!((NetCircuitNode)cmsObservable).getDri() || ((NetCircuitNode)cmsObservable).getDriNodeTypeFromModelLayer() != 2) continue;
                boolean bl3 = false;
                for (NetCircuitSpan netCircuitSpan : ((NetCircuitNode)cmsObservable).getAllSpansList()) {
                    if (!netCircuitSpan.getLink().inBLSR() || !netCircuitSpan.getLink().blsrRingName().equals(object2)) continue;
                    bl3 = true;
                    break;
                }
                if (bl3) {
                    linkedList.add(1, ((NetCircuitNode)cmsObservable).getNetElement());
                    continue;
                }
                linkedList.addLast(((NetCircuitNode)cmsObservable).getNetElement());
            }
        }
        if (NetCircuitRollOperator.dbgOn()) {
            db.println("getDriNodes returns " + linkedList.size() + " Dri nodes");
            iterator = linkedList.iterator();
            while (iterator.hasNext()) {
                db.println("dri node " + ((INetElement)iterator.next()).getName());
            }
        }
        return linkedList;
    }

    protected List getRingNames(List list, List list2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        boolean bl = false;
        linkedList.add("");
        linkedList.add("");
        if (this.circuit.getProtType() == 18) {
            if (this.circuit.getDriNodes().isEmpty()) {
                return linkedList;
            }
            for (NetCircuitSpan netCircuitSpan : list2) {
                if (!netCircuitSpan.getDri()) continue;
                if (!bl) {
                    bl = true;
                    if (netCircuitSpan.getLink().getProtectionType() != 0 && netCircuitSpan.getLink().getProtectionType() != 4) continue;
                    if (NetCircuitRollOperator.dbgOn()) {
                        db.println("getRingNames set first ring name to " + netCircuitSpan.getLink().blsrRingName());
                    }
                    linkedList.set(0, netCircuitSpan.getLink().blsrRingName());
                    continue;
                }
                String string = (String)linkedList.get(0);
                if (netCircuitSpan.getLink().getProtectionType() != 0 && netCircuitSpan.getLink().getProtectionType() != 4 || netCircuitSpan.getLink().blsrRingName().equals(string)) continue;
                if (NetCircuitRollOperator.dbgOn()) {
                    db.println("getRingNames set second ring name to " + netCircuitSpan.getLink().blsrRingName());
                }
                linkedList.set(1, netCircuitSpan.getLink().blsrRingName());
                break;
            }
        }
        return linkedList;
    }

    protected void addSpansAndNodes(List list, Map map) {
        Object object3;
        Object object22;
        INetElement iNetElement = this.circuit.srcCircuitNode.getNetElement();
        this.circuit.removeCktNode(this.circuit.srcCircuitNode);
        this.circuit.insertCktNode((NetCircuitNode)map.get(iNetElement));
        ((NetCircuitNode)map.get(iNetElement)).setCircuit(this.circuit);
        this.circuit.srcCircuitNode = (NetCircuitNode)map.get(iNetElement);
        this.circuit.srcCircuitNode.setAdminState(this.circuit.getAdminState());
        this.circuit.setSrcNodeModel(iNetElement.getNodeModel());
        for (Object object22 : this.circuit.srcCircuitNode.getAllSpansList()) {
            if (list.contains(object22)) continue;
            if (this.circuit.srcCircuitNode.biSpans.contains(object22)) {
                this.circuit.srcCircuitNode.biSpans.remove(object22);
                break;
            }
            this.circuit.srcCircuitNode.inSpans.remove(object22);
            break;
        }
        this.circuit.srcCircuitNode.insertSource((NetCircuitEnd)this.circuit.getPrimarySource());
        this.circuit.srcCircuitNode.setupConnListOnCreation(this.circuit.srcCircuitNode.findConnType());
        object22 = this.circuit.getPrimaryDrop().getNetElement();
        NetCircuitNode netCircuitNode = null;
        List list2 = this.circuit.getCircuitNodeFromNE((INetElement)object22);
        if (list2 != null) {
            netCircuitNode = list2.size() > 1 ? this.circuit.getCircuitNodeFromCktEnd(this.circuit.getPrimaryDrop()) : (NetCircuitNode)list2.get(0);
        }
        this.circuit.removeCktNode(netCircuitNode);
        netCircuitNode = (NetCircuitNode)map.get(object22);
        this.circuit.insertCktNode(netCircuitNode);
        netCircuitNode.setCircuit(this.circuit);
        netCircuitNode.setAdminState(this.circuit.getAdminState());
        for (Object object3 : netCircuitNode.getAllSpansList()) {
            if (list.contains(object3)) continue;
            if (netCircuitNode.biSpans.contains(object3)) {
                netCircuitNode.biSpans.remove(object3);
                break;
            }
            netCircuitNode.outSpans.remove(object3);
            break;
        }
        netCircuitNode.insertDrop((NetCircuitEnd)this.circuit.getPrimaryDrop());
        netCircuitNode.setupConnListOnCreation(netCircuitNode.findConnType());
        Iterator<Object> iterator = list.iterator();
        object3 = new LinkedList();
        while (iterator.hasNext()) {
            CmsObservable cmsObservable = (NetCircuitSpan)iterator.next();
            this.circuit.insertCktSpan((NetCircuitSpan)cmsObservable);
            ((NetCircuitSpan)cmsObservable).setCircuit(this.circuit);
            if (!((LinkedList)object3).contains(((NetCircuitSpan)cmsObservable).getLink().getSrc())) {
                ((LinkedList)object3).add(((NetCircuitSpan)cmsObservable).getLink().getSrc());
            }
            if (((LinkedList)object3).contains(((NetCircuitSpan)cmsObservable).getLink().getDst())) continue;
            ((LinkedList)object3).add(((NetCircuitSpan)cmsObservable).getLink().getDst());
        }
        for (CmsObservable cmsObservable : map.values()) {
            if (this.circuit.getCircuitNodes().contains((Object)cmsObservable) || !((LinkedList)object3).contains(((NetCircuitNode)cmsObservable).getNetElement())) continue;
            this.circuit.insertCktNode((NetCircuitNode)cmsObservable);
            ((NetCircuitNode)cmsObservable).setCircuit(this.circuit);
            ((NetCircuitNode)cmsObservable).setAdminState(this.circuit.getAdminState());
        }
    }

    private static boolean isDriPathIndex(int n, int n2) {
        return n == 10 ? n2 == 1 : (n == 11 ? n2 == 1 || n2 == 3 : (n == 14 ? n2 == 1 : (n == 6 ? n2 == 1 : n == 16 && n2 == 1)));
    }

    protected static boolean isDriSpan(NetCircuitNode netCircuitNode, NetCircuitSpan netCircuitSpan) {
        int n = netCircuitNode.getPathDefIndexFromSpan(netCircuitSpan);
        return netCircuitNode.getDri() && NetCircuitRollOperator.isDriPathIndex(netCircuitNode.getConnectionType(), n);
    }

    public static boolean isDriCktEnd(NetCircuitNode netCircuitNode, INetCircuitEnd iNetCircuitEnd) {
        int n = netCircuitNode.getPathDefIndexFromCktEnd(iNetCircuitEnd);
        return netCircuitNode.getDri() && NetCircuitRollOperator.isDriPathIndex(netCircuitNode.getConnectionType(), n);
    }

    protected static boolean isRollToCktEnd(NetCircuitNode netCircuitNode, NetCircuitEnd netCircuitEnd) {
        NetCircuitEnd netCircuitEnd2 = NetCircuitRollOperator.getRollToCktEnd(netCircuitNode);
        return netCircuitEnd.equals(netCircuitEnd2);
    }

    protected static NetCircuitEnd getRollFromCktEnd(NetCircuitNode netCircuitNode) {
        NetCircuitEnd netCircuitEnd = null;
        IRollModel iRollModel = netCircuitNode.getRoll();
        if (iRollModel != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), netCircuitNode.getRollFromPath(iRollModel));
        }
        return netCircuitEnd;
    }

    protected static NetCircuitEnd getRollToCktEnd(NetCircuitNode netCircuitNode) {
        NetCircuitEnd netCircuitEnd = null;
        IRollModel iRollModel = netCircuitNode.getRoll();
        if (iRollModel != null) {
            netCircuitEnd = NetCircuitEndFactory.createCircuitEndFromConn(netCircuitNode.getNetElement(), netCircuitNode.getRollToPath(iRollModel));
        }
        return netCircuitEnd;
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof NetCcatCircuit) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (NetCircuitRollOperator.dbgOn()) {
                    db.println("RollOperator: DELETED from circuit " + this.circuit.getCircuitName());
                }
                this.dispose();
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                int n;
                int n2;
                if (NetCircuitRollOperator.dbgOn()) {
                    db.println("RollOperator: CHANGED from circuit " + this.circuit.getCircuitName());
                }
                if ((n2 = this.circuitState) != (n = ((NetCcatCircuit)iObservable).getState())) {
                    this.circuitState = n;
                    if (n2 == 8 && n == 1) {
                        this.dispose();
                        this.circuit.disposeRollOperator();
                    }
                }
            }
        }
    }

    private void dispose() {
        this.circuit.deleteObserver(this);
    }
}

