/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.CircuitMergeManager;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IDwdmPortModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.IHoConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.ILoAditModel;
import cerent.cms.model.ILoConnectionModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchccConnectionModel;
import cerent.cms.model.IOchccPathDefModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.ITdmProtocolType;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchPortsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.SvlanCircuitHelper;
import cerent.cms.ncp.CallbackLinkComparator;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.HoCcatCircuit;
import cerent.cms.ncp.HoCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InternalNetLink;
import cerent.cms.ncp.InternalSpliceLink;
import cerent.cms.ncp.InternalSpliceLinkComparator;
import cerent.cms.ncp.LoCcatCircuit;
import cerent.cms.ncp.LoCircuitNode;
import cerent.cms.ncp.LoCircuitSpan;
import cerent.cms.ncp.LoTunnelNode;
import cerent.cms.ncp.LoYCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitNodeFactory;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.OchTrailTunnelNode;
import cerent.cms.ncp.OchccCircuit;
import cerent.cms.ncp.OchccCircuitNode;
import cerent.cms.ncp.OchncCircuitNode;
import cerent.cms.ncp.SpliceLinkIndex;
import cerent.cms.ncp.SpliceLinkIndexComparator;
import cerent.cms.ncp.SpliceListener;
import cerent.cms.ncp.SpliceListenerComparator;
import cerent.cms.ncp.SpliceListenerEntry;
import cerent.cms.ncp.SpliceListenerEntryComparator;
import cerent.cms.ncp.SvlanCircuitNode;
import cerent.cms.ncp.eSpanDirection;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.NonRoutableNetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.ServerTrailLink;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import cerent.util.ILoNum;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class NetCircuitSplicer
implements Observer {
    private static NetCircuitSplicer splicer;
    private static SDebug db;
    public DumpDebug spliceTreeDump = new DumpDebug("SpliceTree");
    private Map linkEntries;
    protected SpliceListenerComparator listenerComparator = new SpliceListenerComparator();
    private SpliceLinkIndexComparator linkIndexComparator = new SpliceLinkIndexComparator();
    private CallbackLinkComparator netLinkComparator = new CallbackLinkComparator();
    private InternalSpliceLinkComparator internalSpliceLinkComparator = new InternalSpliceLinkComparator();
    private TreeSet spliceListenersAddHolder;
    private TreeSet spliceListenersRemoveHolder;
    private List callbackLinksHolder;
    private List callbackIntLinksHolder;
    private TreeSet callbackLinks;
    private TreeSet callbackIntLinks;
    private Object holderLockObject;
    protected Network net;
    protected NetCircuitManager ncMgr;

    protected NetCircuitSplicer() {
        this.linkEntries = new TreeMap(this.linkIndexComparator);
        this.callbackLinks = new TreeSet(this.netLinkComparator);
        this.callbackIntLinks = new TreeSet(this.internalSpliceLinkComparator);
        this.callbackLinksHolder = new LinkedList();
        this.callbackIntLinksHolder = new LinkedList();
        SpliceListenerEntryComparator spliceListenerEntryComparator = new SpliceListenerEntryComparator();
        this.spliceListenersAddHolder = new TreeSet(spliceListenerEntryComparator);
        this.spliceListenersRemoveHolder = new TreeSet(spliceListenerEntryComparator);
        this.holderLockObject = new Object();
        this.net = null;
        this.ncMgr = null;
    }

    public static synchronized NetCircuitSplicer instance() {
        if (splicer == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Creating a Circuit Splicer");
            }
            splicer = new NetCircuitSplicer();
        }
        return splicer;
    }

    protected void initialize() {
        this.net = Network.instance();
        this.ncMgr = NetCircuitManager.instance();
    }

    protected Map getLinkEntries() {
        return this.linkEntries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelCallback(SpliceListenerEntry spliceListenerEntry) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Queuing callback cancel for " + spliceListenerEntry.prettyString());
        }
        Object object = this.holderLockObject;
        synchronized (object) {
            this.spliceListenersAddHolder.remove(spliceListenerEntry);
            this.spliceListenersRemoveHolder.add(spliceListenerEntry);
        }
    }

    protected synchronized SpliceListener findListener(INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, boolean bl) {
        SpliceLinkIndex spliceLinkIndex = new SpliceLinkIndex(iNetElement, n, eSpanDirection2);
        Map map = (Map)this.linkEntries.get(spliceLinkIndex);
        if (map == null) {
            return null;
        }
        SpliceListener spliceListener = new SpliceListener(iHoNum, iLoNum, 0, null, bl);
        spliceListener = (SpliceListener)map.get(spliceListener);
        return spliceListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SpliceListenerEntry registerCallback(INetElement iNetElement, int n, eSpanDirection eSpanDirection2, IHoNum iHoNum, ILoNum iLoNum, int n2, NetCircuitNode netCircuitNode, boolean bl) {
        Object object;
        SpliceListenerEntry spliceListenerEntry;
        LinkedList<InternalSpliceLink> linkedList;
        LinkedList<INetLink> linkedList2;
        block94: {
            INetLink iNetLink = null;
            INetLink iNetLink2 = null;
            INetLink iNetLink3 = null;
            INetLink iNetLink4 = null;
            boolean bl2 = false;
            boolean bl3 = false;
            linkedList2 = new LinkedList<INetLink>();
            InternalSpliceLink internalSpliceLink = null;
            linkedList = new LinkedList<InternalSpliceLink>();
            spliceListenerEntry = new SpliceListenerEntry(iNetElement, n, eSpanDirection2, iHoNum, iLoNum, n2, netCircuitNode, bl);
            if (this.net == null) {
                this.net = Network.instance();
            }
            if (eSpanDirection2 == eSpanDirection.ORIGINATING || eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
                iNetLink = this.net.findNetLinkFromSource(false, iNetElement, n, iHoNum, iLoNum);
                if (iNetLink != null && (iNetLink2 = this.net.findReverseLink(iNetLink)) != null && !iNetLink2.isValidDstHoNumber(iHoNum)) {
                    iNetLink2 = null;
                }
                if (iLoNum != null) {
                    iNetLink3 = this.net.findNetLinkFromSource(true, iNetElement, n, iHoNum, iLoNum);
                    if (iNetLink3 != null && (iNetLink4 = this.net.findReverseLink(iNetLink3)) != null && !iNetLink4.isValidDstHoNumber(iHoNum)) {
                        iNetLink4 = null;
                    }
                } else {
                    iNetLink3 = this.net.findOchTrailTunnelNetLinkFromSrc(iNetElement, n);
                    if (iNetLink3 != null) {
                        iNetLink4 = this.net.findReverseLink(iNetLink3);
                    }
                }
            } else {
                iNetLink = this.net.findNetLinkFromDestination(false, iNetElement, n, iHoNum, iLoNum);
                if (iNetLink != null && (iNetLink2 = this.net.findReverseLink(iNetLink)) != null && !iNetLink2.isValidSrcHoNumber(iHoNum)) {
                    iNetLink2 = null;
                }
                if (iLoNum != null) {
                    iNetLink3 = this.net.findNetLinkFromDestination(true, iNetElement, n, iHoNum, iLoNum);
                    if (iNetLink3 != null && (iNetLink4 = this.net.findReverseLink(iNetLink3)) != null && !iNetLink4.isValidSrcHoNumber(iHoNum)) {
                        iNetLink4 = null;
                    }
                } else {
                    iNetLink3 = this.net.findOchTrailTunnelNetLinkFromDst(iNetElement, n);
                    if (iNetLink3 != null) {
                        iNetLink4 = this.net.findReverseLink(iNetLink3);
                    }
                }
            }
            if (NetCircuitSplicer.dbgOn()) {
                if (iNetLink != null && this.hasNullTdmReverseLink(iNetLink, iNetLink2)) {
                    NetCircuitSplicer.debug("registerCallback: WARNING-No reverse link for " + iNetLink.prettyString());
                }
                if (iNetLink3 != null && this.hasNullTdmReverseLink(iNetLink3, iNetLink4)) {
                    NetCircuitSplicer.debug("registerCallback: WARNING-No reverse link for " + iNetLink3.prettyString());
                }
            }
            bl2 = iNetLink != null && !this.hasNullTdmReverseLink(iNetLink, iNetLink2);
            boolean bl4 = bl3 = iNetLink3 != null && !this.hasNullTdmReverseLink(iNetLink3, iNetLink4);
            if (bl3) {
                if (!linkedList2.contains(iNetLink3)) {
                    linkedList2.add(iNetLink3);
                }
                if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL && iNetLink4 != null && !linkedList2.contains(iNetLink4)) {
                    linkedList2.add(iNetLink4);
                }
            }
            if (bl2) {
                if (!linkedList2.contains(iNetLink)) {
                    linkedList2.add(iNetLink);
                }
                if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL && iNetLink2 != null && !linkedList2.contains(iNetLink2)) {
                    linkedList2.add(iNetLink2);
                }
            }
            if (iNetLink == null && iNetLink3 == null) {
                int n3;
                int n4 = 0;
                if (netCircuitNode instanceof OchccCircuitNode && bl) {
                    if (OchTrailHelper.isTrunkPort(iNetElement.getNodeModel(), n)) {
                        n4 = n;
                        try {
                            object = OchTrailHelper.getColocatedOchPorts(iNetElement, n4);
                            if (object != null && ((Object)object).length > 0) {
                                internalSpliceLink = eSpanDirection2 == eSpanDirection.ORIGINATING ? new InternalSpliceLink(iNetElement, n4, (int)object[0]) : new InternalSpliceLink(iNetElement, (int)object[1], n4);
                                linkedList.add(internalSpliceLink);
                            }
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)abstractCmsNoSuchEntityException));
                            }
                        }
                        catch (FeatureUnsupported featureUnsupported) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)featureUnsupported));
                            }
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)noSuchInterface));
                            }
                        }
                    }
                } else if (netCircuitNode instanceof OchncCircuitNode && bl) {
                    if (OchTrailHelper.isTrunkPort(iNetElement.getNodeModel(), n)) {
                        n4 = n;
                        int[] nArray = null;
                        try {
                            nArray = OchTrailHelper.getColocatedOchPorts(netCircuitNode.getNetElement(), n4);
                            if (nArray == null || nArray.length <= 0) break block94;
                            if (eSpanDirection2 == eSpanDirection.TERMINATING) {
                                int n5 = nArray[1];
                                internalSpliceLink = new InternalSpliceLink(iNetElement, n5, n4);
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("t-creating och to trunk internal link: " + n5 + ", " + n4);
                                }
                            } else if (eSpanDirection2 == eSpanDirection.ORIGINATING) {
                                int n6 = nArray[0];
                                internalSpliceLink = new InternalSpliceLink(iNetElement, n4, n6);
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("o-creating trunk to och internal link: " + n4 + ", " + n6);
                                }
                            } else if (eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
                                IEntityModel iEntityModel;
                                IEntityModel iEntityModel2;
                                INodeModel iNodeModel;
                                block95: {
                                    iNodeModel = netCircuitNode.getNetElement().getNodeModel();
                                    IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                                    iEntityModel2 = null;
                                    try {
                                        if (iEntityTableModel != null) {
                                            iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n4);
                                        }
                                    }
                                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                        if (!NetCircuitSplicer.dbgOn()) break block95;
                                        abstractCmsNoSuchEntityException.printStackTrace();
                                    }
                                }
                                if (iEntityModel2 != null && iEntityModel2.getModuleModel().getEqType() == 293 && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OTU2_XP) && (iEntityModel = ((IDwdmPortModel)iEntityModel2).getRegenPeerLineModel()) != null) {
                                    internalSpliceLink = new InternalSpliceLink(iNetElement, iEntityModel.getEntityIndex(), n4);
                                    if (NetCircuitSplicer.dbgOn()) {
                                        NetCircuitSplicer.debug("b-creating trunk to trunk internal link: " + n4 + ", " + iEntityModel.getEntityIndex());
                                    }
                                }
                            }
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug(internalSpliceLink.prettyString());
                            }
                            linkedList.add(internalSpliceLink);
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            abstractCmsNoSuchEntityException.printStackTrace();
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            noSuchInterface.printStackTrace();
                        }
                        catch (FeatureUnsupported featureUnsupported) {
                            featureUnsupported.printStackTrace();
                        }
                    }
                } else if (netCircuitNode instanceof OchncCircuitNode) {
                    if (OchPortsHelper.isOchPort(iNetElement.getNodeModel(), n)) {
                        int n7 = n;
                        if (n2 == 0) {
                            n2 = spliceListenerEntry.spliceListener.optChannel;
                        }
                        if ((n4 = OchTrailHelper.getColocatedTrunkPort(iNetElement.getNodeModel(), n7, n2)) != 0) {
                            if (eSpanDirection2 == eSpanDirection.TERMINATING) {
                                internalSpliceLink = new InternalSpliceLink(iNetElement, n4, n7);
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("t-creating trunk to och internal link: " + n4 + ", " + n7);
                                }
                            } else {
                                internalSpliceLink = new InternalSpliceLink(iNetElement, n7, n4);
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("o-creating och to trunk internal link: " + n7 + ", " + n4);
                                }
                            }
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug(internalSpliceLink.prettyString());
                            }
                            linkedList.add(internalSpliceLink);
                        }
                    }
                } else if (netCircuitNode instanceof OchTrailTunnelNode) {
                    if (OchTrailHelper.isTrunkPort(iNetElement.getNodeModel(), n) && eSpanDirection2 == eSpanDirection.BIDIRECTIONAL) {
                        n4 = n;
                        INodeModel iNodeModel = iNetElement.getNodeModel();
                        try {
                            int n8;
                            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                            IEntityModel iEntityModel = null;
                            if (iEntityTableModel != null) {
                                iEntityModel = iEntityTableModel.getEntityModelByIndex(n4);
                            }
                            IEntityModel iEntityModel3 = null;
                            if (iEntityModel != null && iEntityModel instanceof IDwdmPortModel && Feature.provides((INodeModel)iNodeModel, (Feature)Feature.OTU2_XP)) {
                                iEntityModel3 = ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel();
                            }
                            if (iEntityModel3 != null && (n8 = iEntityModel3.getEntityIndex()) != 0 && n4 != 0 && n8 != n4) {
                                internalSpliceLink = new InternalSpliceLink(iNetElement, n4, n8);
                                linkedList.add(internalSpliceLink);
                                if (db.on()) {
                                    NetCircuitSplicer.debug("Regen found on " + netCircuitNode.getName() + " between " + n4 + " and " + n8);
                                }
                            }
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (db.on()) {
                                db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                            }
                        }
                    }
                } else if (netCircuitNode instanceof LoCircuitNode && bl || netCircuitNode instanceof HoCircuitNode) {
                    if (netCircuitNode.onXm(n)) {
                        int n9 = n;
                        int n10 = netCircuitNode.getPairedPortlessPort(n9);
                        internalSpliceLink = eSpanDirection2 == eSpanDirection.TERMINATING ? new InternalSpliceLink(iNetElement, n10, n9) : new InternalSpliceLink(iNetElement, n9, n10);
                        linkedList.add(internalSpliceLink);
                    } else if (netCircuitNode instanceof HoCircuitNode && (n4 = ((HoCircuitNode)netCircuitNode).getADMoBTrunkPort(n)) != 0) {
                        try {
                            object = OchTrailHelper.getColocatedOchPorts(iNetElement, n4);
                            if (object != null && ((Object)object).length > 0) {
                                internalSpliceLink = new InternalSpliceLink(iNetElement, n4, (int)object[0]);
                                linkedList.add(internalSpliceLink);
                                internalSpliceLink = new InternalSpliceLink(iNetElement, (int)object[1], n4);
                                linkedList.add(internalSpliceLink);
                            }
                        }
                        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)abstractCmsNoSuchEntityException));
                            }
                        }
                        catch (FeatureUnsupported featureUnsupported) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)featureUnsupported));
                            }
                        }
                        catch (NoSuchInterface noSuchInterface) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception getting co-located ports: " + (Object)((Object)noSuchInterface));
                            }
                        }
                    }
                } else if (netCircuitNode instanceof SvlanCircuitNode && (n3 = SvlanCircuitHelper.getGZConnectedTrunk(iNetElement, n4 = n)) != 0) {
                    internalSpliceLink = new InternalSpliceLink(iNetElement, n4, n3);
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("SVLAN - creating trunk to trunk internal link: " + Integer.toHexString(n4) + ", " + Integer.toHexString(n3));
                    }
                    linkedList.add(internalSpliceLink);
                }
            }
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Queuing callback register for " + spliceListenerEntry.prettyString());
        }
        object = this.holderLockObject;
        synchronized (object) {
            this.spliceListenersRemoveHolder.remove(spliceListenerEntry);
            this.spliceListenersAddHolder.add(spliceListenerEntry);
            this.callbackLinksHolder.addAll(linkedList2);
            this.callbackIntLinksHolder.addAll(linkedList);
        }
        return spliceListenerEntry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeSpliceListeners() {
        Object object = this.holderLockObject;
        synchronized (object) {
            Map map;
            for (SpliceListenerEntry spliceListenerEntry : this.spliceListenersAddHolder) {
                map = (TreeMap<SpliceListener, SpliceListener>)this.linkEntries.get(spliceListenerEntry.spliceLinkIndex);
                if (map == null) {
                    map = new TreeMap<SpliceListener, SpliceListener>(this.listenerComparator);
                    this.linkEntries.put(spliceListenerEntry.spliceLinkIndex, map);
                }
                map.put(spliceListenerEntry.spliceListener, spliceListenerEntry.spliceListener);
                if (!NetCircuitSplicer.dbgOn()) continue;
                NetCircuitSplicer.debug("Added " + spliceListenerEntry.prettyString() + " to listenerTree");
            }
            this.spliceListenersAddHolder.clear();
            for (SpliceListenerEntry spliceListenerEntry : this.spliceListenersRemoveHolder) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Deleting " + spliceListenerEntry.prettyString() + " from listenerTree");
                }
                if ((map = (Map)this.linkEntries.get(spliceListenerEntry.spliceLinkIndex)) == null) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("Splice link index tree not found");
                    continue;
                }
                SpliceListener spliceListener = (SpliceListener)map.get(spliceListenerEntry.spliceListener);
                if (spliceListener == null) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("Splice listener not found in listener tree");
                    continue;
                }
                map.remove(spliceListener);
            }
            this.spliceListenersRemoveHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void synchronizeCallbackLinks() {
        Object object = this.holderLockObject;
        synchronized (object) {
            for (Object object2 : this.callbackLinksHolder) {
                if (this.callbackLinks.contains(object2)) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Adding " + object2.prettyString() + " to callback links");
                }
                if (object2.state() == 2) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("Link " + object2.prettyString() + " not added to callback links: LINK_DOWN");
                    continue;
                }
                this.callbackLinks.add(object2);
            }
            this.callbackLinksHolder.clear();
            for (Object object2 : this.callbackIntLinksHolder) {
                if (this.callbackIntLinks.contains(object2)) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Adding " + ((InternalSpliceLink)object2).prettyString() + " to callback internal splice links");
                }
                this.callbackIntLinks.add(object2);
            }
            this.callbackIntLinksHolder.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newNetLink(INetLink iNetLink) {
        if (iNetLink instanceof NonRoutableNetLink) {
            return;
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("newNetLink(" + iNetLink.prettyString() + ")");
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        Object object = this.holderLockObject;
        synchronized (object) {
            this.callbackLinksHolder.add(iNetLink);
            iNetLink.addObserver(this);
            if (iNetLink2 != null) {
                this.callbackLinksHolder.add(iNetLink2);
                iNetLink2.addObserver(this);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void changeNetLink(INetLink iNetLink) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("changeNetLink(" + iNetLink.prettyString() + ")");
        }
        INetLink iNetLink2 = Network.instance().findReverseLink(iNetLink);
        Object object = this.holderLockObject;
        synchronized (object) {
            this.callbackLinksHolder.add(iNetLink);
            if (iNetLink2 != null) {
                this.callbackLinksHolder.add(iNetLink2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteNetLink(INetLink iNetLink) {
        if (iNetLink instanceof NonRoutableNetLink) {
            return;
        }
        Object object = this.holderLockObject;
        synchronized (object) {
            iNetLink.deleteObserver(this);
            this.callbackLinksHolder.remove(iNetLink);
        }
    }

    protected boolean spliceAllowed(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        if (netCircuitNode.isUpsrOverOnePluOne() || netCircuitNode2.isUpsrOverOnePluOne()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Splicing denied on 1s/2d or 2s/1d UPSRover1+1 connections");
            }
            return false;
        }
        return this.spliceAllowed(netCircuitNode.getCircuit(), netCircuitNode2.getCircuit());
    }

    protected boolean spliceAllowed(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        ICircuitId iCircuitId = iNetCircuit.getCircuitId();
        ICircuitId iCircuitId2 = iNetCircuit2.getCircuitId();
        if (iCircuitId == null || iCircuitId2 == null) {
            return false;
        }
        if (iCircuitId.getNodeId() != 0 && iCircuitId2.getNodeId() != 0 && !iCircuitId.equals(iCircuitId2)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceAllowed: Encountered circuit ID conflict");
            }
            return false;
        }
        return true;
    }

    protected boolean spliceCheck(SpliceListener spliceListener, SpliceListener spliceListener2, boolean bl) {
        if (!spliceListener.node.isNodeRefValid() || !spliceListener2.node.isNodeRefValid()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Invalid node reference");
            }
            return false;
        }
        INetCircuit iNetCircuit = spliceListener.node.getCircuit();
        INetCircuit iNetCircuit2 = spliceListener2.node.getCircuit();
        if (!iNetCircuit.isCircuitRefValid() || !iNetCircuit2.isCircuitRefValid()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Invalid circuit reference");
            }
            return false;
        }
        if (!this.spliceAllowed(spliceListener.node, spliceListener2.node)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Failed spliceAllowed()");
            }
            return false;
        }
        if (!bl && iNetCircuit.getCircuitSize() != iNetCircuit2.getCircuitSize()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Circuit size conflict");
            }
            return false;
        }
        if (spliceListener.optChannel != spliceListener2.optChannel) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Circuit optical channel conflict");
            }
            return false;
        }
        if (spliceListener.node instanceof SvlanCircuitNode && spliceListener2.node instanceof SvlanCircuitNode && ((SvlanCircuitNode)spliceListener.node).getSvlan() != ((SvlanCircuitNode)spliceListener2.node).getSvlan()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceCheck: Circuit SVLAN conflict");
            }
            return false;
        }
        if (spliceListener.node instanceof OchccCircuitNode && spliceListener2.node instanceof OchccCircuitNode) {
            OchccCircuit ochccCircuit = (OchccCircuit)iNetCircuit;
            OchccCircuit ochccCircuit2 = (OchccCircuit)iNetCircuit2;
            OchTrailHelper.OchccCircuitSize ochccCircuitSize = null;
            OchTrailHelper.OchccCircuitSize ochccCircuitSize2 = null;
            if (ochccCircuit != null) {
                ochccCircuitSize = OchTrailHelper.OchccCircuitSize.fromInt(ochccCircuit.getSpecificSize(), ochccCircuit.getSourceNE().getTdmProtocolType());
            }
            if (ochccCircuit2 != null) {
                ochccCircuitSize2 = OchTrailHelper.OchccCircuitSize.fromInt(ochccCircuit2.getSpecificSize(), ochccCircuit2.getSourceNE().getTdmProtocolType());
            }
            if (ochccCircuitSize != null && ochccCircuitSize2 != null && !ochccCircuitSize.equals(ochccCircuitSize2)) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceCheck: OCHCC Circuit Circuit Size conflict");
                }
                return false;
            }
            IEntityModel iEntityModel = ((OchccCircuitNode)spliceListener.node).getClientPortModel();
            IEntityModel iEntityModel2 = ((OchccCircuitNode)spliceListener2.node).getClientPortModel();
            if (iEntityModel != null && iEntityModel2 != null && iEntityModel.getModuleModel().getEqType() != 293 && iEntityModel2.getModuleModel().getEqType() != 293 && iEntityModel.getModuleModel().getEqType() != 271 && iEntityModel2.getModuleModel().getEqType() != 271 && ((OchccCircuitNode)spliceListener.node).getClientPortNumber() != ((OchccCircuitNode)spliceListener2.node).getClientPortNumber()) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceCheck: OCHCC Circuit client port number conflict");
                }
                return false;
            }
        }
        return true;
    }

    private void addTl1TunnelEnd(SpliceListenerEntry spliceListenerEntry, SpliceListenerEntry spliceListenerEntry2, Object object, INetLink iNetLink) {
        Object object2;
        Object object3;
        InternalNetLink internalNetLink;
        NetCircuitNode netCircuitNode;
        NetCircuitNode netCircuitNode2 = null;
        SpliceListener spliceListener = spliceListenerEntry.spliceListener;
        SpliceLinkIndex spliceLinkIndex = spliceListenerEntry.spliceLinkIndex;
        SpliceListener spliceListener2 = spliceListenerEntry2.spliceListener;
        SpliceLinkIndex spliceLinkIndex2 = spliceListenerEntry2.spliceLinkIndex;
        NetCircuitNode netCircuitNode3 = spliceListener.node;
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode3.getCircuit();
        NetCircuitNode netCircuitNode4 = spliceListener2.node;
        INetLink iNetLink2 = null;
        boolean bl = true;
        if (object instanceof INetLink) {
            bl = true;
            iNetLink2 = (INetLink)object;
        } else if (object instanceof InternalSpliceLink) {
            bl = false;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addTl1TunnelEnd: ERROR-Invalid link object");
            }
            return;
        }
        List list = netCcatCircuit.getCircuitNodeFromNE(spliceListener2.node.getNetElement());
        if (list != null) {
            if (list.size() > 1) {
                for (Object object4 : list) {
                    if (!(object4 instanceof LoTunnelNode) && !(object4 instanceof OchTrailTunnelNode) && !(object4 instanceof DualConnectionCircuitNode)) continue;
                    netCircuitNode2 = object4;
                    break;
                }
            } else {
                netCircuitNode2 = (NetCircuitNode)list.get(0);
            }
        }
        if (netCircuitNode2 != null && (netCircuitNode2 instanceof LoTunnelNode || netCircuitNode2 instanceof OchTrailTunnelNode || netCircuitNode2 instanceof DualConnectionCircuitNode)) {
            netCircuitNode = netCircuitNode2;
        } else {
            IConnectionModel iConnectionModel = spliceListener2.node.getConn();
            int n = spliceLinkIndex2.entityIndex;
            internalNetLink = null;
            object3 = null;
            if (iConnectionModel instanceof ILoConnectionModel) {
                object3 = ((ILoConnectionModel)iConnectionModel).getPaths();
            } else if (iConnectionModel instanceof IOchccConnectionModel) {
                object3 = ((IOchccConnectionModel)iConnectionModel).getPaths();
            } else if (iConnectionModel instanceof IHoConnectionModel) {
                object3 = ((IHoConnectionModel)iConnectionModel).getPaths();
            }
            for (int i = 0; i < ((ILoDefModel[])object3).length; ++i) {
                ILoDefModel iLoDefModel = object3[i];
                ILoAditModel iLoAditModel = null;
                if (iLoDefModel instanceof ILoDefModel) {
                    iLoAditModel = iLoDefModel.getLoAdit();
                } else if (iLoDefModel instanceof IOchccPathDefModel) {
                    iLoAditModel = ((IOchccPathDefModel)iLoDefModel).getOchTrailAdit();
                }
                int n2 = 0;
                if (iLoAditModel instanceof ILoAditModel) {
                    IHoPathDefModel iHoPathDefModel = iLoAditModel.getHo();
                    n2 = iHoPathDefModel.getPool().getEntityIndex();
                } else if (iLoAditModel instanceof IOchTrailAditModel) {
                    IOchncPathDefModel[] iOchncPathDefModelArray = ((IOchTrailAditModel)iLoAditModel).getPaths();
                    n2 = iOchncPathDefModelArray[0].getPortEntityIdx();
                } else if (netCircuitNode4 instanceof HoCircuitNode) {
                    int n3 = ((IHoPathDefModel)iLoDefModel).getPool().getEntityIndex();
                    n2 = ((HoCircuitNode)netCircuitNode4).getADMoBTrunkPort(n3);
                    if (n2 == 0) continue;
                    IConnectionModels iConnectionModels = netCircuitNode4.getNodeModel().getConnectionModels();
                    IOchTrailAditModel[] iOchTrailAditModelArray = iConnectionModels.getOchTrailAditModels();
                    for (int j = 0; j < iOchTrailAditModelArray.length; ++j) {
                        IOchncPathDefModel[] iOchncPathDefModelArray = iOchTrailAditModelArray[j].getPaths();
                        if (iOchncPathDefModelArray[0].getPortEntityIdx() != n2) continue;
                        iLoAditModel = iOchTrailAditModelArray[j];
                        break;
                    }
                }
                if (n2 != n) continue;
                internalNetLink = iLoAditModel;
                break;
            }
            if (internalNetLink == null) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("addTl1TunnelEnd: ERROR: Could not find tunnel adit model");
                }
                return;
            }
            netCircuitNode = NetCircuitNodeFactory.createCircuitNode(spliceListener2.node.getNetElement(), netCcatCircuit, internalNetLink);
            netCircuitNode.setState(2);
            object2 = NetCircuitEndFactory.createNodeDrop(netCcatCircuit.getCircuitType(), spliceListener2.node.getNetElement());
            ((NetCircuitEnd)object2).setStage(4);
            netCircuitNode.insertDrop((NetCircuitEnd)object2);
            if (bl) {
                netCcatCircuit.insertCktNode(netCircuitNode);
            } else {
                netCcatCircuit.insertCktNode(netCircuitNode);
            }
            netCircuitNode.cleanupSpliceListeners();
        }
        if (bl) {
            NetLinkSpan netLinkSpan = spliceLinkIndex2.direction != eSpanDirection.BIDIRECTIONAL || spliceLinkIndex.direction != eSpanDirection.BIDIRECTIONAL ? new NetLinkSpan(iNetLink2, iNetLink, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum) : (iNetLink2.getSrc().equals(netCircuitNode3.getNetElement()) ? new NetLinkSpan(iNetLink2, iNetLink, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum) : new NetLinkSpan(iNetLink, iNetLink2, (ILabel)spliceListener2.hoNum, (ILabel)spliceListener2.hoNum));
            NetCircuitSpan netCircuitSpan = iNetLink2.getSrc().equals(netCircuitNode3.getNetElement()) ? NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode3, netCircuitNode) : NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode, netCircuitNode3);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            netCircuitNode.addActiveSpan(netCircuitSpan, spliceLinkIndex2.direction);
            netCircuitNode3.addActiveSpan(netCircuitSpan, spliceLinkIndex.direction);
        } else if (netCircuitNode3.isOchncCircuitNode()) {
            Object object4;
            boolean bl2 = false;
            object4 = (InternalSpliceLink)object;
            if (OchTrailHelper.isTrunkPort(netCircuitNode3.getNodeModel(), ((InternalSpliceLink)object4).srcEntityIndex)) {
                bl2 = true;
            }
            internalNetLink = new InternalNetLink(netCircuitNode3.getNetElement(), netCircuitNode.getNetElement(), ((InternalSpliceLink)object4).srcEntityIndex, ((InternalSpliceLink)object4).dstEntityIndex, null, null);
            NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, null, null, null);
            object3 = null;
            object2 = null;
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("src or drop internal link" + ((InternalSpliceLink)object4).prettyString());
            }
            if (bl2) {
                object3 = netCircuitNode;
                object2 = netCircuitNode3;
            } else {
                object3 = netCircuitNode3;
                object2 = netCircuitNode;
            }
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, (INetCircuitNode)object3, (INetCircuitNode)object2);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            ((NetCircuitNode)object3).addActiveSpan(netCircuitSpan, eSpanDirection.ORIGINATING);
            ((NetCircuitNode)object2).addActiveSpan(netCircuitSpan, eSpanDirection.TERMINATING);
            netCcatCircuit.insertCktSpan(netCircuitSpan);
        }
    }

    private boolean spliceTl1TunnelEnd(SpliceListenerEntry spliceListenerEntry, SpliceListenerEntry spliceListenerEntry2, Object object, INetLink iNetLink, boolean bl, boolean bl2) {
        int n;
        int n2;
        boolean bl3;
        NetCcatCircuit netCcatCircuit;
        SpliceListenerEntry spliceListenerEntry3;
        Object object2;
        NetCcatCircuit netCcatCircuit2;
        SpliceListenerEntry spliceListenerEntry4;
        Object object3;
        Object object4;
        INetLink iNetLink2 = null;
        InternalSpliceLink internalSpliceLink = null;
        boolean bl4 = true;
        if (object instanceof INetLink) {
            bl4 = true;
            iNetLink2 = (INetLink)object;
        } else if (object instanceof InternalSpliceLink) {
            bl4 = false;
            internalSpliceLink = (InternalSpliceLink)object;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: ERROR-Invalid link object");
            }
            return false;
        }
        if (NetCircuitSplicer.dbgOn()) {
            object4 = bl4 ? iNetLink2.prettyString() : internalSpliceLink.prettyString();
            NetCircuitSplicer.debug("spliceTl1TunnelEnd for " + (String)object4);
        }
        object4 = spliceListenerEntry.spliceListener;
        SpliceListener spliceListener = spliceListenerEntry2.spliceListener;
        NetCcatCircuit netCcatCircuit3 = (NetCcatCircuit)((SpliceListener)object4).node.getCircuit();
        NetCcatCircuit netCcatCircuit4 = (NetCcatCircuit)spliceListener.node.getCircuit();
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Splicing TL1 tunnel end listeners: " + ((SpliceListener)object4).prettyString() + " and " + spliceListener.prettyString());
        }
        if (((SpliceListener)object4).loAdit && spliceListener.loAdit) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Both listeners cannot be Adits");
            }
            return false;
        }
        if (((SpliceListener)object4).loAdit) {
            object3 = object4;
            spliceListenerEntry4 = spliceListenerEntry;
            netCcatCircuit2 = netCcatCircuit3;
            object2 = spliceListener;
            spliceListenerEntry3 = spliceListenerEntry2;
            netCcatCircuit = netCcatCircuit4;
            bl3 = bl2;
        } else if (spliceListener.loAdit) {
            object3 = spliceListener;
            spliceListenerEntry4 = spliceListenerEntry2;
            netCcatCircuit2 = netCcatCircuit4;
            object2 = object4;
            spliceListenerEntry3 = spliceListenerEntry;
            netCcatCircuit = netCcatCircuit3;
            bl3 = bl;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: No loAdit found");
            }
            return false;
        }
        if (!(((SpliceListener)object2).node instanceof OchncCircuitNode) && !bl3) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Unidirectional TL1 tunnels are not recognized as links");
            }
            return false;
        }
        ITdmProtocolType iTdmProtocolType = ((SpliceListener)object2).node.getNetElement().getTdmProtocolTypeObj();
        if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType() || netCcatCircuit.getCircuitTypeObj().isHoCircuitType()) {
            n2 = ((SpliceListener)object2).hoNum.getFramingType();
            n = CircuitSize.getLoTunnelSize((int)n2).getEnum();
            if (netCcatCircuit.getCircuitSize() != n) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceTl1Lot:: hoCkt size does not match LAP/LOT");
                }
                return false;
            }
        }
        if (netCcatCircuit.getCircuitTypeObj().isLAPCircuitType()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Converting LAP to LOT ");
            }
            netCcatCircuit.checkAndUpdateCircuit();
            this.ncMgr.removeCircuitIfLAP(netCcatCircuit);
            n2 = iTdmProtocolType.getTunnelCircuitType();
            netCcatCircuit.setCircuitType(n2);
            this.addTl1TunnelEnd(spliceListenerEntry3, spliceListenerEntry4, object, iNetLink);
            netCcatCircuit.tl1CircuitCompleteCheck();
        } else if (netCcatCircuit.getCircuitTypeObj().isHoCircuitType()) {
            NetCircuitEnd netCircuitEnd = ((SpliceListener)object2).node.getSpliceListenerEndpoint(spliceListenerEntry3);
            if (netCcatCircuit.isSource(netCircuitEnd)) {
                try {
                    netCcatCircuit.reverseRoutingDir();
                }
                catch (IncorrectCircuitState incorrectCircuitState) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("spliceTl1TunnelEnd: Error during ckt. reversal");
                    }
                    return false;
                }
            }
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Converting circuit to LAP");
            }
            n = iTdmProtocolType.getAggCircuitType();
            netCcatCircuit.setCircuitType(n);
            IConnectionModel iConnectionModel = ((SpliceListener)object3).node.getConn();
            ILoDefModel[] iLoDefModelArray = ((ILoConnectionModel)iConnectionModel).getActivePaths();
            int n3 = iLoDefModelArray[0].getLoPathWidth();
            ICircuitSize iCircuitSize = CircuitSize.width2sizeOfLoCircuit((int)n3);
            ((HoCcatCircuit)netCcatCircuit).setContainedLoSize(iCircuitSize);
            ICircuitType iCircuitType = netCcatCircuit2.getCircuitTypeObj();
            ((HoCcatCircuit)netCcatCircuit).setContainedLoType(iCircuitType);
            this.addTl1TunnelEnd(spliceListenerEntry3, spliceListenerEntry4, object, iNetLink);
            netCcatCircuit.tl1CircuitCompleteCheck();
            this.ncMgr.insertCircuitIfLAP(netCcatCircuit);
        } else if (netCcatCircuit.getCircuitTypeObj().isOchncType() || netCcatCircuit.getCircuitTypeObj().isOchTrailTunnelCircuitType()) {
            if (netCcatCircuit.getCircuitTypeObj().isOchncType()) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("spliceTl1TunnelEnd: Converting OCHNC circuit to OTT");
                }
                netCcatCircuit.setCircuitType(15);
                netCcatCircuit.checkAndUpdateCircuit();
            } else if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Completing OTT circuit");
            }
            this.addTl1TunnelEnd(spliceListenerEntry3, spliceListenerEntry4, object, iNetLink);
            netCcatCircuit.tl1CircuitCompleteCheck();
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceTl1TunnelEnd: Invalid Circuit Type ");
            }
            return false;
        }
        netCcatCircuit.notifyChanged();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void spliceListenersInTrees(Map map, Map map2, SpliceLinkIndex spliceLinkIndex, SpliceLinkIndex spliceLinkIndex2, Object object, INetLink iNetLink, boolean bl, boolean bl2) {
        Object object2;
        TreeMap<SpliceListener, SpliceListener> treeMap = new TreeMap<SpliceListener, SpliceListener>(this.listenerComparator);
        INetLink iNetLink2 = null;
        InternalSpliceLink internalSpliceLink = null;
        boolean bl3 = true;
        if (object instanceof INetLink) {
            bl3 = true;
            iNetLink2 = (INetLink)object;
        } else if (object instanceof InternalSpliceLink) {
            bl3 = false;
            internalSpliceLink = (InternalSpliceLink)object;
        } else {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceListenersinTrees: ERROR-Invalid link object");
            }
            return;
        }
        if (map == null || map2 == null) {
            return;
        }
        if (NetCircuitSplicer.dbgOn()) {
            object2 = bl3 ? iNetLink2.prettyString() : internalSpliceLink.prettyString();
            NetCircuitSplicer.debug("spliceListenersinTrees for " + (String)object2);
        }
        object2 = map.values().iterator();
        while (object2.hasNext()) {
            Object object3;
            SpliceListenerEntry spliceListenerEntry;
            SpliceListener spliceListener;
            SpliceListener spliceListener2;
            Object object4;
            Object object5;
            IHoNum iHoNum;
            SpliceListener spliceListener3 = (SpliceListener)object2.next();
            Object object6 = (NetCcatCircuit)spliceListener3.node.getCircuit();
            ICircuitType iCircuitType = ((NetCircuit)object6).getCircuitTypeObj();
            treeMap.clear();
            if (bl3) {
                if (!iNetLink2.isValidSrcHoNumber(spliceListener3.hoNum)) {
                    if (!NetCircuitSplicer.dbgOn()) continue;
                    NetCircuitSplicer.debug("spliceListenersinTrees: Link does not support HO num" + spliceListener3.hoNum.getHoNum());
                    continue;
                }
                iHoNum = iNetLink2.getLinkType() == 2 ? iNetLink2.getDstHo() : spliceListener3.hoNum;
            } else {
                iHoNum = spliceListener3.hoNum;
            }
            if (spliceListener3.loAdit && this.aditListenerSuperceded(map, spliceListener3)) continue;
            if (bl3 && iNetLink2.isServerTrail()) {
                object5 = null;
                if (spliceListener3.loNum != null) {
                    object4 = ((ServerTrailLink)iNetLink2).getDstHoLo(spliceListener3.hoNum, spliceListener3.loNum);
                    iHoNum = object4.getHoNum();
                    object5 = object4.getLoNum();
                } else {
                    iHoNum = ((ServerTrailLink)iNetLink2).getDstHo(spliceListener3.hoNum);
                }
                spliceListener2 = new SpliceListener(iHoNum, (ILoNum)object5, 0, null, false);
            } else {
                spliceListener2 = new SpliceListener(iHoNum, spliceListener3.loNum, spliceListener3.optChannel, null, false);
            }
            while (true) {
                if ((spliceListener = (SpliceListener)this.findNextMatch(map2, treeMap, spliceListener2)) == null && spliceListener3.loNum == null && !spliceListener3.loAdit) {
                    spliceListener2.loNum = null;
                    spliceListener2.loAdit = true;
                    spliceListener = (SpliceListener)this.findNextMatch(map2, treeMap, spliceListener2);
                    if (spliceListener != null && spliceListener.loAdit && this.aditListenerSuperceded(map2, spliceListener)) continue;
                }
                if (spliceListener == null) {
                    if (!NetCircuitSplicer.dbgOn()) break;
                    spliceListenerEntry = new SpliceListenerEntry(spliceLinkIndex, spliceListener3);
                    NetCircuitSplicer.debug("spliceListenersinTrees: Could not find a match for " + spliceListenerEntry.prettyString());
                    NetCircuitSplicer.debug("dstTree: ");
                    object5 = map2.values();
                    object4 = object5.iterator();
                    while (object4.hasNext()) {
                        object3 = (SpliceListener)object4.next();
                        NetCircuitSplicer.debug(((SpliceListener)object3).prettyString());
                    }
                    break;
                }
                if (this.spliceCheck(spliceListener3, spliceListener, spliceListener3.loAdit || spliceListener.loAdit)) break;
                treeMap.put(spliceListener, spliceListener);
            }
            if (spliceListener == null || this.checkAndFabricateLoCircuits(spliceListener3, spliceListener)) continue;
            spliceListenerEntry = new SpliceListenerEntry(spliceLinkIndex, spliceListener3);
            SpliceListenerEntry spliceListenerEntry2 = new SpliceListenerEntry(spliceLinkIndex2, spliceListener);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Splicing listeners: " + spliceListenerEntry.prettyString() + " and " + spliceListenerEntry2.prettyString());
            }
            object5 = (NetCcatCircuit)spliceListener.node.getCircuit();
            object4 = ((NetCircuit)object5).getCircuitTypeObj();
            object3 = object6;
            synchronized (object3) {
                block106: {
                    NetCircuitSpan netCircuitSpan;
                    NetLinkSpan netLinkSpan;
                    Object object7;
                    NetCircuitNode netCircuitNode;
                    NetCircuitNode netCircuitNode2;
                    if (!spliceListener3.node.isNodeRefValid() || !spliceListener.node.isNodeRefValid()) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Node on ckt got deleted - skipping");
                        }
                        continue;
                    }
                    if (!bl3 && spliceListener3.node.getConnectionCircuitId().getUniquePart().getUniqueId() == 0) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Internal link for TL1 circuit:");
                            NetCircuitSplicer.debug("Circuit Type : " + iCircuitType.getProtocolIndepCktTypeStr());
                            NetCircuitSplicer.debug("listener node: " + spliceListener3.node.getName());
                            NetCircuitSplicer.debug("match node   : " + spliceListener.node.getName());
                            NetCircuitSplicer.debug("listner  : " + spliceListenerEntry.prettyString());
                            NetCircuitSplicer.debug("match index  : " + spliceListenerEntry2.prettyString());
                            NetCircuitSplicer.debug("Internal Link: " + internalSpliceLink.prettyString());
                        }
                        if (!iCircuitType.isSVLANType()) {
                            int n;
                            int n2;
                            IEntityModel iEntityModel;
                            IEntityModel iEntityModel2;
                            block103: {
                                netCircuitNode2 = spliceListenerEntry.spliceListener.node;
                                netCircuitNode = spliceListenerEntry2.spliceListener.node;
                                object7 = netCircuitNode2.getNodeModel();
                                IEntityTableModel iEntityTableModel = object7.getEntityTable();
                                iEntityModel2 = null;
                                iEntityModel = null;
                                n2 = spliceListenerEntry.spliceLinkIndex.entityIndex;
                                n = spliceListenerEntry2.spliceLinkIndex.entityIndex;
                                try {
                                    if (iEntityTableModel != null) {
                                        iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n2);
                                        iEntityModel = iEntityTableModel.getEntityModelByIndex(n);
                                    }
                                }
                                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                                    if (!db.on()) break block103;
                                    db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
                                }
                            }
                            boolean bl4 = false;
                            boolean bl5 = false;
                            bl4 = Feature.provides((INodeModel)object7, (Feature)Feature.OTU2_XP) && OchTrailHelper.isTrunkPort(netCircuitNode2.getNodeModel(), n2) && iEntityModel2 != null && iEntityModel2.getModuleModel().getEqType() == 293 && ((IDwdmPortModel)iEntityModel2).getRegenPeerLineModel() != null;
                            boolean bl6 = bl5 = Feature.provides((INodeModel)object7, (Feature)Feature.OTU2_XP) && OchTrailHelper.isTrunkPort(netCircuitNode.getNodeModel(), n) && iEntityModel != null && iEntityModel.getModuleModel().getEqType() == 293 && ((IDwdmPortModel)iEntityModel).getRegenPeerLineModel() != null;
                            if (bl4 || bl5) {
                                if (this.addInternalTL1TunnelEnd(spliceListenerEntry, spliceListenerEntry2, internalSpliceLink, bl, bl2)) {
                                    object2.remove();
                                    spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                                    map2.remove(spliceListener);
                                    spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                                }
                                continue;
                            }
                        }
                    }
                    if (object6 != object5) {
                        if (!this.spliceAllowed(spliceListener3.node, spliceListener.node)) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Splice match for two non-null circuits. Skipping");
                            }
                            continue;
                        }
                        if (!(spliceListener3.loAdit || spliceListener.loAdit || this.passedTwoConnsSameNECheck((INetCircuit)object6, (INetCircuit)object5))) {
                            continue;
                        }
                        if (bl3 && !iNetLink2.isLAP()) {
                            if (iCircuitType.isLAPCircuitType()) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Splicer: Extending existing TL1-LAP circuit");
                                }
                                ((NetCcatCircuit)object6).checkAndUpdateCircuit();
                            }
                            if (object4.isLAPCircuitType()) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Splicer: Extending existing TL1-LAP circuit");
                                }
                                ((NetCcatCircuit)object5).checkAndUpdateCircuit();
                            }
                        }
                        if (!bl3 && CircuitMergeManager.isCktInMerge((INetCircuit)object6) && CircuitMergeManager.isCktInMerge((INetCircuit)object5) && (iCircuitType.isOchTrailTunnelCircuitType() || iCircuitType.isOchncType())) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Internal splicing: xconns from different circuits.");
                            }
                            netCircuitNode2 = spliceListener3.node;
                            netCircuitNode = spliceListener.node;
                            object7 = new InternalNetLink(netCircuitNode2.getNetElement(), netCircuitNode.getNetElement(), internalSpliceLink.srcEntityIndex, internalSpliceLink.dstEntityIndex, spliceListener3.hoNum, spliceListener.hoNum);
                            netLinkSpan = new NetLinkSpan((INetLink)object7, null, spliceListener3.hoNum, iHoNum, spliceListener3.loNum);
                            netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((INetCircuit)object6, netLinkSpan, netCircuitNode2, netCircuitNode);
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Created the internal splicing span");
                            }
                            netCircuitSpan.setSrcState(4);
                            netCircuitSpan.setDstState(4);
                            spliceListener3.node.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
                            spliceListener.node.addActiveSpan(netCircuitSpan, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Successfully added active internal splicing span");
                            }
                            try {
                                this.completeSplice(spliceListener3.node, spliceListener.node);
                            }
                            catch (AbstractCmsIOException abstractCmsIOException) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Exception on complete check! Undoing " + (Object)((Object)abstractCmsIOException));
                                }
                                spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                                spliceListener.node.disposeActiveSpan(netCircuitSpan);
                                netCircuitSpan.dispose();
                                continue;
                            }
                            catch (IllegalStateException illegalStateException) {
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Exception on unify! Undoing " + illegalStateException);
                                }
                                spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                                spliceListener.node.disposeActiveSpan(netCircuitSpan);
                                netCircuitSpan.dispose();
                                continue;
                            }
                        }
                    } else {
                        if (!bl3) {
                            block105: {
                                if (iCircuitType.isOchTrailTunnelCircuitType() || iCircuitType.isOchncType() || iCircuitType.isSVLANType()) {
                                    if (NetCircuitSplicer.dbgOn()) {
                                        NetCircuitSplicer.debug("Internal splicing: Both xconns from same circuit.");
                                    }
                                    netCircuitNode2 = spliceListener3.node;
                                    netCircuitNode = spliceListener.node;
                                    if (netCircuitNode2.isOchTrailTunnelNode() && netCircuitNode.isOchTrailTunnelNode() && (!bl || !bl2)) {
                                        continue;
                                    }
                                    object7 = new InternalNetLink(netCircuitNode2.getNetElement(), netCircuitNode.getNetElement(), internalSpliceLink.srcEntityIndex, internalSpliceLink.dstEntityIndex, spliceListener3.hoNum, spliceListener.hoNum);
                                    netLinkSpan = new NetLinkSpan((INetLink)object7, null, spliceListener3.hoNum, iHoNum, spliceListener3.loNum);
                                    netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((INetCircuit)object6, netLinkSpan, netCircuitNode2, netCircuitNode);
                                    if (iCircuitType.isSVLANType()) {
                                        if (NetCircuitSplicer.dbgOn()) {
                                            NetCircuitSplicer.debug("Set ckt node internal points");
                                        }
                                        ((SvlanCircuitNode)netCircuitNode2).setInternalEntityIdx(internalSpliceLink.srcEntityIndex);
                                        ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(internalSpliceLink.dstEntityIndex);
                                    }
                                    if (NetCircuitSplicer.dbgOn()) {
                                        NetCircuitSplicer.debug("Created the internal splicing span");
                                    }
                                    netCircuitSpan.setSrcState(4);
                                    netCircuitSpan.setDstState(4);
                                    spliceListener3.node.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
                                    spliceListener.node.addActiveSpan(netCircuitSpan, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
                                    if (NetCircuitSplicer.dbgOn()) {
                                        NetCircuitSplicer.debug("Successfully added active internal splicing span");
                                    }
                                    try {
                                        this.completeSplice(spliceListener3.node, spliceListener.node);
                                        break block105;
                                    }
                                    catch (AbstractCmsIOException abstractCmsIOException) {
                                        if (NetCircuitSplicer.dbgOn()) {
                                            NetCircuitSplicer.debug("Exception on complete check! Undoing " + (Object)((Object)abstractCmsIOException));
                                        }
                                        spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                                        spliceListener.node.disposeActiveSpan(netCircuitSpan);
                                        netCircuitSpan.dispose();
                                        continue;
                                    }
                                    catch (IllegalStateException illegalStateException) {
                                        if (NetCircuitSplicer.dbgOn()) {
                                            NetCircuitSplicer.debug("Exception on unify! Undoing " + illegalStateException);
                                        }
                                        spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                                        spliceListener.node.disposeActiveSpan(netCircuitSpan);
                                        netCircuitSpan.dispose();
                                        continue;
                                    }
                                }
                                if (NetCircuitSplicer.dbgOn()) {
                                    NetCircuitSplicer.debug("Internal splicing cancelled : Both xconns from same circuit.");
                                }
                            }
                            object2.remove();
                            spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                            map2.remove(spliceListener);
                            spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                            continue;
                        }
                        if (iCircuitType.isTunnelCircuitType() && iNetLink2.isLOTunnel()) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Attempt to splice LOT ckt with LOT link. Skipping...");
                            }
                            continue;
                        }
                        if (iCircuitType.isLAPCircuitType() && iNetLink2.isLAP()) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Attempt to splice LAP ckt with LAP net link. Skipping...");
                            }
                            continue;
                        }
                        if (iCircuitType.isOchTrailTunnelCircuitType() && iNetLink2 instanceof OchTrailTunnelNetLink) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Attempt to splice OTT ckt with OTT net link. Skipping...");
                            }
                            continue;
                        }
                        if (this.alreadyConnected(spliceListener3.node, spliceListener.node)) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Two nodes have already connected.");
                            }
                            continue;
                        }
                    }
                    if (!((NetCircuit)object6).isCircuitRefValid()) {
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Splicer: Circuit got destroyed. Skipping");
                        }
                        continue;
                    }
                    if (spliceListener3.loAdit || spliceListener.loAdit) {
                        if (bl3 && (iNetLink2.isLAP() || iNetLink2.isLOTunnel() || iNetLink2.isOchTrailTunnel())) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Skipping LoAdit listener on tunnel links");
                            }
                            continue;
                        }
                        if (this.spliceTl1TunnelEnd(spliceListenerEntry, spliceListenerEntry2, object, iNetLink, bl, bl2)) {
                            object2.remove();
                            spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                            map2.remove(spliceListener);
                            spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                        }
                        continue;
                    }
                    object2.remove();
                    spliceListener3.node.removeSpliceListener(spliceListenerEntry);
                    map2.remove(spliceListener);
                    spliceListener.node.removeSpliceListener(spliceListenerEntry2);
                    if (bl3) {
                        netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink, spliceListener3.hoNum, iHoNum, spliceListener3.loNum);
                        netCircuitNode2 = ((NetCcatCircuit)object6).getDualConnectionCircuitNode(spliceListener3.node);
                        netCircuitNode = ((NetCcatCircuit)object6).getDualConnectionCircuitNode(spliceListener.node);
                        if (netCircuitNode2 == null) {
                            netCircuitNode2 = spliceListener3.node;
                        }
                        if (netCircuitNode == null) {
                            netCircuitNode = spliceListener.node;
                        }
                        netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((INetCircuit)object6, netLinkSpan, netCircuitNode2, netCircuitNode);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Created the splicing span");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        if (netCircuitSpan instanceof LoCircuitSpan) {
                            this.updateSpanYState(spliceListener3, spliceListener, (LoCircuitSpan)netCircuitSpan);
                        }
                        if (bl && bl2 && ((NetCcatCircuit)object6).isBiDirSpanKnown(netCircuitSpan)) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Span already present in circuit. Skipping");
                            }
                            continue;
                        }
                        spliceListener3.node.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
                        spliceListener.node.addActiveSpan(netCircuitSpan, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Successfully added active splicing span");
                        }
                        try {
                            this.completeSplice(spliceListener3.node, spliceListener.node);
                            this.unifyYCircuits(spliceListener3, spliceListener);
                            break block106;
                        }
                        catch (AbstractCmsIOException abstractCmsIOException) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception on complete check! Undoing " + (Object)((Object)abstractCmsIOException));
                            }
                            spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                            spliceListener.node.disposeActiveSpan(netCircuitSpan);
                            netCircuitSpan.dispose();
                            continue;
                        }
                        catch (IllegalStateException illegalStateException) {
                            if (NetCircuitSplicer.dbgOn()) {
                                NetCircuitSplicer.debug("Exception on unify! Undoing " + illegalStateException);
                            }
                            spliceListener3.node.disposeActiveSpan(netCircuitSpan);
                            spliceListener.node.disposeActiveSpan(netCircuitSpan);
                            netCircuitSpan.dispose();
                            continue;
                        }
                    }
                    if (iCircuitType.isSVLANType()) {
                        netCircuitNode2 = spliceListener3.node;
                        netCircuitNode = spliceListener.node;
                        object7 = new InternalNetLink(netCircuitNode2.getNetElement(), netCircuitNode.getNetElement(), internalSpliceLink.srcEntityIndex, internalSpliceLink.dstEntityIndex, null, null);
                        netLinkSpan = new NetLinkSpan((INetLink)object7, null, null, null, null);
                        netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan((INetCircuit)object6, netLinkSpan, netCircuitNode2, netCircuitNode);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Set ckt node internal points");
                        }
                        ((SvlanCircuitNode)netCircuitNode2).setInternalEntityIdx(internalSpliceLink.srcEntityIndex);
                        ((SvlanCircuitNode)netCircuitNode).setInternalEntityIdx(internalSpliceLink.dstEntityIndex);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Created the internal splicing span");
                        }
                        netCircuitSpan.setSrcState(4);
                        netCircuitSpan.setDstState(4);
                        spliceListener3.node.addActiveSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                        spliceListener.node.addActiveSpan(netCircuitSpan, eSpanDirection.BIDIRECTIONAL);
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("Successfully added active internal splicing span");
                        }
                        this.completeSplice(spliceListener3.node, spliceListener.node);
                    } else if (CircuitMergeManager.isCktInMerge((INetCircuit)object6) && CircuitMergeManager.isCktInMerge((INetCircuit)object5)) {
                        this.completeSplice(spliceListener3.node, spliceListener.node);
                    } else {
                        ((NetCcatCircuit)object6).unify((NetCcatCircuit)object5);
                    }
                }
            }
            if (!((NetCircuit)object5).isCircuitRefValid()) {
                ((NetCcatCircuit)object5).notifyDeleted();
            } else if (!((NetCircuit)object6).isCircuitRefValid()) {
                ((NetCcatCircuit)object6).notifyDeleted();
                object6 = object5;
            }
            ((NetCcatCircuit)object6).notifyChanged();
            if (((NetCircuit)object6).getState() != 1 || !iCircuitType.isTunnelCircuitType()) continue;
            this.spliceListenersInTrees(map, map2, spliceLinkIndex, spliceLinkIndex2, ((NetCcatCircuit)object6).getLotLink(), ((NetCcatCircuit)object6).getReverseLotLink(), bl, bl2);
            this.spliceListenersInTrees(map, map2, spliceLinkIndex, spliceLinkIndex2, iNetLink2, iNetLink, bl, bl2);
            break;
        }
    }

    private boolean aditListenerSuperceded(Map map, SpliceListener spliceListener) {
        SpliceListener spliceListener2 = new SpliceListener(spliceListener.hoNum, null, spliceListener.optChannel, null, false);
        if (this.findNextMatch(map, null, spliceListener2) != null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Matching HO listener for adit found;  (Skipping the Adit Listener) ");
            }
            return true;
        }
        return false;
    }

    protected boolean passedTwoConnsSameNECheck(INetCircuit iNetCircuit, INetCircuit iNetCircuit2) {
        INetElement iNetElement = null;
        for (NetCircuitNode netCircuitNode : iNetCircuit.getCircuitNodes()) {
            if (iNetCircuit2.getCircuitNodeFromNE(netCircuitNode.getNetElement()) == null) continue;
            iNetElement = netCircuitNode.getNetElement();
            break;
        }
        if (iNetElement != null) {
            NetCircuitNode netCircuitNode;
            netCircuitNode = iNetCircuit.getCircuitTypeObj();
            if (!(netCircuitNode.isHoCircuitType() || netCircuitNode.isLAPCircuitType() || netCircuitNode.isOchncType() || netCircuitNode.isOchTrailTunnelCircuitType() || netCircuitNode.isSVLANType())) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splice skipped: Circuit type does not support 2 conns on same NE");
                }
                return false;
            }
            List list = iNetCircuit.getCircuitNodeFromNE(iNetElement);
            NetCircuitNode netCircuitNode22 = null;
            for (int i = 0; i < 2; ++i) {
                if (list != null) {
                    for (NetCircuitNode netCircuitNode22 : list) {
                        if (!netCircuitNode22.hasDualConnections()) continue;
                        if (NetCircuitSplicer.dbgOn()) {
                            NetCircuitSplicer.debug("splice skipped: already has 2 conns on same NE");
                        }
                        return false;
                    }
                }
                list = iNetCircuit2.getCircuitNodeFromNE(iNetElement);
            }
        }
        return true;
    }

    private void spliceLapListenerInSrcTree(Map map, SpliceLinkIndex spliceLinkIndex, INetLink iNetLink, INetLink iNetLink2, boolean bl) {
        NetCircuitNode netCircuitNode = null;
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("spliceLapListenerInSrcTree for " + iNetLink.prettyString());
        }
        if (!iNetLink.isLAP()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("called for non- lap link");
            }
            return;
        }
        if (map == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Source tree is null!");
            }
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            SpliceListener spliceListener = (SpliceListener)iterator.next();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("considering splice listener " + spliceListener.prettyString());
            }
            if (!iNetLink.isValidSrcHoNumber(spliceListener.hoNum)) continue;
            if (spliceListener.loNum == null) {
                if (!NetCircuitSplicer.dbgOn()) continue;
                NetCircuitSplicer.debug("skipping over this listener");
                continue;
            }
            IHoNum iHoNum = iNetLink.getDstHo();
            NetCircuitNode netCircuitNode2 = spliceListener.node;
            LoCcatCircuit loCcatCircuit = (LoCcatCircuit)netCircuitNode2.getCircuit();
            List list = loCcatCircuit.getCircuitNodeFromNE(iNetLink.getDst());
            if (list != null) {
                if (list.size() > 1 && NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Error !! MXPN at LAP end of this circuit");
                }
                netCircuitNode = (NetCircuitNode)list.get(0);
            } else {
                netCircuitNode = null;
            }
            boolean bl2 = false;
            if (netCircuitNode == null) {
                if (loCcatCircuit.circuitInfoActive()) {
                    int n = 0;
                    Iterator iterator2 = loCcatCircuit.getDropCktEnds().iterator();
                    for (int i = 0; i < 2; ++i) {
                        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)iterator2.next();
                        if (netCircuitEnd.getNetElement() != iNetLink.getDst()) {
                            ++n;
                        }
                        iterator2 = loCcatCircuit.getSources().iterator();
                    }
                    if (n == loCcatCircuit.getDrops().size() + loCcatCircuit.getSources().size()) continue;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("circuit node on LAP HO grooming end not found, creating one");
                }
                HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)((NetLink)iNetLink).getLotCircuit();
                netCircuitNode = loCcatCircuit.createLapHoCircuitNode(hoCcatCircuit, iNetLink.getDst(), iNetLink.getDstEntityIndex(), iNetLink.getDstHo(), spliceListener.loNum, false);
                bl2 = true;
            }
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, spliceListener.hoNum, iHoNum, spliceListener.loNum);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(loCcatCircuit, netLinkSpan, netCircuitNode2, netCircuitNode);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Adding active spans to the circuit");
            }
            netCircuitNode2.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
            netCircuitNode.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("removing splice listener");
            }
            netCircuitNode2.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex, spliceListener));
            if (bl2) {
                loCcatCircuit.lapNodeCreated(netCircuitNode);
            }
            iterator.remove();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceLapListenerInSrcTree: check circuit's completeness");
            }
            if (loCcatCircuit.circuitInfoActive()) {
                loCcatCircuit.completeCheck();
            } else {
                loCcatCircuit.tl1CircuitCompleteCheck();
            }
            loCcatCircuit.notifyChanged();
        }
    }

    private void spliceLapListenerInDstTree(Map map, SpliceLinkIndex spliceLinkIndex, INetLink iNetLink, INetLink iNetLink2, boolean bl) {
        NetCircuitNode netCircuitNode = null;
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("spliceLapListenerInDstTree for " + iNetLink.prettyString());
        }
        if (!iNetLink.isLAP()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("called for non- lap link");
            }
            return;
        }
        if (map == null) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Destination tree is null!");
            }
            return;
        }
        Iterator iterator = map.values().iterator();
        while (iterator.hasNext()) {
            SpliceListener spliceListener = (SpliceListener)iterator.next();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("considering splice listener " + spliceListener.prettyString());
            }
            if (!iNetLink.isValidDstHoNumber(spliceListener.hoNum)) continue;
            if (spliceListener.loNum == null) {
                if (!NetCircuitSplicer.dbgOn()) continue;
                NetCircuitSplicer.debug("skipping over this listener");
                continue;
            }
            IHoNum iHoNum = iNetLink.getSrcHo();
            NetCircuitNode netCircuitNode2 = spliceListener.node;
            LoCcatCircuit loCcatCircuit = (LoCcatCircuit)netCircuitNode2.getCircuit();
            List list = loCcatCircuit.getCircuitNodeFromNE(iNetLink.getSrc());
            if (list != null) {
                if (list.size() > 1 && NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Error !! MXPN at LAP end of this circuit");
                }
                netCircuitNode = (NetCircuitNode)list.get(0);
            } else {
                netCircuitNode = null;
            }
            boolean bl2 = false;
            if (netCircuitNode == null) {
                if (loCcatCircuit.circuitInfoActive() && ((NetCircuitEnd)loCcatCircuit.getSources().get(0)).getNetElement() != iNetLink.getSrc() && ((NetCircuitDropInfo)loCcatCircuit.getDrops().get(0)).getNetElement() != iNetLink.getSrc()) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("circuit node on LAP HO grooming end not found, creating one");
                }
                HoCcatCircuit hoCcatCircuit = (HoCcatCircuit)((NetLink)iNetLink).getLotCircuit();
                netCircuitNode = loCcatCircuit.createLapHoCircuitNode(hoCcatCircuit, iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), iNetLink.getSrcHo(), spliceListener.loNum, true);
                bl2 = true;
            }
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, iHoNum, spliceListener.hoNum, spliceListener.loNum);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(loCcatCircuit, netLinkSpan, netCircuitNode, netCircuitNode2);
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Adding active spans to the circuit");
            }
            netCircuitNode2.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
            netCircuitNode.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("removing splice listener");
            }
            netCircuitNode2.removeSpliceListener(new SpliceListenerEntry(spliceLinkIndex, spliceListener));
            if (bl2) {
                loCcatCircuit.lapNodeCreated(netCircuitNode);
            }
            iterator.remove();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("spliceLapListenerInDstTree: check circuit's completeness");
            }
            if (loCcatCircuit.circuitInfoActive()) {
                loCcatCircuit.completeCheck();
            } else {
                loCcatCircuit.tl1CircuitCompleteCheck();
            }
            loCcatCircuit.notifyChanged();
        }
    }

    protected void completeSplice(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        NetCcatCircuit netCcatCircuit = (NetCcatCircuit)netCircuitNode.getCircuit();
        NetCcatCircuit netCcatCircuit2 = (NetCcatCircuit)netCircuitNode2.getCircuit();
        NetCcatCircuit netCcatCircuit3 = (NetCcatCircuit)netCircuitNode.getCircuit();
        if (!netCcatCircuit.circuitInfoActive() && netCcatCircuit2.circuitInfoActive()) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Unify: swapping source ckt " + NetCcatCircuit.prettyString(netCcatCircuit.getCircuitId()) + " with matchCkt " + NetCcatCircuit.prettyString(netCcatCircuit2.getCircuitId()));
            }
            netCcatCircuit = netCcatCircuit2;
            netCcatCircuit2 = netCcatCircuit3;
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("After the SWAP: source ckt " + NetCcatCircuit.prettyString(netCcatCircuit.getCircuitId()) + " with matchCkt " + NetCcatCircuit.prettyString(netCcatCircuit2.getCircuitId()));
            }
        }
        if (netCcatCircuit != netCcatCircuit2) {
            if (!netCcatCircuit.unify(netCcatCircuit2)) {
                throw new IllegalStateException("The circuits could not be unified.");
            }
        } else {
            this.checkCircuitComplete(netCcatCircuit);
            netCcatCircuit.notifyChanged();
        }
    }

    protected boolean alreadyConnected(NetCircuitNode netCircuitNode, NetCircuitNode netCircuitNode2) {
        return false;
    }

    protected void checkCircuitComplete(NetCcatCircuit netCcatCircuit) {
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Check circuit's completeness");
        }
        if (!netCcatCircuit.circuitInfoActive()) {
            if (!netCcatCircuit.tl1CircuitCompleteCheck()) {
                netCcatCircuit.checkAndUpdateCircuit();
            }
        } else {
            netCcatCircuit.completeCheck();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void generateCallbacks() {
        NetCircuitSplicer netCircuitSplicer = this;
        synchronized (netCircuitSplicer) {
            Map map;
            SpliceLinkIndex spliceLinkIndex;
            Map map2;
            SpliceLinkIndex spliceLinkIndex2;
            Map map3;
            SpliceLinkIndex spliceLinkIndex3;
            Map map4;
            SpliceLinkIndex spliceLinkIndex4;
            this.synchronizeSpliceListeners();
            this.synchronizeCallbackLinks();
            while (this.callbackLinks.size() != 0) {
                INetLink iNetLink;
                INetLink iNetLink2;
                block36: {
                    try {
                        iNetLink2 = (INetLink)this.callbackLinks.first();
                        if (!this.callbackLinks.remove(iNetLink2)) {
                            if (!NetCircuitSplicer.dbgOn()) break;
                            NetCircuitSplicer.debug("Splicer: WARNING! - Unable to remove Link from callbackLinks");
                            NetCircuitSplicer.debug(iNetLink2.prettyString());
                        }
                        break block36;
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        if (!NetCircuitSplicer.dbgOn()) break;
                        NetCircuitSplicer.debug("Splicer: Link disappeared from callbackLinks unexpectedly");
                    }
                    break;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: Considering network link: ");
                    NetCircuitSplicer.debug(iNetLink2.prettyString());
                }
                if (this.hasNullTdmReverseLink(iNetLink2, iNetLink = Network.instance().findReverseLink(iNetLink2))) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: WARNING-Reverse link not found; aborting...");
                    }
                    return;
                }
                spliceLinkIndex4 = new SpliceLinkIndex(iNetLink2.getSrc(), iNetLink2.getSrcEntityIndex(), eSpanDirection.ORIGINATING);
                map4 = (Map)this.linkEntries.get(spliceLinkIndex4);
                spliceLinkIndex3 = new SpliceLinkIndex(iNetLink2.getDst(), iNetLink2.getDstEntityIndex(), eSpanDirection.TERMINATING);
                map3 = (Map)this.linkEntries.get(spliceLinkIndex3);
                spliceLinkIndex2 = new SpliceLinkIndex(iNetLink2.getSrc(), iNetLink2.getSrcEntityIndex(), eSpanDirection.BIDIRECTIONAL);
                map2 = (Map)this.linkEntries.get(spliceLinkIndex2);
                spliceLinkIndex = new SpliceLinkIndex(iNetLink2.getDst(), iNetLink2.getDstEntityIndex(), eSpanDirection.BIDIRECTIONAL);
                map = (Map)this.linkEntries.get(spliceLinkIndex);
                if (map4 != null && map3 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->termTree");
                    }
                    this.spliceListenersInTrees(map4, map3, spliceLinkIndex4, spliceLinkIndex3, iNetLink2, iNetLink, false, false);
                }
                if (map2 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map2, map, spliceLinkIndex2, spliceLinkIndex, iNetLink2, iNetLink, true, true);
                }
                if (map4 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map4, map, spliceLinkIndex4, spliceLinkIndex, iNetLink2, iNetLink, false, true);
                }
                if (map2 != null && map3 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->termTree");
                    }
                    this.spliceListenersInTrees(map2, map3, spliceLinkIndex2, spliceLinkIndex3, iNetLink2, iNetLink, true, false);
                }
                if (!iNetLink2.isLAP()) continue;
                if (map2 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->");
                    }
                    this.spliceLapListenerInSrcTree(map2, spliceLinkIndex2, iNetLink2, iNetLink, true);
                }
                if (map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: -->dstBiTree");
                    }
                    this.spliceLapListenerInDstTree(map, spliceLinkIndex, iNetLink2, iNetLink, true);
                }
                if (map4 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->");
                    }
                    this.spliceLapListenerInSrcTree(map4, spliceLinkIndex4, iNetLink2, iNetLink, false);
                }
                if (map3 == null) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: -->termTree");
                }
                this.spliceLapListenerInDstTree(map3, spliceLinkIndex3, iNetLink2, iNetLink, false);
            }
            while (this.callbackIntLinks.size() != 0) {
                InternalSpliceLink internalSpliceLink;
                try {
                    internalSpliceLink = (InternalSpliceLink)this.callbackIntLinks.first();
                    this.callbackIntLinks.remove(internalSpliceLink);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    if (!NetCircuitSplicer.dbgOn()) break;
                    NetCircuitSplicer.debug("Splicer: intLink disappeared from callbackIntLinks unexpectedly");
                    break;
                }
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: Considering internal splice link: ");
                    NetCircuitSplicer.debug(internalSpliceLink.prettyString());
                }
                spliceLinkIndex4 = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.srcEntityIndex, eSpanDirection.ORIGINATING);
                map4 = (Map)this.linkEntries.get(spliceLinkIndex4);
                spliceLinkIndex3 = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.dstEntityIndex, eSpanDirection.TERMINATING);
                map3 = (Map)this.linkEntries.get(spliceLinkIndex3);
                spliceLinkIndex2 = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.srcEntityIndex, eSpanDirection.BIDIRECTIONAL);
                map2 = (Map)this.linkEntries.get(spliceLinkIndex2);
                spliceLinkIndex = new SpliceLinkIndex(internalSpliceLink.ne, internalSpliceLink.dstEntityIndex, eSpanDirection.BIDIRECTIONAL);
                map = (Map)this.linkEntries.get(spliceLinkIndex);
                if (map4 != null && map3 != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->termTree");
                    }
                    this.spliceListenersInTrees(map4, map3, spliceLinkIndex4, spliceLinkIndex3, internalSpliceLink, null, false, false);
                }
                if (map2 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: srcBiTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map2, map, spliceLinkIndex2, spliceLinkIndex, internalSpliceLink, null, true, true);
                }
                if (map4 != null && map != null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("Splicer: origTree-->dstBiTree");
                    }
                    this.spliceListenersInTrees(map4, map, spliceLinkIndex4, spliceLinkIndex, internalSpliceLink, null, false, true);
                }
                if (map2 == null || map3 == null) continue;
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Splicer: srcBiTree-->termTree");
                }
                this.spliceListenersInTrees(map2, map3, spliceLinkIndex2, spliceLinkIndex3, internalSpliceLink, null, true, false);
            }
        }
    }

    protected Object findNextMatch(Map map, Map map2, Object object) {
        TreeSet treeSet = new TreeSet(this.listenerComparator);
        TreeSet<Object> treeSet2 = new TreeSet<Object>(this.listenerComparator);
        treeSet.addAll(map.values());
        if (map2 != null) {
            treeSet.removeAll(map2.values());
        }
        treeSet2.add(object);
        treeSet.retainAll(treeSet2);
        try {
            Object e = treeSet.first();
            return e;
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof Network.NetLinkCreationNotifier) {
            if (object instanceof INetLink) {
                INetLink iNetLink = (INetLink)object;
                if (db.on()) {
                    NetCircuitSplicer.debug("update: received notification about new NL " + iNetLink.prettyString());
                }
                this.newNetLink(iNetLink);
            }
        } else if (observable instanceof INetLink) {
            if (object == ModelUpdateType.DELETED) {
                INetLink iNetLink = (INetLink)((Object)observable);
                if (db.on()) {
                    NetCircuitSplicer.debug("NetLink deleted " + iNetLink.prettyString());
                }
                this.deleteNetLink(iNetLink);
            } else if (object == ModelUpdateType.CHANGED) {
                INetLink iNetLink = (INetLink)((Object)observable);
                if (db.on()) {
                    NetCircuitSplicer.debug("NetLink changed " + iNetLink.prettyString());
                }
                this.changeNetLink(iNetLink);
            }
        }
    }

    public void dispose() {
        this.spliceTreeDump.dispose();
        for (INetLink iNetLink : this.callbackLinks) {
            iNetLink.deleteObserver(this);
        }
        for (INetLink iNetLink : this.callbackLinksHolder) {
            iNetLink.deleteObserver(this);
        }
    }

    private boolean hasNullTdmReverseLink(INetLink iNetLink, INetLink iNetLink2) {
        return !(iNetLink instanceof DwdmNetLink) && iNetLink2 == null;
    }

    protected TreeMap createTreeMapWithListenerComparator() {
        return new TreeMap(this.listenerComparator);
    }

    protected static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected static void debug(String string) {
        db.println(string);
    }

    private boolean checkHoAditYCondition(SpliceListener spliceListener, SpliceListener spliceListener2) {
        SpliceListener spliceListener3 = spliceListener.loAdit ? spliceListener2 : spliceListener;
        SpliceListener spliceListener4 = spliceListener.loAdit ? spliceListener : spliceListener2;
        INetCircuit iNetCircuit = spliceListener3.node.getCircuit();
        INetCircuit iNetCircuit2 = spliceListener4.node.getCircuit();
        if (!(iNetCircuit instanceof HoCcatCircuit)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("y circuit algorithm called for non supported circuit types, returning..");
            }
            return false;
        }
        int n = ((HoCcatCircuit)iNetCircuit).getYState();
        if (0 == n) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("No Y Circuit configuration detected");
            }
            return false;
        }
        if (3 == n) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Lo fabrication already done for this Y-circuit, ignoring...");
            }
            return true;
        }
        if (1 == n) {
            IConnectionModel iConnectionModel = spliceListener4.node.getConn();
            ILoDefModel[] iLoDefModelArray = ((ILoConnectionModel)iConnectionModel).getActivePaths();
            int n2 = iLoDefModelArray[0].getLoPathWidth();
            ICircuitSize iCircuitSize = CircuitSize.width2sizeOfLoCircuit((int)n2);
            ((HoCcatCircuit)iNetCircuit).setContainedLoSize(iCircuitSize);
            ICircuitType iCircuitType = iNetCircuit2.getCircuitTypeObj();
            ((HoCcatCircuit)iNetCircuit).setContainedLoType(iCircuitType);
            this.fabricateLoOnCircuit(spliceListener3);
            return true;
        }
        if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("Should never reach here, critical error...");
        }
        return false;
    }

    private void checkHoHoYCondition(SpliceListener spliceListener, SpliceListener spliceListener2) {
        INetCircuit iNetCircuit;
        INetCircuit iNetCircuit2;
        SpliceListener spliceListener3;
        SpliceListener spliceListener4;
        INetCircuit iNetCircuit3 = spliceListener.node.getCircuit();
        INetCircuit iNetCircuit4 = spliceListener2.node.getCircuit();
        if (!(iNetCircuit3 instanceof HoCcatCircuit) || !(iNetCircuit4 instanceof HoCcatCircuit)) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("y circuit algorithm called for non supported circuit types, returning...");
            }
            return;
        }
        int n = ((HoCcatCircuit)iNetCircuit3).getYState();
        int n2 = ((HoCcatCircuit)iNetCircuit4).getYState();
        if (0 == n && 0 == n2) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Both Ho circuits are Y Unlikely, processing normal splicing");
            }
            return;
        }
        if (1 == n && 1 == n2) {
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Both Ho circuits are Y Tentative, processing normal splicing");
            }
            return;
        }
        if (0 == n && 1 == n2 || 0 == n2 && 1 == n) {
            spliceListener4 = 0 == n ? spliceListener2 : spliceListener;
            SpliceListener spliceListener5 = spliceListener3 = 0 == n ? spliceListener : spliceListener2;
            if (spliceListener3.node.getCircuit().getCircuitTypeObj().isLAPCircuitType()) {
                iNetCircuit2 = spliceListener4.node.getCircuit();
                iNetCircuit = spliceListener3.node.getCircuit();
                ((HoCcatCircuit)iNetCircuit2).setContainedLoSize(((HoCcatCircuit)iNetCircuit).getContainedLoSize());
                ((HoCcatCircuit)iNetCircuit2).setContainedLoType(((HoCcatCircuit)iNetCircuit).getContainedLoType());
                this.fabricateLoOnCircuit(spliceListener4);
                this.disposeLTN(spliceListener3);
                this.fabricateLoOnCircuit(spliceListener3);
            }
        }
        if (0 == n && 3 == n2 || 0 == n2 && 3 == n) {
            spliceListener4 = 0 == n ? spliceListener : spliceListener2;
            spliceListener3 = 0 == n ? spliceListener2 : spliceListener;
            iNetCircuit2 = spliceListener3.node.getCircuit();
            iNetCircuit = spliceListener4.node.getCircuit();
            ((HoCcatCircuit)iNetCircuit).setContainedLoSize(((HoCcatCircuit)iNetCircuit2).getContainedLoSize());
            ((HoCcatCircuit)iNetCircuit).setContainedLoType(((HoCcatCircuit)iNetCircuit2).getContainedLoType());
            if (spliceListener4.node.getCircuit().getCircuitTypeObj().isLAPCircuitType()) {
                this.disposeLTN(spliceListener4);
                spliceListener4.node.getCircuit().setCircuitType(spliceListener3.node.getCircuit().getCircuitType());
            }
            this.fabricateLoOnCircuit(spliceListener4);
        }
        if (3 == n && 1 == n2 || 3 == n2 && 1 == n) {
            spliceListener4 = 1 == n ? spliceListener : spliceListener2;
            spliceListener3 = 1 == n ? spliceListener2 : spliceListener;
            iNetCircuit2 = spliceListener4.node.getCircuit();
            iNetCircuit = spliceListener3.node.getCircuit();
            ((HoCcatCircuit)iNetCircuit2).setContainedLoSize(((HoCcatCircuit)iNetCircuit).getContainedLoSize());
            ((HoCcatCircuit)iNetCircuit2).setContainedLoType(((HoCcatCircuit)iNetCircuit).getContainedLoType());
            this.fabricateLoOnCircuit(spliceListener4);
        }
    }

    private void disposeLTN(SpliceListener spliceListener) {
        IConnectionModel iConnectionModel;
        NetCircuitNode netCircuitNode;
        Iterator iterator = spliceListener.node.getCircuit().getCircuitNodes().iterator();
        ArrayList<IConnectionModel> arrayList = new ArrayList<IConnectionModel>();
        while (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            if (!(netCircuitNode instanceof LoTunnelNode)) continue;
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("Disposing LTN connection on node: " + netCircuitNode.getName());
            }
            iConnectionModel = netCircuitNode.getConn();
            arrayList.add(iConnectionModel);
            ((NetCcatCircuit)spliceListener.node.getCircuit()).disposeLTN(netCircuitNode);
        }
        NetCircuitWatchDog.instance().discoverCircuitFromConnectionList(arrayList);
        iterator = spliceListener.node.getCircuit().getCircuitNodes().iterator();
        if (iterator.hasNext()) {
            netCircuitNode = (NetCircuitNode)iterator.next();
            iConnectionModel = netCircuitNode.getNetElement().getTdmProtocolTypeObj();
            int n = iConnectionModel.getHoCircuitType();
            ((NetCcatCircuit)spliceListener.node.getCircuit()).setCircuitType(n);
        } else if (NetCircuitSplicer.dbgOn()) {
            NetCircuitSplicer.debug("No nodes left with the circuit, should never happen");
        }
    }

    private void fabricateLoOnCircuit(SpliceListener spliceListener) {
        ((HoCcatCircuit)spliceListener.node.getCircuit()).setYState(3);
        Iterator iterator = ((HoCcatCircuit)spliceListener.node.getCircuit()).getCircuitNodes().iterator();
        ICircuitSize iCircuitSize = ((HoCcatCircuit)spliceListener.node.getCircuit()).getContainedLoSize();
        ICircuitType iCircuitType = ((HoCcatCircuit)spliceListener.node.getCircuit()).getContainedLoType();
        while (iterator.hasNext()) {
            HoCircuitNode hoCircuitNode = (HoCircuitNode)iterator.next();
            NetCircuitFactory.fabricateYCircuits(hoCircuitNode, iCircuitSize, iCircuitType);
        }
    }

    private boolean checkAndFabricateLoCircuits(SpliceListener spliceListener, SpliceListener spliceListener2) {
        if (spliceListener.loAdit ^ spliceListener2.loAdit) {
            return this.checkHoAditYCondition(spliceListener, spliceListener2);
        }
        if (spliceListener.loNum == null && spliceListener2.loNum == null) {
            this.checkHoHoYCondition(spliceListener, spliceListener2);
            return false;
        }
        return false;
    }

    private void unifyYCircuits(SpliceListener spliceListener, SpliceListener spliceListener2) {
        if (spliceListener.node instanceof LoYCircuitNode ^ spliceListener2.node instanceof LoYCircuitNode) {
            ((LoCcatCircuit)spliceListener.node.getCircuit()).updateYCircuit(true);
        } else if (spliceListener.node instanceof LoYCircuitNode && spliceListener2.node instanceof LoYCircuitNode) {
            ((LoCcatCircuit)spliceListener.node.getCircuit()).updateYCircuit(false);
        }
        if (spliceListener.node instanceof HoCircuitNode && spliceListener2.node instanceof HoCircuitNode) {
            ((HoCcatCircuit)spliceListener.node.getCircuit()).updateYCircuit();
        }
    }

    private void updateSpanYState(SpliceListener spliceListener, SpliceListener spliceListener2, LoCircuitSpan loCircuitSpan) {
        if (spliceListener.node instanceof LoYCircuitNode) {
            loCircuitSpan.setSrcFabricated();
        }
        if (spliceListener2.node instanceof LoYCircuitNode) {
            loCircuitSpan.setDstFabricated();
        }
    }

    private boolean addInternalTL1TunnelEnd(SpliceListenerEntry spliceListenerEntry, SpliceListenerEntry spliceListenerEntry2, InternalSpliceLink internalSpliceLink, boolean bl, boolean bl2) {
        IEntityModel iEntityModel;
        IEntityModel iEntityModel2;
        boolean bl3;
        boolean bl4;
        boolean bl5;
        NetCcatCircuit netCcatCircuit;
        NetCcatCircuit netCcatCircuit2;
        NetCcatCircuit netCcatCircuit3;
        IConnectionModel iConnectionModel;
        IConnectionModel iConnectionModel2;
        int n;
        int n2;
        int n3;
        int n4;
        NetCircuitNode netCircuitNode;
        NetCircuitNode netCircuitNode2;
        NetCircuitNode netCircuitNode3;
        NetCircuitNode netCircuitNode4;
        SpliceListener spliceListener;
        SpliceListener spliceListener2;
        block35: {
            spliceListener2 = spliceListenerEntry.spliceListener;
            spliceListener = spliceListenerEntry2.spliceListener;
            netCircuitNode4 = spliceListener2.node;
            netCircuitNode3 = spliceListener.node;
            netCircuitNode2 = null;
            netCircuitNode = null;
            n4 = spliceListenerEntry.spliceLinkIndex.entityIndex;
            n3 = spliceListenerEntry2.spliceLinkIndex.entityIndex;
            n2 = 0;
            n = 0;
            iConnectionModel2 = null;
            iConnectionModel = null;
            netCcatCircuit3 = (NetCcatCircuit)netCircuitNode4.getCircuit();
            netCcatCircuit2 = (NetCcatCircuit)netCircuitNode3.getCircuit();
            netCcatCircuit = null;
            bl5 = false;
            bl4 = OchTrailHelper.isTrunkPort(netCircuitNode4.getNodeModel(), n4);
            bl3 = OchTrailHelper.isTrunkPort(netCircuitNode3.getNodeModel(), n3);
            INodeModel iNodeModel = netCircuitNode4.getNodeModel();
            IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
            iEntityModel2 = null;
            iEntityModel = null;
            try {
                if (iEntityTableModel != null) {
                    iEntityModel2 = iEntityTableModel.getEntityModelByIndex(n4);
                    iEntityModel = iEntityTableModel.getEntityModelByIndex(n3);
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (!db.on()) break block35;
                db.println("getTunnelEntityIndex: Exception " + (Object)((Object)abstractCmsNoSuchEntityException));
            }
        }
        if (bl4 && bl3) {
            if (!bl || !bl2) {
                return false;
            }
            if (db.on()) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Got trunk to trunk !" + n4 + " " + n3);
            }
            if (!netCircuitNode4.isOchTrailTunnelNode() || !netCircuitNode3.isOchTrailTunnelNode()) {
                return false;
            }
            if (db.on() && iEntityModel2.getModuleModel().getEqType() == 293) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: trunk 1 is catinaccio");
            }
            if (db.on() && iEntityModel.getModuleModel().getEqType() == 293) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: trunk 2 is catinaccio");
            }
            n2 = n4;
            n = n3;
            netCircuitNode2 = this.findTunnelNode(netCcatCircuit3, netCircuitNode4.getNetElement(), n2);
            if (netCircuitNode2 == null) {
                iConnectionModel2 = this.findAditModel(netCircuitNode4.getNodeModel(), n2);
                if (iConnectionModel2 == null) {
                    if (db.on()) {
                        NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Adit not found on Node for index = " + n2);
                    }
                    return false;
                }
                netCircuitNode2 = NetCircuitNodeFactory.createCircuitNode(netCircuitNode4.getNetElement(), netCcatCircuit3, iConnectionModel2);
                netCcatCircuit3.insertCktNode(netCircuitNode2);
            }
            if ((netCircuitNode = this.findTunnelNode(netCcatCircuit2, netCircuitNode4.getNetElement(), n)) == null) {
                iConnectionModel = this.findAditModel(netCircuitNode3.getNodeModel(), n);
                if (iConnectionModel == null) {
                    if (db.on()) {
                        NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Adit not found on Node for index = " + n);
                    }
                    return false;
                }
                netCircuitNode = NetCircuitNodeFactory.createCircuitNode(netCircuitNode3.getNetElement(), netCcatCircuit2, iConnectionModel);
                netCcatCircuit2.insertCktNode(netCircuitNode);
            }
            netCircuitNode2.cleanupSpliceListeners();
            netCircuitNode.cleanupSpliceListeners();
            netCcatCircuit = netCcatCircuit3;
            bl5 = true;
        }
        if (bl4 && !bl3 || !bl4 && bl3) {
            if (db.on()) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Handling Trunk to Och");
            }
            if (bl4) {
                n2 = n4;
                netCcatCircuit = netCcatCircuit3;
                netCircuitNode = netCircuitNode3;
            } else {
                n2 = n3;
                netCcatCircuit = netCcatCircuit2;
                netCircuitNode = netCircuitNode4;
            }
            if (NetCircuitSplicer.dbgOn() && iEntityModel2.getModuleModel().getEqType() == 293) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: trunk 1 is catinaccio");
            }
            if (NetCircuitSplicer.dbgOn() && iEntityModel.getModuleModel().getEqType() == 293) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: trunk 2 is catinaccio");
            }
            if ((netCircuitNode2 = this.findTunnelNode(netCcatCircuit, netCircuitNode4.getNetElement(), n2)) == null) {
                iConnectionModel2 = this.findAditModel(netCircuitNode4.getNodeModel(), n2);
                if (iConnectionModel2 == null) {
                    if (NetCircuitSplicer.dbgOn()) {
                        NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Adit not found on Node for index = " + n2);
                    }
                    return false;
                }
                netCircuitNode2 = NetCircuitNodeFactory.createCircuitNode(netCircuitNode4.getNetElement(), netCcatCircuit, iConnectionModel2);
                netCcatCircuit.insertCktNode(netCircuitNode2);
            }
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: inserted new tunnel node : " + netCircuitNode2.getName());
            }
            bl5 = true;
        }
        if (bl5) {
            InternalNetLink internalNetLink = new InternalNetLink(netCircuitNode4.getNetElement(), netCircuitNode3.getNetElement(), internalSpliceLink.srcEntityIndex, internalSpliceLink.dstEntityIndex, spliceListener2.hoNum, spliceListener.hoNum);
            NetLinkSpan netLinkSpan = new NetLinkSpan(internalNetLink, null, spliceListener2.hoNum, spliceListener.hoNum, spliceListener2.loNum);
            NetCircuitSpan netCircuitSpan = NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, netCircuitNode4, netCircuitNode3);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Created the internal splicing span");
            }
            netCircuitSpan.setSrcState(4);
            netCircuitSpan.setDstState(4);
            if (!bl4 && bl3) {
                netCircuitSpan.setSrcNCN(netCircuitNode);
                netCircuitSpan.setDstNCN(netCircuitNode2);
            } else {
                netCircuitSpan.setSrcNCN(netCircuitNode2);
                netCircuitSpan.setDstNCN(netCircuitNode);
            }
            netCircuitNode2.addActiveSpan(netCircuitSpan, bl ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.ORIGINATING);
            netCircuitNode.addActiveSpan(netCircuitSpan, bl2 ? eSpanDirection.BIDIRECTIONAL : eSpanDirection.TERMINATING);
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("addInternalTL1TunnelEnd: Successfully added active internal splicing span");
            }
            try {
                this.completeSplice(netCircuitNode2, netCircuitNode);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Exception on complete check! Undoing " + (Object)((Object)abstractCmsIOException));
                }
                netCircuitNode2.disposeActiveSpan(netCircuitSpan);
                netCircuitNode.disposeActiveSpan(netCircuitSpan);
                netCircuitSpan.dispose();
            }
            catch (IllegalStateException illegalStateException) {
                if (NetCircuitSplicer.dbgOn()) {
                    NetCircuitSplicer.debug("Exception on unify! Undoing " + illegalStateException);
                }
                netCircuitNode2.disposeActiveSpan(netCircuitSpan);
                netCircuitNode.disposeActiveSpan(netCircuitSpan);
                netCircuitSpan.dispose();
            }
        }
        return true;
    }

    private NetCircuitNode findTunnelNode(NetCcatCircuit netCcatCircuit, INetElement iNetElement, int n) {
        List list = netCcatCircuit.getCircuitNodeFromNE(iNetElement);
        if (list != null && list.size() > 0) {
            for (NetCircuitNode netCircuitNode : list) {
                IOchTrailAditModel iOchTrailAditModel;
                IOchncPathDefModel[] iOchncPathDefModelArray;
                if (!(netCircuitNode instanceof OchTrailTunnelNode) || (iOchncPathDefModelArray = (iOchTrailAditModel = (IOchTrailAditModel)netCircuitNode.getConn()).getPaths())[0].getPortEntityIdx() != n) continue;
                return netCircuitNode;
            }
        }
        return null;
    }

    private IConnectionModel findAditModel(INodeModel iNodeModel, int n) {
        IConnectionModels iConnectionModels = iNodeModel.getConnectionModels();
        IOchTrailAditModel[] iOchTrailAditModelArray = iConnectionModels.getOchTrailAditModels();
        for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
            IOchncPathDefModel[] iOchncPathDefModelArray = iOchTrailAditModelArray[i].getPaths();
            if (NetCircuitSplicer.dbgOn()) {
                NetCircuitSplicer.debug("findAditModel: Adit index = " + iOchncPathDefModelArray[0].getPortEntityIdx());
            }
            if (iOchncPathDefModelArray[0].getPortEntityIdx() != n) continue;
            return iOchTrailAditModelArray[i];
        }
        return null;
    }

    static {
        db = new SDebug("NetCircuitSplicer");
    }

    public class DumpDebug
    extends SDebug {
        public DumpDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            if (!this.on()) {
                this.set();
            }
            NetCircuitSplicer netCircuitSplicer = NetCircuitSplicer.this;
            synchronized (netCircuitSplicer) {
                Set set = NetCircuitSplicer.this.linkEntries.keySet();
                Iterator iterator = set.iterator();
                this.println(set.size() + " link indices found");
                while (iterator.hasNext()) {
                    SpliceLinkIndex spliceLinkIndex = (SpliceLinkIndex)iterator.next();
                    this.println("Index: " + spliceLinkIndex.prettyString());
                    Map map = (Map)NetCircuitSplicer.this.linkEntries.get(spliceLinkIndex);
                    if (map == null) continue;
                    Iterator iterator2 = map.values().iterator();
                    this.println("---> " + map.size() + " listeners found");
                    while (iterator2.hasNext()) {
                        SpliceListener spliceListener = (SpliceListener)iterator2.next();
                        if (spliceListener == null) continue;
                        this.println("     " + spliceListener.prettyString());
                    }
                }
            }
        }
    }
}

