/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CannotCancelRoll;
import cerent.cms.model.CannotCompleteRoll;
import cerent.cms.model.CannotFinishRoll;
import cerent.cms.model.CannotForceCompleteRoll;
import cerent.cms.model.CircuitEnd;
import cerent.cms.model.CktInfo;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitDropInfo;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitInfo;
import cerent.cms.model.ICircuitRollFinish;
import cerent.cms.model.ICircuitRollMode;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IRollModel;
import cerent.cms.model.InvalidRollMode;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.NoRollCondition;
import cerent.cms.model.NoRollValidSignal;
import cerent.cms.model.NoSuchConnection;
import cerent.cms.model.RollNotConnected;
import cerent.cms.model.SiblingRollNotComplete;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.IRollState;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitDropInfo;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitEndFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitRollOperator;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetCircuitSpanFactory;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.RollManager;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.cms.ui.circuits.CircuitEndCellRenderer;
import cerent.cms.vlan.VlanSetManager;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;

public abstract class NetRoll
extends CmsObservable
implements IObserver {
    private static final SDebug db = new SDebug("NetRoll");
    private static final int SOURCE_ROLL = 1;
    private static final int DESTINATION_ROLL = 2;
    private static final int INVALID_ROLL_TYPE = 3;
    protected StringBuffer exceptionStr = new StringBuffer();
    protected INodeModel node;
    protected INetElement ne;
    protected IConnectionModel conn;
    protected NetRoll siblingRoll;
    protected NetCcatCircuit rollFromCircuit;
    protected NetCcatCircuit rollToCircuit;
    protected NetCircuitEnd rollFromCktEnd;
    protected NetCircuitEnd rollToCktEnd;
    protected NetCircuitEnd rollCktEnd;
    protected NetCircuitEnd cktEndForTl1RollTo;
    protected CircuitBirthObserver rfCircuitBirthObserver;
    protected CircuitBirthObserver rtCircuitBirthObserver;
    protected int rollMode;
    protected int connIndex;
    protected int state = 3;
    protected int rollType = 3;
    protected short circuitRollNumber;
    protected short circuitRollMode;
    protected boolean isRollRefValid;
    protected boolean isRollProcessingClient;
    protected boolean bothCircuitsEqual;
    protected int rollCircuitSize;

    public abstract IRollModel getRollModel();

    public abstract void setRollModel(IRollModel var1);

    public abstract Object getRollFromPath();

    public abstract Object getRollToPath();

    protected abstract IConnectionModel getConnection(INodeModel var1, Object var2) throws NoSuchConnection;

    public boolean isRollRefValid() {
        return this.isRollRefValid;
    }

    public INodeModel getNodeModel() {
        return this.node;
    }

    public INetElement getNetElement() {
        return this.ne;
    }

    public String getRollFromCircuitName() {
        if (this.rollFromCircuit == null) {
            return "";
        }
        return this.rollFromCircuit.getCircuitName();
    }

    public String getRollToCircuitName() {
        if (this.rollToCircuit == null) {
            return "";
        }
        return this.rollToCircuit.getCircuitName();
    }

    public NetCcatCircuit getFromCircuit() {
        return this.rollFromCircuit;
    }

    public NetCcatCircuit getToCircuit() {
        return this.rollToCircuit;
    }

    public NetCircuitEnd getRollFromCktEnd() {
        return this.rollFromCktEnd;
    }

    public NetCircuitEnd getRollToCktEnd() {
        return this.rollToCktEnd;
    }

    public NetCircuitEnd getRollPathCktEnd() {
        return this.rollCktEnd;
    }

    public int getRollMode() {
        return this.rollMode;
    }

    public int getCircuitRollMode() {
        return this.circuitRollMode;
    }

    public boolean getRollValidSignal() {
        return this.getRollModel().getRollValidSignal();
    }

    public int getRollFinish() {
        return this.getRollModel().getRollFinish();
    }

    public int getConnectionIndex() {
        return this.connIndex;
    }

    public int getCircuitSize() {
        return this.rollCircuitSize;
    }

    protected boolean isRollProcessingClient() {
        return this.isRollProcessingClient;
    }

    protected void setIsRollProcessingClient(boolean bl) {
        this.isRollProcessingClient = bl;
        this.setChanged();
    }

    protected void setState(int n) {
        if (this.state != n) {
            if (this.dbgOn()) {
                db.println("Roll state change: old = " + EnumStrings.getString(IRollState.class, (int)this.state) + "; new = " + EnumStrings.getString(IRollState.class, (int)n));
            }
            this.state = n;
            this.setChanged();
        }
    }

    public int getState() {
        return this.state;
    }

    protected int getRollType() {
        return this.rollType;
    }

    protected void setRollType(int n) {
        this.rollType = n;
        this.setChanged();
    }

    public String getExceptionString() {
        return this.exceptionStr.toString();
    }

    public void clearExceptionString() {
        this.exceptionStr.delete(1, this.exceptionStr.length());
    }

    public NetRoll getSiblingRoll() {
        return this.siblingRoll;
    }

    protected void setSiblingRoll(NetRoll netRoll) {
        this.siblingRoll = netRoll;
        this.setChanged();
    }

    public boolean canBeForceCompleted() throws CannotForceCompleteRoll {
        if (!this.isRollRefValid) {
            throw new CannotForceCompleteRoll("The roll has been destroyed.");
        }
        if (this.getState() == 3) {
            throw new CannotForceCompleteRoll("The roll is in the INCOMPLETE state.");
        }
        if (this.getState() == 4) {
            throw new CannotForceCompleteRoll("The roll is in the TL1_ROLL state.");
        }
        if (!this.node.provides(Feature.ENHANCED_BRIDGE_AND_ROLL)) {
            throw new CannotForceCompleteRoll("The old node does not support the force valid signal operation.");
        }
        if (this.circuitRollNumber == 2 && this.siblingRoll == null) {
            throw new CannotForceCompleteRoll("The sibling roll was not found.");
        }
        if (this.getRollFinish() == 2) {
            throw new CannotForceCompleteRoll("The roll has been canceled.");
        }
        if (this.getRollValidSignal()) {
            throw new CannotForceCompleteRoll("The roll has already received a valid signal.");
        }
        if (this.rollFromCircuit.getCircuitDir() == 0 && this.rollMode == 1) {
            NetCircuitNode netCircuitNode = null;
            List list = this.rollFromCircuit.getCircuitNodeFromNE(this.rollFromCktEnd.getNetElement());
            if (list != null) {
                netCircuitNode = list.size() > 1 ? this.rollFromCircuit.getCircuitNodeFromCktEnd(this.rollFromCktEnd) : (NetCircuitNode)list.get(0);
            }
            if (netCircuitNode.getSources().size() != 2 || !netCircuitNode.getSources().contains(this.rollFromCktEnd) || netCircuitNode.getConnectionType() != 6) {
                throw new CannotForceCompleteRoll("A valid signal cannot be forced on a one-way manual roll.");
            }
        }
        if (this.siblingRoll != null && this.siblingRoll.getRollFinish() == 2) {
            throw new CannotForceCompleteRoll("The sibling roll has been canceled.");
        }
        return true;
    }

    public boolean canBeCompleted() throws CannotCompleteRoll {
        if (!this.isRollRefValid) {
            throw new CannotCompleteRoll("The roll has been destroyed.");
        }
        if (this.getState() == 3) {
            throw new CannotCompleteRoll("The roll is in the INCOMPLETE state.");
        }
        if (this.getState() == 4) {
            throw new CannotCompleteRoll("The roll is in the TL1_ROLL state.");
        }
        if (this.circuitRollNumber == 2 && this.siblingRoll == null) {
            throw new CannotCompleteRoll("The sibling roll was not found.");
        }
        if (this.getRollFinish() == 3) {
            throw new CannotCompleteRoll("The roll has been completed.");
        }
        if (this.getRollFinish() == 2) {
            throw new CannotCompleteRoll("The roll has been canceled.");
        }
        if (this.getRollFinish() != 1) {
            throw new CannotCompleteRoll("The roll is not ready to be completed.");
        }
        if (this.circuitRollMode != 1) {
            throw new CannotCompleteRoll("The AUTO roll cannot be completed.");
        }
        if (this.siblingRoll != null) {
            if (!this.siblingRoll.getRollValidSignal()) {
                throw new CannotCompleteRoll("The sibling roll does not have a valid signal.");
            }
            if (this.siblingRoll.getRollFinish() == 2) {
                throw new CannotCompleteRoll("The sibling roll has been canceled.");
            }
        }
        return true;
    }

    public boolean canBeCancelled() throws CannotCancelRoll {
        if (!this.isRollRefValid) {
            throw new CannotCancelRoll("The roll has been destroyed.");
        }
        if (this.getState() == 3) {
            throw new CannotCancelRoll("The roll is in the INCOMPLETE state.");
        }
        if (this.getState() == 4) {
            throw new CannotCancelRoll("The roll is in the TL1_ROLL state.");
        }
        if (this.circuitRollNumber == 2 && this.siblingRoll == null) {
            throw new CannotCancelRoll("The sibling roll was not found.");
        }
        if (this.getRollFinish() == 3) {
            throw new CannotCancelRoll("The roll has been completed.");
        }
        if (this.getRollFinish() == 2) {
            throw new CannotCancelRoll("The roll has been canceled.");
        }
        if (this.circuitRollNumber == 1) {
            if (this.circuitRollMode != 1 && this.getRollValidSignal()) {
                throw new CannotCancelRoll("A valid signal was received on the AUTO roll.");
            }
        } else if (this.siblingRoll != null) {
            if (this.siblingRoll.getRollFinish() == 3) {
                throw new CannotCancelRoll("The sibling roll has been completed.");
            }
            if (this.circuitRollMode != 1 && this.getRollValidSignal() && this.siblingRoll.getRollValidSignal()) {
                throw new CannotCancelRoll("A valid signal was received on the AUTO roll.");
            }
        }
        return true;
    }

    public boolean canBeFinished() throws CannotFinishRoll {
        if (!this.isRollRefValid) {
            throw new CannotFinishRoll("The roll has been destroyed.");
        }
        if (this.getState() == 3) {
            throw new CannotFinishRoll("The roll is in the INCOMPLETE state.");
        }
        if (this.getState() == 4) {
            throw new CannotFinishRoll("The roll is in the TL1_ROLL state.");
        }
        if (this.circuitRollNumber == 2 && this.siblingRoll == null) {
            throw new CannotFinishRoll("The sibling roll was not found.");
        }
        if (!this.allRollsCompleted()) {
            throw new CannotFinishRoll("Not all rolls have completed.");
        }
        if (this.isFinished()) {
            throw new CannotFinishRoll("The roll is already finished.");
        }
        return true;
    }

    private boolean isFinished() {
        try {
            return this.getRollModel().isAcknowledged();
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Already acknowledged by another client");
            }
            return false;
        }
    }

    public void rollFinish() throws Exception {
        try {
            if (this.dbgOn()) {
                db.println("calling rollFinish()");
            }
            if (this.acknowledgeRollModel()) {
                if (this.siblingRoll != null) {
                    this.siblingRoll.acknowledgeRollModel();
                }
                this.setIsRollProcessingClient(true);
                this.updateChanged();
            }
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Exception during roll finish");
                SDebug.printStackTrace((Throwable)exception);
            }
            throw exception;
        }
    }

    private boolean acknowledgeRollModel() {
        try {
            return this.getRollModel().acknowledgeRoll();
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Already acknowledged by another client");
            }
            return false;
        }
    }

    public void rollComplete() throws InvalidRollMode, NoRollValidSignal, NoRollCondition, RollNotConnected, SiblingRollNotComplete {
        block7: {
            try {
                if (this.dbgOn()) {
                    db.println("calling rollComplete() at " + this.node.getName());
                }
                this.getRollModel().rollComplete();
                this.setState(1);
            }
            catch (InvalidRollMode invalidRollMode) {
                throw invalidRollMode;
            }
            catch (NoRollCondition noRollCondition) {
                throw noRollCondition;
            }
            catch (NoRollValidSignal noRollValidSignal) {
                throw noRollValidSignal;
            }
            catch (RollNotConnected rollNotConnected) {
                throw rollNotConnected;
            }
            catch (Exception exception) {
                if (!this.dbgOn()) break block7;
                db.println("Exception during roll completion");
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    public void rollCancel() throws CannotCancelRoll {
        try {
            if (this.dbgOn()) {
                db.println("calling rollCancel()");
            }
            this.getRollModel().rollCancel();
            this.setState(2);
            this.setIsRollProcessingClient(true);
        }
        catch (RollNotConnected rollNotConnected) {
            throw new CannotCancelRoll("The roll cannot be canceled because it is not connected.");
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Exception during roll cancel");
                SDebug.printStackTrace((Throwable)exception);
            }
            throw new CannotCancelRoll("An error occurred while canceling the roll.");
        }
    }

    public boolean isDualRollWithValidSignal() {
        if (this.circuitRollNumber != 2) {
            return false;
        }
        if (this.getRollValidSignal()) {
            return true;
        }
        return this.siblingRoll != null && this.siblingRoll.getRollValidSignal();
    }

    public void cancelAndDestroyRoll() {
        try {
            this.getRollModel().rollCancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.getRollModel().rollDestroy();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.isRollRefValid = false;
    }

    public void rollDelete() throws ConnectionInRoll, Exception {
        if (this.getState() == 4) {
            throw new Exception("CTC is not allowed to delete a TL1-created roll.");
        }
        if (this.getRollFinish() != 2 && this.getRollFinish() != 3) {
            try {
                this.getRollModel().rollCancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.rollDestroy();
    }

    private void updateRollInfo() {
        if (!this.isRollRefValid) {
            if (this.dbgOn()) {
                db.println("updateRollInfo: roll ref is not valid");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("calling updateRollInfo on " + this.node.getName());
        }
        this.discoverRollState();
        this.discoverCircuitState();
        this.discoverSiblingRoll();
    }

    private synchronized void updateCircuitChangedInfo() {
        if (!this.isRollRefValid) {
            if (this.dbgOn()) {
                db.println("updateCircuitChangedInfo: roll ref is not valid");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("calling updateCircuitChangedInfo on " + this.node.getName());
        }
        if (this.rollFromCircuit != null && this.rollToCircuit == null && this.isTL1Roll()) {
            if (this.rtCircuitBirthObserver != null) {
                NetCircuitManager.instance().deleteObserver(this.rtCircuitBirthObserver);
            }
            this.discoverTl1RollToCircuit();
        }
        this.updateRollInfo();
    }

    private synchronized void updateCircuitDeletionInfo() {
        if (!this.isRollRefValid) {
            if (this.dbgOn()) {
                db.println("updateCircuitDeletionInfo: roll ref is not valid");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("calling updateCircuitDeletionInfo on " + this.node.getName());
        }
        this.cleanUpCircuitInfo();
        if (this.rfCircuitBirthObserver != null) {
            NetCircuitManager.instance().deleteObserver(this.rfCircuitBirthObserver);
        }
        if (this.rtCircuitBirthObserver != null) {
            NetCircuitManager.instance().deleteObserver(this.rtCircuitBirthObserver);
        }
        this.discoverCircuitInfo();
    }

    private synchronized void updateCircuitAdditionInfo(NetCcatCircuit netCcatCircuit, ICircuitId iCircuitId, CircuitBirthObserver circuitBirthObserver) {
        if (this.dbgOn()) {
            db.println("calling updateCircuitAdditionInfo on " + this.node.getName());
        }
        if (!NetRoll.isNullCircuitId(iCircuitId)) {
            ICircuitId iCircuitId2 = netCcatCircuit.getCircuitId();
            if (iCircuitId.equals(iCircuitId2)) {
                if (iCircuitId.equals(this.getRollModel().getRollFromCircuit())) {
                    this.rollFromCircuit = netCcatCircuit;
                    this.rollFromCircuit.addObserver(this);
                }
                if (iCircuitId.equals(this.getRollModel().getRollToCircuit())) {
                    this.rollToCircuit = netCcatCircuit;
                    this.rollToCircuit.addObserver(this);
                }
                if (this.dbgOn()) {
                    db.println("Circuit is found, deregister from NetCircuitManager");
                }
                NetCircuitManager.instance().deleteObserver(circuitBirthObserver);
                this.updateRollInfo();
            }
        } else if (netCcatCircuit.containsCktEnd(this.rollFromCktEnd)) {
            this.rollFromCircuit = netCcatCircuit;
            this.rollFromCircuit.addObserver(this);
            if (this.rtCircuitBirthObserver != null) {
                NetCircuitManager.instance().deleteObserver(this.rtCircuitBirthObserver);
            }
            this.discoverTl1RollToCircuit();
            if (this.dbgOn()) {
                db.println("Circuit is found, deregister from NetCircuitManager");
            }
            NetCircuitManager.instance().deleteObserver(circuitBirthObserver);
            this.updateRollInfo();
        } else if (netCcatCircuit.containsCktEnd(this.cktEndForTl1RollTo)) {
            this.rollToCircuit = netCcatCircuit;
            this.rollToCircuit.addObserver(this);
            if (this.dbgOn()) {
                db.println("Circuit is found, deregister from NetCircuitManager");
            }
            NetCircuitManager.instance().deleteObserver(circuitBirthObserver);
            this.updateRollInfo();
        }
    }

    private synchronized void discoverTl1RollToCircuit() {
        if (this.dbgOn()) {
            db.println("calling discoverTl1RollToCircuit on " + this.node.getName());
        }
        if (this.rollFromCircuit == null) {
            if (this.dbgOn()) {
                db.println("rollFromCircuit is NULL, return");
            }
            return;
        }
        INetLink iNetLink = Network.instance().findNetLinkFromSourceCktEnd(this.rollFromCircuit.getCircuitTypeObj().isLoCircuitType(), this.rollToCktEnd.getNetElement(), this.rollToCktEnd.getEntityIndex(), this.rollToCktEnd.getHoNum(), this.rollToCktEnd.getLoNum());
        if (iNetLink == null) {
            if (this.dbgOn()) {
                db.println("link is null, rollToCircuit = rollFromCircuit");
            }
            this.rollToCircuit = this.rollFromCircuit;
            this.rollToCircuit.addObserver(this);
        } else {
            NetCircuitEnd netCircuitEnd = NetCircuitEndFactory.createCircuitEnd(this.rollFromCircuit.getCircuitType(), this.getCktEndOnLinkDst(iNetLink));
            NetCircuitNode netCircuitNode = null;
            List list = this.rollFromCircuit.getCircuitNodeFromNE(netCircuitEnd.getNetElement());
            if (list != null) {
                netCircuitNode = list.size() > 1 ? this.rollFromCircuit.getCircuitNodeFromCktEnd(netCircuitEnd) : (NetCircuitNode)list.get(0);
            }
            if (netCircuitNode != null && NetCircuitRollOperator.isRollToCktEnd(netCircuitNode, netCircuitEnd)) {
                if (this.dbgOn()) {
                    db.println("direct link between 2 rollTo, rollToCircuit = rollFromCircuit");
                }
                this.rollToCircuit = this.rollFromCircuit;
                this.rollToCircuit.addObserver(this);
            } else {
                if (this.dbgOn()) {
                    db.println("no direct link between 2 rollTo, rollToCircuit != rollFromCircuit");
                }
                List list2 = NetCircuitManager.instance().getCircuits(iNetLink);
                for (NetCircuit netCircuit : list2) {
                    NetCcatCircuit netCcatCircuit;
                    if (netCircuit instanceof NetVcatCircuit || !(netCcatCircuit = (NetCcatCircuit)netCircuit).containsCktEnd(netCircuitEnd)) continue;
                    this.rollToCircuit = netCcatCircuit;
                    break;
                }
                if (this.rollToCircuit == null) {
                    if (this.dbgOn()) {
                        db.println("Roll To Circuit = null, observing NetCircuitManager for update");
                    }
                    this.cktEndForTl1RollTo = netCircuitEnd;
                    this.rtCircuitBirthObserver = new CircuitBirthObserver(null);
                    NetCircuitManager.instance().addObserver(this.rtCircuitBirthObserver);
                } else {
                    if (this.dbgOn()) {
                        db.println("Roll To Circuit = " + this.rollToCircuit.getCircuitName());
                    }
                    this.rollToCircuit.addObserver(this);
                }
            }
        }
    }

    private NetCircuitEnd getCktEndOnLinkDst(INetLink iNetLink) {
        INodeModel iNodeModel = iNetLink.getDst().getNodeModel();
        int n = iNetLink.getDstEntityIndex();
        ILoNum iLoNum = this.rollToCktEnd.getLoNum();
        IHoNum iHoNum = this.rollToCktEnd.getHoNum();
        if (iNetLink.isLOTunnel() || iNetLink.isLAP()) {
            iHoNum = iNetLink.getDstHo();
        }
        return new NetCircuitEnd(iNodeModel.getNodeId(), n, iHoNum, iLoNum, false);
    }

    protected void discoverCircuitInfo() {
        ICircuitId iCircuitId;
        if (this.dbgOn()) {
            db.println("calling discoverCircuitInfo on " + this.node.getName());
        }
        this.rollFromCircuit = NetRoll.isNullCircuitId(iCircuitId = this.getRollModel().getRollFromCircuit()) ? (NetRoll.isNullCircuitId(iCircuitId = this.conn.getCircuitId()) ? (NetCcatCircuit)NetCircuitManager.instance().getCircuitFromConn(this.ne, this.conn) : (NetCcatCircuit)NetCircuitManager.instance().getCircuitFromId(iCircuitId)) : (NetCcatCircuit)NetCircuitManager.instance().getCircuitFromId(iCircuitId);
        if (this.rollFromCircuit == null) {
            if (this.dbgOn()) {
                db.println("Roll From Circuit = null, observing NetCircuitManager for update");
            }
            this.rfCircuitBirthObserver = new CircuitBirthObserver(iCircuitId);
            NetCircuitManager.instance().addObserver(this.rfCircuitBirthObserver);
        } else {
            if (this.dbgOn()) {
                db.println("Roll From Circuit = " + this.rollFromCircuit.getCircuitName());
            }
            this.rollFromCircuit.addObserver(this);
        }
        iCircuitId = this.getRollModel().getRollToCircuit();
        if (NetRoll.isNullCircuitId(iCircuitId)) {
            if (this.rollFromCircuit != null) {
                this.discoverTl1RollToCircuit();
            }
        } else {
            this.rollToCircuit = (NetCcatCircuit)NetCircuitManager.instance().getCircuitFromId(iCircuitId);
            if (this.rollToCircuit == null) {
                if (this.dbgOn()) {
                    db.println("Roll To Circuit = null, observing NetCircuitManager for update");
                }
                this.rtCircuitBirthObserver = new CircuitBirthObserver(iCircuitId);
                NetCircuitManager.instance().addObserver(this.rtCircuitBirthObserver);
            } else {
                if (this.dbgOn()) {
                    db.println("Roll To Circuit = " + this.rollToCircuit.getCircuitName());
                }
                this.rollToCircuit.addObserver(this);
            }
        }
        this.updateRollInfo();
    }

    private void discoverRollState() {
        block12: {
            try {
                if (this.getRollFinish() == 3) {
                    if (this.dbgOn()) {
                        db.println("discoverRollState(): RF flag is RF_COMPLETE");
                    }
                    this.setState(1);
                } else if (this.getRollFinish() == 2) {
                    if (this.dbgOn()) {
                        db.println("discoverRollState(): RF flag is RF_CANCEL");
                    }
                    this.setState(2);
                } else if (this.getRollFinish() == 1) {
                    if (this.dbgOn()) {
                        db.println("discoverRollState(): RF flag is RF_READY");
                    }
                    this.setState(0);
                } else {
                    if (this.dbgOn()) {
                        db.println("discoverRollState(): RF flag is RF_UNDETERMINED");
                    }
                    this.setState(0);
                }
            }
            catch (Exception exception) {
                if (!this.dbgOn()) break block12;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void discoverCircuitState() {
        block23: {
            try {
                if (this.rollFromCircuit == null) {
                    if (this.isTL1Roll()) {
                        this.setState(4);
                    } else {
                        this.setState(3);
                    }
                    return;
                }
                if (this.rollToCircuit == null) {
                    if (this.isTL1Roll()) {
                        this.setState(4);
                    } else {
                        this.setState(3);
                    }
                    return;
                }
                if (this.rollToCircuit != this.rollFromCircuit && !this.rollToCircuit.inRoll()) {
                    if (this.dbgOn()) {
                        db.println("Setting roll to circuit " + this.getRollToCircuitName() + " to be in roll");
                    }
                    this.rollToCircuit.setInRoll(true);
                }
                if (this.rollFromCircuit.circuitInfoActive()) {
                    if (!this.rollFromCircuit.completeCheck()) {
                        if (this.dbgOn()) {
                            db.println("Roll From Circuit (CTC) is not fully discovered");
                        }
                        if (this.isTL1Roll()) {
                            this.setState(4);
                        } else {
                            this.setState(3);
                        }
                        return;
                    }
                } else if (!this.rollFromCircuit.tl1CircuitCompleteCheck()) {
                    if (this.dbgOn()) {
                        db.println("Roll From Circuit (TL1) is not fully discovered");
                    }
                    if (this.isTL1Roll()) {
                        this.setState(4);
                    } else {
                        this.setState(3);
                    }
                    return;
                }
                if (this.dbgOn()) {
                    db.println("Roll From Circuit is fully discovered");
                }
                if (this.rollType == 3) {
                    this.discoverRollType();
                }
                if (this.isTL1Roll()) {
                    this.setState(4);
                    return;
                }
            }
            catch (Exception exception) {
                if (!this.dbgOn()) break block23;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private boolean isTL1Roll() {
        if (NetRoll.isNullCircuitId(this.getRollModel().getRollToCircuit())) {
            if (this.dbgOn()) {
                db.println("calling isTL1Roll(): rollToCkt has nullId");
            }
            return true;
        }
        return false;
    }

    private void discoverRollType() {
        NetCircuitNode netCircuitNode = this.rollFromCircuit.getCircuitNodeFromCktEnd(this.rollFromCktEnd);
        if (netCircuitNode == null) {
            this.setRollType(3);
            return;
        }
        if (netCircuitNode.isIngressPoint(this.rollFromCktEnd)) {
            this.setRollType(1);
        } else if (netCircuitNode.isEgressPoint(this.rollFromCktEnd)) {
            this.setRollType(2);
        } else {
            this.setRollType(3);
        }
    }

    private void discoverSiblingRoll() {
        if (this.circuitRollNumber != 2) {
            return;
        }
        if (this.siblingRoll != null) {
            return;
        }
        if (this.dbgOn()) {
            db.println("Looking for sibling roll");
        }
        NetRoll netRoll2 = null;
        List list = RollManager.instance().getRolls();
        for (NetRoll netRoll2 : list) {
            if (netRoll2.rollFromCircuit == null || netRoll2.rollToCircuit == null || netRoll2.rollFromCircuit != this.rollFromCircuit || netRoll2.rollToCircuit != this.rollToCircuit || netRoll2.isSameRoll(this)) continue;
            this.setSiblingRoll(netRoll2);
            if (netRoll2.getSiblingRoll() == null) {
                netRoll2.setSiblingRoll(this);
            }
            if (this.dbgOn()) {
                db.println("Found sibling roll");
            }
            return;
        }
        if (this.dbgOn()) {
            db.println("Sibling roll not found");
        }
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IRollModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.println("NetRoll.update: type = DELETED at " + this.node.getName() + " on circuit " + this.rollFromCircuit.getCircuitName());
                }
                this.updateDeleted();
                this.notifyObservers(ModelUpdateType.DELETED);
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.println("NetRoll.update: type = CHANGED at " + this.node.getName() + " on circuit " + this.rollFromCircuit.getCircuitName());
                }
                this.updateChanged();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        } else if (iObservable instanceof INetCircuit) {
            if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.println("NetCircuit.update: type = CHANGED at " + this.node.getName() + " on circuit " + ((INetCircuit)iObservable).getCircuitName());
                }
                this.updateCircuitChangedInfo();
                this.notifyObservers(ModelUpdateType.CHANGED);
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.println("NetCircuit.update: type = DELETED at " + this.node.getName() + " on circuit " + ((INetCircuit)iObservable).getCircuitName());
                }
                this.updateCircuitDeletionInfo();
                this.notifyObservers(ModelUpdateType.CHANGED);
            }
        }
    }

    private synchronized void updateDeleted() {
        if (this.dbgOn()) {
            db.println("updateDeleted: Removing roll from RollManager " + this.getPathString() + ", " + this.rollFromCircuit.getCircuitName());
        }
        this.isRollRefValid = false;
        if (this.siblingRoll == null && this.rollToCircuit != null && this.rollToCircuit != this.rollFromCircuit) {
            this.rollToCircuit.setInRoll(false);
        }
        this.cleanUpCircuitInfo();
        this.cleanUpSiblingRoll();
        RollManager.instance().removeRoll(this);
        try {
            ModelIndirectObservable.instance().deleteObserver((IObservable)this.getRollModel(), this);
        }
        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
            // empty catch block
        }
        this.setRollModel(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void updateChanged() {
        block47: {
            block46: {
                if (!this.isRollRefValid) {
                    if (this.dbgOn()) {
                        db.println("updateChanged: roll ref is not valid");
                    }
                    return;
                }
                if (this.getRollModel() == null) {
                    if (this.dbgOn()) {
                        db.println("updateChanged: roll model is null");
                    }
                    return;
                }
                if (this.getState() == 3 || this.getState() == 4) {
                    if (this.dbgOn()) {
                        db.println("updateChanged: roll state is INCOMPLETE/TL1_ROLL");
                    }
                    return;
                }
                if (this.circuitRollNumber == 2 && this.siblingRoll == null) {
                    if (this.dbgOn()) {
                        db.println("updateChanged: sibling roll is not found");
                    }
                    return;
                }
                try {
                    this.discoverRollState();
                    if (this.circuitRollMode == 2) {
                        if (this.rollFromCircuit.getCircuitDir() == 0) {
                            if (this.rollMode == 1) {
                                if (this.getRollFinish() == 1 && this.siblingRoll.getRollFinish() == 3) {
                                    if (this.dbgOn()) {
                                        db.println("DUAL mode, uni-dir ckt, MAN mode, call this.rollComplete()");
                                    }
                                    this.rollComplete();
                                }
                            } else if (this.rollMode == 0 && this.getRollFinish() == 3 && this.siblingRoll.getRollFinish() == 1) {
                                if (this.dbgOn()) {
                                    db.println("DUAL mode, uni-dir ckt, AUTO mode, call siblingRoll.rollComplete()");
                                }
                                this.siblingRoll.rollComplete();
                            }
                        } else if (this.rollFromCircuit.getCircuitDir() == 1 && this.siblingRoll.getRollFinish() == 1 && this.getRollFinish() == 1) {
                            if (this.dbgOn()) {
                                db.println("DUAL mode, bi-dir ckt, call this.rollComplete() & siblingRoll.rollComplete()");
                            }
                            this.rollComplete();
                            this.siblingRoll.rollComplete();
                        }
                    }
                }
                catch (NoRollValidSignal noRollValidSignal) {
                    if (this.dbgOn()) {
                        db.println("No roll valid signal during roll completion");
                        SDebug.printStackTrace((Throwable)noRollValidSignal);
                    }
                    this.exceptionStr.append("No roll valid signal during roll completion");
                    return;
                }
                catch (SiblingRollNotComplete siblingRollNotComplete) {
                    if (this.dbgOn()) {
                        db.println("Sibling roll has been canceled, this roll cannot be completed");
                        SDebug.printStackTrace((Throwable)siblingRollNotComplete);
                    }
                    this.exceptionStr.append("No roll valid signal during roll completion");
                    return;
                }
                catch (Exception exception) {
                    if (!this.dbgOn()) break block46;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            if (!this.isRollProcessingClient()) {
                if (this.dbgOn()) {
                    db.println("updateChanged: is not roll processing client");
                }
                this.setChanged();
                return;
            }
            try {
                if (this.allRollsCompleted()) {
                    if (this.dbgOn()) {
                        db.println("updateChanged: All rolls have been completed, circuit roll number = " + this.circuitRollNumber);
                    }
                    NetCcatCircuit netCcatCircuit = this.rollFromCircuit;
                    synchronized (netCcatCircuit) {
                        NetCcatCircuit netCcatCircuit2 = this.rollToCircuit;
                        synchronized (netCcatCircuit2) {
                            if (this.rollFromCircuit.equals(this.rollToCircuit)) {
                                this.bothCircuitsEqual = true;
                            }
                            this.processCircuits();
                        }
                    }
                    this.setIsRollProcessingClient(false);
                    break block47;
                }
                if (!this.allRollsCancelled()) break block47;
                if (this.dbgOn()) {
                    db.println("updateChanged: All rolls have been canceled, circuit roll number = " + this.circuitRollNumber);
                }
                NetCcatCircuit netCcatCircuit = this.rollFromCircuit;
                synchronized (netCcatCircuit) {
                    NetCcatCircuit netCcatCircuit3 = this.rollToCircuit;
                    synchronized (netCcatCircuit3) {
                        this.destroyAllRolls();
                    }
                }
                this.setIsRollProcessingClient(false);
            }
            catch (Exception exception) {
                if (this.dbgOn()) {
                    db.println("Exception during update roll on circuit " + this.rollFromCircuit.getCircuitName());
                    SDebug.printStackTrace((Throwable)exception);
                }
                this.exceptionStr.append("Exception during update roll on circuit " + this.rollFromCircuit.getCircuitName());
                return;
            }
        }
    }

    private void processCircuits() {
        if (this.dbgOn()) {
            db.println("calling processCircuits()");
        }
        if (this.getRollModel() == null) {
            return;
        }
        Object var1_1 = null;
        if (this.circuitRollNumber == 1) {
            if (this.isSourceDropRoll()) {
                this.handleSourceDropRoll();
            } else {
                this.handleReroute();
            }
        } else if (this.circuitRollNumber == 2) {
            this.handleMerge();
        }
    }

    private boolean isSourceDropRoll() {
        return this.rollFromCircuit.isSource(this.rollFromCktEnd) || this.rollFromCircuit.isDrop(this.rollFromCktEnd);
    }

    private List getUnchangedCircuitNodes(List list) {
        List list2 = this.rollFromCircuit.getCircuitNodes();
        for (INetCircuitNode iNetCircuitNode : list) {
            list2.remove(iNetCircuitNode);
        }
        return list2;
    }

    private void handleSourceDropRoll() {
        if (this.dbgOn()) {
            db.println("calling handleSourceDropRoll(),  bothCircuitsEqual = " + this.bothCircuitsEqual);
        }
        try {
            NetCircuitEnd netCircuitEnd = null;
            NetCircuitEnd netCircuitEnd2 = null;
            LinkedList<NetCircuitEnd> linkedList = new LinkedList<NetCircuitEnd>();
            if (this.rollType == 2) {
                netCircuitEnd = (NetCircuitEnd)this.rollFromCircuit.getPrimarySource();
                netCircuitEnd2 = (NetCircuitEnd)this.rollFromCircuit.getSecondarySource();
                NetCircuitDropInfo netCircuitDropInfo2 = null;
                List list = this.rollFromCircuit.getCktDrops();
                for (NetCircuitDropInfo netCircuitDropInfo2 : list) {
                    if (this.rollFromCktEnd.equals(netCircuitDropInfo2.getNetCktEnd())) continue;
                    linkedList.add(netCircuitDropInfo2.getNetCktEnd());
                }
                if (this.bothCircuitsEqual) {
                    linkedList.add(this.rollToCktEnd);
                } else {
                    list = this.rollToCircuit.getCktDrops();
                    for (NetCircuitDropInfo netCircuitDropInfo2 : list) {
                        linkedList.add(netCircuitDropInfo2.getNetCktEnd());
                    }
                }
            } else if (this.rollType == 1) {
                netCircuitEnd = (NetCircuitEnd)this.rollFromCircuit.getPrimarySource();
                netCircuitEnd2 = (NetCircuitEnd)this.rollFromCircuit.getSecondarySource();
                if (this.bothCircuitsEqual) {
                    if (this.rollFromCktEnd.equals(netCircuitEnd)) {
                        netCircuitEnd = this.rollToCktEnd;
                    } else if (this.rollFromCktEnd.equals(netCircuitEnd2)) {
                        netCircuitEnd2 = this.rollToCktEnd;
                    }
                } else {
                    netCircuitEnd = (NetCircuitEnd)this.rollToCircuit.getPrimarySource();
                    netCircuitEnd2 = (NetCircuitEnd)this.rollToCircuit.getSecondarySource();
                }
                NetCircuitDropInfo netCircuitDropInfo3 = null;
                List list = this.rollFromCircuit.getCktDrops();
                for (NetCircuitDropInfo netCircuitDropInfo3 : list) {
                    linkedList.add(netCircuitDropInfo3.getNetCktEnd());
                }
                if (!this.bothCircuitsEqual) {
                    list = this.rollToCircuit.getCktDrops();
                    for (NetCircuitDropInfo netCircuitDropInfo3 : list) {
                        if (this.isMergePoint(this, netCircuitDropInfo3.getNetCktEnd())) continue;
                        linkedList.add(netCircuitDropInfo3.getNetCktEnd());
                    }
                }
            }
            if (this.dbgOn()) {
                db.println("calling finishRolls: sourceRollNode = " + this.rollFromCktEnd.getNetElement().getName() + ", destinationRollNode = " + this.rollFromCktEnd.getNetElement().getName());
            }
            this.finishRolls(this.rollFromCircuit.getCircuitNodes(), new LinkedList(), new LinkedList(), new LinkedList(), netCircuitEnd, netCircuitEnd2, linkedList, this.rollFromCktEnd.getNetElement(), this.rollFromCktEnd.getNetElement());
            if (this.dbgOn()) {
                db.println("Processed source/drop roll successfully");
            }
            this.rollDestroy();
        }
        catch (ConnectionInRoll connectionInRoll) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)connectionInRoll);
            }
            this.exceptionStr.append("Error during reroute ");
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Error during reroute ");
        }
    }

    private void handleReroute() {
        if (this.dbgOn()) {
            db.println("calling handleReroute(),  bothCircuitsEqual = " + this.bothCircuitsEqual);
        }
        try {
            this.handleSingleRoll();
            if (this.dbgOn()) {
                db.println("Processed single roll successfully");
            }
            this.rollDestroy();
        }
        catch (ConnectionInRoll connectionInRoll) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)connectionInRoll);
            }
            this.exceptionStr.append("Error during reroute ");
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Error during reroute ");
        }
    }

    private void handleMerge() {
        if (this.dbgOn()) {
            db.println("handleMerge: dual roll and merge two circuits");
        }
        if (this == null || this.siblingRoll == null) {
            if (this.dbgOn()) {
                db.println("Could not find two rolls on circuit " + this.rollFromCircuit.getCircuitName());
            }
            return;
        }
        NetRoll netRoll = null;
        NetRoll netRoll2 = null;
        if (this.dbgOn()) {
            db.println("Roll type = " + this.rollType);
        }
        try {
            if (this.rollType == 2) {
                if (this.dbgOn()) {
                    db.println("Process destination roll");
                }
                netRoll = this;
                netRoll2 = this.siblingRoll;
            } else if (this.rollType == 1) {
                if (this.dbgOn()) {
                    db.println("Process source roll");
                }
                netRoll = this.siblingRoll;
                netRoll2 = this;
            }
            this.handleDualRolls(netRoll, netRoll2);
            if (this.dbgOn()) {
                db.println("Processed dual rolls successfully");
            }
            this.siblingRoll.rollDestroy();
            this.rollDestroy();
            if (PortGrouping.isPortGroupingCircuit(this.rollFromCircuit) && this.isLastPortGroupRoll()) {
                Object object;
                Object object2;
                Network network = Network.instance();
                INetLink iNetLink = network.findNetLinkFromSourceCktEnd(this.rollToCircuit.getCircuitTypeObj().isLoCircuitType(), this.rollToCktEnd.getNetElement(), this.rollToCktEnd.getEntityIndex(), this.rollToCktEnd.getHoNum(), this.rollToCktEnd.getLoNum());
                if (iNetLink != null && (object2 = ((NetLink)iNetLink).getLotCircuit()) != null && ((String)(object = object2.getCircuitName())).endsWith("_ROLL**")) {
                    object2.rename(((String)object).substring(0, ((String)object).lastIndexOf("_ROLL**")));
                }
                if ((object2 = network.findNetLinkFromSourceCktEnd(this.rollFromCircuit.getCircuitTypeObj().isLoCircuitType(), this.rollFromCktEnd.getNetElement(), this.rollFromCktEnd.getEntityIndex(), this.rollFromCktEnd.getHoNum(), this.rollFromCktEnd.getLoNum())) != null && (object = ((NetLink)object2).getLotCircuit()) != null) {
                    object.setState(2);
                    object.destroyCircuit();
                }
            }
        }
        catch (ConnectionInRoll connectionInRoll) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)connectionInRoll);
            }
            this.exceptionStr.append("Connection in roll - cannot destroy roll");
            return;
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Cannot destroy roll");
            return;
        }
    }

    private boolean isSameRoll(NetRoll netRoll) {
        return netRoll.getNodeModel().getNodeId() == this.getNodeModel().getNodeId() && netRoll.getConnectionIndex() == this.getConnectionIndex();
    }

    private void handleSingleRoll() {
        if (this.dbgOn()) {
            db.println("calling handleSingleRoll() for " + this.getRollTypeString());
        }
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        boolean bl = false;
        boolean bl2 = false;
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        LinkedList<NetCircuitNode> linkedList2 = new LinkedList<NetCircuitNode>();
        LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
        LinkedList linkedList4 = new LinkedList();
        LinkedList linkedList5 = new LinkedList();
        List list = new LinkedList();
        if (linkedList5.isEmpty()) {
            this.rollFromCircuit.getNodeAndSpanListWithCktEnd(this.getRollFromCktEnd(), null, linkedList5, linkedList4);
        }
        list = this.getUnchangedCircuitNodes(linkedList5);
        for (NetCircuitNode netCircuitNode : linkedList5) {
            if (this.rollType == 1) {
                if (iNetElement == null) {
                    iNetElement = netCircuitNode.getNetElement();
                }
            } else if (this.rollType == 2) {
                iNetElement2 = netCircuitNode.getNetElement();
            }
            if (this.hasSameNE(netCircuitNode, this)) {
                bl2 = true;
                bl = true;
                if (this.rollType == 1) {
                    iNetElement2 = netCircuitNode.getNetElement();
                } else if (this.rollType == 2) {
                    iNetElement = netCircuitNode.getNetElement();
                }
            } else {
                bl2 = false;
            }
            if (this.canNodeBeDeleted(bl2, bl)) {
                linkedList2.add(netCircuitNode);
                linkedList3.add(new Integer(netCircuitNode.getNetElement().getNodeId()));
                continue;
            }
            linkedList.add(netCircuitNode);
        }
        if (!bl) {
            if (this.dbgOn()) {
                db.println("Error: Could not find connection that contains roll point");
            }
            this.exceptionStr.append("Error: Could not find connection that contains roll point");
            return;
        }
        NetCircuitEnd netCircuitEnd = null;
        NetCircuitEnd netCircuitEnd2 = null;
        LinkedList<NetCircuitEnd> linkedList6 = new LinkedList<NetCircuitEnd>();
        if (this.rollType == 2) {
            netCircuitEnd = (NetCircuitEnd)this.rollFromCircuit.getPrimarySource();
            netCircuitEnd2 = (NetCircuitEnd)this.rollFromCircuit.getSecondarySource();
            NetCircuitDropInfo netCircuitDropInfo2 = null;
            List list2 = this.rollFromCircuit.getCktDrops();
            for (NetCircuitDropInfo netCircuitDropInfo2 : list2) {
                if (linkedList3.contains(new Integer(netCircuitDropInfo2.getNodeId())) || this.rollFromCktEnd.equals(netCircuitDropInfo2.getNetCktEnd())) continue;
                linkedList6.add(netCircuitDropInfo2.getNetCktEnd());
            }
            if (this.bothCircuitsEqual) {
                linkedList6.add(this.rollToCktEnd);
            } else {
                list2 = this.rollToCircuit.getCktDrops();
                for (NetCircuitDropInfo netCircuitDropInfo2 : list2) {
                    linkedList6.add(netCircuitDropInfo2.getNetCktEnd());
                }
            }
        } else if (this.rollType == 1) {
            boolean bl3;
            netCircuitEnd = (NetCircuitEnd)this.rollFromCircuit.getPrimarySource();
            netCircuitEnd2 = (NetCircuitEnd)this.rollFromCircuit.getSecondarySource();
            boolean bl4 = linkedList3.contains(new Integer(netCircuitEnd.getNodeId()));
            boolean bl5 = bl3 = netCircuitEnd2 == null ? false : linkedList3.contains(new Integer(netCircuitEnd2.getNodeId()));
            if (this.bothCircuitsEqual) {
                if (bl4 && bl3) {
                    netCircuitEnd = this.rollToCktEnd;
                    netCircuitEnd2 = null;
                } else if (bl4 && !bl3) {
                    netCircuitEnd = this.rollToCktEnd;
                } else if (!bl4 && bl3) {
                    netCircuitEnd2 = this.rollToCktEnd;
                }
            } else if (bl4 && bl3) {
                netCircuitEnd = (NetCircuitEnd)this.rollToCircuit.getPrimarySource();
                netCircuitEnd2 = (NetCircuitEnd)this.rollToCircuit.getSecondarySource();
            } else if (bl4 && !bl3) {
                netCircuitEnd = (NetCircuitEnd)this.rollToCircuit.getPrimarySource();
            } else if (!bl4 && bl3) {
                netCircuitEnd2 = (NetCircuitEnd)this.rollToCircuit.getPrimarySource();
            }
            NetCircuitDropInfo netCircuitDropInfo3 = null;
            List list3 = this.rollFromCircuit.getCktDrops();
            for (NetCircuitDropInfo netCircuitDropInfo3 : list3) {
                if (linkedList3.contains(new Integer(netCircuitDropInfo3.getNodeId()))) continue;
                linkedList6.add(netCircuitDropInfo3.getNetCktEnd());
            }
            if (!this.bothCircuitsEqual) {
                list3 = this.rollToCircuit.getCktDrops();
                for (NetCircuitDropInfo netCircuitDropInfo3 : list3) {
                    if (this.isMergePoint(this, netCircuitDropInfo3.getNetCktEnd())) continue;
                    linkedList6.add(netCircuitDropInfo3.getNetCktEnd());
                }
            }
        }
        if (this.dbgOn()) {
            db.println("calling finishRolls: sourceRollNode = " + iNetElement.getName() + ", destinationRollNode = " + iNetElement2.getName());
        }
        this.finishRolls(linkedList, linkedList2, list, linkedList4, netCircuitEnd, netCircuitEnd2, linkedList6, iNetElement, iNetElement2);
    }

    private boolean hasSameNE(NetCircuitNode netCircuitNode, NetRoll netRoll) {
        return netCircuitNode.getNetElement() == netRoll.getNetElement();
    }

    private boolean canNodeBeDeleted(boolean bl, boolean bl2) {
        return this.rollType == 2 ? !bl && bl2 : this.rollType == 1 && !bl && !bl2;
    }

    private void handleDualRolls(NetRoll netRoll, NetRoll netRoll2) {
        if (this.dbgOn()) {
            db.println("calling handleDualRolls() for " + this.getRollTypeString());
        }
        INetElement iNetElement = null;
        INetElement iNetElement2 = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        LinkedList<NetCircuitNode> linkedList2 = new LinkedList<NetCircuitNode>();
        LinkedList<Integer> linkedList3 = new LinkedList<Integer>();
        LinkedList linkedList4 = new LinkedList();
        LinkedList linkedList5 = new LinkedList();
        List list = new LinkedList();
        this.rollFromCircuit.getNodeAndSpanListWithCktEnd(netRoll.getRollFromCktEnd(), netRoll2.getRollFromCktEnd(), linkedList5, linkedList4);
        list = this.getUnchangedCircuitNodes(linkedList5);
        for (NetCircuitNode netCircuitNode : linkedList5) {
            if (this.hasSameNE(netCircuitNode, netRoll2)) {
                bl4 = true;
                bl2 = true;
                bl3 = false;
                iNetElement2 = netCircuitNode.getNetElement();
            } else if (this.hasSameNE(netCircuitNode, netRoll)) {
                bl3 = true;
                bl = true;
                bl4 = false;
                iNetElement = netCircuitNode.getNetElement();
            } else {
                bl4 = false;
                bl3 = false;
            }
            if (bl && !bl3 && !bl2) {
                linkedList2.add(netCircuitNode);
                linkedList3.add(new Integer(netCircuitNode.getNetElement().getNodeId()));
                continue;
            }
            linkedList.add(netCircuitNode);
        }
        if (!bl2 || !bl) {
            if (this.dbgOn()) {
                db.println("Error: Could not find connection that contains roll point");
            }
            this.exceptionStr.append("Error: Could not find connection that contains roll point");
            return;
        }
        NetCircuitEnd netCircuitEnd = (NetCircuitEnd)this.rollFromCircuit.getPrimarySource();
        NetCircuitEnd netCircuitEnd2 = (NetCircuitEnd)this.rollFromCircuit.getSecondarySource();
        LinkedList<NetCircuitEnd> linkedList6 = new LinkedList<NetCircuitEnd>();
        NetCircuitDropInfo netCircuitDropInfo2 = null;
        List list2 = this.rollFromCircuit.getCktDrops();
        for (NetCircuitDropInfo netCircuitDropInfo2 : list2) {
            if (linkedList3.contains(new Integer(netCircuitDropInfo2.getNodeId()))) continue;
            linkedList6.add(netCircuitDropInfo2.getNetCktEnd());
        }
        if (!this.bothCircuitsEqual) {
            list2 = this.rollToCircuit.getCktDrops();
            for (NetCircuitDropInfo netCircuitDropInfo2 : list2) {
                if (this.isMergePoint(netRoll2, netCircuitDropInfo2.getNetCktEnd())) continue;
                linkedList6.add(netCircuitDropInfo2.getNetCktEnd());
            }
        }
        if (this.dbgOn()) {
            db.println("calling finishRolls: sourceRollNode = " + iNetElement.getName() + ", destinationRollNode = " + iNetElement2.getName());
        }
        this.finishRolls(linkedList, linkedList2, list, linkedList4, netCircuitEnd, netCircuitEnd2, linkedList6, iNetElement, iNetElement2);
    }

    private void finishRolls(List list, List list2, List list3, List list4, NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2, List list5, INetElement iNetElement, INetElement iNetElement2) {
        try {
            this.deleteRollFromCircuit();
            ICircuitId iCircuitId = this.getNewCircuitId(list4, netCircuitEnd, netCircuitEnd2, list5, iNetElement, iNetElement2);
            if (iCircuitId == null) {
                this.exceptionStr.append("Could not get new circuit Id for roll on " + this.getRollFromCircuitName());
                return;
            }
            this.deleteExtraConns(list2);
            if (this.dbgOn()) {
                db.println("change saved conns circuitId:");
            }
            LinkedList linkedList = new LinkedList();
            this.setConnId(list, iCircuitId, this.rollFromCircuit, linkedList);
            if (this.dbgOn()) {
                db.println("change other path conns circuitId:");
            }
            this.setConnId(list3, iCircuitId, this.rollFromCircuit, linkedList);
            if (!this.bothCircuitsEqual) {
                if (this.dbgOn()) {
                    db.println("change rollTo circuit conns circuitId:");
                }
                this.setConnName(this.rollToCircuit.getCircuitNodes(), this.rollFromCircuit.getCircuitName());
                this.setConnId(this.rollToCircuit.getCircuitNodes(), iCircuitId, this.rollToCircuit, linkedList);
            }
            this.reloadConns(linkedList);
            this.deleteRollToCircuit();
            this.setEmptyLOT2AINS(list4);
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("error during roll processing");
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Error processing circuits for rolls");
            return;
        }
    }

    private ICircuitId getNewCircuitId(List list, NetCircuitEnd netCircuitEnd, NetCircuitEnd netCircuitEnd2, List list2, INetElement iNetElement, INetElement iNetElement2) {
        ICircuitId iCircuitId = null;
        INodeModel iNodeModel = netCircuitEnd.getNodeModel();
        try {
            CktInfo cktInfo = new CktInfo();
            if (this.dbgOn()) {
                db.println("new primarySrc = " + netCircuitEnd.prettyString());
            }
            cktInfo.setSrcPoint(netCircuitEnd.getCircuitEnd());
            if (netCircuitEnd2 != null) {
                if (this.dbgOn()) {
                    db.println("new secSrc = " + netCircuitEnd2.prettyString());
                }
                cktInfo.setSecSrcPoint(netCircuitEnd2.getCircuitEnd());
            } else {
                NetRoll.setNullSecSrcPoint(cktInfo);
            }
            int n = this.deriveNewPathProt(list, iNetElement, iNetElement2);
            LinkedList<ICircuitDropInfo> linkedList = new LinkedList<ICircuitDropInfo>();
            NetCircuitEnd netCircuitEnd32 = null;
            NetCircuitDropInfo netCircuitDropInfo = null;
            for (NetCircuitEnd netCircuitEnd32 : list2) {
                if (this.dbgOn()) {
                    db.println("new drop = " + netCircuitEnd32.prettyString());
                }
                netCircuitDropInfo = new NetCircuitDropInfo(netCircuitEnd32, n);
                linkedList.add(netCircuitDropInfo.getCircuitDropInfo());
            }
            ICircuitDropInfo[] iCircuitDropInfoArray = new ICircuitDropInfo[]{};
            iCircuitDropInfoArray = linkedList.toArray(iCircuitDropInfoArray);
            cktInfo.setDropInfo(iCircuitDropInfoArray);
            VlanSetManager.instance();
            cktInfo.setVlans(VlanSetManager.vlanModelToVlanInfo(this.rollFromCircuit.getVlans()));
            cktInfo.setMonitor(this.rollFromCircuit.isMonitorCircuit());
            cktInfo.setCircuitSize(this.rollFromCircuit.getCircuitSize());
            cktInfo.setCircuitType(this.rollFromCircuit.getCircuitType());
            cktInfo.setCircuitName(this.rollFromCircuit.getCircuitName());
            cktInfo.setDir(this.rollFromCircuit.getCircuitDir());
            iCircuitId = this.rollFromCircuit.getOperator().createCircuitInfo(iNodeModel, cktInfo);
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Unable to create new circuit info for circuit " + this.rollFromCircuit.getCircuitName());
            }
            return null;
        }
        return iCircuitId;
    }

    private int deriveNewPathProt(List list, INetElement iNetElement, INetElement iNetElement2) {
        Object object2;
        List list2 = new LinkedList();
        if (!this.isSourceDropRoll()) {
            list2 = list;
        }
        List list3 = this.getConnectingSpans();
        if (!this.bothCircuitsEqual) {
            list3.addAll(this.rollToCircuit.getCircuitSpans());
        }
        if (this.rollFromCircuit.isOldRouteUPSR(list2) && !this.bothCircuitsEqual) {
            for (Object object2 : list3) {
                ((NetCircuitSpan)object2).setUpsrLink(true);
            }
        }
        LinkedList linkedList = new LinkedList();
        object2 = new LinkedList();
        this.rollFromCircuit.getNewSpanAndNodeList(list3, list2, linkedList, (List)object2);
        if (this.dbgOn()) {
            CmsObservable cmsObservable;
            int n;
            db.println("<<< new route contains following spans : >>>");
            for (n = 0; n < list3.size(); ++n) {
                cmsObservable = (NetCircuitSpan)list3.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)cmsObservable).prettyString());
            }
            db.println("<<< old route contains following spans : >>>");
            for (n = 0; n < list2.size(); ++n) {
                cmsObservable = (NetCircuitSpan)list2.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)cmsObservable).prettyString());
            }
            db.println("<<< spanList contains following spans : >>>");
            for (n = 0; n < linkedList.size(); ++n) {
                cmsObservable = (NetCircuitSpan)linkedList.get(n);
                db.println("span " + n + " is : " + ((NetCircuitSpan)cmsObservable).prettyString());
            }
            db.println("<<< nodeList contains following nodes : >>>");
            for (n = 0; n < object2.size(); ++n) {
                cmsObservable = (NetCircuitNode)object2.get(n);
                db.println("node " + n + " is : " + ((NetCircuitNode)cmsObservable).getNodeModel().getName());
            }
        }
        for (CmsObservable cmsObservable : this.rollToCircuit.getCircuitSpans()) {
            ((NetCircuitSpan)cmsObservable).setSrcState(4);
            ((NetCircuitSpan)cmsObservable).setDstState(4);
        }
        int n = this.rollFromCircuit.getProtType(linkedList, new LinkedList());
        if (NetProtectionType.isProtectedType(n)) {
            return 0;
        }
        return 2;
    }

    private List getConnectingSpans() {
        LinkedList linkedList = new LinkedList();
        if (this.circuitRollNumber == 1) {
            linkedList.addAll(this.getConnectingSpans(this));
        } else if (this.circuitRollNumber == 2) {
            linkedList.addAll(this.getConnectingSpans(this));
            if (!this.bothCircuitsEqual) {
                linkedList.addAll(this.getConnectingSpans(this.siblingRoll));
            }
        }
        return linkedList;
    }

    private List getConnectingSpans(NetRoll netRoll) {
        LinkedList<NetCircuitSpan> linkedList = new LinkedList<NetCircuitSpan>();
        if (netRoll == null) {
            return linkedList;
        }
        NetCircuitSpan netCircuitSpan = this.getRollFromSpan(netRoll);
        NetCircuitSpan netCircuitSpan2 = this.getRollToSpan(netRoll);
        if (netCircuitSpan2 != null) {
            if (netCircuitSpan != null) {
                netCircuitSpan2.setUpsrLink(netCircuitSpan.getUpsrLink());
            }
            linkedList.add(netCircuitSpan2);
        }
        return linkedList;
    }

    private NetCircuitSpan getRollFromSpan(NetRoll netRoll) {
        NetCcatCircuit netCcatCircuit = netRoll.getFromCircuit();
        NetCircuitEnd netCircuitEnd = netRoll.getRollFromCktEnd();
        if (netRoll.getRollType() == 1) {
            return netCcatCircuit.getCircuitSpanFromDstCktEnd(netCircuitEnd);
        }
        if (netRoll.getRollType() == 2) {
            return netCcatCircuit.getCircuitSpanFromSrcCktEnd(netCircuitEnd);
        }
        return null;
    }

    private NetCircuitSpan getRollToSpan(NetRoll netRoll) {
        NetCcatCircuit netCcatCircuit = netRoll.getFromCircuit();
        NetCircuitEnd netCircuitEnd = netRoll.getRollToCktEnd();
        Network network = Network.instance();
        INetLink iNetLink = null;
        if (netRoll.getRollType() == 1) {
            iNetLink = network.findNetLinkFromDestinationCktEnd(netCcatCircuit.getCircuitTypeObj().isLoCircuitType(), netCircuitEnd.getNetElement(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum());
        } else if (netRoll.getRollType() == 2) {
            iNetLink = network.findNetLinkFromSourceCktEnd(netCcatCircuit.getCircuitTypeObj().isLoCircuitType(), netCircuitEnd.getNetElement(), netCircuitEnd.getEntityIndex(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum());
        }
        if (iNetLink != null) {
            INetLink iNetLink2 = network.findReverseLink(iNetLink);
            NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink, iNetLink2, netCircuitEnd.getHoNum(), netCircuitEnd.getHoNum(), netCircuitEnd.getLoNum());
            return NetCircuitSpanFactory.createCircuitSpan(netCcatCircuit, netLinkSpan, null, null);
        }
        return null;
    }

    private boolean isMergePoint(NetRoll netRoll, NetCircuitEnd netCircuitEnd) {
        if (netRoll == null) {
            return false;
        }
        NetCircuitEnd netCircuitEnd2 = netRoll.getRollToCktEnd();
        Network network = Network.instance();
        INetLink iNetLink = network.findNetLinkFromSourceCktEnd(netRoll.getFromCircuit().getCircuitTypeObj().isLoCircuitType(), netCircuitEnd2.getNetElement(), netCircuitEnd2.getEntityIndex(), netCircuitEnd2.getHoNum(), netCircuitEnd2.getLoNum());
        return iNetLink != null && iNetLink.getDst() == netCircuitEnd.getNetElement() && iNetLink.getDstEntityIndex() == netCircuitEnd.getEntityIndex();
    }

    private void deleteExtraConns(List list) {
        if (this.dbgOn()) {
            db.println("delete all extra conns: ");
        }
        Iterator iterator = list.iterator();
        NetCircuitNode netCircuitNode = null;
        try {
            while (iterator.hasNext()) {
                netCircuitNode = (NetCircuitNode)iterator.next();
                if (this.dbgOn()) {
                    db.println("   on node = " + netCircuitNode.getName());
                }
                netCircuitNode.deactivate();
                this.rollFromCircuit.disposeConnection(netCircuitNode, true);
            }
        }
        catch (DeletionError deletionError) {
            this.exceptionStr.append("Could not delete connection on " + netCircuitNode.getNetElement().getHostName());
        }
    }

    private void reloadConns(List list) {
        if (this.dbgOn()) {
            db.println("reload connections: ");
        }
        for (INetElement iNetElement : list) {
            if (this.dbgOn()) {
                db.println("   on node = " + iNetElement.getName());
            }
            NetCircuitWatchDog.instance().reloadConnections(iNetElement);
        }
    }

    private void setConnId(List list, ICircuitId iCircuitId, NetCcatCircuit netCcatCircuit, List list2) {
        if (this.dbgOn()) {
            db.println("set connections with newId");
        }
        for (NetCircuitNode netCircuitNode : list) {
            if (this.dbgOn()) {
                db.println("   on node = " + netCircuitNode.getName());
            }
            netCircuitNode.setConnectionCircuitId(iCircuitId);
            netCcatCircuit.disposeConnection(netCircuitNode, true);
            list2.add(netCircuitNode.getNetElement());
        }
    }

    private void setConnName(List list, String string) {
        if (this.dbgOn()) {
            db.println("set connections with newName");
        }
        for (NetCircuitNode netCircuitNode : list) {
            if (this.dbgOn()) {
                db.println("   on node = " + netCircuitNode.getName());
            }
            try {
                netCircuitNode.setConnName(string);
            }
            catch (CircuitProvError circuitProvError) {}
        }
    }

    private void deleteRollFromCircuit() {
        try {
            if (this.dbgOn()) {
                db.println("delete RollFrom circuit model");
            }
            this.rollFromCircuit.deleteCircuitModel();
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Unable to delete old circuit");
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Unable to delete old circuit");
        }
        this.rollFromCircuit.deleteCircuitInfoObserver();
    }

    private void deleteRollToCircuit() {
        try {
            if (!this.bothCircuitsEqual) {
                if (this.dbgOn()) {
                    db.println("delete RollTo circuit model");
                }
                this.rollToCircuit.deleteCircuitModel();
            }
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Unable to delete old circuit");
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Unable to delete old circuit");
        }
    }

    private boolean isLastPortGroupRoll() {
        Object object;
        Object object22;
        LinkedList<IConnectionModel> linkedList = new LinkedList<IConnectionModel>();
        INetElement iNetElement = this.rollFromCktEnd.getNetElement();
        List list = PortGrouping.getVc3CircuitsInPortGroup(this.rollFromCircuit);
        for (Object object22 : list) {
            object = null;
            List list2 = object22.getCircuitNodeFromNE(iNetElement);
            if (list2 != null) {
                if (list2.size() > 1) {
                    if (this.dbgOn()) {
                        db.println("Error !! MXPN on VC3 circuit");
                    }
                } else {
                    object = (INetCircuitNode)list2.get(0);
                }
            }
            if (object == null) continue;
            linkedList.add(object.getConn());
        }
        object22 = RollManager.instance().getRolls(linkedList);
        Iterator iterator = object22.iterator();
        while (iterator.hasNext()) {
            object = (NetRoll)((Object)iterator.next());
            if (object == this || !object.isRollRefValid) continue;
            return false;
        }
        return true;
    }

    private void rollDestroy() throws ConnectionInRoll {
        block4: {
            try {
                if (this.dbgOn()) {
                    db.println("Destroying roll on circuit " + this.rollFromCircuit.getCircuitName() + " at node " + this.node.getName());
                }
                this.getRollModel().rollDestroy();
            }
            catch (ConnectionInRoll connectionInRoll) {
                throw connectionInRoll;
            }
            catch (Exception exception) {
                if (!this.dbgOn()) break block4;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.isRollRefValid = false;
        this.setChanged();
    }

    private boolean allRollsCompleted() {
        List list = RollManager.instance().getRolls(this.rollFromCircuit);
        Iterator iterator = list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            NetRoll netRoll = (NetRoll)((Object)iterator.next());
            if (netRoll.getRollFinish() != 3) {
                if (this.dbgOn()) {
                    db.println("The roll has not been completed: " + netRoll.getPathString() + ", " + netRoll.getRollFromCircuitName() + ", " + "roll finish=" + netRoll.getRollFinish());
                }
                bl = false;
                break;
            }
            if (!this.dbgOn()) continue;
            db.println("The roll has been completed: " + netRoll.getPathString() + ", " + netRoll.getRollFromCircuitName() + ", " + "roll finish=" + netRoll.getRollFinish());
        }
        return bl;
    }

    private boolean allRollsCancelled() {
        List list = RollManager.instance().getRolls(this.rollFromCircuit);
        Iterator iterator = list.iterator();
        boolean bl = true;
        while (iterator.hasNext()) {
            NetRoll netRoll = (NetRoll)((Object)iterator.next());
            if (netRoll.getRollFinish() != 2) {
                if (this.dbgOn()) {
                    db.println("The roll has not been canceled: " + netRoll.getPathString() + ", " + netRoll.getRollFromCircuitName() + ", " + "roll finish=" + netRoll.getRollFinish());
                }
                bl = false;
                break;
            }
            if (!this.dbgOn()) continue;
            db.println("The roll has been canceled: " + netRoll.getPathString() + ", " + netRoll.getRollFromCircuitName() + ", " + "roll finish=" + netRoll.getRollFinish());
        }
        return bl;
    }

    private void destroyAllRolls() {
        try {
            if (this.dbgOn()) {
                db.println("Destroying dual rolls, circuit roll number " + this.circuitRollNumber);
            }
            if (this.siblingRoll != null) {
                if (this.dbgOn()) {
                    db.println("Destroying sibling roll with path " + this.getPathString());
                }
                this.siblingRoll.rollDestroy();
            }
            if (this.dbgOn()) {
                db.println("Destroying roll with path " + this.getPathString());
            }
            this.rollDestroy();
            if (PortGrouping.isPortGroupingCircuit(this.rollFromCircuit)) {
                String string;
                INetCircuit iNetCircuit;
                INetLink iNetLink;
                if (this.isLastPortGroupRoll() && (iNetLink = Network.instance().findNetLinkFromSourceCktEnd(this.rollToCircuit.getCircuitTypeObj().isLoCircuitType(), this.rollToCktEnd.getNetElement(), this.rollToCktEnd.getEntityIndex(), this.rollToCktEnd.getHoNum(), this.rollToCktEnd.getLoNum())) != null && (iNetCircuit = ((NetLink)iNetLink).getLotCircuit()) != null && (string = iNetCircuit.getCircuitName()).endsWith("_ROLL**")) {
                    if (this.dbgOn()) {
                        db.println("Destroying roll to tunnel circuit");
                    }
                    iNetCircuit.setState(2);
                    iNetCircuit.destroyCircuit();
                }
            } else {
                String string = this.rollToCircuit.getCircuitName();
                if (string.endsWith("_ROLL**")) {
                    if (this.dbgOn()) {
                        db.println("Destroying roll to circuit");
                    }
                    this.rollToCircuit.setState(2);
                    this.rollToCircuit.destroyCircuit();
                    this.rollToCircuit = null;
                } else {
                    if (this.dbgOn()) {
                        db.println("Setting roll to circuit " + this.getRollToCircuitName() + " back to DISCOVERED");
                    }
                    this.rollToCircuit.setInRoll(false);
                }
            }
        }
        catch (ConnectionInRoll connectionInRoll) {
            if (this.dbgOn()) {
                db.println("Could not destroy roll - connection in roll");
                SDebug.printStackTrace((Throwable)connectionInRoll);
            }
            this.exceptionStr.append("Could not destroy roll - connection in roll");
            return;
        }
        catch (IncorrectCircuitState incorrectCircuitState) {
            if (this.dbgOn()) {
                db.println("Could not destroy rollTo circuit");
                SDebug.printStackTrace((Throwable)incorrectCircuitState);
            }
            this.exceptionStr.append("Could not destroy rollTo circuit");
            return;
        }
        catch (Exception exception) {
            if (this.dbgOn()) {
                db.println("Could not destroy roll");
                SDebug.printStackTrace((Throwable)exception);
            }
            this.exceptionStr.append("Could not destroy roll ");
            return;
        }
    }

    private void cleanUpCircuitInfo() {
        if (this.rollFromCircuit != null) {
            this.rollFromCircuit.deleteObserver(this);
            this.rollFromCircuit = null;
        }
        if (this.rollToCircuit != null) {
            this.rollToCircuit.deleteObserver(this);
            this.rollToCircuit = null;
        }
    }

    private void cleanUpSiblingRoll() {
        if (this.siblingRoll != null) {
            this.siblingRoll.setSiblingRoll(null);
            this.setSiblingRoll(null);
        }
    }

    protected static void setNullSecSrcPoint(ICircuitInfo iCircuitInfo) {
        iCircuitInfo.setSecSrcPoint((ICircuitEnd)new CircuitEnd(0, 0, null, null, false, 0));
    }

    protected static boolean isNullCircuitId(ICircuitId iCircuitId) {
        if (iCircuitId == null) {
            return true;
        }
        return iCircuitId.getNodeId() == 0 && iCircuitId.getUniquePart().getUniqueId() == 0;
    }

    private void setEmptyLOT2AINS(List list) {
        if (this.rollFromCircuit.getCircuitTypeObj().isLoCircuitType()) {
            for (NetCircuitSpan netCircuitSpan : list) {
                if (!netCircuitSpan.getLink().isLOTunnel()) continue;
                INetCircuit iNetCircuit = ((NetLink)netCircuitSpan.getLink()).getLotCircuit();
                try {
                    iNetCircuit.destroySanityCheck();
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    continue;
                }
                if (this.dbgOn()) {
                    db.println("setEmptyLOT2AINS on tunnel " + iNetCircuit.getCircuitName());
                }
                try {
                    iNetCircuit.setAdminState(3);
                }
                catch (Exception exception) {
                    if (this.dbgOn()) {
                        db.println("Unable to change tunnel admin state");
                        SDebug.printStackTrace((Throwable)exception);
                    }
                    this.exceptionStr.append("Unable to change tunnel admin state");
                }
            }
        }
    }

    public String getPathString() {
        return this.ne.getName() + "/" + NetRoll.slashSeparatedStr(this.rollCktEnd);
    }

    public String getRollFromPathString() {
        return this.ne.getName() + "/" + NetRoll.slashSeparatedStr(this.rollFromCktEnd);
    }

    public String getRollToPathString() {
        return this.ne.getName() + "/" + NetRoll.slashSeparatedStr(this.rollToCktEnd);
    }

    public String getRollTypeString() {
        switch (this.rollType) {
            case 1: {
                return "Source roll";
            }
            case 2: {
                return "Destination roll";
            }
        }
        return "Invalid roll type";
    }

    public String getRollModeString() {
        switch (this.rollMode) {
            case 0: {
                return "Auto";
            }
            case 1: {
                return "Manual";
            }
        }
        return "Invalid roll type";
    }

    public static String slashSeparatedStr(INetCircuitEnd iNetCircuitEnd) {
        return CircuitEndCellRenderer.asSlashSeparatedString(iNetCircuitEnd);
    }

    public void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println("");
        if (this.circuitRollNumber == 0) {
            sDebug.println("TL1 Roll (node " + this.ne.getName() + ")");
        } else if (this.circuitRollNumber == 1) {
            sDebug.println("Single Roll (node " + this.ne.getName() + ")");
        } else if (this.circuitRollNumber == 2) {
            sDebug.println("Dual Roll (node " + this.ne.getName() + ")");
        }
        sDebug.println("This roll = " + (Object)((Object)this));
        if (this.circuitRollNumber == 2) {
            if (this.siblingRoll == null) {
                sDebug.println("Sibling roll is not found");
            } else {
                sDebug.println("Sibling roll = " + (Object)((Object)this.siblingRoll));
            }
        }
        sDebug.println("Roll From Circuit = " + this.getRollFromCircuitName() + " (" + this.rollFromCircuit + ")");
        sDebug.println("Roll To Circuit = " + this.getRollToCircuitName() + " (" + this.rollToCircuit + ")");
        sDebug.println("Roll From Point = " + this.getRollFromPathString());
        sDebug.println("Roll To Point = " + this.getRollToPathString());
        sDebug.println("Roll Type = " + this.getRollTypeString());
        sDebug.println("Roll Mode = " + this.getRollModeString());
        sDebug.println("Circuit Roll Mode = " + EnumStrings.getString(ICircuitRollMode.class, (int)this.circuitRollMode));
        sDebug.println("Roll Valid Signal = " + this.getRollValidSignal());
        sDebug.println("Roll Finish Flag = " + EnumStrings.getString(ICircuitRollFinish.class, (int)this.getRollFinish()));
        sDebug.println("Roll State = " + EnumStrings.getString(IRollState.class, (int)this.getState()));
        sDebug.println("Connection Index = " + this.getConnectionIndex());
        sDebug.println("Circuit Size = " + this.getCircuitSize());
        sDebug.println("");
    }

    protected boolean dbgOn() {
        return db.on() || RollManager.pkgDbgOn();
    }

    public class CircuitBirthObserver
    implements Observer {
        ICircuitId unbornCktId;

        public CircuitBirthObserver(ICircuitId iCircuitId) {
            this.unbornCktId = iCircuitId;
        }

        @Override
        public void update(Observable observable, Object object) {
            if ((NetRoll.this.rollFromCircuit == null || NetRoll.this.rollToCircuit == null) && object instanceof NetCcatCircuit) {
                if (NetRoll.this.dbgOn()) {
                    db.println("NetCircuitManager.update: type = ADDED " + ((NetCcatCircuit)object).getCircuitName() + "(" + object + ")");
                }
                NetRoll.this.updateCircuitAdditionInfo((NetCcatCircuit)object, this.unbornCktId, this);
                NetRoll.this.notifyObservers(ModelUpdateType.CHANGED);
            }
        }
    }
}

