/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.AsymVcatNotSupported;
import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CcatCircuitsExistsOnPort;
import cerent.cms.model.CircuitId;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitDirection;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.ICircuitSize;
import cerent.cms.model.ICircuitType;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IHoPathDefModel;
import cerent.cms.model.IHoVcatTermModel;
import cerent.cms.model.ILoDefModel;
import cerent.cms.model.ILoVcatTermModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IVcatTermAttributes;
import cerent.cms.model.IVcatTermMember;
import cerent.cms.model.IVcatTermModel;
import cerent.cms.model.IVcatTermModels;
import cerent.cms.model.InvalidNumOfMembers;
import cerent.cms.model.InvalidOperation;
import cerent.cms.model.InvalidParms;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidStatus;
import cerent.cms.model.InvalidVcatMode;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoMoreLoCapableHo;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.PathInUse;
import cerent.cms.model.PathWidthNotsupported;
import cerent.cms.model.UniDirVcatNotSupported;
import cerent.cms.model.VcatExists;
import cerent.cms.model.VcatMemberInvalidState;
import cerent.cms.model.VcatMemberNotOutOfGroup;
import cerent.cms.model.VcatNotReconfigurable;
import cerent.cms.model.VcatNotSupported;
import cerent.cms.model.VcatTermAttributes;
import cerent.cms.ncp.CircuitCreatInfo;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.HoCircuitEnd;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.INetCircuitProvState;
import cerent.cms.ncp.INetVcatTermination;
import cerent.cms.ncp.LoCircuitEnd;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitFactory;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitWatchDog;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.NetVcatGroup;
import cerent.cms.ncp.TL1ObjectManager;
import cerent.cms.topo.INetElement;
import cerent.util.EnumStrings;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class NetVcatTermination
extends CmsObservable
implements INetVcatTermination,
IObserver {
    private static final SDebug db = new SDebug("NetVcatTermination");
    private IVcatTermModel vcatTermModel;
    private NetVcatCircuit circuit;
    private INetElement ne;
    private boolean isNodeRefValid;
    private NetCircuitEnd netCktEnd;
    private String vcatName;
    private ICircuitId cktId;
    private int lcasMode;
    private int direction;
    private int txMembers;
    private int rxMembers;
    private int state;
    private boolean extBuffer;
    private Map netCktNodes;
    private UpdateEvent updateEvent;

    protected NetVcatTermination(NetVcatCircuit netVcatCircuit, NetCircuitEnd netCircuitEnd, String string, ICircuitId iCircuitId, int n, int n2, int n3, int n4, boolean bl) {
        this.netCktEnd = netCircuitEnd;
        this.circuit = netVcatCircuit;
        this.ne = netCircuitEnd.getNetElement();
        this.updateEvent = new UpdateEvent();
        this.state = 0;
        this.vcatName = string;
        this.cktId = iCircuitId;
        this.lcasMode = n;
        this.direction = n2;
        this.txMembers = n3;
        this.rxMembers = n4;
        this.extBuffer = bl;
        this.vcatTermModel = null;
        this.isNodeRefValid = true;
    }

    protected NetVcatTermination(NetVcatCircuit netVcatCircuit, NetCircuitEnd netCircuitEnd, CircuitCreatInfo circuitCreatInfo) {
        this(netVcatCircuit, netCircuitEnd, circuitCreatInfo.name(), new CircuitId(0, 0), circuitCreatInfo.lcasMode(), circuitCreatInfo.dir(), circuitCreatInfo.forwardMembers(), circuitCreatInfo.reverseMembers(), false);
        this.netCktNodes = this.initMemberNodes();
    }

    protected NetVcatTermination(NetVcatCircuit netVcatCircuit, NetCircuitEnd netCircuitEnd, NetVcatTermination netVcatTermination) {
        this(netVcatCircuit, netCircuitEnd, netVcatTermination.getVcatName(), netVcatTermination.getCircuitId(), netVcatTermination.getLcasMode(), netVcatTermination.getDirection(), netVcatTermination.getConfiguredNumOfMembers(1), netVcatTermination.getConfiguredNumOfMembers(0), netVcatTermination.getExtBuffer());
        this.netCktNodes = this.initMemberNodes();
    }

    protected NetVcatTermination(NetVcatCircuit netVcatCircuit, NetCircuitEnd netCircuitEnd, Object object) {
        block11: {
            block10: {
                this(netVcatCircuit, netCircuitEnd, "", new CircuitId(0, 0), -1, -1, -1, -1, false);
                this.vcatTermModel = (IVcatTermModel)object;
                this.vcatName = this.getVcatNameFromNE();
                this.cktId = this.getVcatTermCircuitId();
                this.lcasMode = this.vcatTermModel.getLcasMode();
                this.direction = this.vcatTermModel.getDirection();
                if (this.getNodeModel().provides(Feature.VCAT_LCAS)) {
                    this.extBuffer = this.vcatTermModel.getExtBuffer();
                }
                try {
                    this.txMembers = this.getConfiguredNumOfMembersOnNE(1);
                }
                catch (InvalidParms invalidParms) {
                    if (this.dbgOn()) {
                        db.println("constructor: Unable to getNumberOfMembers");
                        SDebug.printStackTrace((Throwable)invalidParms);
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (!this.dbgOn()) break block10;
                    db.println("constructor: Unable to getNumberOfMembers");
                    SDebug.printStackTrace((Throwable)objNotFound);
                }
            }
            try {
                this.rxMembers = this.getConfiguredNumOfMembersOnNE(0);
            }
            catch (InvalidParms invalidParms) {
                if (this.dbgOn()) {
                    db.println("constructor: Unable to getNumberOfMembers");
                    SDebug.printStackTrace((Throwable)invalidParms);
                }
            }
            catch (ObjNotFound objNotFound) {
                if (!this.dbgOn()) break block11;
                db.println("constructor: Unable to getNumberOfMembers");
                SDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        this.netCktNodes = this.initMemberNodes();
        this.addVcatTermObserver();
        this.setState(2);
        if (NetVcatCircuit.isNullCircuitId(this.cktId)) {
            TL1ObjectManager.instance().registerTL1Object(this.ne, object, this);
        }
    }

    private Map initMemberNodes() {
        HashMap hashMap = new HashMap();
        if (this.getDirection() == 1) {
            hashMap.put(new Integer(2), new LinkedList());
        } else {
            hashMap.put(new Integer(0), new LinkedList());
            hashMap.put(new Integer(1), new LinkedList());
        }
        return hashMap;
    }

    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    protected IVcatTermModel getVcatTerm() {
        return this.vcatTermModel;
    }

    @Override
    public INetCircuit getCircuit() {
        return this.circuit;
    }

    @Override
    public INetElement getNetElement() {
        return this.ne;
    }

    public INodeModel getNodeModel() {
        return this.ne.getNodeModel();
    }

    protected void setVcatCircuit(NetVcatCircuit netVcatCircuit) {
        this.circuit = netVcatCircuit;
    }

    @Override
    public INetCircuitEnd getNetCktEnd() {
        return this.netCktEnd;
    }

    protected void setNetCktEnd(NetCircuitEnd netCircuitEnd) {
        this.netCktEnd = netCircuitEnd;
    }

    @Override
    public Short[] getAvailableVcatMemNums() {
        if (this.vcatTermModel == null) {
            return new Short[0];
        }
        return this.vcatTermModel.getAvailableVcatMemNums();
    }

    @Override
    public short getNumOfNewMembersAllowed() throws VcatNotReconfigurable {
        if (this.vcatTermModel == null) {
            return 0;
        }
        if (this.getNodeModel().provides(Feature.VCAT_LCAS)) {
            return this.vcatTermModel.getNumOfNewMemsAllowed();
        }
        throw new VcatNotReconfigurable("getNumOfNewMembersAllowed() is not supported on older release");
    }

    @Override
    public int getDirection() {
        return this.direction;
    }

    @Override
    public String getVcatName() {
        return this.vcatName;
    }

    public String getVcatNameFromNE() {
        if (this.vcatTermModel != null && this.getNodeModel().provides(Feature.TCCU)) {
            try {
                return this.vcatTermModel.getVcatName();
            }
            catch (Exception exception) {
                return "";
            }
        }
        return "";
    }

    public void setVcatName(String string) throws CircuitProvError {
        if (this.vcatTermModel == null) {
            if (this.dbgOn()) {
                db.println("setVcatName: Cannot find valid vcatTermModel");
            }
            throw new CircuitProvError("The VCAT name cannot be changed.");
        }
        if (this.getNodeModel().provides(Feature.TCCU)) {
            try {
                this.vcatTermModel.setVcatName(string);
                this.vcatName = string;
            }
            catch (Exception exception) {
                throw new CircuitProvError("The VCAT name cannot be modified.");
            }
        }
    }

    @Override
    public int getLcasMode() {
        return this.lcasMode;
    }

    @Override
    public boolean getExtBuffer() {
        return this.extBuffer;
    }

    public void setExtBuffer(boolean bl) {
        this.extBuffer = bl;
    }

    public int getConfiguredNumOfMembers(int n) {
        switch (n) {
            case 1: {
                return this.txMembers;
            }
            case 0: {
                return this.rxMembers;
            }
            case 2: {
                return this.txMembers;
            }
        }
        return 0;
    }

    protected void setConfiguredNumOfMembers(int n, int n2) {
        switch (n2) {
            case 1: {
                this.txMembers = n;
            }
            case 0: {
                this.rxMembers = n;
            }
            case 2: {
                this.txMembers = n;
                this.rxMembers = n;
            }
        }
    }

    protected int getConfiguredNumOfMembersOnNE(int n) throws ObjNotFound, InvalidParms {
        if (this.vcatTermModel == null) {
            if (this.dbgOn()) {
                db.println("getConfiguredNumOfMembersOnNE: Cannot find valid vcatTermModel");
            }
            throw new ObjNotFound("The member number cannot be retrieved.");
        }
        return this.vcatTermModel.getNumberOfMembers(n);
    }

    protected void setConfiguredNumOfMembersOnNE(int n, int n2) throws ObjNotFound, InvalidOperation, InvalidParms {
        if (this.vcatTermModel == null) {
            if (this.dbgOn()) {
                db.println("setConfiguredNumOfMembersOnNE: Cannot find valid vcatTermModel");
            }
            throw new ObjNotFound("The member number cannot be changed.");
        }
        if (this.dbgOn()) {
            db.println("setConfiguredNumOfMembersOnNE: set configured number of members to " + n);
        }
        this.vcatTermModel.setNumberOfMembers((short)n, n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void insertMemberNode(Integer n, INetCircuitNode iNetCircuitNode) {
        Map map = this.netCktNodes;
        synchronized (map) {
            ((List)this.netCktNodes.get(n)).add(iNetCircuitNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeMemberNode(Integer n, INetCircuitNode iNetCircuitNode) {
        Map map = this.netCktNodes;
        synchronized (map) {
            ((List)this.netCktNodes.get(n)).remove(iNetCircuitNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getAllMemberNodes(int n) {
        LinkedList linkedList;
        Map map = this.netCktNodes;
        synchronized (map) {
            linkedList = new LinkedList((List)this.netCktNodes.get(new Integer(n)));
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map getAllMemberNodes() {
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>();
        Map map = this.netCktNodes;
        synchronized (map) {
            if (this.getDirection() == 1) {
                hashMap.put(new Integer(2), this.getAllMemberNodes(2));
            } else {
                hashMap.put(new Integer(0), this.getAllMemberNodes(0));
                hashMap.put(new Integer(1), this.getAllMemberNodes(1));
            }
        }
        return hashMap;
    }

    protected List getAllMemberConns(int n) {
        if (this.vcatTermModel == null) {
            return new LinkedList();
        }
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        try {
            if (iCircuitType.isHoVcatCircuitType()) {
                return Arrays.asList(((IHoVcatTermModel)this.vcatTermModel).getMembersOfTheVcatTerm(n));
            }
            return Arrays.asList(((ILoVcatTermModel)this.vcatTermModel).getMembersOfTheVcatTerm(n));
        }
        catch (InvalidParms invalidParms) {
            if (this.dbgOn()) {
                db.println("getAllMembers: Unable to getMembersOfTheVcatTerm - InvalidParms");
                SDebug.printStackTrace((Throwable)invalidParms);
            }
            return new LinkedList();
        }
    }

    private Map getAllMemberConns() {
        HashMap<Integer, List> hashMap = new HashMap<Integer, List>();
        if (this.getDirection() == 1) {
            hashMap.put(new Integer(2), this.getAllMemberConns(2));
        } else {
            hashMap.put(new Integer(0), this.getAllMemberConns(0));
            hashMap.put(new Integer(1), this.getAllMemberConns(1));
        }
        return hashMap;
    }

    protected int getMemberStatus(NetCircuitEnd netCircuitEnd) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        if (this.vcatTermModel == null) {
            if (this.dbgOn()) {
                db.println("getMemberStatus: Cannot find valid vcatTermModel");
            }
            throw new ObjNotFound("The member status cannot be retrieved.");
        }
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        if (iCircuitType.isHoVcatCircuitType()) {
            return ((IHoVcatTermModel)this.vcatTermModel).getMemberStatus(this.getHoPathDef(netCircuitEnd));
        }
        return ((ILoVcatTermModel)this.vcatTermModel).getMemberStatus(this.getLoPathDef(netCircuitEnd));
    }

    protected void setMemberStatus(NetCircuitEnd netCircuitEnd, int n) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo, InvalidStatus {
        if (this.vcatTermModel == null) {
            if (this.dbgOn()) {
                db.println("setMemberStatus: Cannot find valid vcatTermModel");
            }
            throw new ObjNotFound("The member status cannot be changed.");
        }
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        if (iCircuitType.isHoVcatCircuitType()) {
            ((IHoVcatTermModel)this.vcatTermModel).setMemberStatus(this.getHoPathDef(netCircuitEnd), n);
        } else {
            ((ILoVcatTermModel)this.vcatTermModel).setMemberStatus(this.getLoPathDef(netCircuitEnd), n);
        }
    }

    private IHoPathDefModel getHoPathDef(NetCircuitEnd netCircuitEnd) throws ObjNotFound {
        ICircuitSize iCircuitSize = this.circuit.getCircuitSizeObj();
        return (IHoPathDefModel)((HoCircuitEnd)netCircuitEnd).getPathDef(iCircuitSize.size2widthOfHoCircuit());
    }

    private ILoDefModel getLoPathDef(NetCircuitEnd netCircuitEnd) throws ObjNotFound, PathInUse, InvalidPath, NoMoreLoCapableHo {
        ICircuitSize iCircuitSize = this.circuit.getCircuitSizeObj();
        return (ILoDefModel)((LoCircuitEnd)netCircuitEnd).getPathDef(iCircuitSize.size2widthOfLoCircuit());
    }

    protected void setVcatTermCircuitId(ICircuitId iCircuitId) {
        if (this.dbgOn()) {
            db.println("setting the vcat term circuit Id at " + this.getNodeName() + " to " + NetCircuit.prettyString(iCircuitId));
        }
        if (this.vcatTermModel != null) {
            this.vcatTermModel.setCircuitId(iCircuitId);
            this.cktId = iCircuitId;
            if (!NetVcatCircuit.isNullCircuitId(iCircuitId)) {
                TL1ObjectManager.instance().deregisterTL1Object(this.ne, this.vcatTermModel);
            }
        } else if (this.dbgOn()) {
            db.println("setVcatTermCircuitId @ Node " + this.getNodeName() + " with vcat term object deleted");
        }
    }

    protected ICircuitId getVcatTermCircuitId() {
        if (this.vcatTermModel != null) {
            return this.vcatTermModel.getCircuitId();
        }
        if (this.dbgOn()) {
            db.println("getVcatTermCircuitId @ Node " + this.getNodeName() + " with vcat term object deleted");
        }
        return null;
    }

    public ICircuitId getCircuitId() {
        return this.cktId;
    }

    protected void setState(int n) {
        if (n != this.state) {
            if (this.dbgOn()) {
                db.println("Node " + this.getNodeName() + " state change: old = " + EnumStrings.getString(INetCircuitProvState.class, (int)this.state) + "; new = " + EnumStrings.getString(INetCircuitProvState.class, (int)n));
            }
            this.state = n;
        }
    }

    protected String getNodeName() {
        return this.ne.getName();
    }

    protected void activate() throws CircuitProvError {
        if (this.state == 2) {
            return;
        }
        if (this.state == 0) {
            this.createVcatTerm();
            return;
        }
        this.modifyVcatTerm();
    }

    protected void deactivate() throws DeletionError {
        if (this.dbgOn()) {
            db.println("Deactivating circuit vcat term " + this.getNodeName());
        }
        if (this.state != 0) {
            try {
                this.destroyVcatTerm();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.dbgOn()) {
                    db.println("i/o exception trying to destroy VcatTerm at " + this.getNodeName());
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                throw new DeletionError("An I/O error occurred on the node " + this.getNodeName() + ".\n" + abstractCmsIOException.getMessage());
            }
            catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                if (this.dbgOn()) {
                    db.println("VcatMemberNotOutOfGroup exception trying to destroy VcatTerm at " + this.getNodeName());
                    SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                }
                throw new DeletionError("Not all connections are out of group. You cannot delete the VCG at this time.");
            }
            catch (VcatMemberInvalidState vcatMemberInvalidState) {
                if (this.dbgOn()) {
                    db.println("VcatMemberInvalidState exception trying to destroy VcatTerm at " + this.getNodeName());
                    SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                }
                throw new DeletionError("The connections are not in valid states. You cannot delete the VCG at this time.");
            }
        }
        this.circuit.disposeVcatTerm(this, true);
    }

    protected boolean deletedEventPending() {
        return this.updateEvent.deleted;
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IVcatTermModel) {
            if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                if (this.dbgOn()) {
                    db.println("vcatTerm.update: type = DELETED " + this.getNodeName());
                }
                this.updateEvent.deleted = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "deleted");
            } else if (((Integer)object).equals(ModelUpdateType.CHANGED)) {
                if (this.dbgOn()) {
                    db.println("vcatTerm.update: type = CHANGED " + this.getNodeName());
                }
                this.updateEvent.changed = true;
                NetCircuitWatchDog.instance().queueCircuitUpdate(this.circuit, this, "changed");
            }
        }
    }

    protected void runUpdate() {
        if (!this.isNodeRefValid) {
            return;
        }
        if (this.updateEvent.deleted) {
            this.updateEvent.deleted = false;
            if (this.dbgOn()) {
                db.println("vcatTerm.runUpdate: type = DELETED at " + this.getNodeName());
            }
            this.updateDeleted();
        } else if (this.updateEvent.changed) {
            this.updateEvent.changed = false;
            if (this.dbgOn()) {
                db.println("vcatTerm.runUpdate: type = CHANGED at " + this.getNodeName());
            }
            this.updateChanged();
        }
    }

    private void updateDeleted() {
        if (this.dbgOn()) {
            db.println("Disposing the Vcat Termination");
        }
        if (this.state == 2 || this.state == 3) {
            this.circuit.disposeVcatTerm(this, true);
        } else if (this.state == 1) {
            this.deleteVcatTermObserver();
            this.vcatTermModel = null;
            this.setState(0);
        } else if (this.state == 0) {
            this.deleteVcatTermObserver();
            this.vcatTermModel = null;
        }
    }

    private void updateChanged() {
        boolean bl;
        block23: {
            ICircuitId iCircuitId;
            if (this.circuit.getState() == 0 || this.circuit.getState() == 2) {
                return;
            }
            if (this.dbgOn()) {
                db.println("handle Vcat Termination changed update on node " + this.getNodeName());
            }
            try {
                iCircuitId = this.getVcatTermCircuitId();
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                return;
            }
            if (this.cktId != null && iCircuitId != null && (this.cktId.getNodeId() != iCircuitId.getNodeId() || this.cktId.getUniquePart().getUniqueId() != iCircuitId.getUniquePart().getUniqueId())) {
                this.cktId = iCircuitId;
                if (this.dbgOn()) {
                    db.println("handleChanges(" + this.getNodeName() + "): cktId changed");
                }
                this.circuit.disposeVcatTerm(this, true);
                NetCircuitWatchDog.instance().reloadVcatTerms(this.ne);
                return;
            }
            String string = this.getVcatNameFromNE();
            if (!this.vcatName.equals(string)) {
                if (this.dbgOn()) {
                    db.println("handleChanges(" + this.getNodeName() + "): vcat name changed");
                }
                this.vcatName = string;
                if (this.getNodeModel() == this.circuit.getSrcNodeModel()) {
                    String string2 = this.circuit.getCircuitNameFromSrcNode();
                    this.circuit.updateCircuitName(string2);
                    this.circuit.setChanged();
                }
            }
            bl = false;
            try {
                int n = this.getConfiguredNumOfMembersOnNE(1);
                int n2 = this.getConfiguredNumOfMembersOnNE(0);
                if (this.txMembers != n) {
                    if (this.dbgOn()) {
                        db.println("handleChanges(" + this.getNodeName() + "): number of tx member changed");
                    }
                    bl = true;
                    this.txMembers = n;
                    this.circuit.setChanged();
                }
                if (this.rxMembers != n2) {
                    if (this.dbgOn()) {
                        db.println("handleChanges(" + this.getNodeName() + "): number of rx member changed");
                    }
                    bl = true;
                    this.rxMembers = n2;
                    this.circuit.setChanged();
                }
            }
            catch (InvalidParms invalidParms) {
                if (this.dbgOn()) {
                    db.println("updateChanged: Unable to getNumberOfMembers");
                    SDebug.printStackTrace((Throwable)invalidParms);
                }
            }
            catch (ObjNotFound objNotFound) {
                if (!this.dbgOn()) break block23;
                db.println("updateChanged: Unable to getNumberOfMembers");
                SDebug.printStackTrace((Throwable)objNotFound);
            }
        }
        Map map = this.getAllMemberConns();
        Map map2 = this.getAllMemberNodes();
        boolean bl2 = this.checkMemberAdded(map, map2);
        map2 = this.getAllMemberNodes();
        boolean bl3 = this.checkMemberDeleted(map, map2);
        if (bl2 || bl3 || bl) {
            if (this.dbgOn()) {
                db.println("updateChanged: check circuit's completeness");
            }
            if (!this.circuit.circuitInfoActive()) {
                if (!this.circuit.tl1CircuitCompleteCheck()) {
                    this.circuit.checkAndUpdateCircuit();
                }
            } else if (!this.circuit.completeCheck()) {
                this.circuit.checkAndUpdateCircuit();
            }
        }
    }

    private boolean checkMemberAdded(Map map, Map map2) {
        if (this.dbgOn()) {
            db.println("calling checkMemberAdded");
        }
        boolean bl = false;
        NetCircuitNode netCircuitNode = null;
        NetVcatGroup netVcatGroup = null;
        NetVcatGroup netVcatGroup2 = null;
        Set set = map.entrySet();
        for (Map.Entry entry : set) {
            Integer n = (Integer)entry.getKey();
            List list = (List)entry.getValue();
            for (IVcatTermMember iVcatTermMember : list) {
                List list2;
                IConnectionModel iConnectionModel = iVcatTermMember.getConnection();
                int n2 = iVcatTermMember.getStatus();
                ICircuitId iCircuitId = NetCircuitNode.getConnCircuitId(iConnectionModel);
                NetCcatCircuit netCcatCircuit = !NetVcatCircuit.isNullCircuitId(iCircuitId) ? (NetCcatCircuit)this.circuit.ncMgr.getCircuitFromId(iCircuitId) : (NetCcatCircuit)this.circuit.ncMgr.getCircuitFromConn(this.getNetElement(), iConnectionModel);
                if (netCcatCircuit == null) {
                    if (this.dbgOn()) {
                        db.println("couldn't find the member circuit, create one using the cross-connect that discovered");
                    }
                    netCcatCircuit = NetCircuitFactory.newCircuitFromConn(this.getNetElement(), iConnectionModel);
                }
                netCircuitNode = (list2 = netCcatCircuit.getCircuitNodeFromNE(this.getNetElement())) != null ? (list2.size() > 1 ? netCcatCircuit.getCircuitNodeFromConn(this.getNetElement(), iConnectionModel) : (NetCircuitNode)list2.get(0)) : null;
                if (netCircuitNode == null) {
                    if (this.dbgOn()) {
                        db.println("couldn't find the member node, create one using the cross-connect that discovered");
                    }
                    netCcatCircuit.addDiscoveredConnection(this.getNetElement(), iConnectionModel);
                    list2 = netCcatCircuit.getCircuitNodeFromNE(this.getNetElement());
                    if (list2 != null) {
                        netCircuitNode = list2.size() > 1 ? netCcatCircuit.getCircuitNodeFromConn(this.getNetElement(), iConnectionModel) : (NetCircuitNode)list2.get(0);
                    } else {
                        netCircuitNode = null;
                        if (this.dbgOn()) {
                            db.println("Error!! not able to find the CircuitNode just added");
                        }
                    }
                }
                if (!this.doesTermContainNode((List)map2.get(n), n, netCircuitNode)) {
                    if (this.dbgOn()) {
                        db.println("add new member (" + netCircuitNode.getName() + ") to netCktNode list");
                    }
                    bl = true;
                    this.insertMemberNode(n, netCircuitNode);
                    NetVcatGroup netVcatGroup3 = this.getVcatGroup(n);
                    if (netVcatGroup3 == null) continue;
                    if (!netVcatGroup3.getAllMemberCircuits().contains(netCcatCircuit)) {
                        if (this.dbgOn()) {
                            db.println("add new member ctk (" + netCcatCircuit.getCircuitName() + ") to the group");
                        }
                        if (!netCcatCircuit.isMemberOfVcat()) {
                            netCcatCircuit.initVcatGroup(netVcatGroup3);
                            this.circuit.ncMgr.convertCcatToMember(netCcatCircuit);
                            this.circuit.ccat2VcatList.add(netCcatCircuit);
                        } else {
                            netVcatGroup = netVcatGroup3;
                            netVcatGroup2 = netCcatCircuit.getVcatGroup();
                        }
                        netVcatGroup3.insertMemberCircuit(netCcatCircuit);
                    } else if (netVcatGroup3.getAllMemberCircuits().contains(netCcatCircuit)) {
                        if (!netCcatCircuit.isMemberOfVcat()) {
                            netCcatCircuit.initVcatGroup(netVcatGroup3);
                            this.circuit.ncMgr.convertCcatToMember(netCcatCircuit);
                            this.circuit.ccat2VcatList.add(netCcatCircuit);
                        }
                        netVcatGroup3.insertMemberCircuit(netCcatCircuit);
                    }
                    netCcatCircuit.deleteSpliceListener(this.netCktEnd);
                    netCcatCircuit.setMemberStatus(this.netCktEnd, n2);
                    continue;
                }
                if (n2 == netCcatCircuit.getMemberStatus(this.netCktEnd)) continue;
                if (this.dbgOn()) {
                    db.println("member status has changed");
                }
                netCcatCircuit.setMemberStatus(this.netCktEnd, n2);
                this.circuit.setChanged();
            }
        }
        if (netVcatGroup != null && netVcatGroup2 != null && netVcatGroup != netVcatGroup2) {
            netVcatGroup.unify(netVcatGroup2, true);
        }
        return bl;
    }

    private boolean checkMemberDeleted(Map map, Map map2) {
        if (this.dbgOn()) {
            db.println("calling checkMemberDeleted");
        }
        boolean bl = false;
        Set set = map2.entrySet();
        for (Map.Entry entry : set) {
            Integer n = (Integer)entry.getKey();
            List list = (List)entry.getValue();
            for (INetCircuitNode iNetCircuitNode : list) {
                NetCcatCircuit netCcatCircuit = (NetCcatCircuit)iNetCircuitNode.getCircuit();
                if (this.doesTermContainConn((List)map.get(n), iNetCircuitNode.getConn())) continue;
                if (this.dbgOn()) {
                    db.println("remove member from netCktNode list");
                }
                bl = true;
                this.removeMemberNode(n, iNetCircuitNode);
                NetVcatGroup netVcatGroup = this.getVcatGroup(n);
                if (netVcatGroup == null) continue;
                if (netCcatCircuit.isMemberOfVcat()) {
                    netCcatCircuit.removeMemberStatus(this.netCktEnd);
                }
                if (!netVcatGroup.getAllMemberCircuits().contains(netCcatCircuit) || !netCcatCircuit.isMemberOfVcat() || netCcatCircuit.getMemberStatusMap().size() != 0) continue;
                if (this.dbgOn()) {
                    db.println("remove member ctk (" + netCcatCircuit.getCircuitName() + ") from the group");
                }
                netVcatGroup.removeMemberCircuit(netCcatCircuit);
                netCcatCircuit.deleteVcatGroup();
                this.circuit.ncMgr.convertMemberToCcat(netCcatCircuit);
                this.circuit.vcat2CcatList.add(netCcatCircuit);
            }
        }
        return bl;
    }

    private NetVcatGroup getVcatGroup(int n) {
        NetVcatGroup netVcatGroup = null;
        if (n == 2) {
            if (this.dbgOn()) {
                db.println("TXRX, return forward group");
            }
            netVcatGroup = (NetVcatGroup)this.circuit.getForwardVcatGroup();
        } else if (this.circuit.getCktSources().contains(this.netCktEnd)) {
            if (n == 0) {
                if (this.dbgOn()) {
                    db.println("match source vcat term, return forward group");
                }
                netVcatGroup = (NetVcatGroup)this.circuit.getForwardVcatGroup();
            } else {
                if (this.dbgOn()) {
                    db.println("match source vcat term, return reverse group");
                }
                netVcatGroup = (NetVcatGroup)this.circuit.getReverseVcatGroup();
            }
        } else if (this.circuit.isDrop(this.netCktEnd)) {
            if (n == 1) {
                if (this.dbgOn()) {
                    db.println("match drop vcat term, return forward group");
                }
                netVcatGroup = (NetVcatGroup)this.circuit.getForwardVcatGroup();
            } else {
                if (this.dbgOn()) {
                    db.println("match drop vcat term, return reverse group");
                }
                netVcatGroup = (NetVcatGroup)this.circuit.getReverseVcatGroup();
            }
        }
        return netVcatGroup;
    }

    private boolean doesTermContainNode(List list, Integer n, INetCircuitNode iNetCircuitNode) {
        for (INetCircuitNode iNetCircuitNode2 : list) {
            if (!iNetCircuitNode2.getCircuit().equals(iNetCircuitNode.getCircuit()) || !iNetCircuitNode2.getNetElement().equals(iNetCircuitNode.getNetElement())) continue;
            if (!iNetCircuitNode2.equals(iNetCircuitNode)) {
                this.removeMemberNode(n, iNetCircuitNode2);
                this.insertMemberNode(n, iNetCircuitNode);
            }
            return true;
        }
        return false;
    }

    private boolean doesTermContainConn(List list, IConnectionModel iConnectionModel) {
        for (IVcatTermMember iVcatTermMember : list) {
            IConnectionModel iConnectionModel2 = iVcatTermMember.getConnection();
            if (!iConnectionModel2.equals(iConnectionModel)) continue;
            return true;
        }
        return false;
    }

    protected void addAllMembers() {
        this.checkMemberAdded(this.getAllMemberConns(), this.initMemberNodes());
    }

    protected void deleteAllMembers() {
        this.checkMemberDeleted(this.initMemberNodes(), this.getAllMemberNodes());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createVcatTerm() throws CircuitProvError {
        IVcatTermModels iVcatTermModels = this.getNodeModel().getVcatTermModels();
        ICircuitType iCircuitType = this.circuit.getCircuitTypeObj();
        ICircuitSize iCircuitSize = this.circuit.getCircuitSizeObj();
        VcatTermAttributes vcatTermAttributes = new VcatTermAttributes((short)this.txMembers, (short)this.rxMembers, this.lcasMode, this.direction, this.extBuffer);
        this.cktId = this.circuit.getCircuitId();
        this.vcatName = this.circuit.getCircuitName();
        if (this.dbgOn()) {
            db.println("createVcatTerm(" + this.getNodeName() + ")" + "; direction=" + EnumStrings.getString(ICircuitDirection.class, (int)this.getDirection()) + "; cktId=" + NetVcatCircuit.prettyString(this.cktId) + "; vcatName=" + this.vcatName);
        }
        Map map = TL1ObjectManager.instance().getTL1VcatTerms();
        synchronized (map) {
            try {
                this.vcatTermModel = iCircuitType.isHoVcatCircuitType() ? iVcatTermModels.createHoVcatTerm(this.cktId, this.netCktEnd.getEntityIndex(), (IVcatTermAttributes)vcatTermAttributes, iCircuitSize.size2widthOfHoCircuit(), this.vcatName) : iVcatTermModels.createLoVcatTerm(this.cktId, this.netCktEnd.getEntityIndex(), (IVcatTermAttributes)vcatTermAttributes, (int)iCircuitSize.size2widthOfLoCircuit(), this.vcatName);
            }
            catch (CTCUserException cTCUserException) {
                if (this.dbgOn()) {
                    db.println("Exception while creating vcat term at " + this.getNodeName());
                    SDebug.printStackTrace((Throwable)cTCUserException);
                }
                String string = "A VCAT termination could not be created on the node " + this.getNodeName() + ".";
                if (cTCUserException instanceof Busy) {
                    string = string + "\nThe VCG is busy.";
                } else if (cTCUserException instanceof VcatExists) {
                    string = string + "\nThe VCG already exists.";
                } else if (cTCUserException instanceof NoSuchEquipment) {
                    string = string + "\nThe port is invalid.";
                } else if (cTCUserException instanceof InvalidVcatMode) {
                    string = string + "\nVCAT mode is not supported.";
                } else if (cTCUserException instanceof AsymVcatNotSupported) {
                    string = string + "\nAsynchronous VCGs are not supported.";
                } else if (cTCUserException instanceof PathWidthNotsupported) {
                    string = string + "\nThe path width is not supported.";
                } else if (cTCUserException instanceof CcatCircuitsExistsOnPort) {
                    string = string + "\nA CCAT circuit already exists on the port.";
                } else if (cTCUserException instanceof InvalidNumOfMembers) {
                    string = string + "\nThe number of members is invalid.";
                } else if (cTCUserException instanceof VcatNotSupported) {
                    string = string + "\nVCAT circuits are not supported.";
                    string = string + "\n(check line card FPGA version)";
                } else if (cTCUserException instanceof UniDirVcatNotSupported) {
                    string = string + "\nUnidirectional VCAT circuits are not supported.";
                }
                throw new CircuitProvError(string);
            }
            if (NetVcatCircuit.isNullCircuitId(this.cktId) && this.vcatTermModel != null) {
                TL1ObjectManager.instance().registerTL1Object(this.ne, this.vcatTermModel, this);
            }
        }
        this.addVcatTermObserver();
        this.setState(1);
        if (this.netCktEnd.getStage() == 2) {
            this.netCktEnd.setStage(3);
        }
    }

    private void modifyVcatTerm() throws CircuitProvError {
        this.setState(2);
        if (this.netCktEnd.getStage() == 2) {
            this.netCktEnd.setStage(3);
        }
    }

    private void destroyVcatTerm() throws VcatMemberNotOutOfGroup, VcatMemberInvalidState {
        block7: {
            if (this.vcatTermModel != null) {
                try {
                    if (this.getNodeModel().provides(Feature.FORCE_DESTROY)) {
                        this.vcatTermModel.localDestroy(true);
                    } else {
                        this.vcatTermModel.localDestroy();
                    }
                }
                catch (Busy busy) {
                    if (this.dbgOn()) {
                        db.println("Unable to delete VcatTerm - xBusy");
                    }
                    return;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    if (!this.dbgOn()) break block7;
                    db.println("VcatTerm already deleted");
                }
            }
        }
    }

    protected void dispose() {
        this.deleteAllMembers();
        if (this.vcatTermModel != null) {
            TL1ObjectManager.instance().deregisterTL1Object(this.ne, this.vcatTermModel);
        }
        this.deleteVcatTermObserver();
        this.isNodeRefValid = false;
        this.vcatTermModel = null;
    }

    protected void addVcatTermObserver() {
        if (this.vcatTermModel != null) {
            if (this.dbgOn()) {
                db.println("addVcatTermObserver at node " + this.getNodeName());
            }
            this.updateEvent.init();
            ModelIndirectObservable.instance().addObserver((IObservable)this.vcatTermModel, this);
        }
    }

    protected void deleteVcatTermObserver() {
        if (this.vcatTermModel != null) {
            if (this.dbgOn()) {
                db.println("deleteVcatTermObserver at node " + this.getNodeName());
            }
            try {
                ModelIndirectObservable.instance().deleteObserver((IObservable)this.vcatTermModel, this);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                // empty catch block
            }
            this.updateEvent.init();
        }
    }

    protected void tentative2Routed() throws DeletionError {
        if (this.dbgOn()) {
            db.println("tentative2Routed at " + this.getNodeName());
        }
        if (this.state == 0) {
            if (this.dbgOn()) {
                db.println("node is inactive");
            }
            return;
        }
        if (this.state == 1) {
            block13: {
                if (this.dbgOn()) {
                    db.println("node is tentative, destroying the vcat term");
                }
                try {
                    this.destroyVcatTerm();
                }
                catch (VcatMemberNotOutOfGroup vcatMemberNotOutOfGroup) {
                    if (this.dbgOn()) {
                        db.println("VcatMemberNotOutOfGroup destroying a VcatTerm in tentative2Routed.");
                        SDebug.printStackTrace((Throwable)vcatMemberNotOutOfGroup);
                    }
                }
                catch (VcatMemberInvalidState vcatMemberInvalidState) {
                    if (!this.dbgOn()) break block13;
                    db.println("VcatMemberInvalidState destroying a VcatTerm in tentative2Routed.");
                    SDebug.printStackTrace((Throwable)vcatMemberInvalidState);
                }
            }
            this.setState(0);
        } else if (this.circuit.getCktOperation() == 6) {
            this.revertMemberCount();
            if (this.dbgOn()) {
                db.println("revert member count successful");
            }
        }
        if (this.netCktEnd.getStage() == 3) {
            this.netCktEnd.setStage(2);
        }
    }

    protected void tentative2Active() {
        if (this.dbgOn()) {
            db.println("tentative2Active at node " + this.getNodeName());
        }
        if (this.state == 0) {
            if (this.dbgOn()) {
                db.println("node is inactive");
            }
            return;
        }
        this.netCktEnd.setStage(4);
        this.setState(2);
    }

    protected void revertMemberCount() {
        try {
            this.setConfiguredNumOfMembersOnNE(this.txMembers, 2);
        }
        catch (InvalidOperation invalidOperation) {
            SDebug.printStackTrace((Throwable)invalidOperation);
        }
        catch (InvalidParms invalidParms) {
            SDebug.printStackTrace((Throwable)invalidParms);
        }
        catch (ObjNotFound objNotFound) {
            SDebug.printStackTrace((Throwable)objNotFound);
        }
    }

    protected void prettyPrint(SDebug sDebug) {
        if (!sDebug.on()) {
            return;
        }
        sDebug.println(" NODE " + this.getNodeName());
        sDebug.print("     ");
        sDebug.print(" Vcat name = \"" + this.vcatName + "\"");
        sDebug.println(" | State = " + EnumStrings.getString(INetCircuitProvState.class, (int)this.state));
        sDebug.print("     ");
        sDebug.println(" Circuit ID = " + NetCircuit.prettyString(this.cktId));
        sDebug.print("     ");
        sDebug.print(" LCAS mode = " + this.lcasMode);
        sDebug.println(" | Direction = " + EnumStrings.getString(ICircuitDirection.class, (int)this.direction));
        sDebug.print("     ");
        sDebug.println(" ExtBuffer = " + this.extBuffer);
        sDebug.print("     ");
        sDebug.print(" Configured_TX " + this.getConfiguredNumOfMembers(1));
        sDebug.println(" | Configured_RX " + this.getConfiguredNumOfMembers(0));
        sDebug.print("     ");
        sDebug.print(" Acture_TX " + this.getAllMemberNodes(2).size());
        sDebug.println(" | Acture_RX " + this.getAllMemberNodes(2).size());
        sDebug.println("     " + ((NetCircuitEnd)this.getNetCktEnd()).prettyString());
    }

    private class UpdateEvent {
        public boolean changed;
        public boolean deleted;

        public UpdateEvent() {
            this.init();
        }

        public void init() {
            this.changed = false;
            this.deleted = false;
        }
    }
}

