/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.fv.IFvNodeModel;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Busy;
import cerent.cms.model.CircuitId;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IConnectionModels;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchTrailAditModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.InvalidPath;
import cerent.cms.model.InvalidState;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchccPathDefModel;
import cerent.cms.model.OchncPathDefModel;
import cerent.cms.model.PathInUse;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.SDebug;

public class OchccCircuitSpan
extends NetCircuitSpan {
    private static final SDebug db = new SDebug("OchccCircuitSpan");
    private int optChannel;

    public OchccCircuitSpan(NetCcatCircuit netCcatCircuit, NetLinkSpan netLinkSpan, INetCircuitNode iNetCircuitNode, INetCircuitNode iNetCircuitNode2) {
        super(netCcatCircuit, netLinkSpan, iNetCircuitNode, iNetCircuitNode2);
        this.optChannel = netCcatCircuit.getCircuitOptChannel();
        if (this.dbgOn()) {
            db.println("OchccCircuitSpan object instantiated");
        }
    }

    protected int getOptChannel() {
        return this.optChannel;
    }

    @Override
    public int getEntityIndex(INetElement iNetElement) {
        if (this.getLink() == null) {
            return -1;
        }
        if (iNetElement == this.getLink().getSrc()) {
            return this.getLink().getSrcEntityIndex();
        }
        if (this.getLink().isVirtual()) {
            return ((VirtualNetLink)this.getLink()).getDstEntityIndex();
        }
        return this.getLink().getDstEntityIndex();
    }

    @Override
    protected IPathDefModel getPathDef(INetElement iNetElement, short s) throws ObjNotFound, PathInUse, InvalidPath {
        if (this.dbgOn()) {
            db.println("getPathDef: EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)) + " on " + iNetElement.getNodeModel().getName());
        }
        CircuitId circuitId = new CircuitId(iNetElement.getNodeId(), 0);
        IOchTrailAditModel iOchTrailAditModel = this.getOchTrailAdit(iNetElement);
        if (iOchTrailAditModel == null) {
            block9: {
                try {
                    iOchTrailAditModel = this.createOchTrailAdit(iNetElement, circuitId, s);
                    if (this.dbgOn()) {
                        this.debug("OchTrailCircuitEnd: auto-created OchTrailAdit on " + iNetElement.getName() + " EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)));
                    }
                }
                catch (InvalidState invalidState) {
                    if (!this.dbgOn()) break block9;
                    this.debug("OchccCircuitSpan: unable to create OchTrailAdit, InvalidState");
                }
            }
            if (iOchTrailAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("OchccCircuitSpan: unable to create OchTrailAdit");
                }
                throw new ObjNotFound("unable to find OchTrailAdit model");
            }
        } else if (this.dbgOn()) {
            this.debug("OchTrailCircuitEnd: found an auto-created OchTrail idx: " + iOchTrailAditModel.getObjIndex());
        }
        OchccPathDefModel ochccPathDefModel = new OchccPathDefModel(iNetElement.getNodeModel(), iOchTrailAditModel, this.getEntityIndex(iNetElement), s);
        return ochccPathDefModel;
    }

    protected IOchTrailAditModel createOchTrailAdit(INetElement iNetElement, ICircuitId iCircuitId, int n) throws PathInUse, InvalidPath, InvalidState {
        IOchncPathDefModel[] iOchncPathDefModelArray;
        IConnectionModels iConnectionModels = iNetElement.getNodeModel().getConnectionModels();
        iOchncPathDefModelArray = new IOchncPathDefModel[]{new OchncPathDefModel(iNetElement.getNodeModel(), this.optChannel, this.getEntityIndex(iNetElement), (short)n), iOchncPathDefModelArray[0]};
        return iConnectionModels.createOchTrailAdit(iCircuitId, iOchncPathDefModelArray, 3);
    }

    private IOchTrailAditModel getOchTrailAdit(INetElement iNetElement) {
        IOchTrailAditModel iOchTrailAditModel = null;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel == null) {
            return null;
        }
        IOchTrailAditModel[] iOchTrailAditModelArray = iNodeModel.getConnectionModels().getOchTrailAditModels();
        if (iOchTrailAditModelArray != null) {
            for (int i = 0; i < iOchTrailAditModelArray.length; ++i) {
                try {
                    iOchTrailAditModel = iOchTrailAditModelArray[i];
                    if (iOchTrailAditModel != null && iOchTrailAditModel.getPaths()[0].getPortEntityIdx() == this.getEntityIndex(iNetElement)) {
                        return iOchTrailAditModel;
                    }
                    continue;
                }
                catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public void cleanupOchTrailAdit(INetElement iNetElement) {
        block8: {
            IOchTrailAditModel iOchTrailAditModel = this.getOchTrailAdit(iNetElement);
            if (iOchTrailAditModel == null) {
                if (this.dbgOn()) {
                    this.debug("cleanupOchTrailAdit: OchTrailAdit on " + iNetElement.getName() + " EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)) + " NOT found - assume deleted");
                }
                return;
            }
            try {
                ICircuitId iCircuitId = iOchTrailAditModel.getCircuitId();
                if (iCircuitId.getUniquePart().getUniqueId() != 0) {
                    return;
                }
                if (this.dbgOn()) {
                    this.debug("cleanupOchTrailAdit: destroying OchTrailAdit on " + iNetElement.getName() + " EntIdx " + Integer.toHexString(this.getEntityIndex(iNetElement)));
                }
                iOchTrailAditModel.localDestroy();
            }
            catch (Busy busy) {
                if (this.dbgOn()) {
                    this.debug("cleanupOchTrailAdit: OchTrailAdit in use");
                }
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (!this.dbgOn()) break block8;
                this.debug("cleanupOchTrailAdit: OchTrailAdit object does not exist; Assume deleted");
            }
        }
    }

    @Override
    protected boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    @Override
    protected void debug(String string) {
        db.println(string);
    }

    @Override
    public int getSpanState(IFvNodeModel iFvNodeModel) {
        return this.getSpanState(iFvNodeModel);
    }

    @Override
    public int getSpanState(INodeModel iNodeModel) {
        int n;
        if (!this.circuit.isCircuitRefValid()) {
            return 3;
        }
        if (this.circuit.getState() != 1 && this.circuit.getState() != 5 && this.circuit.getState() != 4 && this.circuit.getState() != 6 && this.circuit.getState() != 8) {
            return 3;
        }
        if (!this.upsrLink) {
            n = this.getLink().getSrcEntityIndex();
            int n2 = this.getLink().getDstEntityIndex();
            try {
                IEntityModel iEntityModel = this.getLink().getLinkModel().src().getEntityTable().getEntityModelByIndex(n);
                IEntityModel iEntityModel2 = this.getLink().getLinkModel().dst().getEntityTable().getEntityModelByIndex(n2);
                if (iEntityModel != null && iEntityModel2 != null) {
                    boolean bl = ((IPortModel)iEntityModel).getInterfaceModel().isCurrentlyActive();
                    boolean bl2 = ((IPortModel)iEntityModel2).getInterfaceModel().isCurrentlyActive();
                    if (bl && bl2) {
                        return 0;
                    }
                    if (!bl && !bl2) {
                        return 1;
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (db != null) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                return 3;
            }
            catch (NoSuchInterface noSuchInterface) {
                if (db != null) {
                    SDebug.printStackTrace((Throwable)noSuchInterface);
                }
                return 3;
            }
            catch (WrongInterfaceType wrongInterfaceType) {
                if (db != null) {
                    SDebug.printStackTrace((Throwable)wrongInterfaceType);
                }
                return 3;
            }
            catch (UnsupportedOperation unsupportedOperation) {
                if (db != null) {
                    SDebug.printStackTrace((Throwable)unsupportedOperation);
                }
                return 3;
            }
        }
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.println("can not getUpsrSpanState on null node");
            }
            return 3;
        }
        n = this.getUpsrSpanState(iNodeModel);
        return n;
    }
}

