/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.CircuitEnd;
import cerent.cms.model.ICircuitEnd;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOchncPathDefModel;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchncPathDefModel;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.topo.INetElement;
import cerent.util.SDebug;

public class OchncCircuitEnd
extends NetCircuitEnd {
    private static SDebug db = new SDebug("OchncCircuitEnd");
    private int optChannel;

    public OchncCircuitEnd() {
    }

    public OchncCircuitEnd(int n) {
        this.optChannel = n;
        if (this.dbgOn()) {
            db.println("OchncCircuitEnd: channel ctorchannel = " + this.optChannel);
        }
    }

    public OchncCircuitEnd(INodeModel iNodeModel, ICircuitEnd iCircuitEnd, int n) {
        super(iNodeModel, iCircuitEnd);
        this.optChannel = n;
        if (this.dbgOn()) {
            db.println("OchncCircuitEnd: port = " + Integer.toHexString(iCircuitEnd.getPortNum()) + " channel = " + this.optChannel);
        }
    }

    public OchncCircuitEnd(INetCircuitEnd iNetCircuitEnd) {
        super(iNetCircuitEnd);
        if (iNetCircuitEnd instanceof OchncCircuitEnd) {
            OchncCircuitEnd ochncCircuitEnd = (OchncCircuitEnd)iNetCircuitEnd;
            this.optChannel = ochncCircuitEnd.getOptChannel();
            if (this.dbgOn()) {
                db.println("OchncCircuitEnd copy ctor: port = " + Integer.toHexString(iNetCircuitEnd.getEntityIndex()) + " channel = " + this.optChannel);
            }
        }
    }

    public OchncCircuitEnd(INetElement iNetElement, Object object) {
        int n = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        int n2 = 0;
        if (object instanceof IOchncPathDefModel) {
            IOchncPathDefModel iOchncPathDefModel = (IOchncPathDefModel)object;
            n = iOchncPathDefModel.getPortEntityIdx();
            this.optChannel = iOchncPathDefModel.getOptChannel();
            if (this.dbgOn()) {
                db.println("OchncCircuitEnd ctor with path: port = " + Integer.toHexString(n) + " channel = " + this.optChannel);
            }
            n2 = 4;
        } else if (this.dbgOn()) {
            db.println("Warning! OchncCircuitEnd constructor unknown object type");
        }
        this.setCircuitEnd(new CircuitEnd(iNodeModel.getNodeId(), n, null, null, false, 0));
        this.setStage(n2);
    }

    public OchncCircuitEnd(INetElement iNetElement, int n, int n2) {
        this(iNetElement.getNodeModel(), new CircuitEnd(iNetElement.getNodeId(), n, null, null, false, 0), n2);
    }

    @Override
    public Object getPathDef(short s) throws ObjNotFound {
        OchncPathDefModel ochncPathDefModel = new OchncPathDefModel(this.getNodeModel(), this.optChannel, this.getEntityIndex(), s);
        return ochncPathDefModel;
    }

    @Override
    public boolean equals(Object object) {
        boolean bl = false;
        if (object != null && object instanceof OchncCircuitEnd) {
            OchncCircuitEnd ochncCircuitEnd = (OchncCircuitEnd)object;
            bl = ochncCircuitEnd.getCircuitEnd().getNodeId() == this.getCircuitEnd().getNodeId() && ochncCircuitEnd.getCircuitEnd().getPortNum() == this.getCircuitEnd().getPortNum() && ochncCircuitEnd.getOptChannel() == this.getOptChannel();
        }
        return bl;
    }

    @Override
    public String prettyString() {
        if (this.getNodeModel() == null) {
            return "Unknown::" + this.getOptChannel();
        }
        String string = this.getNodeModel().getName() + "::";
        string = string + Integer.toHexString(this.getCircuitEnd().getPortNum()) + "c";
        string = string + "::" + this.getOptChannel();
        string = string + " (" + this.getClass().getName() + ")";
        return string;
    }

    public String toString() {
        return this.prettyString();
    }

    public int getOptChannel() {
        return this.optChannel;
    }
}

