/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AllocFailed;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CircuitSize;
import cerent.cms.model.FramingType;
import cerent.cms.model.IFramingType;
import cerent.cms.model.ObjNotFound;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitEnd;
import cerent.cms.ncp.LoTunnelInfo;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitPath;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.INetElement;
import cerent.util.AnnotatedException;
import cerent.util.HoLoFactory;
import cerent.util.SDebug;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class OptionalTunnel {
    protected static OptionalTunnel OptionalTunnelCreator;
    private static final SDebug db;

    private static boolean dbgOn() {
        return db.on() || NetCircuitManager.pkgDbgOn();
    }

    public static synchronized OptionalTunnel instance() {
        if (OptionalTunnelCreator == null) {
            OptionalTunnelCreator = new OptionalTunnel();
        }
        return OptionalTunnelCreator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLoTunnelNeeded(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) {
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        boolean bl = false;
        INetElement iNetElement = ((INetCircuitEnd)list.get(0)).getNetElement();
        if (list.size() > 1) {
            routePrefs2.setSecDst(((INetCircuitEnd)list.get(1)).getNetElement());
        }
        if (iNetCircuit.doesCircuitUseNetElem(iNetElement)) {
            if (OptionalTunnel.dbgOn()) {
                db.println("isLoTunnelNeeded: Circuit Node already in circuit. No tunnel is needed");
            }
            return false;
        }
        boolean bl2 = false;
        routePrefs2.setSrc(iNetCircuit.getPrimarySource().getNetElement());
        if (iNetCircuit.getSecondarySource() != null && iNetCircuit.getSecondarySource().getNodeId() != iNetCircuit.getPrimarySource().getNodeId()) {
            routePrefs2.setSecSrc(iNetCircuit.getSecondarySource().getNetElement());
        }
        INetCircuit iNetCircuit2 = iNetCircuit;
        synchronized (iNetCircuit2) {
            block16: {
                try {
                    ((NetCircuit)iNetCircuit).getOperator().routeCurrentDrop(iNetElement, routePrefs2, false);
                    if (OptionalTunnel.dbgOn()) {
                        db.println("isLoTunnelNeeded: Able to find LO route. No tunnel is required");
                    }
                }
                catch (CTCUserException cTCUserException) {
                    bl2 = true;
                }
                catch (SanityCheckFailed sanityCheckFailed) {
                    if (!OptionalTunnel.dbgOn()) break block16;
                    db.println("isLoTunnelNeeded: hit exception on the circuit" + sanityCheckFailed);
                }
            }
            if (bl2) {
                if (routePrefs.getPathProt() != 5) {
                    if (OptionalTunnel.dbgOn()) {
                        db.println("isLoTunnelNeeded: Unable to find LO route. Tunnel is required");
                    }
                    bl = true;
                } else if (OptionalTunnel.dbgOn()) {
                    db.println("isLoTunnelNeeded: Unable to find LO route. For DRI protection Tunnel will not help");
                }
            }
            return bl;
        }
    }

    protected boolean canHaveOptionalLot(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) {
        boolean bl;
        block15: {
            bl = false;
            if (OptionalTunnel.dbgOn()) {
                db.println("canHaveOptionalLot:");
            }
            if (iNetCircuit.useLAP() != null) {
                return bl;
            }
            if (list.size() == 1) {
                INetCircuitEnd iNetCircuitEnd = (INetCircuitEnd)list.get(0);
                try {
                    if (NetCircuitManager.instance().getLAPHo(iNetCircuitEnd.getNodeModel(), iNetCircuitEnd.getEntityModel(), iNetCircuitEnd.getHoNum()) != null) {
                        return bl;
                    }
                }
                catch (ObjNotFound objNotFound) {
                    if (OptionalTunnel.dbgOn()) {
                        db.println("canHaveOptionalLot checking LAP availability failed on exception");
                    }
                    return bl;
                }
            }
            try {
                NetCircuitPath netCircuitPath = this.loTunnelGetCircuitPath(iNetCircuit, list, routePrefs);
                if (netCircuitPath == null) {
                    if (OptionalTunnel.dbgOn()) {
                        db.println("loTunnelGetCircuitPath does not find LOT");
                    }
                    bl = false;
                } else {
                    int n = iNetCircuit instanceof NetVcatCircuit && ((NetVcatCircuit)iNetCircuit).getRoutePrefs().getFwdDropPrefs().isCommonFiber() ? ((NetVcatCircuit)iNetCircuit).getAllMemberCircuits().size() : 1;
                    bl = !netCircuitPath.singleHopOrExistingLotHavingBw(iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitType(), iNetCircuit.getSla(), n);
                }
            }
            catch (NoRoute noRoute) {
                if (OptionalTunnel.dbgOn()) {
                    db.println("Caught an exception");
                }
            }
            catch (AllocFailed allocFailed) {
                if (!OptionalTunnel.dbgOn()) break block15;
                db.println("Caught an exception");
            }
        }
        if (OptionalTunnel.dbgOn()) {
            db.println("canHaveOptionalLot returns " + bl);
        }
        return bl;
    }

    private NetCircuitPath loTunnelGetCircuitPath(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        INetElement iNetElement = ((INetCircuitEnd)list.get(0)).getNetElement();
        if (iNetCircuit.doesCircuitUseNetElem(iNetElement)) {
            return null;
        }
        RoutePrefs routePrefs2 = new RoutePrefs(routePrefs);
        routePrefs2.setSrc(iNetCircuit.getPrimarySource().getNetElement());
        if (iNetCircuit.getSecondarySource() != null) {
            routePrefs2.setSecSrc(iNetCircuit.getSecondarySource().getNetElement());
        }
        routePrefs2.setDst(iNetElement);
        if (list.size() > 1) {
            routePrefs2.setSecDst(((INetCircuitEnd)list.get(1)).getNetElement());
        }
        int n = NetCircuitManager.instance().calcFramingType(iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize());
        routePrefs2.setCircuitSizeToAllMembers(CircuitSize.getLoTunnelSize((int)n).getEnum());
        routePrefs2.setRequiredSpans(iNetCircuit.getRequiredSpans());
        IFramingType iFramingType = FramingType.getFramingType((int)n);
        routePrefs2.setCircuitType(iFramingType.getTunnelCircuitType());
        routePrefs2.setPathOnly(false);
        routePrefs2.setTunnel(true);
        if (iNetCircuit.getCircuitTypeObj().isVcatCircuitType()) {
            int n2 = 0;
            int n3 = routePrefs2.getActiveDropPrefs().isCommonFiber() ? routePrefs2.getMemberCount() : routePrefs2.getActiveDropPrefs().getMemberGroupPrefs().size();
            int n4 = HoLoFactory.getAllLoNums(n, iNetCircuit.getCircuitSize()).size();
            int n5 = n3 % n4;
            n2 = n5 == 0 ? n3 / n4 + 1 : (n3 - n5) / n4 + 1;
            if (routePrefs2.getActiveDropPrefs().isCommonFiber()) {
                routePrefs2.getActiveDropPrefs().getActiveMemberGroupPrefs().setMemberCount(n2);
            } else {
                LinkedList linkedList = new LinkedList();
                Iterator iterator = routePrefs2.getActiveDropPrefs().getMemberGroupPrefs().iterator();
                for (n5 = n2; iterator.hasNext() && n5 > 0; --n5) {
                    linkedList.add(iterator.next());
                }
                routePrefs2.getActiveDropPrefs().setMemberGroupPrefs(linkedList);
            }
        }
        NetCircuitPath netCircuitPath = new NetCircuitPath(routePrefs2, null);
        netCircuitPath.computeCircuitPath();
        return netCircuitPath;
    }

    protected List createLoTunnel(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs, boolean bl) throws Exception {
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd);
        return this.createLoTunnel(iNetCircuit, linkedList, routePrefs, bl);
    }

    protected List createLoTunnel(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs, boolean bl) throws Exception {
        if (OptionalTunnel.dbgOn()) {
            db.println("createLoTunnels: ");
        }
        List list2 = this.createLoTunnels(iNetCircuit, list, routePrefs);
        if (OptionalTunnel.dbgOn()) {
            db.println("createLoTunnel " + bl + " got " + list2.size() + " tunnel");
        }
        for (LoTunnelInfo loTunnelInfo : list2) {
            boolean bl2 = true;
            AnnotatedException annotatedException = null;
            if (!loTunnelInfo.required() && !bl) continue;
            try {
                if (OptionalTunnel.dbgOn()) {
                    db.println("createLoTunnel: provisioning required Lo tunnel");
                }
                loTunnelInfo.tunnel().provision();
                bl2 = false;
            }
            catch (Exception exception) {
                annotatedException = new AnnotatedException("Unable to create required LO tunnel", exception);
            }
            if (!bl2) continue;
            try {
                if (OptionalTunnel.dbgOn()) {
                    db.println("createLoTunnel: destroying LO tunnel");
                }
                loTunnelInfo.tunnel().destroyCircuit();
            }
            catch (Exception exception) {
                throw new AnnotatedException("The LO tunnel could not be destroyed.", exception);
            }
            if (annotatedException == null) continue;
            throw annotatedException;
        }
        return list2;
    }

    protected List createLoTunnels(INetCircuit iNetCircuit, INetCircuitEnd iNetCircuitEnd, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        LinkedList<INetCircuitEnd> linkedList = new LinkedList<INetCircuitEnd>();
        linkedList.add(iNetCircuitEnd);
        return this.createLoTunnels(iNetCircuit, linkedList, routePrefs);
    }

    protected List createLoTunnels(INetCircuit iNetCircuit, List list, RoutePrefs routePrefs) throws NoRoute, AllocFailed {
        if (OptionalTunnel.dbgOn()) {
            db.println("createLoTunnels: ");
        }
        LinkedList linkedList = new LinkedList();
        NetCircuitPath netCircuitPath = this.loTunnelGetCircuitPath(iNetCircuit, list, routePrefs);
        if (netCircuitPath == null) {
            if (OptionalTunnel.dbgOn()) {
                db.println("loTunnelGetCircuitPath does not find LOT");
            }
            return linkedList;
        }
        try {
            int n = iNetCircuit instanceof NetVcatCircuit && ((NetVcatCircuit)iNetCircuit).getRoutePrefs().getFwdDropPrefs().isCommonFiber() ? ((NetVcatCircuit)iNetCircuit).getAllMemberCircuits().size() : 1;
            int n2 = NetCircuitManager.instance().calcFramingType(iNetCircuit.getCircuitType(), iNetCircuit.getCircuitSize());
            linkedList = netCircuitPath.getLoTunnels(iNetCircuit.getCircuitSize(), iNetCircuit.getCircuitType(), n2, iNetCircuit.getSla(), iNetCircuit.tl1Compatible(), n);
            if (OptionalTunnel.dbgOn()) {
                db.println("Found a route for the LO Tunnels");
            }
        }
        catch (NoRoute noRoute) {
            throw new NoRoute("The VT circuit could not be routed. Possible reasons include: \n1) The circuit requires a VT tunnel and cannot be routed because of cross-connects in the path from source to destination.\n2) A route cannot be found  that will satisfy the given requirements.");
        }
        return linkedList;
    }

    static {
        db = new SDebug("OptionalTunnel");
    }
}

