/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.ConfigError;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.IDwdmModuleModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.IModuleModel;
import cerent.cms.model.IPlimTrkLineModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.IRevertiveBehavior;
import cerent.cms.model.NoSuchEquipment;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ObjNotFound;
import cerent.cms.model.OchTrailAttrsHelper;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.circuits.CircuitMapUtil;
import cerent.util.DetailedLog;
import cerent.util.SDebug;
import cerent.util.gui.WindowHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public final class TrkAttribOperator {
    private OchTrailAttrsHelper.TrunkInfo srcTrunkInfo;
    private OchTrailAttrsHelper.TrunkInfo dropTrunkInfo;
    private HashMap regenTrkPortsInfo;
    private OchTrailAttrsHelper.TrunkInfo newTrunkInfo;
    private IRevertiveBehavior srcReversion;
    private IRevertiveBehavior dropReversion;
    private IRevertiveBehavior newReversion;
    private IEntityModel srcTrkPort;
    private IEntityModel dropTrkPort;
    private SDebug db;

    public TrkAttribOperator(SDebug sDebug) {
        this.db = sDebug;
    }

    public OchTrailAttrsHelper.TrunkInfo getSrcTrunkInfo() {
        return this.srcTrunkInfo;
    }

    public OchTrailAttrsHelper.TrunkInfo getDropTrunkInfo() {
        return this.dropTrunkInfo;
    }

    public OchTrailAttrsHelper.TrunkInfo getNewTrunkInfo() {
        return this.newTrunkInfo;
    }

    public HashMap getRegenTrkPortsInfo() {
        return this.regenTrkPortsInfo;
    }

    public IEntityModel getSrcTrkPort() {
        return this.srcTrkPort;
    }

    public IEntityModel getDropTrunkPort() {
        return this.dropTrkPort;
    }

    public void addToRegenTrkPorts(IEntityModel iEntityModel) throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        if (iEntityModel != null) {
            if (this.regenTrkPortsInfo == null) {
                this.regenTrkPortsInfo = new HashMap();
            }
            if (!this.regenTrkPortsInfo.keySet().contains(iEntityModel)) {
                OchTrailAttrsHelper.TrunkInfo trunkInfo = OchTrailAttrsHelper.getTrunkAttrs(iEntityModel);
                this.regenTrkPortsInfo.put(iEntityModel, trunkInfo);
            }
        }
    }

    public void removeFromRegenTrkPorts(IEntityModel iEntityModel) {
        if (iEntityModel != null && this.regenTrkPortsInfo != null) {
            this.regenTrkPortsInfo.remove(iEntityModel);
        }
    }

    public void clearRegenTrkPorts() {
        if (this.regenTrkPortsInfo != null) {
            this.regenTrkPortsInfo.clear();
        }
    }

    public void clearTrunkAttrs() {
        this.srcTrunkInfo = null;
        this.dropTrunkInfo = null;
        this.newTrunkInfo = null;
        this.srcTrkPort = null;
        this.dropTrkPort = null;
        this.clearRegenTrkPorts();
    }

    public void clearReversions() {
        this.srcReversion = null;
        this.dropReversion = null;
        this.newReversion = null;
    }

    public void setTrkAttribOperatorInfo(TrkAttribOperator trkAttribOperator) {
        this.clearTrunkAttrs();
        this.clearReversions();
        if (trkAttribOperator != null) {
            this.srcTrunkInfo = trkAttribOperator.getSrcTrunkInfo();
            this.dropTrunkInfo = trkAttribOperator.getDropTrunkInfo();
            this.newTrunkInfo = trkAttribOperator.getNewTrunkInfo();
            this.srcTrkPort = trkAttribOperator.getSrcTrkPort();
            this.dropTrkPort = trkAttribOperator.getDropTrunkPort();
            this.srcReversion = trkAttribOperator.getSrcReversion();
            this.dropReversion = trkAttribOperator.getDropReversion();
            this.newReversion = trkAttribOperator.getNewReversion();
            if (trkAttribOperator.getRegenTrkPortsInfo() != null) {
                this.regenTrkPortsInfo = new HashMap(trkAttribOperator.getRegenTrkPortsInfo());
            }
        }
    }

    public void saveTrunkAttrs(IEntityModel iEntityModel, IEntityModel iEntityModel2, OchTrailAttrsHelper.TrunkInfo trunkInfo) throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        this.clearTrunkAttrs();
        if (trunkInfo == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply null trunk attrs");
            }
            return;
        }
        if (OchTrailHelper.isLineCard(iEntityModel) || OchTrailHelper.isLineCard(iEntityModel2)) {
            if (this.db.on()) {
                this.db.println("Cannot apply trunk attrs to ITU-T line cards.");
            }
            return;
        }
        this.srcTrunkInfo = OchTrailAttrsHelper.getTrunkAttrs(iEntityModel);
        this.srcTrkPort = iEntityModel;
        if (this.db.on()) {
            this.db.println("Stored src trunk attrs: " + this.srcTrunkInfo);
        }
        this.dropTrunkInfo = OchTrailAttrsHelper.getTrunkAttrs(iEntityModel2);
        this.dropTrkPort = iEntityModel2;
        if (this.db.on()) {
            this.db.println("Stored dst trunk attrs: " + this.dropTrunkInfo);
        }
        this.newTrunkInfo = trunkInfo;
        if (this.db.on()) {
            this.db.println(" Saved trunk attrs: " + trunkInfo);
        }
    }

    private boolean areTrunkAttrsApplicable(IEntityModel iEntityModel) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, NoSuchInterface {
        IInterfaceModel iInterfaceModel = ((IPortModel)iEntityModel).getInterfaceModel();
        if (iInterfaceModel instanceof IPlimTrkLineModel) {
            return true;
        }
        IModuleModel iModuleModel = iEntityModel.getModuleModel();
        if (iModuleModel instanceof IDwdmModuleModel && !((IDwdmModuleModel)iModuleModel).supportsOTN()) {
            if (this.db.on()) {
                this.db.println("areTrunkAttrsApplicable - Not Applicable: The Trunk doesn't support OTN Port: " + iEntityModel);
            }
            return false;
        }
        if (OchTrailHelper.isLineCard(iEntityModel)) {
            if (this.db.on()) {
                this.db.println("areTrunkAttrsApplicable - Not Applicable: The Trunk is not a line card; Port: " + iEntityModel);
            }
            return false;
        }
        return true;
    }

    public void applyTrunkAttrs() throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        OchTrailAttrsHelper.TrunkInfo trunkInfo = this.getNewTrunkInfo();
        if (trunkInfo == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply null trunk attrs");
            }
            return;
        }
        if (this.srcTrkPort == null || this.dropTrkPort == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply trunk attrs on null src or drop port");
            }
            return;
        }
        if (!this.areTrunkAttrsApplicable(this.srcTrkPort) || !this.areTrunkAttrsApplicable(this.dropTrkPort)) {
            if (this.db.on()) {
                this.db.println("Cannot apply trunk attrs..");
            }
            return;
        }
        if (this.getTrunksInUse().size() != 0) {
            if (this.db.on()) {
                this.db.println("Cannot apply trunk OTN attrs to ports in IS state or with OCHCC connections..trying to set FRR attributes");
                this.db.println(this.getTrunksInUseMsg());
            }
            OchTrailAttrsHelper.setTrunkFrrAttrs(trunkInfo, this.srcTrkPort);
            if (this.db.on()) {
                this.db.println("Applied trunk FRR attrs to src " + trunkInfo);
            }
            OchTrailAttrsHelper.setTrunkFrrAttrs(trunkInfo, this.dropTrkPort);
            if (this.db.on()) {
                this.db.println("Applied trunk FRR attrs to drop" + trunkInfo);
            }
            this.applyRegenTrunkFrrAttrs();
            if (this.db.on()) {
                this.db.println("Applied trunk FRR attrs to regen trunk ports" + trunkInfo);
            }
            return;
        }
        OchTrailAttrsHelper.setTrunkAttrs(trunkInfo, this.srcTrkPort);
        if (this.db.on()) {
            this.db.println("Applied trunk attrs to src " + trunkInfo);
        }
        OchTrailAttrsHelper.setTrunkAttrs(trunkInfo, this.dropTrkPort);
        if (this.db.on()) {
            this.db.println("Applied trunk attrs to drop" + trunkInfo);
        }
        this.applyRegenTrunkAttrs();
        if (this.db.on()) {
            this.db.println("Applied trunk attrs to regen trunk ports" + trunkInfo);
        }
    }

    public void applyRegenTrunkFrrAttrs() throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        OchTrailAttrsHelper.TrunkInfo trunkInfo = this.getNewTrunkInfo();
        if (trunkInfo == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply null trunk attrs");
            }
            return;
        }
        if (this.regenTrkPortsInfo == null || this.regenTrkPortsInfo.size() == 0) {
            if (this.db.on()) {
                this.db.println("no regen trunk ports to apply trunk frr attrs");
            }
            return;
        }
        Iterator iterator = this.regenTrkPortsInfo.keySet().iterator();
        while (iterator.hasNext()) {
            if (!OchTrailHelper.isLineCard((IEntityModel)iterator.next())) continue;
            if (this.db.on()) {
                this.db.println("Cannot apply trunk FRR attrs to ITU-T line cards.");
            }
            return;
        }
        for (IEntityModel iEntityModel : this.regenTrkPortsInfo.keySet()) {
            OchTrailAttrsHelper.setTrunkFrrAttrs(trunkInfo, iEntityModel);
            if (!this.db.on()) continue;
            this.db.println("Applied trunk FRR attrs " + trunkInfo + "to " + iEntityModel);
        }
    }

    public void applyRegenTrunkAttrs() throws NoSuchEquipment, DetailedConfigError, AbstractCmsNoSuchEntityException, NoSuchInterface, WrongInterfaceType, ConfigError, ObjNotFound, ProvisionError {
        OchTrailAttrsHelper.TrunkInfo trunkInfo = this.getNewTrunkInfo();
        if (trunkInfo == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply null trunk attrs");
            }
            return;
        }
        if (this.regenTrkPortsInfo == null || this.regenTrkPortsInfo.size() == 0) {
            if (this.db.on()) {
                this.db.println("no regen trunk ports to apply trunk attrs");
            }
            return;
        }
        Iterator iterator = this.regenTrkPortsInfo.keySet().iterator();
        while (iterator.hasNext()) {
            if (!OchTrailHelper.isLineCard((IEntityModel)iterator.next())) continue;
            if (this.db.on()) {
                this.db.println("Cannot apply trunk attrs to ITU-T line cards.");
            }
            return;
        }
        if (this.getRegenTrunksInUse().size() != 0) {
            if (this.db.on()) {
                this.db.println("Cannot apply trunk attrs to regen ports in IS state");
                this.db.println(this.getRegenTrunksInUseMsg());
            }
            return;
        }
        iterator = this.regenTrkPortsInfo.keySet().iterator();
        int n = trunkInfo.getMappingType();
        while (iterator.hasNext()) {
            IEntityModel iEntityModel = (IEntityModel)iterator.next();
            int n2 = ((OchTrailAttrsHelper.TrunkInfo)this.regenTrkPortsInfo.get(iEntityModel)).getMappingType();
            trunkInfo.setMappingType(n2);
            OchTrailAttrsHelper.setTrunkAttrs(trunkInfo, iEntityModel);
            if (!this.db.on()) continue;
            this.db.println("Applied trunk attrs " + trunkInfo + "to " + iEntityModel);
        }
        trunkInfo.setMappingType(n);
    }

    public void restoreTrunkAttrs() throws Exception {
        Exception exception;
        block18: {
            block17: {
                block16: {
                    if (OchTrailHelper.isLineCard(this.srcTrkPort) || OchTrailHelper.isLineCard(this.dropTrkPort)) {
                        if (this.db.on()) {
                            this.db.println("Line Cards , restore skipped.");
                        }
                        return;
                    }
                    exception = null;
                    if (this.srcTrunkInfo != null) {
                        try {
                            if (this.db.on()) {
                                this.db.println("Restoring src trunk attrs: " + this.srcTrunkInfo);
                            }
                            if (((IPortModel)this.srcTrkPort).getInterfaceModel() instanceof IPlimTrkLineModel) {
                                WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Router  " + this.srcTrkPort.getNodeModel().getName() + ": Circuit creation did not succeed, reverting the proactive protection" + " attributes to default values"));
                            }
                            OchTrailAttrsHelper.setTrunkAttrs(this.srcTrunkInfo, this.srcTrkPort);
                        }
                        catch (Exception exception2) {
                            exception = exception2;
                            if (!this.db.on()) break block16;
                            this.db.println("Got exception while restoring src trunk attrs: " + exception2.getMessage());
                        }
                    }
                }
                if (this.dropTrunkInfo != null) {
                    try {
                        if (this.db.on()) {
                            this.db.println("Restoring dst trunk attrs: " + this.dropTrunkInfo);
                        }
                        if (((IPortModel)this.dropTrkPort).getInterfaceModel() instanceof IPlimTrkLineModel) {
                            WindowHelper.postAlert((DetailedLog)new DetailedLog(3, "Router  " + this.srcTrkPort.getNodeModel().getName() + ": Circuit creation did not succeed, reverting the proactive protection" + " attributes to default values"));
                        }
                        OchTrailAttrsHelper.setTrunkAttrs(this.dropTrunkInfo, this.dropTrkPort);
                    }
                    catch (Exception exception3) {
                        exception = exception3;
                        if (!this.db.on()) break block17;
                        this.db.println("Got exception while restoring dst trunk attrs: " + exception3.getMessage());
                    }
                }
            }
            try {
                this.restoreRegenTrunkAttrs();
            }
            catch (Exception exception4) {
                exception = exception4;
                if (!this.db.on()) break block18;
                this.db.println("Got exception while restoring regen trunk attrs: " + exception4.getMessage());
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (this.db.on()) {
            this.db.println("Restored trunk attrs");
        }
    }

    public void restoreRegenTrunkAttrs() throws Exception {
        if (this.regenTrkPortsInfo == null || this.regenTrkPortsInfo.size() == 0) {
            if (this.db.on()) {
                this.db.println("no regen trunk ports to restore trunk attrs");
            }
            return;
        }
        Iterator iterator = this.regenTrkPortsInfo.keySet().iterator();
        while (iterator.hasNext()) {
            if (!OchTrailHelper.isLineCard((IEntityModel)iterator.next())) continue;
            if (this.db.on()) {
                this.db.println("Line Cards , restore skipped.");
            }
            return;
        }
        Exception exception = null;
        for (IEntityModel iEntityModel : this.regenTrkPortsInfo.keySet()) {
            OchTrailAttrsHelper.TrunkInfo trunkInfo = (OchTrailAttrsHelper.TrunkInfo)this.regenTrkPortsInfo.get(iEntityModel);
            try {
                if (this.db.on()) {
                    this.db.println("Restoring regen trunk attrs: " + trunkInfo);
                }
                OchTrailAttrsHelper.setTrunkAttrs(trunkInfo, iEntityModel);
            }
            catch (Exception exception2) {
                exception = exception2;
                if (!this.db.on()) continue;
                this.db.println("Got exception while restoring regen trunk attrs: " + exception2.getMessage());
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (this.db.on()) {
            this.db.println("Restored regen trunk attrs");
        }
    }

    public IRevertiveBehavior getSrcReversion() {
        return this.srcReversion;
    }

    public IRevertiveBehavior getDropReversion() {
        return this.dropReversion;
    }

    public IRevertiveBehavior getNewReversion() {
        return this.newReversion;
    }

    public void saveReversions(IEntityModel iEntityModel, IEntityModel iEntityModel2, IRevertiveBehavior iRevertiveBehavior) throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException, ObjNotFound {
        this.clearReversions();
        if (iRevertiveBehavior == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply null reversions");
            }
            return;
        }
        if (OchTrailHelper.isProtected(iEntityModel) && OchTrailHelper.isProtected(iEntityModel2)) {
            IEntityModel iEntityModel3 = OchTrailHelper.getWorkingTrunk(iEntityModel);
            IEntityModel iEntityModel4 = OchTrailHelper.getWorkingTrunk(iEntityModel2);
            this.srcReversion = OchTrailAttrsHelper.getReversion(iEntityModel3);
            this.dropReversion = OchTrailAttrsHelper.getReversion(iEntityModel4);
            this.newReversion = iRevertiveBehavior;
            if (this.db.on()) {
                this.db.println("Stored reversions: " + this.srcReversion + ", " + this.dropReversion + " , " + iRevertiveBehavior);
            }
        }
        if (this.db.on()) {
            this.db.println("Saved reversion: " + iRevertiveBehavior);
        }
    }

    public void applyReversions() throws AbstractCmsNoSuchEntityException, NoSuchEquipment, AbstractCmsNoSuchElementException, ObjNotFound {
        IRevertiveBehavior iRevertiveBehavior = this.getNewReversion();
        if (iRevertiveBehavior == null) {
            if (this.db.on()) {
                this.db.println("Cannot apply null reversions");
            }
            return;
        }
        if (OchTrailHelper.isProtected(this.srcTrkPort) && OchTrailHelper.isProtected(this.dropTrkPort)) {
            OchTrailAttrsHelper.setReversion(iRevertiveBehavior, this.srcTrkPort);
            OchTrailAttrsHelper.setReversion(iRevertiveBehavior, this.dropTrkPort);
        } else {
            this.clearReversions();
        }
        if (this.db.on()) {
            this.db.println("Applied reversion: " + iRevertiveBehavior);
        }
    }

    public void restoreReversions() throws Exception {
        Exception exception;
        block11: {
            block10: {
                exception = null;
                if (this.srcReversion != null) {
                    if (this.db.on()) {
                        this.db.println("Restoring src reversion: " + this.srcReversion);
                    }
                    try {
                        OchTrailAttrsHelper.setReversion(this.srcReversion, this.srcTrkPort);
                    }
                    catch (Exception exception2) {
                        exception = exception2;
                        if (!this.db.on()) break block10;
                        this.db.println("Got exception while restoring src reversion: " + exception2.getMessage());
                    }
                }
            }
            if (this.dropReversion != null) {
                if (this.db.on()) {
                    this.db.println("Restoring dst reversion: " + this.dropReversion);
                }
                try {
                    OchTrailAttrsHelper.setReversion(this.dropReversion, this.dropTrkPort);
                }
                catch (Exception exception3) {
                    exception = exception3;
                    if (!this.db.on()) break block11;
                    this.db.println("Got exception while restoring dst reversion: " + exception3.getMessage());
                }
            }
        }
        if (exception != null) {
            throw exception;
        }
        if (this.db.on()) {
            this.db.println("Restored original reversions");
        }
    }

    public void restoreAll() {
        block2: {
            try {
                this.restoreTrunkAttrs();
                this.restoreReversions();
            }
            catch (Exception exception) {
                if (!this.db.on()) break block2;
                this.db.println("Got exception while restoring  : " + exception.getMessage());
            }
        }
    }

    public void applyAll() throws Exception {
        this.applyTrunkAttrs();
        this.applyReversions();
    }

    public ArrayList getTrunksInUse() {
        ArrayList<IEntityModel> arrayList;
        block12: {
            block11: {
                arrayList = new ArrayList<IEntityModel>();
                try {
                    if (this.srcTrkPort != null && OchTrailAttrsHelper.isTrunkInIS(this.srcTrkPort)) {
                        arrayList.add(this.srcTrkPort);
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block11;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
            try {
                if (this.dropTrkPort != null && OchTrailAttrsHelper.isTrunkInIS(this.dropTrkPort)) {
                    arrayList.add(this.dropTrkPort);
                }
            }
            catch (Exception exception) {
                if (!this.db.on()) break block12;
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        if (this.regenTrkPortsInfo != null && this.regenTrkPortsInfo.size() != 0) {
            for (IEntityModel iEntityModel : this.regenTrkPortsInfo.keySet()) {
                try {
                    boolean bl = OchTrailAttrsHelper.isTrunkInIS(iEntityModel);
                    if (this.db.on()) {
                        this.db.println("Applying trunk attrs: isTrunkInUse = " + bl);
                    }
                    if (!bl) continue;
                    arrayList.add(iEntityModel);
                }
                catch (Exception exception) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    public String getTrunksInUseMsg() {
        String string = null;
        ArrayList arrayList = this.getTrunksInUse();
        if (arrayList.size() != 0) {
            string = new String();
            for (IEntityModel iEntityModel : arrayList) {
                string = string + iEntityModel.getNodeModel().getName() + "/" + CircuitMapUtil.getSpanLabel(iEntityModel, null, null) + "\n";
            }
        }
        return string;
    }

    public ArrayList getRegenTrunksInUse() {
        ArrayList<IEntityModel> arrayList = new ArrayList<IEntityModel>();
        if (this.regenTrkPortsInfo != null && this.regenTrkPortsInfo.size() != 0) {
            for (IEntityModel iEntityModel : this.regenTrkPortsInfo.keySet()) {
                try {
                    boolean bl = OchTrailAttrsHelper.isTrunkInIS(iEntityModel);
                    if (this.db.on()) {
                        this.db.println("Applying trunk attrs: isTrunkInUse = " + bl);
                    }
                    if (!bl) continue;
                    arrayList.add(iEntityModel);
                }
                catch (Exception exception) {
                    if (!this.db.on()) continue;
                    SDebug.printStackTrace((Throwable)exception);
                }
            }
        }
        return arrayList;
    }

    public String getRegenTrunksInUseMsg() {
        String string = null;
        ArrayList arrayList = this.getRegenTrunksInUse();
        if (arrayList.size() != 0) {
            string = new String();
            for (IEntityModel iEntityModel : arrayList) {
                string = string + iEntityModel.getNodeModel().getName() + "/" + CircuitMapUtil.getSpanLabel(iEntityModel, null, null) + "\n";
            }
        }
        return string;
    }
}

