/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.model.Busy;
import cerent.cms.model.CTCUserException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.ConnCreateAttrs;
import cerent.cms.model.ConnectionInLoopback;
import cerent.cms.model.ConnectionInRoll;
import cerent.cms.model.ConnectionInTestAccess;
import cerent.cms.model.ConnectionInTopologyUpgrade;
import cerent.cms.model.Feature;
import cerent.cms.model.IConnCreateAttrs;
import cerent.cms.model.IConnectionConversionModel;
import cerent.cms.model.IConnectionModel;
import cerent.cms.model.IConnectionType;
import cerent.cms.model.IPathDefModel;
import cerent.cms.model.PathListIncomplete;
import cerent.cms.model.TopologyUpgradeNotAllowed;
import cerent.cms.ncp.AdminStateProvisioningError;
import cerent.cms.ncp.ConnectionPathNotFound;
import cerent.cms.ncp.DeletionError;
import cerent.cms.ncp.DualConnectionCircuitNode;
import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.INetCircuitNode;
import cerent.cms.ncp.InServiceUpgradeError;
import cerent.cms.ncp.InServiceUpgradeMgr;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ncp.InvalidSpanProtectionOp;
import cerent.cms.ncp.NetCcatCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitComparator;
import cerent.cms.ncp.NetCircuitEnd;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.ncp.NetVcatCircuit;
import cerent.cms.ncp.PortGrouping;
import cerent.cms.ncp.SanityCheckFailed;
import cerent.cms.ncp.Upsr2BlsrInServiceUpgradeWorker;
import cerent.cms.ncp.UpsrCircuitPaths;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.NetLink;
import cerent.cms.topo.Network;
import cerent.util.EnumStrings;
import cerent.util.HoLoComparator;
import cerent.util.IHoNum;
import cerent.util.ILoNum;
import cerent.util.job.IJobControl;
import cerent.util.job.IJobGroupListener;
import cerent.util.job.JobController;
import cerent.util.job.JobControllerFactory;
import cerent.util.job.JobGroup;
import cerent.util.job.JobStatus;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import java.util.TreeMap;

public class Upsr2BlsrInServiceUpgradeMgr
extends InServiceUpgradeMgr
implements Observer,
IJobGroupListener {
    private List upsrLinks = new LinkedList();
    private List upsrRingNEs = new LinkedList();
    private Map upsrCkts = Collections.synchronizedMap(new TreeMap(new NetCircuitComparator()));
    private Set cktsInRing = Collections.synchronizedSet(new HashSet());
    private Set cktsEndpointsOnLink = Collections.synchronizedSet(new HashSet());
    private List unusedTunnelsBeforeUpgrade = new LinkedList();
    private int stage = 0;
    private JobGroup inSerUpgradeJobGroup = null;
    private JobController inSerUpgradeJobController = null;
    private boolean operationDone = false;
    private Object threadWaitObject = new Object();
    private String UPSR_TERM = NetCircuitNode.getTDMTerminology(null).getRingTerms(0);
    private String BLSR_TERM = NetCircuitNode.getTDMTerminology(null).getRingTerms(1);

    public Upsr2BlsrInServiceUpgradeMgr() {
        Upsr2BlsrInServiceUpgradeMgr.debug("Upsr2BlsrInServiceUpgradeMgr: default constructor called");
    }

    public Upsr2BlsrInServiceUpgradeMgr(List list) throws SanityCheckFailed {
        this();
        this.ncm.addObserver(this);
        this.setUpsrRingLinks(list);
        Upsr2BlsrInServiceUpgradeMgr.debug("Upsr2BlsrInServiceUpgradeMgr Created");
    }

    @Override
    public int getInServiceUpgradeOp() {
        return 1;
    }

    private void setConversionStage(int n) {
        this.stage = n;
    }

    private int getConversionStage() {
        return this.stage;
    }

    public void performInServiceUpgrade(INetCircuit iNetCircuit) throws InvalidSpanProtectionOp, Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, AdminStateProvisioningError, IncorrectCircuitState, CTCUserException, ConnectionPathNotFound {
        int n = this.getConversionStage();
        switch (this.stage) {
            case 1: {
                this.switchTraffic2ShortestPaths(iNetCircuit);
                break;
            }
            case 2: {
                this.createConversionModels(iNetCircuit);
                break;
            }
            case 3: {
                this.convertCircuit(iNetCircuit);
                break;
            }
            case 4: {
                this.setUnusedLOT2AINS(iNetCircuit);
                break;
            }
            case 5: {
                this.clearTrafficSwitching(iNetCircuit);
                break;
            }
            default: {
                Upsr2BlsrInServiceUpgradeMgr.debug("unknown conversion stage");
            }
        }
    }

    @Override
    public List getPreferredLinks() {
        LinkedList<INetLink> linkedList = new LinkedList<INetLink>();
        for (NetCcatCircuit netCcatCircuit : this.ncm.getCircuits()) {
            if (netCcatCircuit.getState() != 11 || netCcatCircuit.getConversionOperation() != 1) continue;
            for (NetCircuitSpan netCircuitSpan : netCcatCircuit.getCircuitSpans()) {
                if (!netCircuitSpan.inUpsr2BlsrConversion()) continue;
                linkedList.add(netCircuitSpan.getLink());
            }
        }
        return linkedList;
    }

    private void sanityCheckRingLinks(List list, List list2, List list3) throws SanityCheckFailed {
        Upsr2BlsrInServiceUpgradeMgr.debug("sanitCheckRingLinks: upsrLinks.size() = " + list.size());
        if (list2.isEmpty()) {
            throw new SanityCheckFailed("The " + this.UPSR_TERM + " links are empty.");
        }
        INetLink iNetLink = (INetLink)list2.get(0);
        if (!(iNetLink instanceof NetLink)) {
            throw new SanityCheckFailed("An invalid link set was provided.");
        }
        int n = ((NetLink)iNetLink).getPhysicalLinkType();
        Iterator iterator = list2.iterator();
        while (iterator.hasNext()) {
            INetLink iNetLink2 = (INetLink)iterator.next();
            if (!(iNetLink2 instanceof NetLink)) {
                throw new SanityCheckFailed("An invalid link set was provided.");
            }
            NetLink netLink = (NetLink)iNetLink2;
            NetLink netLink2 = (NetLink)this.net.findReverseLink(netLink);
            if (netLink2 == null) {
                throw new SanityCheckFailed("The reverse link for " + netLink.prettyString() + " is missing.");
            }
            if (netLink.getLinkType() != 1) {
                throw new SanityCheckFailed(netLink.prettyString() + " is not a physical link.");
            }
            if (n != netLink.getPhysicalLinkType()) {
                throw new SanityCheckFailed("The provided links do not have the same speed.");
            }
            if (netLink.getProtectionType() != 3) {
                throw new SanityCheckFailed(netLink.prettyString() + " is already line protected.");
            }
            if (!list3.contains(netLink.getSrc())) {
                list3.add(netLink.getSrc());
            }
            if (!list3.contains(netLink.getDst())) {
                list3.add(netLink.getDst());
            }
            if (!list2.contains(netLink2)) continue;
            iterator.remove();
        }
        if (list2.size() != list.size()) {
            throw new SanityCheckFailed("The given set of links contains some reverse link pairs.");
        }
        if (list3.size() != list.size()) {
            throw new SanityCheckFailed("The provided links do not form a ring.");
        }
    }

    private boolean checkUpsrRingLinks() {
        LinkedList linkedList = new LinkedList(this.upsrLinks);
        for (INetLink iNetLink : linkedList) {
            if (Network.instance().findNetLinkFromLinkModel(iNetLink.getLinkModel()) != null) continue;
            return false;
        }
        return true;
    }

    @Override
    public void setUpsrRingLinks(List list) throws SanityCheckFailed {
        LinkedList linkedList = new LinkedList(list);
        LinkedList linkedList2 = new LinkedList();
        if (this.getConversionStage() == 0) {
            this.sanityCheckRingLinks(list, linkedList, linkedList2);
            this.upsrLinks.addAll(linkedList);
            this.upsrRingNEs.addAll(linkedList2);
            this.setCktsInRing();
            this.setCktsEndpointsOnLink();
            this.setUpsrCircuits();
            this.setUnusedTunnels();
        } else if (this.checkUpsrRingLinks()) {
            for (NetCcatCircuit netCcatCircuit : this.upsrCkts.keySet()) {
                UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCcatCircuit);
                if (upsrCircuitPaths.getBridge() != null) continue;
                upsrCircuitPaths.setBridge(netCcatCircuit, this.upsrRingNEs, this.upsrLinks);
                upsrCircuitPaths.setPaths(netCcatCircuit, this.upsrRingNEs, this.upsrLinks);
            }
        } else {
            throw new SanityCheckFailed("The ring links have changed.");
        }
    }

    private List getUpsrRingLinks() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.upsrLinks);
        return linkedList;
    }

    private List getUpsrRingNEs() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.upsrRingNEs);
        return linkedList;
    }

    private boolean setCktsInRing() {
        HashSet hashSet = new HashSet();
        for (INetLink iNetLink : this.getUpsrRingLinks()) {
            hashSet.addAll(this.ncm.getCircuits(iNetLink));
            hashSet.addAll(this.ncm.getCircuits(this.net.findReverseLink(iNetLink)));
            HashSet hashSet2 = new HashSet();
            HashSet hashSet3 = new HashSet();
            Iterator iterator = hashSet.iterator();
            while (iterator.hasNext()) {
                NetCircuit netCircuit = (NetCircuit)iterator.next();
                if (netCircuit.getCircuitTypeObj().isTunnelCircuitType()) {
                    INetLink iNetLink2 = netCircuit.getLotLink();
                    INetLink iNetLink3 = netCircuit.getReverseLotLink();
                    hashSet2.addAll(this.ncm.getCircuits(iNetLink2));
                    hashSet2.addAll(this.ncm.getCircuits(iNetLink3));
                    continue;
                }
                if (!netCircuit.getCircuitTypeObj().isVcatCircuitType()) continue;
                hashSet3.addAll(((NetVcatCircuit)netCircuit).getAllMemberCircuits());
                iterator.remove();
            }
            if (!hashSet2.isEmpty()) {
                hashSet.addAll(hashSet2);
            }
            if (hashSet3.isEmpty()) continue;
            hashSet.addAll(hashSet3);
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("cktsInRing size = " + this.cktsInRing.size() + " allCktsInRing size = " + hashSet.size());
        if (((Object)this.cktsInRing).equals(hashSet)) {
            return false;
        }
        this.cktsInRing = hashSet;
        return true;
    }

    private void setCktsEndpointsOnLink() {
        for (INetElement iNetElement : this.getUpsrRingNEs()) {
            for (NetCircuit netCircuit : this.ncm.getCircuits(iNetElement.getNodeModel())) {
                for (INetLink iNetLink : this.getUpsrRingLinks()) {
                    if (netCircuit.getLinkEndpoints(iNetLink).isEmpty()) continue;
                    this.cktsEndpointsOnLink.add(netCircuit);
                }
            }
        }
    }

    private void setUpsrCircuits() {
        UpsrCircuitPaths upsrCircuitPaths;
        List list = this.getPartialUpsrCktsInRing();
        List list2 = this.getUnprotCktsWithUpsrInRing();
        Upsr2BlsrInServiceUpgradeMgr.debug("setUpsrCircuits called");
        for (NetCircuit netCircuit : this.cktsInRing) {
            if (netCircuit.getProtType() != 13 && netCircuit.getProtType() != 11 || list.contains(netCircuit) || (upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCircuit)) != null) continue;
            upsrCircuitPaths = new UpsrCircuitPaths(netCircuit, this.upsrRingNEs, this.upsrLinks);
            this.upsrCkts.put(netCircuit, upsrCircuitPaths);
            netCircuit.addObserver(this);
        }
        for (NetCircuit netCircuit : list2) {
            upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCircuit);
            if (upsrCircuitPaths != null) continue;
            upsrCircuitPaths = new UpsrCircuitPaths(netCircuit, this.upsrRingNEs, this.upsrLinks);
            this.upsrCkts.put(netCircuit, upsrCircuitPaths);
            netCircuit.addObserver(this);
        }
    }

    private void setUnusedTunnels() {
        this.unusedTunnelsBeforeUpgrade.addAll(this.getUnusedTunnels());
    }

    private List getCktsInRing() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.cktsInRing);
        return linkedList;
    }

    private List getCktsEndpointsOnLink() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.cktsEndpointsOnLink);
        return linkedList;
    }

    private List getPartialUpsrCktsInRing() {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<INetLink> hashSet2 = new HashSet<INetLink>();
        HashSet hashSet3 = new HashSet(this.upsrRingNEs);
        HashSet hashSet4 = new HashSet(this.upsrLinks);
        for (NetCircuit netCircuit : this.getCktsInRing()) {
            Object object;
            if (netCircuit.getProtType() != 13 && netCircuit.getProtType() != 11) continue;
            Iterator iterator = netCircuit.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                object = ((NetCircuitNode)iterator.next()).getNetElement();
                if (!hashSet3.contains(object)) continue;
                hashSet.add(object);
            }
            object = netCircuit.getCircuitSpans().iterator();
            while (object.hasNext()) {
                Object object22;
                INetLink iNetLink = ((NetCircuitSpan)object.next()).getLink();
                if (iNetLink.isPhysical()) {
                    if (hashSet4.contains(iNetLink)) {
                        hashSet2.add(iNetLink);
                        continue;
                    }
                    if (!hashSet4.contains(iNetLink.getReverseLink())) continue;
                    hashSet2.add(iNetLink.getReverseLink());
                    continue;
                }
                if (!iNetLink.isLOTunnel()) continue;
                for (Object object22 : iNetLink.getNodesList()) {
                    if (!hashSet3.contains(object22)) continue;
                    hashSet.add(object22);
                }
                object22 = iNetLink.getLinksList().iterator();
                while (object22.hasNext()) {
                    INetLink iNetLink2 = (INetLink)object22.next();
                    if (hashSet4.contains(iNetLink2)) {
                        hashSet2.add(iNetLink2);
                        continue;
                    }
                    if (!hashSet4.contains(iNetLink2.getReverseLink())) continue;
                    hashSet2.add(iNetLink2.getReverseLink());
                }
            }
            if (((Object)hashSet).equals(hashSet3) && ((Object)hashSet2).equals(hashSet4)) continue;
            Upsr2BlsrInServiceUpgradeMgr.debug("getPartialUpsrCktsInRing find a partial ckt " + netCircuit.getCircuitName());
            if (linkedList.contains(netCircuit)) continue;
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    private List getUnprotCktsWithUpsrInRing() {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        HashSet<Object> hashSet = new HashSet<Object>();
        HashSet<Object> hashSet2 = new HashSet<Object>();
        HashSet hashSet3 = new HashSet(this.upsrRingNEs);
        HashSet hashSet4 = new HashSet(this.upsrLinks);
        for (NetCircuit netCircuit : this.getCktsInRing()) {
            Object object;
            Object object22;
            Object object3;
            Object object4;
            if (netCircuit.getProtType() != 3) continue;
            Iterator iterator = netCircuit.getCircuitNodes().iterator();
            while (iterator.hasNext()) {
                object4 = ((NetCircuitNode)iterator.next()).getNetElement();
                if (!hashSet3.contains(object4)) continue;
                hashSet.add(object4);
            }
            object4 = netCircuit.getCircuitSpans().iterator();
            while (object4.hasNext()) {
                object3 = ((NetCircuitSpan)object4.next()).getLink();
                if (object3.isPhysical()) {
                    if (hashSet4.contains(object3)) {
                        hashSet2.add(object3);
                        continue;
                    }
                    if (!hashSet4.contains(object3.getReverseLink())) continue;
                    hashSet2.add(object3.getReverseLink());
                    continue;
                }
                if (!object3.isLOTunnel()) continue;
                for (Object object22 : object3.getNodesList()) {
                    if (!hashSet3.contains(object22)) continue;
                    hashSet.add(object22);
                }
                object22 = object3.getLinksList().iterator();
                while (object22.hasNext()) {
                    object = (INetLink)object22.next();
                    if (hashSet4.contains(object)) {
                        hashSet2.add(object);
                        continue;
                    }
                    if (!hashSet4.contains(object.getReverseLink())) continue;
                    hashSet2.add(object.getReverseLink());
                }
            }
            if (!((Object)hashSet).equals(hashSet3) || !((Object)hashSet2).equals(hashSet4)) continue;
            object3 = hashSet3.iterator();
            boolean bl = false;
            block5: while (object3.hasNext() && !bl) {
                object22 = netCircuit.getCircuitNodeFromNE((NetElement)object3.next());
                object = null;
                if (object22 == null) continue;
                Iterator iterator2 = object22.iterator();
                while (iterator2.hasNext()) {
                    object = (NetCircuitNode)iterator2.next();
                    if (!((NetCircuitNode)object).isUpsrSelector()) continue;
                    Upsr2BlsrInServiceUpgradeMgr.debug("getUnprotCktsWithUpsrInRing: find an unprot circuit that is Upsr in the ring " + netCircuit.getCircuitName());
                    if (!linkedList.contains(netCircuit)) {
                        linkedList.add(netCircuit);
                    }
                    bl = true;
                    continue block5;
                }
            }
        }
        return linkedList;
    }

    private List getUpsrCktsEndpointOnLink() {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        for (NetCircuit netCircuit : this.getCktsEndpointsOnLink()) {
            LinkedList linkedList2 = new LinkedList();
            for (INetLink iNetLink : this.upsrLinks) {
                linkedList2.addAll(netCircuit.getLinkEndpoints(iNetLink));
            }
            if ((linkedList2.size() != 2 || netCircuit.getCktSources().size() != 2 || !linkedList2.contains(netCircuit.getCktSources().get(0)) || !linkedList2.contains(netCircuit.getCktSources().get(1))) && (linkedList2.size() != 2 || netCircuit.getCktDrops().size() != 2 || !linkedList2.contains(netCircuit.getCktDrops().get(0)) || !linkedList2.contains(netCircuit.getCktDrops().get(1)))) continue;
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    private List getCktsInConversion() {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        for (NetCircuit netCircuit : this.getCktsInRing()) {
            if (netCircuit.getState() != 11 || this.upsrCkts.containsKey(netCircuit)) continue;
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    private boolean meetBLSRTimeSlots(NetCircuit netCircuit) {
        boolean bl = true;
        IHoNum iHoNum = null;
        ILoNum iLoNum = null;
        HoLoComparator hoLoComparator = HoLoComparator.instance();
        Upsr2BlsrInServiceUpgradeMgr.debug("meetBLSRTimeSlots for circuit: " + netCircuit.getCircuitName());
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCircuit);
        for (NetCircuitSpan netCircuitSpan : netCircuit.getCircuitSpans()) {
            INetLink iNetLink = netCircuitSpan.getLink();
            if (!UpsrCircuitPaths.belongTo(this.upsrLinks, iNetLink, netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) continue;
            if (upsrCircuitPaths != null) {
                INetCircuitNode iNetCircuitNode = netCircuitSpan.getSrcNCN();
                INetCircuitNode iNetCircuitNode2 = netCircuitSpan.getDstNCN();
                if (netCircuitSpan == upsrCircuitPaths.getOrigSpan() || netCircuitSpan == upsrCircuitPaths.getTermSpan() || !upsrCircuitPaths.getShortestPaths().contains(iNetCircuitNode) && !upsrCircuitPaths.getShortestPaths().contains(iNetCircuitNode2)) {
                    Upsr2BlsrInServiceUpgradeMgr.debug("ignore span " + netCircuitSpan.prettyString());
                    continue;
                }
            }
            if (iHoNum == null) {
                iHoNum = netCircuitSpan.getSrcHoNum();
                continue;
            }
            if (hoLoComparator.isEqual(iHoNum, netCircuitSpan.getSrcHoNum())) {
                if (!netCircuit.getCircuitTypeObj().isLoCircuitType()) continue;
                if (iLoNum == null) {
                    iLoNum = netCircuitSpan.getLoNum();
                    continue;
                }
                if (hoLoComparator.isEqual(iLoNum, netCircuitSpan.getLoNum())) continue;
                bl = false;
                break;
            }
            bl = false;
            break;
        }
        return bl;
    }

    private boolean potentialPcaCircuit(NetCircuit netCircuit) {
        Object object;
        NetCircuitSpan netCircuitSpan = null;
        NetCircuitNode netCircuitNode = null;
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCircuit);
        Iterator iterator = this.upsrRingNEs.iterator();
        while (iterator.hasNext()) {
            object = netCircuit.getCircuitNodeFromNE((NetElement)iterator.next());
            if (object == null) continue;
            Iterator iterator2 = object.iterator();
            boolean bl = false;
            NetCircuitNode netCircuitNode2 = null;
            while (iterator2.hasNext()) {
                netCircuitNode2 = (NetCircuitNode)iterator2.next();
                if (upsrCircuitPaths == null || !upsrCircuitPaths.getShortestPaths().contains(netCircuitNode2)) continue;
                netCircuitNode = netCircuitNode2;
                bl = true;
                break;
            }
            if (!bl) continue;
            break;
        }
        if (netCircuitNode != null) {
            object = netCircuitNode.getAllSpansList().iterator();
            while (object.hasNext() && !UpsrCircuitPaths.belongTo(this.upsrLinks, (netCircuitSpan = (NetCircuitSpan)object.next()).getLink(), netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) {
            }
        }
        return netCircuitSpan != null && ((NetCcatCircuit)netCircuit).isInStsUpperHalf(netCircuitSpan);
    }

    private List getPortGroupingCircuits(Map map) {
        LinkedList linkedList = new LinkedList();
        for (NetCcatCircuit netCcatCircuit : map.keySet()) {
            List list = PortGrouping.getCircuitsInPortGroup(netCcatCircuit);
            if (list.isEmpty() || linkedList.contains(netCcatCircuit)) continue;
            linkedList.addAll(list);
        }
        return linkedList;
    }

    private boolean inMonitorNodes(UpsrCircuitPaths upsrCircuitPaths, List list) {
        if (upsrCircuitPaths == null) {
            return false;
        }
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        linkedList.add(upsrCircuitPaths.getBridge());
        linkedList.addAll(upsrCircuitPaths.getLongestPaths());
        for (NetCircuitNode netCircuitNode : list) {
            for (NetCircuitNode netCircuitNode2 : linkedList) {
                if (!netCircuitNode2.getNetElement().equals(netCircuitNode.getNetElement())) continue;
                List list2 = netCircuitNode.getConnectionPathEnds();
                if (upsrCircuitPaths.getShortestPaths().contains(netCircuitNode2)) {
                    NetCircuitSpan netCircuitSpan = upsrCircuitPaths.getBridge() == netCircuitNode2 ? upsrCircuitPaths.getOrigSpan() : upsrCircuitPaths.getTermSpan();
                    if (!list2.contains(netCircuitNode2.getSpanEndpoint(netCircuitSpan))) continue;
                    return true;
                }
                for (NetCircuitEnd netCircuitEnd : netCircuitNode2.getConnectionPathEnds()) {
                    if (!list2.contains(netCircuitEnd)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private List haveMonitorCircuits(Set set, Map map) {
        LinkedList<NetCircuit> linkedList = new LinkedList<NetCircuit>();
        LinkedList<INetCircuitNode> linkedList2 = new LinkedList<INetCircuitNode>();
        for (NetCircuit netCircuit : set) {
            if (!netCircuit.isMonitorCircuit()) continue;
            linkedList2.add(netCircuit.getSrcCircuitNode());
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("haveMonitorCircuits: find " + linkedList2.size() + " number of monitor circuits in the ring");
        if (linkedList2.isEmpty()) {
            return linkedList;
        }
        for (NetCircuit netCircuit : map.keySet()) {
            UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)map.get(netCircuit);
            if (!this.inMonitorNodes(upsrCircuitPaths, linkedList2)) continue;
            Upsr2BlsrInServiceUpgradeMgr.debug("The upsr circuit " + netCircuit.getCircuitName() + " that is to be upgraded " + "has monitor circuit on its longest path which will be removed " + "if upgrade continues resulting in the orphaned monitor circuit");
            linkedList.add(netCircuit);
        }
        return linkedList;
    }

    private List potentialUnupgradableUpsrCircuits(Map map) {
        LinkedList<NetCcatCircuit> linkedList = new LinkedList<NetCcatCircuit>();
        for (NetCcatCircuit netCcatCircuit : map.keySet()) {
            UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)map.get(netCcatCircuit);
            if (upsrCircuitPaths.getBridge() != null && upsrCircuitPaths.getShortestPaths().size() >= 1 && upsrCircuitPaths.getLongestPaths().size() >= 1 && upsrCircuitPaths.getOrigSpan() != null && upsrCircuitPaths.getTermSpan() != null) continue;
            linkedList.add(netCcatCircuit);
        }
        return linkedList;
    }

    private String buildErrorString(List list) {
        String string = "";
        for (NetCircuit netCircuit : list) {
            string = string + "\n" + netCircuit.getCircuitName();
        }
        return string;
    }

    @Override
    public int upsr2BlsrConversionCheck() throws SanityCheckFailed {
        Object object22;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        LinkedList<Object> linkedList2 = new LinkedList<Object>();
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        LinkedList<Object> linkedList4 = new LinkedList<Object>();
        LinkedList linkedList5 = new LinkedList(this.upsrRingNEs);
        List list = this.getPartialUpsrCktsInRing();
        List list2 = this.getUpsrCktsEndpointOnLink();
        Set<Object> set = Collections.synchronizedSet(new HashSet());
        set.addAll(this.cktsInRing);
        set.addAll(this.cktsEndpointsOnLink);
        Upsr2BlsrInServiceUpgradeMgr.debug("upsr2BlsrConversionCheck:");
        for (Object object22 : set) {
            if (((NetCircuit)object22).getState() == 4 || ((NetCircuit)object22).getState() == 6) {
                linkedList.add(object22);
                continue;
            }
            if (((NetCircuit)object22).getProtType() == 18) {
                linkedList2.add(object22);
                continue;
            }
            if (!this.meetBLSRTimeSlots((NetCircuit)object22)) {
                linkedList3.add(object22);
                continue;
            }
            if (!this.cktsInRing.contains(object22) || !this.upsrCkts.keySet().contains(object22) || !this.potentialPcaCircuit((NetCircuit)object22)) continue;
            linkedList4.add(object22);
        }
        if (!linkedList.isEmpty()) {
            object22 = "These PARTIAL circuits cannot be upgraded:";
            object22 = (String)object22 + this.buildErrorString(linkedList);
            throw new SanityCheckFailed((String)object22);
        }
        if (!list2.isEmpty()) {
            object22 = "These " + this.UPSR_TERM + " circuits have " + "either sources or drops on the ring cannot be upgraded:";
            object22 = (String)object22 + this.buildErrorString(list2);
            throw new SanityCheckFailed((String)object22);
        }
        if (!linkedList2.isEmpty()) {
            object22 = "These DRI circuits cannot be upgraded:";
            object22 = (String)object22 + this.buildErrorString(linkedList2);
            throw new SanityCheckFailed((String)object22);
        }
        if (!list.isEmpty()) {
            object22 = "These " + this.UPSR_TERM + " circuits that only " + "partially traverse the ring cannot be upgraded:";
            object22 = (String)object22 + this.buildErrorString(list);
            throw new SanityCheckFailed((String)object22);
        }
        if (!linkedList3.isEmpty()) {
            object22 = "These circuits with different timeslots cannot be upgraded:";
            object22 = (String)object22 + this.buildErrorString(linkedList3);
            throw new SanityCheckFailed((String)object22);
        }
        if (!linkedList4.isEmpty()) {
            object22 = "These " + this.UPSR_TERM + " circuits cannot be " + "upgraded because they will be in PCA channels:";
            object22 = (String)object22 + this.buildErrorString(linkedList4);
            throw new SanityCheckFailed((String)object22);
        }
        Iterator<Object> iterator = linkedList5.iterator();
        while (iterator.hasNext()) {
            object22 = (INetElement)iterator.next();
            if (!object22.getNodeModel().provides(Feature.ISTU)) continue;
            iterator.remove();
        }
        if (!linkedList5.isEmpty()) {
            object22 = "The ring cannot be upgraded because the following NE(s) do not support the feature:";
            object22 = (String)object22 + this.buildErrorString(linkedList5);
            throw new SanityCheckFailed((String)object22);
        }
        object22 = this.getPortGroupingCircuits(this.upsrCkts);
        if (!object22.isEmpty()) {
            String string = "These " + this.UPSR_TERM + " circuits cannot be " + "upgraded because they are in a port group:";
            string = string + this.buildErrorString((List)object22);
            throw new SanityCheckFailed(string);
        }
        List list3 = this.potentialUnupgradableUpsrCircuits(this.upsrCkts);
        if (!list3.isEmpty()) {
            String string = "These " + this.UPSR_TERM + " circuits cannot be " + "upgraded because they do not appear upgradable:";
            string = string + this.buildErrorString(list3);
            throw new SanityCheckFailed(string);
        }
        List list4 = this.haveMonitorCircuits(set, this.upsrCkts);
        if (!list4.isEmpty()) {
            String string = "These " + this.UPSR_TERM + " circuits cannot be " + "upgraded because they have monitor circuits" + " on their longest paths that must be removed:";
            string = string + this.buildErrorString(list4);
            throw new SanityCheckFailed(string);
        }
        return this.upsrCkts.size();
    }

    @Override
    public void switchTraffic2ShortestPaths() throws InServiceUpgradeError {
        if (this.upsrCkts.values().isEmpty()) {
            this.setConversionStage(1);
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("switchTrafficToShortestPath =======================");
        if (this.inSerUpgradeJobGroup != null) {
            throw new InServiceUpgradeError("Another in-service upgrade job is already in progress.");
        }
        if (this.inSerUpgradeJobController == null) {
            this.inSerUpgradeJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.inSerUpgradeJobController == null) {
            throw new InServiceUpgradeError("The jobs could not be created.");
        }
        this.setConversionStage(1);
        Object[] objectArray = this.upsrCkts.keySet().toArray();
        IJobControl[] iJobControlArray = new IJobControl[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuit netCircuit = (NetCircuit)objectArray[i];
            iJobControlArray[i] = new Upsr2BlsrInServiceUpgradeWorker(netCircuit, this);
        }
        this.inSerUpgradeJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
        this.operationDone = false;
        this.inSerUpgradeJobController.submitJob(this.inSerUpgradeJobGroup);
        this.processJobResult();
    }

    @Override
    public void convert() throws InServiceUpgradeError {
        try {
            this.setUpsrRingLinks(this.upsrLinks);
        }
        catch (SanityCheckFailed sanityCheckFailed) {
            Upsr2BlsrInServiceUpgradeMgr.debug("convert cannot proceed due to invalid upsrLinks");
            throw new InServiceUpgradeError("The upgrade cannot proceed: " + sanityCheckFailed.getMessage());
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("convert called ============= ");
        this.processCreateConversionModels();
        this.processConvertUpsrCircuits();
        this.destroyUnusedTunnels();
        this.dispose();
    }

    private void processCreateConversionModels() throws InServiceUpgradeError {
        if (this.upsrCkts.values().isEmpty()) {
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModels ============================ ");
        if (this.inSerUpgradeJobGroup != null) {
            throw new InServiceUpgradeError("Another in-service upgrade job is already in progress.");
        }
        if (this.inSerUpgradeJobController == null) {
            this.inSerUpgradeJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.inSerUpgradeJobController == null) {
            throw new InServiceUpgradeError("The jobs could not be created.");
        }
        this.setConversionStage(2);
        Object[] objectArray = this.upsrCkts.keySet().toArray();
        IJobControl[] iJobControlArray = new IJobControl[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuit netCircuit = (NetCircuit)objectArray[i];
            iJobControlArray[i] = new Upsr2BlsrInServiceUpgradeWorker(netCircuit, this);
        }
        this.inSerUpgradeJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
        this.operationDone = false;
        this.inSerUpgradeJobController.submitJob(this.inSerUpgradeJobGroup);
        this.processJobResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processConvertUpsrCircuits() throws InServiceUpgradeError {
        if (this.getCktsInConversion().isEmpty() && this.upsrCkts.values().isEmpty()) {
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("convertUpsrCircuits ============================== ");
        if (this.inSerUpgradeJobGroup != null) {
            throw new InServiceUpgradeError("Another in-service upgrade job is already in progress.");
        }
        if (this.inSerUpgradeJobController == null) {
            this.inSerUpgradeJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.inSerUpgradeJobController == null) {
            throw new InServiceUpgradeError("The jobs could not be created.");
        }
        String string = "The UPSR to BLSR upgrade failed to convert\nthe connections on the following circuits:\n";
        boolean bl = false;
        this.setConversionStage(3);
        Object[] objectArray = this.upsrCkts.keySet().toArray();
        Object[] objectArray2 = this.getCktsInConversion().toArray();
        int n = objectArray.length + objectArray2.length;
        int n2 = n / 10 + (n % 10 == 0 ? 0 : 1);
        for (int i = 0; i < n2; ++i) {
            Object object;
            int n3;
            IJobControl[] iJobControlArray = n2 - i == 1 && n % 10 != 0 ? new IJobControl[n % 10] : new IJobControl[10];
            for (int j = 0; j < iJobControlArray.length; ++j) {
                n3 = i * 10 + j;
                object = n3 < objectArray.length ? (NetCircuit)objectArray[n3] : (NetCircuit)objectArray2[n3 - objectArray.length];
                iJobControlArray[j] = new Upsr2BlsrInServiceUpgradeWorker((NetCircuit)object, this);
            }
            this.inSerUpgradeJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
            this.operationDone = false;
            this.inSerUpgradeJobController.submitJob(this.inSerUpgradeJobGroup);
            while (!this.operationDone) {
                Object object2 = this.threadWaitObject;
                synchronized (object2) {
                    try {
                        this.threadWaitObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Upsr2BlsrInServiceUpgradeMgr.debug("In-Service Upgrade: InterruptedException");
                    }
                }
            }
            JobStatus[] jobStatusArray = this.inSerUpgradeJobGroup.getJobStatusList();
            for (n3 = 0; n3 < jobStatusArray.length; ++n3) {
                if (jobStatusArray[n3].value() != 2) continue;
                object = (InServiceUpgradeError)jobStatusArray[n3].getResult();
                if (object != null) {
                    string = string + ((Throwable)object).toString();
                }
                if (bl) continue;
                bl = true;
            }
            this.inSerUpgradeJobGroup = null;
            try {
                Thread.sleep(2000L);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (bl) {
            throw new InServiceUpgradeError(string);
        }
    }

    private void clearTrafficSwitching() throws InServiceUpgradeError {
        Upsr2BlsrInServiceUpgradeMgr.debug("clearTrafficSwitching =============================");
        if (this.inSerUpgradeJobGroup != null) {
            throw new InServiceUpgradeError("Another in-service upgrade job is already in progress.");
        }
        if (this.inSerUpgradeJobController == null) {
            this.inSerUpgradeJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.inSerUpgradeJobController == null) {
            throw new InServiceUpgradeError("The jobs could not be created.");
        }
        this.setConversionStage(5);
        Object[] objectArray = this.upsrCkts.keySet().toArray();
        IJobControl[] iJobControlArray = new IJobControl[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuit netCircuit = (NetCircuit)objectArray[i];
            iJobControlArray[i] = new Upsr2BlsrInServiceUpgradeWorker(netCircuit, this);
        }
        this.inSerUpgradeJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
        this.operationDone = false;
        this.inSerUpgradeJobController.submitJob(this.inSerUpgradeJobGroup);
        this.processJobResult();
    }

    private void destroyUnusedTunnels() throws InServiceUpgradeError {
        INetCircuit[] iNetCircuitArray2;
        LinkedList<INetCircuit[]> linkedList = new LinkedList<INetCircuit[]>();
        List list = this.getUnusedTunnels();
        for (INetCircuit[] iNetCircuitArray2 : list) {
            if (this.unusedTunnelsBeforeUpgrade.contains(iNetCircuitArray2)) continue;
            linkedList.add(iNetCircuitArray2);
        }
        if (linkedList.isEmpty()) {
            return;
        }
        iNetCircuitArray2 = new INetCircuit[linkedList.size()];
        for (int i = 0; i < linkedList.size(); ++i) {
            iNetCircuitArray2[i] = (INetCircuit)linkedList.get(i);
        }
        try {
            this.ncm.deleteSelectedCircuits(iNetCircuitArray2, 1, null);
        }
        catch (DeletionError deletionError) {
            Upsr2BlsrInServiceUpgradeMgr.debug("Upsr2BlsrInServiceUpgradeMgr: deleting unused tunnels hit exception");
            throw new InServiceUpgradeError(deletionError.getMessage());
        }
    }

    private void setUnusedTunnelState2AINS() throws InServiceUpgradeError {
        Object[] objectArray = this.getUnusedTunnels().toArray();
        if (objectArray.length == 0) {
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("setUnusedTunnelState2AINS ===========================");
        if (this.inSerUpgradeJobGroup != null) {
            throw new InServiceUpgradeError("Another in-service upgrade job is already in progress.");
        }
        if (this.inSerUpgradeJobController == null) {
            this.inSerUpgradeJobController = JobControllerFactory.createJC((int)5);
        }
        if (this.inSerUpgradeJobController == null) {
            throw new InServiceUpgradeError("The jobs could not be created.");
        }
        this.setConversionStage(4);
        IJobControl[] iJobControlArray = new IJobControl[objectArray.length];
        for (int i = 0; i < objectArray.length; ++i) {
            NetCircuit netCircuit = (NetCircuit)objectArray[i];
            iJobControlArray[i] = new Upsr2BlsrInServiceUpgradeWorker(netCircuit, this);
        }
        this.inSerUpgradeJobGroup = new JobGroup(iJobControlArray, (IJobGroupListener)this, null);
        this.operationDone = false;
        this.inSerUpgradeJobController.submitJob(this.inSerUpgradeJobGroup);
        this.processJobResult();
    }

    private List getUnusedTunnels() {
        Iterator iterator = this.getCktsInRing().iterator();
        LinkedList<INetCircuit> linkedList = new LinkedList<INetCircuit>();
        while (iterator.hasNext()) {
            INetCircuit iNetCircuit = (INetCircuit)iterator.next();
            if (!iNetCircuit.getCircuitTypeObj().isTunnelCircuitType()) continue;
            try {
                iNetCircuit.destroySanityCheck();
            }
            catch (SanityCheckFailed sanityCheckFailed) {
                continue;
            }
            linkedList.add(iNetCircuit);
        }
        return linkedList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processJobResult() throws InServiceUpgradeError {
        Object object;
        while (!this.operationDone) {
            object = this.threadWaitObject;
            synchronized (object) {
                try {
                    this.threadWaitObject.wait();
                }
                catch (InterruptedException interruptedException) {
                    Upsr2BlsrInServiceUpgradeMgr.debug("In-Service Upgrade: InterruptedException");
                }
            }
        }
        switch (this.getConversionStage()) {
            case 1: {
                object = "The " + this.UPSR_TERM + " to " + this.BLSR_TERM + " upgrade operation " + "failed to switch traffic on the following circuits\n";
                break;
            }
            case 2: {
                object = "The " + this.UPSR_TERM + " to " + this.BLSR_TERM + " upgrade operation " + "failed to create a conversion model on the following circuits\n";
                break;
            }
            case 3: {
                object = "The " + this.UPSR_TERM + " to " + this.BLSR_TERM + " upgrade operation " + "failed to convert connections on the following circuits\n";
                break;
            }
            case 4: {
                object = "The " + this.UPSR_TERM + " to " + this.BLSR_TERM + " upgrade operation " + "failed to set the admin state to AINS on the following circuits\n";
                break;
            }
            case 5: {
                object = "The " + this.UPSR_TERM + " to " + this.BLSR_TERM + " upgrade operation " + "failed to clear protection switching on the following circuits\n";
                break;
            }
            default: {
                Upsr2BlsrInServiceUpgradeMgr.debug("unknown conversion stage");
                throw new InServiceUpgradeError("An in-service upgrade error occurred.\nThe job result returned with an unknown operation.");
            }
        }
        JobStatus[] jobStatusArray = this.inSerUpgradeJobGroup.getJobStatusList();
        boolean bl = false;
        for (int i = 0; i < jobStatusArray.length; ++i) {
            if (jobStatusArray[i].value() != 2) continue;
            InServiceUpgradeError inServiceUpgradeError = (InServiceUpgradeError)jobStatusArray[i].getResult();
            if (inServiceUpgradeError != null) {
                object = (String)object + inServiceUpgradeError.getMessage();
            }
            if (bl) continue;
            bl = true;
        }
        this.inSerUpgradeJobGroup = null;
        if (bl) {
            throw new InServiceUpgradeError((String)object);
        }
    }

    private void switchTraffic2ShortestPaths(INetCircuit iNetCircuit) throws InvalidSpanProtectionOp {
        if (iNetCircuit.getState() == 11) {
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("switchTraffic2ShortestPaths for circuit " + iNetCircuit.getCircuitName());
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(iNetCircuit);
        NetCircuitNode netCircuitNode = upsrCircuitPaths.getBridge();
        if (netCircuitNode == null) {
            if (upsrCircuitPaths.inConversionCreation || iNetCircuit.getState() != 11) {
                Upsr2BlsrInServiceUpgradeMgr.debug("switchTraffic2ShortestPaths: the circuit has no bridge found");
                throw new InvalidSpanProtectionOp("Traffic for the circuit " + iNetCircuit.getCircuitName() + " cannot be switched because no bridge node was found.");
            }
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("bridge node " + netCircuitNode.getName() + " shortest path size = " + upsrCircuitPaths.getShortestPaths().size() + " longest path size = " + upsrCircuitPaths.getLongestPaths().size());
        if (iNetCircuit.getState() != 11) {
            upsrCircuitPaths.getTermSpan().performProtectionOp(0);
            upsrCircuitPaths.getTermSpan().switchTrafficAway();
        }
    }

    private void createConversionModels(INetCircuit iNetCircuit) throws Busy, PathListIncomplete, ConnectionInRoll, ConnectionInTopologyUpgrade, ConnectionInTestAccess, ConnectionInLoopback, TopologyUpgradeNotAllowed, CTCUserException, ConnectionPathNotFound {
        int n;
        Object object;
        ConnCreateAttrs connCreateAttrs = new ConnCreateAttrs();
        connCreateAttrs.setCktName(iNetCircuit.getCircuitName());
        Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModels for circuit " + iNetCircuit.getCircuitName());
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(iNetCircuit);
        if (upsrCircuitPaths == null) {
            Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModels for circuit " + iNetCircuit.getCircuitName() + " has null " + this.UPSR_TERM + " paths");
            return;
        }
        NetCircuitNode netCircuitNode = upsrCircuitPaths.getBridge();
        if (netCircuitNode == null) {
            if (iNetCircuit.getState() != 11 || upsrCircuitPaths.inConversionCreation) {
                throw new CTCUserException("The bridge node is missing.");
            }
            return;
        }
        IConnectionModel iConnectionModel = this.getConnModel(netCircuitNode);
        if (iConnectionModel != null) {
            if (!iConnectionModel.inConnectionConversion()) {
                object = this.findNewPaths((NetCircuit)iNetCircuit, netCircuitNode);
                n = this.findNewConnectionType((NetCircuit)iNetCircuit, netCircuitNode);
                Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModel on node " + netCircuitNode.getName() + " with newPaths size = " + object.size() + " newConnType = " + (n == -1 ? "Unknown" : EnumStrings.getString(IConnectionType.class, (int)n)));
                iConnectionModel.createConnectionConversionModel((List)object, 1, iNetCircuit.getCircuitId(), new LinkedList(), n, (IConnCreateAttrs)connCreateAttrs, 0, true, true);
            }
        } else {
            Upsr2BlsrInServiceUpgradeMgr.debug("connection model is null for node " + netCircuitNode.getName());
            throw new CTCUserException("The upgrade was aborted because no connection reference was found on the bridge node " + netCircuitNode.getName() + " of the circuit " + iNetCircuit.getCircuitName() + ".");
        }
        if (iNetCircuit.getCircuitDir() == 0) {
            for (NetCircuitNode netCircuitNode2 : upsrCircuitPaths.getShortestPaths()) {
                iConnectionModel = this.getConnModel(netCircuitNode2);
                if (iConnectionModel != null) {
                    if (iConnectionModel.inConnectionConversion()) continue;
                    if (upsrCircuitPaths.getLongestPaths().contains(netCircuitNode2)) {
                        object = this.findNewPaths((NetCircuit)iNetCircuit, netCircuitNode2);
                        n = this.findNewConnectionType((NetCircuit)iNetCircuit, netCircuitNode2);
                        Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModel on ONEWAY selector node " + netCircuitNode2.getName() + " with newPaths size = " + object.size() + " newConnType = " + (n == -1 ? "Unknown" : EnumStrings.getString(IConnectionType.class, (int)n)));
                        iConnectionModel.createConnectionConversionModel((List)object, 1, iNetCircuit.getCircuitId(), new LinkedList(), n, (IConnCreateAttrs)connCreateAttrs, 1, true, false);
                        continue;
                    }
                    object = this.rearrangePaths((NetCircuit)iNetCircuit, netCircuitNode2);
                    Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModel on shortest path on node " + netCircuitNode2.getName() + " with path list unchanged and but connection type changing to ONEWAY");
                    iConnectionModel.createConnectionConversionModel((List)object, 1, iNetCircuit.getCircuitId(), new LinkedList(), 0, (IConnCreateAttrs)connCreateAttrs, 1, true, false);
                    continue;
                }
                Upsr2BlsrInServiceUpgradeMgr.debug("connection model is null for node " + netCircuitNode2.getName());
            }
        }
        for (NetCircuitNode netCircuitNode2 : upsrCircuitPaths.getLongestPaths()) {
            iConnectionModel = this.getConnModel(netCircuitNode2);
            if (iConnectionModel != null) {
                if (iConnectionModel.inConnectionConversion()) continue;
                object = netCircuitNode2.getPathsFromConnModel();
                if (!netCircuitNode2.isUpsrSelector()) {
                    Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModel on longest path on node " + netCircuitNode2.getName() + " with empty path list" + "and TWOWAY connection");
                    iConnectionModel.createConnectionConversionModel(new LinkedList(), 1, iNetCircuit.getCircuitId(), new LinkedList(), 1, (IConnCreateAttrs)connCreateAttrs, 1, true, false);
                    continue;
                }
                if (iNetCircuit.getCircuitDir() == 0) continue;
                List list = this.findNewPaths((NetCircuit)iNetCircuit, netCircuitNode2);
                int n2 = this.findNewConnectionType((NetCircuit)iNetCircuit, netCircuitNode2);
                Upsr2BlsrInServiceUpgradeMgr.debug("createConversionModel on TWOWAY selector node " + netCircuitNode2.getName() + " with newPaths size = " + list.size() + " newConnType = " + (n2 == -1 ? "Unknown" : EnumStrings.getString(IConnectionType.class, (int)n2)));
                iConnectionModel.createConnectionConversionModel(list, 1, iNetCircuit.getCircuitId(), new LinkedList(), n2, (IConnCreateAttrs)connCreateAttrs, 1, true, false);
                continue;
            }
            Upsr2BlsrInServiceUpgradeMgr.debug("connection model is null for node " + netCircuitNode2.getName());
        }
        object = netCircuitNode.getConn().getConnectionConversionModel();
        if (object != null) {
            object.setState(1);
        } else {
            Upsr2BlsrInServiceUpgradeMgr.debug("conversion model is null for node " + netCircuitNode.getName());
        }
    }

    private void convertCircuit(INetCircuit iNetCircuit) {
        Upsr2BlsrInServiceUpgradeMgr.debug("convertCircuit called for circuit " + iNetCircuit.getCircuitName());
        for (NetCircuitNode netCircuitNode : iNetCircuit.getCircuitNodes()) {
            IConnectionConversionModel iConnectionConversionModel = netCircuitNode.getConnectionConversionModel();
            if (iConnectionConversionModel == null) continue;
            iConnectionConversionModel.convert();
            Upsr2BlsrInServiceUpgradeMgr.debug("convertCircuit on node " + netCircuitNode.getName() + ":CONVERTED");
        }
    }

    private List findNewPaths(NetCircuit netCircuit, NetCircuitNode netCircuitNode) throws ConnectionPathNotFound {
        Object e;
        NetCircuitSpan netCircuitSpan;
        Object object;
        int n = netCircuitNode.getConnectionType();
        List<Object> list = Arrays.asList(netCircuitNode.getPathsFromConnModel());
        if (netCircuitNode.hasDualConnections()) {
            object = ((DualConnectionCircuitNode)netCircuitNode).getChildCktNode(this.upsrLinks);
            if (object != null) {
                list = Arrays.asList(((NetCircuitNode)object).getPathsFromConnModel());
                n = ((NetCircuitNode)object).getConnectionType();
            } else {
                Upsr2BlsrInServiceUpgradeMgr.debug("Error: could not find the child node on this dual circuit node");
            }
        }
        object = new ArrayList<Object>(list);
        int n2 = 0;
        int n3 = 0;
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCircuit);
        if (upsrCircuitPaths == null) {
            Upsr2BlsrInServiceUpgradeMgr.debug("findNewPaths for circuit " + netCircuit.getCircuitName() + " has null " + this.UPSR_TERM + " paths");
            return object;
        }
        n2 = netCircuitNode == upsrCircuitPaths.getBridge() ? upsrCircuitPaths.getOrigSpan().getEntityIndex(netCircuitNode.getNetElement()) : upsrCircuitPaths.getTermSpan().getEntityIndex(netCircuitNode.getNetElement());
        if (n2 != 0) {
            for (int i = 0; i < list.size(); ++i) {
                n3 = netCircuitNode.getEntityIndexFromPathDef(list.get(i));
                if (n3 == 0 || n3 != n2) continue;
                ((ArrayList)object).remove(list.get(i));
                break;
            }
        }
        if (netCircuitNode.areNodesEqual(upsrCircuitPaths.getBridge()) && n != 0 && n != 6 && n != 3) {
            Object e2 = ((ArrayList)object).remove(0);
            ((ArrayList)object).add(1, e2);
        } else if (!netCircuitNode.areNodesEqual(upsrCircuitPaths.getBridge()) && n == 3 && (netCircuitSpan = netCircuitNode.getSpanFromPathDef((IPathDefModel)(e = ((ArrayList)object).get(0)))) != null && netCircuitSpan.belongsToPathZeroSelector(netCircuitNode)) {
            ((ArrayList)object).remove(0);
            ((ArrayList)object).add(2, e);
        }
        netCircuitNode.getOperator().prettyPrint((List)object);
        return object;
    }

    private int findNewConnectionType(NetCircuit netCircuit, NetCircuitNode netCircuitNode) {
        CmsObservable cmsObservable;
        NetCircuitNode netCircuitNode2 = netCircuitNode;
        int n = netCircuitNode2.getConnectionType();
        if (netCircuitNode.hasDualConnections()) {
            cmsObservable = ((DualConnectionCircuitNode)netCircuitNode).getChildCktNode(this.upsrLinks);
            if (cmsObservable != null) {
                n = ((NetCircuitNode)cmsObservable).getConnectionType();
                netCircuitNode2 = cmsObservable;
            } else {
                Upsr2BlsrInServiceUpgradeMgr.debug("Error: could not find the child node on this dual circuit node");
            }
        }
        if (netCircuit.getCircuitDir() == 1) {
            if (n == 2) {
                n = 1;
            } else if (n == 3) {
                n = 2;
            }
        } else if (n == 4) {
            n = 0;
        } else if (n == 6 || n == 5 || n == 7) {
            if (netCircuitNode2.getTermSpans().size() == 2) {
                cmsObservable = (NetCircuitSpan)netCircuitNode2.getTermSpans().getFirst();
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)netCircuitNode2.getTermSpans().getLast();
                if (UpsrCircuitPaths.belongTo(this.upsrLinks, ((NetCircuitSpan)cmsObservable).getLink(), ((NetCircuitSpan)cmsObservable).getSrcHoNum(), ((NetCircuitSpan)cmsObservable).getDstHoNum()) && UpsrCircuitPaths.belongTo(this.upsrLinks, netCircuitSpan.getLink(), netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) {
                    n = 0;
                }
            } else if (netCircuitNode2.getTermSpans().size() == 1 && UpsrCircuitPaths.belongTo(this.upsrLinks, ((NetCircuitSpan)(cmsObservable = (NetCircuitSpan)netCircuitNode2.getTermSpans().getFirst())).getLink(), ((NetCircuitSpan)cmsObservable).getSrcHoNum(), ((NetCircuitSpan)cmsObservable).getDstHoNum())) {
                n = 0;
            }
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("findNewConnectionType for circuit " + netCircuit.getCircuitName() + " on node " + netCircuitNode2.getName() + " " + EnumStrings.getString(IConnectionType.class, (int)n));
        return n;
    }

    private List rearrangePaths(NetCircuit netCircuit, NetCircuitNode netCircuitNode) {
        NetCircuitSpan netCircuitSpan2;
        LinkedList<Object> linkedList = new LinkedList<Object>(Arrays.asList(netCircuitNode.getPathsFromConnModel()));
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(netCircuit);
        if (upsrCircuitPaths == null) {
            Upsr2BlsrInServiceUpgradeMgr.debug("rearrangePaths for circuit " + netCircuit.getCircuitName() + " has null " + this.UPSR_TERM + " paths");
            return linkedList;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("rearrangePaths for circuit " + netCircuit.getCircuitName());
        NetCircuitNode netCircuitNode2 = upsrCircuitPaths.getBridge();
        LinkedList<NetCircuitSpan> linkedList2 = new LinkedList<NetCircuitSpan>();
        for (NetCircuitSpan netCircuitSpan2 : netCircuitNode2.getOrigSpans()) {
            if (!UpsrCircuitPaths.belongTo(this.upsrLinks, netCircuitSpan2.getLink(), netCircuitSpan2.getSrcHoNum(), netCircuitSpan2.getDstHoNum())) continue;
            linkedList2.add(netCircuitSpan2);
        }
        if (linkedList2.size() != 2) {
            Upsr2BlsrInServiceUpgradeMgr.debug("rearrangePaths for circuit " + netCircuit.getCircuitName() + " could not find two orig spans on bridge node " + netCircuitNode2.getName());
            return linkedList;
        }
        netCircuitSpan2 = linkedList2.get(0) == upsrCircuitPaths.getOrigSpan() ? (NetCircuitSpan)linkedList2.get(1) : (NetCircuitSpan)linkedList2.get(0);
        Upsr2BlsrInServiceUpgradeMgr.debug("rearrangePaths: start on span " + netCircuitSpan2.prettyString() + " on bridge node " + netCircuitNode2.getName());
        NetCircuitNode netCircuitNode3 = netCircuitNode2;
        block1: while (true) {
            NetCircuitSpan netCircuitSpan3;
            Iterator iterator;
            if ((netCircuitNode3 = netCircuitNode3.spanGetPeer(netCircuitSpan2)) == netCircuitNode) {
                if (netCircuitNode3.getPathDefIndexFromSpan(netCircuitSpan2) != 1) break;
                Upsr2BlsrInServiceUpgradeMgr.debug("rearrangePaths: shuffle paths on node " + netCircuitNode3.getName());
                iterator = linkedList.remove(1);
                linkedList.add(0, iterator);
                break;
            }
            iterator = netCircuitNode3.getAllSpansList().iterator();
            do {
                if (!iterator.hasNext()) continue block1;
            } while (!UpsrCircuitPaths.belongTo(this.upsrLinks, (netCircuitSpan3 = (NetCircuitSpan)iterator.next()).getLink(), netCircuitSpan3.getSrcHoNum(), netCircuitSpan3.getDstHoNum()) || netCircuitSpan3 == netCircuitSpan2);
            netCircuitSpan2 = netCircuitSpan3;
        }
        netCircuitNode.getOperator().prettyPrint(linkedList);
        return linkedList;
    }

    private IConnectionModel getConnModel(NetCircuitNode netCircuitNode) {
        IConnectionModel iConnectionModel = null;
        if (netCircuitNode.hasDualConnections()) {
            NetCircuitNode netCircuitNode2 = ((DualConnectionCircuitNode)netCircuitNode).getChildCktNode(this.upsrLinks);
            if (netCircuitNode2 != null) {
                iConnectionModel = netCircuitNode2.getConn();
            }
        } else {
            iConnectionModel = netCircuitNode.getConn();
        }
        return iConnectionModel;
    }

    private void clearTrafficSwitching(INetCircuit iNetCircuit) throws InvalidSpanProtectionOp {
        if (iNetCircuit.getState() == 11) {
            return;
        }
        Upsr2BlsrInServiceUpgradeMgr.debug("clearTrafficSwitching for circuit " + iNetCircuit.getCircuitName());
        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(iNetCircuit);
        upsrCircuitPaths.getTermSpan().performProtectionOp(0);
    }

    private void setUnusedLOT2AINS(INetCircuit iNetCircuit) throws IncorrectCircuitState, AdminStateProvisioningError {
        Upsr2BlsrInServiceUpgradeMgr.debug("setUnusedLOT2AINS for circuit " + iNetCircuit.getCircuitName());
        iNetCircuit.setAdminState(3);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void jobGroupFinished(JobGroup jobGroup) {
        Object object = this.threadWaitObject;
        synchronized (object) {
            this.operationDone = true;
            this.threadWaitObject.notifyAll();
        }
    }

    @Override
    public synchronized void update(Observable observable, Object object) {
        if (observable instanceof INetCircuit) {
            INetCircuit iNetCircuit = (INetCircuit)((Object)observable);
            if (iNetCircuit.isCircuitRefValid()) {
                Upsr2BlsrInServiceUpgradeMgr.debug("update ckt = " + iNetCircuit.getCircuitName() + " CHANGED");
                if (this.upsrCkts.containsKey(iNetCircuit)) {
                    if (iNetCircuit.getState() == 4 || iNetCircuit.getState() == 6) {
                        UpsrCircuitPaths upsrCircuitPaths = (UpsrCircuitPaths)this.upsrCkts.get(iNetCircuit);
                        upsrCircuitPaths.clear();
                    }
                } else if (iNetCircuit.getCircuitDir() == 0 && (iNetCircuit.getProtType() == 13 || iNetCircuit.getProtType() == 11) && this.setCktsInRing()) {
                    this.setUpsrCircuits();
                }
            } else {
                Upsr2BlsrInServiceUpgradeMgr.debug("update ckt = " + iNetCircuit.getCircuitName() + " DELETED");
                if (this.upsrCkts.containsKey(iNetCircuit)) {
                    this.upsrCkts.remove(iNetCircuit);
                } else if (this.cktsInRing.contains(iNetCircuit)) {
                    this.cktsInRing.remove(iNetCircuit);
                } else if (this.cktsEndpointsOnLink.contains(iNetCircuit)) {
                    this.cktsEndpointsOnLink.remove(iNetCircuit);
                }
            }
        } else {
            Upsr2BlsrInServiceUpgradeMgr.debug("update event from NCM");
            if (this.setCktsInRing()) {
                this.setUpsrCircuits();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispose() {
        Map map = this.upsrCkts;
        synchronized (map) {
            for (NetCircuit netCircuit : this.upsrCkts.keySet()) {
                netCircuit.deleteObserver(this);
            }
        }
        this.upsrLinks.clear();
        this.upsrRingNEs.clear();
        this.upsrCkts.clear();
        this.cktsInRing.clear();
        this.cktsEndpointsOnLink.clear();
        this.unusedTunnelsBeforeUpgrade.clear();
        this.ncm.deleteObserver(this);
    }

    @Override
    public void cancel() throws InServiceUpgradeError {
        if (this.upsrCkts.values().isEmpty()) {
            return;
        }
        int n = this.getConversionStage();
        Upsr2BlsrInServiceUpgradeMgr.debug("cancel upsr2blsr topology upgrade by client");
        switch (this.stage) {
            case 1: {
                this.clearTrafficSwitching();
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                break;
            }
        }
        this.setConversionStage(0);
        this.dispose();
    }
}

