/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ncp;

import cerent.cms.ncp.INetCircuit;
import cerent.cms.ncp.NetCircuit;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.ncp.NetCircuitNode;
import cerent.cms.ncp.NetCircuitSpan;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.util.IHoNum;
import cerent.util.SDebug;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

class UpsrCircuitPaths {
    public NetCircuitNode bridge = null;
    public List shortestPaths = Collections.synchronizedList(new LinkedList());
    public List longestPaths = Collections.synchronizedList(new LinkedList());
    public NetCircuitSpan origSpan = null;
    public NetCircuitSpan termSpan = null;
    public boolean inConversionCreation = false;
    private static final SDebug db = new SDebug("UpsrCircuitPaths");

    public UpsrCircuitPaths() {
    }

    public UpsrCircuitPaths(INetCircuit iNetCircuit, List list, List list2) {
        this();
        this.setBridge(iNetCircuit, list, list2);
        this.setPaths(iNetCircuit, list, list2);
    }

    protected NetCircuitNode getBridge() {
        return this.bridge;
    }

    protected List getShortestPaths() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.shortestPaths);
        return linkedList;
    }

    protected List getLongestPaths() {
        LinkedList linkedList = new LinkedList();
        linkedList.addAll(this.longestPaths);
        return linkedList;
    }

    protected NetCircuitSpan getOrigSpan() {
        return this.origSpan;
    }

    protected NetCircuitSpan getTermSpan() {
        return this.termSpan;
    }

    public void clear() {
        this.bridge = null;
        this.shortestPaths.clear();
        this.longestPaths.clear();
        this.origSpan = null;
        this.termSpan = null;
    }

    public void setInConversionCreation(INetCircuit iNetCircuit) {
        if (iNetCircuit.getState() == 11) {
            for (NetCircuitNode netCircuitNode : iNetCircuit.getCircuitNodes()) {
                if (!netCircuitNode.inConnectionConversion() || netCircuitNode.getConnectionConversionModel().getState() != 0) continue;
                this.inConversionCreation = true;
            }
        }
    }

    protected void setBridge(INetCircuit iNetCircuit, List list, List list2) {
        Iterator iterator = iNetCircuit.getCircuitNodes().iterator();
        if (iNetCircuit.getState() == 11) {
            this.setInConversionCreation(iNetCircuit);
            if (!this.inConversionCreation) {
                return;
            }
            while (iterator.hasNext()) {
                NetCircuitNode netCircuitNode = (NetCircuitNode)iterator.next();
                if (!netCircuitNode.upsrBridgeOrSelector() || !netCircuitNode.inConnectionConversion() || netCircuitNode.getConnectionConversionModel().getState() != 0) continue;
                this.bridge = netCircuitNode;
                break;
            }
            return;
        }
        db.println("UpsrCircuitPaths: setBridge called for circuit " + iNetCircuit.getCircuitName());
        for (NetCircuitNode netCircuitNode : iNetCircuit.getCircuitNodes()) {
            if (!list.contains(netCircuitNode.getNetElement()) || !netCircuitNode.upsrBridgeOrSelector()) continue;
            LinkedList linkedList = new LinkedList();
            linkedList.addAll(netCircuitNode.getOrigSpans());
            if (linkedList.size() < 2) continue;
            db.println("UpsrCircuitPaths: got at least two origSpans for " + iNetCircuit.getCircuitName());
            Iterator iterator2 = linkedList.iterator();
            int n = 0;
            while (iterator2.hasNext()) {
                NetCircuitSpan netCircuitSpan = (NetCircuitSpan)iterator2.next();
                if (!UpsrCircuitPaths.belongTo(list2, netCircuitSpan.getLink(), netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) continue;
                ++n;
            }
            if (n != 2) continue;
            this.bridge = netCircuitNode;
            db.println("UpsrCircuitPaths: find the bridge on " + netCircuitNode.getName() + " for circuit " + iNetCircuit.getCircuitName());
            break;
        }
        if (this.bridge == null) {
            db.println("UpsrCircuitPaths: setBridge - failed to find bridge node " + iNetCircuit.getCircuitName());
        }
    }

    public static boolean belongTo(List list, INetLink iNetLink, IHoNum iHoNum, IHoNum iHoNum2) {
        db.println("UpsrCircuitPaths->belongTo is called");
        if (iNetLink.isLOTunnel()) {
            NetCircuit netCircuit = NetCircuitManager.instance().findLoTunnel(iNetLink, iHoNum, iHoNum2);
            if (netCircuit != null) {
                for (NetCircuitSpan netCircuitSpan : netCircuit.getCircuitSpans()) {
                    if (list.contains(netCircuitSpan.getLink()) || list.contains(netCircuitSpan.getReverseLink())) continue;
                    return false;
                }
                db.println("UpsrCircuitPaths->belongTo return true for tunnel link");
                return true;
            }
            return false;
        }
        if (list.contains(iNetLink) || list.contains(Network.instance().findReverseLink(iNetLink))) {
            db.println("UpsrCircuitPaths->belongTo return true for a link" + iNetLink.prettyString());
            return true;
        }
        return false;
    }

    protected void setPaths(INetCircuit iNetCircuit, List list, List list2) {
        NetCircuitNode netCircuitNode;
        NetCircuitSpan netCircuitSpan;
        int n;
        NetCircuitSpan netCircuitSpan2;
        NetCircuitSpan netCircuitSpan3;
        LinkedList<NetCircuitNode> linkedList = new LinkedList<NetCircuitNode>();
        LinkedList<NetCircuitNode> linkedList2 = new LinkedList<NetCircuitNode>();
        LinkedList<NetCircuitNode> linkedList3 = new LinkedList<NetCircuitNode>();
        db.println("UpsrCircuitPaths setPaths called for circuit " + iNetCircuit.getCircuitName());
        if (this.bridge == null) {
            if (iNetCircuit.getState() != 11 || this.inConversionCreation) {
                db.println(iNetCircuit.getCircuitName() + " has no bridge found");
            }
            return;
        }
        if (this.inConversionCreation) {
            LinkedList<NetCircuitSpan> linkedList4 = new LinkedList<NetCircuitSpan>();
            for (NetCircuitSpan netCircuitSpan4 : this.bridge.getAllSpansList()) {
                if (!UpsrCircuitPaths.belongTo(list2, netCircuitSpan4.getLink(), netCircuitSpan4.getSrcHoNum(), netCircuitSpan4.getDstHoNum())) continue;
                linkedList4.add(netCircuitSpan4);
            }
            for (NetCircuitSpan netCircuitSpan4 : linkedList4) {
                int n2;
                NetCircuitNode netCircuitNode2 = this.bridge.spanGetPeer(netCircuitSpan4);
                while (!netCircuitNode2.isUpsrSelector()) {
                    netCircuitSpan4 = this.findAlternateSpan(netCircuitNode2, netCircuitSpan4, list2);
                    netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan4);
                }
                NetCircuitNode netCircuitNode3 = netCircuitNode2;
                LinkedList<Integer> linkedList5 = new LinkedList<Integer>();
                Iterator iterator = netCircuitNode2.getActivePathList().iterator();
                while (iterator.hasNext()) {
                    n2 = netCircuitNode2.getEntityIndexFromPathDef(iterator.next());
                    linkedList5.add(new Integer(n2));
                }
                if (linkedList5.contains(new Integer(netCircuitSpan4.getEntityIndex(netCircuitNode2.getNetElement())))) continue;
                this.termSpan = netCircuitSpan4;
                this.longestPaths.add(netCircuitNode2);
                while (netCircuitNode2 != this.bridge) {
                    netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan4);
                    netCircuitSpan4 = this.findAlternateSpan(netCircuitNode2, netCircuitSpan4, list2);
                    this.longestPaths.add(0, netCircuitNode2);
                }
                this.origSpan = netCircuitSpan4;
                n2 = linkedList4.indexOf(netCircuitSpan4);
                NetCircuitSpan netCircuitSpan5 = n2 == 0 ? (NetCircuitSpan)linkedList4.get(1) : (NetCircuitSpan)linkedList4.get(0);
                this.shortestPaths.add(this.bridge);
                netCircuitSpan4 = netCircuitSpan5;
                for (netCircuitNode2 = this.bridge; netCircuitNode2 != netCircuitNode3; netCircuitNode2 = netCircuitNode2.spanGetPeer(netCircuitSpan4)) {
                    netCircuitSpan4 = this.findAlternateSpan(netCircuitNode2, netCircuitSpan4, list2);
                    this.shortestPaths.add(netCircuitNode2);
                }
            }
            return;
        }
        if (iNetCircuit.getCircuitDir() == 1) {
            netCircuitSpan3 = (NetCircuitSpan)this.bridge.getOrigSpans().get(0);
            netCircuitSpan2 = (NetCircuitSpan)this.bridge.getOrigSpans().get(1);
            int n3 = 0;
            n = 0;
            netCircuitSpan = netCircuitSpan3;
            for (netCircuitNode = this.bridge.spanGetPeer(netCircuitSpan); netCircuitNode != null && !netCircuitNode.isUpsrSelector(); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan)) {
                linkedList.add(netCircuitNode);
                n3 = (short)(n3 + 1);
                if (netCircuitSpan.getLink().isLOTunnel()) {
                    n3 = (short)(n3 + netCircuitSpan.getLink().getNodesList().size());
                    n3 = (short)(n3 - 2);
                }
                netCircuitSpan = this.findAlternateSpan(netCircuitNode, netCircuitSpan, list2);
            }
            linkedList.add(netCircuitNode);
            n3 = (short)(n3 + 1);
            if (netCircuitSpan != null && netCircuitSpan.getLink().isLOTunnel()) {
                n3 = (short)(n3 + netCircuitSpan.getLink().getNodesList().size());
                n3 = (short)(n3 - 2);
            }
            netCircuitSpan = netCircuitSpan2;
            for (netCircuitNode = this.bridge.spanGetPeer(netCircuitSpan); netCircuitNode != null && !netCircuitNode.isUpsrSelector(); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan)) {
                linkedList2.add(netCircuitNode);
                n = (short)(n + 1);
                if (netCircuitSpan.getLink().isLOTunnel()) {
                    n = (short)(n + netCircuitSpan.getLink().getNodesList().size());
                    n = (short)(n - 2);
                }
                netCircuitSpan = this.findAlternateSpan(netCircuitNode, netCircuitSpan, list2);
            }
            linkedList2.add(netCircuitNode);
            n = (short)(n + 1);
            if (netCircuitSpan != null && netCircuitSpan.getLink().isLOTunnel()) {
                n = (short)(n + netCircuitSpan.getLink().getNodesList().size());
                n = (short)(n - 2);
            }
            if (n3 < n) {
                this.shortestPaths = linkedList;
                this.longestPaths = linkedList2;
                this.origSpan = (NetCircuitSpan)this.bridge.getOrigSpans().get(1);
            } else if (n3 > n) {
                this.shortestPaths = linkedList2;
                this.longestPaths = linkedList;
                this.origSpan = (NetCircuitSpan)this.bridge.getOrigSpans().get(0);
            } else if (this.bridge.getWorkingSpans().contains(netCircuitSpan3)) {
                this.shortestPaths = linkedList;
                this.longestPaths = linkedList2;
                this.origSpan = (NetCircuitSpan)this.bridge.getOrigSpans().get(1);
            } else {
                this.shortestPaths = linkedList2;
                this.longestPaths = linkedList;
                this.origSpan = (NetCircuitSpan)this.bridge.getOrigSpans().get(0);
            }
        } else {
            Iterator iterator = this.bridge.getOrigSpans().iterator();
            LinkedList<NetCircuitSpan> linkedList6 = new LinkedList<NetCircuitSpan>();
            while (iterator.hasNext()) {
                netCircuitSpan = (NetCircuitSpan)iterator.next();
                if (!UpsrCircuitPaths.belongTo(list2, netCircuitSpan.getLink(), netCircuitSpan.getSrcHoNum(), netCircuitSpan.getDstHoNum())) continue;
                linkedList6.add(netCircuitSpan);
            }
            netCircuitSpan3 = (NetCircuitSpan)linkedList6.get(0);
            netCircuitSpan2 = (NetCircuitSpan)linkedList6.get(1);
            n = 0;
            int n4 = 0;
            int n5 = 0;
            netCircuitSpan = netCircuitSpan3;
            for (netCircuitNode = this.bridge.spanGetPeer(netCircuitSpan); netCircuitNode != null && netCircuitNode != this.bridge; netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan)) {
                if (netCircuitSpan.getLink().isLOTunnel()) {
                    n5 = (short)(n5 + netCircuitSpan.getLink().getNodesList().size());
                    n5 = (short)(n5 - 2);
                }
                if (netCircuitNode.isUpsrSelector()) {
                    if (!linkedList3.isEmpty()) {
                        linkedList.addAll(linkedList3);
                        n = (short)(n + linkedList3.size());
                        linkedList3.clear();
                    }
                    linkedList.add(netCircuitNode);
                    n = (short)(n + 1);
                    n = (short)(n + n5);
                    n5 = 0;
                } else {
                    linkedList3.add(netCircuitNode);
                }
                netCircuitSpan = this.findAlternateSpan(netCircuitNode, netCircuitSpan, list2);
            }
            netCircuitSpan = netCircuitSpan2;
            linkedList3.clear();
            n5 = 0;
            for (netCircuitNode = this.bridge.spanGetPeer(netCircuitSpan); netCircuitNode != null && netCircuitNode != this.bridge; netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan)) {
                if (netCircuitSpan.getLink().isLOTunnel()) {
                    n5 = (short)(n5 + netCircuitSpan.getLink().getNodesList().size());
                    n5 = (short)(n5 - 2);
                }
                if (netCircuitNode.isUpsrSelector()) {
                    if (!linkedList3.isEmpty()) {
                        linkedList2.addAll(linkedList3);
                        n4 = (short)(n4 + linkedList3.size());
                        linkedList3.clear();
                    }
                    linkedList2.add(netCircuitNode);
                    n4 = (short)(n4 + 1);
                    n4 = (short)(n4 + n5);
                    n5 = 0;
                } else {
                    linkedList3.add(netCircuitNode);
                }
                netCircuitSpan = this.findAlternateSpan(netCircuitNode, netCircuitSpan, list2);
            }
            if (n < n4) {
                this.shortestPaths = linkedList;
                linkedList3.clear();
                while (!linkedList2.isEmpty()) {
                    netCircuitNode = (NetCircuitNode)linkedList2.remove(0);
                    if (netCircuitNode.isUpsrSelector()) {
                        linkedList3.add(netCircuitNode);
                        break;
                    }
                    linkedList3.add(netCircuitNode);
                }
                this.longestPaths = linkedList3;
                this.origSpan = (NetCircuitSpan)linkedList6.get(1);
            } else if (n > n4) {
                this.shortestPaths = linkedList2;
                linkedList3.clear();
                while (!linkedList.isEmpty()) {
                    netCircuitNode = (NetCircuitNode)linkedList.remove(0);
                    if (netCircuitNode.isUpsrSelector()) {
                        linkedList3.add(netCircuitNode);
                        break;
                    }
                    linkedList3.add(netCircuitNode);
                }
                this.longestPaths = linkedList3;
                this.origSpan = (NetCircuitSpan)linkedList6.get(0);
            } else {
                linkedList3.clear();
                LinkedList linkedList7 = new LinkedList();
                this.shortestPaths = linkedList;
                linkedList7 = linkedList2;
                while (!linkedList7.isEmpty()) {
                    netCircuitNode = (NetCircuitNode)linkedList7.remove(0);
                    if (netCircuitNode.isUpsrSelector()) {
                        linkedList3.add(netCircuitNode);
                        break;
                    }
                    linkedList3.add(netCircuitNode);
                }
                this.longestPaths = linkedList3;
                this.origSpan = (NetCircuitSpan)linkedList6.get(1);
            }
        }
        netCircuitSpan = this.origSpan;
        for (netCircuitNode = this.bridge.spanGetPeer(netCircuitSpan); netCircuitNode != null && !netCircuitNode.isUpsrSelector(); netCircuitNode = netCircuitNode.spanGetPeer(netCircuitSpan)) {
            netCircuitSpan = this.findAlternateSpan(netCircuitNode, netCircuitSpan, list2);
        }
        this.termSpan = netCircuitSpan;
    }

    private NetCircuitSpan findAlternateSpan(NetCircuitNode netCircuitNode, NetCircuitSpan netCircuitSpan, List list) {
        for (NetCircuitSpan netCircuitSpan2 : netCircuitNode.getAllSpansList()) {
            if (netCircuitSpan2 == netCircuitSpan || !UpsrCircuitPaths.belongTo(list, netCircuitSpan2.getLink(), netCircuitSpan2.getSrcHoNum(), netCircuitSpan2.getDstHoNum())) continue;
            return netCircuitSpan2;
        }
        return null;
    }
}

