/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AllocFailed;
import cerent.cms.model.Busy;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.IIpAddr;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitEnd;
import cerent.cms.model.IOhCircuitInfo;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhIpTunnelTerm;
import cerent.cms.model.IOhIpTunnelTermModel;
import cerent.cms.model.InvalidOhTerm;
import cerent.cms.model.InvalidOhXcon;
import cerent.cms.model.IpTunnelCircuitInfo;
import cerent.cms.model.OhChannel;
import cerent.cms.model.OhChannelType;
import cerent.cms.model.OhCircuitEnd;
import cerent.cms.model.OhCircuitType;
import cerent.cms.model.OhIpTunnelTerm;
import cerent.cms.model.OhMaxConnections;
import cerent.cms.model.OhTerm;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.ResourceInUse;
import cerent.cms.ncp.CircuitProvError;
import cerent.cms.ncp.IncorrectCircuitState;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhConnectionModelComparator;
import cerent.cms.ocm.OhNetCircuitEnd;
import cerent.cms.route.NoRoute;
import cerent.util.AnnotatedException;
import cerent.util.InetUtil;
import cerent.util.SDebug;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observer;
import java.util.Set;
import java.util.TreeSet;

public class IpEncapsulatedTunnel
extends OhCircuit {
    public static final int DEFAULT_MAX_BANDWIDTH = 100;
    public static final int DEFAULT_MIN_BANDWIDTH = 10;
    private static final SDebug db = new SDebug("IpEncapsulatedTunnel");
    private IIpAddr srcIp;
    private IIpAddr dstIp;
    private int maxBwPercent;

    public IpEncapsulatedTunnel(IOhCircuitInfo iOhCircuitInfo) throws AnnotatedException {
        super(iOhCircuitInfo);
    }

    @Override
    protected void buildCircuit(IOhCircuitInfo iOhCircuitInfo) throws NoRoute, CircuitProvError, InvalidOhTerm, InvalidOhXcon, AllocFailed, IncorrectCircuitState, Busy, OhMaxConnections, ResourceInUse, ProvisionError {
        this.maxBwPercent = ((IpTunnelCircuitInfo)iOhCircuitInfo).getMaxBwPercent();
        this.createOhCircuitInfoIfce(iOhCircuitInfo);
        this.createIpTerminations(iOhCircuitInfo.getSrcPoint(), iOhCircuitInfo.getDestPoints()[0], iOhCircuitInfo.getCircuitType());
    }

    public IpEncapsulatedTunnel(IOhConnectionModel iOhConnectionModel) {
        super(iOhConnectionModel);
    }

    public IpEncapsulatedTunnel(IOhCircuitModel iOhCircuitModel) {
        super(iOhCircuitModel);
    }

    protected void createIpTerminations(IOhCircuitEnd iOhCircuitEnd, IOhCircuitEnd iOhCircuitEnd2, int n) throws InvalidOhTerm, Busy, OhMaxConnections, ResourceInUse, ProvisionError {
        ArrayList<IOhIpTunnelTermModel> arrayList = new ArrayList<IOhIpTunnelTermModel>();
        OhCircuitType ohCircuitType = OhCircuitType.getOhCktTypeObj((int)n);
        INodeModel iNodeModel = net.getNodeModel(iOhCircuitEnd.getNodeId());
        INodeModel iNodeModel2 = net.getNodeModel(iOhCircuitEnd2.getNodeId());
        if (iNodeModel == null) {
            if (this.dbgOn()) {
                db.warning("Can't find the node model for node - " + iOhCircuitEnd.getNodeId());
            }
            return;
        }
        if (iNodeModel2 == null) {
            if (this.dbgOn()) {
                db.warning("Can't find the node model for node - " + iOhCircuitEnd2.getNodeId());
            }
            return;
        }
        this.srcIp = iNodeModel.getIpConfig().getIpAddress();
        this.dstIp = iNodeModel2.getIpConfig().getIpAddress();
        OhCircuitEnd ohCircuitEnd = (OhCircuitEnd)iOhCircuitEnd;
        OhCircuitEnd ohCircuitEnd2 = (OhCircuitEnd)iOhCircuitEnd2;
        int n2 = ohCircuitType.getCorrespondingChannelType().getIndex();
        OhTerm ohTerm = new OhTerm(new OhChannel(ohCircuitEnd.getPort(), n2), ohCircuitEnd.getPort());
        OhTerm ohTerm2 = new OhTerm(new OhChannel(ohCircuitEnd2.getPort(), n2), ohCircuitEnd2.getPort());
        int n3 = ohCircuitEnd.getPort();
        int n4 = ohCircuitEnd2.getPort();
        OhIpTunnelTerm ohIpTunnelTerm = new OhIpTunnelTerm(ohTerm, n4, this.srcIp, this.dstIp, this.maxBwPercent);
        OhIpTunnelTerm ohIpTunnelTerm2 = new OhIpTunnelTerm(ohTerm2, n3, this.dstIp, this.srcIp, this.maxBwPercent);
        IOhConnectionModels iOhConnectionModels = iNodeModel.getOhConnectionModels();
        IOhConnectionModels iOhConnectionModels2 = iNodeModel2.getOhConnectionModels();
        IOhIpTunnelTermModel iOhIpTunnelTermModel = null;
        IOhIpTunnelTermModel iOhIpTunnelTermModel2 = null;
        try {
            iOhIpTunnelTermModel = iOhConnectionModels.createOhIpTunnelTerm(this.getCircuitId(), (IOhIpTunnelTerm)ohIpTunnelTerm);
            arrayList.add(iOhIpTunnelTermModel);
            this.addConnection((IOhConnectionModel)iOhIpTunnelTermModel);
            iOhIpTunnelTermModel2 = iOhConnectionModels2.createOhIpTunnelTerm(this.getCircuitId(), (IOhIpTunnelTerm)ohIpTunnelTerm2);
            arrayList.add(iOhIpTunnelTermModel2);
            this.addConnection((IOhConnectionModel)iOhIpTunnelTermModel2);
        }
        catch (InvalidOhTerm invalidOhTerm) {
            this.destroyConnections(arrayList);
            if (db.on()) {
                db.println("Invalid Oh Term");
                SDebug.printStackTrace((Throwable)invalidOhTerm);
            }
            throw invalidOhTerm;
        }
        catch (Busy busy) {
            this.destroyConnections(arrayList);
            if (db.on()) {
                db.println("Busy");
            }
            throw busy;
        }
        catch (ResourceInUse resourceInUse) {
            this.destroyConnections(arrayList);
            if (db.on()) {
                db.println("Resource in Use");
            }
            throw resourceInUse;
        }
        catch (OhMaxConnections ohMaxConnections) {
            this.destroyConnections(arrayList);
            if (db.on()) {
                db.println("Max connections");
            }
            throw ohMaxConnections;
        }
        catch (ProvisionError provisionError) {
            this.destroyConnections(arrayList);
            if (db.on()) {
                db.println("Provision error");
            }
            throw provisionError;
        }
        finally {
            this.completeCheck();
            this.circuitChanged();
        }
    }

    @Override
    protected boolean addConnection(IOhConnectionModel iOhConnectionModel) {
        INodeModel iNodeModel;
        if (this.dbgOn()) {
            db.fine("addConnection entry");
        }
        if ((iNodeModel = iOhConnectionModel.getNodeModel()) == null) {
            if (this.dbgOn()) {
                db.warning("NodeModel for a connection is null -- in 'addConnection' of 'OhCircuit'.");
            }
            return false;
        }
        Integer n = new Integer(iNodeModel.getNodeId());
        Set<IOhConnectionModel> set = (Set<IOhConnectionModel>)this.connModelMap.get(n);
        if (set == null) {
            set = Collections.synchronizedSet(new TreeSet(new OhConnectionModelComparator()));
            if (this.dbgOn()) {
                db.fine("Add nodeId " + Integer.toHexString(n) + " with modelSet " + set + " into connModelMap");
            }
            this.connModelMap.put(n, set);
        }
        if (set.contains(iOhConnectionModel)) {
            return false;
        }
        if (set.size() > 0) {
            throw new IllegalStateException("Only orderwire circuits can have two connections on one node.");
        }
        if (this.dbgOn()) {
            db.fine("Add conn " + iOhConnectionModel + " into modelSet " + set);
        }
        set.add(iOhConnectionModel);
        iOhConnectionModel.addObserver((Observer)this);
        this.maxBwPercent = ((IOhIpTunnelTermModel)iOhConnectionModel).getMaxBwPercent();
        return true;
    }

    public OhChannelType getChannelType() {
        return OhChannelType.getOhChannelTypeObj((int)9);
    }

    protected synchronized boolean repairTunnel(INodeModel iNodeModel, String string, String string2) throws CircuitProvError {
        boolean bl = false;
        if (this.dbgOn()) {
            db.fine("Repairing Circuit: " + this.getCircuitName());
        }
        INodeModel iNodeModel2 = this.getSource().getNodeModel();
        INodeModel iNodeModel3 = this.getFirstDestination().getNodeModel();
        IIpAddr iIpAddr = InetUtil.makeIpAddr(string2);
        IIpAddr iIpAddr2 = InetUtil.makeIpAddr(string);
        if (iNodeModel.getNodeId() == iNodeModel2.getNodeId()) {
            bl = this.setNewIp(iNodeModel2, iNodeModel3, iIpAddr2, iIpAddr);
            if (db.on()) {
                db.println("Source node Ip change successful\noldIp: " + iIpAddr2 + "newIp" + iIpAddr);
            }
        } else if (iNodeModel.getNodeId() == iNodeModel3.getNodeId()) {
            bl = this.setNewIp(iNodeModel3, iNodeModel2, iIpAddr2, iIpAddr);
            if (db.on()) {
                db.println("Dest node Ip change successful\noldIp: " + iIpAddr2 + "newIp" + iIpAddr);
            }
        } else {
            return true;
        }
        if (bl) {
            this.completeCheck();
            this.circuitChanged();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean setNewIp(INodeModel iNodeModel, INodeModel iNodeModel2, IIpAddr iIpAddr, IIpAddr iIpAddr2) {
        if (iNodeModel == null) {
            if (db.on()) {
                db.println("srcNode is null");
            }
            return false;
        }
        if (iNodeModel2 == null) {
            if (db.on()) {
                db.println("srcNode is null");
            }
            return false;
        }
        List list = this.getConnections();
        if (list == null) {
            return false;
        }
        boolean bl = false;
        List list2 = list;
        synchronized (list2) {
            for (IOhIpTunnelTermModel iOhIpTunnelTermModel : list) {
                IIpAddr iIpAddr3;
                int n = iOhIpTunnelTermModel.getNodeModel().getNodeId();
                IOhIpTunnelTerm iOhIpTunnelTerm = iOhIpTunnelTermModel.getOhIpTunnelTerm();
                if (n == iNodeModel.getNodeId()) {
                    iIpAddr3 = iOhIpTunnelTerm.getSrcNodeIP();
                    if (iIpAddr3 == iIpAddr) {
                        iOhIpTunnelTerm.setSrcNodeIP(iIpAddr2);
                        iOhIpTunnelTermModel.setIpTunnelTerm(iOhIpTunnelTerm);
                        bl = true;
                        continue;
                    }
                    if (iIpAddr3 != iIpAddr2) {
                        iOhIpTunnelTerm.setSrcNodeIP(iIpAddr2);
                        iOhIpTunnelTermModel.setIpTunnelTerm(iOhIpTunnelTerm);
                        continue;
                    }
                    bl = true;
                    continue;
                }
                if (n != iNodeModel2.getNodeId()) continue;
                iIpAddr3 = iOhIpTunnelTerm.getDstNodeIP();
                if (iIpAddr3 == iIpAddr) {
                    iOhIpTunnelTerm.setDstNodeIP(iIpAddr2);
                    iOhIpTunnelTermModel.setIpTunnelTerm(iOhIpTunnelTerm);
                    bl = true;
                    continue;
                }
                if (iIpAddr3 != iIpAddr2) {
                    iOhIpTunnelTerm.setDstNodeIP(iIpAddr2);
                    iOhIpTunnelTermModel.setIpTunnelTerm(iOhIpTunnelTerm);
                    bl = true;
                    continue;
                }
                bl = true;
            }
        }
        return bl;
    }

    public IIpAddr getSrcIpAddress() {
        return this.srcIp;
    }

    public IIpAddr getDstIpAddress() {
        return this.dstIp;
    }

    public int getMaxBwPercent() {
        return this.maxBwPercent;
    }

    public void setMaxBwPercent(int n) {
        if (this.maxBwPercent != n) {
            this.maxBwPercent = n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateMaxBwPercent(int n) {
        List list = this.getConnections();
        boolean bl = false;
        if (list == null) {
            return bl;
        }
        if (db.on()) {
            db.println("setting bw: " + n);
        }
        List list2 = list;
        synchronized (list2) {
            for (IOhIpTunnelTermModel iOhIpTunnelTermModel : list) {
                IOhIpTunnelTerm iOhIpTunnelTerm = iOhIpTunnelTermModel.getOhIpTunnelTerm();
                iOhIpTunnelTerm.setMaxBwPercent(n);
                iOhIpTunnelTermModel.setIpTunnelTerm(iOhIpTunnelTerm);
                bl = true;
            }
        }
        return bl;
    }

    @Override
    protected void handleCircuitChange(IOhConnectionModel iOhConnectionModel) {
        ICircuitId iCircuitId = iOhConnectionModel.getCircuitId();
        if (!iCircuitId.equals(this.getCircuitId())) {
            super.handleCircuitChange(iOhConnectionModel);
        } else {
            IOhIpTunnelTermModel iOhIpTunnelTermModel = (IOhIpTunnelTermModel)iOhConnectionModel;
            IOhIpTunnelTerm iOhIpTunnelTerm = iOhIpTunnelTermModel.getOhIpTunnelTerm();
            if (this.circuitModel != null) {
                IOhCircuitEnd iOhCircuitEnd = this.circuitModel.getSrcPoint();
                INodeModel iNodeModel = net.getNodeModel(iOhCircuitEnd.getNodeId());
                INodeModel iNodeModel2 = iOhIpTunnelTermModel.getNodeModel();
                this.maxBwPercent = iOhIpTunnelTerm.getMaxBwPercent();
                if (iNodeModel2.equals(iNodeModel)) {
                    this.srcIp = iOhIpTunnelTerm.getSrcNodeIP();
                    this.dstIp = iOhIpTunnelTerm.getDstNodeIP();
                } else {
                    this.srcIp = iOhIpTunnelTerm.getDstNodeIP();
                    this.dstIp = iOhIpTunnelTerm.getSrcNodeIP();
                }
            } else if (db.on()) {
                db.println("CircuitModel null for the circuit");
            }
        }
        if (db.on()) {
            db.println("update - srcIp : " + this.srcIp + "dstIp: " + this.dstIp + "maxBw: " + this.maxBwPercent);
        }
    }

    @Override
    protected synchronized void completeCheck() {
        if (this.dbgOn()) {
            db.fine("Performing complete check for circuit. ");
        }
        if (!this.circuitInfoActive()) {
            if (this.dbgOn()) {
                db.warning("Circuit Info is not active");
            }
            return;
        }
        if (!this.isComplete() && this.foundAllConns() && this.checkIpMatch()) {
            this.setState(1);
        }
    }

    protected boolean foundAllConns() {
        if (!this.circuitInfoActive()) {
            return false;
        }
        OhNetCircuitEnd ohNetCircuitEnd = this.getSource();
        OhNetCircuitEnd ohNetCircuitEnd2 = this.getFirstDestination();
        List list = this.findConnections(ohNetCircuitEnd.getNodeId(), ohNetCircuitEnd.getPort());
        List list2 = this.findConnections(ohNetCircuitEnd2.getNodeId(), ohNetCircuitEnd2.getPort());
        return list.size() != 0 && list2.size() != 0;
    }

    protected boolean checkIpMatch() {
        IIpAddr iIpAddr;
        IIpAddr iIpAddr2;
        OhNetCircuitEnd ohNetCircuitEnd = this.getSource();
        OhNetCircuitEnd ohNetCircuitEnd2 = this.getFirstDestination();
        IIpAddr iIpAddr3 = null;
        IIpAddr iIpAddr4 = null;
        if (ohNetCircuitEnd != null) {
            INodeModel iNodeModel = ohNetCircuitEnd.getNodeModel();
            if (iNodeModel != null) {
                iIpAddr3 = iNodeModel.getIpConfig().getIpAddress();
            }
        } else {
            return false;
        }
        if (ohNetCircuitEnd2 != null) {
            INodeModel iNodeModel = ohNetCircuitEnd2.getNodeModel();
            if (iNodeModel != null) {
                iIpAddr4 = iNodeModel.getIpConfig().getIpAddress();
            }
        } else {
            return false;
        }
        List list = this.findConnections(ohNetCircuitEnd.getNodeId(), ohNetCircuitEnd.getPort());
        List list2 = this.findConnections(ohNetCircuitEnd2.getNodeId(), ohNetCircuitEnd2.getPort());
        boolean bl = false;
        boolean bl2 = false;
        for (Object object : list) {
            IOhIpTunnelTermModel iOhIpTunnelTermModel = (IOhIpTunnelTermModel)object;
            iIpAddr2 = iOhIpTunnelTermModel.getSrcIp();
            iIpAddr = iOhIpTunnelTermModel.getDstIp();
            if (iIpAddr3 == null || iIpAddr4 == null || iIpAddr2.compareTo((Object)iIpAddr3) != 0 || iIpAddr.compareTo((Object)iIpAddr4) != 0) continue;
            bl = true;
        }
        for (Object object : list2) {
            iIpAddr2 = object.getSrcIp();
            iIpAddr = object.getDstIp();
            if (iIpAddr4 == null || iIpAddr3 == null || iIpAddr2.compareTo((Object)iIpAddr4) != 0 || iIpAddr.compareTo((Object)iIpAddr3) != 0) continue;
            bl2 = true;
        }
        return bl && bl2;
    }
}

