/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ocm;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.Feature;
import cerent.cms.model.ICircuitId;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOhCircuitFactoryModel;
import cerent.cms.model.IOhCircuitModel;
import cerent.cms.model.IOhConnectionModel;
import cerent.cms.model.IOhConnectionModels;
import cerent.cms.model.IOhIpTunnelTermModel;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.IOhXconModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NodeModel;
import cerent.cms.ocm.OhCircuit;
import cerent.cms.ocm.OhCircuitManager;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElemComparator;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.SDebug;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Observable;
import java.util.Observer;
import java.util.SortedSet;
import java.util.TreeSet;

public class OhCircuitWatchDog
implements Observer {
    private static final SDebug db = new SDebug("OhCircuitWatchDog");
    private static OhCircuitWatchDog watchDog;
    private SortedSet cktInfoNodes = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));
    private SortedSet connNodes = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));
    private List updatedCircuits = new LinkedList();
    private boolean updateCircuitNameMaps = false;
    private SortedSet unprocessedCktNameMapNodes = Collections.synchronizedSortedSet(new TreeSet(new NetElemComparator()));

    private OhCircuitWatchDog() {
        Thread thread = new Thread("OhCircuitWatchDog"){

            @Override
            public void run() {
                while (true) {
                    try {
                        while (true) {
                            1.sleep(5000L);
                            OhCircuitWatchDog.this.generateCallbacks();
                        }
                    }
                    catch (Exception exception) {
                        db.warning("Circuit Watch dog thread hit exception");
                        db;
                        SDebug.printStackTrace((Throwable)exception);
                        continue;
                    }
                    break;
                }
            }
        };
        thread.setName("CMS CircuitWatchdog");
        thread.start();
    }

    public static synchronized OhCircuitWatchDog instance() {
        if (watchDog == null) {
            if (OhCircuitWatchDog.dbgOn()) {
                db.finer("Creating a Circuit WatchDog");
            }
            watchDog = new OhCircuitWatchDog();
        }
        return watchDog;
    }

    public void newNetElement(INetElement iNetElement) {
        if (iNetElement != null) {
            this.cktInfoNodes.add(iNetElement);
        }
    }

    protected void reloadConnections(INetElement iNetElement) {
        if (iNetElement != null) {
            this.connNodes.add(iNetElement);
        }
    }

    protected void reloadCircuitInfos(INetElement iNetElement) {
        if (iNetElement != null) {
            this.cktInfoNodes.add(iNetElement);
        }
    }

    protected void queueCircuitNameMapUpdate() {
        this.updateCircuitNameMaps = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void queueCircuitUpdate(OhCircuit ohCircuit) {
        List list = this.updatedCircuits;
        synchronized (list) {
            if (ohCircuit != null && !ohCircuit.updateEventQueued) {
                this.updatedCircuits.add(ohCircuit);
                ohCircuit.updateEventQueued = true;
            }
        }
    }

    public void newNetLink(INetLink iNetLink) {
        OhCircuitManager.instance().newNetLink(iNetLink);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCallbacks() {
        Iterator iterator;
        ICircuitId iCircuitId;
        INodeModel iNodeModel;
        OhCircuit ohCircuit;
        IOhCircuitModel[] iOhCircuitModelArray;
        NetElement netElement = null;
        OhCircuitManager ohCircuitManager = OhCircuitManager.instance();
        LinkedList<NetElement> linkedList = new LinkedList<NetElement>();
        if (ohCircuitManager == null) {
            if (OhCircuitWatchDog.dbgOn()) {
                db.finer("circuit manager is not yet instantiated- returning");
            }
            return;
        }
        while (true) {
            iOhCircuitModelArray = this.updatedCircuits;
            synchronized (iOhCircuitModelArray) {
                if (this.updatedCircuits.size() == 0) {
                    break;
                }
                ohCircuit = (OhCircuit)this.updatedCircuits.remove(0);
                ohCircuit.updateEventQueued = false;
            }
            ohCircuit.runUpdate();
        }
        while (this.cktInfoNodes.size() != 0) {
            try {
                try {
                    iOhCircuitModelArray = this.cktInfoNodes;
                    synchronized (iOhCircuitModelArray) {
                        netElement = (NetElement)this.cktInfoNodes.first();
                        this.cktInfoNodes.remove(netElement);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!OhCircuitWatchDog.dbgOn()) break;
                    db.warning("Somehow the cktInfoNodes list became empty!");
                    break;
                }
                if (netElement == null) {
                    if (!OhCircuitWatchDog.dbgOn()) continue;
                    db.fine("NetElement is null!");
                    continue;
                }
                iNodeModel = netElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!OhCircuitWatchDog.dbgOn()) continue;
                    db.fine(netElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (OhCircuitWatchDog.dbgOn()) {
                        db.fine(netElement.getName() + ": node not initialized");
                        db.finer("putting back in queue");
                    }
                    linkedList.add(netElement);
                    continue;
                }
                if (!iNodeModel.provides(Feature.AICI)) {
                    iNodeModel.getConnectionNotifier().addObserver((Observer)this);
                    continue;
                }
                IOhCircuitFactoryModel iOhCircuitFactoryModel = iNodeModel.getOhCircuitFactoryModel();
                iOhCircuitModelArray = iOhCircuitFactoryModel.getOhCircuits();
                if (OhCircuitWatchDog.dbgOn()) {
                    db.fine("Received " + iOhCircuitModelArray.length + " overhead circuit(s) from " + netElement.getName());
                }
                for (int i = 0; i < iOhCircuitModelArray.length; ++i) {
                    try {
                        iCircuitId = iOhCircuitModelArray[i].getId();
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (!OhCircuitWatchDog.dbgOn()) continue;
                        db.warning("Couldn't get circuit Id");
                        continue;
                    }
                    ohCircuit = ohCircuitManager.getCircuitFromId(iCircuitId);
                    try {
                        if (ohCircuit != null) {
                            ohCircuit.addDiscoveredCircuitInfo(iOhCircuitModelArray[i]);
                            continue;
                        }
                        ohCircuit = ohCircuitManager.newCircuitFromCircuitInfo(iOhCircuitModelArray[i]);
                        continue;
                    }
                    catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                        if (!OhCircuitWatchDog.dbgOn()) continue;
                        db.fine("Discovered circuitInfo does not exist.");
                    }
                }
                if (iOhCircuitModelArray.length != 0 && OhCircuitWatchDog.dbgOn()) {
                    db.fine("=================================================");
                    db.fine("Done processing overhead circuits from " + netElement.getName());
                    db.fine("=================================================");
                }
                this.connNodes.add(netElement);
                iOhCircuitFactoryModel.addObserver((Observer)this);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (OhCircuitWatchDog.dbgOn()) {
                    db.warning(abstractCmsIOException.toString() + " exception at node " + (netElement != null ? netElement.getName() : "UNKNOWN") + ", will try after 6 seconds");
                }
                if (netElement == null) continue;
                linkedList.add(netElement);
            }
        }
        if (linkedList.size() != 0) {
            this.cktInfoNodes.addAll(linkedList);
        }
        iOhCircuitModelArray = new LinkedList();
        LinkedList<NetElement> linkedList2 = new LinkedList<NetElement>();
        while (this.connNodes.size() != 0) {
            try {
                try {
                    Object object = this.connNodes;
                    synchronized (object) {
                        netElement = (NetElement)this.connNodes.first();
                        this.connNodes.remove(netElement);
                    }
                }
                catch (NoSuchElementException noSuchElementException) {
                    if (!OhCircuitWatchDog.dbgOn()) break;
                    db.warning("Somehow the connNodes list became empty!");
                    break;
                }
                if (netElement == null) {
                    if (!OhCircuitWatchDog.dbgOn()) continue;
                    db.warning("NetElement is null!");
                    continue;
                }
                iNodeModel = netElement.getNodeModel();
                if (iNodeModel == null) {
                    if (!OhCircuitWatchDog.dbgOn()) continue;
                    db.warning(netElement.getName() + "NodeModel is null!");
                    continue;
                }
                if (!iNodeModel.isInited()) {
                    if (OhCircuitWatchDog.dbgOn()) {
                        db.fine(netElement.getName() + ": node not initialized");
                        db.finer("putting back in queue");
                    }
                    linkedList2.add(netElement);
                    continue;
                }
                if (!iNodeModel.provides(Feature.AICI)) continue;
                int n = netElement.getNodeId();
                IOhConnectionModels iOhConnectionModels = iNodeModel.getOhConnectionModels();
                List<IOhTermModel> list = Arrays.asList(iOhConnectionModels.getOhTermModels());
                List<IOhXconModel> list2 = Arrays.asList(iOhConnectionModels.getOhXconModels());
                iOhCircuitModelArray.add(list);
                iOhCircuitModelArray.add(list2);
                if (iNodeModel.provides(Feature.ENHANCED_DCC)) {
                    List<IOhIpTunnelTermModel> list3 = Arrays.asList(iOhConnectionModels.getOhIpTunnelTermModels());
                    iOhCircuitModelArray.add(list3);
                }
                if (OhCircuitWatchDog.dbgOn()) {
                    db.fine("Got " + list.size() + " Overhead Terms & " + list2.size() + " Overhead Xcons from " + netElement.getName());
                }
                for (List list4 : iOhCircuitModelArray) {
                    for (IOhConnectionModel iOhConnectionModel : list4) {
                        int n2;
                        if (OhCircuitWatchDog.dbgOn()) {
                            db.fine("Handle connection " + iOhConnectionModel);
                        }
                        if (iOhConnectionModel instanceof IOhTermModel && (((IOhTermModel)iOhConnectionModel).getChannelType() == 0 || ((IOhTermModel)iOhConnectionModel).getChannelType() == 4 || ((IOhTermModel)iOhConnectionModel).getChannelType() == 10 || ((IOhTermModel)iOhConnectionModel).getChannelType() == 11)) continue;
                        try {
                            iCircuitId = iOhConnectionModel.getCircuitId();
                        }
                        catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                            continue;
                        }
                        if (iCircuitId.getUniquePart().getUniqueId() == 0 && OhCircuitWatchDog.dbgOn()) {
                            db.warning("Connection with null connection Id");
                        }
                        ohCircuit = ohCircuitManager.getCircuitFromId(iCircuitId);
                        if (OhCircuitWatchDog.dbgOn()) {
                            db.fine("Processing connection for circuit Id " + OhCircuit.prettyString(iCircuitId));
                        }
                        if ((n2 = ohCircuit != null ? ohCircuit.getCircuitType() : iOhConnectionModel.getCircuitType()) == 6 && !(iOhConnectionModel instanceof IOhIpTunnelTermModel)) continue;
                        if (ohCircuit != null) {
                            OhCircuit ohCircuit2 = ohCircuit;
                            synchronized (ohCircuit2) {
                                if (!ohCircuit.isCircuitRefValid()) {
                                    if (OhCircuitWatchDog.dbgOn()) {
                                        db.finer("Circuit got destroyed");
                                    }
                                    continue;
                                }
                                if (OhCircuitWatchDog.dbgOn()) {
                                    db.fine("Adding connection to circuit ");
                                }
                                ohCircuit.addDiscoveredConnection(iOhConnectionModel);
                                continue;
                            }
                        }
                        if (OhCircuitWatchDog.dbgOn()) {
                            db.fine("Creating new circuit");
                        }
                        ohCircuitManager.newCircuitFromConn(iOhConnectionModel);
                    }
                }
                if (iOhCircuitModelArray.size() != 0 && OhCircuitWatchDog.dbgOn()) {
                    db.fine("=================================================");
                    db.fine("Done processing overhead connections from " + netElement.getName());
                    db.fine("=================================================");
                }
                iOhConnectionModels.addObserver((Observer)this);
                iOhCircuitModelArray.clear();
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (OhCircuitWatchDog.dbgOn()) {
                    db.warning(abstractCmsIOException.toString() + " exception at node " + (netElement != null ? netElement.getName() : "UNKNOWN") + ", will try connections after 6 seconds");
                }
                if (netElement == null) continue;
                linkedList2.add(netElement);
            }
        }
        if (linkedList2.size() != 0) {
            this.connNodes.addAll(linkedList2);
        }
        if (this.updateCircuitNameMaps) {
            this.updateCircuitNameMaps = false;
            iterator = Network.instance();
            for (Object object : ((Network)((Object)iterator)).getElements()) {
                iNodeModel = object.getNodeModel();
                if (iNodeModel.isInited() && (!iNodeModel.provides(Feature.AICI) || ohCircuitManager.setNodeCircuitNameMap(iNodeModel))) continue;
                this.unprocessedCktNameMapNodes.add(object);
            }
        }
        if (OhCircuitWatchDog.dbgOn() && this.unprocessedCktNameMapNodes.size() > 0) {
            db.fine("Updating circuit name map for " + this.unprocessedCktNameMapNodes.size() + " unprocessed elements");
        }
        iterator = this.unprocessedCktNameMapNodes.iterator();
        while (iterator.hasNext()) {
            NetElement netElement2 = (NetElement)iterator.next();
            if (netElement2.isDeleted()) {
                iterator.remove();
                continue;
            }
            if (!netElement2.isInited() || netElement2.getNodeModel().provides(Feature.AICI) && !ohCircuitManager.setNodeCircuitNameMap(netElement2.getNodeModel())) continue;
            iterator.remove();
        }
    }

    @Override
    public void update(Observable observable, Object object) {
        if (observable instanceof IOhConnectionModels) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                INetElement iNetElement;
                INodeModel iNodeModel = ((IOhConnectionModels)observable).getNodeModel();
                try {
                    Network network = Network.instance();
                    iNetElement = network.findNetElem(iNodeModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iNetElement = null;
                }
                if (iNetElement == null) {
                    if (OhCircuitWatchDog.dbgOn()) {
                        db.warning("Watchdog unable to find NetElem in update method");
                    }
                } else {
                    this.connNodes.add(iNetElement);
                    if (OhCircuitWatchDog.dbgOn()) {
                        db.fine("ConnectionModels changed at " + iNetElement.getName());
                    }
                }
            }
        } else if (observable instanceof IOhCircuitFactoryModel) {
            if (((Integer)object).equals(ModelUpdateType.ADDED)) {
                INetElement iNetElement;
                INodeModel iNodeModel = ((IOhCircuitFactoryModel)observable).getNodeModel();
                try {
                    Network network = Network.instance();
                    iNetElement = network.findNetElem(iNodeModel);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    iNetElement = null;
                }
                if (iNetElement != null) {
                    this.cktInfoNodes.add(iNetElement);
                    if (OhCircuitWatchDog.dbgOn()) {
                        db.fine("CktFactory changed at " + iNetElement.getName());
                    }
                }
            } else if (((Integer)object).equals(ModelUpdateType.DELETED)) {
                // empty if block
            }
        } else if (observable instanceof Network.NetElementCreationNotifier) {
            if (object instanceof NetElement) {
                NetElement netElement = (NetElement)object;
                if (OhCircuitWatchDog.dbgOn()) {
                    db.info("update: received notification about new NE " + netElement.getHostName());
                }
                if (netElement.getNodeId() == 0 || netElement.getNodeId() == -1) {
                    netElement.addObserver(this);
                } else {
                    this.newNetElement(netElement);
                }
            }
        } else if (observable instanceof Network.NetLinkCreationNotifier) {
            if (object instanceof INetLink) {
                INetLink iNetLink = (INetLink)object;
                if (OhCircuitWatchDog.dbgOn()) {
                    db.info("update: received notification about new NL " + iNetLink.prettyString());
                }
                this.newNetLink(iNetLink);
            }
        } else if (observable instanceof NetElement) {
            if (object == ModelUpdateType.CHANGED) {
                NetElement netElement = (NetElement)((Object)observable);
                if (OhCircuitWatchDog.dbgOn()) {
                    db.info("update: received CHANGED event from NE " + netElement.getHostName());
                }
                if (netElement.getNodeId() != 0 && netElement.getNodeId() != -1) {
                    if (OhCircuitWatchDog.dbgOn()) {
                        db.info("update: NE has valid node ID, adding new NE");
                    }
                    netElement.deleteObserver(this);
                    this.newNetElement(netElement);
                }
            }
        } else if (observable instanceof INodeModel.AbstractConnectionNotifier) {
            INodeModel.AbstractConnectionNotifier abstractConnectionNotifier = (INodeModel.AbstractConnectionNotifier)observable;
            if (object == ModelUpdateType.CHANGED) {
                if (db.on()) {
                    db.println("update: received Connection CHANGED event");
                }
                try {
                    Network network = Network.instance();
                    NodeModel nodeModel = ((NodeModel.ConnectionNotifier)abstractConnectionNotifier).getNodeModel();
                    this.newNetElement(network.findNetElem(nodeModel));
                    abstractConnectionNotifier.deleteObserver((Observer)this);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (db.on()) {
                        SDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
            } else if (object == ModelUpdateType.DELETED) {
                if (db.on()) {
                    db.println("update: received Connection DELETED event");
                }
                abstractConnectionNotifier.deleteObserver((Observer)this);
            }
        }
    }

    private static boolean dbgOn() {
        return db.on() || OhCircuitManager.pkgDbgOn();
    }
}

