/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.GranularityFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.ISrg;
import cerent.cms.route.PathFilterFactory;
import cerent.cms.route.PortSrg;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.VcatFilter;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.util.ILabel;
import cerent.util.LambdaLabel;
import java.util.Iterator;
import java.util.Set;

public class LambdaGranularityFilter
extends GranularityFilter {
    public LambdaGranularityFilter(RoutePrefs routePrefs, VcatFilter vcatFilter) {
        this.prefs = routePrefs;
        this.vcatFilter = vcatFilter;
        routePrefs.getLog().getDebugLog().info("LambdaGranularityFilter: Created");
        this.pathFilter = PathFilterFactory.create(routePrefs, this);
    }

    @Override
    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        if (sptLink.getLink() instanceof LmpDataLinkNetLink) {
            LmpDataLinkNetLink lmpDataLinkNetLink = (LmpDataLinkNetLink)sptLink.getLink();
            lmpDataLinkNetLink.isUsable(this.prefs, sptLink.getParentLink());
            sptLink.setLabelSets(lmpDataLinkNetLink.getSrcLabelSet(this.prefs.getCircuitSize(), this.prefs.getCircuitType()), lmpDataLinkNetLink.getDstLabelSet(this.prefs.getCircuitSize(), this.prefs.getCircuitType()), this.prefs);
        } else {
            this.isUsableGranularityCheck(sptLink);
            this.prefs.getLog().getDebugLog().info("LambdaGranularityFilter: isUsable");
            Set set = this.prefs.getActiveMember().getExcludeSrgs();
            Iterator iterator = set.iterator();
            INetLink iNetLink = sptLink.getLink();
            PortSrg portSrg = new PortSrg(iNetLink.getSrc(), iNetLink.getSrcEntityIndex(), iNetLink.getSrcShelfNumber(), iNetLink.getSrcSlotNumber(), iNetLink.getSrcPortNumber());
            PortSrg portSrg2 = new PortSrg(iNetLink.getDst(), iNetLink.getDstEntityIndex(), iNetLink.getDstShelfNumber(), iNetLink.getDstSlotNumber(), iNetLink.getDstPortNumber());
            while (iterator.hasNext()) {
                ISrg iSrg = (ISrg)iterator.next();
                if (!(iSrg instanceof PortSrg) || !((Object)portSrg).equals(iSrg) && !((Object)portSrg2).equals(iSrg)) continue;
                throw new xLinkNotUsable("Link is in Exclude SRG list");
            }
        }
        ILabelSet iLabelSet = sptLink.getSrcLabelSet();
        ILabelSet iLabelSet2 = sptLink.getDstLabelSet();
        iLabelSet.addLabel((ILabel)new LambdaLabel(this.prefs.getcktOptChannel()));
        iLabelSet2.addLabel((ILabel)new LambdaLabel(this.prefs.getcktOptChannel()));
        return true;
    }
}

