/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.CircuitSize;
import cerent.cms.route.DropPrefs;
import cerent.cms.route.MemberPrefs;
import cerent.cms.route.RouteLog;
import cerent.cms.topo.INetElement;

public class MemberGroupPrefs {
    private int memberBandwidth;
    private int numMembers;
    private DropPrefs dropPrefs;
    private MemberPrefs memberPrefs;

    public MemberGroupPrefs(DropPrefs dropPrefs) {
        this.dropPrefs = dropPrefs;
        this.memberBandwidth = 29;
        this.numMembers = 1;
        this.memberPrefs = new MemberPrefs(this);
    }

    public MemberGroupPrefs(MemberGroupPrefs memberGroupPrefs, DropPrefs dropPrefs) {
        this.dropPrefs = dropPrefs;
        this.memberBandwidth = memberGroupPrefs.memberBandwidth;
        this.numMembers = memberGroupPrefs.numMembers;
        this.memberPrefs = new MemberPrefs(memberGroupPrefs.memberPrefs, this);
    }

    public int getGranularity() {
        return 1;
    }

    public void setMemberBandwidth(int n) {
        this.memberBandwidth = n;
    }

    public int getMemberBandwidth() {
        return this.memberBandwidth;
    }

    public void setMemberCount(int n) {
        this.numMembers = n;
    }

    public int getMemberCount() {
        return this.numMembers;
    }

    public MemberPrefs getMemberPrefs() {
        return this.memberPrefs;
    }

    protected MemberPrefs getActiveMember() {
        return this.getMemberPrefs();
    }

    public RouteLog getLog() {
        return this.dropPrefs.getLog();
    }

    protected INetElement getSrc() {
        return this.dropPrefs.getSrc();
    }

    public String prettyString() {
        String string = "\n\t\tGroup Preferences: ";
        string = string + "\n\t\tNumber of members: " + this.getMemberCount();
        string = string + "\n\t\tEach Member Bandwidth: " + CircuitSize.getCircuitSize((int)this.getMemberBandwidth()).toString();
        string = string + this.getMemberPrefs().prettyString();
        return string;
    }

    public DropPrefs getDropPrefs() {
        return this.dropPrefs;
    }
}

