/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CircuitPath;
import cerent.cms.route.DropPath;
import cerent.cms.route.IGranularityFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.IPathFilter;
import cerent.cms.route.InvalidCircuitPath;
import cerent.cms.route.MemberPath;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.PathSegment;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.Spt;
import cerent.cms.route.SptCompositeNetLink;
import cerent.cms.route.SptLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.OchTrailTunnelNetLink;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.util.ILabel;
import java.util.LinkedList;

public class PathFilter
implements IPathFilter {
    protected RoutePrefs prefs;
    protected IGranularityFilter gFilter;

    public PathFilter(RoutePrefs routePrefs, IGranularityFilter iGranularityFilter) {
        this.prefs = routePrefs;
        this.gFilter = iGranularityFilter;
    }

    @Override
    public boolean isUsable(SptLink sptLink) throws xLinkNotUsable {
        if (sptLink.getLink().getLinksList().size() > 1 && !this.prefs.getTunnelsAllowed()) {
            throw new xLinkNotUsable("Path Filter: Tunnels are not allowed for this path computation");
        }
        if (!this.prefs.isOchncCircuit() && !this.prefs.isOchTrailTunnelCircuit() && sptLink.getLink() instanceof DwdmNetLink) {
            throw new xLinkNotUsable("DWDM Link can be used only for OCHNC/OchTrail circuits");
        }
        if (!(this.prefs.isOchTrailTunnelCircuit() || this.prefs.isOchccCircuit() || this.prefs.isOchncCircuit() || this.prefs.isSvlanCircuit() || !(sptLink.getLink() instanceof VirtualNetLink))) {
            throw new xLinkNotUsable("PPC Link can be used only for OCHCC/OchTrail/OCHNC/SVLAN circuits");
        }
        if (this.prefs.isOchccCircuit() && !(sptLink.getLink() instanceof VirtualNetLink) && !(sptLink.getLink() instanceof OchTrailTunnelNetLink)) {
            throw new xLinkNotUsable("OCHCC circuits can be supported only on PPC/OTT Links");
        }
        if (this.prefs.isSvlanCircuit() && !(sptLink.getLink() instanceof VirtualNetLink) && !(sptLink.getLink() instanceof OchTrailTunnelNetLink)) {
            throw new xLinkNotUsable("SVLAN circuits can be supported only on PPC/OTT Links");
        }
        if (!this.prefs.getPathOnly() && sptLink.getLink() instanceof OscNetLink) {
            throw new xLinkNotUsable("OSC Link can be used only for OverHead circuits");
        }
        return this.gFilter.isUsable(sptLink);
    }

    @Override
    public boolean isUsableByParent(SptLink sptLink) throws xLinkNotUsable {
        return true;
    }

    @Override
    public CircuitPath getCircuitPath() throws NoRoute {
        LinkedList linkedList = this.getPathLinks();
        return this.buildCircuitPath(linkedList);
    }

    protected CircuitPath buildCircuitPath(LinkedList linkedList) {
        CircuitPath circuitPath = new CircuitPath(this.prefs);
        DropPath dropPath = new DropPath(circuitPath);
        try {
            circuitPath.setDropPath(dropPath);
        }
        catch (InvalidCircuitPath invalidCircuitPath) {
            this.prefs.getLog().getDebugLog().info("Invalid Drop Path");
        }
        MemberPath[] memberPathArray = new MemberPath[this.prefs.getMemberCount()];
        for (int i = 0; i < this.prefs.getMemberCount(); ++i) {
            memberPathArray[i] = new MemberPath(dropPath);
            dropPath.addMemberPath(memberPathArray[i]);
            LinkedList linkedList2 = this.computeCircuitPathSegments(linkedList, i);
            memberPathArray[i].addPathSegments(linkedList2);
            memberPathArray[i].setMemberPrefs(this.prefs.getActiveDropPrefs().getActiveMemberGroupPrefs().getActiveMember());
        }
        this.prefs.getLog().getDebugLog().info(circuitPath.prettyString());
        return circuitPath;
    }

    protected LinkedList computeCircuitPathSegments(LinkedList linkedList, int n) {
        LinkedList<PathSegment> linkedList2 = new LinkedList<PathSegment>();
        PathSegment pathSegment = new PathSegment(this.prefs.getSrc(), this.prefs.getDst());
        LinkedList<Object> linkedList3 = new LinkedList<Object>();
        for (SptLink sptLink : linkedList) {
            Object object;
            ILabelSet iLabelSet = sptLink.getSrcLabelSet();
            ILabelSet iLabelSet2 = sptLink.getDstLabelSet();
            ILabel[] iLabelArray = iLabelSet.getLabels(this.prefs.getMemberCount());
            ILabel[] iLabelArray2 = iLabelSet2.getLabels(this.prefs.getMemberCount());
            INetLink iNetLink = sptLink.getLink();
            if (iNetLink.isTemporarySptLink()) {
                for (INetLink iNetLink2 : object = ((SptCompositeNetLink)iNetLink).getLinks()) {
                    NetLinkSpan netLinkSpan = new NetLinkSpan(iNetLink2, iNetLink2.getReverseLink(), iLabelArray[n], iLabelArray2[n]);
                    linkedList3.add(netLinkSpan);
                }
                iNetLink.dispose();
                continue;
            }
            object = new NetLinkSpan(iNetLink, iNetLink.getReverseLink(), iLabelArray[n], iLabelArray2[n]);
            linkedList3.add(object);
        }
        if (linkedList != null) {
            pathSegment.setPrimary(linkedList3);
            linkedList2.add(pathSegment);
        }
        return linkedList2;
    }

    @Override
    public LinkedList getPathLinks() throws NoRoute {
        Spt spt = new Spt(this.prefs, this);
        spt.computeRoute();
        return spt.getPathLinks();
    }

    @Override
    public INetElement[] getReachableNodes() {
        Spt spt = new Spt(this.prefs, this);
        return spt.computeReachableNodes();
    }
}

