/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.IMetric;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.topo.INetLink;

public class ProtectionMetric
implements IMetric {
    private RoutePrefs prefs;
    private int numFailurePoints;

    public ProtectionMetric(RoutePrefs routePrefs) {
        this.prefs = routePrefs;
        this.numFailurePoints = 0;
    }

    public int getNumFailurePoints() {
        return this.numFailurePoints;
    }

    @Override
    public void accumulate(IMetric iMetric, SptLink sptLink, RoutePrefs routePrefs) {
        ProtectionMetric protectionMetric = (ProtectionMetric)iMetric;
        int n = 0;
        INetLink iNetLink = sptLink.getParentLink();
        INetLink iNetLink2 = sptLink.getLink();
        for (INetLink iNetLink3 : iNetLink2.getLinksList()) {
            if (iNetLink != null && (iNetLink.terminatingInRing() || iNetLink3.originatingInRing()) && !iNetLink.terminatingRingName().equals(iNetLink3.originatingRingName())) {
                ++n;
            }
            iNetLink = iNetLink3;
        }
        this.numFailurePoints = protectionMetric.getNumFailurePoints() + n;
    }

    public int compareTo(Object object) {
        ProtectionMetric protectionMetric = (ProtectionMetric)object;
        return this.getNumFailurePoints() - protectionMetric.getNumFailurePoints();
    }

    @Override
    public boolean betterThan(Object object) {
        return this.compareTo(object) <= 0;
    }

    @Override
    public String prettyString() {
        String string = " PQM: " + this.getNumFailurePoints();
        return string;
    }
}

