/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.route.CircuitPath;
import cerent.cms.route.IEndProtectPathFilter;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.NetLinkSpan;
import cerent.cms.route.PathSegment;
import cerent.cms.route.ProtectedPathFilter;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptLink;
import cerent.cms.route.xNoAlternatePath;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.util.ILabel;
import java.util.Iterator;
import java.util.LinkedList;

public class SingleEndProtectPathFilter
implements IEndProtectPathFilter {
    RoutePrefs prefs;
    ProtectedPathFilter filter;

    public SingleEndProtectPathFilter(RoutePrefs routePrefs, ProtectedPathFilter protectedPathFilter) {
        this.prefs = routePrefs;
        this.filter = protectedPathFilter;
    }

    @Override
    public boolean alternatePaths(CircuitPath circuitPath, LinkedList linkedList) throws xNoAlternatePath {
        this.info("SingleEnd: Computing AlternatePaths for the following Links");
        LinkedList<INetLink> linkedList2 = null;
        for (INetLink iNetLink : linkedList) {
            this.info(iNetLink.prettyString());
            int n = this.prefs.getActiveMember().findDriNodeType(iNetLink.getSrc());
            if (iNetLink.isFullyUnprotected() && n != 2 && n != 4) {
                if (linkedList2 == null) {
                    linkedList2 = new LinkedList<INetLink>();
                }
                linkedList2.add(iNetLink);
                continue;
            }
            if (linkedList2 == null) continue;
            this.alternatePathSegment(circuitPath, linkedList2, linkedList);
            linkedList2 = null;
        }
        if (linkedList2 != null) {
            this.alternatePathSegment(circuitPath, linkedList2, linkedList);
        }
        return true;
    }

    public void alternatePathSegment(CircuitPath circuitPath, LinkedList linkedList, LinkedList linkedList2) throws xNoAlternatePath {
        INetElement iNetElement = ((INetLink)linkedList.getFirst()).getSrc();
        INetElement iNetElement2 = ((INetLink)linkedList.getLast()).getDst();
        this.info("Alterate path segment endpoints: " + iNetElement.prettyString() + ", " + iNetElement2.prettyString());
        iNetElement = this.prefs.getActiveMember().convertPathSegmentEndPoint(iNetElement);
        iNetElement2 = this.prefs.getActiveMember().convertPathSegmentEndPoint(iNetElement2);
        this.info("Converted Alterate path segment endpoints: " + iNetElement.prettyString() + ", " + iNetElement2.prettyString());
        CircuitPath circuitPath2 = this.filter.computeAlternatePath(linkedList2, linkedList, iNetElement, iNetElement2, 3, null, null);
        if (circuitPath != null) {
            circuitPath.updatePathSegments(circuitPath2);
        }
    }

    @Override
    public void cleanup() {
    }

    @Override
    public LinkedList computeCircuitPathSegments(LinkedList linkedList, int n) {
        LinkedList<PathSegment> linkedList2 = new LinkedList<PathSegment>();
        PathSegment pathSegment = null;
        LinkedList<NetLinkSpan> linkedList3 = new LinkedList<NetLinkSpan>();
        INetLink iNetLink = null;
        Iterator iterator = linkedList.iterator();
        this.info("SEP path filter: computing circuit path segments");
        while (iterator.hasNext()) {
            SptLink sptLink = (SptLink)iterator.next();
            int n2 = this.prefs.getActiveMember().findDriNodeType(sptLink.getLink().getSrc());
            int n3 = this.prefs.getActiveMember().findDriNodeType(sptLink.getLink().getDst());
            this.info("SEP Working on link : " + sptLink.getLink().prettyString() + "srcType = " + n2 + "dstType = " + n3);
            boolean bl = false;
            if (iNetLink == null || !this.filter.areProtectionTypesSimilar(iNetLink, sptLink.getLink())) {
                if (iNetLink == null) {
                    bl = true;
                } else {
                    this.info("protection changed at " + sptLink.getLink().getSrc().prettyString());
                    if (n2 != 2 && n2 != 3 && n2 != 4) {
                        bl = true;
                    } else {
                        this.info("protection change allowed at trad BLSR DRI nodes");
                    }
                }
                if (bl) {
                    this.info("creating a new path segment");
                    if (pathSegment != null) {
                        pathSegment.setPrimary(linkedList3);
                        linkedList2.add(pathSegment);
                    }
                    pathSegment = new PathSegment(this.prefs.getSrc(), this.prefs.getDst());
                    linkedList3 = new LinkedList();
                }
            }
            ILabelSet iLabelSet = sptLink.getSrcLabelSet();
            ILabelSet iLabelSet2 = sptLink.getDstLabelSet();
            ILabel[] iLabelArray = iLabelSet.getLabels(this.prefs.getMemberCount());
            ILabel[] iLabelArray2 = iLabelSet2.getLabels(this.prefs.getMemberCount());
            NetLinkSpan netLinkSpan = new NetLinkSpan(sptLink.getLink(), sptLink.getLink().getReverseLink(), iLabelArray[n], iLabelArray2[n]);
            linkedList3.add(netLinkSpan);
            iNetLink = sptLink.getLink();
        }
        if (pathSegment != null) {
            pathSegment.setPrimary(linkedList3);
            linkedList2.add(pathSegment);
        }
        return linkedList2;
    }

    private void info(String string) {
        this.prefs.getLog().getDebugLog().info(string);
    }
}

