/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.route;

import cerent.cms.model.ILinkModel;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.Network;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.SDebug;

public class SptCompositeNetLink
extends RoutableNetLink {
    private INetLink[] links;
    private static final SDebug debug = new SDebug("SptCompositeNetLink");

    public SptCompositeNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, INetLink[] iNetLinkArray) {
        super(network, iLinkModel, iNetElement, iNetElement2, false);
        this.links = iNetLinkArray;
        int n = 0;
        for (INetLink iNetLink : iNetLinkArray) {
            n += iNetLink.getCost();
        }
        this.setCost(n);
        for (int i = 0; i < iNetLinkArray.length; ++i) {
            INetLink iNetLink = iNetLinkArray[i];
            if (i <= 0) continue;
            this.nodesList.add(iNetLink.getSrc());
        }
        if (this.db.on()) {
            this.dump();
        }
    }

    public INetLink[] getLinks() {
        return this.links;
    }

    public INetLink getFirstLink() {
        return this.links.length > 0 ? this.links[0] : null;
    }

    public INetLink getLastLink() {
        return this.links.length > 0 ? this.links[this.links.length - 1] : null;
    }

    @Override
    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (debug.on()) {
            debug.println("Called isUsable");
        }
        boolean bl = true;
        for (INetLink iNetLink2 : this.links) {
            if (debug.on()) {
                debug.println("Forward isUsable call to " + iNetLink2 + "(from " + iNetLink + ")");
            }
            if (!(bl = iNetLink2.isUsable(routePrefs, iNetLink))) break;
            iNetLink = iNetLink2;
        }
        if (debug.on()) {
            debug.println("isUsable: " + bl);
        }
        return bl;
    }

    @Override
    public String prettyString() {
        StringBuilder stringBuilder = new StringBuilder("Spt Composite link [");
        for (INetLink iNetLink : this.links) {
            stringBuilder.append(" ").append(iNetLink.prettyString());
        }
        return stringBuilder.toString();
    }

    @Override
    public ILabelSet getSrcLabelSet(int n, int n2) {
        return this.getFirstLink().getSrcLabelSet(n, n2);
    }

    @Override
    public ILabelSet getDstLabelSet(int n, int n2) {
        return this.getLastLink().getDstLabelSet(n, n2);
    }

    @Override
    public void dispose() {
        this.links = null;
        super.dispose();
    }

    @Override
    public boolean isTemporarySptLink() {
        return true;
    }

    @Override
    public boolean isBlsrCapable() {
        return false;
    }

    @Override
    public void newState(int n) {
    }

    @Override
    protected void setChecking(boolean bl) {
    }

    @Override
    protected boolean inChecking() {
        return false;
    }

    @Override
    public int state() {
        return 0;
    }

    @Override
    protected void setOspfAreaId(long l) {
    }

    @Override
    public long getOspfAreaId() {
        return 0L;
    }

    @Override
    protected void initializeDebug() {
        this.db = new SDebug("SptCompositeNetLink" + SptCompositeNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + SptCompositeNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
        if (debug.on()) {
            this.db.set();
        }
    }

    private void dump() {
        this.db.println("======================================");
        this.db.println("SPT Composite link");
        this.db.println("Src = " + this.src.getHostName());
        this.db.println("Src Slot = " + this.srcSlot);
        this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])this.srcPort));
        this.db.println("Dst = " + this.dst.getHostName());
        this.db.println("Dst Slot = " + this.dstSlot);
        this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])this.dstPort));
        this.db.println("Cost = " + this.getCost());
        this.db.println("");
        this.db.println("Links:");
        int n = 0;
        for (INetLink iNetLink : this.links) {
            this.db.println("#" + ++n + " " + iNetLink.prettyString());
        }
    }
}

