/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AlreadyInUse;
import cerent.cms.model.CannotPerform;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IInterfaceModel;
import cerent.cms.model.ILinkModel;
import cerent.cms.model.ILinkType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IPortModel;
import cerent.cms.model.LinkModel;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.event.EventInfo;
import cerent.cms.model.event.IAlarmStatus;
import cerent.cms.model.event.IAlarmStore;
import cerent.cms.model.event.ICardAlarmStore;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.LambdaLabelSet;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.cms.topo.OchncFilterManager;
import cerent.cms.topo.OscNetLink;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.cms.ui.DwdmSide;
import cerent.cms.ui.helper.PortHelper;
import cerent.util.EnumStrings;
import cerent.util.IHoNum;
import cerent.util.IObserver;
import cerent.util.KDebug;
import cerent.util.SDebug;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Observer;

public class DwdmNetLink
extends RoutableNetLink
implements Observer {
    private static final int OCN_ENTITY_TYPE = 6;
    private long ospfAreaId = 0L;
    private IInterfaceModel srcIM;
    private IInterfaceModel dstIM;
    protected ICardAlarmStore dstCardAlarmStore;
    private int optLinkDir = -1;
    private String optRingName;
    private OscNetLink oscParentLink;
    private boolean oscLinkObserved = false;
    private boolean dstAlrStoreObserved = false;
    private boolean srcdstPortModelObserved = false;
    private boolean isDstEntityAlarmed = false;
    private boolean isDstNEMS = false;
    private static final int LOS = 22;
    private static final int IMPROPRMVL = 81;
    private static final int EQPT_FAIL = 64;
    public static final int UNKNOWN_OPT_DIR = -2;
    public static final int UNUSED_OPT_DIR = -1;
    public static final int EAST_TO_WEST_OPT_DIR = 0;
    public static final int WEST_TO_EAST_OPT_DIR = 1;

    protected DwdmNetLink(Network network, ILinkModel iLinkModel, INetElement iNetElement, INetElement iNetElement2, boolean bl, Topology topology, int n, boolean bl2) {
        super(network, iLinkModel, iNetElement, iNetElement2, bl, topology, n);
        this.deleted = false;
        this.linkModel = iLinkModel;
        this.newState(1);
    }

    @Override
    protected void initializeDebug() {
        this.db = new DwdmNetLinkDebug("NLd" + DwdmNetLink.getDebugName(this.src.getHostName()) + "(" + Integer.toHexString(this.getSrcEntityIndex()) + ")-" + DwdmNetLink.getDebugName(this.dst.getHostName()) + "(" + Integer.toHexString(this.getDstEntityIndex()) + ")");
        if (this.db.on()) {
            this.db.println("DwdmNetLink: creating new DwdmNetLink");
        }
    }

    @Override
    public String prettyString() {
        return super.prettyString() + "- Observing: " + (this.oscLinkObserved ? "OSCLink - " : " - ") + (this.dstAlrStoreObserved ? "DstAlmStore - " : " - ") + (this.srcdstPortModelObserved ? "SrcDstPortModel - " : " -");
    }

    @Override
    public boolean isBlsrCapable() {
        return false;
    }

    @Override
    public INodeModel topoHost() {
        return this.linkModel.topoHost();
    }

    public void setTopoHost(INodeModel iNodeModel) {
        this.linkModel.setTopoHost(iNodeModel);
    }

    public int oldState() {
        return ((LinkModel)this.linkModel).oldState();
    }

    public int newState() {
        return ((LinkModel)this.linkModel).newState();
    }

    protected void oldState(int n) {
        ((LinkModel)this.linkModel).oldState(n);
    }

    @Override
    public void newState(int n) {
        ((LinkModel)this.linkModel).oldState(this.newState());
        if (n != this.oldState()) {
            if (this.db.on()) {
                this.db.println("newState: state changed from " + (this.oldState() == 1 ? "Up" : "Down") + " to " + (n == 1 ? "Up" : "Down"));
            }
            ((LinkModel)this.linkModel).newState(n);
            if (!this.deleted) {
                this.setChanged();
            } else {
                this.clearChanged();
            }
        } else if (this.db.on()) {
            this.db.println("newState: state unchanged = " + (n == 1 ? "Up" : "Down."));
        }
        this.notifyObservers(ModelUpdateType.CHANGED);
    }

    @Override
    public void setChecking(boolean bl) {
    }

    @Override
    public boolean inChecking() {
        return false;
    }

    protected void setOptAttribs(String string, int n) {
        this.optRingName = string;
        this.optLinkDir = n;
        if (this.db.on()) {
            this.db.println("setOptAttirbs: optRingName = " + string);
            this.db.println("setOptAttirbs: optLinkDir = " + DwdmNetLink.cktOptDirString(n));
        }
    }

    public String getOptRingName() {
        return this.optRingName;
    }

    @Override
    public Topology getTopology() {
        return this.topology;
    }

    @Override
    public int getTopoId() {
        return this.topoId;
    }

    @Override
    protected void setOspfAreaId(long l) {
        if (this.ospfAreaId != l) {
            this.ospfAreaId = l;
            this.topology.ospfAreaChanged(this);
        }
    }

    protected void clearOspfAreaId() {
        this.ospfAreaId = 0L;
    }

    @Override
    public long getOspfAreaId() {
        return this.ospfAreaId;
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof DwdmNetLink)) {
            return false;
        }
        DwdmNetLink dwdmNetLink = (DwdmNetLink)object;
        return this.physicalLinkEquals(dwdmNetLink);
    }

    @Override
    public int hashCode() {
        int n = 17;
        n = 37 * n + this.src.hashCode();
        n = 37 * n + this.getSrcEntityIndex();
        n = 37 * n + this.dst.hashCode();
        n = 37 * n + this.getDstEntityIndex();
        return n;
    }

    @Override
    public ILabelSet getSrcLabelSet(int n, int n2) {
        return new LambdaLabelSet();
    }

    @Override
    public ILabelSet getDstLabelSet(int n, int n2) {
        return new LambdaLabelSet();
    }

    private boolean isDstNeMultiShelf() {
        INodeModel iNodeModel;
        boolean bl = false;
        if (this.getDst().getConnectionState() && (iNodeModel = this.getDst().getNodeModel()).provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            bl = true;
        }
        return bl;
    }

    protected void startObserving(OscNetLink oscNetLink) {
        this.isDstNEMS = this.isDstNeMultiShelf();
        this.oscParentLink = oscNetLink;
        DwdmNetLink dwdmNetLink = this;
        this.oscParentLink.addObserver(dwdmNetLink);
        this.oscLinkObserved = true;
        if (this.db.on()) {
            this.db.println("Start observing OSC parent link " + this.oscParentLink.prettyString());
        }
        this.getSrc().addObserver(dwdmNetLink);
        this.getDst().addObserver(dwdmNetLink);
        if (this.db.on()) {
            this.db.println("Start observing src & dst NE " + this.getSrc().getHostName() + " & " + this.getDst().getHostName());
        }
        this.startObservingSrcDstPortModel();
        this.startObservingDstCardAlarmStore();
    }

    private void startObservingSrcDstPortModel() {
        block6: {
            try {
                IPortModel iPortModel = (IPortModel)this.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(this.linkModel.srcEntityIndex());
                this.srcIM = iPortModel.getInterfaceModel();
                IPortModel iPortModel2 = (IPortModel)this.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(this.linkModel.dstEntityIndex());
                this.dstIM = iPortModel2.getInterfaceModel();
                DwdmNetLink dwdmNetLink = this;
                if (this.srcIM != null) {
                    this.srcIM.addObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Start observing Src PortModel: " + Integer.toHexString(this.srcIM.getPortModel().getEntityIndex()));
                    }
                }
                if (this.dstIM != null) {
                    this.dstIM.addObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Start observing Dst PortModel: " + Integer.toHexString(this.dstIM.getPortModel().getEntityIndex()));
                    }
                }
                this.srcdstPortModelObserved = true;
            }
            catch (Exception exception) {
                if (!this.db.on) break block6;
                this.db.println("Exception trying to observe portModel");
            }
        }
    }

    private void stopObservingSrcDstPortModel() {
        block6: {
            try {
                DwdmNetLink dwdmNetLink = this;
                if (this.srcIM != null) {
                    this.srcIM.deleteObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Stop observing src PortModel: " + this.srcIM.getPortModel().getEntityIndex());
                    }
                }
                if (this.dstIM != null) {
                    this.dstIM.deleteObserver((IObserver)dwdmNetLink);
                    if (this.db.on) {
                        this.db.println("Stop observing dst PortModel: " + this.dstIM.getPortModel().getEntityIndex());
                    }
                }
                this.srcdstPortModelObserved = false;
            }
            catch (Exception exception) {
                if (!this.db.on) break block6;
                this.db.println("Exception trying to deregister from portModel: " + exception);
            }
        }
    }

    private void stopObserving() {
        this.stopObservingParentLink();
        DwdmNetLink dwdmNetLink = this;
        this.getSrc().deleteObserver(dwdmNetLink);
        this.getDst().deleteObserver(dwdmNetLink);
        if (this.db.on()) {
            this.db.println("Stop observing src & dst NE " + this.getSrc().getHostName() + " & " + this.getDst().getHostName());
        }
        this.stopObservingDstCardAlarmStore();
        this.stopObservingSrcDstPortModel();
    }

    private void stopObservingParentLink() {
        DwdmNetLink dwdmNetLink = this;
        if (this.oscLinkObserved) {
            this.oscParentLink.deleteObserver(dwdmNetLink);
            this.oscLinkObserved = false;
            if (this.db.on()) {
                this.db.println("Stop observing OSC parent link " + this.oscParentLink.prettyString());
            }
        }
    }

    private void startObservingDstCardAlarmStore() {
        block11: {
            INodeModel iNodeModel;
            if (this.db.on) {
                this.db.println("Try Observing CardAlarmStore: node " + this.getDst().getHostName());
            }
            if (this.getDst().getConnectionState() && (iNodeModel = this.getDst().getNodeModel()).provides(Feature.OCHNC_PROVISIONING)) {
                try {
                    IAlarmStore iAlarmStore = this.getDst().getNodeModel().getElementAlarmStore();
                    if (iAlarmStore != null) {
                        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
                            IEntityModel iEntityModel = iNodeModel.getEntityTable().getEntityModelByIndex(this.linkModel.dstEntityIndex());
                            this.dstCardAlarmStore = iAlarmStore.getCardAlarmStore(iEntityModel.getShelfId(), this.linkModel.dstSlotNum());
                        } else {
                            this.dstCardAlarmStore = iAlarmStore.getCardAlarmStore(this.linkModel.dstSlotNum());
                        }
                        if (this.dstCardAlarmStore != null) {
                            this.dstCardAlarmStore.addAlarmStatusObserver((Observer)this);
                            this.dstAlrStoreObserved = true;
                            if (this.db.on) {
                                this.db.println("Start observing DstCardAlarmStore: node " + this.getDst().getHostName());
                            }
                            this.update(this.dstCardAlarmStore.getAlarmStatusObservable(), (Object)this.dstCardAlarmStore.getAlarmStatus());
                        }
                    }
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    if (this.db.on()) {
                        this.db.println("Caught exception in getElementAlarmStore()");
                        KDebug.printStackTrace((Throwable)abstractCmsIOException);
                    }
                }
                catch (Exception exception) {
                    if (!this.db.on()) break block11;
                    this.db.println("Caught exception in getElementAlarmStore()");
                    KDebug.printStackTrace((Throwable)exception);
                }
            }
        }
    }

    private void stopObservingDstCardAlarmStore() {
        if (this.db.on) {
            this.db.println("Stop observing DstCardAlarmStore: node " + this.getDst().getHostName());
        }
        if (this.dstCardAlarmStore != null) {
            this.dstCardAlarmStore.deleteAlarmStatusObserver((Observer)this);
        }
        this.dstAlrStoreObserved = false;
        this.dstCardAlarmStore = null;
    }

    @Override
    protected void _update(Object object, Object object2) {
        if (object instanceof NetElement) {
            INetElement iNetElement = (INetElement)object;
            if (object2 == ModelUpdateType.DELETED) {
                this.newState(2);
                return;
            }
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("UPDATE changed event from NE " + iNetElement.getHostName());
                }
                if (!this.isDstNEMS && this.isDstNeMultiShelf() || this.isDstNEMS && !this.isDstNeMultiShelf()) {
                    this.isDstNEMS = this.isDstNeMultiShelf();
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                        this.db.println("Dst NE changed from " + (this.isDstNEMS ? "SS" : "MS") + " to " + (this.isDstNEMS ? "MS" : "SS") + " restart observing dst alarm store");
                    }
                    this.stopObservingDstCardAlarmStore();
                    this.startObservingDstCardAlarmStore();
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                    }
                }
                if (!this.dstAlrStoreObserved) {
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                        this.db.println("Re-start observing destination alarm store");
                    }
                    this.startObservingDstCardAlarmStore();
                    if (this.db.on()) {
                        this.db.println("-------------------------------------------------------------------");
                    }
                }
            }
        } else if (object2 instanceof IAlarmStatus) {
            if (this.db.on) {
                this.db.println("UPDATE from alarm status");
            }
        } else if (object instanceof INetLink) {
            if (object2 == ModelUpdateType.CHANGED) {
                if (this.db.on) {
                    this.db.println("UPDATE OscNetLink updated");
                }
                OscNetLink oscNetLink = (OscNetLink)object;
                if (!this.hasSrcNodeOpticalSide()) {
                    this.setOptAttribs(oscNetLink.getOptRingName(), oscNetLink.getOptLinkDir());
                } else if (this.hasDstNodeOpticalSide()) {
                    this.setOptAttribs(null, -1);
                }
                this.setTopology(oscNetLink.getTopology(), oscNetLink.getTopoId());
            } else if (object2 == ModelUpdateType.DELETED) {
                if (this.db.on) {
                    this.db.println("UPDATE OscNetLink deleted");
                }
                this.stopObservingParentLink();
            }
        } else if (object instanceof IInterfaceModel) {
            if (this.db.on) {
                this.db.println("UPDATE from PortModel");
            }
            if (object2 == ModelUpdateType.DELETED) {
                this.newState(2);
                return;
            }
        }
        this.driveLinkStatus();
    }

    private void driveLinkStatus() {
        boolean bl;
        this.isDstEntityAlarmed = this.isDstEntityAlarmed();
        boolean bl2 = this.getSrc().getConnectionState() && !this.isSrcPortOOS();
        boolean bl3 = bl = this.getDst().getConnectionState() && !this.isDstPortOOS() && !this.isDstEntityAlarmed;
        if (!bl && !bl2) {
            if (this.oscParentLink.isDeleted()) {
                this.dispose();
            } else {
                this.newState(2);
            }
        } else if (!bl || !bl2) {
            this.newState(2);
        } else if (bl && bl2) {
            this.newState(1);
        }
        if (this.db.on()) {
            this.db.println("Src node: " + (this.getSrc().getConnectionState() ? "UP" : "DOWN") + " - Dst node: " + (this.getDst().getConnectionState() ? "UP" : "DOWN") + " - Dst AlmStatus: " + (this.isDstEntityAlarmed ? "ALARMED" : "NOT ALARMED") + " - OSCLink Status: " + (this.oscParentLink.getLinkModel().state() == 1 ? "UP" : "DOWN"));
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isDstEntityAlarmed() {
        var1_1 = false;
        if (this.dstCardAlarmStore != null && this.getDst().getConnectionState()) {
            var3_2 = new ArrayList();
            var4_3 = this.getDst().getNodeModel().getAlarmDecoderDefs();
            if (var4_3 != null) {
                var5_4 = var4_3.getDwdmNetLinkAlarms();
                for (Integer var7_8 : var5_4) {
                    var3_2.addAll(this.dstCardAlarmStore.getAlarmByCondition(var7_8.intValue()));
                }
            } else {
                var3_2 = this.dstCardAlarmStore.getAlarmByCondition(22);
                var3_2.addAll(this.dstCardAlarmStore.getAlarmByCondition(64));
                var3_2.addAll(this.dstCardAlarmStore.getAlarmByCondition(81));
            }
            ** if (var3_2.size() <= 0) goto lbl38
            for (var5_5 = 0; var5_5 < var3_2.size(); ++var5_5) {
                block11: {
                    var2_9 = (EventInfo)var3_2.get(var5_5);
                    if (var2_9.getEntityType() == 6 || var2_9.getState() != 'R') continue;
                    try {
                        if (this.getDst().getNodeModel().getEntityTable() == null) break block11;
                        var6_6 = this.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(var2_9.getIndex());
                        if (var6_6.getModuleModel().getEqType() == 286) {
                            if (var2_9.getIndex() == this.getDstEntityIndex()) {
                                var1_1 = true;
                                break;
                            }
                            break block11;
                        }
                        var1_1 = true;
                        break;
                    }
                    catch (AbstractCmsNoSuchEntityException var6_7) {
                        if (!this.db.on) break block11;
                        this.db.println("Exception trying to retrieve portModel");
                    }
                }
                if (!this.db.on) continue;
                this.db.println("LOS, EQPT FAIL or IMPROPRMVL raised by destination link card");
lbl-1000:
                // 2 sources

                {
                    continue;
                }
            }
        }
lbl38:
        // 6 sources

        if (this.db.on && !var1_1) {
            this.db.println("Cleared alarms or no relevant alarm raised by dst link card");
        }
        return var1_1;
    }

    private boolean isSrcPortOOS() {
        boolean bl = false;
        try {
            IPortModel iPortModel = (IPortModel)this.getSrc().getNodeModel().getEntityTable().getEntityModelByIndex(this.getSrcEntityIndex());
            if (iPortModel != null) {
                if (iPortModel.getAdminState() == 0 || iPortModel.getAdminState() == 2) {
                    if (this.db.on) {
                        this.db.println("Src Port is IS or OOS_MT: " + Integer.toHexString(this.getSrcEntityIndex()));
                    }
                } else {
                    if (this.db.on) {
                        this.db.println("Src Port is OOS_DSBLD or IS_AINS: " + Integer.toHexString(this.getSrcEntityIndex()));
                    }
                    bl = true;
                }
            } else if (this.db.on) {
                this.db.println("Src Port Model is NULL");
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on) {
                this.db.println("Exception trying to get the Src port Status");
            }
            bl = true;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                this.db.println("Exception trying to get the Src port Model ");
            }
            bl = true;
        }
        catch (Exception exception) {
            if (this.db.on) {
                this.db.println("Exception trying to get the Src Entity Table Model ");
            }
            bl = true;
        }
        return bl;
    }

    private boolean isDstPortOOS() {
        boolean bl = false;
        try {
            IPortModel iPortModel = (IPortModel)this.getDst().getNodeModel().getEntityTable().getEntityModelByIndex(this.getDstEntityIndex());
            if (iPortModel != null) {
                if (iPortModel.getAdminState() == 0 || iPortModel.getAdminState() == 2) {
                    if (this.db.on) {
                        this.db.println("Dst Port is IS or OOS_MT: " + Integer.toHexString(this.getDstEntityIndex()));
                    }
                } else {
                    if (this.db.on) {
                        this.db.println("Dst Port is OOS_DSBLD or IS_AINS: " + Integer.toHexString(this.getDstEntityIndex()));
                    }
                    bl = true;
                }
            } else if (this.db.on) {
                this.db.println("Dst Port Model is NULL");
            }
        }
        catch (NoSuchInterface noSuchInterface) {
            if (this.db.on) {
                this.db.println("Exception trying to get the Dst port Status");
            }
            bl = true;
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on) {
                this.db.println("Exception trying to get the Dst port Model ");
            }
            bl = true;
        }
        catch (Exception exception) {
            if (this.db.on) {
                this.db.println("Exception trying to get the Dst Entity Table Model ");
            }
            bl = true;
        }
        return bl;
    }

    @Override
    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public int state() {
        return this.newState();
    }

    @Override
    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (routePrefs.isFormerOchncCircuit()) {
            return this.isUsableFormerOchnc(routePrefs, iNetLink);
        }
        OchncFilterManager ochncFilterManager = new OchncFilterManager(this, this.db);
        return ochncFilterManager.isUsable(routePrefs, iNetLink);
    }

    private boolean isUsableFormerOchnc(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.db.on()) {
            this.db.println("Checking isUsable for prefs: " + routePrefs.prettyString());
        }
        if (this.getSrc().getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            throw new xLinkNotUsable("Source node version must be 6.0 or previous.");
        }
        if (this.getDst().getNodeModel().provides(Feature.OCH_TRAIL_PROVISIONING)) {
            throw new xLinkNotUsable("Destination node version must be 6.0 or previous.");
        }
        if (this.optLinkDir != routePrefs.getCktOptDir()) {
            throw new xLinkNotUsable("Invalid link direction (" + DwdmNetLink.cktOptDirString(this.optLinkDir) + " found; " + DwdmNetLink.cktOptDirString(routePrefs.getCktOptDir()) + "expected)");
        }
        this.checkIsUsableFormerOchnc(routePrefs);
        if (routePrefs.getDirectionality() == 3) {
            INetLink iNetLink2 = OchncFilterManager.findLinkForReversePath(this, this.db);
            if (this.db.on()) {
                this.db.println("Bidi circuit - Checking opposite link: " + iNetLink2);
            }
            if (iNetLink2 == null) {
                throw new xLinkNotUsable("Cannot find opposite link for bidirectional circuit.");
            }
            if (iNetLink2 instanceof DwdmNetLink) {
                RoutePrefs routePrefs2 = routePrefs.getReversePrefs();
                ((DwdmNetLink)iNetLink2).checkIsUsableFormerOchnc(routePrefs2);
            } else {
                throw new xLinkNotUsable("Opposite link must be an OTS link: " + iNetLink2);
            }
        }
        if (this.db.on()) {
            this.db.println("IS USABLE for former OCHNC");
        }
        return true;
    }

    private void checkIsUsableFormerOchnc(RoutePrefs routePrefs) throws xLinkNotUsable {
        INetElement iNetElement = routePrefs.getSrc();
        INetElement iNetElement2 = routePrefs.getDst();
        int n = routePrefs.getcktOptChannel();
        int n2 = routePrefs.getCktOptDir();
        if (this.getSrc().getConnectionState()) {
            if (this.getSrc().equals(iNetElement)) {
                this.checkFormerChannelAvailability(this.getSrc().getNodeModel(), n, n2, 0);
            } else {
                this.checkFormerChannelAvailability(this.getSrc().getNodeModel(), n, n2, 2);
            }
        } else {
            throw new xLinkNotUsable("Source node not connected");
        }
        if (this.getDst().getConnectionState()) {
            if (this.getDst().equals(iNetElement2)) {
                this.checkFormerChannelAvailability(this.getDst().getNodeModel(), n, n2, 1);
            } else {
                this.checkFormerChannelAvailability(this.getDst().getNodeModel(), n, n2, 2);
            }
        } else {
            throw new xLinkNotUsable("Destination node not connected");
        }
    }

    private void checkFormerChannelAvailability(INodeModel iNodeModel, int n, int n2, int n3) throws xLinkNotUsable {
        String string = iNodeModel.getName();
        String string2 = "";
        switch (n3) {
            case 0: {
                string2 = "Add";
                break;
            }
            case 2: {
                string2 = "Passthrough";
                break;
            }
            case 1: {
                string2 = "Drop";
            }
        }
        if (this.db.on()) {
            this.db.println("checkFormerChannelAvailability on node " + string + " for type " + string2);
        }
        try {
            if (this.db.on()) {
                this.db.println("Verifying " + string2 + "channel availability on " + string);
            }
            boolean bl = iNodeModel.getOchncPathAvailability(n, n2, n3);
            if (this.db.on()) {
                this.db.println("avail = " + bl);
            }
            if (!bl) {
                throw new xLinkNotUsable(string2 + " channel not available on " + string);
            }
        }
        catch (AlreadyInUse alreadyInUse) {
            throw new xLinkNotUsable(string2 + " channel is provisioned but already in use on " + string);
        }
        catch (Exception exception) {
            throw new xLinkNotUsable("Cannot verify " + string2.toLowerCase() + " channel availability on " + string + ": " + exception.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        if (this.db.on) {
            this.db.println("Disposing DWDMNetLink...");
        }
        DwdmNetLink dwdmNetLink = this;
        synchronized (dwdmNetLink) {
            if (this.deleted) {
                return;
            }
            this.deleted = true;
        }
        if (this.net != null) {
            this.net.delete(this);
        }
        this.stopObserving();
        super.dispose();
    }

    public static String getDebugName(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
            if (inetAddress != null) {
                byte[] byArray = inetAddress.getAddress();
                return "" + (byArray[3] & 0xFF) + "-" + (byArray[2] & 0xFF) + "-" + (byArray[1] & 0xFF) + "-" + (byArray[0] & 0xFF);
            }
            return string;
        }
        catch (UnknownHostException unknownHostException) {
            return string;
        }
    }

    public INetLink getParentLink() {
        return this.oscParentLink;
    }

    public String[] getSpanLoss() throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        if (Feature.provides((INodeModel)this.getDst().getNodeModel(), (Feature)Feature.REMOTE_ELE_V1)) {
            if (this.hasDstNodeOpticalSide()) {
                return this.getDst().getNodeModel().getSpanLoss(OchncHelper.getSideFromPortIndex(this.getDst().getNodeModel(), this.getDstEntityIndex()));
            }
            return this.getDst().getNodeModel().getSpanLoss(this.optLinkDir);
        }
        return this.getDst().getNodeModel().getSpanLoss(this.getDstEntityIndex());
    }

    private boolean hasSrcNodeOpticalSide() {
        return this.getSrc().getNodeModel().provides(Feature.OPTICAL_SIDE);
    }

    private boolean hasDstNodeOpticalSide() {
        return this.getDst().getNodeModel().provides(Feature.OPTICAL_SIDE);
    }

    public String getVitalStatsString() {
        return this.getAttrsString("\n");
    }

    public String getAttrsString() {
        return this.getAttrsString(", ");
    }

    private String getAttrsString(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (!this.hasSrcNodeOpticalSide() && !this.hasDstNodeOpticalSide()) {
            stringBuffer.append(string + "Optical Direction: " + DwdmNetLink.cktOptDirString(this.optLinkDir));
        }
        if (this.getOptRingName() != null) {
            stringBuffer.append(string + "Optical Ring Name: " + this.getOptRingName());
        }
        return stringBuffer.toString();
    }

    private int getSrcSide() throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        return this.oscParentLink.getSrcSide();
    }

    private int getDstSide() throws FeatureUnsupported, CannotPerform, AbstractCmsNoSuchElementException {
        return this.oscParentLink.getDstSide();
    }

    private int getDstOptLinkDir() {
        DwdmNetLink dwdmNetLink = (DwdmNetLink)this.getReverseLink();
        if (dwdmNetLink != null) {
            return dwdmNetLink.optLinkDir;
        }
        return -2;
    }

    public static int getOppositeOptDir(int n) {
        switch (n) {
            case 0: {
                return 1;
            }
            case 1: {
                return 0;
            }
        }
        return n;
    }

    public static String cktOptDirString(int n) {
        switch (n) {
            case -2: {
                return "Unknown";
            }
            case -1: {
                return "Unused";
            }
            case 0: {
                return "East to West";
            }
            case 1: {
                return "West to East";
            }
        }
        return "Unmanaged (" + n + ")";
    }

    public class DwdmNetLinkDebug
    extends SDebug {
        public DwdmNetLinkDebug(String string) {
            super(string);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dump() {
            AbstractNetLink.dbg.println("==============================================");
            DwdmNetLink.this.db.println("Src = " + DwdmNetLink.this.src.getHostName());
            DwdmNetLink.this.db.println("Dst = " + DwdmNetLink.this.dst.getHostName());
            DwdmNetLink.this.db.println("State = " + (DwdmNetLink.this.newState() == 1 ? "Up" : "Down"));
            DwdmNetLink.this.db.println("Deleted = " + DwdmNetLink.this.deleted);
            DwdmNetLink.this.db.println("Topology ID = " + DwdmNetLink.this.topoId);
            DwdmNetLink.this.db.println("NetLink Type = " + DwdmNetLink.this.getLinkTypeObj());
            DwdmNetLink.this.db.println("Physical Link Type = " + EnumStrings.getString(ILinkType.class, (int)DwdmNetLink.this.getPhysicalLinkType()));
            DwdmNetLink.this.db.println("Src Slot = " + DwdmNetLink.this.srcSlot);
            DwdmNetLink.this.db.println("Src Port = " + PortHelper.getConcatenatedString((int[])DwdmNetLink.this.srcPort));
            if (DwdmNetLink.this.hasSrcNodeOpticalSide()) {
                try {
                    DwdmNetLink.this.db.println("Src Side = " + DwdmSide.getSideFromOffset(DwdmNetLink.this.getSrcSide()));
                }
                catch (Exception exception) {
                    DwdmNetLink.this.db.println("Src Side = UNKNOWN (" + exception.getMessage() + ")");
                }
            } else {
                DwdmNetLink.this.db.println("Src opt link dir = " + DwdmNetLink.cktOptDirString(DwdmNetLink.this.optLinkDir));
            }
            DwdmNetLink.this.db.println("Dst Slot = " + DwdmNetLink.this.dstSlot);
            DwdmNetLink.this.db.println("Dst Port = " + PortHelper.getConcatenatedString((int[])DwdmNetLink.this.dstPort));
            if (DwdmNetLink.this.hasDstNodeOpticalSide()) {
                try {
                    DwdmNetLink.this.db.println("Dst Side = " + DwdmSide.getSideFromOffset(DwdmNetLink.this.getDstSide()));
                }
                catch (Exception exception) {
                    DwdmNetLink.this.db.println("Dst Side = UNKNOWN (" + exception.getMessage() + ")");
                }
            } else {
                DwdmNetLink.this.db.println("Dst opt link dir = " + DwdmNetLink.cktOptDirString(DwdmNetLink.this.getDstOptLinkDir()));
            }
            DwdmNetLink.this.db.println("Optical RingName = " + DwdmNetLink.this.optRingName);
            DwdmNetLink.this.db.println("  Nodes List: ");
            ArrayList arrayList = DwdmNetLink.this.nodesList;
            synchronized (arrayList) {
                for (Object object : DwdmNetLink.this.nodesList) {
                    DwdmNetLink.this.db.println("    " + object.getHostName());
                }
            }
            DwdmNetLink.this.db.println("  Links List:");
            arrayList = DwdmNetLink.this.linksList;
            synchronized (arrayList) {
                for (Object object : DwdmNetLink.this.linksList) {
                    DwdmNetLink.this.db.println("    " + object.prettyString());
                }
            }
        }

        public final void dumpObservers() {
            DwdmNetLink.this.db.println("NL observers:");
            DwdmNetLink.this.printObservers();
        }
    }
}

