/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.ModelUpdateType;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.NetElement;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;
import java.util.Observable;
import java.util.Observer;

public abstract class LinkStateMachine
implements IObserver {
    public static final int LINK_CREATION_STATE = 0;
    public static final int NE_OBS_STATE = 1;
    public static final int TERM_OBS_STATE = 2;
    public static final int NE_DISPOSED_STATE = 3;
    public static final int LINK_DISPOSED_STATE = 4;
    public static final int SRC_NE_DISPOSE_EVENT = 0;
    public static final int SRC_TERM_DISPOSE_EVENT = 1;
    public static final int DST_NE_DISPOSE_EVENT = 2;
    public static final int DST_TERM_DISPOSE_EVENT = 3;
    public static final int LINK_DISPOSE_EVENT = 4;
    public static final int LINK_INITED_EVENT = 5;
    public static final int SRC_NE_UPDATE_EVENT = 6;
    public static final int DST_NE_UPDATE_EVENT = 7;
    public static final int LINK_DOWN_EVENT = 8;
    public static final int LINK_UP_EVENT = 9;
    public static final String[] events = new String[]{"SRC_NE_DISPOSE_EVENT", "SRC_TERM_DISPOSE_EVENT", "DST_NE_DISPOSE_EVENT", "DST_TERMM_DISPOSE_EVENT", "LINK_DISPOSE_EVENT", "LINK_INITED_EVENT", "SRC_NE_UPDATE_EVENT", "DST_NE_UPDATE_EVENT", "LINK_DOWN_EVENT", "LINK_UP_EVENT"};
    public static final String[] states = new String[]{"LINK_CREATION_STATE", "NE_OBS_STATE", "TERM_OBS_STATE", "NE_DISPOSED_STATE", "LINK_DISPOSED_STATE"};
    private boolean stateBeingUpdated;
    protected SDebug db;
    protected int srcState;
    protected int dstState;
    protected TermObserver srcTermObserver;
    protected TermObserver dstTermObserver;
    private Thread currentThread;
    private int lockCounter;
    protected Network net;
    protected INetLink link;
    private static int counter = 0;

    public LinkStateMachine(Network network, INetLink iNetLink, SDebug sDebug) {
        this.net = network;
        this.link = iNetLink;
        this.lockCounter = 0;
        this.srcState = 0;
        this.dstState = 0;
        this.stateBeingUpdated = false;
        this.srcTermObserver = new TermObserver(1);
        this.dstTermObserver = new TermObserver(3);
        this.db = new LinkStateMachineDebug("LSM_" + AbstractNetLink.getDebugName(iNetLink.getSrc().getActualAddressDisplay()) + "(" + Integer.toHexString(iNetLink.getSrcEntityIndex()) + ")-" + AbstractNetLink.getDebugName(iNetLink.getDst().getActualAddressDisplay()) + "(" + Integer.toHexString(iNetLink.getDstEntityIndex()) + ")" + "__" + ++counter);
        if (sDebug.on()) {
            this.db.set(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getLinkSmLock() {
        LinkStateMachine linkStateMachine = this;
        synchronized (linkStateMachine) {
            Thread thread = Thread.currentThread();
            if (this.currentThread == thread) {
                ++this.lockCounter;
                if (this.db.on()) {
                    this.db.println("getLinkSmLock: currentThread requesting lock");
                }
                return;
            }
            while (this.stateBeingUpdated) {
                try {
                    if (this.db.on()) {
                        this.db.println("getLinkSmLock: attempting to acquire SM lock");
                    }
                    this.wait();
                    if (!this.db.on()) continue;
                    this.db.println("getLinkSmLock: acquired SM lock");
                }
                catch (InterruptedException interruptedException) {
                    this.db.finest("InterruptedException in getLinkSmLock() " + interruptedException);
                }
            }
            ++this.lockCounter;
            this.stateBeingUpdated = true;
            this.currentThread = thread;
            if (this.db.on()) {
                this.db.println("getLinkSmLock: setting currentThread to " + this.currentThread.getName() + ", counter = " + this.lockCounter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLinkSmLock() {
        if (this.db.on()) {
            this.db.println("releaseLinkSmLock: stateBeingUpdate = " + this.stateBeingUpdated);
        }
        LinkStateMachine linkStateMachine = this;
        synchronized (linkStateMachine) {
            --this.lockCounter;
            if (this.lockCounter == 0) {
                this.stateBeingUpdated = false;
                this.notifyAll();
                this.currentThread = null;
            }
        }
        if (this.db.on()) {
            this.db.println("releaseLinkSmLock: SM lock released, counter = " + this.lockCounter);
        }
    }

    public int getCurrentSrcState() {
        return this.srcState;
    }

    public int getCurrentDstState() {
        return this.dstState;
    }

    public String getCurrentSrcStateAsString() {
        return states[this.srcState];
    }

    public String getCurrentDstStateAsString() {
        return states[this.dstState];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean driveSm(int n) {
        boolean bl;
        if (this.db.on()) {
            this.db.println("driveSm: current srcState = " + states[this.srcState]);
            this.db.println("driveSm: current dstState = " + states[this.dstState]);
            this.db.println("driveSm: Event = " + events[n]);
        }
        this.getLinkSmLock();
        int n2 = this.srcState;
        int n3 = this.dstState;
        try {
            switch (n) {
                case 5: {
                    this.registerSrcWithNe();
                    this.registerDstWithNe();
                    this.registerSrcWithTerm();
                    this.registerDstWithTerm();
                    break;
                }
                case 6: {
                    this.registerSrcWithTerm();
                    break;
                }
                case 7: {
                    this.registerDstWithTerm();
                    break;
                }
                case 0: {
                    this.deregisterSrcWithTerm();
                    this.deregisterSrcWithNe();
                    break;
                }
                case 1: {
                    this.deregisterSrcWithTerm();
                    break;
                }
                case 2: {
                    this.deregisterDstWithTerm();
                    this.deregisterDstWithNe();
                    break;
                }
                case 3: {
                    this.deregisterDstWithTerm();
                    break;
                }
                case 4: {
                    this.deregisterSrcWithTerm();
                    this.deregisterSrcWithNe();
                    this.deregisterDstWithTerm();
                    this.deregisterDstWithNe();
                    this.dstState = 4;
                    this.srcState = 4;
                    break;
                }
                case 9: {
                    this.registerSrcWithTerm();
                    this.registerDstWithTerm();
                    break;
                }
                case 8: {
                    break;
                }
            }
            int n4 = this.srcState;
            int n5 = this.dstState;
            boolean bl2 = bl = n2 != n4 || n3 != n5;
            if (n4 != 2 && n5 != 2 && this.link.state() != 1 && n != 4) {
                this.deregisterSrcWithNe();
                this.deregisterDstWithNe();
                this.dstState = 4;
                this.srcState = 4;
            }
        }
        finally {
            this.releaseLinkSmLock();
        }
        if (this.db.on()) {
            this.db.println("driveSm: new srcState = " + states[this.srcState]);
            this.db.println("driveSm: new dstState = " + states[this.dstState]);
        }
        if (this.srcState == 4 && this.dstState == 4) {
            ((AbstractNetLink)this.link).disposed();
            this.db.dispose();
        }
        return bl;
    }

    private void registerSrcWithNe() {
        if (this.srcState == 0) {
            this.link.getSrc().addObserver(this);
            this.srcState = 1;
        }
    }

    private void registerDstWithNe() {
        if (this.dstState == 0) {
            this.link.getDst().addObserver(this);
            this.dstState = 1;
        }
    }

    private void deregisterSrcWithNe() {
        if (this.srcState == 1) {
            this.link.getSrc().deleteObserver(this);
            this.srcState = 3;
        }
    }

    private void deregisterDstWithNe() {
        if (this.dstState == 1) {
            this.link.getDst().deleteObserver(this);
            this.dstState = 3;
        }
    }

    protected abstract void registerSrcWithTerm();

    protected abstract void registerDstWithTerm();

    protected abstract void deregisterSrcWithTerm();

    protected abstract void deregisterDstWithTerm();

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof NetElement) {
            NetElement netElement = (NetElement)iObservable;
            if (object == ModelUpdateType.CHANGED) {
                if (this.db.on()) {
                    this.db.println("update: received CHANGED event for NE " + netElement.getActualAddressDisplay());
                }
                if (netElement.equals(this.link.getSrc())) {
                    this.driveSm(6);
                } else if (netElement.equals(this.link.getDst())) {
                    this.driveSm(7);
                }
            } else if (object == ModelUpdateType.DELETED) {
                if (netElement.equals(this.link.getSrc())) {
                    this.driveSm(0);
                } else if (netElement.equals(this.link.getDst())) {
                    this.driveSm(2);
                }
                if (this.db.on()) {
                    this.db.println("update: received DELETED event for NE " + netElement.getActualAddressDisplay());
                }
            }
        }
    }

    public class LinkStateMachineDebug
    extends SDebug {
        public LinkStateMachineDebug(String string) {
            super(string);
        }

        public final void dump() {
            LinkStateMachine.this.db.println("--------------------------------");
        }

        public final void dumpObservers() {
        }
    }

    private class TermObserver
    implements IObserver,
    Observer {
        int event;

        public TermObserver(int n) {
            this.event = n;
        }

        public void update(IObservable iObservable, Object object) {
            this._update(iObservable, object);
        }

        @Override
        public void update(Observable observable, Object object) {
            this._update(observable, object);
        }

        private void _update(Object object, Object object2) {
            if (object2 == ModelUpdateType.DELETED) {
                if (LinkStateMachine.this.db.on()) {
                    LinkStateMachine.this.db.println("update: received DELETED event from " + object.getClass().getName());
                }
                LinkStateMachine.this.driveSm(this.event);
            } else if (object2 == ModelUpdateType.CHANGED) {
                LinkStateMachine.this.db.info("update: received unexpected CHANGED event from " + object);
            } else if (object2 == ModelUpdateType.ADDED) {
                if (LinkStateMachine.this.db.on()) {
                    LinkStateMachine.this.db.println("update: received ADDED event from " + object);
                }
                LinkStateMachine.this.registerSrcWithTerm();
                LinkStateMachine.this.registerDstWithTerm();
            }
        }
    }
}

