/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.OchTrailHelper;
import cerent.cms.model.OchncHelper;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.route.RoutePrefs;
import cerent.cms.route.SptCompositeNetLink;
import cerent.cms.route.xLinkNotUsable;
import cerent.cms.topo.DwdmNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LmpDataLinkNetLink;
import cerent.cms.topo.VirtualNetLink;
import cerent.cms.ui.Wavelength;
import cerent.util.DetailedLog;
import cerent.util.SDebug;
import java.util.Collection;
import java.util.Iterator;

public class OchncFilterManager {
    private INetLink myLink;
    private SDebug myDb;

    public OchncFilterManager(INetLink iNetLink, SDebug sDebug) {
        this.myLink = iNetLink;
        this.myDb = sDebug;
    }

    public static INetLink findLinkForReversePath(INetLink iNetLink, SDebug sDebug) {
        return new OchncFilterManager(null, sDebug).findLinkForReversePath(iNetLink);
    }

    private INetLink findLinkForReversePath(INetLink iNetLink) {
        if (this.myDb.on()) {
            this.myDb.println("Called findLinkForReversePath for " + iNetLink);
        }
        INetLink iNetLink2 = null;
        Collection collection = iNetLink.getDst().getAdjacencyList();
        Iterator iterator = collection.iterator();
        boolean bl = false;
        boolean bl2 = false;
        int n = -1;
        int n2 = -1;
        if (iNetLink instanceof LmpDataLinkNetLink) {
            bl2 = true;
        }
        if (iNetLink.isVirtual()) {
            VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink;
            try {
                bl = virtualNetLink.isBetweenOtsPorts();
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                this.myDb.warning("Cannot get if " + iNetLink + " is between OTS ports: " + abstractCmsNoSuchEntityException.getMessage());
                return null;
            }
            if (bl) {
                try {
                    n = iNetLink.getSrc().getNodeModel().getINodeOpticsTopologyModel().getSideForOtsPort(iNetLink.getSrcEntityIndex());
                }
                catch (Exception exception) {
                    this.myDb.warning("[" + iNetLink + "]Cannot get side for OTS source port " + Integer.toHexString(iNetLink.getSrcEntityIndex()) + ": " + exception.getMessage());
                    return null;
                }
                try {
                    n2 = iNetLink.getDst().getNodeModel().getINodeOpticsTopologyModel().getSideForOtsPort(iNetLink.getDstEntityIndex());
                }
                catch (Exception exception) {
                    this.myDb.warning("[" + iNetLink + "]Cannot get side for OTS destination port " + Integer.toHexString(iNetLink.getDstEntityIndex()) + ": " + exception.getMessage());
                    return null;
                }
            }
            if (this.myDb.isFinestEnabled()) {
                this.myDb.finest("Link sides are: " + n + " and " + n2);
            }
        }
        while (iterator.hasNext()) {
            int n3;
            int n4;
            int n5;
            INetLink iNetLink3 = (INetLink)iterator.next();
            if (this.myDb.isFinestEnabled()) {
                this.myDb.finest("Trying adjacent link  " + iNetLink3);
            }
            if (((Object)iNetLink3).equals(iNetLink)) continue;
            if (((Object)iNetLink3).equals(iNetLink.getReverseLink())) {
                if (!this.myDb.isFinestEnabled()) continue;
                this.myDb.finest("Reverse link skipped");
                continue;
            }
            if (iNetLink3.getSrc().getNodeId() != iNetLink.getSrc().getNodeId() && iNetLink3.getSrc().getNodeId() != iNetLink.getDst().getNodeId()) {
                if (!this.myDb.isFinestEnabled()) continue;
                this.myDb.finest("Different Src nodes - skipped");
                continue;
            }
            if (iNetLink3.getDst().getNodeId() != iNetLink.getSrc().getNodeId() && iNetLink3.getDst().getNodeId() != iNetLink.getDst().getNodeId()) {
                if (!this.myDb.isFinestEnabled()) continue;
                this.myDb.finest("Different Dst nodes - skipped");
                continue;
            }
            if (bl2 && iNetLink3 instanceof LmpDataLinkNetLink) {
                try {
                    int n6 = iNetLink.getLinkModel().srcEntityIndex();
                    n5 = iNetLink.getLinkModel().dstEntityIndex();
                    n4 = iNetLink3.getLinkModel().srcEntityIndex();
                    n3 = iNetLink3.getLinkModel().dstEntityIndex();
                    if (n5 != n4 && n6 != n5 && n6 != n4 && n6 != n3) continue;
                    iNetLink2 = iNetLink3;
                    break;
                }
                catch (Exception exception) {
                    continue;
                }
            }
            if (iNetLink3.isVirtual() && iNetLink.isVirtual()) {
                VirtualNetLink virtualNetLink = (VirtualNetLink)iNetLink3;
                try {
                    n5 = virtualNetLink.isBetweenOtsPorts() ? 1 : 0;
                }
                catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                    this.myDb.warning("Cannot get if " + iNetLink3 + " is between OTS ports: " + abstractCmsNoSuchEntityException.getMessage());
                    continue;
                }
                if (bl && n5 != 0) {
                    try {
                        n4 = iNetLink3.getSrc().getNodeModel().getINodeOpticsTopologyModel().getSideForOtsPort(iNetLink3.getSrcEntityIndex());
                    }
                    catch (Exception exception) {
                        this.myDb.warning("[" + iNetLink3 + "]Cannot get side for OTS source port " + Integer.toHexString(iNetLink3.getSrcEntityIndex()) + ": " + exception.getMessage());
                        continue;
                    }
                    try {
                        n3 = iNetLink3.getDst().getNodeModel().getINodeOpticsTopologyModel().getSideForOtsPort(iNetLink3.getDstEntityIndex());
                    }
                    catch (Exception exception) {
                        this.myDb.warning("[" + iNetLink3 + "]Cannot get side for OTS destination port " + Integer.toHexString(iNetLink3.getDstEntityIndex()) + ": " + exception.getMessage());
                        continue;
                    }
                    if (this.myDb.isFinestEnabled()) {
                        this.myDb.finest("Tmp Link sides are: " + n4 + " and " + n3);
                    }
                    if (iNetLink.getSrc().getNodeId() == iNetLink3.getSrc().getNodeId()) {
                        if (n != n4 || n2 != n3) continue;
                        iNetLink2 = iNetLink3;
                        break;
                    }
                    if (iNetLink.getSrc().getNodeId() != iNetLink3.getDst().getNodeId() || n != n3 || n2 != n4) continue;
                    iNetLink2 = iNetLink3;
                    break;
                }
                if (!bl && n5 == 0) {
                    try {
                        if (!VirtualLinksDirector.arePeers((VirtualNetLink)iNetLink, virtualNetLink)) continue;
                        if (this.myDb.isFinestEnabled()) {
                            this.myDb.finest("Links are peer");
                        }
                        iNetLink2 = iNetLink3;
                        break;
                    }
                    catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                        this.myDb.warning("Cannot get if " + iNetLink + " and " + iNetLink3 + " are VL peers: " + abstractCmsNoSuchEntityException.getMessage());
                        continue;
                    }
                }
                if (!this.myDb.isFinestEnabled()) continue;
                this.myDb.finest("Discarded since isOts2OtsVl = " + bl + " and isTmpOts2OtsVl = " + (n5 != 0));
                continue;
            }
            if (!(iNetLink3 instanceof DwdmNetLink) || !(iNetLink instanceof DwdmNetLink)) continue;
            int n7 = 0;
            n5 = 0;
            n4 = 0;
            n3 = 0;
            try {
                n7 = this.getShelfId(iNetLink.getSrc(), iNetLink.getSrcEntityIndex());
                n5 = this.getShelfId(iNetLink.getDst(), iNetLink.getDstEntityIndex());
                n4 = this.getShelfId(iNetLink3.getSrc(), iNetLink3.getSrcEntityIndex());
                n3 = this.getShelfId(iNetLink3.getDst(), iNetLink3.getDstEntityIndex());
            }
            catch (Exception exception) {
                this.myDb.warning("Cannot get shelf ID: " + exception.getMessage());
                continue;
            }
            if (iNetLink3.getSrc().getNodeId() != iNetLink.getDst().getNodeId() || iNetLink3.getDst().getNodeId() != iNetLink.getSrc().getNodeId() || n7 != n3 || n5 != n4 || iNetLink3.getSrcSlotNumber() != iNetLink.getDstSlotNumber() || iNetLink3.getDstSlotNumber() != iNetLink.getSrcSlotNumber() || iNetLink3.getProtectionRole() != iNetLink.getProtectionRole()) continue;
            iNetLink2 = iNetLink3;
            break;
        }
        if (this.myDb.on()) {
            this.myDb.println("Opposite link is " + iNetLink2);
        }
        return iNetLink2;
    }

    private int getShelfId(INetElement iNetElement, int n) throws Exception {
        int n2 = 0;
        INodeModel iNodeModel = iNetElement.getNodeModel();
        if (iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf()) {
            IEntityModel iEntityModel = this.getEntityModel(iNetElement, n);
            n2 = iEntityModel.getShelfId();
        }
        if (this.myDb.isFinestEnabled()) {
            this.myDb.finest("getShelfId(" + iNetElement.getName() + ", " + Integer.toHexString(n) + ") = " + n2);
        }
        return n2;
    }

    private IEntityModel getEntityModel(INetElement iNetElement, int n) throws Exception {
        IEntityModel iEntityModel = null;
        iEntityModel = iNetElement.getNodeModel().getEntityTable().getEntityModelByIndex(n);
        return iEntityModel;
    }

    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("========================= isUsable called");
        }
        try {
            this.doIsUsable(routePrefs, iNetLink);
            if (this.myDb.on()) {
                this.myDb.println("========================= isUsable");
            }
        }
        catch (xLinkNotUsable xLinkNotUsable2) {
            if (this.myDb.on()) {
                this.myDb.println("========================= is not usable: " + xLinkNotUsable2.getString() + "\n=========================");
            }
            throw xLinkNotUsable2;
        }
        return true;
    }

    public boolean doIsUsable(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (!routePrefs.isOchncCircuit() && !routePrefs.isOchTrailTunnelCircuit()) {
            throw new xLinkNotUsable("Usable only for OCHNC and OCH-Trail circuits");
        }
        if (iNetLink != null && iNetLink.isTemporarySptLink()) {
            iNetLink = ((SptCompositeNetLink)iNetLink).getLastLink();
        }
        if (!(iNetLink == null || iNetLink instanceof DwdmNetLink || iNetLink instanceof VirtualNetLink || routePrefs.isOchTrailTunnelCircuit() || iNetLink instanceof LmpDataLinkNetLink)) {
            throw new xLinkNotUsable("Parent link " + iNetLink + " must be OTS/PPC link");
        }
        if (this.myLink.state() != 1) {
            throw new xLinkNotUsable("Link is Not UP");
        }
        if (!this.myLink.getDst().getConnectionState()) {
            throw new xLinkNotUsable("Destination Node not connected");
        }
        if (!this.myLink.getSrc().getConnectionState()) {
            throw new xLinkNotUsable("Source Node not connected");
        }
        INetLink iNetLink2 = null;
        if (this.isBidirectional(routePrefs) && (iNetLink2 = this.findLinkForReversePath(this.myLink)) == null) {
            throw new xLinkNotUsable("Opposite link not found");
        }
        if (this.myLink.getSrc().getNodeId() == routePrefs.getSrc().getNodeId()) {
            this.checkSrcConnections(routePrefs, iNetLink2);
        }
        if (iNetLink != null) {
            this.checkOchncConnections(routePrefs, iNetLink, iNetLink2);
        }
        if (this.myLink.getDst().getNodeId() == routePrefs.getDst().getNodeId()) {
            this.checkDstConnections(routePrefs, iNetLink2);
        }
        return true;
    }

    private void checkSrcConnections(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("First link check on source node " + this.myLink.getSrc().getName());
        }
        if (routePrefs.isOchncCircuit()) {
            this.checkOchncSrcConnections(routePrefs, iNetLink);
        } else {
            this.checkOchTrailSrcConnections(routePrefs, iNetLink);
        }
        if (this.myDb.on()) {
            this.myDb.println("First link check completed");
        }
    }

    private void checkDstConnections(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("Last link check on destination node " + this.myLink.getDst().getName());
        }
        if (routePrefs.isOchncCircuit()) {
            this.checkOchncDstConnections(routePrefs, iNetLink);
        } else {
            this.checkOchTrailDstConnections(routePrefs, iNetLink);
        }
        if (this.myDb.on()) {
            this.myDb.println("Last link check completed");
        }
    }

    private void checkOchncSrcConnections(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("============> Forward check");
            this.myDb.println("First link check for forward link " + this.myLink);
        }
        OchncHelper.checkAreConnectedByOCHNCPath(routePrefs.getSrc(), routePrefs.getcktSrcEntityIndex(), this.myLink.getSrcEntityIndex(), routePrefs.getcktOptChannel());
        if (this.myDb.on()) {
            this.myDb.println("<============ Forward check");
        }
        if (iNetLink != null) {
            if (this.myDb.on()) {
                this.myDb.println("============> Reverse check");
                this.myDb.println("First link check for reverse link " + iNetLink);
            }
            try {
                OchncHelper.checkAreConnectedByOCHNCPath(routePrefs.getSrc(), routePrefs.getcktSecDstEntityIndex(), iNetLink.getDstEntityIndex(), routePrefs.getcktOptChannel());
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                this.handleOppositeNotUsable(xLinkNotUsable2, iNetLink);
            }
            if (this.myDb.on()) {
                this.myDb.println("<============ Reverse check");
            }
        }
    }

    private void checkOchncDstConnections(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("============> Forward check");
            this.myDb.println("Last link check for forward link " + this.myLink);
        }
        OchncHelper.checkAreConnectedByOCHNCPath(routePrefs.getDst(), routePrefs.getcktDstEntityIndex(), this.myLink.getDstEntityIndex(), routePrefs.getcktOptChannel());
        if (this.myDb.on()) {
            this.myDb.println("<============ Forward check");
        }
        if (iNetLink != null) {
            if (this.myDb.on()) {
                this.myDb.println("============> Reverse check");
                this.myDb.println("Last link check for reverse link " + iNetLink);
            }
            try {
                OchncHelper.checkAreConnectedByOCHNCPath(routePrefs.getDst(), routePrefs.getcktSecSrcEntityIndex(), iNetLink.getSrcEntityIndex(), routePrefs.getcktOptChannel());
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                this.handleOppositeNotUsable(xLinkNotUsable2, iNetLink);
            }
            if (this.myDb.on()) {
                this.myDb.println("<============ Reverse check");
            }
        }
    }

    private void checkOchTrailSrcConnections(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        INetElement iNetElement = routePrefs.getSrc();
        int n = this.myLink.getSrcEntityIndex();
        int n2 = routePrefs.getcktSrcEntityIndex();
        int n3 = routePrefs.getcktOptChannel();
        if (this.myLink.isVirtual() && !((VirtualNetLink)this.myLink).isSrcPortTX()) {
            throw new xLinkNotUsable("Link is not exiting the node.");
        }
        if (this.myDb.on()) {
            this.myDb.println("============> Forward check");
            this.myDb.println("First link check for forward link " + this.myLink);
        }
        this.checkOchTrailSrcDstConnections(iNetElement, n, n2, n3);
        if (this.myDb.on()) {
            this.myDb.println("<============ Forward check");
        }
        if (this.myDb.on()) {
            this.myDb.println("============> Reverse check");
            this.myDb.println("First link check for reverse link " + iNetLink);
        }
        try {
            n = iNetLink.getDstEntityIndex();
            this.checkOchTrailSrcDstConnections(iNetElement, n, n2, n3);
        }
        catch (xLinkNotUsable xLinkNotUsable2) {
            this.handleOppositeNotUsable(xLinkNotUsable2, iNetLink);
        }
        if (this.myDb.on()) {
            this.myDb.println("<============ Reverse check");
        }
    }

    private void checkOchTrailDstConnections(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        INetElement iNetElement = routePrefs.getDst();
        int n = this.myLink.getDstEntityIndex();
        int n2 = routePrefs.getcktDstEntityIndex();
        int n3 = routePrefs.getcktOptChannel();
        if (this.myDb.on()) {
            this.myDb.println("============> Forward check");
            this.myDb.println("Last link check for forward link " + this.myLink);
        }
        this.checkOchTrailSrcDstConnections(iNetElement, n, n2, n3);
        if (this.myDb.on()) {
            this.myDb.println("<============ Forward check");
        }
        if (this.myDb.on()) {
            this.myDb.println("============> Reverse check");
            this.myDb.println("Last link check for reverse link " + iNetLink);
        }
        try {
            n = iNetLink.getSrcEntityIndex();
            this.checkOchTrailSrcDstConnections(iNetElement, n, n2, n3);
        }
        catch (xLinkNotUsable xLinkNotUsable2) {
            this.handleOppositeNotUsable(xLinkNotUsable2, iNetLink);
        }
        if (this.myDb.on()) {
            this.myDb.println("============> Reverse check");
        }
    }

    private void checkOchTrailSrcDstConnections(INetElement iNetElement, int n, int n2, int n3) throws xLinkNotUsable {
        int[] nArray;
        if (this.myDb.on()) {
            this.myDb.println("checkOchTrailSrcDstConnections(" + iNetElement.getName() + ", " + Integer.toHexString(n) + ", " + Integer.toHexString(n2) + ", " + Wavelength.getWavelengthStringFromWavelength(n3) + ")");
        }
        if (n == n2) {
            if (this.myLink.isVirtual()) {
                if (this.myDb.on()) {
                    this.myDb.println("Link starts/terminates on circuit port " + Integer.toHexString(n));
                }
                return;
            }
            throw new xLinkNotUsable("Cannot start/terminate on circuit endpoints");
        }
        try {
            nArray = OchTrailHelper.getColocatedOchPorts(iNetElement, n2);
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            throw new xLinkNotUsable("Cannot get OCH ports for trunk port " + Integer.toHexString(n2) + " on node " + iNetElement.getName() + ": " + abstractCmsNoSuchEntityException.getMessage());
        }
        catch (FeatureUnsupported featureUnsupported) {
            throw new xLinkNotUsable("Cannot get OCH ports for trunk port " + Integer.toHexString(n2) + " on node " + iNetElement.getName() + ": " + featureUnsupported.getMessage());
        }
        catch (NoSuchInterface noSuchInterface) {
            throw new xLinkNotUsable("Cannot get OCH ports for trunk port " + Integer.toHexString(n2) + " on node " + iNetElement.getName() + ": " + noSuchInterface.getMessage());
        }
        if (nArray.length == 0) {
            throw new xLinkNotUsable("Trunk " + Integer.toHexString(n2) + " on node " + iNetElement.getName() + " is not colocated");
        }
        for (int i = 0; i < nArray.length; ++i) {
            try {
                if (this.myDb.on()) {
                    this.myDb.println("Checking internal OCHNC path for OCH port " + Integer.toHexString(nArray[i]));
                }
                OchncHelper.checkAreConnectedByOCHNCPath(iNetElement, nArray[i], n, n3);
                if (this.myDb.on()) {
                    this.myDb.println("Internal OCHNC path found");
                }
                return;
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                if (!this.myDb.on()) continue;
                this.myDb.println("Internal OCHNC path not found");
                continue;
            }
        }
        throw new xLinkNotUsable("Not connected through internal patchcords to the circuit on node " + iNetElement.getName());
    }

    private void checkOchncConnections(RoutePrefs routePrefs, INetLink iNetLink, INetLink iNetLink2) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("checkOchncConnections(" + iNetLink + ", " + iNetLink2 + ")");
        }
        this.myLink.containsSrg(routePrefs.getExcludeSrgs());
        if (this.myDb.on()) {
            this.myDb.println("============> Forward check");
        }
        this.checkOchncPath(routePrefs, iNetLink);
        if (this.myDb.on()) {
            this.myDb.println("<============ Forward check");
        }
        if (iNetLink2 != null) {
            if (this.myDb.on()) {
                this.myDb.println("============> Reverse check");
            }
            try {
                if (!(iNetLink instanceof LmpDataLinkNetLink)) {
                    INetLink iNetLink3 = this.findLinkForReversePath(iNetLink);
                    if (iNetLink3 == null) {
                        throw new xLinkNotUsable("No opposite link found for previous link " + iNetLink);
                    }
                    OchncFilterManager ochncFilterManager = new OchncFilterManager(iNetLink2, this.myDb);
                    ochncFilterManager.checkOchncPath(routePrefs, iNetLink3);
                }
            }
            catch (xLinkNotUsable xLinkNotUsable2) {
                this.handleOppositeNotUsable(xLinkNotUsable2, iNetLink2);
            }
            if (this.myDb.on()) {
                this.myDb.println("<============ Reverse check");
            }
        }
    }

    private void checkOchncPath(RoutePrefs routePrefs, INetLink iNetLink) throws xLinkNotUsable {
        int n;
        int n2;
        int n3 = routePrefs.getcktOptChannel();
        if (this.myDb.on()) {
            this.myDb.println("Checking available OCHNC path from parent: " + (iNetLink == null ? "-" : "\n\t" + iNetLink.prettyString()) + "\n\tto " + this.myLink.prettyString() + "\nfor channel " + Wavelength.getWavelengthStringFromWavelength(n3));
        }
        INetElement iNetElement = null;
        if (this.myLink.getSrc().getNodeId() == iNetLink.getDst().getNodeId()) {
            iNetElement = this.myLink.getSrc();
            n2 = iNetLink.getDstEntityIndex();
            n = this.myLink.getSrcEntityIndex();
        } else if (this.myLink.getDst().getNodeId() == iNetLink.getSrc().getNodeId()) {
            iNetElement = this.myLink.getDst();
            n2 = iNetLink.getSrcEntityIndex();
            n = this.myLink.getDstEntityIndex();
        } else {
            throw new xLinkNotUsable("No common NE with parent link " + iNetLink.toString());
        }
        OchncHelper.checkAreConnectedByOCHNCPath(iNetElement, n2, n, n3);
        if (this.myDb.on()) {
            this.myDb.println("OCHNC path found");
        }
    }

    private boolean isBidirectional(RoutePrefs routePrefs) {
        return routePrefs.isOchTrailTunnelCircuit() || routePrefs.isOchncCircuit() && routePrefs.getDirectionality() == 3;
    }

    private void handleOppositeNotUsable(xLinkNotUsable xLinkNotUsable2, INetLink iNetLink) throws xLinkNotUsable {
        if (this.myDb.on()) {
            this.myDb.println("Check failed on opposite link " + iNetLink + ": " + xLinkNotUsable2.getString());
        }
        DetailedLog detailedLog = new DetailedLog(3, iNetLink.prettyString() + ": " + xLinkNotUsable2.getString());
        throw new xLinkNotUsable("Opposite link not usable", detailedLog);
    }
}

