/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsCommFailException;
import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.IOhTermModel;
import cerent.cms.model.ITermConnectionModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.NodeModel;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.LinkStateMachine;
import cerent.cms.topo.Network;
import cerent.util.IObservable;
import cerent.util.SDebug;

public class OscLinkStateMachine
extends LinkStateMachine {
    private IOhTermModel srcObs;
    private IOhTermModel dstObs;
    private ITermConnectionModel srcTerm;
    private ITermConnectionModel dstTerm;

    public OscLinkStateMachine(Network network, INetLink iNetLink, SDebug sDebug) {
        super(network, iNetLink, sDebug);
    }

    @Override
    protected void registerSrcWithTerm() {
        NodeModel nodeModel = (NodeModel)this.link.getSrc().getNodeModel();
        if (this.srcState == 1) {
            if (this.link.getSrc().getConnectionState()) {
                try {
                    this.srcTerm = nodeModel.getOscTermConnectionModel();
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerSrcWithTerm: src caught Comm Fail exception");
                }
                if (this.srcTerm != null) {
                    int n = this.link.getSrcEntityIndex();
                    ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                    modelIndirectObservable.addObserver((IObservable)this.srcTerm, this.srcTermObserver);
                    try {
                        this.srcObs = this.srcTerm.getTermModel(n);
                        if (this.srcObs == null) {
                            if (this.db.on()) {
                                this.db.println("registerSrcWithTerm: cannot find OhTermModel with index " + n);
                            }
                            return;
                        }
                        modelIndirectObservable.addObserver((IObservable)this.srcObs, this.srcTermObserver);
                        if (this.db.on()) {
                            this.db.println("registerSrcWithTerm: registered with NE " + this.link.getSrc().getHostName() + " OSC on index " + this.link.getSrcEntityIndex());
                        }
                        this.srcState = 2;
                        this.link.getSrc().deleteObserver(this);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        this.db.println("registerSrcWithTerm: caught IO exception while adding OSC observer");
                    }
                } else if (this.db.on()) {
                    this.db.println("registerSrcWithTerm: failed to register with NE " + this.link.getSrc().getHostName() + " OSC, OSC = null");
                }
            } else if (this.db.on()) {
                this.db.println("registerSrcWithTerm: failed to register with NE " + this.link.getSrc().getHostName() + " OSC, NE not ready");
            }
        } else if (this.db.on()) {
            this.db.println("registerSrcWithTerm: invalid srcState = " + this.srcState);
        }
    }

    @Override
    protected void registerDstWithTerm() {
        NodeModel nodeModel = (NodeModel)this.link.getDst().getNodeModel();
        if (this.dstState == 1) {
            if (this.link.getDst().getConnectionState()) {
                try {
                    this.dstTerm = nodeModel.getOscTermConnectionModel();
                }
                catch (AbstractCmsCommFailException abstractCmsCommFailException) {
                    this.db.println("registerDstWithTerm: dst caught Comm Fail exception");
                }
                if (this.dstTerm != null) {
                    int n = this.link.getDstEntityIndex();
                    ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                    modelIndirectObservable.addObserver((IObservable)this.dstTerm, this.dstTermObserver);
                    try {
                        this.dstObs = this.dstTerm.getTermModel(n);
                        if (this.dstObs == null) {
                            if (this.db.on()) {
                                this.db.println("registerDstWithTerm: cannot find OhTermModel with index " + n);
                            }
                            return;
                        }
                        modelIndirectObservable.addObserver((IObservable)this.dstObs, this.dstTermObserver);
                        if (this.db.on()) {
                            this.db.println("registerDstWithTerm: registered with NE " + this.link.getDst().getHostName() + " OSC on index " + n);
                        }
                        this.dstState = 2;
                        this.link.getDst().deleteObserver(this);
                    }
                    catch (AbstractCmsIOException abstractCmsIOException) {
                        this.db.println("registerDstWithTerm: caught IO exception while adding OSC observer");
                    }
                } else if (this.db.on()) {
                    this.db.println("registerDstWithTerm: failed to register with NE " + this.link.getDst().getHostName() + " OSC, OSC = null");
                }
            } else if (this.db.on()) {
                this.db.println("registerDstWithTerm: failed to register with NE " + this.link.getDst().getHostName() + " OSC, NE not ready");
            }
        } else if (this.db.on()) {
            this.db.println("registerDstWithTerm: invalid dstState = " + this.dstState);
        }
    }

    @Override
    protected void deregisterSrcWithTerm() {
        if (this.srcState == 2) {
            int n = this.link.getSrcEntityIndex();
            if (this.srcTerm != null) {
                if (this.db != null && this.db.on()) {
                    this.db.println("deregisterSrcWithTerm: removing OSC observer on index " + n);
                }
                ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                try {
                    if (this.srcObs != null) {
                        modelIndirectObservable.deleteObserver((IObservable)this.srcObs, this.srcTermObserver);
                    } else if (this.db.on()) {
                        this.db.println("deregisterSrcWithTerm: cannot find OhTermModel with index " + n);
                    }
                    modelIndirectObservable.deleteObserver((IObservable)this.srcTerm, this.srcTermObserver);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("deregisterSrcWithTerm: Comm Fail while deleting srcTerm observer");
                }
                this.srcTerm = null;
                this.link.getSrc().addObserver(this);
                this.srcState = 1;
            }
        }
    }

    @Override
    protected void deregisterDstWithTerm() {
        if (this.dstState == 2) {
            int n = this.link.getDstEntityIndex();
            if (this.dstTerm != null) {
                if (this.db != null && this.db.on()) {
                    this.db.println("deregisterDstWithTerm: removing OSC observer on index " + n);
                }
                ModelIndirectObservable modelIndirectObservable = ModelIndirectObservable.instance();
                try {
                    if (this.dstObs != null) {
                        modelIndirectObservable.deleteObserver((IObservable)this.dstObs, this.dstTermObserver);
                    } else if (this.db.on()) {
                        this.db.println("deregisterDstWithTerm: cannot find OhTermModel with index " + n);
                    }
                    modelIndirectObservable.deleteObserver((IObservable)this.dstTerm, this.dstTermObserver);
                }
                catch (AbstractCmsIOException abstractCmsIOException) {
                    this.db.println("deregisterDstWithTerm: Comm Fail while deleting srcTerm observer");
                }
                this.dstTerm = null;
                this.link.getDst().addObserver(this);
                this.dstState = 1;
            }
        }
    }
}

