/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.AbstractCmsNoSuchElementException;
import cerent.cms.model.AbstractCmsNoSuchEntityException;
import cerent.cms.model.AbstractCmsObjectNotExistException;
import cerent.cms.model.CmsObservable;
import cerent.cms.model.Feature;
import cerent.cms.model.IBlsrModel;
import cerent.cms.model.IBlsrProtectionOp;
import cerent.cms.model.IElementModel;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.IEntityTableModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.IOnePlusOneModel;
import cerent.cms.model.IProtectionOp;
import cerent.cms.model.ITdmPortModel;
import cerent.cms.model.ModelIndirectObservable;
import cerent.cms.model.ModelUpdateType;
import cerent.cms.model.VirtualLinksDirector;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.NetLink;
import cerent.util.EnumStrings;
import cerent.util.IObservable;
import cerent.util.IObserver;
import cerent.util.SDebug;

public class ProtectionSwitchStateHelper
extends CmsObservable
implements IObserver {
    private NetLink nl;
    private INetElement ne;
    private int entIdx;
    private SDebug db;
    private IElementModel eleModel;
    private boolean eleModelObserved;
    private int state = -1;

    public ProtectionSwitchStateHelper(NetLink netLink, INetElement iNetElement, int n, SDebug sDebug) {
        this.nl = netLink;
        this.ne = iNetElement;
        this.entIdx = n;
        this.db = sDebug;
        this.eleModel = null;
        this.eleModelObserved = false;
        if (sDebug.on()) {
            sDebug.println("ProtectionSwitchStateHelper: creating new helper for NE " + iNetElement.getActualAddressDisplay() + ", entIdx " + n);
        }
        this.registerWithEM();
    }

    public int getState() {
        if (this.db.on()) {
            this.db.println("in getState() : returning state=" + this.state);
        }
        return this.state;
    }

    public String getStateAsString() {
        if (this.state != -1) {
            if (this.nl.isBlsr()) {
                return EnumStrings.getString(IBlsrProtectionOp.class, (int)this.state);
            }
            if (this.nl.isOnePlusOne()) {
                return "OnePlusOne_" + EnumStrings.getString(IProtectionOp.class, (int)this.state);
            }
        }
        return "UNKNOWN_PROTECTION_STATE:" + this.state;
    }

    protected void updateState() {
        int n;
        if (this.db.on()) {
            this.db.println((Object)((Object)this) + " in updateState()");
        }
        if ((n = this.getNewState()) != this.state) {
            if (this.db.on()) {
                this.db.println(" state changed from " + this.state + " -> " + n);
            }
            this.state = n;
            this.setChanged();
            this.notifyObservers(ModelUpdateType.CHANGED);
        } else if (this.db.on()) {
            this.db.println(" state unchanged from " + this.state + " to: " + n);
        }
    }

    private int getNewState() {
        INodeModel iNodeModel = this.ne.getNodeModel();
        if (this.db.on()) {
            this.db.println("getState (ProtectionSwitch): " + this.ne.getActualAddressDisplay() + ", " + " EntIdx: " + Integer.toHexString(this.entIdx));
        }
        if (!Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SPAN_PROT_DISPLAY) || !iNodeModel.isInited()) {
            if (this.db.on()) {
                this.db.println("getState (ProtectionSwitch): Feature.SPAN_PROT_DISPLAY not supported or node not inited: ");
            }
            return -1;
        }
        try {
            if (this.eleModel != null) {
                if (this.eleModel instanceof IBlsrModel) {
                    IBlsrModel iBlsrModel = (IBlsrModel)this.eleModel;
                    IEntityModel iEntityModel = iBlsrModel.getEastEntityModel();
                    IEntityModel iEntityModel2 = iBlsrModel.getWestEntityModel();
                    IEntityModel iEntityModel3 = iBlsrModel.getEastProtectEntityModel();
                    IEntityModel iEntityModel4 = iBlsrModel.getWestProtectEntityModel();
                    if (this.entIdx == iEntityModel.getEntityIndex() || iEntityModel3 != null && this.entIdx == iEntityModel3.getEntityIndex()) {
                        return iBlsrModel.getBlsrEastProtectionOp().getKOp();
                    }
                    if (this.entIdx == iEntityModel2.getEntityIndex() || iEntityModel4 != null && this.entIdx == iEntityModel4.getEntityIndex()) {
                        return iBlsrModel.getBlsrWestProtectionOp().getKOp();
                    }
                    if (this.db.on()) {
                        this.db.println("getState (ProtectionSwitch): EntIdx : " + Integer.toHexString(this.entIdx) + " not " + "part of BLSR on " + this.ne.getActualAddressDisplay());
                    }
                    return -1;
                }
                if (this.eleModel instanceof IOnePlusOneModel) {
                    return ((IOnePlusOneModel)this.eleModel).getProtection();
                }
                if (this.db.on()) {
                    this.db.println("getState (ProtectionSwitch): EntIdx : " + Integer.toHexString(this.entIdx) + " not part " + "of BLSR or 1+1 on " + this.ne.getActualAddressDisplay());
                }
                return -1;
            }
            if (this.db.on()) {
                this.db.println("getState (ProtectionSwitch): eleModel is null");
            }
        }
        catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
            }
            this.db.println("getState (ProtectionSwitch): No such entity for ent idx => " + this.entIdx);
            return -1;
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (this.db.on()) {
                SDebug.printStackTrace((Throwable)abstractCmsIOException);
            }
            this.db.println("getState (ProtectionSwitch): Comm error attempting to get EM for ent idx => " + this.entIdx);
            return -1;
        }
        if (this.db.on()) {
            this.db.println("getState (ProtectionSwitch): No valid value, returning -1");
        }
        return -1;
    }

    protected void registerWithEM() {
        INodeModel iNodeModel;
        if (this.eleModelObserved) {
            if (this.db.on()) {
                this.db.println("registerWithEM: Already observing Element Model");
            }
            return;
        }
        boolean bl = true;
        if (this.db.on()) {
            this.db.println("registerWithEM: attempting to observe Element Model");
        }
        if ((iNodeModel = this.ne.getNodeModel()).isInited()) {
            try {
                IEntityModel iEntityModel;
                IEntityTableModel iEntityTableModel = iNodeModel.getEntityTable();
                if (iEntityTableModel != null && (iEntityModel = iEntityTableModel.getEntityModelByIndex(this.entIdx)) != null && iEntityModel instanceof ITdmPortModel) {
                    if (Feature.provides((INodeModel)iNodeModel, (Feature)Feature.SPAN_PROT_DISPLAY)) {
                        IEntityModel iEntityModel2 = VirtualLinksDirector.instance().isProtected(iEntityModel);
                        if (iEntityModel2 != null) {
                            if (this.db.on()) {
                                this.db.println("registerWithEM: observing protect EntityModel (protection group)");
                            }
                            iEntityModel2.addObserver((IObserver)this);
                        }
                        ITdmPortModel iTdmPortModel = (ITdmPortModel)iEntityModel;
                        this.eleModel = iTdmPortModel.getElementModel();
                        if (this.eleModel instanceof IBlsrModel || this.eleModel instanceof IOnePlusOneModel) {
                            ModelIndirectObservable.instance().addObserver((IObservable)this.eleModel, this);
                            if (this.db.on()) {
                                this.db.println("registerWithEM: observing ElementModel" + this.ne.getActualAddressDisplay());
                            }
                            this.eleModelObserved = true;
                            this.ne.deleteObserver(this);
                        } else {
                            bl = false;
                            if (this.db.on()) {
                                this.db.println("registerWithEM: link unprotected, no need to observe ElementModel");
                            }
                        }
                    } else if (this.db.on()) {
                        this.db.println("registerWithEM: Feature.SPAN_PROT_DISPLAY not supported on " + this.ne.getActualAddressDisplay());
                    }
                }
            }
            catch (AbstractCmsNoSuchEntityException abstractCmsNoSuchEntityException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchEntityException);
                }
                this.db.println("registerWithEM: No such entity for ent idx => " + this.entIdx);
            }
            catch (AbstractCmsNoSuchElementException abstractCmsNoSuchElementException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsNoSuchElementException);
                }
                this.db.println("registerWithEM: No such element for ent idx => " + this.entIdx);
            }
            catch (AbstractCmsObjectNotExistException abstractCmsObjectNotExistException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsObjectNotExistException);
                }
                this.db.println("registerWithEM: No such object for ent idx => " + this.entIdx);
            }
            catch (AbstractCmsIOException abstractCmsIOException) {
                if (this.db.on()) {
                    SDebug.printStackTrace((Throwable)abstractCmsIOException);
                }
                this.db.println("registerWithEM: Comm error attempting to get EM for ent idx => " + this.entIdx);
            }
        }
        if (bl && !this.eleModelObserved) {
            if (this.db.on()) {
                this.db.println("registerWithEM: observing NE " + this.ne.getActualAddressDisplay());
            }
            this.ne.addObserver(this);
        }
        this.updateState();
    }

    protected void deregisterWithEM() {
        if (!this.eleModelObserved) {
            if (this.db.on()) {
                this.db.println("deregisterWithEM: Not observing Element Model on NE " + this.ne.getActualAddressDisplay());
            }
            return;
        }
        ModelIndirectObservable.instance().deleteObserver((IObservable)this.eleModel, this);
        if (this.db.on()) {
            this.db.println("deregisterWithEM: deleted ElementModel observation on NE " + this.ne.getActualAddressDisplay());
        }
        this.eleModelObserved = false;
        this.eleModel = null;
    }

    public void dispose() {
        if (this.db.on()) {
            this.db.println("dispose: disposing ProtectionSwitchStateHelper");
        }
        this.deregisterWithEM();
        this.ne.deleteObserver(this);
        this.setChanged();
        this.notifyObservers(ModelUpdateType.DELETED);
    }

    public void update(IObservable iObservable, Object object) {
        if (iObservable instanceof IElementModel) {
            IElementModel iElementModel = (IElementModel)iObservable;
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.db.on()) {
                    this.db.println("ProtectionSwitchHelper.update: received CHANGED event from ElementModel " + iObservable);
                }
                this.updateState();
            } else if (object.equals(ModelUpdateType.DELETED)) {
                if (this.db.on()) {
                    this.db.println("ProtectionSwitchHelper.update: received DELETED event from ElementModel");
                }
                this.deregisterWithEM();
                this.ne.addObserver(this);
                if (this.db.on()) {
                    this.db.println("ProtectionSwitchHelper.update: observing NE " + this.ne.getActualAddressDisplay());
                }
            }
        } else if (iObservable instanceof IEntityModel) {
            IEntityModel iEntityModel = (IEntityModel)iObservable;
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.db.on()) {
                    this.db.println("ProtectionSwitchHelper.update: received CHANGED event from protect entity model");
                }
                this.registerWithEM();
            }
        } else if (iObservable instanceof INetElement) {
            INetElement iNetElement = (INetElement)iObservable;
            if (object.equals(ModelUpdateType.CHANGED)) {
                if (this.db.on()) {
                    this.db.println("ProtectionSwitchHelper.update: received CHANGED event from NE " + iNetElement.getActualAddressDisplay());
                }
                this.registerWithEM();
            } else if (object.equals(ModelUpdateType.DELETED)) {
                if (this.db.on()) {
                    this.db.println("ProtectionSwitchHelper.update: received DELETED event from NE " + iNetElement.getActualAddressDisplay());
                }
                this.dispose();
            }
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("PSSH[" + this.ne.getName() + "(");
        stringBuffer.append(Integer.toHexString(this.entIdx) + ")] : " + this.nl.toString());
        return stringBuffer.toString();
    }
}

