/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.topo;

import cerent.cms.model.ILinkModel;
import cerent.cms.model.INetLinkType;
import cerent.cms.model.IPoolModel;
import cerent.cms.ncp.NetCircuitManager;
import cerent.cms.route.DummyLabelSet;
import cerent.cms.route.ILabelSet;
import cerent.cms.route.INetLinkSpan;
import cerent.cms.route.NoRoute;
import cerent.cms.route.RoutePrefs;
import cerent.cms.topo.AbstractNetLink;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.INetLink;
import cerent.cms.topo.RoutableNetLink;
import cerent.cms.topo.Topology;
import cerent.util.EnumStrings;
import cerent.util.HoLoFactory;
import cerent.util.IHoNum;
import cerent.util.ILabel;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class UPSRLoopLink
extends RoutableNetLink {
    private int framingType;

    public UPSRLoopLink(INetElement iNetElement, INetElement iNetElement2, int n) {
        super(iNetElement, iNetElement2);
        this.framingType = n;
    }

    @Override
    public int getSrcEntityIndex() {
        return 0;
    }

    @Override
    public int[] getSrcPortNumber() {
        return new int[0];
    }

    @Override
    public int getSrcSlotNumber() {
        return 0;
    }

    @Override
    public IHoNum getSrcHo() {
        return HoLoFactory.createFirstHoNum(this.framingType);
    }

    @Override
    public int getDstEntityIndex() {
        return 0;
    }

    @Override
    public int[] getDstPortNumber() {
        return new int[0];
    }

    @Override
    public int getDstSlotNumber() {
        return 0;
    }

    @Override
    public IHoNum getDstHo() {
        return HoLoFactory.createFirstHoNum(this.framingType);
    }

    @Override
    public ILinkModel getLinkModel() {
        return null;
    }

    @Override
    public int getLinkType() {
        return 5;
    }

    @Override
    public ArrayList getLinksList() {
        ArrayList<UPSRLoopLink> arrayList = new ArrayList<UPSRLoopLink>();
        arrayList.add(this);
        return arrayList;
    }

    @Override
    public int getPhysicalType() {
        return 0;
    }

    @Override
    public int getProtectionType() {
        return 3;
    }

    @Override
    public void setProtectionType(int n) {
    }

    @Override
    public boolean isSdccLink() {
        return false;
    }

    @Override
    public int getProtectionGroup() {
        return 0;
    }

    @Override
    public void setPhysicalType(int n) {
    }

    @Override
    public void setCost(int n) {
    }

    @Override
    public int getCost() {
        return 0;
    }

    @Override
    public IPoolModel getSrcPool() {
        return null;
    }

    @Override
    public IPoolModel getDstPool() {
        return null;
    }

    @Override
    public ILabelSet getSrcLabelSet(int n, int n2) {
        return this.getLabelSet(n, n2);
    }

    @Override
    public ILabelSet getDstLabelSet(int n, int n2) {
        return this.getLabelSet(n, n2);
    }

    private ILabelSet getLabelSet(int n, int n2) {
        if (this.db.on()) {
            this.db.println("getLabelSet: Link : " + this.prettyString());
        }
        DummyLabelSet dummyLabelSet = new DummyLabelSet();
        int n3 = NetCircuitManager.instance().calcFramingType(n2, n);
        dummyLabelSet.addLabel((ILabel)HoLoFactory.createFirstHoNum(n3));
        return dummyLabelSet;
    }

    @Override
    public int state() {
        return 1;
    }

    @Override
    public boolean isProtected() {
        return false;
    }

    @Override
    public String prettyString() {
        return this.src.prettyString() + "->" + this.dst.prettyString() + " ( " + EnumStrings.getString(INetLinkType.class, (int)this.getLinkType()) + " ) ";
    }

    @Override
    public boolean isPhysical() {
        return false;
    }

    @Override
    public boolean isLOTunnel() {
        return false;
    }

    @Override
    public boolean isLAP() {
        return false;
    }

    @Override
    public boolean isPhantom() {
        return false;
    }

    @Override
    public boolean isPca() {
        return false;
    }

    @Override
    public boolean isPca(INetElement iNetElement) {
        return false;
    }

    @Override
    public boolean inWorkingBLSR() {
        return false;
    }

    @Override
    public boolean isBlsrCapable() {
        return false;
    }

    @Override
    public boolean isLOCapable() {
        return true;
    }

    public INetLinkSpan getAvailSpan(int n, int n2, boolean bl) throws NoRoute {
        return null;
    }

    @Override
    public INetLinkSpan[] getAllAvailSpans(int n, int n2) {
        return new INetLinkSpan[0];
    }

    @Override
    public boolean isDeleted() {
        return false;
    }

    @Override
    public List getAvailableHoNumbers(int n, int n2) {
        return new LinkedList();
    }

    @Override
    public List getAvailableLoNumbers(IHoNum iHoNum, int n) {
        return new LinkedList();
    }

    @Override
    public boolean canSupportCircuitSize(int n, int n2) {
        return true;
    }

    @Override
    public boolean canSupportCircuitDirection(int n) {
        return true;
    }

    @Override
    public boolean isValidSrcHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public boolean isValidDstHoNumber(IHoNum iHoNum) {
        return true;
    }

    @Override
    public void dispose() {
    }

    @Override
    public long getTimestamp() {
        return 0L;
    }

    @Override
    public Topology getTopology() {
        return null;
    }

    @Override
    public int getTopoId() {
        return 0;
    }

    @Override
    public void setOspfAreaId(long l) {
    }

    @Override
    protected boolean inChecking() {
        return true;
    }

    @Override
    public long getOspfAreaId() {
        return -1L;
    }

    @Override
    public void setSla(short s) {
    }

    @Override
    public Integer getSla() {
        return new Integer(0);
    }

    @Override
    public boolean isUsable(RoutePrefs routePrefs, INetLink iNetLink) {
        return true;
    }

    @Override
    protected void setChecking(boolean bl) {
    }

    @Override
    public void newState(int n) {
    }

    @Override
    public void acquireSrcSlotAndPort() {
    }

    @Override
    public void acquireDstSlotAndPort() {
    }

    @Override
    public int getEndProtectionSwitchState(boolean bl) {
        return -1;
    }

    @Override
    protected void initializeDebug() {
        this.db = new AbstractNetLink.AbstractNetLinkDebug(this, "UPSRLoopNL_" + UPSRLoopLink.getDebugName(this.src.getHostName()) + this.dst.getHostName());
        if (this.db.on()) {
            this.db.println("UPSRLoopLink: Creating UPSRLookLink");
        }
    }
}

