/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ConfigError;
import cerent.cms.model.IPmStat;
import cerent.cms.model.InternalCommError;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.UnsupportedOperation;
import cerent.cms.model.WrongInterfaceType;
import cerent.util.SDebug;
import cerent.util.gui.IFixedColumnsTableModel;
import javax.swing.table.AbstractTableModel;

public abstract class AbstractPmTableModel
extends AbstractTableModel
implements IFixedColumnsTableModel {
    public static final int fixedColumns = 1;
    public static final int REFRESH_PANE = -100;
    public static final int PARM_INDEX = 0;
    protected static final int CURRENT_DATA_COLUMN = 1;
    protected String[] columnNames;
    protected int numRegisters;
    protected long[] baseline;
    protected static final SDebug db = new SDebug("PmTableModel");

    public void setColNames(String[] stringArray) {
        this.columnNames = stringArray;
        this.numRegisters = this.columnNames.length - 1;
    }

    public abstract void clearStats() throws NoSuchInterface, WrongInterfaceType, InternalCommError, ConfigError, UnsupportedOperation;

    public Class getColumnClass(int n) {
        if (n == 0) {
            return String.class;
        }
        return IPmStat.class;
    }

    @Override
    public int getColumnCount() {
        return this.numRegisters + 1;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public abstract int getRowCount();

    @Override
    public Object getValueAt(int n, int n2) {
        try {
            Object object = this.getValueAtImpl(n, n2);
            if (1 == n2 && object != null) {
                IPmStat iPmStat;
                long l;
                this.initBaseline();
                if (object instanceof IPmStat && (l = (long)(iPmStat = (IPmStat)object).getCnt()) >= 0L) {
                    long l2 = l - this.baseline[n];
                    if (l2 < 0L) {
                        this.resetBaseline();
                        l2 = l - this.baseline[n];
                    }
                    if (this.baseline[n] > 0L) {
                        object = this.setLongValue(iPmStat, l2);
                    }
                }
            }
            return object;
        }
        catch (InternalCommError internalCommError) {
            if (db.on()) {
                db.println("Caught exception in AbstractPmTableModel.getValueAt(" + n + ", " + n2 + ": " + (Object)((Object)internalCommError));
                SDebug.printStackTrace((Throwable)internalCommError);
            }
        }
        catch (Exception exception) {
            db.println("Caught exception in AbstractPmTableModel.getValueAt(" + n + ", " + n2 + ": " + exception);
            SDebug.printStackTrace((Throwable)exception);
        }
        return null;
    }

    protected abstract Object getValueAtImpl(int var1, int var2) throws NoSuchInterface, WrongInterfaceType, InternalCommError;

    public abstract long getLongValue(Object var1);

    public abstract Object setLongValue(Object var1, long var2);

    public void setBaseline() throws NoSuchInterface, WrongInterfaceType, InternalCommError {
        int n = this.getRowCount();
        this.initBaseline();
        for (int i = 0; i < n; ++i) {
            Object object = this.getValueAtImpl(i, 1);
            if (!(object instanceof IPmStat)) continue;
            IPmStat iPmStat = (IPmStat)object;
            long l = this.getLongValue(this.getValueAtImpl(i, 1));
            this.baseline[i] = l < 0L ? 0L : l;
        }
        this.fireTableDataChanged();
    }

    protected void initBaseline() {
        boolean bl = false;
        int n = this.getRowCount();
        if (this.baseline == null) {
            bl = true;
        } else if (this.baseline.length != n) {
            if (db.on()) {
                db.println("in initBaseline(), baseline.length=" + this.baseline.length + ", but rowCount=" + n + "... setting baseline" + " to rowCount length.");
            }
            bl = true;
        }
        if (bl) {
            this.baseline = new long[n];
        }
    }

    protected void resetBaseline() {
        int n = this.getRowCount();
        this.baseline = new long[n];
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public boolean isRowDirty(int n) {
        return false;
    }

    public void resetDirtyBits() {
    }

    public abstract void setIntervalType(int var1);

    public abstract void destroy();

    public abstract void tossData();

    public int getFixedColumnCount() {
        return 1;
    }
}

