/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.AbstractCmsIOException;
import cerent.cms.model.DetailedConfigError;
import cerent.cms.model.IModel;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractPane;
import cerent.cms.ui.CSHelpButton;
import cerent.cms.ui.Pane;
import cerent.cms.ui.TabbedView;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;

public abstract class AbstractProvPane
extends AbstractPane {
    public static final String APPLY = "Apply";
    public static final String RESET = "Reset";
    public static final String HELP = "Help";
    protected JButton applyButton;
    protected JButton resetButton;
    private CSHelpButton helpButton;
    private boolean isDirty = false;
    protected JPanel buttonPanel = null;
    protected static final SDebug db = new SDebug("AbstractProvPane");

    public AbstractProvPane(String string, TabbedView tabbedView) {
        this(string, tabbedView.getUiModel(), tabbedView);
    }

    public AbstractProvPane(String string, IModel iModel, TabbedView tabbedView) {
        super(string, iModel, tabbedView);
        this.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        if (!this.hasSubTabs()) {
            this.addButtonPanel();
        }
        this.setDefaultPrivilegeLevel(SecurityLevel.PROVISIONING);
    }

    public boolean hasSubTabs() {
        return false;
    }

    protected void addButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonPanel = this.getButtonPanel();
            this.add(this.buttonPanel, "East");
        }
    }

    public void addButton(JButton jButton) {
        this.buttonPanel.add(Box.createVerticalStrut(this.applyButton.getPreferredSize().height / 3));
        this.buttonPanel.add(jButton);
    }

    @Override
    public void enteringPage() throws Exception {
        if (this.isDirty && db.on()) {
            db.println("enteringPage: " + this.getName() + " is dirty");
        }
        if (db.on()) {
            db.println("enteringPage: refreshing " + this.getName());
        }
        this.refresh();
    }

    @Override
    public void leavingPage() throws Exception {
        this.stopTableCellEditing();
        if (this.isDirty) {
            switch (CerentDialog.cancelableQuestionDialog((Component)((Object)this), (String)"Apply changes?", (String)"Changes Not Applied")) {
                case 0: {
                    if (db.on()) {
                        db.println("leavingPage: applying " + this.getName());
                    }
                    this.apply();
                    break;
                }
                case 1: {
                    if (db.on()) {
                        db.println("leavingPage: abandoning changes to " + this.getName());
                    }
                    this.resetDirty();
                    break;
                }
                default: {
                    if (db.on()) {
                        db.println("leavingPage: canceling change from " + this.getName());
                    }
                    throw this.createLeavePageException("Page change canceled by user");
                }
            }
        }
    }

    public final void setDirty() {
        this.setDirty(true);
    }

    public final void resetDirty() {
        this.setDirty(false);
    }

    public final boolean isProvPaneDirty() {
        return this.isDirty;
    }

    public final void setDirty(boolean bl) {
        if (db.on()) {
            db.println("setDirty: " + this.getName() + ": " + this.isDirty + " -> " + bl);
        }
        this.isDirty = bl;
        if (this.applyButton != null) {
            this.applyButton.setEnabled(this.isDirty);
        }
    }

    protected boolean queryRemainDirty() {
        return false;
    }

    private JPanel getButtonPanel() {
        Dimension dimension = new Dimension(75, 25);
        this.applyButton = new JButton(APPLY);
        this.applyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AbstractProvPane.this.apply();
            }
        });
        this.applyButton.setEnabled(false);
        this.applyButton.setMinimumSize(dimension);
        this.applyButton.setMaximumSize(dimension);
        this.resetButton = new JButton(RESET);
        this.resetButton.setMinimumSize(dimension);
        this.resetButton.setMaximumSize(dimension);
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (db.on()) {
                    db.println("class name = " + ((Object)((Object)AbstractProvPane.this)).getClass().getName());
                }
                AbstractProvPane.this.refresh();
            }
        });
        JPanel jPanel = new JPanel(new GridLayout(0, 1, 10, 5));
        jPanel.add(this.applyButton);
        jPanel.add(this.resetButton);
        AbstractButton[] abstractButtonArray = this.getExtraButtons();
        for (int i = 0; i < abstractButtonArray.length; ++i) {
            abstractButtonArray[i].setMinimumSize(dimension);
            abstractButtonArray[i].setMaximumSize(dimension);
            jPanel.add(abstractButtonArray[i]);
        }
        if (this.getHelpID() != null) {
            this.helpButton = new CSHelpButton(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    AbstractProvPane.this.helpButton.launchHelp(AbstractProvPane.this.getHelpID());
                }
            });
            this.helpButton.setMinimumSize(dimension);
            this.helpButton.setMaximumSize(dimension);
            jPanel.add(this.helpButton);
        } else if (db.on()) {
            db.warning("No HelpID returned for " + ((Object)((Object)this)).getClass().getName());
        }
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)jPanel, "North");
        return jPanel2;
    }

    protected AbstractButton[] getExtraButtons() {
        return new JButton[0];
    }

    public boolean onValidate() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void apply() {
        try {
            if (this.isDirty) {
                this.setCursor(3);
                this.stopTableCellEditing();
                if (!this.onValidate()) {
                    return;
                }
                this.applyChangesToModel();
                if (!this.queryRemainDirty()) {
                    this.resetDirty();
                }
            }
            EventBus.instance().notifyEvent((Object)this.getFullName(), (Object)APPLY);
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            if (db.on()) {
                db.fine("Caught " + (Object)((Object)abstractCmsIOException) + " in Pane.apply");
            }
            this.displayErrorDialog(this, (Exception)((Object)abstractCmsIOException), CEMC.EID_FAIL_APPLY_CHANGES);
        }
        catch (ProvisionError provisionError) {
            EID eID = provisionError.getEID();
            if (eID != null) {
                this.displayErrorDialog(this, (Exception)((Object)provisionError), eID);
            } else {
                this.displayErrorDialog(this, (Exception)((Object)provisionError), CEMC.EID_PROVISION_ERROR);
            }
        }
        catch (DetailedConfigError detailedConfigError) {
            if (db.on()) {
                db.fine("Caught " + (Object)((Object)detailedConfigError) + " in Pane.apply");
            }
            ErrorMsg.displayDetailed((Component)((Object)this), CEMC.EID_FAIL_APPLY_CHANGES, detailedConfigError.getMessage());
        }
        catch (Exception exception) {
            this.displayErrorDialog(this, exception, CEMC.EID_FAIL_APPLY_CHANGES);
        }
        finally {
            this.setCursor(0);
        }
    }

    protected void displayErrorDialog(Pane pane, Exception exception, EID eID) {
        ErrorMsg.displayDetailed((Component)((Object)this), eID, exception);
    }

    public void applyChangesToModel() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void refresh() {
        try {
            this.setCursor(3);
            this.cancelTableCellEditing();
            this.refreshFromModel();
            this.resetDirty();
            this.customBehaviour();
        }
        catch (AbstractCmsIOException abstractCmsIOException) {
            SDebug.printStackTrace((Throwable)abstractCmsIOException);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
            ErrorMsg.displayError((Component)((Object)this), (EID)CEMC.EID_FAIL_REFRESH_PANE);
        }
        finally {
            this.setCursor(0);
        }
    }

    public void refreshFromModel() throws Exception {
    }

    public void customBehaviour() {
    }

    protected void setApplyVisible(boolean bl) {
        this.applyButton.setVisible(bl);
    }

    protected void setResetVisible(boolean bl) {
        this.resetButton.setVisible(bl);
    }

    protected void setHelpVisible(boolean bl) {
        this.helpButton.setVisible(bl);
    }

    public void help() {
    }

    protected abstract AbstractLeavePageException createLeavePageException(String var1);

    protected class NumberRangeCellEditor
    extends DefaultCellEditor {
        private int min;
        private int max;
        private EID err;

        public NumberRangeCellEditor(JTextField jTextField, int n, int n2, EID eID) {
            super(jTextField);
            this.min = n;
            this.max = n2;
            this.err = eID;
        }

        @Override
        public boolean stopCellEditing() {
            JTextField jTextField = (JTextField)this.getComponent();
            boolean bl = false;
            try {
                int n = Integer.parseInt(jTextField.getText());
                if (n < this.min || n > this.max) {
                    bl = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                bl = true;
            }
            if (bl) {
                ErrorMsg.displayError((Component)AbstractProvPane.this.getParent(), (EID)this.err);
                return false;
            }
            return super.stopCellEditing();
        }
    }
}

