/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.ExplorerPaneModel;
import cerent.cms.model.ExplorerTreeCard;
import cerent.cms.model.ExplorerTreeNode;
import cerent.cms.model.ExplorerTreeShelf;
import cerent.cms.ui.ExplorerController;
import cerent.cms.ui.ProxyClientDialog;
import cerent.util.ProxyConfigHelper;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.plaf.metal.MetalTreeUI;
import javax.swing.text.Position;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class ExplorerViewPane
extends JPanel
implements TreeExpansionListener,
ActionListener {
    protected DefaultMutableTreeNode rootNode;
    protected ExplorerController controller;
    protected ExplorerPaneModel treeModel;
    public JTree tree;
    private Toolkit toolkit = Toolkit.getDefaultToolkit();
    private String last_val = null;
    public static ExplorerViewPane instance;
    public boolean expand_node = false;
    private JPopupMenu popup = null;
    MouseListener ml = new MouseAdapter(){

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            int n = ExplorerViewPane.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = ExplorerViewPane.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1) {
                if (mouseEvent.isPopupTrigger()) {
                    ExplorerViewPane.this.showPopUp(mouseEvent);
                }
                if (mouseEvent.getClickCount() == 2) {
                    ExplorerViewPane.this.controller.nodeDoubleClicked(n, treePath);
                }
            }
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            int n = ExplorerViewPane.this.tree.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
            TreePath treePath = ExplorerViewPane.this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (n != -1 && mouseEvent.isPopupTrigger()) {
                ExplorerViewPane.this.showPopUp(mouseEvent);
            }
        }
    };

    public ExplorerViewPane() {
        super(new BorderLayout());
        this.rootNode = new DefaultMutableTreeNode("Network Explorer");
        this.treeModel = new ExplorerPaneModel(this.rootNode);
        this.controller = new ExplorerController(this.treeModel);
        this.controller.buildTree();
        this.tree = new JTree(this.treeModel);
        ToolTipManager.sharedInstance().registerComponent(this.tree);
        ExplorerCellRenderer explorerCellRenderer = new ExplorerCellRenderer();
        this.tree.setCellRenderer(explorerCellRenderer);
        this.tree.setEditable(false);
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.setShowsRootHandles(true);
        this.tree.setRowHeight(23);
        JScrollPane jScrollPane = new JScrollPane(this.tree);
        this.add(jScrollPane);
        this.tree.addTreeExpansionListener(this);
        this.tree.addMouseListener(this.ml);
        instance = this;
        this.tree.setUI(new MetalTreeUI(){

            @Override
            protected boolean isToggleEvent(MouseEvent mouseEvent) {
                return false;
            }
        });
    }

    public static ExplorerViewPane getInstance() {
        if (instance == null) {
            instance = new ExplorerViewPane();
        }
        return instance;
    }

    @Override
    public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        this.controller.nodeExpanded(treeExpansionEvent.getPath());
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
        this.controller.nodeCollapsed(treeExpansionEvent.getPath());
    }

    public void initPopUp() {
        this.popup = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Expand All");
        jMenuItem.addActionListener(this);
        this.popup.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Collapse All");
        jMenuItem2.addActionListener(this);
        this.popup.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Search...");
        jMenuItem3.addActionListener(this);
        this.popup.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Client List...");
        jMenuItem4.addActionListener(this);
        this.popup.add(jMenuItem4);
    }

    public void showPopUp(MouseEvent mouseEvent) {
        TreePath treePath;
        if (this.popup == null) {
            this.initPopUp();
        }
        if (this.tree.getRowForPath(treePath = this.tree.getSelectionPath()) == 0) {
            this.popup.getComponent(3).setEnabled(false);
        } else {
            Object object = this.tree.getLastSelectedPathComponent();
            if (object instanceof ExplorerTreeNode) {
                ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)object;
                int n = ProxyConfigHelper.getProxyConfig(explorerTreeNode.getNe());
                if (n == 0 || n == 3) {
                    this.popup.getComponent(3).setEnabled(false);
                } else {
                    this.popup.getComponent(3).setEnabled(true);
                }
            }
        }
        this.popup.show(this.tree, mouseEvent.getX(), mouseEvent.getY());
    }

    public void expandAll(JTree jTree, boolean bl) {
        TreeNode treeNode = (TreeNode)jTree.getModel().getRoot();
        this.expandAll(jTree, new TreePath(treeNode), bl);
    }

    private void expandAll(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreeNode treeNode2 = enumeration.nextElement();
                TreePath treePath2 = treePath.pathByAddingChild(treeNode2);
                this.expandAll(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof JMenuItem) {
            if (actionEvent.getActionCommand().equals("Expand All")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExplorerViewPane.this.expandAll(ExplorerViewPane.this.tree, true);
                    }
                });
            } else if (actionEvent.getActionCommand().equals("Collapse All")) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ExplorerViewPane.this.expandAll(ExplorerViewPane.this.tree, false);
                    }
                });
            } else if (actionEvent.getActionCommand().equals("Search...")) {
                this.searchnode();
            } else if (actionEvent.getActionCommand().equals("Client List...")) {
                this.showClientlist();
            }
        }
    }

    public void showClientlist() {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object != null && object instanceof ExplorerTreeNode) {
            ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)object;
            JFrame jFrame = (JFrame)JOptionPane.getFrameForComponent(this);
            ProxyClientDialog proxyClientDialog = new ProxyClientDialog((Frame)jFrame, explorerTreeNode.getNe().getNodeModel());
            proxyClientDialog.start();
            proxyClientDialog.pack();
            proxyClientDialog.setVisible(true);
        }
    }

    public void searchnode() {
        String string = (String)JOptionPane.showInputDialog(this, "Search Node", "Search", -1, null, null, this.last_val);
        if (string != null) {
            this.searchnode(string);
            this.last_val = string;
        }
    }

    public void searchnode(String string) {
        TreePath treePath = this.tree.getSelectionPath();
        int n = this.tree.getRowForPath(treePath);
        if (n < 0) {
            n = 0;
        }
        try {
            TreePath treePath2 = this.getNextMatch(string, n, Position.Bias.Forward);
            this.tree.setSelectionPath(treePath2);
            this.tree.scrollPathToVisible(treePath2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace(System.out);
        }
    }

    public TreePath getNextMatch(String string, int n, Position.Bias bias) {
        int n2 = this.tree.getRowCount();
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (n < 0 || n >= n2) {
            throw new IllegalArgumentException();
        }
        string = string.toUpperCase();
        int n3 = bias == Position.Bias.Forward ? 1 : -1;
        int n4 = n + 1;
        do {
            TreePath treePath;
            String string2;
            if (!(string2 = this.tree.convertValueToText((treePath = this.tree.getPathForRow(n4)).getLastPathComponent(), this.tree.isRowSelected(n4), this.tree.isExpanded(n4), true, n4, false)).toUpperCase().contains(string)) continue;
            return treePath;
        } while ((n4 = (n4 + n3 + n2) % n2) != n);
        return null;
    }

    class ExplorerCellRenderer
    extends DefaultTreeCellRenderer
    implements TreeCellRenderer {
        DefaultTreeCellRenderer defaultRenderer = new DefaultTreeCellRenderer();
        JLabel Label;
        JPanel renderer;

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            DefaultMutableTreeNode defaultMutableTreeNode;
            JLabel jLabel = (JLabel)super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            if (object != null && object instanceof ExplorerTreeNode) {
                ExplorerTreeNode explorerTreeNode = (ExplorerTreeNode)object;
                jLabel.setIcon(explorerTreeNode.getIcon());
                jLabel.setToolTipText(explorerTreeNode.tooltip);
            } else if (object != null && object instanceof ExplorerTreeCard) {
                ExplorerTreeCard explorerTreeCard = (ExplorerTreeCard)object;
                jLabel.setIcon(explorerTreeCard.getIcon());
            } else if (object != null && object instanceof ExplorerTreeShelf) {
                ExplorerTreeShelf explorerTreeShelf = (ExplorerTreeShelf)object;
                jLabel.setIcon(ExplorerController.SHELF_ICON);
            } else if (object != null && object instanceof DefaultMutableTreeNode && (defaultMutableTreeNode = (DefaultMutableTreeNode)object).isRoot()) {
                jLabel.setIcon(ExplorerController.NETWORK_ICON);
            }
            return jLabel;
        }
    }
}

