/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.util.gui.UFrame;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.LinkedList;

public class ModalFrameUtil {
    public static void showAsModal(final Frame frame, final Frame frame2) {
        final Frame[] frameArray = ModalFrameUtil.getOtherFrames(frame);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent windowEvent) {
                this.disable(frameArray);
            }

            @Override
            public void windowClosed(WindowEvent windowEvent) {
                this.enable(frameArray);
                frame.removeWindowListener(this);
                ModalFrameUtil.toFront(frame2);
            }

            private void disable(Frame[] frameArray2) {
                for (Frame frame3 : frameArray) {
                    frame3.setEnabled(false);
                    if (!(frame3 instanceof UFrame)) continue;
                    ((UFrame)frame3).disableWindowEvents();
                }
            }

            private void enable(Frame[] frameArray2) {
                for (Frame frame3 : frameArray) {
                    frame3.setEnabled(true);
                    if (!(frame3 instanceof UFrame)) continue;
                    ((UFrame)frame3).enableWindowEvents();
                }
            }
        });
        WindowAdapter windowAdapter = new WindowAdapter(){

            @Override
            public void windowIconified(WindowEvent windowEvent) {
                frame.setExtendedState(1);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                if (frame.isShowing()) {
                    ModalFrameUtil.toFront(frame);
                } else {
                    frame2.removeWindowListener(this);
                    frame2.removeWindowStateListener(this);
                }
            }
        };
        frame2.addWindowStateListener(windowAdapter);
        frame2.addWindowListener(windowAdapter);
        frame.setVisible(true);
        try {
            new EventPump(frame).start();
        }
        catch (Throwable throwable) {
            throw new RuntimeException(throwable);
        }
    }

    private static Frame[] getOtherFrames(Frame frame) {
        Frame[] frameArray = Frame.getFrames();
        LinkedList<Frame> linkedList = new LinkedList<Frame>(Arrays.asList(frameArray));
        linkedList.remove(frame);
        return linkedList.toArray(new Frame[0]);
    }

    private static void toFront(Frame frame) {
        int n = frame.getExtendedState();
        frame.setExtendedState(n &= 0xFE);
        frame.toFront();
    }

    static class EventPump
    implements InvocationHandler {
        private static final String CONDITIONAL_CLASS = "java.awt.Conditional";
        private static final String EVENT_DISP_THREAD_CLASS = "java.awt.EventDispatchThread";
        private static final String PUMP_EVENTS_METHOD = "pumpEvents";
        Frame frame;

        public EventPump(Frame frame) {
            this.frame = frame;
        }

        @Override
        public Object invoke(Object object, Method method, Object[] objectArray) throws Throwable {
            return this.frame.isShowing() ? Boolean.TRUE : Boolean.FALSE;
        }

        public void start() throws Exception {
            Class<?> clazz = Class.forName(CONDITIONAL_CLASS);
            Object object = Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)this);
            Method method = Class.forName(EVENT_DISP_THREAD_CLASS).getDeclaredMethod(PUMP_EVENTS_METHOD, clazz);
            method.setAccessible(true);
            method.invoke((Object)Thread.currentThread(), object);
        }
    }
}

