/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Attribute;
import cerent.cms.model.AttributeMaps;
import cerent.cms.model.Feature;
import cerent.cms.model.INetProtectionType;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetAdminState;
import cerent.cms.model.NetProtectionType;
import cerent.cms.model.NetServiceState;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.SecurityLevel;
import cerent.cms.ncp.INetCircuitState;
import cerent.util.EnumStrings;
import cerent.util.SONETTDMTerminology;
import cerent.util.TDMTerminology;
import java.util.TreeMap;

public abstract class NetworkDefaults {
    public static final String DECLARE_VT_SD_BERLEVEL_STRING = "declareVTSdBerLevel";
    public static final String DECLARE_SD_BERLEVEL_STRING = "declareSdBerLevel";
    public static final String DECLARE_SF_BERLEVEL_STRING = "declareSfBerLevel";
    public static final String PROTECTION_OP_STRING = "protectionOp";
    public static final String PROTECTION_OP_STRING_APS_CLEAR = "protectionOpApsClear";
    public static final String SONET_EQTYPE_STRING = "SONET";
    public static final String ETHERGROUP_STRING = "Ethergroup";
    public static final String CIRCUIT_SIZE_STRING = "circuitSize";
    public static final String CIRCUIT_TYPE_STRING = "circuitType";
    public static final String CIRCUIT_PROTECTION_TYPE_STRING = "circuitProtectionType";
    public static final String CIRCUIT_DIRECTION_STRING = "circuitDirection";
    public static final String CIRCUIT_STATE_STRING = "circuitState";
    public static final String BLSR_OP_STRING_2F_MIN = "blsrOp.2F.min";
    public static final String BLSR_OP_STRING_2F_FULL = "blsrOp.2F.full";
    public static final String BLSR_OP_STRING_4F_MIN = "blsrOp.4F.min";
    public static final String BLSR_OP_STRING_4F_FULL = "blsrOp.4F.full";
    public static final String BLSR_OP_STRING_2F_MAN_RING_MIN = "blsrOp.2F.manRing.min";
    public static final String BLSR_OP_STRING_2F_EXER_RING_MIN = "blsrOp.2F.exerRing.min";
    public static final String BLSR_OP_STRING_2F_FORCE_RING_FULL = "blsrOp.2F.forceRing.full";
    public static final String BLSR_OP_STRING_2F_MAN_RING_FULL = "blsrOp.2F.manRing.full";
    public static final String BLSR_OP_STRING_2F_EXER_RING_FULL = "blsrOp.2F.exerRing.full";
    public static final String BLSR_OP_STRING_2F_LOCK_FULL = "blsrOp.2F.lock.full";
    public static final String BLSR_OP_STRING_4F_MAN_SPAN_MIN = "blsrOp.4F.manSpan.min";
    public static final String BLSR_OP_STRING_4F_MAN_RING_MIN = "blsrOp.4F.manRing.min";
    public static final String BLSR_OP_STRING_4F_EXER_SPAN_MIN = "blsrOp.4F.exerSpan.min";
    public static final String BLSR_OP_STRING_4F_EXER_RING_MIN = "blsrOp.4F.exerRing.min";
    public static final String BLSR_OP_STRING_4F_FORCE_SPAN_FULL = "blsrOp.4F.forceSpan.full";
    public static final String BLSR_OP_STRING_4F_FORCE_RING_FULL = "blsrOp.4F.forceRing.full";
    public static final String BLSR_OP_STRING_4F_MAN_SPAN_FULL = "blsrOp.4F.manSpan.full";
    public static final String BLSR_OP_STRING_4F_MAN_RING_FULL = "blsrOp.4F.manRing.full";
    public static final String BLSR_OP_STRING_4F_EXER_SPAN_FULL = "blsrOp.4F.exerSpan.full";
    public static final String BLSR_OP_STRING_4F_EXER_RING_FULL = "blsrOp.4F.exerRing.full";
    public static final String BLSR_OP_STRING_4F_LOCK_FULL = "blsrOp.4F.lock.full";
    public static final String BLSR_OP_STRING_CLEAR = "blsrOp.clear";
    public static final String PRBS_GENERATOR_STRING = "PRBS Generator";
    public static final String SPAN_PROTECTION_OP_STRING = "spanProtectionOp";
    private static String UPSR_TERM = "";
    private static String BLSR_TERM = "";
    public static final int MAX_CKT_NAME_LEN = 48;
    public static final String MONITOR_CKT_SUFFIX = "_MON";
    private static AttributeMaps attributeMap;
    private static AttributeMaps tempAttributeMap;
    private static String[] prefixArr;

    public static AttributeMaps getAttributeMap(boolean bl) {
        boolean bl2 = true;
        if (attributeMap == null || bl) {
            bl2 = NetworkDefaults.initializeAttributeMaps();
        }
        return bl2 ? attributeMap : tempAttributeMap;
    }

    public static AttributeMaps getAttributeMap() {
        return NetworkDefaults.getAttributeMap(false);
    }

    public static synchronized boolean initializeAttributeMaps() {
        attributeMap = null;
        tempAttributeMap = new AttributeMaps();
        NetworkDefaults.initializeSonet();
        boolean bl = NetworkDefaults.initializeCircuits();
        NetworkDefaults.initializeBlsr();
        if (bl) {
            attributeMap = tempAttributeMap;
        }
        return bl;
    }

    private static boolean initializeCircuits() {
        boolean bl = true;
        TDMTerminology tDMTerminology = null;
        try {
            tDMTerminology = NetworkModel.instance().getTDMTerminology();
        }
        catch (Exception exception) {
            tDMTerminology = SONETTDMTerminology.instance();
            bl = false;
        }
        String string = CIRCUIT_PROTECTION_TYPE_STRING;
        TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
        INetProtectionType[] iNetProtectionTypeArray = NetProtectionType.getAllNetProtectionTypes();
        for (int i = 0; i < iNetProtectionTypeArray.length; ++i) {
            INetProtectionType iNetProtectionType = iNetProtectionTypeArray[i];
            treeMap.put(new Integer(iNetProtectionType.getEnum()), new Attribute(iNetProtectionType.getNetProtectionTypeString(tDMTerminology), iNetProtectionType.getEnum()));
        }
        tempAttributeMap.put(string, treeMap);
        string = CIRCUIT_DIRECTION_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(0), new Attribute("1-way", 0));
        treeMap.put(new Integer(1), new Attribute("2-way", 1));
        tempAttributeMap.put(string, treeMap);
        string = CIRCUIT_STATE_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(1), new Attribute("DISCOVERED", 1));
        treeMap.put(new Integer(0), new Attribute("CREATING", 0));
        treeMap.put(new Integer(2), new Attribute("DELETING", 2));
        treeMap.put(new Integer(3), new Attribute("DROP_PENDING", 3));
        treeMap.put(new Integer(7), new Attribute("ERRORED", 7));
        treeMap.put(new Integer(4), new Attribute("PARTIAL", 4));
        treeMap.put(new Integer(6), new Attribute("PARTIAL_TL1", 6));
        treeMap.put(new Integer(5), new Attribute("DISCOVERED_TL1", 5));
        treeMap.put(new Integer(8), new Attribute("ROLL_PENDING", 8));
        treeMap.put(new Integer(11), new Attribute("CONVERSION_PENDING", 11));
        tempAttributeMap.put(string, treeMap);
        return bl;
    }

    private static void initializeSonet() {
        String string = DECLARE_VT_SD_BERLEVEL_STRING;
        TreeMap<Integer, Attribute> treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(5), new Attribute("1E-5", 5));
        treeMap.put(new Integer(6), new Attribute("1E-6", 6));
        treeMap.put(new Integer(7), new Attribute("1E-7", 7));
        treeMap.put(new Integer(8), new Attribute("1E-8", 8));
        tempAttributeMap.put(string, treeMap);
        string = DECLARE_SD_BERLEVEL_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(5), new Attribute("1E-5", 5));
        treeMap.put(new Integer(6), new Attribute("1E-6", 6));
        treeMap.put(new Integer(7), new Attribute("1E-7", 7));
        treeMap.put(new Integer(8), new Attribute("1E-8", 8));
        treeMap.put(new Integer(9), new Attribute("1E-9", 9));
        tempAttributeMap.put(string, treeMap);
        string = DECLARE_SF_BERLEVEL_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(3), new Attribute("1E-3", 3));
        treeMap.put(new Integer(4), new Attribute("1E-4", 4));
        treeMap.put(new Integer(5), new Attribute("1E-5", 5));
        tempAttributeMap.put(string, treeMap);
        string = PROTECTION_OP_STRING;
        treeMap = new TreeMap();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        treeMap.put(new Integer(1), new Attribute("LOCKOUT OF PROTECT", 1));
        treeMap.put(new Integer(2), new Attribute("LOCKOUT OF WORKING", 2));
        treeMap.put(new Integer(4), new Attribute("FORCE TO PROTECT", 4));
        treeMap.put(new Integer(3), new Attribute("FORCE TO WORKING", 3));
        treeMap.put(new Integer(6), new Attribute("MANUAL TO PROTECT", 6));
        treeMap.put(new Integer(5), new Attribute("MANUAL TO WORKING", 5));
        tempAttributeMap.put(string, treeMap);
        string = PROTECTION_OP_STRING_APS_CLEAR;
        treeMap = (TreeMap<Integer, Attribute>)treeMap.clone();
        treeMap.put(new Integer(8), new Attribute("APS_CLEAR", 8));
        tempAttributeMap.put(string, treeMap);
        string = SPAN_PROTECTION_OP_STRING;
        treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        treeMap.put(new Integer(1), new Attribute("MANUAL", 1));
        treeMap.put(new Integer(3), new Attribute("FORCE", 3));
        treeMap.put(new Integer(4), new Attribute("LOCKOUT_OF_PROTECTION", 4));
        tempAttributeMap.put(string, treeMap);
    }

    public static String spanProtectionOPToString(int n) {
        switch (n) {
            case 0: {
                return "CLEAR";
            }
            case 1: {
                return "MANUAL";
            }
            case 3: {
                return "FORCE";
            }
            case 4: {
                return "LOCKOUT_OF_PROTECTION";
            }
        }
        return "Unknown";
    }

    public static String securityLevelToString(int n) {
        switch (n) {
            case 2: {
                return "Provision";
            }
            case 1: {
                return "Maintenance";
            }
            case 0: {
                return "Retrieve";
            }
            case 3: {
                return "Superuser";
            }
        }
        return "Unknown";
    }

    public static String securityLevelToString(SecurityLevel securityLevel) {
        return NetworkDefaults.securityLevelToString(securityLevel.value());
    }

    public static String circuitDirectionToString(int n) {
        if (n == -1) {
            return "";
        }
        return n == 0 ? "1-way" : "2-way";
    }

    public static String circuitStateToString(int n) {
        Attribute attribute;
        TreeMap treeMap = (TreeMap)NetworkDefaults.getAttributeMap().get(CIRCUIT_STATE_STRING);
        if (treeMap != null && (attribute = (Attribute)treeMap.get(new Integer(n))) != null) {
            return attribute.getKey();
        }
        return EnumStrings.getString(INetCircuitState.class, (int)n);
    }

    public static String circuitProtTypeToString(int n, TDMTerminology tDMTerminology) {
        INetProtectionType iNetProtectionType = NetProtectionType.getNetProtectionType(n);
        return iNetProtectionType == null ? "" : iNetProtectionType.getNetProtectionTypeString(tDMTerminology);
    }

    private static void initializeBlsr() {
        TreeMap<Integer, Attribute> treeMap;
        String string = BLSR_OP_STRING_2F_LOCK_FULL;
        TreeMap<Integer, Attribute> treeMap2 = treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_FORCE_RING_FULL;
        TreeMap<Integer, Attribute> treeMap3 = treeMap = (TreeMap<Integer, Attribute>)treeMap2.clone();
        treeMap.put(new Integer(1), new Attribute("LOCKOUT PROTECT SPAN", 1));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_MAN_RING_FULL;
        TreeMap<Integer, Attribute> treeMap4 = treeMap = (TreeMap)treeMap3.clone();
        treeMap.put(new Integer(3), new Attribute("FORCE RING", 3));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_EXER_RING_FULL;
        TreeMap<Integer, Attribute> treeMap5 = treeMap = (TreeMap)treeMap4.clone();
        treeMap.put(new Integer(5), new Attribute("MANUAL RING", 5));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_FULL;
        TreeMap<Integer, Attribute> treeMap6 = treeMap = (TreeMap)treeMap5.clone();
        treeMap.put(new Integer(7), new Attribute("EXERCISE RING", 7));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_MAN_RING_MIN;
        TreeMap<Integer, Attribute> treeMap7 = treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_EXER_RING_MIN;
        TreeMap<Integer, Attribute> treeMap8 = treeMap = (TreeMap<Integer, Attribute>)treeMap7.clone();
        treeMap.put(new Integer(5), new Attribute("MANUAL RING", 5));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_2F_MIN;
        TreeMap<Integer, Attribute> treeMap9 = treeMap = (TreeMap)treeMap8.clone();
        treeMap.put(new Integer(7), new Attribute("EXERCISE RING", 7));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_LOCK_FULL;
        TreeMap<Integer, Attribute> treeMap10 = treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_FORCE_SPAN_FULL;
        TreeMap<Integer, Attribute> treeMap11 = treeMap = (TreeMap<Integer, Attribute>)treeMap10.clone();
        treeMap.put(new Integer(1), new Attribute("LOCKOUT PROTECT SPAN", 1));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_FORCE_RING_FULL;
        TreeMap<Integer, Attribute> treeMap12 = treeMap = (TreeMap)treeMap11.clone();
        treeMap.put(new Integer(2), new Attribute("FORCE SPAN", 2));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_MAN_SPAN_FULL;
        TreeMap<Integer, Attribute> treeMap13 = treeMap = (TreeMap)treeMap12.clone();
        treeMap.put(new Integer(3), new Attribute("FORCE RING", 3));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_MAN_RING_FULL;
        TreeMap<Integer, Attribute> treeMap14 = treeMap = (TreeMap)treeMap13.clone();
        treeMap.put(new Integer(4), new Attribute("MANUAL SPAN", 4));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_EXER_SPAN_FULL;
        TreeMap<Integer, Attribute> treeMap15 = treeMap = (TreeMap)treeMap14.clone();
        treeMap.put(new Integer(5), new Attribute("MANUAL RING", 5));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_EXER_RING_FULL;
        TreeMap<Integer, Attribute> treeMap16 = treeMap = (TreeMap)treeMap15.clone();
        treeMap.put(new Integer(6), new Attribute("EXERCISE SPAN", 6));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_FULL;
        TreeMap<Integer, Attribute> treeMap17 = treeMap = (TreeMap)treeMap16.clone();
        treeMap.put(new Integer(7), new Attribute("EXERCISE RING", 7));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_MAN_SPAN_MIN;
        TreeMap<Integer, Attribute> treeMap18 = treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_MAN_RING_MIN;
        TreeMap<Integer, Attribute> treeMap19 = treeMap = (TreeMap<Integer, Attribute>)treeMap18.clone();
        treeMap.put(new Integer(4), new Attribute("MANUAL SPAN", 4));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_EXER_SPAN_MIN;
        TreeMap<Integer, Attribute> treeMap20 = treeMap = (TreeMap)treeMap19.clone();
        treeMap.put(new Integer(5), new Attribute("MANUAL RING", 5));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_EXER_RING_MIN;
        TreeMap<Integer, Attribute> treeMap21 = treeMap = (TreeMap)treeMap20.clone();
        treeMap.put(new Integer(6), new Attribute("EXERCISE SPAN", 6));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_4F_MIN;
        TreeMap<Integer, Attribute> treeMap22 = treeMap = (TreeMap)treeMap21.clone();
        treeMap.put(new Integer(7), new Attribute("EXERCISE RING", 7));
        tempAttributeMap.put(string, treeMap);
        string = BLSR_OP_STRING_CLEAR;
        treeMap = new TreeMap<Integer, Attribute>();
        treeMap.put(new Integer(0), new Attribute("CLEAR", 0));
        tempAttributeMap.put(string, treeMap);
    }

    public static String circuitAdminStateToString(int n) {
        return NetAdminState.getAdminStateStringFromAdminState(n);
    }

    public static String circuitServiceStateToString(int n) {
        return NetServiceState.getPrimaryStateStringFromServiceState(n);
    }

    public static TDMTerminology getCmsHostTDMTerms() {
        INodeModel iNodeModel = NetworkModel.instance().getCmsHostModel().getNodeModel();
        Object object = Feature.provides((INodeModel)iNodeModel, (Feature)Feature.FTG) ? iNodeModel.getTDMTerminology() : (iNodeModel != null ? iNodeModel.getTDMTerminology() : SONETTDMTerminology.instance());
        return object;
    }

    static {
        prefixArr = new String[]{"VT", "STS-"};
    }
}

