/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NetworkModel;
import cerent.cms.model.event.NetworkAlarmStore;
import cerent.cms.model.event.NetworkEventStore;
import cerent.cms.topo.INetElement;
import cerent.cms.topo.Network;
import cerent.cms.ui.AbstractInvalidViewException;
import cerent.cms.ui.AbstractLeavePageException;
import cerent.cms.ui.AbstractViewController;
import cerent.cms.ui.DefaultViewControllerLayout;
import cerent.cms.ui.DomainViewController;
import cerent.cms.ui.ExplorerController;
import cerent.cms.ui.ExplorerViewPane;
import cerent.cms.ui.FunctionalViewButton;
import cerent.cms.ui.IUiToolkit;
import cerent.cms.ui.IViewController;
import cerent.cms.ui.IVitalStatsPane;
import cerent.cms.ui.InvalidViewException;
import cerent.cms.ui.MainPanel;
import cerent.cms.ui.TabbedView;
import cerent.cms.ui.ViewName;
import cerent.cms.ui.XMLgenerate;
import cerent.cms.ui.event.EventPanelController;
import cerent.cms.ui.network.MapPersist;
import cerent.cms.ui.network.NetworkMap;
import cerent.cms.ui.network.NetworkTabbedView;
import cerent.cms.ui.network.NetworkVitalStatsPane;
import cerent.util.BusEvent;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.EventBus;
import cerent.util.IDebugDiag;
import cerent.util.KDebug;
import cerent.util.NEMC;
import cerent.util.Preferences;
import cerent.util.SDebug;
import cerent.util.WID;
import cerent.util.gui.CerentDialog;
import cerent.util.gui.UFrame;
import cerent.util.gui.WindowHelper;
import com.cisco.ctc.CtcApplication;
import com.cisco.ctc.util.map.MapDomain;
import com.cisco.fv.gui.FunctionalNetworkDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.TreeSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToolBar;

public class NetworkViewController
extends AbstractViewController
implements ActionListener,
Observer {
    private FunctionalViewButton fvButton;
    private static final String SELECTED_ICON = "/images/icons/arrowdown16.gif";
    private static final String BACK_ICON = "/images/icons/arrowleft16.gif";
    private static final String FORWARD_ICON = "/images/icons/arrowright16.gif";
    private static final String PARENT_ICON = "/images/icons/arrowup16.gif";
    private static final String NETWORK_ICON = "/images/icons/network16.gif";
    private static final String HOME_ICON = "/images/icons/home16.gif";
    private static final String OTHER_ICON = "/images/icons/misc/16x16-Optical_blue.gif";
    private static final String REFRESH_ICON = "/images/icons/reload16.gif";
    private static final String XML_ICON = "/images/icons/reload16.gif";
    private static final Dimension TB_DIM = new Dimension(25, 25);
    private static final Insets TB_MARGIN = new Insets(2, 2, 2, 2);
    private static final String ACTION_BACK = "Go To Previous View";
    private static final String ACTION_FORWARD = "Go To Next View";
    private static final String ACTION_NETWORK = "Go To Network View";
    private static final String ACTION_PARENT = "Go To Parent View";
    private static final String ACTION_HOME = "Go To Home View";
    private static final String ACTION_SELECTED = "Go To Selected Object View";
    private static final String ACTION_OTHER = "Go To Other Node...";
    private static final String FUNCTIONAL_VIEW = "Dwdm Functional View";
    private static final String ACTION_SHOW_SB = "Show Status Bar";
    private static final String ACTION_SHOW_TB = "Show Tool Bar";
    private static final String ACTION_SHOW_EXP = "Show Network Explorer";
    private static final String ACTION_CREATE_XML = "Export XML";
    private static JMenuItem homeMenuItem;
    private static JMenuItem parentMenuItem;
    private static JMenuItem networkMenuItem;
    private static JMenuItem backMenuItem;
    private static JMenuItem forwardMenuItem;
    private static JMenuItem selectedMenuItem;
    private static JMenuItem otherMenuItem;
    private static JMenuItem fvMenuItem;
    private static final JCheckBoxMenuItem cbToolBarMenuItem;
    private static final JCheckBoxMenuItem cbStatusBarMenuItem;
    private static final JCheckBoxMenuItem cbExpMenuItem;
    private JButton parentButton;
    private JButton homeButton;
    private JButton backButton;
    private JButton forwardButton;
    private JButton selectedButton;
    private JButton previousButton;
    private JButton networkButton;
    private JButton otherButton;
    private JButton XMLButton;
    private NetworkMap nmap = null;
    private NetworkTabbedView ntv = null;
    private NetworkVitalStatsPane nvsp = null;
    private ExplorerViewPane tree = null;
    private DefaultViewControllerLayout dvcl = null;
    private ViewName homeView = null;
    private JToolBar toolbar = null;
    private long nodeChangedTime = 0L;
    private HashMap domainMap = new HashMap();
    private static NetworkViewController instance;
    private boolean logoutNotified = false;
    private static final SDebug db;
    private static StringBuffer ddBuffer;

    protected NetworkViewController(IUiToolkit iUiToolkit) {
        super(iUiToolkit, (KDebug)db);
        if (db.on()) {
            db.println("<init>");
        }
        if (instance != null) {
            throw new RuntimeException("Multiple NetworkViewControllers instantiated!");
        }
        instance = this;
        EventBus.instance().addObserver((Observer)this, (Object)"ACTIVE_OBJECT");
        this.nodeConnectionStateChanged(NetworkModel.instance().getCmsHostModel(), true);
    }

    public static NetworkViewController instance() {
        return instance;
    }

    public synchronized IVitalStatsPane getVitalStatsPane() {
        db.fine("getVitalStatsPane");
        if (this.nvsp == null) {
            this.nvsp = new NetworkVitalStatsPane();
            this.nvsp.setPreferredSize(NetworkVitalStatsPane.NETWORK_VITALSTATS_DIM);
            this.nvsp.setMinimumSize(NetworkVitalStatsPane.NETWORK_VITALSTATS_MIN_DIM);
        }
        return this.nvsp;
    }

    public synchronized NetworkMap getNetworkMap() {
        db.fine("getNetworkMap");
        if (this.nmap == null) {
            this.nmap = new NetworkMap(this);
        }
        return this.nmap;
    }

    public synchronized ExplorerViewPane getExplorerViewPane() {
        db.fine("getExplorerViewPane");
        this.tree = (ExplorerViewPane)this.uiToolkit.getGuestPane(13);
        return this.tree;
    }

    public TabbedView getTabbedView() {
        db.fine("getTabbedView");
        if (this.ntv == null) {
            this.ntv = new NetworkTabbedView(NetworkAlarmStore.instance(), NetworkEventStore.instance(), new EventPanelController(this));
            this.ntv.setPreferredSize(TabbedView.TABBED_VIEW_DIM);
            this.ntv.setMinimumSize(TabbedView.TABBED_VIEW_MIN_DIM);
        }
        return this.ntv;
    }

    public void nodeConnectionStateChanged(INodeModel iNodeModel, boolean bl) {
        if (db.on()) {
            db.println("nodeConnectionStateChanged for node " + Integer.toHexString(iNodeModel.getNodeId()) + " to " + (bl ? "connected" : "disconnected"));
        }
        this.nodeChangedTime = System.currentTimeMillis();
    }

    public AbstractViewController createChildContainerVC(ViewName viewName) throws AbstractInvalidViewException {
        IViewController iViewController;
        INodeModel iNodeModel;
        int n = viewName.getNodeId();
        if (n == 0) {
            this.throwInvalidViewException("Invalid node ID:" + viewName);
        }
        if ((iNodeModel = this.getNodeModel(n)) == null) {
            this.throwInvalidViewException("NodeModel null for:" + viewName);
        }
        if (!iNodeModel.isInited()) {
            this.throwInvalidViewException("Node is not ready yet:" + viewName);
        }
        if ((iViewController = ElementFactoryFinder.getElementFactory(iNodeModel).createSVC((IViewController)this, iNodeModel, this.uiToolkit)) instanceof AbstractViewController) {
            return (AbstractViewController)iViewController;
        }
        this.throwInvalidViewException("Creating SVC for " + viewName + " returned " + iViewController);
        return null;
    }

    public long getConnectionStatusChangeTime() {
        return this.nodeChangedTime;
    }

    public INodeModel getNodeModel(int n) {
        INetElement iNetElement = Network.instance().findNetElem(n);
        if (iNetElement != null) {
            return iNetElement.getNodeModel();
        }
        return null;
    }

    protected String getUserFriendlyViewName(ViewName viewName) {
        String string = super.getUserFriendlyViewName(viewName);
        int n = viewName.getNodeId();
        INodeModel iNodeModel = this.getNodeModel(n);
        if (iNodeModel != null) {
            int n2 = viewName.getSlotId();
            string = n2 > 0 ? "the card view at slot #" + n2 + " of node " + iNodeModel.getName() : "the shelf view of node " + iNodeModel.getName();
        }
        return string;
    }

    public synchronized void removeDomain(MapDomain mapDomain) {
        if (db.on()) {
            db.println("removeDomain( " + mapDomain.getName() + " )");
        }
        DomainViewController domainViewController = (DomainViewController)((Object)this.domainMap.get(mapDomain.getName()));
        this.pruneHistory(domainViewController.getViewName());
        this.removeChild((IViewController)domainViewController);
        this.domainMap.remove(mapDomain.getName());
        if (currentView != null && currentView.equals(domainViewController.getViewName())) {
            try {
                this.jumpView(ViewName.ROOT_VIEW, false);
            }
            catch (AbstractLeavePageException abstractLeavePageException) {
                SDebug.printStackTrace((Throwable)abstractLeavePageException);
            }
            catch (AbstractInvalidViewException abstractInvalidViewException) {
                SDebug.printStackTrace((Throwable)abstractInvalidViewException);
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
        this.syncButtons(this.getCurrentView());
    }

    public synchronized void createDomain(MapDomain mapDomain) {
        if (db.on()) {
            db.println("createDomain( " + mapDomain.getName() + " )");
        }
        DomainViewController domainViewController = new DomainViewController((IViewController)this, mapDomain, this.uiToolkit);
        this.domainMap.put(mapDomain.getName(), domainViewController);
        this.addChild((IViewController)domainViewController);
    }

    public synchronized void domainNameChange(MapDomain mapDomain, String string, String string2) {
        if (db.on()) {
            db.println("domainNameChanged( " + mapDomain.getName() + " )");
        }
        DomainViewController domainViewController = (DomainViewController)((Object)this.domainMap.get(string));
        this.domainMap.remove(string);
        this.domainMap.put(mapDomain.getName(), domainViewController);
        domainViewController.nameChanged(string2);
    }

    protected void cache(ViewName viewName, ViewName viewName2) {
        if (db.on()) {
            db.println("cache curView is " + viewName + " newView is " + viewName2);
        }
        if (!viewName.isRootView()) {
            try {
                this.flushViewPanel(viewName);
            }
            catch (AbstractInvalidViewException abstractInvalidViewException) {
                db.finer("AbstractInvalidViewException in cache(), viewName=" + viewName + ", newView= " + viewName2);
            }
        }
    }

    protected ViewName localGetSelectedView(ViewName viewName) {
        if (db.on()) {
            db.println("localGetSelectedView destView is " + viewName);
        }
        if (this.nmap != null) {
            return this.nmap.getSelectedView();
        }
        return null;
    }

    protected void localUpdateViewPanel(ViewName viewName) throws AbstractInvalidViewException, AbstractLeavePageException {
        if (db.on()) {
            db.println("localUpdateViewPanel destView is " + viewName);
        }
        if (this.nmap != null) {
            this.dvcl.setComponents(this.nmap.getGraphWindow(), (JComponent)((Object)this.ntv), (JComponent)((Object)this.nvsp), this.tree);
        }
        if (viewName.getTabId() != 0 && !this.ntv.changeTab(viewName.getTabId())) {
            throw new InvalidViewException("View=" + viewName, 6);
        }
    }

    protected void localDispose() {
        this.localDestroy();
    }

    protected void localDestroy() {
        if (db.on()) {
            db.println("localDestroy");
        }
        if (this.ntv != null) {
            this.ntv.destroy();
            this.ntv = null;
        }
        if (this.nmap != null) {
            this.nmap.dispose();
            this.nmap = null;
        }
        if (this.nvsp != null) {
            this.nvsp.dispose();
            this.nvsp = null;
        }
        instance = null;
    }

    protected void localEnterView(ViewName viewName) {
        if (db.on()) {
            db.println("localEnterView destView is " + viewName);
        }
        if (Network.instance().isActive()) {
            this.setTitleLabel(null);
            this.getNetworkMap().setVisible(true);
            this.getNetworkMap().domainDisplayed(null);
            try {
                this.ntv.setShowing(true);
            }
            catch (Exception exception) {
                db.finer("Exception in localEnterView(), dView = " + viewName + " " + exception);
            }
            this.dvcl.updateSplitPanes();
        } else {
            db.severe("ERROR: Attempt to transition to Network view while Network is being destroyed!");
        }
        this.fvButton = FunctionalViewButton.getInstance();
        if (this.fvButton != null) {
            this.fvButton.initFvButton((ActionListener)this);
            if (!this.fvButton.isVisible()) {
                this.fvButton.setVisible(true);
            }
        }
    }

    protected void localExitView(ViewName viewName, ViewName viewName2) throws AbstractLeavePageException {
        INetElement iNetElement;
        if (db.on()) {
            db.println("localExitView srcView is " + viewName + " destView is " + viewName2);
        }
        if (this.dvcl != null) {
            this.dvcl.dispose();
        }
        try {
            this.nmap.setVisible(false);
            this.ntv.setShowing(false);
        }
        catch (AbstractLeavePageException abstractLeavePageException) {
            throw abstractLeavePageException;
        }
        catch (Exception exception) {
            db.finest("Exception in localExitView(), src= " + viewName + " ,dst=" + viewName2 + " " + exception);
        }
        this.fvButton = FunctionalViewButton.getInstance();
        if (this.fvButton != null && viewName2 != null && viewName2.getNodeId() != 0 && (iNetElement = Network.instance().findNetElem(viewName2.getNodeId())) != null) {
            this.fvButton.setVisible(false);
            if (iNetElement.getNodeModel().getDelegate().provides(Feature.NETWORK_FUNCTIONAL_VIEW) || iNetElement.getNodeModel().getDelegate().getSwVersion().contains("09.00")) {
                this.fvButton.setVisible(true);
            }
        }
    }

    protected JPanel createPanel(ViewName viewName) throws AbstractInvalidViewException {
        db.fine("createPanel destView is " + viewName);
        JPanel jPanel = new JPanel();
        try {
            if (Network.instance().isActive()) {
                this.dvcl = new DefaultViewControllerLayout(jPanel);
                this.getVitalStatsPane();
                this.getTabbedView();
                this.getNetworkMap();
                this.getExplorerViewPane();
                this.dvcl.setComponents(this.nmap.getGraphWindow(), (JComponent)((Object)this.ntv), (JComponent)((Object)this.nvsp), this.tree);
                db.fine("createPanel successful, returning " + jPanel);
            }
        }
        catch (Exception exception) {
            SDebug.printStackTrace((Throwable)exception);
        }
        return jPanel;
    }

    protected void throwInvalidViewException(String string) throws AbstractInvalidViewException {
        throw new InvalidViewException(string, 1);
    }

    public JMenu createViewsMenu(boolean bl, boolean bl2, boolean bl3) {
        JMenu jMenu = new JMenu("View");
        jMenu.setMnemonic(86);
        backMenuItem = this.addMenu(jMenu, BACK_ICON, ACTION_BACK, 66);
        forwardMenuItem = this.addMenu(jMenu, FORWARD_ICON, ACTION_FORWARD, 70);
        parentMenuItem = this.addMenu(jMenu, PARENT_ICON, ACTION_PARENT, 85);
        selectedMenuItem = this.addMenu(jMenu, SELECTED_ICON, ACTION_SELECTED, 83);
        homeMenuItem = this.addMenu(jMenu, HOME_ICON, ACTION_HOME, 72);
        networkMenuItem = this.addMenu(jMenu, NETWORK_ICON, ACTION_NETWORK, 78);
        otherMenuItem = this.addMenu(jMenu, OTHER_ICON, ACTION_OTHER, 79);
        jMenu.addSeparator();
        cbExpMenuItem.addActionListener(this);
        cbExpMenuItem.setActionCommand(ACTION_SHOW_EXP);
        jMenu.add(cbExpMenuItem);
        cbExpMenuItem.setSelected(bl3);
        cbStatusBarMenuItem.addActionListener(this);
        cbStatusBarMenuItem.setActionCommand(ACTION_SHOW_SB);
        jMenu.add(cbStatusBarMenuItem);
        cbStatusBarMenuItem.setSelected(bl);
        cbToolBarMenuItem.addActionListener(this);
        cbToolBarMenuItem.setActionCommand(ACTION_SHOW_TB);
        jMenu.add(cbToolBarMenuItem);
        cbToolBarMenuItem.setSelected(bl2);
        return jMenu;
    }

    private JMenuItem addMenu(JMenu jMenu, String string, String string2, int n) {
        JMenuItem jMenuItem = new JMenuItem(string2, n);
        if (string != null) {
            jMenuItem.setIcon(new ImageIcon(this.getClass().getResource(string)));
        }
        jMenuItem.addActionListener(this);
        jMenuItem.setActionCommand(string2);
        jMenu.add(jMenuItem);
        return jMenuItem;
    }

    public void initToolbar(JToolBar jToolBar) {
        this.toolbar = jToolBar;
        this.backButton = this.addToolbar(this, BACK_ICON, ACTION_BACK);
        this.forwardButton = this.addToolbar(this, FORWARD_ICON, ACTION_FORWARD);
        this.parentButton = this.addToolbar(this, PARENT_ICON, ACTION_PARENT);
        this.selectedButton = this.addToolbar(this, SELECTED_ICON, ACTION_SELECTED);
        this.homeButton = this.addToolbar(this, HOME_ICON, ACTION_HOME);
        this.networkButton = this.addToolbar(this, NETWORK_ICON, ACTION_NETWORK);
        this.otherButton = this.addToolbar(this, OTHER_ICON, ACTION_OTHER);
        this.XMLButton = this.addToolbar(this, "/images/icons/reload16.gif", ACTION_CREATE_XML);
        this.XMLButton.setVisible(Preferences.instance().getBoolean("ctc", "xml_export", false));
    }

    public JButton addToolbar(ActionListener actionListener, String string, String string2) {
        return this.addToolbar(actionListener, string, string2, null);
    }

    public JButton addToolbar(ActionListener actionListener, String string, String string2, Object object) {
        JButton jButton = new JButton(new ImageIcon(this.getClass().getResource(string)));
        jButton.addActionListener(actionListener);
        jButton.setToolTipText(string2);
        jButton.setMargin(TB_MARGIN);
        jButton.setMinimumSize(TB_DIM);
        jButton.setMaximumSize(TB_DIM);
        jButton.setActionCommand(string2);
        this.toolbar.add((Component)jButton, object);
        return jButton;
    }

    public JToolBar getToolBar() {
        return this.toolbar;
    }

    private void syncButtons(ViewName viewName) {
        boolean bl;
        if (db.on()) {
            db.println("syncButtons newView is " + viewName);
        }
        boolean bl2 = bl = !viewName.isRootView();
        boolean bl3 = this.homeView == null ? false : !this.homeView.equals(viewName);
        boolean bl4 = !viewName.isCardView();
        parentMenuItem.setEnabled(bl);
        networkMenuItem.setEnabled(bl);
        backMenuItem.setEnabled(this.hasBackView());
        forwardMenuItem.setEnabled(this.hasForwardView());
        homeMenuItem.setEnabled(bl3);
        this.backButton.setEnabled(this.hasBackView());
        this.forwardButton.setEnabled(this.hasForwardView());
        this.networkButton.setEnabled(bl);
        this.parentButton.setEnabled(bl);
        this.homeButton.setEnabled(bl3);
        cbExpMenuItem.setEnabled(!bl);
        if (!bl && this.nmap != null) {
            this.nmap.updateToolbar();
        }
        if (db.on()) {
            db.println("Sync: dst=" + viewName + " notRoot=" + bl + " notHome=" + bl3);
        }
    }

    public void setHomeView(ViewName viewName) {
        this.homeView = viewName;
    }

    protected void setNewView(ViewName viewName) {
        super.setNewView(viewName);
        this.syncButtons(viewName);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals(ACTION_NETWORK)) {
            if (db.on()) {
                db.println("Attempting to switch to network view");
            }
            this.tryJumpView(ViewName.ROOT_VIEW);
        } else if (string.equals(ACTION_HOME)) {
            if (db.on()) {
                db.println("Attempting to switch to home view");
            }
            this.tryJumpView(this.homeView);
        } else if (string.equals(ACTION_PARENT)) {
            if (db.on()) {
                db.println("Attempting to switch to parent view");
            }
            for (ViewName viewName = this.findParentView(currentView); viewName != null; viewName = viewName.getParentView()) {
                try {
                    this.jumpView(viewName, true);
                    break;
                }
                catch (AbstractLeavePageException abstractLeavePageException) {
                    break;
                }
                catch (Exception exception) {
                    SDebug.printStackTrace((Throwable)exception);
                    continue;
                }
            }
        } else if (string.equals(ACTION_BACK)) {
            ViewName viewName = this.getBackView();
            if (db.on()) {
                db.println("Attempting to switch to go back a view: " + viewName);
            }
            if (viewName != null) {
                this.tryJumpView(viewName);
                if (!viewName.equals(this.getCurrentView())) {
                    this.getForwardView();
                }
            }
        } else if (string.equals(ACTION_FORWARD)) {
            ViewName viewName = this.getForwardView();
            if (db.on()) {
                db.println("Attempting to switch to go forward a view: " + viewName);
            }
            if (viewName != null) {
                this.tryJumpView(viewName);
                if (!viewName.equals(this.getCurrentView())) {
                    this.getBackView();
                }
            }
        } else if (string.equals(ACTION_SELECTED)) {
            if (db.on()) {
                db.println("Attempting to switch to open selected object.");
            }
            this.openSelectedObject();
        } else if (string.equals(ACTION_OTHER)) {
            this.showOtherShelfChooser();
        } else if (string.equals(ACTION_SHOW_TB)) {
            this.uiToolkit.showToolBar(cbToolBarMenuItem.getState());
        } else if (string.equals(ACTION_SHOW_SB)) {
            this.uiToolkit.showStatusBar(cbStatusBarMenuItem.getState());
        } else if (string.equals(ACTION_SHOW_EXP)) {
            boolean bl = cbExpMenuItem.getState();
            this.showExplorer(bl);
        } else if (string.equals("Functional View")) {
            FunctionalNetworkDialog functionalNetworkDialog = FunctionalNetworkDialog.instance(this.getUiToolkit(), this);
            functionalNetworkDialog.setVisible(true);
            functionalNetworkDialog.fitGraphView();
        } else if (string.equals(ACTION_CREATE_XML)) {
            XMLgenerate xMLgenerate = new XMLgenerate();
            xMLgenerate.generateXML();
        }
    }

    private void showExplorer(boolean bl) {
        Preferences preferences = Preferences.instance();
        String string = "ctc";
        String string2 = "explorer";
        ExplorerViewPane explorerViewPane = this.getExplorerViewPane();
        ExplorerController explorerController = explorerViewPane.controller;
        if (bl) {
            preferences.setProperty(string, string2, "true");
            explorerController.buildTree();
            this.dvcl.updateSplitPanes();
        } else {
            preferences.setProperty(string, string2, "false");
            explorerViewPane.expandAll(this.tree.tree, false);
            explorerController.collapseTree();
            this.dvcl.updateSplitPanes();
        }
    }

    private void openSelectedObject() {
        if (currentView != null) {
            try {
                ViewName viewName = this.getSelectedView(currentView);
                if (db.on()) {
                    db.println("openSelectedObject, dest is " + viewName);
                }
                if (viewName != null) {
                    this.tryJumpView(viewName);
                }
            }
            catch (Exception exception) {
                SDebug.printStackTrace((Throwable)exception);
            }
        }
    }

    private void showOtherShelfChooser() {
        Object object = CerentDialog.inputDialog((Component)this.getFrame(), (String)"Select Node to Go to", (String)"Select Node", (Object[])this.getNodeNames(), (Object)this.getSelectedNodeName());
        if (object == null || !(object instanceof String)) {
            return;
        }
        INodeModel iNodeModel = this.getNodeModel((String)object);
        this.nodeConnectionStateChanged(iNodeModel, iNodeModel.getConnectionState());
        if (iNodeModel.isInited() && iNodeModel.getConnectionState()) {
            if (!iNodeModel.isManageable()) {
                CerentDialog.warningDialog((Component)this.getFrame(), (String)ErrorMsg.getString((EID)CEMC.WID_NO_NODE_MANAGEMENT_PARAM_1, (Object)iNodeModel.getName()));
            } else {
                try {
                    this.nfvButtonInvisible(iNodeModel.getDelegate());
                    this.jumpView(new ViewName(iNodeModel.getNodeId()), true);
                }
                catch (Exception exception) {
                    ErrorMsg.displayError((Component)this.uiToolkit.getApplicationFrame(), (EID)NEMC.EID_UNABLE_TO_SWITCH_TO_NODE_PARAM_1, (Object)iNodeModel.getName());
                }
            }
        } else {
            ErrorMsg.displayWarning(null, (WID)NEMC.WID_NODE_NOT_INITIALIZED_PARAM_1, (Object)iNodeModel.getName());
        }
    }

    private int getHistCursor() {
        return histCursor;
    }

    private List getHistory() {
        return history;
    }

    public String[] getNodeNames() {
        TreeSet<String> treeSet = new TreeSet<String>();
        for (INetElement iNetElement : Network.instance().getElements()) {
            treeSet.add(iNetElement.getNodeModel().getName());
        }
        return treeSet.toArray(new String[0]);
    }

    public INodeModel getNodeModel(String string) {
        if (string == null) {
            return null;
        }
        for (INetElement iNetElement : Network.instance().getElements()) {
            if (!string.equals(iNetElement.getNodeModel().getName())) continue;
            return iNetElement.getNodeModel();
        }
        return null;
    }

    public String getNodeName(int n) {
        for (INetElement iNetElement : Network.instance().getElements()) {
            if (n != iNetElement.getNodeModel().getNodeId()) continue;
            return iNetElement.getNodeModel().getName();
        }
        return null;
    }

    public ViewName findParentView(ViewName viewName) {
        String string;
        INodeModel iNodeModel;
        ViewName viewName2 = viewName.getParentView();
        if (viewName2 != null && viewName2.isRootView() && (iNodeModel = Network.instance().getNodeModel(viewName.getNodeId())) != null && iNodeModel.isInited() && (string = MapPersist.getNodeDomain(iNodeModel)).length() > 0) {
            viewName2 = new ViewName(string);
        }
        return viewName2;
    }

    public String getSelectedNodeName() {
        int n = currentView.getNodeId();
        if (0 == n) {
            try {
                ViewName viewName = this.getSelectedView(currentView);
                if (null != viewName) {
                    n = viewName.getNodeId();
                }
            }
            catch (AbstractInvalidViewException abstractInvalidViewException) {
                db.finer("AbstractInvalidViewException in getSelectedNodeName() " + (Object)((Object)abstractInvalidViewException));
            }
        }
        return this.getNodeName(n);
    }

    public DomainViewController nodeToDomain(MapDomain mapDomain) {
        return (DomainViewController)((Object)this.domainMap.get(mapDomain.getName()));
    }

    private void exitCTC() {
        if (!this.logoutNotified) {
            this.logoutNotified = true;
            String string = "You were logged out because the time allotted\nfor your session expired or an administrator\nlogged you out.\n\nClick OK to exit CTC.";
            MainPanel mainPanel = CtcApplication.instance().getMainPanel();
            if (UFrame.isWindowsPlatform()) {
                mainPanel.setMinimizeStateForAll();
            } else {
                mainPanel.setVisibleStateForAll(false);
            }
            CerentDialog.infoDialog(null, (String)string, (String)"Logged out");
            CtcApplication.instance().exitCtc(false);
        }
    }

    public void tryJumpView(ViewName viewName) {
        INetElement iNetElement;
        if (db.on()) {
            db.println("tryJumpView destView is " + viewName);
        }
        if (viewName.getNodeId() != 0 && (iNetElement = Network.instance().findNetElem(viewName.getNodeId())) != null) {
            this.nfvButtonInvisible(iNetElement.getNodeModel().getDelegate());
            if (!iNetElement.getNodeModel().isManageable()) {
                CerentDialog.warningDialog((Component)this.getFrame(), (String)ErrorMsg.getString((EID)CEMC.WID_NO_NODE_MANAGEMENT_PARAM_1, (Object)iNetElement.getName()));
                return;
            }
        }
        super.tryJumpView(viewName);
    }

    @Override
    public void update(Observable observable, Object object) {
        BusEvent busEvent;
        if (object instanceof BusEvent && (busEvent = (BusEvent)object).getSource() == "ACTIVE_OBJECT") {
            JComponent[] jComponentArray = new JComponent[]{selectedMenuItem, this.selectedButton};
            if (busEvent.getEvent() != null) {
                WindowHelper.setEnabled((JComponent[])jComponentArray, (boolean)true);
            } else {
                WindowHelper.setEnabled((JComponent[])jComponentArray, (boolean)false);
            }
        }
    }

    private void nfvButtonInvisible(INodeModel iNodeModel) {
        if (!iNodeModel.provides(Feature.NETWORK_FUNCTIONAL_VIEW) && iNodeModel.getSwVersion().contains("08.51")) {
            this.fvButton.setVisible(false);
        }
    }

    static {
        cbToolBarMenuItem = new JCheckBoxMenuItem(ACTION_SHOW_TB);
        cbStatusBarMenuItem = new JCheckBoxMenuItem(ACTION_SHOW_SB);
        cbExpMenuItem = new JCheckBoxMenuItem(ACTION_SHOW_EXP);
        instance = null;
        db = new RvcDebug();
        ddBuffer = null;
    }

    public static class RvcDebug
    extends SDebug
    implements IDebugDiag {
        public RvcDebug() {
            super("RVC");
        }

        public final void back() {
            ViewName viewName;
            ViewName viewName2 = instance.getCurrentView();
            if (viewName2 != null && (viewName = instance.getBackView()) != null) {
                instance.tryJumpView(viewName);
            }
        }

        public final void forward() {
            ViewName viewName;
            ViewName viewName2 = instance.getCurrentView();
            if (viewName2 != null && (viewName = instance.getForwardView()) != null) {
                instance.tryJumpView(viewName);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final void dumpHistory() {
            if (instance != null) {
                NetworkViewController networkViewController = instance;
                synchronized (networkViewController) {
                    Iterator iterator = instance.getHistory().iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        ViewName viewName = (ViewName)iterator.next();
                        if (instance.getHistCursor() == n) {
                            this.print("-->");
                        }
                        this.println("[" + n + "] " + viewName.toString());
                        ++n;
                    }
                }
            }
        }

        public final void destroy() {
            this.println("destroying " + instance.viewName);
            instance.destroy();
        }

        public final void dumpDiag() {
            this.dumpMapping();
            this.dumpHistory();
            this.dumpHierarchy();
            if (ddBuffer != null) {
                this.println("");
                this.println(ddBuffer.toString());
            }
        }

        public final void dumpHierarchy() {
            instance.dumpHierarchy(this, null);
        }

        public final void dumpMapping() {
            for (INetElement iNetElement : Network.instance().getElements()) {
                INodeModel iNodeModel = iNetElement.getNodeModel();
                this.println("nodeId=" + Integer.toHexString(iNodeModel.getNodeId()) + "\t" + iNodeModel.getName());
            }
        }

        public final void printCurTabs() {
            String[][] stringArray = instance.getCurTabHierarchy();
            if (stringArray.length == 0) {
                this.println("zero length tab hierarchy retrieved");
            } else {
                for (int i = 0; i < stringArray.length; ++i) {
                    for (int j = 0; j < stringArray[i].length; ++j) {
                        this.print("/" + stringArray[i][j]);
                    }
                    this.println(" ");
                }
            }
        }
    }
}

