/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.model.Feature;
import cerent.cms.model.INodeModel;
import cerent.cms.topo.Network;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.util.TreeMap;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.ListCellRenderer;

class PCliNodeSelDialog {
    private static final String QUESTION_ICON_STR = "/images/icons/question32.gif";
    private static final ImageIcon QUESTION_ICON = new ImageIcon(PCliNodeSelDialog.class.getResource("/images/icons/question32.gif"));
    private Frame parent;
    private JComboBox nodeCB;
    private INodeModel nodeModel;
    private boolean ok = false;
    public static final SDebug db = new SDebug("PCliNodeSelDialog");

    public PCliNodeSelDialog(Frame frame, INodeModel iNodeModel) {
        this.parent = frame;
        Object[][] objectArray = this.getItemData();
        if (objectArray == null) {
            ErrorMsg.displayError((Component)frame, (EID)NEMC.EID_UNABLE_LOCATE_PCLI_NODE);
            return;
        }
        this.nodeCB = new JComboBox((E[])objectArray);
        this.nodeCB.setRenderer(new NodeSlotRenderer());
        this.setPreferredNode(iNodeModel);
        this.show();
    }

    private void setPreferredNode(INodeModel iNodeModel) {
        if (iNodeModel == null) {
            return;
        }
        for (int i = 0; i < this.nodeCB.getItemCount(); ++i) {
            Object[] objectArray = (Object[])this.nodeCB.getItemAt(i);
            if (objectArray == null || objectArray[1] != iNodeModel) continue;
            this.nodeCB.setSelectedIndex(i);
            break;
        }
    }

    private void show() {
        Object[] objectArray = new Object[]{new JLabel("Select a Node for the Pseudo IOS Connection"), this.nodeCB};
        JOptionPane jOptionPane = new JOptionPane(objectArray, 3, 2, QUESTION_ICON);
        JDialog jDialog = jOptionPane.createDialog(this.parent, "Select Node");
        jDialog.show();
        if (jOptionPane.getValue() != null && (Integer)jOptionPane.getValue() == 0) {
            Object[] objectArray2 = (Object[])this.nodeCB.getSelectedItem();
            if (objectArray2 != null) {
                this.nodeModel = (INodeModel)objectArray2[1];
            }
            this.ok = true;
        }
    }

    public boolean isOk() {
        return this.ok;
    }

    public INodeModel getNodeModel() {
        return this.nodeModel;
    }

    private Object[][] getItemData() {
        Object[] objectArray;
        Object[][] objectArray22;
        TreeMap<String, Object[]> treeMap = new TreeMap<String, Object[]>();
        for (Object[][] objectArray22 : Network.instance().getElements()) {
            objectArray = objectArray22.getNodeModel();
            if (!objectArray.isInited() || !Feature.provides((INodeModel)objectArray, (Feature)Feature.PSEUDO_CLI)) continue;
            treeMap.put(objectArray.getName(), objectArray);
        }
        if (treeMap.size() == 0) {
            return null;
        }
        objectArray22 = new Object[treeMap.size()][2];
        objectArray = treeMap.keySet().toArray();
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray22[i][0] = objectArray[i];
            objectArray22[i][1] = treeMap.get(objectArray[i]);
        }
        return objectArray22;
    }

    class NodeSlotRenderer
    extends JLabel
    implements ListCellRenderer {
        public NodeSlotRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            Object[] objectArray = (Object[])object;
            try {
                this.setText(((String)objectArray[0]).toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.setBackground(bl ? jList.getSelectionBackground() : Color.white);
            this.setForeground(bl ? Color.white : Color.black);
            return this;
        }
    }
}

