/*
 * Decompiled with CFR 0.152.
 */
package cerent.cms.ui;

import cerent.cms.loader.ElementFactoryFinder;
import cerent.cms.model.CmsNodeUpgradingException;
import cerent.cms.model.DuplicateLocalVlinkId;
import cerent.cms.model.DuplicateRemoteVlinkId;
import cerent.cms.model.EndPointInUse;
import cerent.cms.model.Feature;
import cerent.cms.model.FeatureUnsupported;
import cerent.cms.model.IEntityModel;
import cerent.cms.model.INodeModel;
import cerent.cms.model.NoSuchInterface;
import cerent.cms.model.ProvisionError;
import cerent.cms.model.WrongInterfaceType;
import cerent.cms.ui.VirtualLinkPane;
import cerent.cms.ui.WzDiagDebug;
import cerent.cms.ui.WzDialog;
import cerent.cms.ui.ppc.PPCCreateOperator;
import cerent.cms.ui.ppc.PPCCreationInfo;
import cerent.cms.ui.ppc.PPCRollbackFailed;
import cerent.cms.ui.ppc.PPCcdAttrsPane;
import cerent.cms.ui.ppc.PPCcdDestinationPane;
import cerent.cms.ui.ppc.PPCcdIDsPane;
import cerent.cms.ui.ppc.PPCcdSourcePane;
import cerent.util.AnnotatedException;
import cerent.util.CEMC;
import cerent.util.EID;
import cerent.util.ErrorMsg;
import cerent.util.NEMC;
import cerent.util.SDebug;
import cerent.util.gui.CerentDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class PPCLinkCreationDialog
extends WzDialog {
    private static final String TITLE = "PPC Creation";
    public static final int VIGN_WIDTH = 200;
    public static final String WZPANE_PPC_ATTRS = "PPC Attributes";
    public static final String WZPANE_PPC_SRC = "PPC Origination";
    public static final String WZPANE_PPC_DST = "PPC Termination";
    public static final String WZPANE_PPC_PROT_SRC = "PPC Protect Origination";
    public static final String WZPANE_PPC_PROT_DST = "PPC Protect Termination";
    public static final String WZPANE_PPC_IDS = "PPC IDs";
    private PPCCreationInfo info;
    private PPCCreateOperator operator;
    private boolean sanityCheckPassed;

    public static PPCLinkCreationDialog instance(VirtualLinkPane virtualLinkPane, INodeModel iNodeModel) {
        Frame frame = JOptionPane.getFrameForComponent((Component)((Object)virtualLinkPane));
        return new PPCLinkCreationDialog(frame, TITLE, iNodeModel);
    }

    public PPCLinkCreationDialog(Frame frame, String string, INodeModel iNodeModel) {
        super(frame, string, new WzDiagDebug("PPCLinkCreationDialog"), true, true);
        int n = 700;
        int n2 = 450;
        this.setSize(new Dimension(n, n2));
        this.createPanesAndSetCurrent();
        this.setLocationRelativeTo(frame);
        this.info = new PPCCreationInfo();
        this.operator = new PPCCreateOperator(this, this.info);
        if (iNodeModel != null) {
            this.info.setSrcNode(iNodeModel);
        }
    }

    @Override
    protected void createPanesAndSetCurrent() {
        this.wzPaneMap.put(WZPANE_PPC_ATTRS, new PPCcdAttrsPane(this, this.db, WZPANE_PPC_ATTRS));
        this.wzPaneMap.put(WZPANE_PPC_SRC, new PPCcdSourcePane(this, this.db, WZPANE_PPC_SRC));
        this.wzPaneMap.put(WZPANE_PPC_DST, new PPCcdDestinationPane(this, this.db, WZPANE_PPC_DST));
        this.wzPaneMap.put(WZPANE_PPC_PROT_SRC, new PPCcdSourcePane(this, this.db, WZPANE_PPC_PROT_SRC, true));
        this.wzPaneMap.put(WZPANE_PPC_PROT_DST, new PPCcdDestinationPane(this, this.db, WZPANE_PPC_PROT_DST, true));
        this.wzPaneMap.put(WZPANE_PPC_IDS, new PPCcdIDsPane(this, this.db, WZPANE_PPC_IDS));
        this.setCurrentPane(WZPANE_PPC_ATTRS);
    }

    @Override
    protected void apply() throws Exception {
        this.sanityCheckPassed = false;
        if (this.db.on()) {
            this.db.println("calling operator.sanityCheck");
        }
        this.operator.sanityCheck();
        this.sanityCheckPassed = true;
        if (this.db.on()) {
            this.db.println("calling operator.createLinks");
        }
        this.operator.createLinks();
    }

    @Override
    public boolean handleFinishException(Exception exception) {
        String string = exception.getMessage();
        if (exception instanceof AnnotatedException) {
            exception = ((AnnotatedException)((Object)exception)).getChild();
        }
        if (this.db.on()) {
            this.db.println("handleFinishException - Got exception: " + exception.getMessage());
            SDebug.printStackTrace((Throwable)exception);
        }
        if (this.sanityCheckPassed) {
            try {
                this.operator.rollback();
            }
            catch (PPCRollbackFailed pPCRollbackFailed) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_VIRTUAL_LINK_DELETE_FAILED, pPCRollbackFailed.getMessage());
            }
            if (exception instanceof NoSuchInterface) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_NO_SUCHINTERFACE, exception.getMessage() + ". The endpoint " + PPCLinkCreationDialog.toString(this.operator.getCurrentPort()) + " cannot be found on the node " + this.operator.getCurrentNode().getName() + ".");
            } else if (exception instanceof WrongInterfaceType) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_WRONG_INTERFACE_TYPE, exception.getMessage() + ". The endpoint " + PPCLinkCreationDialog.toString(this.operator.getCurrentPort()) + " on the node " + this.operator.getCurrentNode().getName() + " is not of the correct type.");
            } else if (exception instanceof ProvisionError) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_PROVISION_ERROR, exception.getMessage() + ". A patchcord cannot be " + "provisioned on the endpoint " + PPCLinkCreationDialog.toString(this.operator.getCurrentPort()) + " on the node " + this.operator.getCurrentNode().getName() + ".");
            } else if (exception instanceof EndPointInUse) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_END_POINT_INUSE, exception.getMessage() + ". The endpoint " + PPCLinkCreationDialog.toString(this.operator.getCurrentPort()) + " on the node " + this.operator.getCurrentNode().getName() + " is already in use.");
            } else if (exception instanceof FeatureUnsupported) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_UNSUPPORTED_OPERATION, exception.getMessage() + ". The node " + this.operator.getCurrentNode().getName() + " does not support provisionable patchcords.");
            } else if (exception instanceof UnknownHostException) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_UNABLE_TO_LOCATE_HOST, exception.getMessage() + ". The node " + this.operator.getCurrentNode().getName() + " does not exist.");
            } else if (exception instanceof DuplicateLocalVlinkId) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_DUP_LOCAL_VLINK_ID, exception.getMessage() + ". The patchcord identifier, " + Integer.toString(this.operator.getCurrentSrcID()) + ", is already in use on the node " + this.operator.getCurrentNode().getName() + ".");
            } else if (exception instanceof DuplicateRemoteVlinkId) {
                ErrorMsg.displayDetailed((Component)this, NEMC.EID_DUP_REMOTE_VLINK_ID, exception.getMessage() + ". The patchcord identifier, " + Integer.toString(this.operator.getCurrentDstID()) + ", is already in use on the node " + this.operator.getCurrentNode().getName() + ".");
            } else if (exception instanceof CmsNodeUpgradingException) {
                ErrorMsg.displayError((Component)this, (EID)CEMC.EID_NODE_UPGRADING_EXCEPTION);
            } else {
                CerentDialog.errorDialog((Component)this, (String)string, (String)"Error");
            }
            return true;
        }
        return super.handleFinishException(exception);
    }

    public void setFinishEnabled(boolean bl) {
        this.setButtonsEnabled(!bl, bl);
        if (this.finishButton.isEnabled()) {
            this.finishButton.requestFocus();
        }
    }

    public void setNextEnabled(boolean bl) {
        this.setButtonsEnabled(bl, !bl);
    }

    public PPCCreationInfo getInfo() {
        return this.info;
    }

    private static String toString(IEntityModel iEntityModel) {
        INodeModel iNodeModel = iEntityModel.getNodeModel();
        return ElementFactoryFinder.getElementFactory(iNodeModel).createEntityCellRenderer(iEntityModel.getModuleModel()).getString((Object)iEntityModel, iNodeModel.provides(Feature.MULTISHELF) && iNodeModel.isMultishelf() ? "shelf " : "slot ");
    }
}

